/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.Location;
import com.sun.tools.jdi.ArrayReferenceImpl;
import com.sun.tools.jdi.ArrayTypeImpl;
import com.sun.tools.jdi.ClassLoaderReferenceImpl;
import com.sun.tools.jdi.ClassObjectReferenceImpl;
import com.sun.tools.jdi.ClassTypeImpl;
import com.sun.tools.jdi.InterfaceTypeImpl;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.ObjectReferenceImpl;
import com.sun.tools.jdi.PacketStream;
import com.sun.tools.jdi.ReferenceTypeImpl;
import com.sun.tools.jdi.StringReferenceImpl;
import com.sun.tools.jdi.ThreadGroupReferenceImpl;
import com.sun.tools.jdi.ThreadReferenceImpl;
import com.sun.tools.jdi.ValueImpl;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.util.List;

class JDWP {
    JDWP() {
    }

    static class InvokeOptions {
        static final int INVOKE_SINGLE_THREADED = 1;
        static final int INVOKE_NONVIRTUAL = 2;

        InvokeOptions() {
        }
    }

    static class SuspendPolicy {
        static final int NONE = 0;
        static final int EVENT_THREAD = 1;
        static final int ALL = 2;

        SuspendPolicy() {
        }
    }

    static class StepSize {
        static final int MIN = 0;
        static final int LINE = 1;

        StepSize() {
        }
    }

    static class StepDepth {
        static final int INTO = 0;
        static final int OVER = 1;
        static final int OUT = 2;

        StepDepth() {
        }
    }

    static class Tag {
        static final int ARRAY = 91;
        static final int BYTE = 66;
        static final int CHAR = 67;
        static final int OBJECT = 76;
        static final int FLOAT = 70;
        static final int DOUBLE = 68;
        static final int INT = 73;
        static final int LONG = 74;
        static final int SHORT = 83;
        static final int VOID = 86;
        static final int BOOLEAN = 90;
        static final int STRING = 115;
        static final int THREAD = 116;
        static final int THREAD_GROUP = 103;
        static final int CLASS_LOADER = 108;
        static final int CLASS_OBJECT = 99;

        Tag() {
        }
    }

    static class TypeTag {
        static final int CLASS = 1;
        static final int INTERFACE = 2;
        static final int ARRAY = 3;

        TypeTag() {
        }
    }

    static class ClassStatus {
        static final int VERIFIED = 1;
        static final int PREPARED = 2;
        static final int INITIALIZED = 4;
        static final int ERROR = 8;

        ClassStatus() {
        }
    }

    static class SuspendStatus {
        static final int SUSPEND_STATUS_SUSPENDED = 1;

        SuspendStatus() {
        }
    }

    static class ThreadStatus {
        static final int ZOMBIE = 0;
        static final int RUNNING = 1;
        static final int SLEEPING = 2;
        static final int MONITOR = 3;
        static final int WAIT = 4;

        ThreadStatus() {
        }
    }

    static class EventKind {
        static final int VM_DISCONNECTED = 100;
        static final int VM_START = 90;
        static final int THREAD_DEATH = 7;
        static final int SINGLE_STEP = 1;
        static final int BREAKPOINT = 2;
        static final int FRAME_POP = 3;
        static final int EXCEPTION = 4;
        static final int USER_DEFINED = 5;
        static final int THREAD_START = 6;
        static final int THREAD_END = 7;
        static final int CLASS_PREPARE = 8;
        static final int CLASS_UNLOAD = 9;
        static final int CLASS_LOAD = 10;
        static final int FIELD_ACCESS = 20;
        static final int FIELD_MODIFICATION = 21;
        static final int EXCEPTION_CATCH = 30;
        static final int METHOD_ENTRY = 40;
        static final int METHOD_EXIT = 41;
        static final int VM_INIT = 90;
        static final int VM_DEATH = 99;

        EventKind() {
        }
    }

    static class Error {
        static final int NONE = 0;
        static final int INVALID_THREAD = 10;
        static final int INVALID_THREAD_GROUP = 11;
        static final int INVALID_PRIORITY = 12;
        static final int THREAD_NOT_SUSPENDED = 13;
        static final int THREAD_SUSPENDED = 14;
        static final int INVALID_OBJECT = 20;
        static final int INVALID_CLASS = 21;
        static final int CLASS_NOT_PREPARED = 22;
        static final int INVALID_METHODID = 23;
        static final int INVALID_LOCATION = 24;
        static final int INVALID_FIELDID = 25;
        static final int INVALID_FRAMEID = 30;
        static final int NO_MORE_FRAMES = 31;
        static final int OPAQUE_FRAME = 32;
        static final int NOT_CURRENT_FRAME = 33;
        static final int TYPE_MISMATCH = 34;
        static final int INVALID_SLOT = 35;
        static final int DUPLICATE = 40;
        static final int NOT_FOUND = 41;
        static final int INVALID_MONITOR = 50;
        static final int NOT_MONITOR_OWNER = 51;
        static final int INTERRUPT = 52;
        static final int INVALID_CLASS_FORMAT = 60;
        static final int CIRCULAR_CLASS_DEFINITION = 61;
        static final int FAILS_VERIFICATION = 62;
        static final int ADD_METHOD_NOT_IMPLEMENTED = 63;
        static final int SCHEMA_CHANGE_NOT_IMPLEMENTED = 64;
        static final int INVALID_TYPESTATE = 65;
        static final int HIERARCHY_CHANGE_NOT_IMPLEMENTED = 66;
        static final int DELETE_METHOD_NOT_IMPLEMENTED = 67;
        static final int UNSUPPORTED_VERSION = 68;
        static final int NAMES_DONT_MATCH = 69;
        static final int CLASS_MODIFIERS_CHANGE_NOT_IMPLEMENTED = 70;
        static final int METHOD_MODIFIERS_CHANGE_NOT_IMPLEMENTED = 71;
        static final int NOT_IMPLEMENTED = 99;
        static final int NULL_POINTER = 100;
        static final int ABSENT_INFORMATION = 101;
        static final int INVALID_EVENT_TYPE = 102;
        static final int ILLEGAL_ARGUMENT = 103;
        static final int OUT_OF_MEMORY = 110;
        static final int ACCESS_DENIED = 111;
        static final int VM_DEAD = 112;
        static final int INTERNAL = 113;
        static final int UNATTACHED_THREAD = 115;
        static final int INVALID_TAG = 500;
        static final int ALREADY_INVOKING = 502;
        static final int INVALID_INDEX = 503;
        static final int INVALID_LENGTH = 504;
        static final int INVALID_STRING = 506;
        static final int INVALID_CLASS_LOADER = 507;
        static final int INVALID_ARRAY = 508;
        static final int TRANSPORT_LOAD = 509;
        static final int TRANSPORT_INIT = 510;
        static final int NATIVE_METHOD = 511;
        static final int INVALID_COUNT = 512;

        Error() {
        }
    }

    static class Event {
        static final int COMMAND_SET = 64;

        private Event() {
        }

        static class Composite {
            static final int COMMAND = 100;
            final byte suspendPolicy;
            final Events[] events;

            Composite(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.Event.Composite" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.suspendPolicy = packetStream.readByte();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "suspendPolicy(byte): " + this.suspendPolicy);
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "events(Events[]): ");
                }
                int n = packetStream.readInt();
                this.events = new Events[n];
                for (int i = 0; i < n; ++i) {
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "events[" + i + "](Events): " + "");
                    }
                    this.events[i] = new Events(virtualMachineImpl, packetStream);
                }
            }

            static class Events {
                final byte eventKind;
                EventsCommon aEventsCommon;

                Events(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                    this.eventKind = packetStream.readByte();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "eventKind(byte): " + this.eventKind);
                    }
                    switch (this.eventKind) {
                        case 90: {
                            this.aEventsCommon = new VMStart(virtualMachineImpl, packetStream);
                            break;
                        }
                        case 1: {
                            this.aEventsCommon = new SingleStep(virtualMachineImpl, packetStream);
                            break;
                        }
                        case 2: {
                            this.aEventsCommon = new Breakpoint(virtualMachineImpl, packetStream);
                            break;
                        }
                        case 40: {
                            this.aEventsCommon = new MethodEntry(virtualMachineImpl, packetStream);
                            break;
                        }
                        case 41: {
                            this.aEventsCommon = new MethodExit(virtualMachineImpl, packetStream);
                            break;
                        }
                        case 4: {
                            this.aEventsCommon = new Exception(virtualMachineImpl, packetStream);
                            break;
                        }
                        case 6: {
                            this.aEventsCommon = new ThreadStart(virtualMachineImpl, packetStream);
                            break;
                        }
                        case 7: {
                            this.aEventsCommon = new ThreadDeath(virtualMachineImpl, packetStream);
                            break;
                        }
                        case 8: {
                            this.aEventsCommon = new ClassPrepare(virtualMachineImpl, packetStream);
                            break;
                        }
                        case 9: {
                            this.aEventsCommon = new ClassUnload(virtualMachineImpl, packetStream);
                            break;
                        }
                        case 20: {
                            this.aEventsCommon = new FieldAccess(virtualMachineImpl, packetStream);
                            break;
                        }
                        case 21: {
                            this.aEventsCommon = new FieldModification(virtualMachineImpl, packetStream);
                            break;
                        }
                        case 99: {
                            this.aEventsCommon = new VMDeath(virtualMachineImpl, packetStream);
                        }
                    }
                }

                static class VMDeath
                extends EventsCommon {
                    static final byte ALT_ID = 99;
                    final int requestID;

                    byte eventKind() {
                        return 99;
                    }

                    VMDeath(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                        this.requestID = packetStream.readInt();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                    }
                }

                static class FieldModification
                extends EventsCommon {
                    static final byte ALT_ID = 21;
                    final int requestID;
                    final ThreadReferenceImpl thread;
                    final Location location;
                    final byte refTypeTag;
                    final long typeID;
                    final long fieldID;
                    final ObjectReferenceImpl object;
                    final ValueImpl valueToBe;

                    byte eventKind() {
                        return 21;
                    }

                    FieldModification(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                        this.requestID = packetStream.readInt();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.thread = packetStream.readThreadReference();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "thread(ThreadReferenceImpl): " + (this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                        this.location = packetStream.readLocation();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "location(Location): " + this.location);
                        }
                        this.refTypeTag = packetStream.readByte();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "refTypeTag(byte): " + this.refTypeTag);
                        }
                        this.typeID = packetStream.readClassRef();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "typeID(long): ref=" + this.typeID);
                        }
                        this.fieldID = packetStream.readFieldRef();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "fieldID(long): " + this.fieldID);
                        }
                        this.object = packetStream.readTaggedObjectReference();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "object(ObjectReferenceImpl): " + (this.object == null ? "NULL" : "ref=" + this.object.ref()));
                        }
                        this.valueToBe = packetStream.readValue();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "valueToBe(ValueImpl): " + this.valueToBe);
                        }
                    }
                }

                static class FieldAccess
                extends EventsCommon {
                    static final byte ALT_ID = 20;
                    final int requestID;
                    final ThreadReferenceImpl thread;
                    final Location location;
                    final byte refTypeTag;
                    final long typeID;
                    final long fieldID;
                    final ObjectReferenceImpl object;

                    byte eventKind() {
                        return 20;
                    }

                    FieldAccess(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                        this.requestID = packetStream.readInt();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.thread = packetStream.readThreadReference();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "thread(ThreadReferenceImpl): " + (this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                        this.location = packetStream.readLocation();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "location(Location): " + this.location);
                        }
                        this.refTypeTag = packetStream.readByte();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "refTypeTag(byte): " + this.refTypeTag);
                        }
                        this.typeID = packetStream.readClassRef();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "typeID(long): ref=" + this.typeID);
                        }
                        this.fieldID = packetStream.readFieldRef();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "fieldID(long): " + this.fieldID);
                        }
                        this.object = packetStream.readTaggedObjectReference();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "object(ObjectReferenceImpl): " + (this.object == null ? "NULL" : "ref=" + this.object.ref()));
                        }
                    }
                }

                static class ClassUnload
                extends EventsCommon {
                    static final byte ALT_ID = 9;
                    final int requestID;
                    final String signature;

                    byte eventKind() {
                        return 9;
                    }

                    ClassUnload(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                        this.requestID = packetStream.readInt();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.signature = packetStream.readString();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "signature(String): " + this.signature);
                        }
                    }
                }

                static class ClassPrepare
                extends EventsCommon {
                    static final byte ALT_ID = 8;
                    final int requestID;
                    final ThreadReferenceImpl thread;
                    final byte refTypeTag;
                    final long typeID;
                    final String signature;
                    final int status;

                    byte eventKind() {
                        return 8;
                    }

                    ClassPrepare(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                        this.requestID = packetStream.readInt();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.thread = packetStream.readThreadReference();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "thread(ThreadReferenceImpl): " + (this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                        this.refTypeTag = packetStream.readByte();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "refTypeTag(byte): " + this.refTypeTag);
                        }
                        this.typeID = packetStream.readClassRef();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "typeID(long): ref=" + this.typeID);
                        }
                        this.signature = packetStream.readString();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "signature(String): " + this.signature);
                        }
                        this.status = packetStream.readInt();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "status(int): " + this.status);
                        }
                    }
                }

                static class ThreadDeath
                extends EventsCommon {
                    static final byte ALT_ID = 7;
                    final int requestID;
                    final ThreadReferenceImpl thread;

                    byte eventKind() {
                        return 7;
                    }

                    ThreadDeath(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                        this.requestID = packetStream.readInt();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.thread = packetStream.readThreadReference();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "thread(ThreadReferenceImpl): " + (this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                    }
                }

                static class ThreadStart
                extends EventsCommon {
                    static final byte ALT_ID = 6;
                    final int requestID;
                    final ThreadReferenceImpl thread;

                    byte eventKind() {
                        return 6;
                    }

                    ThreadStart(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                        this.requestID = packetStream.readInt();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.thread = packetStream.readThreadReference();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "thread(ThreadReferenceImpl): " + (this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                    }
                }

                static class Exception
                extends EventsCommon {
                    static final byte ALT_ID = 4;
                    final int requestID;
                    final ThreadReferenceImpl thread;
                    final Location location;
                    final ObjectReferenceImpl exception;
                    final Location catchLocation;

                    byte eventKind() {
                        return 4;
                    }

                    Exception(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                        this.requestID = packetStream.readInt();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.thread = packetStream.readThreadReference();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "thread(ThreadReferenceImpl): " + (this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                        this.location = packetStream.readLocation();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "location(Location): " + this.location);
                        }
                        this.exception = packetStream.readTaggedObjectReference();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "exception(ObjectReferenceImpl): " + (this.exception == null ? "NULL" : "ref=" + this.exception.ref()));
                        }
                        this.catchLocation = packetStream.readLocation();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "catchLocation(Location): " + this.catchLocation);
                        }
                    }
                }

                static class MethodExit
                extends EventsCommon {
                    static final byte ALT_ID = 41;
                    final int requestID;
                    final ThreadReferenceImpl thread;
                    final Location location;

                    byte eventKind() {
                        return 41;
                    }

                    MethodExit(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                        this.requestID = packetStream.readInt();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.thread = packetStream.readThreadReference();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "thread(ThreadReferenceImpl): " + (this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                        this.location = packetStream.readLocation();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "location(Location): " + this.location);
                        }
                    }
                }

                static class MethodEntry
                extends EventsCommon {
                    static final byte ALT_ID = 40;
                    final int requestID;
                    final ThreadReferenceImpl thread;
                    final Location location;

                    byte eventKind() {
                        return 40;
                    }

                    MethodEntry(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                        this.requestID = packetStream.readInt();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.thread = packetStream.readThreadReference();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "thread(ThreadReferenceImpl): " + (this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                        this.location = packetStream.readLocation();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "location(Location): " + this.location);
                        }
                    }
                }

                static class Breakpoint
                extends EventsCommon {
                    static final byte ALT_ID = 2;
                    final int requestID;
                    final ThreadReferenceImpl thread;
                    final Location location;

                    byte eventKind() {
                        return 2;
                    }

                    Breakpoint(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                        this.requestID = packetStream.readInt();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.thread = packetStream.readThreadReference();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "thread(ThreadReferenceImpl): " + (this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                        this.location = packetStream.readLocation();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "location(Location): " + this.location);
                        }
                    }
                }

                static class SingleStep
                extends EventsCommon {
                    static final byte ALT_ID = 1;
                    final int requestID;
                    final ThreadReferenceImpl thread;
                    final Location location;

                    byte eventKind() {
                        return 1;
                    }

                    SingleStep(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                        this.requestID = packetStream.readInt();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.thread = packetStream.readThreadReference();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "thread(ThreadReferenceImpl): " + (this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                        this.location = packetStream.readLocation();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "location(Location): " + this.location);
                        }
                    }
                }

                static class VMStart
                extends EventsCommon {
                    static final byte ALT_ID = 90;
                    final int requestID;
                    final ThreadReferenceImpl thread;

                    byte eventKind() {
                        return 90;
                    }

                    VMStart(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                        this.requestID = packetStream.readInt();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "requestID(int): " + this.requestID);
                        }
                        this.thread = packetStream.readThreadReference();
                        if (virtualMachineImpl.traceReceives) {
                            virtualMachineImpl.printReceiveTrace(6, "thread(ThreadReferenceImpl): " + (this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                    }
                }

                static abstract class EventsCommon {
                    EventsCommon() {
                    }

                    abstract byte eventKind();
                }
            }
        }
    }

    static class ClassObjectReference {
        static final int COMMAND_SET = 17;

        private ClassObjectReference() {
        }

        static class ReflectedType {
            static final int COMMAND = 1;
            final byte refTypeTag;
            final long typeID;

            static ReflectedType process(VirtualMachineImpl virtualMachineImpl, ClassObjectReferenceImpl classObjectReferenceImpl) throws JDWPException {
                PacketStream packetStream = ReflectedType.enqueueCommand(virtualMachineImpl, classObjectReferenceImpl);
                return ReflectedType.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ClassObjectReferenceImpl classObjectReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 17, 1);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ClassObjectReference.ReflectedType" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 classObject(ClassObjectReferenceImpl): " + (classObjectReferenceImpl == null ? "NULL" : "ref=" + classObjectReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(classObjectReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static ReflectedType waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new ReflectedType(virtualMachineImpl, packetStream);
            }

            private ReflectedType(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ClassObjectReference.ReflectedType" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.refTypeTag = packetStream.readByte();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "refTypeTag(byte): " + this.refTypeTag);
                }
                this.typeID = packetStream.readClassRef();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "typeID(long): ref=" + this.typeID);
                }
            }
        }
    }

    static class StackFrame {
        static final int COMMAND_SET = 16;

        private StackFrame() {
        }

        static class PopFrames {
            static final int COMMAND = 4;

            static PopFrames process(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl, long l) throws JDWPException {
                PacketStream packetStream = PopFrames.enqueueCommand(virtualMachineImpl, threadReferenceImpl, l);
                return PopFrames.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl, long l) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 16, 4);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.StackFrame.PopFrames" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (threadReferenceImpl == null ? "NULL" : "ref=" + threadReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadReferenceImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 frame(long): " + l);
                }
                packetStream.writeFrameRef(l);
                packetStream.send();
                return packetStream;
            }

            static PopFrames waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new PopFrames(virtualMachineImpl, packetStream);
            }

            private PopFrames(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.StackFrame.PopFrames" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }
        }

        static class ThisObject {
            static final int COMMAND = 3;
            final ObjectReferenceImpl objectThis;

            static ThisObject process(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl, long l) throws JDWPException {
                PacketStream packetStream = ThisObject.enqueueCommand(virtualMachineImpl, threadReferenceImpl, l);
                return ThisObject.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl, long l) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 16, 3);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.StackFrame.ThisObject" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (threadReferenceImpl == null ? "NULL" : "ref=" + threadReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadReferenceImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 frame(long): " + l);
                }
                packetStream.writeFrameRef(l);
                packetStream.send();
                return packetStream;
            }

            static ThisObject waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new ThisObject(virtualMachineImpl, packetStream);
            }

            private ThisObject(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.StackFrame.ThisObject" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.objectThis = packetStream.readTaggedObjectReference();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "objectThis(ObjectReferenceImpl): " + (this.objectThis == null ? "NULL" : "ref=" + this.objectThis.ref()));
                }
            }
        }

        static class SetValues {
            static final int COMMAND = 2;

            static SetValues process(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl, long l, SlotInfo[] slotInfoArray) throws JDWPException {
                PacketStream packetStream = SetValues.enqueueCommand(virtualMachineImpl, threadReferenceImpl, l, slotInfoArray);
                return SetValues.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl, long l, SlotInfo[] slotInfoArray) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 16, 2);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.StackFrame.SetValues" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (threadReferenceImpl == null ? "NULL" : "ref=" + threadReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadReferenceImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 frame(long): " + l);
                }
                packetStream.writeFrameRef(l);
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 slotValues(SlotInfo[]): ");
                }
                packetStream.writeInt(slotInfoArray.length);
                for (int i = 0; i < slotInfoArray.length; ++i) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     slotValues[i](SlotInfo): ");
                    }
                    slotInfoArray[i].write(packetStream);
                }
                packetStream.send();
                return packetStream;
            }

            static SetValues waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new SetValues(virtualMachineImpl, packetStream);
            }

            private SetValues(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.StackFrame.SetValues" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }

            static class SlotInfo {
                final int slot;
                final ValueImpl slotValue;

                SlotInfo(int n, ValueImpl valueImpl) {
                    this.slot = n;
                    this.slotValue = valueImpl;
                }

                private void write(PacketStream packetStream) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     slot(int): " + this.slot);
                    }
                    packetStream.writeInt(this.slot);
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     slotValue(ValueImpl): " + this.slotValue);
                    }
                    packetStream.writeValue(this.slotValue);
                }
            }
        }

        static class GetValues {
            static final int COMMAND = 1;
            final ValueImpl[] values;

            static GetValues process(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl, long l, SlotInfo[] slotInfoArray) throws JDWPException {
                PacketStream packetStream = GetValues.enqueueCommand(virtualMachineImpl, threadReferenceImpl, l, slotInfoArray);
                return GetValues.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl, long l, SlotInfo[] slotInfoArray) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 16, 1);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.StackFrame.GetValues" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (threadReferenceImpl == null ? "NULL" : "ref=" + threadReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadReferenceImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 frame(long): " + l);
                }
                packetStream.writeFrameRef(l);
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 slots(SlotInfo[]): ");
                }
                packetStream.writeInt(slotInfoArray.length);
                for (int i = 0; i < slotInfoArray.length; ++i) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     slots[i](SlotInfo): ");
                    }
                    slotInfoArray[i].write(packetStream);
                }
                packetStream.send();
                return packetStream;
            }

            static GetValues waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new GetValues(virtualMachineImpl, packetStream);
            }

            private GetValues(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.StackFrame.GetValues" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "values(ValueImpl[]): ");
                }
                int n = packetStream.readInt();
                this.values = new ValueImpl[n];
                for (int i = 0; i < n; ++i) {
                    this.values[i] = packetStream.readValue();
                    if (!virtualMachineImpl.traceReceives) continue;
                    virtualMachineImpl.printReceiveTrace(5, "values[" + i + "](ValueImpl): " + this.values[i]);
                }
            }

            static class SlotInfo {
                final int slot;
                final byte sigbyte;

                SlotInfo(int n, byte by) {
                    this.slot = n;
                    this.sigbyte = by;
                }

                private void write(PacketStream packetStream) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     slot(int): " + this.slot);
                    }
                    packetStream.writeInt(this.slot);
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     sigbyte(byte): " + this.sigbyte);
                    }
                    packetStream.writeByte(this.sigbyte);
                }
            }
        }
    }

    static class EventRequest {
        static final int COMMAND_SET = 15;

        private EventRequest() {
        }

        static class ClearAllBreakpoints {
            static final int COMMAND = 3;

            static ClearAllBreakpoints process(VirtualMachineImpl virtualMachineImpl) throws JDWPException {
                PacketStream packetStream = ClearAllBreakpoints.enqueueCommand(virtualMachineImpl);
                return ClearAllBreakpoints.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 15, 3);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.EventRequest.ClearAllBreakpoints" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                packetStream.send();
                return packetStream;
            }

            static ClearAllBreakpoints waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new ClearAllBreakpoints(virtualMachineImpl, packetStream);
            }

            private ClearAllBreakpoints(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.EventRequest.ClearAllBreakpoints" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }
        }

        static class Clear {
            static final int COMMAND = 2;

            static Clear process(VirtualMachineImpl virtualMachineImpl, byte by, int n) throws JDWPException {
                PacketStream packetStream = Clear.enqueueCommand(virtualMachineImpl, by, n);
                return Clear.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, byte by, int n) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 15, 2);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.EventRequest.Clear" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 event(byte): " + by);
                }
                packetStream.writeByte(by);
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 requestID(int): " + n);
                }
                packetStream.writeInt(n);
                packetStream.send();
                return packetStream;
            }

            static Clear waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Clear(virtualMachineImpl, packetStream);
            }

            private Clear(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.EventRequest.Clear" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }
        }

        static class Set {
            static final int COMMAND = 1;
            final int requestID;

            static Set process(VirtualMachineImpl virtualMachineImpl, byte by, byte by2, Modifier[] modifierArray) throws JDWPException {
                PacketStream packetStream = Set.enqueueCommand(virtualMachineImpl, by, by2, modifierArray);
                return Set.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, byte by, byte by2, Modifier[] modifierArray) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 15, 1);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.EventRequest.Set" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 eventKind(byte): " + by);
                }
                packetStream.writeByte(by);
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 suspendPolicy(byte): " + by2);
                }
                packetStream.writeByte(by2);
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 modifiers(Modifier[]): ");
                }
                packetStream.writeInt(modifierArray.length);
                for (int i = 0; i < modifierArray.length; ++i) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     modifiers[i](Modifier): ");
                    }
                    modifierArray[i].write(packetStream);
                }
                packetStream.send();
                return packetStream;
            }

            static Set waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Set(virtualMachineImpl, packetStream);
            }

            private Set(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.EventRequest.Set" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.requestID = packetStream.readInt();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "requestID(int): " + this.requestID);
                }
            }

            static class Modifier {
                final byte modKind;
                ModifierCommon aModifierCommon;

                Modifier(byte by, ModifierCommon modifierCommon) {
                    this.modKind = by;
                    this.aModifierCommon = modifierCommon;
                }

                private void write(PacketStream packetStream) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     modKind(byte): " + this.modKind);
                    }
                    packetStream.writeByte(this.modKind);
                    this.aModifierCommon.write(packetStream);
                }

                static class InstanceOnly
                extends ModifierCommon {
                    static final byte ALT_ID = 11;
                    final ObjectReferenceImpl instance;

                    static Modifier create(ObjectReferenceImpl objectReferenceImpl) {
                        return new Modifier(11, new InstanceOnly(objectReferenceImpl));
                    }

                    InstanceOnly(ObjectReferenceImpl objectReferenceImpl) {
                        this.instance = objectReferenceImpl;
                    }

                    void write(PacketStream packetStream) {
                        if ((packetStream.vm.traceFlags & 1) != 0) {
                            packetStream.vm.printTrace("Sending:                         instance(ObjectReferenceImpl): " + (this.instance == null ? "NULL" : "ref=" + this.instance.ref()));
                        }
                        packetStream.writeObjectRef(this.instance.ref());
                    }
                }

                static class Step
                extends ModifierCommon {
                    static final byte ALT_ID = 10;
                    final ThreadReferenceImpl thread;
                    final int size;
                    final int depth;

                    static Modifier create(ThreadReferenceImpl threadReferenceImpl, int n, int n2) {
                        return new Modifier(10, new Step(threadReferenceImpl, n, n2));
                    }

                    Step(ThreadReferenceImpl threadReferenceImpl, int n, int n2) {
                        this.thread = threadReferenceImpl;
                        this.size = n;
                        this.depth = n2;
                    }

                    void write(PacketStream packetStream) {
                        if ((packetStream.vm.traceFlags & 1) != 0) {
                            packetStream.vm.printTrace("Sending:                         thread(ThreadReferenceImpl): " + (this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                        packetStream.writeObjectRef(this.thread.ref());
                        if ((packetStream.vm.traceFlags & 1) != 0) {
                            packetStream.vm.printTrace("Sending:                         size(int): " + this.size);
                        }
                        packetStream.writeInt(this.size);
                        if ((packetStream.vm.traceFlags & 1) != 0) {
                            packetStream.vm.printTrace("Sending:                         depth(int): " + this.depth);
                        }
                        packetStream.writeInt(this.depth);
                    }
                }

                static class FieldOnly
                extends ModifierCommon {
                    static final byte ALT_ID = 9;
                    final ReferenceTypeImpl declaring;
                    final long fieldID;

                    static Modifier create(ReferenceTypeImpl referenceTypeImpl, long l) {
                        return new Modifier(9, new FieldOnly(referenceTypeImpl, l));
                    }

                    FieldOnly(ReferenceTypeImpl referenceTypeImpl, long l) {
                        this.declaring = referenceTypeImpl;
                        this.fieldID = l;
                    }

                    void write(PacketStream packetStream) {
                        if ((packetStream.vm.traceFlags & 1) != 0) {
                            packetStream.vm.printTrace("Sending:                         declaring(ReferenceTypeImpl): " + (this.declaring == null ? "NULL" : "ref=" + this.declaring.ref()));
                        }
                        packetStream.writeClassRef(this.declaring.ref());
                        if ((packetStream.vm.traceFlags & 1) != 0) {
                            packetStream.vm.printTrace("Sending:                         fieldID(long): " + this.fieldID);
                        }
                        packetStream.writeFieldRef(this.fieldID);
                    }
                }

                static class ExceptionOnly
                extends ModifierCommon {
                    static final byte ALT_ID = 8;
                    final ReferenceTypeImpl exceptionOrNull;
                    final boolean caught;
                    final boolean uncaught;

                    static Modifier create(ReferenceTypeImpl referenceTypeImpl, boolean bl, boolean bl2) {
                        return new Modifier(8, new ExceptionOnly(referenceTypeImpl, bl, bl2));
                    }

                    ExceptionOnly(ReferenceTypeImpl referenceTypeImpl, boolean bl, boolean bl2) {
                        this.exceptionOrNull = referenceTypeImpl;
                        this.caught = bl;
                        this.uncaught = bl2;
                    }

                    void write(PacketStream packetStream) {
                        if ((packetStream.vm.traceFlags & 1) != 0) {
                            packetStream.vm.printTrace("Sending:                         exceptionOrNull(ReferenceTypeImpl): " + (this.exceptionOrNull == null ? "NULL" : "ref=" + this.exceptionOrNull.ref()));
                        }
                        packetStream.writeClassRef(this.exceptionOrNull.ref());
                        if ((packetStream.vm.traceFlags & 1) != 0) {
                            packetStream.vm.printTrace("Sending:                         caught(boolean): " + this.caught);
                        }
                        packetStream.writeBoolean(this.caught);
                        if ((packetStream.vm.traceFlags & 1) != 0) {
                            packetStream.vm.printTrace("Sending:                         uncaught(boolean): " + this.uncaught);
                        }
                        packetStream.writeBoolean(this.uncaught);
                    }
                }

                static class LocationOnly
                extends ModifierCommon {
                    static final byte ALT_ID = 7;
                    final Location loc;

                    static Modifier create(Location location) {
                        return new Modifier(7, new LocationOnly(location));
                    }

                    LocationOnly(Location location) {
                        this.loc = location;
                    }

                    void write(PacketStream packetStream) {
                        if ((packetStream.vm.traceFlags & 1) != 0) {
                            packetStream.vm.printTrace("Sending:                         loc(Location): " + this.loc);
                        }
                        packetStream.writeLocation(this.loc);
                    }
                }

                static class ClassExclude
                extends ModifierCommon {
                    static final byte ALT_ID = 6;
                    final String classPattern;

                    static Modifier create(String string) {
                        return new Modifier(6, new ClassExclude(string));
                    }

                    ClassExclude(String string) {
                        this.classPattern = string;
                    }

                    void write(PacketStream packetStream) {
                        if ((packetStream.vm.traceFlags & 1) != 0) {
                            packetStream.vm.printTrace("Sending:                         classPattern(String): " + this.classPattern);
                        }
                        packetStream.writeString(this.classPattern);
                    }
                }

                static class ClassMatch
                extends ModifierCommon {
                    static final byte ALT_ID = 5;
                    final String classPattern;

                    static Modifier create(String string) {
                        return new Modifier(5, new ClassMatch(string));
                    }

                    ClassMatch(String string) {
                        this.classPattern = string;
                    }

                    void write(PacketStream packetStream) {
                        if ((packetStream.vm.traceFlags & 1) != 0) {
                            packetStream.vm.printTrace("Sending:                         classPattern(String): " + this.classPattern);
                        }
                        packetStream.writeString(this.classPattern);
                    }
                }

                static class ClassOnly
                extends ModifierCommon {
                    static final byte ALT_ID = 4;
                    final ReferenceTypeImpl clazz;

                    static Modifier create(ReferenceTypeImpl referenceTypeImpl) {
                        return new Modifier(4, new ClassOnly(referenceTypeImpl));
                    }

                    ClassOnly(ReferenceTypeImpl referenceTypeImpl) {
                        this.clazz = referenceTypeImpl;
                    }

                    void write(PacketStream packetStream) {
                        if ((packetStream.vm.traceFlags & 1) != 0) {
                            packetStream.vm.printTrace("Sending:                         clazz(ReferenceTypeImpl): " + (this.clazz == null ? "NULL" : "ref=" + this.clazz.ref()));
                        }
                        packetStream.writeClassRef(this.clazz.ref());
                    }
                }

                static class ThreadOnly
                extends ModifierCommon {
                    static final byte ALT_ID = 3;
                    final ThreadReferenceImpl thread;

                    static Modifier create(ThreadReferenceImpl threadReferenceImpl) {
                        return new Modifier(3, new ThreadOnly(threadReferenceImpl));
                    }

                    ThreadOnly(ThreadReferenceImpl threadReferenceImpl) {
                        this.thread = threadReferenceImpl;
                    }

                    void write(PacketStream packetStream) {
                        if ((packetStream.vm.traceFlags & 1) != 0) {
                            packetStream.vm.printTrace("Sending:                         thread(ThreadReferenceImpl): " + (this.thread == null ? "NULL" : "ref=" + this.thread.ref()));
                        }
                        packetStream.writeObjectRef(this.thread.ref());
                    }
                }

                static class Conditional
                extends ModifierCommon {
                    static final byte ALT_ID = 2;
                    final int exprID;

                    static Modifier create(int n) {
                        return new Modifier(2, new Conditional(n));
                    }

                    Conditional(int n) {
                        this.exprID = n;
                    }

                    void write(PacketStream packetStream) {
                        if ((packetStream.vm.traceFlags & 1) != 0) {
                            packetStream.vm.printTrace("Sending:                         exprID(int): " + this.exprID);
                        }
                        packetStream.writeInt(this.exprID);
                    }
                }

                static class Count
                extends ModifierCommon {
                    static final byte ALT_ID = 1;
                    final int count;

                    static Modifier create(int n) {
                        return new Modifier(1, new Count(n));
                    }

                    Count(int n) {
                        this.count = n;
                    }

                    void write(PacketStream packetStream) {
                        if ((packetStream.vm.traceFlags & 1) != 0) {
                            packetStream.vm.printTrace("Sending:                         count(int): " + this.count);
                        }
                        packetStream.writeInt(this.count);
                    }
                }

                static abstract class ModifierCommon {
                    ModifierCommon() {
                    }

                    abstract void write(PacketStream var1);
                }
            }
        }
    }

    static class ClassLoaderReference {
        static final int COMMAND_SET = 14;

        private ClassLoaderReference() {
        }

        static class VisibleClasses {
            static final int COMMAND = 1;
            final ClassInfo[] classes;

            static VisibleClasses process(VirtualMachineImpl virtualMachineImpl, ClassLoaderReferenceImpl classLoaderReferenceImpl) throws JDWPException {
                PacketStream packetStream = VisibleClasses.enqueueCommand(virtualMachineImpl, classLoaderReferenceImpl);
                return VisibleClasses.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ClassLoaderReferenceImpl classLoaderReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 14, 1);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ClassLoaderReference.VisibleClasses" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 classLoaderObject(ClassLoaderReferenceImpl): " + (classLoaderReferenceImpl == null ? "NULL" : "ref=" + classLoaderReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(classLoaderReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static VisibleClasses waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new VisibleClasses(virtualMachineImpl, packetStream);
            }

            private VisibleClasses(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ClassLoaderReference.VisibleClasses" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "classes(ClassInfo[]): ");
                }
                int n = packetStream.readInt();
                this.classes = new ClassInfo[n];
                for (int i = 0; i < n; ++i) {
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "classes[" + i + "](ClassInfo): " + "");
                    }
                    this.classes[i] = new ClassInfo(virtualMachineImpl, packetStream);
                }
            }

            static class ClassInfo {
                final byte refTypeTag;
                final long typeID;

                private ClassInfo(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                    this.refTypeTag = packetStream.readByte();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "refTypeTag(byte): " + this.refTypeTag);
                    }
                    this.typeID = packetStream.readClassRef();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "typeID(long): ref=" + this.typeID);
                    }
                }
            }
        }
    }

    static class ArrayReference {
        static final int COMMAND_SET = 13;

        private ArrayReference() {
        }

        static class SetValues {
            static final int COMMAND = 3;

            static SetValues process(VirtualMachineImpl virtualMachineImpl, ArrayReferenceImpl arrayReferenceImpl, int n, ValueImpl[] valueImplArray) throws JDWPException {
                PacketStream packetStream = SetValues.enqueueCommand(virtualMachineImpl, arrayReferenceImpl, n, valueImplArray);
                return SetValues.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ArrayReferenceImpl arrayReferenceImpl, int n, ValueImpl[] valueImplArray) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 13, 3);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ArrayReference.SetValues" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 arrayObject(ArrayReferenceImpl): " + (arrayReferenceImpl == null ? "NULL" : "ref=" + arrayReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(arrayReferenceImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 firstIndex(int): " + n);
                }
                packetStream.writeInt(n);
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 values(ValueImpl[]): ");
                }
                packetStream.writeInt(valueImplArray.length);
                for (int i = 0; i < valueImplArray.length; ++i) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     values[i](ValueImpl): " + valueImplArray[i]);
                    }
                    packetStream.writeUntaggedValue(valueImplArray[i]);
                }
                packetStream.send();
                return packetStream;
            }

            static SetValues waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new SetValues(virtualMachineImpl, packetStream);
            }

            private SetValues(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ArrayReference.SetValues" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }
        }

        static class GetValues {
            static final int COMMAND = 2;
            final List values;

            static GetValues process(VirtualMachineImpl virtualMachineImpl, ArrayReferenceImpl arrayReferenceImpl, int n, int n2) throws JDWPException {
                PacketStream packetStream = GetValues.enqueueCommand(virtualMachineImpl, arrayReferenceImpl, n, n2);
                return GetValues.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ArrayReferenceImpl arrayReferenceImpl, int n, int n2) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 13, 2);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ArrayReference.GetValues" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 arrayObject(ArrayReferenceImpl): " + (arrayReferenceImpl == null ? "NULL" : "ref=" + arrayReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(arrayReferenceImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 firstIndex(int): " + n);
                }
                packetStream.writeInt(n);
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 length(int): " + n2);
                }
                packetStream.writeInt(n2);
                packetStream.send();
                return packetStream;
            }

            static GetValues waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new GetValues(virtualMachineImpl, packetStream);
            }

            private GetValues(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ArrayReference.GetValues" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.values = packetStream.readArrayRegion();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "values(List): " + this.values);
                }
            }
        }

        static class Length {
            static final int COMMAND = 1;
            final int arrayLength;

            static Length process(VirtualMachineImpl virtualMachineImpl, ArrayReferenceImpl arrayReferenceImpl) throws JDWPException {
                PacketStream packetStream = Length.enqueueCommand(virtualMachineImpl, arrayReferenceImpl);
                return Length.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ArrayReferenceImpl arrayReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 13, 1);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ArrayReference.Length" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 arrayObject(ArrayReferenceImpl): " + (arrayReferenceImpl == null ? "NULL" : "ref=" + arrayReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(arrayReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static Length waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Length(virtualMachineImpl, packetStream);
            }

            private Length(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ArrayReference.Length" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.arrayLength = packetStream.readInt();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "arrayLength(int): " + this.arrayLength);
                }
            }
        }
    }

    static class ThreadGroupReference {
        static final int COMMAND_SET = 12;

        private ThreadGroupReference() {
        }

        static class Children {
            static final int COMMAND = 3;
            final ThreadReferenceImpl[] childThreads;
            final ThreadGroupReferenceImpl[] childGroups;

            static Children process(VirtualMachineImpl virtualMachineImpl, ThreadGroupReferenceImpl threadGroupReferenceImpl) throws JDWPException {
                PacketStream packetStream = Children.enqueueCommand(virtualMachineImpl, threadGroupReferenceImpl);
                return Children.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ThreadGroupReferenceImpl threadGroupReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 12, 3);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ThreadGroupReference.Children" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 group(ThreadGroupReferenceImpl): " + (threadGroupReferenceImpl == null ? "NULL" : "ref=" + threadGroupReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadGroupReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static Children waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Children(virtualMachineImpl, packetStream);
            }

            private Children(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                int n;
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ThreadGroupReference.Children" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "childThreads(ThreadReferenceImpl[]): ");
                }
                int n2 = packetStream.readInt();
                this.childThreads = new ThreadReferenceImpl[n2];
                for (n = 0; n < n2; ++n) {
                    this.childThreads[n] = packetStream.readThreadReference();
                    if (!virtualMachineImpl.traceReceives) continue;
                    virtualMachineImpl.printReceiveTrace(5, "childThreads[" + n + "](ThreadReferenceImpl): " + (this.childThreads[n] == null ? "NULL" : "ref=" + this.childThreads[n].ref()));
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "childGroups(ThreadGroupReferenceImpl[]): ");
                }
                n = packetStream.readInt();
                this.childGroups = new ThreadGroupReferenceImpl[n];
                for (int i = 0; i < n; ++i) {
                    this.childGroups[i] = packetStream.readThreadGroupReference();
                    if (!virtualMachineImpl.traceReceives) continue;
                    virtualMachineImpl.printReceiveTrace(5, "childGroups[" + i + "](ThreadGroupReferenceImpl): " + (this.childGroups[i] == null ? "NULL" : "ref=" + this.childGroups[i].ref()));
                }
            }
        }

        static class Parent {
            static final int COMMAND = 2;
            final ThreadGroupReferenceImpl parentGroup;

            static Parent process(VirtualMachineImpl virtualMachineImpl, ThreadGroupReferenceImpl threadGroupReferenceImpl) throws JDWPException {
                PacketStream packetStream = Parent.enqueueCommand(virtualMachineImpl, threadGroupReferenceImpl);
                return Parent.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ThreadGroupReferenceImpl threadGroupReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 12, 2);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ThreadGroupReference.Parent" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 group(ThreadGroupReferenceImpl): " + (threadGroupReferenceImpl == null ? "NULL" : "ref=" + threadGroupReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadGroupReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static Parent waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Parent(virtualMachineImpl, packetStream);
            }

            private Parent(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ThreadGroupReference.Parent" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.parentGroup = packetStream.readThreadGroupReference();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "parentGroup(ThreadGroupReferenceImpl): " + (this.parentGroup == null ? "NULL" : "ref=" + this.parentGroup.ref()));
                }
            }
        }

        static class Name {
            static final int COMMAND = 1;
            final String groupName;

            static Name process(VirtualMachineImpl virtualMachineImpl, ThreadGroupReferenceImpl threadGroupReferenceImpl) throws JDWPException {
                PacketStream packetStream = Name.enqueueCommand(virtualMachineImpl, threadGroupReferenceImpl);
                return Name.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ThreadGroupReferenceImpl threadGroupReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 12, 1);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ThreadGroupReference.Name" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 group(ThreadGroupReferenceImpl): " + (threadGroupReferenceImpl == null ? "NULL" : "ref=" + threadGroupReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadGroupReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static Name waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Name(virtualMachineImpl, packetStream);
            }

            private Name(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ThreadGroupReference.Name" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.groupName = packetStream.readString();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "groupName(String): " + this.groupName);
                }
            }
        }
    }

    static class ThreadReference {
        static final int COMMAND_SET = 11;

        private ThreadReference() {
        }

        static class SuspendCount {
            static final int COMMAND = 12;
            final int suspendCount;

            static SuspendCount process(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) throws JDWPException {
                PacketStream packetStream = SuspendCount.enqueueCommand(virtualMachineImpl, threadReferenceImpl);
                return SuspendCount.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 11, 12);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.SuspendCount" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (threadReferenceImpl == null ? "NULL" : "ref=" + threadReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static SuspendCount waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new SuspendCount(virtualMachineImpl, packetStream);
            }

            private SuspendCount(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.SuspendCount" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.suspendCount = packetStream.readInt();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "suspendCount(int): " + this.suspendCount);
                }
            }
        }

        static class Interrupt {
            static final int COMMAND = 11;

            static Interrupt process(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) throws JDWPException {
                PacketStream packetStream = Interrupt.enqueueCommand(virtualMachineImpl, threadReferenceImpl);
                return Interrupt.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 11, 11);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.Interrupt" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (threadReferenceImpl == null ? "NULL" : "ref=" + threadReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static Interrupt waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Interrupt(virtualMachineImpl, packetStream);
            }

            private Interrupt(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.Interrupt" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }
        }

        static class Stop {
            static final int COMMAND = 10;

            static Stop process(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl, ObjectReferenceImpl objectReferenceImpl) throws JDWPException {
                PacketStream packetStream = Stop.enqueueCommand(virtualMachineImpl, threadReferenceImpl, objectReferenceImpl);
                return Stop.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl, ObjectReferenceImpl objectReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 11, 10);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.Stop" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (threadReferenceImpl == null ? "NULL" : "ref=" + threadReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadReferenceImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 throwable(ObjectReferenceImpl): " + (objectReferenceImpl == null ? "NULL" : "ref=" + objectReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(objectReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static Stop waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Stop(virtualMachineImpl, packetStream);
            }

            private Stop(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.Stop" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }
        }

        static class CurrentContendedMonitor {
            static final int COMMAND = 9;
            final ObjectReferenceImpl monitor;

            static CurrentContendedMonitor process(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) throws JDWPException {
                PacketStream packetStream = CurrentContendedMonitor.enqueueCommand(virtualMachineImpl, threadReferenceImpl);
                return CurrentContendedMonitor.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 11, 9);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.CurrentContendedMonitor" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (threadReferenceImpl == null ? "NULL" : "ref=" + threadReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static CurrentContendedMonitor waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new CurrentContendedMonitor(virtualMachineImpl, packetStream);
            }

            private CurrentContendedMonitor(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.CurrentContendedMonitor" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.monitor = packetStream.readTaggedObjectReference();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "monitor(ObjectReferenceImpl): " + (this.monitor == null ? "NULL" : "ref=" + this.monitor.ref()));
                }
            }
        }

        static class OwnedMonitors {
            static final int COMMAND = 8;
            final ObjectReferenceImpl[] owned;

            static OwnedMonitors process(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) throws JDWPException {
                PacketStream packetStream = OwnedMonitors.enqueueCommand(virtualMachineImpl, threadReferenceImpl);
                return OwnedMonitors.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 11, 8);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.OwnedMonitors" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (threadReferenceImpl == null ? "NULL" : "ref=" + threadReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static OwnedMonitors waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new OwnedMonitors(virtualMachineImpl, packetStream);
            }

            private OwnedMonitors(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.OwnedMonitors" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "owned(ObjectReferenceImpl[]): ");
                }
                int n = packetStream.readInt();
                this.owned = new ObjectReferenceImpl[n];
                for (int i = 0; i < n; ++i) {
                    this.owned[i] = packetStream.readTaggedObjectReference();
                    if (!virtualMachineImpl.traceReceives) continue;
                    virtualMachineImpl.printReceiveTrace(5, "owned[" + i + "](ObjectReferenceImpl): " + (this.owned[i] == null ? "NULL" : "ref=" + this.owned[i].ref()));
                }
            }
        }

        static class FrameCount {
            static final int COMMAND = 7;
            final int frameCount;

            static FrameCount process(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) throws JDWPException {
                PacketStream packetStream = FrameCount.enqueueCommand(virtualMachineImpl, threadReferenceImpl);
                return FrameCount.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 11, 7);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.FrameCount" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (threadReferenceImpl == null ? "NULL" : "ref=" + threadReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static FrameCount waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new FrameCount(virtualMachineImpl, packetStream);
            }

            private FrameCount(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.FrameCount" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.frameCount = packetStream.readInt();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "frameCount(int): " + this.frameCount);
                }
            }
        }

        static class Frames {
            static final int COMMAND = 6;
            final Frame[] frames;

            static Frames process(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl, int n, int n2) throws JDWPException {
                PacketStream packetStream = Frames.enqueueCommand(virtualMachineImpl, threadReferenceImpl, n, n2);
                return Frames.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl, int n, int n2) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 11, 6);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.Frames" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (threadReferenceImpl == null ? "NULL" : "ref=" + threadReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadReferenceImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 startFrame(int): " + n);
                }
                packetStream.writeInt(n);
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 length(int): " + n2);
                }
                packetStream.writeInt(n2);
                packetStream.send();
                return packetStream;
            }

            static Frames waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Frames(virtualMachineImpl, packetStream);
            }

            private Frames(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.Frames" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "frames(Frame[]): ");
                }
                int n = packetStream.readInt();
                this.frames = new Frame[n];
                for (int i = 0; i < n; ++i) {
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "frames[" + i + "](Frame): " + "");
                    }
                    this.frames[i] = new Frame(virtualMachineImpl, packetStream);
                }
            }

            static class Frame {
                final long frameID;
                final Location location;

                private Frame(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                    this.frameID = packetStream.readFrameRef();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "frameID(long): " + this.frameID);
                    }
                    this.location = packetStream.readLocation();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "location(Location): " + this.location);
                    }
                }
            }
        }

        static class ThreadGroup {
            static final int COMMAND = 5;
            final ThreadGroupReferenceImpl group;

            static ThreadGroup process(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) throws JDWPException {
                PacketStream packetStream = ThreadGroup.enqueueCommand(virtualMachineImpl, threadReferenceImpl);
                return ThreadGroup.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 11, 5);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.ThreadGroup" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (threadReferenceImpl == null ? "NULL" : "ref=" + threadReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static ThreadGroup waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new ThreadGroup(virtualMachineImpl, packetStream);
            }

            private ThreadGroup(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.ThreadGroup" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.group = packetStream.readThreadGroupReference();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "group(ThreadGroupReferenceImpl): " + (this.group == null ? "NULL" : "ref=" + this.group.ref()));
                }
            }
        }

        static class Status {
            static final int COMMAND = 4;
            final int threadStatus;
            final int suspendStatus;

            static Status process(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) throws JDWPException {
                PacketStream packetStream = Status.enqueueCommand(virtualMachineImpl, threadReferenceImpl);
                return Status.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 11, 4);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.Status" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (threadReferenceImpl == null ? "NULL" : "ref=" + threadReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static Status waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Status(virtualMachineImpl, packetStream);
            }

            private Status(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.Status" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.threadStatus = packetStream.readInt();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "threadStatus(int): " + this.threadStatus);
                }
                this.suspendStatus = packetStream.readInt();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "suspendStatus(int): " + this.suspendStatus);
                }
            }
        }

        static class Resume {
            static final int COMMAND = 3;

            static Resume process(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) throws JDWPException {
                PacketStream packetStream = Resume.enqueueCommand(virtualMachineImpl, threadReferenceImpl);
                return Resume.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 11, 3);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.Resume" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (threadReferenceImpl == null ? "NULL" : "ref=" + threadReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static Resume waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Resume(virtualMachineImpl, packetStream);
            }

            private Resume(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.Resume" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }
        }

        static class Suspend {
            static final int COMMAND = 2;

            static Suspend process(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) throws JDWPException {
                PacketStream packetStream = Suspend.enqueueCommand(virtualMachineImpl, threadReferenceImpl);
                return Suspend.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 11, 2);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.Suspend" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (threadReferenceImpl == null ? "NULL" : "ref=" + threadReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static Suspend waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Suspend(virtualMachineImpl, packetStream);
            }

            private Suspend(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.Suspend" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }
        }

        static class Name {
            static final int COMMAND = 1;
            final String threadName;

            static Name process(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) throws JDWPException {
                PacketStream packetStream = Name.enqueueCommand(virtualMachineImpl, threadReferenceImpl);
                return Name.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ThreadReferenceImpl threadReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 11, 1);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.Name" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (threadReferenceImpl == null ? "NULL" : "ref=" + threadReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static Name waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Name(virtualMachineImpl, packetStream);
            }

            private Name(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ThreadReference.Name" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.threadName = packetStream.readString();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "threadName(String): " + this.threadName);
                }
            }
        }
    }

    static class StringReference {
        static final int COMMAND_SET = 10;

        private StringReference() {
        }

        static class Value {
            static final int COMMAND = 1;
            final String stringValue;

            static Value process(VirtualMachineImpl virtualMachineImpl, ObjectReferenceImpl objectReferenceImpl) throws JDWPException {
                PacketStream packetStream = Value.enqueueCommand(virtualMachineImpl, objectReferenceImpl);
                return Value.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ObjectReferenceImpl objectReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 10, 1);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.StringReference.Value" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 stringObject(ObjectReferenceImpl): " + (objectReferenceImpl == null ? "NULL" : "ref=" + objectReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(objectReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static Value waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Value(virtualMachineImpl, packetStream);
            }

            private Value(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.StringReference.Value" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.stringValue = packetStream.readString();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "stringValue(String): " + this.stringValue);
                }
            }
        }
    }

    static class ObjectReference {
        static final int COMMAND_SET = 9;

        private ObjectReference() {
        }

        static class IsCollected {
            static final int COMMAND = 9;
            final boolean isCollected;

            static IsCollected process(VirtualMachineImpl virtualMachineImpl, ObjectReferenceImpl objectReferenceImpl) throws JDWPException {
                PacketStream packetStream = IsCollected.enqueueCommand(virtualMachineImpl, objectReferenceImpl);
                return IsCollected.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ObjectReferenceImpl objectReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 9, 9);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ObjectReference.IsCollected" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 object(ObjectReferenceImpl): " + (objectReferenceImpl == null ? "NULL" : "ref=" + objectReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(objectReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static IsCollected waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new IsCollected(virtualMachineImpl, packetStream);
            }

            private IsCollected(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ObjectReference.IsCollected" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.isCollected = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "isCollected(boolean): " + this.isCollected);
                }
            }
        }

        static class EnableCollection {
            static final int COMMAND = 8;

            static EnableCollection process(VirtualMachineImpl virtualMachineImpl, ObjectReferenceImpl objectReferenceImpl) throws JDWPException {
                PacketStream packetStream = EnableCollection.enqueueCommand(virtualMachineImpl, objectReferenceImpl);
                return EnableCollection.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ObjectReferenceImpl objectReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 9, 8);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ObjectReference.EnableCollection" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 object(ObjectReferenceImpl): " + (objectReferenceImpl == null ? "NULL" : "ref=" + objectReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(objectReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static EnableCollection waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new EnableCollection(virtualMachineImpl, packetStream);
            }

            private EnableCollection(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ObjectReference.EnableCollection" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }
        }

        static class DisableCollection {
            static final int COMMAND = 7;

            static DisableCollection process(VirtualMachineImpl virtualMachineImpl, ObjectReferenceImpl objectReferenceImpl) throws JDWPException {
                PacketStream packetStream = DisableCollection.enqueueCommand(virtualMachineImpl, objectReferenceImpl);
                return DisableCollection.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ObjectReferenceImpl objectReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 9, 7);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ObjectReference.DisableCollection" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 object(ObjectReferenceImpl): " + (objectReferenceImpl == null ? "NULL" : "ref=" + objectReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(objectReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static DisableCollection waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new DisableCollection(virtualMachineImpl, packetStream);
            }

            private DisableCollection(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ObjectReference.DisableCollection" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }
        }

        static class InvokeMethod {
            static final int COMMAND = 6;
            final ValueImpl returnValue;
            final ObjectReferenceImpl exception;

            static InvokeMethod process(VirtualMachineImpl virtualMachineImpl, ObjectReferenceImpl objectReferenceImpl, ThreadReferenceImpl threadReferenceImpl, ClassTypeImpl classTypeImpl, long l, ValueImpl[] valueImplArray, int n) throws JDWPException {
                PacketStream packetStream = InvokeMethod.enqueueCommand(virtualMachineImpl, objectReferenceImpl, threadReferenceImpl, classTypeImpl, l, valueImplArray, n);
                return InvokeMethod.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ObjectReferenceImpl objectReferenceImpl, ThreadReferenceImpl threadReferenceImpl, ClassTypeImpl classTypeImpl, long l, ValueImpl[] valueImplArray, int n) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 9, 6);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ObjectReference.InvokeMethod" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 object(ObjectReferenceImpl): " + (objectReferenceImpl == null ? "NULL" : "ref=" + objectReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(objectReferenceImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (threadReferenceImpl == null ? "NULL" : "ref=" + threadReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadReferenceImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 clazz(ClassTypeImpl): " + (classTypeImpl == null ? "NULL" : "ref=" + classTypeImpl.ref()));
                }
                packetStream.writeClassRef(classTypeImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 methodID(long): " + l);
                }
                packetStream.writeMethodRef(l);
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 arguments(ValueImpl[]): ");
                }
                packetStream.writeInt(valueImplArray.length);
                for (int i = 0; i < valueImplArray.length; ++i) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     arguments[i](ValueImpl): " + valueImplArray[i]);
                    }
                    packetStream.writeValue(valueImplArray[i]);
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 options(int): " + n);
                }
                packetStream.writeInt(n);
                packetStream.send();
                return packetStream;
            }

            static InvokeMethod waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new InvokeMethod(virtualMachineImpl, packetStream);
            }

            private InvokeMethod(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ObjectReference.InvokeMethod" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.returnValue = packetStream.readValue();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "returnValue(ValueImpl): " + this.returnValue);
                }
                this.exception = packetStream.readTaggedObjectReference();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "exception(ObjectReferenceImpl): " + (this.exception == null ? "NULL" : "ref=" + this.exception.ref()));
                }
            }
        }

        static class MonitorInfo {
            static final int COMMAND = 5;
            final ThreadReferenceImpl owner;
            final int entryCount;
            final ThreadReferenceImpl[] waiters;

            static MonitorInfo process(VirtualMachineImpl virtualMachineImpl, ObjectReferenceImpl objectReferenceImpl) throws JDWPException {
                PacketStream packetStream = MonitorInfo.enqueueCommand(virtualMachineImpl, objectReferenceImpl);
                return MonitorInfo.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ObjectReferenceImpl objectReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 9, 5);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ObjectReference.MonitorInfo" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 object(ObjectReferenceImpl): " + (objectReferenceImpl == null ? "NULL" : "ref=" + objectReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(objectReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static MonitorInfo waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new MonitorInfo(virtualMachineImpl, packetStream);
            }

            private MonitorInfo(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ObjectReference.MonitorInfo" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.owner = packetStream.readThreadReference();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "owner(ThreadReferenceImpl): " + (this.owner == null ? "NULL" : "ref=" + this.owner.ref()));
                }
                this.entryCount = packetStream.readInt();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "entryCount(int): " + this.entryCount);
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "waiters(ThreadReferenceImpl[]): ");
                }
                int n = packetStream.readInt();
                this.waiters = new ThreadReferenceImpl[n];
                for (int i = 0; i < n; ++i) {
                    this.waiters[i] = packetStream.readThreadReference();
                    if (!virtualMachineImpl.traceReceives) continue;
                    virtualMachineImpl.printReceiveTrace(5, "waiters[" + i + "](ThreadReferenceImpl): " + (this.waiters[i] == null ? "NULL" : "ref=" + this.waiters[i].ref()));
                }
            }
        }

        static class SetValues {
            static final int COMMAND = 3;

            static SetValues process(VirtualMachineImpl virtualMachineImpl, ObjectReferenceImpl objectReferenceImpl, FieldValue[] fieldValueArray) throws JDWPException {
                PacketStream packetStream = SetValues.enqueueCommand(virtualMachineImpl, objectReferenceImpl, fieldValueArray);
                return SetValues.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ObjectReferenceImpl objectReferenceImpl, FieldValue[] fieldValueArray) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 9, 3);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ObjectReference.SetValues" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 object(ObjectReferenceImpl): " + (objectReferenceImpl == null ? "NULL" : "ref=" + objectReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(objectReferenceImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 values(FieldValue[]): ");
                }
                packetStream.writeInt(fieldValueArray.length);
                for (int i = 0; i < fieldValueArray.length; ++i) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     values[i](FieldValue): ");
                    }
                    fieldValueArray[i].write(packetStream);
                }
                packetStream.send();
                return packetStream;
            }

            static SetValues waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new SetValues(virtualMachineImpl, packetStream);
            }

            private SetValues(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ObjectReference.SetValues" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }

            static class FieldValue {
                final long fieldID;
                final ValueImpl value;

                FieldValue(long l, ValueImpl valueImpl) {
                    this.fieldID = l;
                    this.value = valueImpl;
                }

                private void write(PacketStream packetStream) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     fieldID(long): " + this.fieldID);
                    }
                    packetStream.writeFieldRef(this.fieldID);
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     value(ValueImpl): " + this.value);
                    }
                    packetStream.writeUntaggedValue(this.value);
                }
            }
        }

        static class GetValues {
            static final int COMMAND = 2;
            final ValueImpl[] values;

            static GetValues process(VirtualMachineImpl virtualMachineImpl, ObjectReferenceImpl objectReferenceImpl, Field[] fieldArray) throws JDWPException {
                PacketStream packetStream = GetValues.enqueueCommand(virtualMachineImpl, objectReferenceImpl, fieldArray);
                return GetValues.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ObjectReferenceImpl objectReferenceImpl, Field[] fieldArray) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 9, 2);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ObjectReference.GetValues" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 object(ObjectReferenceImpl): " + (objectReferenceImpl == null ? "NULL" : "ref=" + objectReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(objectReferenceImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 fields(Field[]): ");
                }
                packetStream.writeInt(fieldArray.length);
                for (int i = 0; i < fieldArray.length; ++i) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     fields[i](Field): ");
                    }
                    fieldArray[i].write(packetStream);
                }
                packetStream.send();
                return packetStream;
            }

            static GetValues waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new GetValues(virtualMachineImpl, packetStream);
            }

            private GetValues(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ObjectReference.GetValues" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "values(ValueImpl[]): ");
                }
                int n = packetStream.readInt();
                this.values = new ValueImpl[n];
                for (int i = 0; i < n; ++i) {
                    this.values[i] = packetStream.readValue();
                    if (!virtualMachineImpl.traceReceives) continue;
                    virtualMachineImpl.printReceiveTrace(5, "values[" + i + "](ValueImpl): " + this.values[i]);
                }
            }

            static class Field {
                final long fieldID;

                Field(long l) {
                    this.fieldID = l;
                }

                private void write(PacketStream packetStream) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     fieldID(long): " + this.fieldID);
                    }
                    packetStream.writeFieldRef(this.fieldID);
                }
            }
        }

        static class ReferenceType {
            static final int COMMAND = 1;
            final byte refTypeTag;
            final long typeID;

            static ReferenceType process(VirtualMachineImpl virtualMachineImpl, ObjectReferenceImpl objectReferenceImpl) throws JDWPException {
                PacketStream packetStream = ReferenceType.enqueueCommand(virtualMachineImpl, objectReferenceImpl);
                return ReferenceType.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ObjectReferenceImpl objectReferenceImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 9, 1);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ObjectReference.ReferenceType" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 object(ObjectReferenceImpl): " + (objectReferenceImpl == null ? "NULL" : "ref=" + objectReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(objectReferenceImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static ReferenceType waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new ReferenceType(virtualMachineImpl, packetStream);
            }

            private ReferenceType(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ObjectReference.ReferenceType" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.refTypeTag = packetStream.readByte();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "refTypeTag(byte): " + this.refTypeTag);
                }
                this.typeID = packetStream.readClassRef();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "typeID(long): ref=" + this.typeID);
                }
            }
        }
    }

    static class Field {
        static final int COMMAND_SET = 8;

        private Field() {
        }
    }

    static class Method {
        static final int COMMAND_SET = 6;

        private Method() {
        }

        static class IsObsolete {
            static final int COMMAND = 4;
            final boolean isObsolete;

            static IsObsolete process(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl, long l) throws JDWPException {
                PacketStream packetStream = IsObsolete.enqueueCommand(virtualMachineImpl, referenceTypeImpl, l);
                return IsObsolete.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl, long l) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 6, 4);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.Method.IsObsolete" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (referenceTypeImpl == null ? "NULL" : "ref=" + referenceTypeImpl.ref()));
                }
                packetStream.writeClassRef(referenceTypeImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 methodID(long): " + l);
                }
                packetStream.writeMethodRef(l);
                packetStream.send();
                return packetStream;
            }

            static IsObsolete waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new IsObsolete(virtualMachineImpl, packetStream);
            }

            private IsObsolete(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.Method.IsObsolete" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.isObsolete = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "isObsolete(boolean): " + this.isObsolete);
                }
            }
        }

        static class Bytecodes {
            static final int COMMAND = 3;
            final byte[] bytes;

            static Bytecodes process(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl, long l) throws JDWPException {
                PacketStream packetStream = Bytecodes.enqueueCommand(virtualMachineImpl, referenceTypeImpl, l);
                return Bytecodes.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl, long l) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 6, 3);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.Method.Bytecodes" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (referenceTypeImpl == null ? "NULL" : "ref=" + referenceTypeImpl.ref()));
                }
                packetStream.writeClassRef(referenceTypeImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 methodID(long): " + l);
                }
                packetStream.writeMethodRef(l);
                packetStream.send();
                return packetStream;
            }

            static Bytecodes waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Bytecodes(virtualMachineImpl, packetStream);
            }

            private Bytecodes(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.Method.Bytecodes" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "bytes(byte[]): ");
                }
                int n = packetStream.readInt();
                this.bytes = new byte[n];
                for (int i = 0; i < n; ++i) {
                    this.bytes[i] = packetStream.readByte();
                    if (!virtualMachineImpl.traceReceives) continue;
                    virtualMachineImpl.printReceiveTrace(5, "bytes[" + i + "](byte): " + this.bytes[i]);
                }
            }
        }

        static class VariableTable {
            static final int COMMAND = 2;
            final int argCnt;
            final SlotInfo[] slots;

            static VariableTable process(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl, long l) throws JDWPException {
                PacketStream packetStream = VariableTable.enqueueCommand(virtualMachineImpl, referenceTypeImpl, l);
                return VariableTable.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl, long l) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 6, 2);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.Method.VariableTable" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (referenceTypeImpl == null ? "NULL" : "ref=" + referenceTypeImpl.ref()));
                }
                packetStream.writeClassRef(referenceTypeImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 methodID(long): " + l);
                }
                packetStream.writeMethodRef(l);
                packetStream.send();
                return packetStream;
            }

            static VariableTable waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new VariableTable(virtualMachineImpl, packetStream);
            }

            private VariableTable(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.Method.VariableTable" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.argCnt = packetStream.readInt();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "argCnt(int): " + this.argCnt);
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "slots(SlotInfo[]): ");
                }
                int n = packetStream.readInt();
                this.slots = new SlotInfo[n];
                for (int i = 0; i < n; ++i) {
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "slots[" + i + "](SlotInfo): " + "");
                    }
                    this.slots[i] = new SlotInfo(virtualMachineImpl, packetStream);
                }
            }

            static class SlotInfo {
                final long codeIndex;
                final String name;
                final String signature;
                final int length;
                final int slot;

                private SlotInfo(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                    this.codeIndex = packetStream.readLong();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "codeIndex(long): " + this.codeIndex);
                    }
                    this.name = packetStream.readString();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "name(String): " + this.name);
                    }
                    this.signature = packetStream.readString();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "signature(String): " + this.signature);
                    }
                    this.length = packetStream.readInt();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "length(int): " + this.length);
                    }
                    this.slot = packetStream.readInt();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "slot(int): " + this.slot);
                    }
                }
            }
        }

        static class LineTable {
            static final int COMMAND = 1;
            final long start;
            final long end;
            final LineInfo[] lines;

            static LineTable process(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl, long l) throws JDWPException {
                PacketStream packetStream = LineTable.enqueueCommand(virtualMachineImpl, referenceTypeImpl, l);
                return LineTable.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl, long l) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 6, 1);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.Method.LineTable" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (referenceTypeImpl == null ? "NULL" : "ref=" + referenceTypeImpl.ref()));
                }
                packetStream.writeClassRef(referenceTypeImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 methodID(long): " + l);
                }
                packetStream.writeMethodRef(l);
                packetStream.send();
                return packetStream;
            }

            static LineTable waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new LineTable(virtualMachineImpl, packetStream);
            }

            private LineTable(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.Method.LineTable" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.start = packetStream.readLong();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "start(long): " + this.start);
                }
                this.end = packetStream.readLong();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "end(long): " + this.end);
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "lines(LineInfo[]): ");
                }
                int n = packetStream.readInt();
                this.lines = new LineInfo[n];
                for (int i = 0; i < n; ++i) {
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "lines[" + i + "](LineInfo): " + "");
                    }
                    this.lines[i] = new LineInfo(virtualMachineImpl, packetStream);
                }
            }

            static class LineInfo {
                final long lineCodeIndex;
                final int lineNumber;

                private LineInfo(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                    this.lineCodeIndex = packetStream.readLong();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "lineCodeIndex(long): " + this.lineCodeIndex);
                    }
                    this.lineNumber = packetStream.readInt();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "lineNumber(int): " + this.lineNumber);
                    }
                }
            }
        }
    }

    static class InterfaceType {
        static final int COMMAND_SET = 5;

        private InterfaceType() {
        }
    }

    static class ArrayType {
        static final int COMMAND_SET = 4;

        private ArrayType() {
        }

        static class NewInstance {
            static final int COMMAND = 1;
            final ObjectReferenceImpl newArray;

            static NewInstance process(VirtualMachineImpl virtualMachineImpl, ArrayTypeImpl arrayTypeImpl, int n) throws JDWPException {
                PacketStream packetStream = NewInstance.enqueueCommand(virtualMachineImpl, arrayTypeImpl, n);
                return NewInstance.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ArrayTypeImpl arrayTypeImpl, int n) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 4, 1);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ArrayType.NewInstance" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 arrType(ArrayTypeImpl): " + (arrayTypeImpl == null ? "NULL" : "ref=" + arrayTypeImpl.ref()));
                }
                packetStream.writeClassRef(arrayTypeImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 length(int): " + n);
                }
                packetStream.writeInt(n);
                packetStream.send();
                return packetStream;
            }

            static NewInstance waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new NewInstance(virtualMachineImpl, packetStream);
            }

            private NewInstance(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ArrayType.NewInstance" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.newArray = packetStream.readTaggedObjectReference();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "newArray(ObjectReferenceImpl): " + (this.newArray == null ? "NULL" : "ref=" + this.newArray.ref()));
                }
            }
        }
    }

    static class ClassType {
        static final int COMMAND_SET = 3;

        private ClassType() {
        }

        static class NewInstance {
            static final int COMMAND = 4;
            final ObjectReferenceImpl newObject;
            final ObjectReferenceImpl exception;

            static NewInstance process(VirtualMachineImpl virtualMachineImpl, ClassTypeImpl classTypeImpl, ThreadReferenceImpl threadReferenceImpl, long l, ValueImpl[] valueImplArray, int n) throws JDWPException {
                PacketStream packetStream = NewInstance.enqueueCommand(virtualMachineImpl, classTypeImpl, threadReferenceImpl, l, valueImplArray, n);
                return NewInstance.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ClassTypeImpl classTypeImpl, ThreadReferenceImpl threadReferenceImpl, long l, ValueImpl[] valueImplArray, int n) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 3, 4);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ClassType.NewInstance" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 clazz(ClassTypeImpl): " + (classTypeImpl == null ? "NULL" : "ref=" + classTypeImpl.ref()));
                }
                packetStream.writeClassRef(classTypeImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (threadReferenceImpl == null ? "NULL" : "ref=" + threadReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadReferenceImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 methodID(long): " + l);
                }
                packetStream.writeMethodRef(l);
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 arguments(ValueImpl[]): ");
                }
                packetStream.writeInt(valueImplArray.length);
                for (int i = 0; i < valueImplArray.length; ++i) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     arguments[i](ValueImpl): " + valueImplArray[i]);
                    }
                    packetStream.writeValue(valueImplArray[i]);
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 options(int): " + n);
                }
                packetStream.writeInt(n);
                packetStream.send();
                return packetStream;
            }

            static NewInstance waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new NewInstance(virtualMachineImpl, packetStream);
            }

            private NewInstance(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ClassType.NewInstance" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.newObject = packetStream.readTaggedObjectReference();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "newObject(ObjectReferenceImpl): " + (this.newObject == null ? "NULL" : "ref=" + this.newObject.ref()));
                }
                this.exception = packetStream.readTaggedObjectReference();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "exception(ObjectReferenceImpl): " + (this.exception == null ? "NULL" : "ref=" + this.exception.ref()));
                }
            }
        }

        static class InvokeMethod {
            static final int COMMAND = 3;
            final ValueImpl returnValue;
            final ObjectReferenceImpl exception;

            static InvokeMethod process(VirtualMachineImpl virtualMachineImpl, ClassTypeImpl classTypeImpl, ThreadReferenceImpl threadReferenceImpl, long l, ValueImpl[] valueImplArray, int n) throws JDWPException {
                PacketStream packetStream = InvokeMethod.enqueueCommand(virtualMachineImpl, classTypeImpl, threadReferenceImpl, l, valueImplArray, n);
                return InvokeMethod.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ClassTypeImpl classTypeImpl, ThreadReferenceImpl threadReferenceImpl, long l, ValueImpl[] valueImplArray, int n) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 3, 3);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ClassType.InvokeMethod" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 clazz(ClassTypeImpl): " + (classTypeImpl == null ? "NULL" : "ref=" + classTypeImpl.ref()));
                }
                packetStream.writeClassRef(classTypeImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 thread(ThreadReferenceImpl): " + (threadReferenceImpl == null ? "NULL" : "ref=" + threadReferenceImpl.ref()));
                }
                packetStream.writeObjectRef(threadReferenceImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 methodID(long): " + l);
                }
                packetStream.writeMethodRef(l);
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 arguments(ValueImpl[]): ");
                }
                packetStream.writeInt(valueImplArray.length);
                for (int i = 0; i < valueImplArray.length; ++i) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     arguments[i](ValueImpl): " + valueImplArray[i]);
                    }
                    packetStream.writeValue(valueImplArray[i]);
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 options(int): " + n);
                }
                packetStream.writeInt(n);
                packetStream.send();
                return packetStream;
            }

            static InvokeMethod waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new InvokeMethod(virtualMachineImpl, packetStream);
            }

            private InvokeMethod(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ClassType.InvokeMethod" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.returnValue = packetStream.readValue();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "returnValue(ValueImpl): " + this.returnValue);
                }
                this.exception = packetStream.readTaggedObjectReference();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "exception(ObjectReferenceImpl): " + (this.exception == null ? "NULL" : "ref=" + this.exception.ref()));
                }
            }
        }

        static class SetValues {
            static final int COMMAND = 2;

            static SetValues process(VirtualMachineImpl virtualMachineImpl, ClassTypeImpl classTypeImpl, FieldValue[] fieldValueArray) throws JDWPException {
                PacketStream packetStream = SetValues.enqueueCommand(virtualMachineImpl, classTypeImpl, fieldValueArray);
                return SetValues.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ClassTypeImpl classTypeImpl, FieldValue[] fieldValueArray) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 3, 2);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ClassType.SetValues" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 clazz(ClassTypeImpl): " + (classTypeImpl == null ? "NULL" : "ref=" + classTypeImpl.ref()));
                }
                packetStream.writeClassRef(classTypeImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 values(FieldValue[]): ");
                }
                packetStream.writeInt(fieldValueArray.length);
                for (int i = 0; i < fieldValueArray.length; ++i) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     values[i](FieldValue): ");
                    }
                    fieldValueArray[i].write(packetStream);
                }
                packetStream.send();
                return packetStream;
            }

            static SetValues waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new SetValues(virtualMachineImpl, packetStream);
            }

            private SetValues(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ClassType.SetValues" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }

            static class FieldValue {
                final long fieldID;
                final ValueImpl value;

                FieldValue(long l, ValueImpl valueImpl) {
                    this.fieldID = l;
                    this.value = valueImpl;
                }

                private void write(PacketStream packetStream) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     fieldID(long): " + this.fieldID);
                    }
                    packetStream.writeFieldRef(this.fieldID);
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     value(ValueImpl): " + this.value);
                    }
                    packetStream.writeUntaggedValue(this.value);
                }
            }
        }

        static class Superclass {
            static final int COMMAND = 1;
            final ClassTypeImpl superclass;

            static Superclass process(VirtualMachineImpl virtualMachineImpl, ClassTypeImpl classTypeImpl) throws JDWPException {
                PacketStream packetStream = Superclass.enqueueCommand(virtualMachineImpl, classTypeImpl);
                return Superclass.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ClassTypeImpl classTypeImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 3, 1);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ClassType.Superclass" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 clazz(ClassTypeImpl): " + (classTypeImpl == null ? "NULL" : "ref=" + classTypeImpl.ref()));
                }
                packetStream.writeClassRef(classTypeImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static Superclass waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Superclass(virtualMachineImpl, packetStream);
            }

            private Superclass(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ClassType.Superclass" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.superclass = virtualMachineImpl.classType(packetStream.readClassRef());
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "superclass(ClassTypeImpl): " + (this.superclass == null ? "NULL" : "ref=" + this.superclass.ref()));
                }
            }
        }
    }

    static class ReferenceType {
        static final int COMMAND_SET = 2;

        private ReferenceType() {
        }

        static class SourceDebugExtension {
            static final int COMMAND = 12;
            final String extension;

            static SourceDebugExtension process(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) throws JDWPException {
                PacketStream packetStream = SourceDebugExtension.enqueueCommand(virtualMachineImpl, referenceTypeImpl);
                return SourceDebugExtension.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 2, 12);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.SourceDebugExtension" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (referenceTypeImpl == null ? "NULL" : "ref=" + referenceTypeImpl.ref()));
                }
                packetStream.writeClassRef(referenceTypeImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static SourceDebugExtension waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new SourceDebugExtension(virtualMachineImpl, packetStream);
            }

            private SourceDebugExtension(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.SourceDebugExtension" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.extension = packetStream.readString();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "extension(String): " + this.extension);
                }
            }
        }

        static class ClassObject {
            static final int COMMAND = 11;
            final ClassObjectReferenceImpl classObject;

            static ClassObject process(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) throws JDWPException {
                PacketStream packetStream = ClassObject.enqueueCommand(virtualMachineImpl, referenceTypeImpl);
                return ClassObject.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 2, 11);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.ClassObject" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (referenceTypeImpl == null ? "NULL" : "ref=" + referenceTypeImpl.ref()));
                }
                packetStream.writeClassRef(referenceTypeImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static ClassObject waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new ClassObject(virtualMachineImpl, packetStream);
            }

            private ClassObject(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.ClassObject" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.classObject = packetStream.readClassObjectReference();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "classObject(ClassObjectReferenceImpl): " + (this.classObject == null ? "NULL" : "ref=" + this.classObject.ref()));
                }
            }
        }

        static class Interfaces {
            static final int COMMAND = 10;
            final InterfaceTypeImpl[] interfaces;

            static Interfaces process(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) throws JDWPException {
                PacketStream packetStream = Interfaces.enqueueCommand(virtualMachineImpl, referenceTypeImpl);
                return Interfaces.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 2, 10);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.Interfaces" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (referenceTypeImpl == null ? "NULL" : "ref=" + referenceTypeImpl.ref()));
                }
                packetStream.writeClassRef(referenceTypeImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static Interfaces waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Interfaces(virtualMachineImpl, packetStream);
            }

            private Interfaces(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.Interfaces" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "interfaces(InterfaceTypeImpl[]): ");
                }
                int n = packetStream.readInt();
                this.interfaces = new InterfaceTypeImpl[n];
                for (int i = 0; i < n; ++i) {
                    this.interfaces[i] = virtualMachineImpl.interfaceType(packetStream.readClassRef());
                    if (!virtualMachineImpl.traceReceives) continue;
                    virtualMachineImpl.printReceiveTrace(5, "interfaces[" + i + "](InterfaceTypeImpl): " + (this.interfaces[i] == null ? "NULL" : "ref=" + this.interfaces[i].ref()));
                }
            }
        }

        static class Status {
            static final int COMMAND = 9;
            final int status;

            static Status process(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) throws JDWPException {
                PacketStream packetStream = Status.enqueueCommand(virtualMachineImpl, referenceTypeImpl);
                return Status.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 2, 9);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.Status" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (referenceTypeImpl == null ? "NULL" : "ref=" + referenceTypeImpl.ref()));
                }
                packetStream.writeClassRef(referenceTypeImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static Status waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Status(virtualMachineImpl, packetStream);
            }

            private Status(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.Status" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.status = packetStream.readInt();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "status(int): " + this.status);
                }
            }
        }

        static class NestedTypes {
            static final int COMMAND = 8;
            final TypeInfo[] classes;

            static NestedTypes process(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) throws JDWPException {
                PacketStream packetStream = NestedTypes.enqueueCommand(virtualMachineImpl, referenceTypeImpl);
                return NestedTypes.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 2, 8);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.NestedTypes" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (referenceTypeImpl == null ? "NULL" : "ref=" + referenceTypeImpl.ref()));
                }
                packetStream.writeClassRef(referenceTypeImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static NestedTypes waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new NestedTypes(virtualMachineImpl, packetStream);
            }

            private NestedTypes(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.NestedTypes" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "classes(TypeInfo[]): ");
                }
                int n = packetStream.readInt();
                this.classes = new TypeInfo[n];
                for (int i = 0; i < n; ++i) {
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "classes[" + i + "](TypeInfo): " + "");
                    }
                    this.classes[i] = new TypeInfo(virtualMachineImpl, packetStream);
                }
            }

            static class TypeInfo {
                final byte refTypeTag;
                final long typeID;

                private TypeInfo(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                    this.refTypeTag = packetStream.readByte();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "refTypeTag(byte): " + this.refTypeTag);
                    }
                    this.typeID = packetStream.readClassRef();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "typeID(long): ref=" + this.typeID);
                    }
                }
            }
        }

        static class SourceFile {
            static final int COMMAND = 7;
            final String sourceFile;

            static SourceFile process(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) throws JDWPException {
                PacketStream packetStream = SourceFile.enqueueCommand(virtualMachineImpl, referenceTypeImpl);
                return SourceFile.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 2, 7);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.SourceFile" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (referenceTypeImpl == null ? "NULL" : "ref=" + referenceTypeImpl.ref()));
                }
                packetStream.writeClassRef(referenceTypeImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static SourceFile waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new SourceFile(virtualMachineImpl, packetStream);
            }

            private SourceFile(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.SourceFile" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.sourceFile = packetStream.readString();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "sourceFile(String): " + this.sourceFile);
                }
            }
        }

        static class GetValues {
            static final int COMMAND = 6;
            final ValueImpl[] values;

            static GetValues process(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl, Field[] fieldArray) throws JDWPException {
                PacketStream packetStream = GetValues.enqueueCommand(virtualMachineImpl, referenceTypeImpl, fieldArray);
                return GetValues.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl, Field[] fieldArray) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 2, 6);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.GetValues" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (referenceTypeImpl == null ? "NULL" : "ref=" + referenceTypeImpl.ref()));
                }
                packetStream.writeClassRef(referenceTypeImpl.ref());
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 fields(Field[]): ");
                }
                packetStream.writeInt(fieldArray.length);
                for (int i = 0; i < fieldArray.length; ++i) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     fields[i](Field): ");
                    }
                    fieldArray[i].write(packetStream);
                }
                packetStream.send();
                return packetStream;
            }

            static GetValues waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new GetValues(virtualMachineImpl, packetStream);
            }

            private GetValues(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.GetValues" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "values(ValueImpl[]): ");
                }
                int n = packetStream.readInt();
                this.values = new ValueImpl[n];
                for (int i = 0; i < n; ++i) {
                    this.values[i] = packetStream.readValue();
                    if (!virtualMachineImpl.traceReceives) continue;
                    virtualMachineImpl.printReceiveTrace(5, "values[" + i + "](ValueImpl): " + this.values[i]);
                }
            }

            static class Field {
                final long fieldID;

                Field(long l) {
                    this.fieldID = l;
                }

                private void write(PacketStream packetStream) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     fieldID(long): " + this.fieldID);
                    }
                    packetStream.writeFieldRef(this.fieldID);
                }
            }
        }

        static class Methods {
            static final int COMMAND = 5;
            final MethodInfo[] declared;

            static Methods process(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) throws JDWPException {
                PacketStream packetStream = Methods.enqueueCommand(virtualMachineImpl, referenceTypeImpl);
                return Methods.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 2, 5);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.Methods" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (referenceTypeImpl == null ? "NULL" : "ref=" + referenceTypeImpl.ref()));
                }
                packetStream.writeClassRef(referenceTypeImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static Methods waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Methods(virtualMachineImpl, packetStream);
            }

            private Methods(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.Methods" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "declared(MethodInfo[]): ");
                }
                int n = packetStream.readInt();
                this.declared = new MethodInfo[n];
                for (int i = 0; i < n; ++i) {
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "declared[" + i + "](MethodInfo): " + "");
                    }
                    this.declared[i] = new MethodInfo(virtualMachineImpl, packetStream);
                }
            }

            static class MethodInfo {
                final long methodID;
                final String name;
                final String signature;
                final int modBits;

                private MethodInfo(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                    this.methodID = packetStream.readMethodRef();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "methodID(long): " + this.methodID);
                    }
                    this.name = packetStream.readString();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "name(String): " + this.name);
                    }
                    this.signature = packetStream.readString();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "signature(String): " + this.signature);
                    }
                    this.modBits = packetStream.readInt();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "modBits(int): " + this.modBits);
                    }
                }
            }
        }

        static class Fields {
            static final int COMMAND = 4;
            final FieldInfo[] declared;

            static Fields process(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) throws JDWPException {
                PacketStream packetStream = Fields.enqueueCommand(virtualMachineImpl, referenceTypeImpl);
                return Fields.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 2, 4);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.Fields" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (referenceTypeImpl == null ? "NULL" : "ref=" + referenceTypeImpl.ref()));
                }
                packetStream.writeClassRef(referenceTypeImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static Fields waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Fields(virtualMachineImpl, packetStream);
            }

            private Fields(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.Fields" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "declared(FieldInfo[]): ");
                }
                int n = packetStream.readInt();
                this.declared = new FieldInfo[n];
                for (int i = 0; i < n; ++i) {
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "declared[" + i + "](FieldInfo): " + "");
                    }
                    this.declared[i] = new FieldInfo(virtualMachineImpl, packetStream);
                }
            }

            static class FieldInfo {
                final long fieldID;
                final String name;
                final String signature;
                final int modBits;

                private FieldInfo(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                    this.fieldID = packetStream.readFieldRef();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "fieldID(long): " + this.fieldID);
                    }
                    this.name = packetStream.readString();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "name(String): " + this.name);
                    }
                    this.signature = packetStream.readString();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "signature(String): " + this.signature);
                    }
                    this.modBits = packetStream.readInt();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "modBits(int): " + this.modBits);
                    }
                }
            }
        }

        static class Modifiers {
            static final int COMMAND = 3;
            final int modBits;

            static Modifiers process(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) throws JDWPException {
                PacketStream packetStream = Modifiers.enqueueCommand(virtualMachineImpl, referenceTypeImpl);
                return Modifiers.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 2, 3);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.Modifiers" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (referenceTypeImpl == null ? "NULL" : "ref=" + referenceTypeImpl.ref()));
                }
                packetStream.writeClassRef(referenceTypeImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static Modifiers waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Modifiers(virtualMachineImpl, packetStream);
            }

            private Modifiers(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.Modifiers" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.modBits = packetStream.readInt();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "modBits(int): " + this.modBits);
                }
            }
        }

        static class ClassLoader {
            static final int COMMAND = 2;
            final ClassLoaderReferenceImpl classLoader;

            static ClassLoader process(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) throws JDWPException {
                PacketStream packetStream = ClassLoader.enqueueCommand(virtualMachineImpl, referenceTypeImpl);
                return ClassLoader.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 2, 2);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.ClassLoader" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (referenceTypeImpl == null ? "NULL" : "ref=" + referenceTypeImpl.ref()));
                }
                packetStream.writeClassRef(referenceTypeImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static ClassLoader waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new ClassLoader(virtualMachineImpl, packetStream);
            }

            private ClassLoader(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.ClassLoader" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.classLoader = packetStream.readClassLoaderReference();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "classLoader(ClassLoaderReferenceImpl): " + (this.classLoader == null ? "NULL" : "ref=" + this.classLoader.ref()));
                }
            }
        }

        static class Signature {
            static final int COMMAND = 1;
            final String signature;

            static Signature process(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) throws JDWPException {
                PacketStream packetStream = Signature.enqueueCommand(virtualMachineImpl, referenceTypeImpl);
                return Signature.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ReferenceTypeImpl referenceTypeImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 2, 1);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.Signature" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 refType(ReferenceTypeImpl): " + (referenceTypeImpl == null ? "NULL" : "ref=" + referenceTypeImpl.ref()));
                }
                packetStream.writeClassRef(referenceTypeImpl.ref());
                packetStream.send();
                return packetStream;
            }

            static Signature waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Signature(virtualMachineImpl, packetStream);
            }

            private Signature(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.ReferenceType.Signature" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.signature = packetStream.readString();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "signature(String): " + this.signature);
                }
            }
        }
    }

    static class VirtualMachine {
        static final int COMMAND_SET = 1;

        private VirtualMachine() {
        }

        static class SetDefaultStratum {
            static final int COMMAND = 19;

            static SetDefaultStratum process(VirtualMachineImpl virtualMachineImpl, String string) throws JDWPException {
                PacketStream packetStream = SetDefaultStratum.enqueueCommand(virtualMachineImpl, string);
                return SetDefaultStratum.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, String string) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 1, 19);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.SetDefaultStratum" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 stratumID(String): " + string);
                }
                packetStream.writeString(string);
                packetStream.send();
                return packetStream;
            }

            static SetDefaultStratum waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new SetDefaultStratum(virtualMachineImpl, packetStream);
            }

            private SetDefaultStratum(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.SetDefaultStratum" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }
        }

        static class RedefineClasses {
            static final int COMMAND = 18;

            static RedefineClasses process(VirtualMachineImpl virtualMachineImpl, ClassDef[] classDefArray) throws JDWPException {
                PacketStream packetStream = RedefineClasses.enqueueCommand(virtualMachineImpl, classDefArray);
                return RedefineClasses.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, ClassDef[] classDefArray) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 1, 18);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.RedefineClasses" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 classes(ClassDef[]): ");
                }
                packetStream.writeInt(classDefArray.length);
                for (int i = 0; i < classDefArray.length; ++i) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     classes[i](ClassDef): ");
                    }
                    classDefArray[i].write(packetStream);
                }
                packetStream.send();
                return packetStream;
            }

            static RedefineClasses waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new RedefineClasses(virtualMachineImpl, packetStream);
            }

            private RedefineClasses(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.RedefineClasses" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }

            static class ClassDef {
                final ReferenceTypeImpl refType;
                final byte[] classfile;

                ClassDef(ReferenceTypeImpl referenceTypeImpl, byte[] byArray) {
                    this.refType = referenceTypeImpl;
                    this.classfile = byArray;
                }

                private void write(PacketStream packetStream) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     refType(ReferenceTypeImpl): " + (this.refType == null ? "NULL" : "ref=" + this.refType.ref()));
                    }
                    packetStream.writeClassRef(this.refType.ref());
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     classfile(byte[]): ");
                    }
                    packetStream.writeInt(this.classfile.length);
                    for (int i = 0; i < this.classfile.length; ++i) {
                        if ((packetStream.vm.traceFlags & 1) != 0) {
                            packetStream.vm.printTrace("Sending:                         classfile[i](byte): " + this.classfile[i]);
                        }
                        packetStream.writeByte(this.classfile[i]);
                    }
                }
            }
        }

        static class CapabilitiesNew {
            static final int COMMAND = 17;
            final boolean canWatchFieldModification;
            final boolean canWatchFieldAccess;
            final boolean canGetBytecodes;
            final boolean canGetSyntheticAttribute;
            final boolean canGetOwnedMonitorInfo;
            final boolean canGetCurrentContendedMonitor;
            final boolean canGetMonitorInfo;
            final boolean canRedefineClasses;
            final boolean canAddMethod;
            final boolean canUnrestrictedlyRedefineClasses;
            final boolean canPopFrames;
            final boolean canUseInstanceFilters;
            final boolean canGetSourceDebugExtension;
            final boolean canRequestVMDeathEvent;
            final boolean canSetDefaultStratum;
            final boolean reserved16;
            final boolean reserved17;
            final boolean reserved18;
            final boolean reserved19;
            final boolean reserved20;
            final boolean reserved21;
            final boolean reserved22;
            final boolean reserved23;
            final boolean reserved24;
            final boolean reserved25;
            final boolean reserved26;
            final boolean reserved27;
            final boolean reserved28;
            final boolean reserved29;
            final boolean reserved30;
            final boolean reserved31;
            final boolean reserved32;

            static CapabilitiesNew process(VirtualMachineImpl virtualMachineImpl) throws JDWPException {
                PacketStream packetStream = CapabilitiesNew.enqueueCommand(virtualMachineImpl);
                return CapabilitiesNew.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 1, 17);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.CapabilitiesNew" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                packetStream.send();
                return packetStream;
            }

            static CapabilitiesNew waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new CapabilitiesNew(virtualMachineImpl, packetStream);
            }

            private CapabilitiesNew(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.CapabilitiesNew" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.canWatchFieldModification = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "canWatchFieldModification(boolean): " + this.canWatchFieldModification);
                }
                this.canWatchFieldAccess = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "canWatchFieldAccess(boolean): " + this.canWatchFieldAccess);
                }
                this.canGetBytecodes = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "canGetBytecodes(boolean): " + this.canGetBytecodes);
                }
                this.canGetSyntheticAttribute = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "canGetSyntheticAttribute(boolean): " + this.canGetSyntheticAttribute);
                }
                this.canGetOwnedMonitorInfo = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "canGetOwnedMonitorInfo(boolean): " + this.canGetOwnedMonitorInfo);
                }
                this.canGetCurrentContendedMonitor = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "canGetCurrentContendedMonitor(boolean): " + this.canGetCurrentContendedMonitor);
                }
                this.canGetMonitorInfo = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "canGetMonitorInfo(boolean): " + this.canGetMonitorInfo);
                }
                this.canRedefineClasses = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "canRedefineClasses(boolean): " + this.canRedefineClasses);
                }
                this.canAddMethod = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "canAddMethod(boolean): " + this.canAddMethod);
                }
                this.canUnrestrictedlyRedefineClasses = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "canUnrestrictedlyRedefineClasses(boolean): " + this.canUnrestrictedlyRedefineClasses);
                }
                this.canPopFrames = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "canPopFrames(boolean): " + this.canPopFrames);
                }
                this.canUseInstanceFilters = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "canUseInstanceFilters(boolean): " + this.canUseInstanceFilters);
                }
                this.canGetSourceDebugExtension = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "canGetSourceDebugExtension(boolean): " + this.canGetSourceDebugExtension);
                }
                this.canRequestVMDeathEvent = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "canRequestVMDeathEvent(boolean): " + this.canRequestVMDeathEvent);
                }
                this.canSetDefaultStratum = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "canSetDefaultStratum(boolean): " + this.canSetDefaultStratum);
                }
                this.reserved16 = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "reserved16(boolean): " + this.reserved16);
                }
                this.reserved17 = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "reserved17(boolean): " + this.reserved17);
                }
                this.reserved18 = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "reserved18(boolean): " + this.reserved18);
                }
                this.reserved19 = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "reserved19(boolean): " + this.reserved19);
                }
                this.reserved20 = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "reserved20(boolean): " + this.reserved20);
                }
                this.reserved21 = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "reserved21(boolean): " + this.reserved21);
                }
                this.reserved22 = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "reserved22(boolean): " + this.reserved22);
                }
                this.reserved23 = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "reserved23(boolean): " + this.reserved23);
                }
                this.reserved24 = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "reserved24(boolean): " + this.reserved24);
                }
                this.reserved25 = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "reserved25(boolean): " + this.reserved25);
                }
                this.reserved26 = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "reserved26(boolean): " + this.reserved26);
                }
                this.reserved27 = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "reserved27(boolean): " + this.reserved27);
                }
                this.reserved28 = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "reserved28(boolean): " + this.reserved28);
                }
                this.reserved29 = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "reserved29(boolean): " + this.reserved29);
                }
                this.reserved30 = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "reserved30(boolean): " + this.reserved30);
                }
                this.reserved31 = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "reserved31(boolean): " + this.reserved31);
                }
                this.reserved32 = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "reserved32(boolean): " + this.reserved32);
                }
            }
        }

        static class ReleaseEvents {
            static final int COMMAND = 16;

            static ReleaseEvents process(VirtualMachineImpl virtualMachineImpl) throws JDWPException {
                PacketStream packetStream = ReleaseEvents.enqueueCommand(virtualMachineImpl);
                return ReleaseEvents.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 1, 16);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.ReleaseEvents" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                packetStream.send();
                return packetStream;
            }

            static ReleaseEvents waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new ReleaseEvents(virtualMachineImpl, packetStream);
            }

            private ReleaseEvents(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.ReleaseEvents" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }
        }

        static class HoldEvents {
            static final int COMMAND = 15;

            static HoldEvents process(VirtualMachineImpl virtualMachineImpl) throws JDWPException {
                PacketStream packetStream = HoldEvents.enqueueCommand(virtualMachineImpl);
                return HoldEvents.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 1, 15);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.HoldEvents" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                packetStream.send();
                return packetStream;
            }

            static HoldEvents waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new HoldEvents(virtualMachineImpl, packetStream);
            }

            private HoldEvents(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.HoldEvents" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }
        }

        static class DisposeObjects {
            static final int COMMAND = 14;

            static DisposeObjects process(VirtualMachineImpl virtualMachineImpl, Request[] requestArray) throws JDWPException {
                PacketStream packetStream = DisposeObjects.enqueueCommand(virtualMachineImpl, requestArray);
                return DisposeObjects.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, Request[] requestArray) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 1, 14);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.DisposeObjects" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 requests(Request[]): ");
                }
                packetStream.writeInt(requestArray.length);
                for (int i = 0; i < requestArray.length; ++i) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     requests[i](Request): ");
                    }
                    requestArray[i].write(packetStream);
                }
                packetStream.send();
                return packetStream;
            }

            static DisposeObjects waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new DisposeObjects(virtualMachineImpl, packetStream);
            }

            private DisposeObjects(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.DisposeObjects" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }

            static class Request {
                final ObjectReferenceImpl object;
                final int refCnt;

                Request(ObjectReferenceImpl objectReferenceImpl, int n) {
                    this.object = objectReferenceImpl;
                    this.refCnt = n;
                }

                private void write(PacketStream packetStream) {
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     object(ObjectReferenceImpl): " + (this.object == null ? "NULL" : "ref=" + this.object.ref()));
                    }
                    packetStream.writeObjectRef(this.object.ref());
                    if ((packetStream.vm.traceFlags & 1) != 0) {
                        packetStream.vm.printTrace("Sending:                     refCnt(int): " + this.refCnt);
                    }
                    packetStream.writeInt(this.refCnt);
                }
            }
        }

        static class ClassPaths {
            static final int COMMAND = 13;
            final String baseDir;
            final String[] classpaths;
            final String[] bootclasspaths;

            static ClassPaths process(VirtualMachineImpl virtualMachineImpl) throws JDWPException {
                PacketStream packetStream = ClassPaths.enqueueCommand(virtualMachineImpl);
                return ClassPaths.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 1, 13);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.ClassPaths" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                packetStream.send();
                return packetStream;
            }

            static ClassPaths waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new ClassPaths(virtualMachineImpl, packetStream);
            }

            private ClassPaths(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                int n;
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.ClassPaths" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.baseDir = packetStream.readString();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "baseDir(String): " + this.baseDir);
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "classpaths(String[]): ");
                }
                int n2 = packetStream.readInt();
                this.classpaths = new String[n2];
                for (n = 0; n < n2; ++n) {
                    this.classpaths[n] = packetStream.readString();
                    if (!virtualMachineImpl.traceReceives) continue;
                    virtualMachineImpl.printReceiveTrace(5, "classpaths[" + n + "](String): " + this.classpaths[n]);
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "bootclasspaths(String[]): ");
                }
                n = packetStream.readInt();
                this.bootclasspaths = new String[n];
                for (int i = 0; i < n; ++i) {
                    this.bootclasspaths[i] = packetStream.readString();
                    if (!virtualMachineImpl.traceReceives) continue;
                    virtualMachineImpl.printReceiveTrace(5, "bootclasspaths[" + i + "](String): " + this.bootclasspaths[i]);
                }
            }
        }

        static class Capabilities {
            static final int COMMAND = 12;
            final boolean canWatchFieldModification;
            final boolean canWatchFieldAccess;
            final boolean canGetBytecodes;
            final boolean canGetSyntheticAttribute;
            final boolean canGetOwnedMonitorInfo;
            final boolean canGetCurrentContendedMonitor;
            final boolean canGetMonitorInfo;

            static Capabilities process(VirtualMachineImpl virtualMachineImpl) throws JDWPException {
                PacketStream packetStream = Capabilities.enqueueCommand(virtualMachineImpl);
                return Capabilities.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 1, 12);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.Capabilities" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                packetStream.send();
                return packetStream;
            }

            static Capabilities waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Capabilities(virtualMachineImpl, packetStream);
            }

            private Capabilities(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.Capabilities" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.canWatchFieldModification = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "canWatchFieldModification(boolean): " + this.canWatchFieldModification);
                }
                this.canWatchFieldAccess = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "canWatchFieldAccess(boolean): " + this.canWatchFieldAccess);
                }
                this.canGetBytecodes = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "canGetBytecodes(boolean): " + this.canGetBytecodes);
                }
                this.canGetSyntheticAttribute = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "canGetSyntheticAttribute(boolean): " + this.canGetSyntheticAttribute);
                }
                this.canGetOwnedMonitorInfo = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "canGetOwnedMonitorInfo(boolean): " + this.canGetOwnedMonitorInfo);
                }
                this.canGetCurrentContendedMonitor = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "canGetCurrentContendedMonitor(boolean): " + this.canGetCurrentContendedMonitor);
                }
                this.canGetMonitorInfo = packetStream.readBoolean();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "canGetMonitorInfo(boolean): " + this.canGetMonitorInfo);
                }
            }
        }

        static class CreateString {
            static final int COMMAND = 11;
            final StringReferenceImpl stringObject;

            static CreateString process(VirtualMachineImpl virtualMachineImpl, String string) throws JDWPException {
                PacketStream packetStream = CreateString.enqueueCommand(virtualMachineImpl, string);
                return CreateString.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, String string) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 1, 11);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.CreateString" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 utf(String): " + string);
                }
                packetStream.writeString(string);
                packetStream.send();
                return packetStream;
            }

            static CreateString waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new CreateString(virtualMachineImpl, packetStream);
            }

            private CreateString(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.CreateString" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.stringObject = packetStream.readStringReference();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "stringObject(StringReferenceImpl): " + (this.stringObject == null ? "NULL" : "ref=" + this.stringObject.ref()));
                }
            }
        }

        static class Exit {
            static final int COMMAND = 10;

            static Exit process(VirtualMachineImpl virtualMachineImpl, int n) throws JDWPException {
                PacketStream packetStream = Exit.enqueueCommand(virtualMachineImpl, n);
                return Exit.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, int n) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 1, 10);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.Exit" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 exitCode(int): " + n);
                }
                packetStream.writeInt(n);
                packetStream.send();
                return packetStream;
            }

            static Exit waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Exit(virtualMachineImpl, packetStream);
            }

            private Exit(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.Exit" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }
        }

        static class Resume {
            static final int COMMAND = 9;

            static Resume process(VirtualMachineImpl virtualMachineImpl) throws JDWPException {
                PacketStream packetStream = Resume.enqueueCommand(virtualMachineImpl);
                return Resume.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 1, 9);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.Resume" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                packetStream.send();
                return packetStream;
            }

            static Resume waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Resume(virtualMachineImpl, packetStream);
            }

            private Resume(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.Resume" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }
        }

        static class Suspend {
            static final int COMMAND = 8;

            static Suspend process(VirtualMachineImpl virtualMachineImpl) throws JDWPException {
                PacketStream packetStream = Suspend.enqueueCommand(virtualMachineImpl);
                return Suspend.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 1, 8);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.Suspend" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                packetStream.send();
                return packetStream;
            }

            static Suspend waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Suspend(virtualMachineImpl, packetStream);
            }

            private Suspend(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.Suspend" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }
        }

        static class IDSizes {
            static final int COMMAND = 7;
            final int fieldIDSize;
            final int methodIDSize;
            final int objectIDSize;
            final int referenceTypeIDSize;
            final int frameIDSize;

            static IDSizes process(VirtualMachineImpl virtualMachineImpl) throws JDWPException {
                PacketStream packetStream = IDSizes.enqueueCommand(virtualMachineImpl);
                return IDSizes.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 1, 7);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.IDSizes" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                packetStream.send();
                return packetStream;
            }

            static IDSizes waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new IDSizes(virtualMachineImpl, packetStream);
            }

            private IDSizes(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.IDSizes" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.fieldIDSize = packetStream.readInt();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "fieldIDSize(int): " + this.fieldIDSize);
                }
                this.methodIDSize = packetStream.readInt();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "methodIDSize(int): " + this.methodIDSize);
                }
                this.objectIDSize = packetStream.readInt();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "objectIDSize(int): " + this.objectIDSize);
                }
                this.referenceTypeIDSize = packetStream.readInt();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "referenceTypeIDSize(int): " + this.referenceTypeIDSize);
                }
                this.frameIDSize = packetStream.readInt();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "frameIDSize(int): " + this.frameIDSize);
                }
            }
        }

        static class Dispose {
            static final int COMMAND = 6;

            static Dispose process(VirtualMachineImpl virtualMachineImpl) throws JDWPException {
                PacketStream packetStream = Dispose.enqueueCommand(virtualMachineImpl);
                return Dispose.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 1, 6);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.Dispose" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                packetStream.send();
                return packetStream;
            }

            static Dispose waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Dispose(virtualMachineImpl, packetStream);
            }

            private Dispose(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.Dispose" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
            }
        }

        static class TopLevelThreadGroups {
            static final int COMMAND = 5;
            final ThreadGroupReferenceImpl[] groups;

            static TopLevelThreadGroups process(VirtualMachineImpl virtualMachineImpl) throws JDWPException {
                PacketStream packetStream = TopLevelThreadGroups.enqueueCommand(virtualMachineImpl);
                return TopLevelThreadGroups.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 1, 5);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.TopLevelThreadGroups" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                packetStream.send();
                return packetStream;
            }

            static TopLevelThreadGroups waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new TopLevelThreadGroups(virtualMachineImpl, packetStream);
            }

            private TopLevelThreadGroups(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.TopLevelThreadGroups" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "groups(ThreadGroupReferenceImpl[]): ");
                }
                int n = packetStream.readInt();
                this.groups = new ThreadGroupReferenceImpl[n];
                for (int i = 0; i < n; ++i) {
                    this.groups[i] = packetStream.readThreadGroupReference();
                    if (!virtualMachineImpl.traceReceives) continue;
                    virtualMachineImpl.printReceiveTrace(5, "groups[" + i + "](ThreadGroupReferenceImpl): " + (this.groups[i] == null ? "NULL" : "ref=" + this.groups[i].ref()));
                }
            }
        }

        static class AllThreads {
            static final int COMMAND = 4;
            final ThreadReferenceImpl[] threads;

            static AllThreads process(VirtualMachineImpl virtualMachineImpl) throws JDWPException {
                PacketStream packetStream = AllThreads.enqueueCommand(virtualMachineImpl);
                return AllThreads.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 1, 4);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.AllThreads" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                packetStream.send();
                return packetStream;
            }

            static AllThreads waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new AllThreads(virtualMachineImpl, packetStream);
            }

            private AllThreads(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.AllThreads" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "threads(ThreadReferenceImpl[]): ");
                }
                int n = packetStream.readInt();
                this.threads = new ThreadReferenceImpl[n];
                for (int i = 0; i < n; ++i) {
                    this.threads[i] = packetStream.readThreadReference();
                    if (!virtualMachineImpl.traceReceives) continue;
                    virtualMachineImpl.printReceiveTrace(5, "threads[" + i + "](ThreadReferenceImpl): " + (this.threads[i] == null ? "NULL" : "ref=" + this.threads[i].ref()));
                }
            }
        }

        static class AllClasses {
            static final int COMMAND = 3;
            final ClassInfo[] classes;

            static AllClasses process(VirtualMachineImpl virtualMachineImpl) throws JDWPException {
                PacketStream packetStream = AllClasses.enqueueCommand(virtualMachineImpl);
                return AllClasses.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 1, 3);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.AllClasses" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                packetStream.send();
                return packetStream;
            }

            static AllClasses waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new AllClasses(virtualMachineImpl, packetStream);
            }

            private AllClasses(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.AllClasses" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "classes(ClassInfo[]): ");
                }
                int n = packetStream.readInt();
                this.classes = new ClassInfo[n];
                for (int i = 0; i < n; ++i) {
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "classes[" + i + "](ClassInfo): " + "");
                    }
                    this.classes[i] = new ClassInfo(virtualMachineImpl, packetStream);
                }
            }

            static class ClassInfo {
                final byte refTypeTag;
                final long typeID;
                final String signature;
                final int status;

                private ClassInfo(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                    this.refTypeTag = packetStream.readByte();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "refTypeTag(byte): " + this.refTypeTag);
                    }
                    this.typeID = packetStream.readClassRef();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "typeID(long): ref=" + this.typeID);
                    }
                    this.signature = packetStream.readString();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "signature(String): " + this.signature);
                    }
                    this.status = packetStream.readInt();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "status(int): " + this.status);
                    }
                }
            }
        }

        static class ClassesBySignature {
            static final int COMMAND = 2;
            final ClassInfo[] classes;

            static ClassesBySignature process(VirtualMachineImpl virtualMachineImpl, String string) throws JDWPException {
                PacketStream packetStream = ClassesBySignature.enqueueCommand(virtualMachineImpl, string);
                return ClassesBySignature.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl, String string) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 1, 2);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.ClassesBySignature" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                if ((packetStream.vm.traceFlags & 1) != 0) {
                    packetStream.vm.printTrace("Sending:                 signature(String): " + string);
                }
                packetStream.writeString(string);
                packetStream.send();
                return packetStream;
            }

            static ClassesBySignature waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new ClassesBySignature(virtualMachineImpl, packetStream);
            }

            private ClassesBySignature(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.ClassesBySignature" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "classes(ClassInfo[]): ");
                }
                int n = packetStream.readInt();
                this.classes = new ClassInfo[n];
                for (int i = 0; i < n; ++i) {
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "classes[" + i + "](ClassInfo): " + "");
                    }
                    this.classes[i] = new ClassInfo(virtualMachineImpl, packetStream);
                }
            }

            static class ClassInfo {
                final byte refTypeTag;
                final long typeID;
                final int status;

                private ClassInfo(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                    this.refTypeTag = packetStream.readByte();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "refTypeTag(byte): " + this.refTypeTag);
                    }
                    this.typeID = packetStream.readClassRef();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "typeID(long): ref=" + this.typeID);
                    }
                    this.status = packetStream.readInt();
                    if (virtualMachineImpl.traceReceives) {
                        virtualMachineImpl.printReceiveTrace(5, "status(int): " + this.status);
                    }
                }
            }
        }

        static class Version {
            static final int COMMAND = 1;
            final String description;
            final int jdwpMajor;
            final int jdwpMinor;
            final String vmVersion;
            final String vmName;

            static Version process(VirtualMachineImpl virtualMachineImpl) throws JDWPException {
                PacketStream packetStream = Version.enqueueCommand(virtualMachineImpl);
                return Version.waitForReply(virtualMachineImpl, packetStream);
            }

            static PacketStream enqueueCommand(VirtualMachineImpl virtualMachineImpl) {
                PacketStream packetStream = new PacketStream(virtualMachineImpl, 1, 1);
                if ((virtualMachineImpl.traceFlags & 1) != 0) {
                    virtualMachineImpl.printTrace("Sending Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.Version" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : ""));
                }
                packetStream.send();
                return packetStream;
            }

            static Version waitForReply(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) throws JDWPException {
                packetStream.waitForReply();
                return new Version(virtualMachineImpl, packetStream);
            }

            private Version(VirtualMachineImpl virtualMachineImpl, PacketStream packetStream) {
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printTrace("Receiving Command(id=" + packetStream.pkt.id + ") JDWP.VirtualMachine.Version" + (packetStream.pkt.flags != 0 ? ", FLAGS=" + packetStream.pkt.flags : "") + (packetStream.pkt.errorCode != 0 ? ", ERROR CODE=" + packetStream.pkt.errorCode : ""));
                }
                this.description = packetStream.readString();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "description(String): " + this.description);
                }
                this.jdwpMajor = packetStream.readInt();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "jdwpMajor(int): " + this.jdwpMajor);
                }
                this.jdwpMinor = packetStream.readInt();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "jdwpMinor(int): " + this.jdwpMinor);
                }
                this.vmVersion = packetStream.readString();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "vmVersion(String): " + this.vmVersion);
                }
                this.vmName = packetStream.readString();
                if (virtualMachineImpl.traceReceives) {
                    virtualMachineImpl.printReceiveTrace(4, "vmName(String): " + this.vmName);
                }
            }
        }
    }
}

