/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.v8.code;

import com.sun.tools.javac.v8.util.Context;
import com.sun.tools.javac.v8.util.Hashtable;
import com.sun.tools.javac.v8.util.Options;

public final class Target {
    private static final Context.Key targetKey = new Context.Key();
    private static Target MIN;
    private static Target MAX;
    private static int nextOrdinal;
    private static final Hashtable tab;
    public final int ordinal = nextOrdinal++;
    public final String name;
    public final int majorVersion;
    public final int minorVersion;
    public static final Target JDK1_1;
    public static final Target JDK1_2;
    public static final Target JDK1_3;
    public static final Target JDK1_4;
    public static final Target JDK1_4_1;
    public static final Target JDK1_4_2;
    public static final Target DEFAULT;

    public static Target instance(Context context) {
        Target target = (Target)context.get(targetKey);
        if (target == null) {
            Options options = Options.instance(context);
            String string = (String)options.get("-target");
            if (string != null) {
                target = Target.lookup(string);
            }
            if (target == null) {
                target = DEFAULT;
            }
            context.put(targetKey, target);
        }
        return target;
    }

    public static Target MIN() {
        return MIN;
    }

    public static Target MAX() {
        return MAX;
    }

    private Target(String string, int n, int n2) {
        this.name = string;
        this.majorVersion = n;
        this.minorVersion = n2;
        tab.put(string, this);
        if (MIN == null) {
            MIN = this;
        }
        MAX = this;
    }

    public static Target lookup(String string) {
        return (Target)tab.get(string);
    }

    public boolean requiresIproxy() {
        return this.ordinal <= Target.JDK1_1.ordinal;
    }

    public boolean initializeFieldsBeforeSuper() {
        return this.ordinal >= Target.JDK1_4.ordinal;
    }

    public boolean obeyBinaryCompatibility() {
        return this.ordinal >= Target.JDK1_2.ordinal;
    }

    public boolean arrayBinaryCompatibility() {
        return this.ordinal > Target.JDK1_4.ordinal;
    }

    public boolean interfaceFieldsBinaryCompatibility() {
        return this.ordinal > Target.JDK1_2.ordinal;
    }

    public boolean interfaceObjectOverridesBinaryCompatibility() {
        return this.ordinal > Target.JDK1_4.ordinal;
    }

    static {
        nextOrdinal = 0;
        tab = new Hashtable();
        JDK1_1 = new Target("1.1", 45, 3);
        JDK1_2 = new Target("1.2", 46, 0);
        JDK1_3 = new Target("1.3", 47, 0);
        JDK1_4 = new Target("1.4", 48, 0);
        JDK1_4_1 = new Target("1.4.1", 48, 0);
        JDK1_4_2 = new Target("1.4.2", 48, 0);
        DEFAULT = JDK1_2;
    }
}

