/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.tty;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.event.ModificationWatchpointEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.event.WatchpointEvent;
import com.sun.tools.example.debug.tty.Commands;
import com.sun.tools.example.debug.tty.Env;
import com.sun.tools.example.debug.tty.EventHandler;
import com.sun.tools.example.debug.tty.EventNotifier;
import com.sun.tools.example.debug.tty.MessageOutput;
import com.sun.tools.example.debug.tty.ThreadInfo;
import com.sun.tools.example.debug.tty.VMNotConnectedException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class TTY
implements EventNotifier {
    EventHandler handler = null;
    private List monitorCommands = new ArrayList();
    private int monitorCount = 0;
    private static final String progname = "jdb";
    private static final long version = 1019270533724L;
    private String[] disconnectCmds = new String[]{"run", "catch", "ignore", "stop", "clear", "watch", "unwatch", "use", "sourcepath", "quit", "exit", "help", "?", "read", "version", "exclude"};

    public void vmStartEvent(VMStartEvent vMStartEvent) {
        Thread.yield();
        MessageOutput.lnprint("VM Started:");
    }

    public void vmDeathEvent(VMDeathEvent vMDeathEvent) {
    }

    public void vmDisconnectEvent(VMDisconnectEvent vMDisconnectEvent) {
    }

    public void threadStartEvent(ThreadStartEvent threadStartEvent) {
    }

    public void threadDeathEvent(ThreadDeathEvent threadDeathEvent) {
    }

    public void classPrepareEvent(ClassPrepareEvent classPrepareEvent) {
    }

    public void classUnloadEvent(ClassUnloadEvent classUnloadEvent) {
    }

    public void breakpointEvent(BreakpointEvent breakpointEvent) {
        Thread.yield();
        MessageOutput.lnprint("Breakpoint hit:");
    }

    public void fieldWatchEvent(WatchpointEvent watchpointEvent) {
        Field field = watchpointEvent.field();
        ObjectReference objectReference = watchpointEvent.object();
        Thread.yield();
        if (watchpointEvent instanceof ModificationWatchpointEvent) {
            MessageOutput.lnprint("Field access encountered before after", new Object[]{field, watchpointEvent.valueCurrent(), ((ModificationWatchpointEvent)watchpointEvent).valueToBe()});
        } else {
            MessageOutput.lnprint("Field access encountered", field.toString());
        }
    }

    public void stepEvent(StepEvent stepEvent) {
        Thread.yield();
        MessageOutput.lnprint("Step completed:");
    }

    public void exceptionEvent(ExceptionEvent exceptionEvent) {
        Thread.yield();
        Location location = exceptionEvent.catchLocation();
        if (location == null) {
            MessageOutput.lnprint("Exception occurred uncaught", exceptionEvent.exception().referenceType().name());
        } else {
            MessageOutput.lnprint("Exception occurred caught", new Object[]{exceptionEvent.exception().referenceType().name(), Commands.locationString(location)});
        }
    }

    public void methodEntryEvent(MethodEntryEvent methodEntryEvent) {
        Thread.yield();
        MessageOutput.lnprint("Method entered:", new Object[]{methodEntryEvent.method().declaringType().name(), methodEntryEvent.method().name()});
    }

    public void methodExitEvent(MethodExitEvent methodExitEvent) {
        Thread.yield();
        MessageOutput.lnprint("Method exited:", new Object[]{methodExitEvent.method().declaringType().name(), methodExitEvent.method().name()});
    }

    public void vmInterrupted() {
        ThreadInfo threadInfo = ThreadInfo.current;
        Thread.yield();
        this.printCurrentLocation(threadInfo);
        Iterator iterator = this.monitorCommands.iterator();
        while (iterator.hasNext()) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)iterator.next());
            stringTokenizer.nextToken();
            this.executeCommand(stringTokenizer);
        }
        MessageOutput.printPrompt();
    }

    public void receivedEvent(Event event) {
    }

    private void printCurrentLocation() {
        ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
        this.printCurrentLocation(threadInfo);
    }

    private void printCurrentLocation(ThreadInfo threadInfo) {
        StackFrame stackFrame;
        try {
            stackFrame = threadInfo.getCurrentFrame();
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            MessageOutput.println("<location unavailable>");
            return;
        }
        if (stackFrame == null) {
            MessageOutput.println("No frames on the current call stack");
        } else {
            Location location = stackFrame.location();
            MessageOutput.println("location", new Object[]{threadInfo.getThread().name(), Commands.locationString(location)});
            if (location.lineNumber() != -1) {
                String string;
                try {
                    string = Env.sourceLine(location, location.lineNumber());
                }
                catch (IOException iOException) {
                    string = null;
                }
                if (string != null) {
                    MessageOutput.println("source line number and line", new Object[]{new Integer(location.lineNumber()), string});
                }
            }
        }
        MessageOutput.println();
    }

    void help() {
        MessageOutput.println("zz help text");
    }

    private boolean isDisconnectCmd(String string) {
        for (int i = 0; i < this.disconnectCmds.length; ++i) {
            if (!this.disconnectCmds[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    void executeCommand(StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken().toLowerCase();
        Commands commands = new Commands();
        boolean bl = true;
        if (!Env.connection().isOpen() && !this.isDisconnectCmd(string)) {
            MessageOutput.println("Command not valid until the VM is started with the run command", string);
        } else {
            try {
                if (string.equals("print")) {
                    commands.commandPrint(stringTokenizer, false);
                    bl = false;
                } else if (string.equals("eval")) {
                    commands.commandPrint(stringTokenizer, false);
                    bl = false;
                } else if (string.equals("set")) {
                    commands.commandSet(stringTokenizer);
                    bl = false;
                } else if (string.equals("dump")) {
                    commands.commandPrint(stringTokenizer, true);
                    bl = false;
                } else if (string.equals("locals")) {
                    commands.commandLocals();
                } else if (string.equals("classes")) {
                    commands.commandClasses();
                } else if (string.equals("class")) {
                    commands.commandClass(stringTokenizer);
                } else if (string.equals("methods")) {
                    commands.commandMethods(stringTokenizer);
                } else if (string.equals("fields")) {
                    commands.commandFields(stringTokenizer);
                } else if (string.equals("threads")) {
                    commands.commandThreads(stringTokenizer);
                } else if (string.equals("thread")) {
                    commands.commandThread(stringTokenizer);
                } else if (string.equals("suspend")) {
                    commands.commandSuspend(stringTokenizer);
                } else if (string.equals("resume")) {
                    commands.commandResume(stringTokenizer);
                } else if (string.equals("cont")) {
                    commands.commandCont();
                } else if (string.equals("threadgroups")) {
                    commands.commandThreadGroups();
                } else if (string.equals("threadgroup")) {
                    commands.commandThreadGroup(stringTokenizer);
                } else if (string.equals("catch")) {
                    commands.commandCatchException(stringTokenizer);
                } else if (string.equals("ignore")) {
                    commands.commandIgnoreException(stringTokenizer);
                } else if (string.equals("step")) {
                    commands.commandStep(stringTokenizer);
                } else if (string.equals("stepi")) {
                    commands.commandStepi();
                } else if (string.equals("next")) {
                    commands.commandNext();
                } else if (string.equals("kill")) {
                    commands.commandKill(stringTokenizer);
                } else if (string.equals("interrupt")) {
                    commands.commandInterrupt(stringTokenizer);
                } else if (string.equals("trace")) {
                    commands.commandTrace(stringTokenizer);
                } else if (string.equals("untrace")) {
                    commands.commandUntrace(stringTokenizer);
                } else if (string.equals("where")) {
                    commands.commandWhere(stringTokenizer, false);
                } else if (string.equals("wherei")) {
                    commands.commandWhere(stringTokenizer, true);
                } else if (string.equals("up")) {
                    commands.commandUp(stringTokenizer);
                } else if (string.equals("down")) {
                    commands.commandDown(stringTokenizer);
                } else if (string.equals("load")) {
                    commands.commandLoad(stringTokenizer);
                } else if (string.equals("run")) {
                    commands.commandRun(stringTokenizer);
                    if (this.handler == null && Env.connection().isOpen()) {
                        this.handler = new EventHandler(this, false);
                    }
                } else if (string.equals("memory")) {
                    commands.commandMemory();
                } else if (string.equals("gc")) {
                    commands.commandGC();
                } else if (string.equals("stop")) {
                    commands.commandStop(stringTokenizer);
                } else if (string.equals("clear")) {
                    commands.commandClear(stringTokenizer);
                } else if (string.equals("watch")) {
                    commands.commandWatch(stringTokenizer);
                } else if (string.equals("unwatch")) {
                    commands.commandUnwatch(stringTokenizer);
                } else if (string.equals("list")) {
                    commands.commandList(stringTokenizer);
                } else if (string.equals("lines")) {
                    commands.commandLines(stringTokenizer);
                } else if (string.equals("classpath")) {
                    commands.commandClasspath(stringTokenizer);
                } else if (string.equals("use") || string.equals("sourcepath")) {
                    commands.commandUse(stringTokenizer);
                } else if (string.equals("monitor")) {
                    this.monitorCommand(stringTokenizer);
                } else if (string.equals("unmonitor")) {
                    this.unmonitorCommand(stringTokenizer);
                } else if (string.equals("lock")) {
                    commands.commandLock(stringTokenizer);
                    bl = false;
                } else if (string.equals("threadlocks")) {
                    commands.commandThreadlocks(stringTokenizer);
                } else if (string.equals("disablegc")) {
                    commands.commandDisableGC(stringTokenizer);
                    bl = false;
                } else if (string.equals("enablegc")) {
                    commands.commandEnableGC(stringTokenizer);
                    bl = false;
                } else if (string.equals("save")) {
                    commands.commandSave(stringTokenizer);
                    bl = false;
                } else if (string.equals("bytecodes")) {
                    commands.commandBytecodes(stringTokenizer);
                } else if (string.equals("extension")) {
                    commands.commandExtension(stringTokenizer);
                } else if (string.equals("exclude")) {
                    commands.commandExclude(stringTokenizer);
                } else if (string.equals("read")) {
                    this.readCommand(stringTokenizer);
                } else if (string.equals("help") || string.equals("?")) {
                    this.help();
                } else if (string.equals("version")) {
                    commands.commandVersion(progname, 1019270533724L);
                } else if (string.equals("quit") || string.equals("exit")) {
                    if (this.handler != null) {
                        this.handler.shutdown();
                    }
                    Env.shutdown();
                } else {
                    if (stringTokenizer.hasMoreTokens()) {
                        try {
                            int n = Integer.parseInt(string);
                            String string2 = stringTokenizer.nextToken("");
                            while (n-- > 0) {
                                this.executeCommand(new StringTokenizer(string2));
                            }
                            return;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    MessageOutput.println("Unrecognized command.  Try help...");
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                MessageOutput.println("Command is not supported on the target VM", string);
            }
            catch (VMNotConnectedException vMNotConnectedException) {
                MessageOutput.println("Command not valid until the VM is started with the run command", string);
            }
            catch (Exception exception) {
                MessageOutput.printException("Internal exception:", exception);
            }
        }
        if (bl) {
            MessageOutput.printPrompt();
        }
    }

    void monitorCommand(StringTokenizer stringTokenizer) {
        if (stringTokenizer.hasMoreTokens()) {
            ++this.monitorCount;
            this.monitorCommands.add(this.monitorCount + ": " + stringTokenizer.nextToken(""));
        } else {
            Iterator iterator = this.monitorCommands.iterator();
            while (iterator.hasNext()) {
                MessageOutput.printDirectln((String)iterator.next());
            }
        }
    }

    void unmonitorCommand(StringTokenizer stringTokenizer) {
        if (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            try {
                int n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                MessageOutput.println("Not a monitor number:", string);
                return;
            }
            String string2 = string + ":";
            Iterator iterator = this.monitorCommands.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string3);
                if (!stringTokenizer2.nextToken().equals(string2)) continue;
                this.monitorCommands.remove(string3);
                MessageOutput.println("Unmonitoring", string3);
                return;
            }
            MessageOutput.println("No monitor numbered:", string);
        } else {
            MessageOutput.println("Usage: unmonitor <monitor#>");
        }
    }

    void readCommand(StringTokenizer stringTokenizer) {
        if (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (!this.readCommandFile(string)) {
                MessageOutput.println("Could not open:", string);
            }
        } else {
            MessageOutput.println("Usage: read <command-filename>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean readCommandFile(String var1_1) {
        block11: {
            var2_2 = new File(var1_1);
            var3_3 = null;
            try {
                try {
                    if (var2_2.canRead()) {
                        MessageOutput.println("*** Reading commands from", var2_2.getCanonicalPath());
                        var3_3 = new BufferedReader(new FileReader(var2_2));
                        while ((var4_4 = var3_3.readLine()) != null) {
                            var5_6 = new StringTokenizer(var4_4);
                            if (!var5_6.hasMoreTokens()) continue;
                            this.executeCommand(var5_6);
                        }
                    }
                    var7_7 = null;
                    if (var3_3 == null) break block11;
                }
                catch (IOException var4_5) {
                    var7_8 = null;
                    if (var3_3 != null) {
                        try {
                            var3_3.close();
                        }
                        catch (Exception var8_11) {}
                    }
                    break block11;
                }
            }
            catch (Throwable var6_13) {
                var7_9 = null;
                if (var3_3 == null) throw var6_13;
                ** try [egrp 2[TRYBLOCK] [4 : 109->116)] { 
lbl30:
                // 1 sources

                var3_3.close();
                throw var6_13;
lbl32:
                // 1 sources

                catch (Exception var8_12) {
                    // empty catch block
                }
                throw var6_13;
            }
            try {}
            catch (Exception var8_10) {}
            var3_3.close();
        }
        if (var3_3 == null) return false;
        return true;
    }

    public TTY() throws Exception {
        MessageOutput.println("Initializing progname", progname);
        if (Env.connection().isOpen()) {
            this.handler = new EventHandler(this, true);
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            String string = null;
            Thread.currentThread().setPriority(5);
            if (!this.readCommandFile(System.getProperty("user.home") + File.separator + "jdb.ini")) {
                this.readCommandFile(System.getProperty("user.home") + File.separator + ".jdbrc");
            }
            if (!this.readCommandFile(System.getProperty("user.dir") + File.separator + "jdb.ini")) {
                this.readCommandFile(System.getProperty("user.dir") + File.separator + ".jdbrc");
            }
            MessageOutput.printPrompt();
            while (true) {
                StringTokenizer stringTokenizer;
                String string2;
                if ((string2 = bufferedReader.readLine()) == null) {
                    MessageOutput.println("Input stream closed.");
                    return;
                }
                if (string2.startsWith("!!") && string != null) {
                    string2 = string + string2.substring(2);
                    MessageOutput.printDirectln(string2);
                }
                if ((stringTokenizer = new StringTokenizer(string2)).hasMoreTokens()) {
                    string = string2;
                    this.executeCommand(stringTokenizer);
                    continue;
                }
                MessageOutput.printPrompt();
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            this.handler.handleDisconnectedException();
            return;
        }
    }

    private static void usage() {
        MessageOutput.println("zz usage text", new Object[]{progname, File.pathSeparator});
        System.exit(1);
    }

    static void usageError(String string) {
        MessageOutput.println(string);
        MessageOutput.println();
        TTY.usage();
    }

    static void usageError(String string, String string2) {
        MessageOutput.println(string, string2);
        MessageOutput.println();
        TTY.usage();
    }

    private static Connector findConnector(String string, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Connector connector = (Connector)iterator.next();
            if (!connector.transport().name().equals(string)) continue;
            return connector;
        }
        throw new IllegalArgumentException(MessageOutput.format("Invalid transport name:", string));
    }

    private static boolean supportsSharedMemory() {
        List list = Bootstrap.virtualMachineManager().allConnectors();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Connector connector = (Connector)iterator.next();
            if (!connector.transport().name().equals("dt_shmem")) continue;
            return true;
        }
        return false;
    }

    private static String addressToSocketArgs(String string) {
        int n = string.indexOf(58);
        if (n != -1) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            return "hostname=" + string2 + ",port=" + string3;
        }
        return "port=" + string;
    }

    private static boolean hasWhitespace(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (!Character.isWhitespace(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static String addArgument(String string, String string2) {
        if (TTY.hasWhitespace(string2) || string2.indexOf(44) != -1) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append('\"');
            for (int i = 0; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                if (c == '\"') {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c);
            }
            stringBuffer.append("\" ");
            return stringBuffer.toString();
        }
        return string + string2 + ' ';
    }

    public static void main(String[] stringArray) throws MissingResourceException {
        String string = "";
        String string2 = "";
        int n = 0;
        boolean bl = false;
        String string3 = null;
        MessageOutput.textResources = ResourceBundle.getBundle("com.sun.tools.example.debug.tty.TTYResources", Locale.getDefault());
        for (int i = 0; i < stringArray.length; ++i) {
            String string4;
            Object object;
            String string5 = stringArray[i];
            if (string5.equals("-dbgtrace")) {
                if (i == stringArray.length - 1 || !Character.isDigit(stringArray[i + 1].charAt(0))) {
                    n = 0xFFFFFF;
                    continue;
                }
                object = "";
                try {
                    object = stringArray[++i];
                    n = Integer.decode((String)object);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    TTY.usageError("dbgtrace flag value must be an integer:", (String)object);
                    return;
                }
            }
            if (string5.equals("-X")) {
                TTY.usageError("Use java minus X to see");
                return;
            }
            if (string5.equals("-v") || string5.startsWith("-v:") || string5.startsWith("-verbose") || string5.startsWith("-D") || string5.startsWith("-X") || string5.equals("-noasyncgc") || string5.equals("-prof") || string5.equals("-verify") || string5.equals("-noverify") || string5.equals("-verifyremote") || string5.equals("-verbosegc") || string5.startsWith("-ms") || string5.startsWith("-mx") || string5.startsWith("-ss") || string5.startsWith("-oss")) {
                string2 = TTY.addArgument(string2, string5);
                continue;
            }
            if (string5.equals("-sourcepath")) {
                if (i == stringArray.length - 1) {
                    TTY.usageError("No sourcepath specified.");
                    return;
                }
                Env.setSourcePath(stringArray[++i]);
                continue;
            }
            if (string5.equals("-classpath")) {
                if (i == stringArray.length - 1) {
                    TTY.usageError("No classpath specified.");
                    return;
                }
                string2 = TTY.addArgument(string2, string5);
                string2 = TTY.addArgument(string2, stringArray[++i]);
                continue;
            }
            if (string5.equals("-attach")) {
                if (string3 != null) {
                    TTY.usageError("cannot redefine existing connection", string5);
                    return;
                }
                if (i == stringArray.length - 1) {
                    TTY.usageError("No attach address specified.");
                    return;
                }
                object = stringArray[++i];
                if (TTY.supportsSharedMemory()) {
                    string3 = "com.sun.jdi.SharedMemoryAttach:name=" + (String)object;
                    continue;
                }
                string4 = TTY.addressToSocketArgs((String)object);
                string3 = "com.sun.jdi.SocketAttach:" + string4;
                continue;
            }
            if (string5.equals("-listen") || string5.equals("-listenany")) {
                if (string3 != null) {
                    TTY.usageError("cannot redefine existing connection", string5);
                    return;
                }
                object = null;
                if (string5.equals("-listen")) {
                    if (i == stringArray.length - 1) {
                        TTY.usageError("No attach address specified.");
                        return;
                    }
                    object = stringArray[++i];
                }
                if (TTY.supportsSharedMemory()) {
                    string3 = "com.sun.jdi.SharedMemoryListen";
                    if (object == null) continue;
                    string3 = string3 + ":name=" + (String)object;
                    continue;
                }
                string4 = TTY.addressToSocketArgs((String)object);
                string3 = "com.sun.jdi.SocketListen";
                if (object == null) continue;
                string3 = string3 + ":port=" + (String)object;
                continue;
            }
            if (string5.equals("-launch")) {
                bl = true;
                continue;
            }
            if (string5.equals("-connect")) {
                if (string3 != null) {
                    TTY.usageError("cannot redefine existing connection", string5);
                    return;
                }
                if (i == stringArray.length - 1) {
                    TTY.usageError("No connect specification.");
                    return;
                }
                string3 = stringArray[++i];
                continue;
            }
            if (string5.equals("-help")) {
                TTY.usage();
                continue;
            }
            if (string5.equals("-version")) {
                object = new Commands();
                ((Commands)object).commandVersion(progname, 1019270533724L);
                System.exit(0);
                continue;
            }
            if (string5.startsWith("-")) {
                TTY.usageError("invalid option", string5);
                return;
            }
            string = TTY.addArgument("", string5);
            ++i;
            while (i < stringArray.length) {
                string = TTY.addArgument(string, stringArray[i]);
                ++i;
            }
            break;
        }
        if (string3 == null) {
            string3 = "com.sun.jdi.CommandLineLaunch:";
        } else if (!string3.endsWith(",") && !string3.endsWith(":")) {
            string3 = string3 + ",";
        }
        string = string.trim();
        string2 = string2.trim();
        if (string.length() > 0) {
            if (!string3.startsWith("com.sun.jdi.CommandLineLaunch:")) {
                TTY.usageError("Cannot specify command line with connector:", string3);
                return;
            }
            string3 = string3 + "main=" + string + ",";
        }
        if (string2.length() > 0) {
            if (!string3.startsWith("com.sun.jdi.CommandLineLaunch:")) {
                TTY.usageError("Cannot specify target vm arguments with connector:", string3);
                return;
            }
            string3 = string3 + "options=" + string2 + ",";
        }
        try {
            if (!string3.endsWith(",")) {
                string3 = string3 + ",";
            }
            Env.init(string3, bl, n);
            new TTY();
        }
        catch (Exception exception) {
            MessageOutput.printException("Internal exception:", exception);
        }
    }
}

