/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.tools.doclets.Util;
import java.util.ArrayList;
import java.util.List;

public class ImplementedMethods {
    private List methlist = new ArrayList();
    private final ClassDoc classdoc;
    private final MethodDoc method;

    public ImplementedMethods(MethodDoc methodDoc) {
        this.method = methodDoc;
        this.classdoc = methodDoc.containingClass();
    }

    public MethodDoc[] build() {
        for (ClassDoc classDoc = this.classdoc; classDoc != null; classDoc = classDoc.superclass()) {
            this.buildImplementedMethodList(classDoc.interfaces());
        }
        return this.methlist.toArray(new MethodDoc[this.methlist.size()]);
    }

    private void buildImplementedMethodList(ClassDoc[] classDocArray) {
        for (int i = 0; i < classDocArray.length; ++i) {
            MethodDoc methodDoc = Util.findMethod(classDocArray[i], this.method);
            if (methodDoc != null) {
                this.removeOverriddenMethod(methodDoc);
                if (!this.overridingMethodFound(methodDoc)) {
                    this.methlist.add(methodDoc);
                }
            }
            ClassDoc[] classDocArray2 = classDocArray[i].interfaces();
            this.buildImplementedMethodList(classDocArray2);
        }
    }

    private void removeOverriddenMethod(MethodDoc methodDoc) {
        ClassDoc classDoc = methodDoc.overriddenClass();
        if (classDoc != null) {
            for (int i = 0; i < this.methlist.size(); ++i) {
                ClassDoc classDoc2 = ((MethodDoc)this.methlist.get(i)).containingClass();
                if (classDoc2 != classDoc && !classDoc.subclassOf(classDoc2)) continue;
                this.methlist.remove(i);
                return;
            }
        }
    }

    private boolean overridingMethodFound(MethodDoc methodDoc) {
        ClassDoc classDoc = methodDoc.containingClass();
        for (int i = 0; i < this.methlist.size(); ++i) {
            MethodDoc methodDoc2 = (MethodDoc)this.methlist.get(i);
            if (classDoc == methodDoc2.containingClass()) {
                return true;
            }
            ClassDoc classDoc2 = methodDoc2.overriddenClass();
            if (classDoc2 == null || classDoc2 != classDoc && !classDoc2.subclassOf(classDoc)) continue;
            return true;
        }
        return false;
    }
}

