/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.rmic.iiop;

import com.ibm.rmi.util.Utility;
import com.ibm.tools.rmic.iiop.AbstractType;
import com.ibm.tools.rmic.iiop.BatchEnvironment;
import com.ibm.tools.rmic.iiop.ClassType;
import com.ibm.tools.rmic.iiop.CompoundType;
import com.ibm.tools.rmic.iiop.Constants;
import com.ibm.tools.rmic.iiop.ContextStack;
import com.ibm.tools.rmic.iiop.Generator;
import com.ibm.tools.rmic.iiop.IDLNames;
import com.ibm.tools.rmic.iiop.ImplementationType;
import com.ibm.tools.rmic.iiop.InterfaceType;
import com.ibm.tools.rmic.iiop.NullWriter;
import com.ibm.tools.rmic.iiop.RemoteType;
import com.ibm.tools.rmic.iiop.StaticStringsHash;
import com.ibm.tools.rmic.iiop.Type;
import com.ibm.tools.rmic.iiop.UserExceptionComparator;
import com.ibm.tools.rmic.iiop.ValueType;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import sun.rmi.rmic.IndentingWriter;
import sun.rmi.rmic.Main;
import sun.tools.java.ClassDefinition;
import sun.tools.java.CompilerError;
import sun.tools.java.Identifier;

public class StubGenerator
extends Generator {
    private static final String DEFAULT_STUB_CLASS = "javax.rmi.CORBA.Stub";
    private static final String DEFAULT_TIE_CLASS = "org.omg.CORBA_2_3.portable.ObjectImpl";
    private static final String POA_TIE_CLASS = "org.omg.PortableServer.Servant";
    private static final String DEBUG_PROPERTY = "com.ibm.tools.rmic.iiop.Debug";
    private boolean isPOATie = false;
    private boolean reverseIDs = false;
    private boolean localStubs = true;
    private boolean useHash = true;
    private String stubBaseClass = "javax.rmi.CORBA.Stub";
    private String tieBaseClass = "org.omg.CORBA_2_3.portable.ObjectImpl";
    private HashSet namesInUse = new HashSet();
    private ClassNameTable classesInUse = new ClassNameTable();
    private HashSet alwaysFullyQualify = new HashSet();
    private HashMap imports = new HashMap();
    private String currentPackage = null;
    private String currentClass = null;
    private boolean castArray = false;
    static final String SINGLE_SLASH = "\\";
    static final String DOUBLE_SLASH = "\\\\";

    protected boolean requireNewInstance() {
        return false;
    }

    protected boolean parseNonConforming(ContextStack contextStack) {
        return contextStack.getEnv().getParseNonConforming();
    }

    protected CompoundType getTopType(ClassDefinition classDefinition, ContextStack contextStack) {
        CompoundType compoundType = null;
        if (classDefinition.isInterface()) {
            compoundType = AbstractType.forAbstract(classDefinition, contextStack, true);
            if (compoundType == null) {
                compoundType = RemoteType.forRemote(classDefinition, contextStack, false);
            }
        } else {
            compoundType = ImplementationType.forImplementation(classDefinition, contextStack, false);
        }
        return compoundType;
    }

    public boolean parseArgs(String[] stringArray, Main main) {
        this.reverseIDs = false;
        this.localStubs = true;
        this.useHash = true;
        this.stubBaseClass = DEFAULT_STUB_CLASS;
        this.tieBaseClass = DEFAULT_TIE_CLASS;
        boolean bl = super.parseArgs(stringArray, main);
        if (bl) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                String string = stringArray[i].toLowerCase();
                if (string.equals("-iiop")) {
                    stringArray[i] = null;
                    continue;
                }
                if (string.equals("-poa")) {
                    stringArray[i] = null;
                    this.tieBaseClass = POA_TIE_CLASS;
                    this.isPOATie = true;
                    continue;
                }
                if (string.equals("-xreverseids")) {
                    this.reverseIDs = true;
                    stringArray[i] = null;
                    continue;
                }
                if (string.equals("-nolocalstubs")) {
                    this.localStubs = false;
                    stringArray[i] = null;
                    continue;
                }
                if (string.equals("-xnohash")) {
                    this.useHash = false;
                    stringArray[i] = null;
                    continue;
                }
                if (string.equals("-xstubbase")) {
                    stringArray[i] = null;
                    if (++i < stringArray.length && stringArray[i] != null && !stringArray[i].startsWith("-")) {
                        this.stubBaseClass = stringArray[i];
                        stringArray[i] = null;
                        continue;
                    }
                    main.error("rmic.option.requires.argument", "-Xstubbase");
                    bl = false;
                    continue;
                }
                if (!string.equals("-xtiebase")) continue;
                stringArray[i] = null;
                if (++i < stringArray.length && stringArray[i] != null && !stringArray[i].startsWith("-")) {
                    this.tieBaseClass = stringArray[i];
                    stringArray[i] = null;
                    continue;
                }
                main.error("rmic.option.requires.argument", "-Xtiebase");
                bl = false;
            }
        }
        return bl;
    }

    protected Generator.OutputType[] getOutputTypesFor(CompoundType compoundType, HashSet hashSet) {
        int n = 69632;
        Type[] typeArray = compoundType.collectMatching(n, hashSet);
        int n2 = typeArray.length;
        Vector<Generator.OutputType> vector = new Vector<Generator.OutputType>(n2 + 5);
        BatchEnvironment batchEnvironment = compoundType.getEnv();
        for (int i = 0; i < typeArray.length; ++i) {
            Type type = typeArray[i];
            String string = type.getName();
            boolean bl = true;
            if (type instanceof ImplementationType) {
                vector.addElement(new Generator.OutputType(Utility.tieName((String)string), type));
                int n3 = 0;
                InterfaceType[] interfaceTypeArray = ((CompoundType)type).getInterfaces();
                for (int j = 0; j < interfaceTypeArray.length; ++j) {
                    if (!interfaceTypeArray[j].isType(4096) || interfaceTypeArray[j].isType(12288)) continue;
                    ++n3;
                }
                if (n3 <= 1) {
                    bl = false;
                }
            }
            if (!bl) continue;
            vector.addElement(new Generator.OutputType(Utility.stubName((String)string), type));
        }
        Object[] objectArray = new Generator.OutputType[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected String getFileNameExtensionFor(Generator.OutputType outputType) {
        return ".java";
    }

    protected void writeOutputFor(Generator.OutputType outputType, HashSet hashSet, IndentingWriter indentingWriter, boolean bl) throws IOException {
        this.writeComment(outputType, indentingWriter);
        this.parseTypeForImports(outputType);
        this.writePackageAndImports(indentingWriter);
        this.writeCodeForType(outputType, indentingWriter);
        if (System.getProperty(DEBUG_PROPERTY) != null) {
            this.classesInUse.listEntries(System.out, outputType.getName());
        }
    }

    private boolean isStub(Generator.OutputType outputType) {
        String string = outputType.getName();
        return string.endsWith("_Stub");
    }

    private void writeComment(Generator.OutputType outputType, IndentingWriter indentingWriter) throws IOException {
        String string = null;
        string = this.isStub(outputType) ? "Stub" : (this.isPOATie ? "POA Tie" : "Tie");
        indentingWriter.pln("// " + string + " class generated by rmic, do not edit.");
        indentingWriter.pln("// Contents subject to change without notice.");
        indentingWriter.pln();
    }

    private void writeCodeForType(Generator.OutputType outputType, IndentingWriter indentingWriter) throws IOException {
        if (this.isStub(outputType)) {
            this.writeStub(outputType, indentingWriter);
        } else {
            this.writeTie(outputType, indentingWriter);
        }
    }

    private void parseTypeForImports(Generator.OutputType outputType) throws IOException {
        CompoundType compoundType = (CompoundType)outputType.getType();
        this.resetState(compoundType, this.isStub(outputType));
        if (System.getProperty("com.ibm.tools.rmic.iiop.SkipImports") == null) {
            NullWriter nullWriter = NullWriter.instance;
            this.writeCodeForType(outputType, nullWriter);
        }
    }

    protected void writeStub(Generator.OutputType outputType, IndentingWriter indentingWriter) throws IOException {
        CompoundType compoundType = (CompoundType)outputType.getType();
        RemoteType[] remoteTypeArray = this.getDirectRemoteInterfaces(compoundType);
        indentingWriter.p("public class " + this.currentClass);
        indentingWriter.p(" extends " + this.getName(this.stubBaseClass));
        indentingWriter.p(" implements ");
        if (remoteTypeArray.length > 0) {
            for (int i = 0; i < remoteTypeArray.length; ++i) {
                if (i > 0) {
                    indentingWriter.pln(",");
                }
                indentingWriter.p(this.getName(remoteTypeArray[i]));
            }
        }
        if (!this.implementsRemote(compoundType)) {
            indentingWriter.pln(",");
            indentingWriter.p(this.getName(sun.rmi.rmic.Constants.idRemote.toString()));
        }
        indentingWriter.plnI(" {");
        indentingWriter.pln();
        this.writeIds(indentingWriter, compoundType);
        indentingWriter.pln();
        indentingWriter.plnI("public " + this.getName(sun.tools.java.Constants.idJavaLangString) + "[] _ids() { ");
        indentingWriter.pln("return _type_ids;");
        indentingWriter.pOln("}");
        CompoundType.Method[] methodArray = compoundType.getMethods();
        int n = methodArray.length;
        for (int i = 0; i < n; ++i) {
            if (methodArray[i].isConstructor()) continue;
            indentingWriter.pln();
            this.writeStubMethod(indentingWriter, methodArray[i], compoundType);
        }
        this.writeCastArray(indentingWriter);
        indentingWriter.pOln("}");
    }

    void addClassInUse(String string) {
        String string2 = string;
        String string3 = null;
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string2 = string.substring(n + 1);
            string3 = string.substring(0, n);
        }
        this.addClassInUse(string2, string, string3);
    }

    void addClassInUse(Type type) {
        if (!type.isPrimitive()) {
            Identifier identifier = type.getIdentifier();
            String string = IDLNames.replace(identifier.getName().toString(), ". ", ".");
            String string2 = type.getPackageName();
            String string3 = string2 != null ? string2 + "." + string : string;
            this.addClassInUse(string3);
        }
    }

    void addClassInUse(Type[] typeArray) {
        for (int i = 0; i < typeArray.length; ++i) {
            this.addClassInUse(typeArray[i]);
        }
    }

    void addStubInUse(Type type) {
        if (type.getIdentifier() != Constants.idCorbaObject && type.isType(2048)) {
            String string = this.getStubNameFor(type, false);
            String string2 = type.getPackageName();
            String string3 = string2 == null ? string : string2 + "." + string;
            this.addClassInUse(string, string3, string2);
        }
    }

    String getStubNameFor(Type type, boolean bl) {
        String string = bl ? type.getQualifiedName() : type.getName();
        String string2 = ((CompoundType)type).isCORBAObject() ? Utility.idlStubName((String)string) : Utility.stubName((String)string);
        return string2;
    }

    void addStubInUse(Type[] typeArray) {
        for (int i = 0; i < typeArray.length; ++i) {
            this.addStubInUse(typeArray[i]);
        }
    }

    void addClassInUse(String string, String string2, String string3) {
        String string4 = this.classesInUse.getProvisionalName(string2);
        if (string4 == null) {
            String string5 = null;
            if (this.alwaysFullyQualify.contains(string2)) {
                string5 = string2;
            } else {
                ImportEntry importEntry = (ImportEntry)this.imports.get(string);
                int n = ImportEntry.getOrderFromPackageName(string3, this.currentPackage);
                if (importEntry == null || n > importEntry.getImportOrder()) {
                    ImportEntry importEntry2 = new ImportEntry(string2, n);
                    this.imports.put(string, importEntry2);
                    string5 = string;
                    if (importEntry != null) {
                        String string6 = importEntry.getQualifiedName();
                        this.classesInUse.setNameToUse(string6, string6);
                    }
                } else {
                    string5 = string2;
                }
            }
            this.classesInUse.setNameToUse(string2, string5);
        }
    }

    String getName(Type type) {
        if (type.isPrimitive()) {
            return type.getName() + type.getArrayBrackets();
        }
        Identifier identifier = type.getIdentifier();
        String string = IDLNames.replace(identifier.toString(), ". ", ".");
        return this.getName(string) + type.getArrayBrackets();
    }

    String getName(String string) {
        if (this.classesInUse.isReadable()) {
            return this.classesInUse.getNameToUse(string);
        }
        this.addClassInUse(string);
        return string;
    }

    String getName(Identifier identifier) {
        return this.getName(identifier.toString());
    }

    String getStubName(Type type) {
        String string = this.getStubNameFor(type, true);
        return this.getName(string);
    }

    void resetState(CompoundType compoundType, boolean bl) {
        this.currentPackage = compoundType.getPackageName();
        this.imports.clear();
        this.classesInUse.reset();
        this.namesInUse.clear();
        this.castArray = false;
        if (bl && this.currentPackage != null && compoundType.relocateStubs) {
            this.currentPackage = "org.omg.stub." + this.currentPackage;
        }
        this.currentClass = bl ? Utility.stubName((String)compoundType.getName()) : Utility.tieName((String)compoundType.getName());
    }

    void setStandardClassesInUse(CompoundType compoundType) {
        this.addClassInUse(compoundType);
        if (this.currentPackage == null) {
            this.addClassInUse(this.currentClass, this.currentClass, this.currentPackage);
        } else {
            this.addClassInUse(this.currentClass, this.currentPackage + "." + this.currentClass, this.currentPackage);
        }
        this.alwaysFullyQualify.add(Constants.idCorbaObject);
    }

    void addClassesInUse(CompoundType compoundType, RemoteType[] remoteTypeArray) {
        CompoundType.Method[] methodArray = compoundType.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            this.addClassInUse(methodArray[i].getReturnType());
            this.addStubInUse(methodArray[i].getReturnType());
            this.addClassInUse(methodArray[i].getArguments());
            this.addStubInUse(methodArray[i].getArguments());
            this.addClassInUse(methodArray[i].getExceptions());
            this.addClassInUse(methodArray[i].getImplExceptions());
        }
        if (remoteTypeArray != null) {
            this.addClassInUse(remoteTypeArray);
        }
    }

    void writePackageAndImports(IndentingWriter indentingWriter) throws IOException {
        this.classesInUse.makeReadOnly();
        if (this.currentPackage != null) {
            indentingWriter.pln("package " + this.currentPackage + ";");
            indentingWriter.pln();
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        Iterator<Object> iterator = this.imports.values().iterator();
        while (iterator.hasNext()) {
            String string = ((ImportEntry)iterator.next()).getImportName();
            if (string == null) continue;
            treeSet.add(string);
        }
        iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            indentingWriter.pln("import " + iterator.next() + ";");
        }
        indentingWriter.pln();
    }

    boolean implementsRemote(CompoundType compoundType) {
        boolean bl;
        boolean bl2 = bl = compoundType.isType(4096) && !compoundType.isType(12288);
        if (!bl) {
            InterfaceType[] interfaceTypeArray = compoundType.getInterfaces();
            for (int i = 0; i < interfaceTypeArray.length && !(bl = this.implementsRemote(interfaceTypeArray[i])); ++i) {
            }
        }
        return bl;
    }

    void writeStubMethod(IndentingWriter indentingWriter, CompoundType.Method method, CompoundType compoundType) throws IOException {
        int n;
        String string = IDLNames.expandEscapedSourceCharacters(method.getName());
        String string2 = method.getIDLName(true);
        Type[] typeArray = method.getArguments();
        String[] stringArray = method.getArgumentNames();
        Type type = method.getReturnType();
        ValueType[] valueTypeArray = this.getStubExceptions(method, false);
        this.addNamesInUse(method);
        this.addNameInUse("_type_ids");
        indentingWriter.p("public " + this.getName(type) + " " + string + "(");
        for (n = 0; n < typeArray.length; ++n) {
            if (n > 0) {
                indentingWriter.p(", ");
            }
            indentingWriter.p(this.getName(typeArray[n]) + " " + stringArray[n]);
        }
        indentingWriter.p(")");
        if (valueTypeArray.length > 0) {
            indentingWriter.p(" throws ");
            for (n = 0; n < valueTypeArray.length; ++n) {
                if (n > 0) {
                    indentingWriter.p(", ");
                }
                indentingWriter.p(this.getName(valueTypeArray[n]));
            }
        }
        indentingWriter.plnI(" {");
        if (this.localStubs) {
            this.writeLocalStubMethodBody(indentingWriter, method, compoundType);
        } else {
            this.writeNonLocalStubMethodBody(indentingWriter, method, compoundType);
        }
        indentingWriter.pOln("}");
    }

    void writeLocalStubMethodBody(IndentingWriter indentingWriter, CompoundType.Method method, CompoundType compoundType) throws IOException {
        String[] stringArray = method.getArgumentNames();
        Type type = method.getReturnType();
        ValueType[] valueTypeArray = this.getStubExceptions(method, false);
        String string = IDLNames.expandEscapedSourceCharacters(method.getName());
        String string2 = method.getIDLName(true);
        indentingWriter.plnI("if (!" + this.getName(Constants.idCorbaUtil) + ".isLocal(this)) {");
        this.writeNonLocalStubMethodBody(indentingWriter, method, compoundType);
        indentingWriter.pOlnI("} else {");
        String string3 = this.getVariableName("so");
        String string4 = method.getDeclaredBy().toString();
        indentingWriter.pln(this.getName(Constants.idServantObject) + " " + string3 + " = _servant_preinvoke(\"" + string2 + "\"," + string4 + ".class);");
        indentingWriter.plnI("if (" + string3 + " == null) {");
        if (!type.isType(1)) {
            indentingWriter.p("return ");
        }
        indentingWriter.p(string + "(");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                indentingWriter.p(", ");
            }
            indentingWriter.p(stringArray[i]);
        }
        indentingWriter.pln(");");
        if (type.isType(1)) {
            indentingWriter.pln("return;");
        }
        indentingWriter.pOln("}");
        indentingWriter.plnI("try {");
        String[] stringArray2 = this.writeCopyArguments(method, indentingWriter);
        boolean bl = StubGenerator.mustCopy(type);
        String string5 = null;
        if (!type.isType(1)) {
            if (bl) {
                string5 = this.getVariableName("result");
                indentingWriter.p(this.getName(type) + " " + string5 + " = ");
            } else {
                indentingWriter.p("return ");
            }
        }
        indentingWriter.p("((" + string4 + ")" + string3 + ".servant)." + string + "(");
        for (int i = 0; i < stringArray2.length; ++i) {
            if (i > 0) {
                indentingWriter.p(", ");
            }
            indentingWriter.p(stringArray2[i]);
        }
        if (bl) {
            indentingWriter.pln(");");
            indentingWriter.pln("return (" + this.getName(type) + ")" + this.getName(Constants.idCorbaUtil) + ".copyObject(" + string5 + ",_orb());");
        } else {
            indentingWriter.pln(");");
        }
        String string6 = this.getVariableName("ex");
        String string7 = this.getVariableName("exCopy");
        if (type.isType(1)) {
            indentingWriter.pln("return;");
        }
        indentingWriter.pOlnI("} catch (" + this.getName(sun.tools.java.Constants.idJavaLangThrowable) + " " + string6 + ") {");
        indentingWriter.pln(this.getName(sun.tools.java.Constants.idJavaLangThrowable) + " " + string7 + " = (" + this.getName(sun.tools.java.Constants.idJavaLangThrowable) + ")" + this.getName(Constants.idCorbaUtil) + ".copyObject(" + string6 + ",_orb());");
        for (int i = 0; i < valueTypeArray.length; ++i) {
            if (valueTypeArray[i].getIdentifier() == sun.rmi.rmic.Constants.idRemoteException || !valueTypeArray[i].isType(32768)) continue;
            indentingWriter.plnI("if (" + string7 + " instanceof " + this.getName(valueTypeArray[i]) + ") {");
            indentingWriter.pln("throw (" + this.getName(valueTypeArray[i]) + ")" + string7 + ";");
            indentingWriter.pOln("}");
        }
        indentingWriter.pln("throw " + this.getName(Constants.idCorbaUtil) + ".wrapException(" + string7 + ");");
        indentingWriter.pOlnI("} finally {");
        indentingWriter.pln("_servant_postinvoke(" + string3 + ");");
        indentingWriter.pOln("}");
        indentingWriter.pOln("}");
    }

    void writeNonLocalStubMethodBody(IndentingWriter indentingWriter, CompoundType.Method method, CompoundType compoundType) throws IOException {
        int n;
        int n2;
        String string = IDLNames.expandEscapedSourceCharacters(method.getName());
        String string2 = method.getIDLName(true);
        Type[] typeArray = method.getArguments();
        String[] stringArray = method.getArgumentNames();
        Type type = method.getReturnType();
        ValueType[] valueTypeArray = this.getStubExceptions(method, true);
        String string3 = this.getVariableName("in");
        String string4 = this.getVariableName("out");
        String string5 = this.getVariableName("ex");
        boolean bl = false;
        for (n2 = 0; n2 < valueTypeArray.length; ++n2) {
            if (valueTypeArray[n2].getIdentifier() == sun.rmi.rmic.Constants.idRemoteException || !valueTypeArray[n2].isType(32768) || !StubGenerator.needNewReadStreamClass(valueTypeArray[n2])) continue;
            bl = true;
            break;
        }
        if (!bl) {
            for (n2 = 0; n2 < typeArray.length; ++n2) {
                if (!StubGenerator.needNewReadStreamClass(typeArray[n2])) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            bl = StubGenerator.needNewReadStreamClass(type);
        }
        n2 = 0;
        for (int i = 0; i < typeArray.length; ++i) {
            if (!StubGenerator.needNewWriteStreamClass(typeArray[i])) continue;
            n2 = 1;
            break;
        }
        indentingWriter.plnI("try {");
        if (bl) {
            indentingWriter.pln(this.getName(Constants.idExtInputStream) + " " + string3 + " = null;");
        } else {
            indentingWriter.pln(this.getName(Constants.idInputStream) + " " + string3 + " = null;");
        }
        indentingWriter.plnI("try {");
        String string6 = "null";
        if (n2 != 0) {
            indentingWriter.plnI(this.getName(Constants.idExtOutputStream) + " " + string4 + " = ");
            indentingWriter.pln("(" + this.getName(Constants.idExtOutputStream) + ")");
            indentingWriter.pln("_request(\"" + string2 + "\", true);");
            indentingWriter.pO();
        } else {
            indentingWriter.pln(this.getName(Constants.idOutputStream) + " " + string4 + " = _request(\"" + string2 + "\", true);");
        }
        if (typeArray.length > 0) {
            this.writeMarshalArguments(indentingWriter, string4, typeArray, stringArray);
            indentingWriter.pln();
        }
        string6 = string4;
        if (type.isType(1)) {
            indentingWriter.pln("_invoke(" + string6 + ");");
            indentingWriter.pln("return;");
        } else {
            if (bl) {
                indentingWriter.plnI(string3 + " = (" + this.getName(Constants.idExtInputStream) + ")_invoke(" + string6 + ");");
                indentingWriter.pO();
            } else {
                indentingWriter.pln(string3 + " = _invoke(" + string6 + ");");
            }
            indentingWriter.p("return ");
            this.writeUnmarshalArgument(indentingWriter, string3, type, null);
            indentingWriter.pln();
        }
        indentingWriter.pOlnI("} catch (" + this.getName(Constants.idApplicationException) + " " + string5 + ") {");
        if (bl) {
            indentingWriter.pln(string3 + " = (" + this.getName(Constants.idExtInputStream) + ") " + string5 + ".getInputStream();");
        } else {
            indentingWriter.pln(string3 + " = " + string5 + ".getInputStream();");
        }
        boolean bl2 = false;
        boolean bl3 = false;
        String string7 = this.getVariableName("id");
        for (n = 0; n < valueTypeArray.length; ++n) {
            if (valueTypeArray[n].getIdentifier() == sun.rmi.rmic.Constants.idRemoteException) continue;
            if (valueTypeArray[n].isIDLEntityException() && !valueTypeArray[n].isCORBAUserException()) {
                if (!bl3 && !bl2) {
                    indentingWriter.pln(this.getName(sun.tools.java.Constants.idJavaLangString) + " " + string7 + " = " + string5 + ".getId();");
                    bl3 = true;
                }
                String string8 = IDLNames.replace(valueTypeArray[n].getQualifiedIDLName(false), "::", ".");
                string8 = string8 + "Helper";
                indentingWriter.plnI("if (" + string7 + ".equals(" + string8 + ".id())) {");
                indentingWriter.pln("throw " + string8 + ".read(" + string3 + ");");
            } else {
                if (!bl3 && !bl2) {
                    indentingWriter.pln(this.getName(sun.tools.java.Constants.idJavaLangString) + " " + string7 + " = " + string3 + ".read_string();");
                    bl3 = true;
                    bl2 = true;
                } else if (bl3 && !bl2) {
                    indentingWriter.pln(string7 + " = " + string3 + ".read_string();");
                    bl2 = true;
                }
                indentingWriter.plnI("if (" + string7 + ".equals(\"" + this.getExceptionRepositoryID(valueTypeArray[n]) + "\")) {");
                indentingWriter.pln("throw (" + this.getName(valueTypeArray[n]) + ") " + string3 + ".read_value(" + this.getName(valueTypeArray[n]) + ".class);");
            }
            indentingWriter.pOln("}");
        }
        if (!bl3 && !bl2) {
            indentingWriter.pln(this.getName(sun.tools.java.Constants.idJavaLangString) + " " + string7 + " = " + string3 + ".read_string();");
            bl3 = true;
            bl2 = true;
        } else if (bl3 && !bl2) {
            indentingWriter.pln(string7 + " = " + string3 + ".read_string();");
            bl2 = true;
        }
        indentingWriter.pln("throw new " + this.getName(Constants.idUnexpectedEx) + "(" + string7 + ");");
        indentingWriter.pOlnI("} catch (" + this.getName(Constants.idRemarshalException) + " " + string5 + ") {");
        if (!type.isType(1)) {
            indentingWriter.p("return ");
        }
        indentingWriter.p(string + "(");
        for (n = 0; n < typeArray.length; ++n) {
            if (n > 0) {
                indentingWriter.p(",");
            }
            indentingWriter.p(stringArray[n]);
        }
        indentingWriter.pln(");");
        if (type.isType(1)) {
            indentingWriter.pln("return;");
        }
        indentingWriter.pOlnI("} finally {");
        indentingWriter.pln("_releaseReply(" + string3 + ");");
        indentingWriter.pOln("}");
        indentingWriter.pOlnI("} catch (" + this.getName(Constants.idSystemException) + " " + string5 + ") {");
        indentingWriter.pln("throw " + this.getName(Constants.idCorbaUtil) + ".mapSystemException(" + string5 + ");");
        indentingWriter.pOln("}");
    }

    void allocateResult(IndentingWriter indentingWriter, Type type) throws IOException {
        if (!type.isType(1)) {
            indentingWriter.p(this.getName(type) + " result = ");
        }
    }

    int getTypeCode(Type type) {
        int n = type.getTypeCode();
        if (type instanceof CompoundType && ((CompoundType)type).isAbstractBase()) {
            n = 12288;
        }
        return n;
    }

    void writeMarshalArgument(IndentingWriter indentingWriter, String string, Type type, String string2) throws IOException {
        int n = this.getTypeCode(type);
        switch (n) {
            case 2: {
                indentingWriter.p(string + ".write_boolean(" + string2 + ");");
                break;
            }
            case 4: {
                indentingWriter.p(string + ".write_octet(" + string2 + ");");
                break;
            }
            case 8: {
                indentingWriter.p(string + ".write_wchar(" + string2 + ");");
                break;
            }
            case 16: {
                indentingWriter.p(string + ".write_short(" + string2 + ");");
                break;
            }
            case 32: {
                indentingWriter.p(string + ".write_long(" + string2 + ");");
                break;
            }
            case 64: {
                indentingWriter.p(string + ".write_longlong(" + string2 + ");");
                break;
            }
            case 128: {
                indentingWriter.p(string + ".write_float(" + string2 + ");");
                break;
            }
            case 256: {
                indentingWriter.p(string + ".write_double(" + string2 + ");");
                break;
            }
            case 512: {
                indentingWriter.p(string + ".write_value(" + string2 + "," + this.getName(type) + ".class);");
                break;
            }
            case 0x100000: {
                indentingWriter.p(string + ".write_value(" + string2 + "," + this.getName(type) + ".class);");
                break;
            }
            case 1024: {
                indentingWriter.p(this.getName(Constants.idCorbaUtil) + ".writeAny(" + string + "," + string2 + ");");
                break;
            }
            case 2048: {
                indentingWriter.p(string + ".write_Object(" + string2 + ");");
                break;
            }
            case 4096: {
                indentingWriter.p(this.getName(Constants.idCorbaUtil) + ".writeRemoteObject(" + string + "," + string2 + ");");
                break;
            }
            case 12288: {
                indentingWriter.p(this.getName(Constants.idCorbaUtil) + ".writeAbstractObject(" + string + "," + string2 + ");");
                break;
            }
            case 16384: {
                indentingWriter.p(string + ".write_value((" + this.getName(sun.tools.java.Constants.idJavaIoSerializable) + ")" + string2 + "," + this.getName(type) + ".class);");
                break;
            }
            case 32768: {
                indentingWriter.p(string + ".write_value(" + string2 + "," + this.getName(type) + ".class);");
                break;
            }
            case 65536: {
                indentingWriter.p(string + ".write_value((" + this.getName(sun.tools.java.Constants.idJavaIoSerializable) + ")" + string2 + "," + this.getName(type) + ".class);");
                break;
            }
            case 131072: {
                indentingWriter.p(string + ".write_value((" + this.getName(sun.tools.java.Constants.idJavaIoSerializable) + ")" + string2 + "," + this.getName(type) + ".class);");
                break;
            }
            case 262144: {
                this.castArray = true;
                indentingWriter.p(string + ".write_value(cast_array(" + string2 + ")," + this.getName(type) + ".class);");
                break;
            }
            case 524288: {
                indentingWriter.p(this.getName(Constants.idCorbaUtil) + ".writeRemoteObject(" + string + "," + string2 + ");");
                break;
            }
            default: {
                throw new Error("unexpected type code: " + n);
            }
        }
    }

    void writeUnmarshalArgument(IndentingWriter indentingWriter, String string, Type type, String string2) throws IOException {
        int n = this.getTypeCode(type);
        if (string2 != null) {
            indentingWriter.p(string2 + " = ");
        }
        switch (n) {
            case 2: {
                indentingWriter.p(string + ".read_boolean();");
                break;
            }
            case 4: {
                indentingWriter.p(string + ".read_octet();");
                break;
            }
            case 8: {
                indentingWriter.p(string + ".read_wchar();");
                break;
            }
            case 16: {
                indentingWriter.p(string + ".read_short();");
                break;
            }
            case 32: {
                indentingWriter.p(string + ".read_long();");
                break;
            }
            case 64: {
                indentingWriter.p(string + ".read_longlong();");
                break;
            }
            case 128: {
                indentingWriter.p(string + ".read_float();");
                break;
            }
            case 256: {
                indentingWriter.p(string + ".read_double();");
                break;
            }
            case 512: {
                indentingWriter.p("(" + this.getName(sun.tools.java.Constants.idJavaLangString) + ") " + string + ".read_value(" + this.getName(type) + ".class);");
                break;
            }
            case 0x100000: {
                indentingWriter.p("(" + this.getName(sun.tools.java.Constants.idJavaLangString) + ") " + string + ".read_value(" + this.getName(type) + ".class);");
                break;
            }
            case 1024: {
                if (type.getIdentifier() != sun.tools.java.Constants.idJavaLangObject) {
                    indentingWriter.p("(" + this.getName(type) + ") ");
                }
                indentingWriter.p(this.getName(Constants.idCorbaUtil) + ".readAny(" + string + ");");
                break;
            }
            case 2048: {
                if (type.getIdentifier() == Constants.idCorbaObject) {
                    indentingWriter.p("(" + this.getName(type) + ") " + string + ".read_Object();");
                    break;
                }
                indentingWriter.p("(" + this.getName(type) + ") " + string + ".read_Object(" + this.getStubName(type) + ".class);");
                break;
            }
            case 4096: {
                indentingWriter.p("(" + this.getName(type) + ") " + string + ".read_Object(" + this.getName(type) + ".class);");
                break;
            }
            case 12288: {
                indentingWriter.p("(" + this.getName(type) + ") " + string + ".read_abstract_interface(" + this.getName(type) + ".class);");
                break;
            }
            case 16384: {
                indentingWriter.p("(" + this.getName(type) + ") " + string + ".read_value(" + this.getName(type) + ".class);");
                break;
            }
            case 32768: {
                indentingWriter.p("(" + this.getName(type) + ") " + string + ".read_value(" + this.getName(type) + ".class);");
                break;
            }
            case 65536: {
                indentingWriter.p("(" + this.getName(type) + ") " + string + ".read_value(" + this.getName(type) + ".class);");
                break;
            }
            case 131072: {
                indentingWriter.p("(" + this.getName(type) + ") " + string + ".read_value(" + this.getName(type) + ".class);");
                break;
            }
            case 262144: {
                indentingWriter.p("(" + this.getName(type) + ") " + string + ".read_value(" + this.getName(type) + ".class);");
                break;
            }
            case 524288: {
                indentingWriter.p("(" + this.getName(type) + ") " + string + ".read_Object(" + this.getName(type) + ".class);");
                break;
            }
            default: {
                throw new Error("unexpected type code: " + n);
            }
        }
    }

    String[] getAllRemoteRepIDs(CompoundType compoundType) {
        int n;
        Object object;
        int n2;
        String[] stringArray;
        Type[] typeArray = this.collectAllRemoteInterfaces(compoundType);
        int n3 = typeArray.length;
        boolean bl = compoundType instanceof ImplementationType;
        Type[] typeArray2 = compoundType.getInterfaces();
        int n4 = this.countRemote(typeArray2, false);
        int n5 = 0;
        if (bl && n4 > 1) {
            stringArray = new String[n3 + 1];
            stringArray[0] = this.getRepositoryID(compoundType);
            n5 = 1;
        } else {
            stringArray = new String[n3];
            if (n3 > 1) {
                String string = null;
                if (bl) {
                    for (n2 = 0; n2 < typeArray2.length; ++n2) {
                        if (!typeArray2[n2].isType(4096)) continue;
                        string = typeArray2[n2].getRepositoryID();
                        break;
                    }
                } else {
                    string = compoundType.getRepositoryID();
                }
                for (n2 = 0; n2 < n3; ++n2) {
                    if (typeArray[n2].getRepositoryID() != string) continue;
                    if (n2 <= 0) break;
                    object = typeArray[0];
                    typeArray[0] = typeArray[n2];
                    typeArray[n2] = object;
                    break;
                }
            }
        }
        for (n = 0; n < typeArray.length; ++n) {
            stringArray[n5++] = this.getRepositoryID(typeArray[n]);
        }
        if (this.reverseIDs) {
            n = 0;
            n2 = stringArray.length - 1;
            while (n < n2) {
                object = stringArray[n];
                stringArray[n++] = stringArray[n2];
                stringArray[n2--] = object;
            }
        }
        return stringArray;
    }

    Type[] collectAllRemoteInterfaces(CompoundType compoundType) {
        Vector vector = new Vector();
        this.addRemoteInterfaces(vector, compoundType);
        Object[] objectArray = new Type[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    void addRemoteInterfaces(Vector vector, CompoundType compoundType) {
        if (compoundType != null) {
            if (compoundType.isInterface() && !vector.contains(compoundType)) {
                vector.addElement(compoundType);
            }
            InterfaceType[] interfaceTypeArray = compoundType.getInterfaces();
            for (int i = 0; i < interfaceTypeArray.length; ++i) {
                if (compoundType instanceof ImplementationType) {
                    if (!interfaceTypeArray[i].isType(4096) || interfaceTypeArray[i].isType(12288)) continue;
                    this.addRemoteInterfaces(vector, interfaceTypeArray[i]);
                    continue;
                }
                if (!interfaceTypeArray[i].isType(4096)) continue;
                this.addRemoteInterfaces(vector, interfaceTypeArray[i]);
            }
            this.addRemoteInterfaces(vector, compoundType.getSuperclass());
        }
    }

    RemoteType[] getDirectRemoteInterfaces(CompoundType compoundType) {
        RemoteType[] remoteTypeArray;
        if (compoundType instanceof ImplementationType) {
            Type[] typeArray = compoundType.getInterfaces();
            int n = this.countRemote(typeArray, false);
            if (n == 0) {
                throw new CompilerError("iiop.StubGenerator: No remote interfaces!");
            }
            remoteTypeArray = new RemoteType[n];
            int n2 = 0;
            for (int i = 0; i < typeArray.length; ++i) {
                if (!typeArray[i].isType(4096) || typeArray[i].isType(12288)) continue;
                remoteTypeArray[n2++] = (RemoteType)typeArray[i];
            }
        } else {
            if (!compoundType.isType(4096)) {
                throw new CompilerError("iiop.StubGenerator: Not a remote interface!");
            }
            remoteTypeArray = new RemoteType[]{(RemoteType)compoundType};
        }
        return remoteTypeArray;
    }

    int countRemote(Type[] typeArray, boolean bl) {
        int n = 0;
        for (int i = 0; i < typeArray.length; ++i) {
            if (!typeArray[i].isType(4096) || !bl && typeArray[i].isType(12288)) continue;
            ++n;
        }
        return n;
    }

    void writeCastArray(IndentingWriter indentingWriter) throws IOException {
        if (this.castArray) {
            indentingWriter.pln();
            indentingWriter.pln("// This method is required as a work-around for");
            indentingWriter.pln("// a bug in the JDK 1.1.6 verifier.");
            indentingWriter.pln();
            indentingWriter.plnI("private " + this.getName(sun.tools.java.Constants.idJavaIoSerializable) + " cast_array(" + this.getName(sun.tools.java.Constants.idJavaLangObject) + " obj) {");
            indentingWriter.pln("return (" + this.getName(sun.tools.java.Constants.idJavaIoSerializable) + ")obj;");
            indentingWriter.pOln("}");
        }
    }

    void writeIds(IndentingWriter indentingWriter, CompoundType compoundType) throws IOException {
        indentingWriter.plnI("private static final " + this.getName(sun.tools.java.Constants.idJavaLangString) + "[] _type_ids = {");
        String[] stringArray = this.getAllRemoteRepIDs(compoundType);
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    indentingWriter.pln(", ");
                }
                indentingWriter.p("\"" + stringArray[i] + "\"");
            }
            indentingWriter.pln();
        } else {
            indentingWriter.pln("\"\"");
        }
        indentingWriter.pOln("};");
    }

    protected void writeTie(Generator.OutputType outputType, IndentingWriter indentingWriter) throws IOException {
        if (this.isPOATie) {
            this.writePOATie(outputType, indentingWriter);
        } else {
            this.writeOriginalTie(outputType, indentingWriter);
        }
    }

    protected void writePOATie(Generator.OutputType outputType, IndentingWriter indentingWriter) throws IOException {
        CompoundType compoundType = (CompoundType)outputType.getType();
        Object var4_4 = null;
        indentingWriter.p("public class " + this.currentClass + " extends " + this.tieBaseClass + " implements " + this.getName(Constants.idTieInterface));
        if (!this.implementsRemote(compoundType)) {
            indentingWriter.pln(",");
            indentingWriter.p(this.getName(sun.rmi.rmic.Constants.idRemote));
        }
        indentingWriter.plnI(" {");
        indentingWriter.pln();
        indentingWriter.pln("private " + this.getName(compoundType) + " target = null;");
        indentingWriter.pln();
        this.writeIds(indentingWriter, compoundType);
        indentingWriter.pln();
        indentingWriter.plnI("public void setTarget(" + this.getName(sun.rmi.rmic.Constants.idRemote) + " target) {");
        indentingWriter.pln("this.target = (" + this.getName(compoundType) + ") target;");
        indentingWriter.pOln("}");
        indentingWriter.pln();
        indentingWriter.plnI("public " + this.getName(sun.rmi.rmic.Constants.idRemote) + " getTarget() {");
        indentingWriter.pln("return target;");
        indentingWriter.pOln("}");
        indentingWriter.pln();
        indentingWriter.plnI("public " + this.getName(Constants.idCorbaObject) + " thisObject() {");
        indentingWriter.pln("return _this_object();");
        indentingWriter.pOln("}");
        indentingWriter.pln();
        indentingWriter.plnI("public void deactivate() {");
        indentingWriter.plnI("try {");
        indentingWriter.pln("_poa().deactivate_object(_poa().servant_to_id(this));");
        indentingWriter.pOln("}");
        indentingWriter.pln("catch(" + this.getName(Constants.idWrongPolicy) + " e) { }");
        indentingWriter.pln("catch(" + this.getName(Constants.idObjectNotActive) + " e) { }");
        indentingWriter.pln("catch(" + this.getName(Constants.idServantNotActive) + " e) { }");
        indentingWriter.pOln("}");
        indentingWriter.pln();
        indentingWriter.plnI("public " + this.getName(Constants.idCorbaORB) + " orb() {");
        indentingWriter.pln("return _orb();");
        indentingWriter.pOln("}");
        indentingWriter.pln();
        indentingWriter.plnI("public void orb(" + this.getName(Constants.idCorbaORB) + " orb) {");
        indentingWriter.plnI("try {");
        indentingWriter.pln("((" + this.getName(Constants.idCorba23ORB) + ")orb).set_delegate(this);");
        indentingWriter.pOln("}");
        indentingWriter.plnI("catch(" + this.getName(Constants.idClassCastEx) + " e) {");
        indentingWriter.pln("throw new " + this.getName(Constants.idBadParamException) + "(\"POA Servant needs an org.omg.CORBA_2_3.ORB\");");
        indentingWriter.pOln("}");
        indentingWriter.pOln("}");
        indentingWriter.pln();
        indentingWriter.plnI("public " + this.getName(sun.tools.java.Constants.idJavaLangString) + "[] _all_interfaces(" + this.getName(Constants.idPOA) + " poa, byte[] objectId) { ");
        indentingWriter.pln("return _type_ids;");
        indentingWriter.pOln("}");
        CompoundType.Method[] methodArray = compoundType.getMethods();
        this.addNamesInUse(methodArray);
        this.addNameInUse("target");
        this.addNameInUse("_type_ids");
        this.writeCommonTieInvokeMethod(outputType, indentingWriter, methodArray);
        this.writeTieMethods(outputType, indentingWriter, methodArray);
        this.writeCastArray(indentingWriter);
        indentingWriter.pOln("}");
    }

    protected void writeOriginalTie(Generator.OutputType outputType, IndentingWriter indentingWriter) throws IOException {
        CompoundType compoundType = (CompoundType)outputType.getType();
        Object var4_4 = null;
        indentingWriter.p("public class " + this.currentClass + " extends " + this.tieBaseClass + " implements " + this.getName(Constants.idTieInterface));
        if (!this.implementsRemote(compoundType)) {
            indentingWriter.pln(",");
            indentingWriter.p(this.getName(sun.rmi.rmic.Constants.idRemote));
        }
        indentingWriter.plnI(" {");
        indentingWriter.pln();
        indentingWriter.pln("private " + this.getName(compoundType) + " target = null;");
        indentingWriter.pln("private " + this.getName(Constants.idCorbaORB) + " orb = null;");
        indentingWriter.pln();
        this.writeIds(indentingWriter, compoundType);
        indentingWriter.pln();
        indentingWriter.plnI("public void setTarget(" + this.getName(sun.rmi.rmic.Constants.idRemote) + " target) {");
        indentingWriter.pln("this.target = (" + this.getName(compoundType) + ") target;");
        indentingWriter.pOln("}");
        indentingWriter.pln();
        indentingWriter.plnI("public " + this.getName(sun.rmi.rmic.Constants.idRemote) + " getTarget() {");
        indentingWriter.pln("return target;");
        indentingWriter.pOln("}");
        indentingWriter.pln();
        indentingWriter.plnI("public " + this.getName(Constants.idCorbaObject) + " thisObject() {");
        indentingWriter.pln("return this;");
        indentingWriter.pOln("}");
        indentingWriter.pln();
        indentingWriter.plnI("public void deactivate() {");
        indentingWriter.plnI("if (orb != null) {");
        indentingWriter.pln("orb.disconnect(this);");
        indentingWriter.pln("_set_delegate(null);");
        indentingWriter.pOln("}");
        indentingWriter.pOln("}");
        indentingWriter.pln();
        indentingWriter.plnI("public " + this.getName(Constants.idCorbaORB) + " orb() {");
        indentingWriter.pln("return _orb();");
        indentingWriter.pOln("}");
        indentingWriter.pln();
        indentingWriter.plnI("public void orb(" + this.getName(Constants.idCorbaORB) + " orb) {");
        indentingWriter.pln("orb.connect(this);");
        indentingWriter.pOln("}");
        indentingWriter.pln();
        indentingWriter.plnI("public void _set_delegate(" + this.getName(Constants.idDelegate) + " del) {");
        indentingWriter.pln("super._set_delegate(del);");
        indentingWriter.plnI("if (del != null)");
        indentingWriter.pln("orb = _orb();");
        indentingWriter.pOlnI("else");
        indentingWriter.pln("orb = null;");
        indentingWriter.pO();
        indentingWriter.pOln("}");
        indentingWriter.pln();
        indentingWriter.plnI("public " + this.getName(sun.tools.java.Constants.idJavaLangString) + "[] _ids() { ");
        indentingWriter.pln("return _type_ids;");
        indentingWriter.pOln("}");
        CompoundType.Method[] methodArray = compoundType.getMethods();
        this.addNamesInUse(methodArray);
        this.addNameInUse("target");
        this.addNameInUse("_type_ids");
        this.writeCommonTieInvokeMethod(outputType, indentingWriter, methodArray);
        this.writeTieMethods(outputType, indentingWriter, methodArray);
        this.writeCastArray(indentingWriter);
        indentingWriter.pOln("}");
    }

    protected void writeCommonTieInvokeMethod(Generator.OutputType outputType, IndentingWriter indentingWriter, CompoundType.Method[] methodArray) throws IOException {
        CompoundType compoundType = (CompoundType)outputType.getType();
        indentingWriter.pln();
        String string = this.getVariableName("in");
        String string2 = this.getVariableName("_in");
        String string3 = this.getVariableName("ex");
        String string4 = this.getVariableName("method");
        String string5 = this.getVariableName("reply");
        indentingWriter.plnI("public " + this.getName(Constants.idOutputStream) + " _invoke(" + this.getName(sun.tools.java.Constants.idJavaLangString) + " " + string4 + ", " + this.getName(Constants.idInputStream) + " " + string2 + ", " + this.getName(Constants.idReplyHandler) + " " + string5 + ") throws " + this.getName(Constants.idSystemException) + " {");
        if (methodArray.length > 0) {
            indentingWriter.plnI("try {");
            indentingWriter.plnI(this.getName(Constants.idExtInputStream) + " " + string + " = ");
            indentingWriter.pln("(" + this.getName(Constants.idExtInputStream) + ") " + string2 + ";");
            indentingWriter.pO();
            StaticStringsHash staticStringsHash = this.getStringsHash(methodArray);
            if (staticStringsHash != null) {
                indentingWriter.plnI("switch (" + string4 + "." + staticStringsHash.method + ") {");
                for (int i = 0; i < staticStringsHash.buckets.length; ++i) {
                    indentingWriter.plnI("case " + staticStringsHash.keys[i] + ": ");
                    for (int j = 0; j < staticStringsHash.buckets[i].length; ++j) {
                        CompoundType.Method method = methodArray[staticStringsHash.buckets[i][j]];
                        if (j > 0) {
                            indentingWriter.pO("} else ");
                        }
                        indentingWriter.plnI("if (" + string4 + ".equals(\"" + method.getIDLName(true) + "\")) {");
                        indentingWriter.pln("return " + method.getIDLName(true) + "(" + string + ", " + string5 + ");");
                    }
                    indentingWriter.pOln("}");
                    indentingWriter.pO();
                }
            } else {
                for (int i = 0; i < methodArray.length; ++i) {
                    CompoundType.Method method = methodArray[i];
                    if (i > 0) {
                        indentingWriter.pO("} else ");
                    }
                    indentingWriter.plnI("if (" + string4 + ".equals(\"" + method.getIDLName(true) + "\")) {");
                    indentingWriter.pln("return " + method.getIDLName(true) + "(" + string + ", " + string5 + ");");
                }
            }
            indentingWriter.pOln("}");
            indentingWriter.pln("throw new " + this.getName(Constants.idBadMethodException) + "();");
            indentingWriter.pOlnI("} catch (" + this.getName(Constants.idSystemException) + " " + string3 + ") {");
            indentingWriter.pln("throw " + string3 + ";");
            indentingWriter.pOlnI("} catch (" + this.getName(sun.tools.java.Constants.idJavaLangThrowable) + " " + string3 + ") {");
            indentingWriter.pln("throw new " + this.getName(Constants.idPortableUnknownException) + "(" + string3 + ");");
            indentingWriter.pOln("}");
        } else {
            indentingWriter.pln("throw new " + this.getName(Constants.idBadMethodException) + "();");
        }
        indentingWriter.pOln("}");
    }

    protected void writeTieMethods(Generator.OutputType outputType, IndentingWriter indentingWriter, CompoundType.Method[] methodArray) throws IOException {
        CompoundType compoundType = (CompoundType)outputType.getType();
        String string = this.getVariableName("in");
        String string2 = this.getVariableName("reply");
        for (int i = 0; i < methodArray.length; ++i) {
            CompoundType.Method method = methodArray[i];
            indentingWriter.pln();
            indentingWriter.plnI("private " + this.getName(Constants.idOutputStream) + " " + method.getIDLName(true) + "(" + this.getName(Constants.idExtInputStream) + " " + string + " , " + this.getName(Constants.idReplyHandler) + " " + string2 + ") throws " + this.getName(sun.tools.java.Constants.idJavaLangThrowable) + " {");
            this.writeTieMethod(indentingWriter, compoundType, method);
            indentingWriter.pOln("}");
        }
    }

    StaticStringsHash getStringsHash(CompoundType.Method[] methodArray) {
        if (this.useHash && methodArray.length > 1) {
            String[] stringArray = new String[methodArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = methodArray[i].getIDLName(true);
            }
            return new StaticStringsHash(stringArray);
        }
        return null;
    }

    static boolean needNewReadStreamClass(Type type) {
        if (type.isType(12288)) {
            return true;
        }
        return StubGenerator.needNewWriteStreamClass(type);
    }

    static boolean needNewWriteStreamClass(Type type) {
        switch (type.getTypeCode()) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 32: 
            case 64: 
            case 128: 
            case 256: {
                return false;
            }
            case 512: {
                return true;
            }
            case 0x100000: {
                return true;
            }
            case 1024: {
                return false;
            }
            case 2048: {
                return false;
            }
            case 4096: {
                return false;
            }
            case 12288: {
                return false;
            }
            case 16384: {
                return true;
            }
            case 32768: {
                return true;
            }
            case 65536: {
                return true;
            }
            case 131072: {
                return true;
            }
            case 262144: {
                return true;
            }
            case 524288: {
                return false;
            }
        }
        throw new Error("unexpected type code: " + type.getTypeCode());
    }

    String[] writeCopyArguments(CompoundType.Method method, IndentingWriter indentingWriter) throws IOException {
        int n;
        int n2;
        Type[] typeArray = method.getArguments();
        String[] stringArray = method.getArgumentNames();
        String[] stringArray2 = new String[stringArray.length];
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            stringArray2[n2] = stringArray[n2];
        }
        n2 = 0;
        boolean[] blArray = new boolean[typeArray.length];
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < typeArray.length; ++n) {
            if (StubGenerator.mustCopy(typeArray[n])) {
                blArray[n] = true;
                ++n3;
                n4 = n;
                if (typeArray[n].getTypeCode() == 4096 || typeArray[n].getTypeCode() == 65536) continue;
                n2 = 1;
                continue;
            }
            blArray[n] = false;
        }
        if (n3 > 0) {
            if (n2 != 0) {
                for (n = 0; n < typeArray.length; ++n) {
                    if (typeArray[n].getTypeCode() != 512 && typeArray[n].getTypeCode() != 0x100000) continue;
                    blArray[n] = true;
                    ++n3;
                }
            }
            if (n3 > 1) {
                int n5;
                String string = this.getVariableName("copies");
                indentingWriter.p(this.getName(sun.tools.java.Constants.idJavaLangObject) + "[] " + string + " = " + this.getName(Constants.idCorbaUtil) + ".copyObjects(new " + this.getName(sun.tools.java.Constants.idJavaLangObject) + "[]{");
                boolean bl = true;
                for (n5 = 0; n5 < typeArray.length; ++n5) {
                    if (!blArray[n5]) continue;
                    if (!bl) {
                        indentingWriter.p(",");
                    }
                    bl = false;
                    indentingWriter.p(stringArray[n5]);
                }
                indentingWriter.pln("},_orb());");
                n5 = 0;
                for (int i = 0; i < typeArray.length; ++i) {
                    if (!blArray[i]) continue;
                    stringArray2[i] = this.getVariableName(stringArray2[i] + "Copy");
                    indentingWriter.pln(this.getName(typeArray[i]) + " " + stringArray2[i] + " = (" + this.getName(typeArray[i]) + ") " + string + "[" + n5++ + "];");
                }
            } else {
                stringArray2[n4] = this.getVariableName(stringArray2[n4] + "Copy");
                indentingWriter.pln(this.getName(typeArray[n4]) + " " + stringArray2[n4] + " = (" + this.getName(typeArray[n4]) + ") " + this.getName(Constants.idCorbaUtil) + ".copyObject(" + stringArray[n4] + ",_orb());");
            }
        }
        return stringArray2;
    }

    String getRepositoryID(Type type) {
        return IDLNames.replace(type.getRepositoryID(), SINGLE_SLASH, DOUBLE_SLASH);
    }

    String getExceptionRepositoryID(Type type) {
        ClassType classType = (ClassType)type;
        return IDLNames.getIDLRepositoryID(classType.getQualifiedIDLExceptionName(false));
    }

    String getVariableName(String string) {
        while (this.namesInUse.contains(string)) {
            string = "$" + string;
        }
        return string;
    }

    void addNamesInUse(CompoundType.Method[] methodArray) {
        for (int i = 0; i < methodArray.length; ++i) {
            this.addNamesInUse(methodArray[i]);
        }
    }

    void addNamesInUse(CompoundType.Method method) {
        String[] stringArray = method.getArgumentNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.addNameInUse(stringArray[i]);
        }
    }

    void addNameInUse(String string) {
        this.namesInUse.add(string);
    }

    static boolean mustCopy(Type type) {
        switch (type.getTypeCode()) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 32: 
            case 64: 
            case 128: 
            case 256: 
            case 512: {
                return false;
            }
            case 0x100000: {
                return false;
            }
            case 1024: {
                return true;
            }
            case 2048: {
                return false;
            }
            case 4096: 
            case 12288: 
            case 16384: 
            case 32768: 
            case 65536: 
            case 131072: 
            case 262144: 
            case 524288: {
                return true;
            }
        }
        throw new Error("unexpected type code: " + type.getTypeCode());
    }

    ValueType[] getStubExceptions(CompoundType.Method method, boolean bl) {
        ValueType[] valueTypeArray = method.getFilteredStubExceptions(method.getExceptions());
        if (bl) {
            Arrays.sort(valueTypeArray, new UserExceptionComparator());
        }
        return valueTypeArray;
    }

    ValueType[] getTieExceptions(CompoundType.Method method) {
        return method.getUniqueCatchList(method.getImplExceptions());
    }

    void writeTieMethod(IndentingWriter indentingWriter, CompoundType compoundType, CompoundType.Method method) throws IOException {
        int n;
        boolean bl;
        int n2;
        String string = IDLNames.expandEscapedSourceCharacters(method.getName());
        Type[] typeArray = method.getArguments();
        String[] stringArray = method.getArgumentNames();
        Type type = method.getReturnType();
        ValueType[] valueTypeArray = this.getTieExceptions(method);
        String string2 = this.getVariableName("in");
        String string3 = this.getVariableName("ex");
        String string4 = this.getVariableName("out");
        String string5 = this.getVariableName("reply");
        for (n2 = 0; n2 < typeArray.length; ++n2) {
            indentingWriter.p(this.getName(typeArray[n2]) + " " + stringArray[n2] + " = ");
            this.writeUnmarshalArgument(indentingWriter, string2, typeArray[n2], null);
            indentingWriter.pln();
        }
        n2 = valueTypeArray != null ? 1 : 0;
        boolean bl2 = bl = !type.isType(1);
        if (n2 != 0 && bl) {
            indentingWriter.pln(this.getName(type) + " result;");
        }
        if (n2 != 0) {
            indentingWriter.plnI("try {");
        }
        if (bl) {
            if (n2 != 0) {
                indentingWriter.p("result = ");
            } else {
                indentingWriter.p(this.getName(type) + " result = ");
            }
        }
        indentingWriter.p("target." + string + "(");
        for (n = 0; n < stringArray.length; ++n) {
            if (n > 0) {
                indentingWriter.p(", ");
            }
            indentingWriter.p(stringArray[n]);
        }
        indentingWriter.pln(");");
        if (n2 != 0) {
            for (n = 0; n < valueTypeArray.length; ++n) {
                indentingWriter.pOlnI("} catch (" + this.getName(valueTypeArray[n]) + " " + string3 + ") {");
                if (valueTypeArray[n].isIDLEntityException() && !valueTypeArray[n].isCORBAUserException()) {
                    String string6 = IDLNames.replace(valueTypeArray[n].getQualifiedIDLName(false), "::", ".");
                    string6 = string6 + "Helper";
                    indentingWriter.pln(this.getName(Constants.idOutputStream) + " " + string4 + " = " + string5 + ".createExceptionReply();");
                    indentingWriter.pln(string6 + ".write(" + string4 + "," + string3 + ");");
                } else {
                    indentingWriter.pln(this.getName(sun.tools.java.Constants.idJavaLangString) + " id = \"" + this.getExceptionRepositoryID(valueTypeArray[n]) + "\";");
                    indentingWriter.plnI(this.getName(Constants.idExtOutputStream) + " " + string4 + " = ");
                    indentingWriter.pln("(" + this.getName(Constants.idExtOutputStream) + ") " + string5 + ".createExceptionReply();");
                    indentingWriter.pOln(string4 + ".write_string(id);");
                    indentingWriter.pln(string4 + ".write_value(" + string3 + "," + this.getName(valueTypeArray[n]) + ".class);");
                }
                indentingWriter.pln("return " + string4 + ";");
            }
            indentingWriter.pOln("}");
        }
        if (StubGenerator.needNewWriteStreamClass(type)) {
            indentingWriter.plnI(this.getName(Constants.idExtOutputStream) + " " + string4 + " = ");
            indentingWriter.pln("(" + this.getName(Constants.idExtOutputStream) + ") " + string5 + ".createReply();");
            indentingWriter.pO();
        } else {
            indentingWriter.pln(this.getName(Constants.idOutputStream) + " " + string4 + " = " + string5 + ".createReply();");
        }
        if (bl) {
            this.writeMarshalArgument(indentingWriter, string4, type, "result");
            indentingWriter.pln();
        }
        indentingWriter.pln("return " + string4 + ";");
    }

    void writeMarshalArguments(IndentingWriter indentingWriter, String string, Type[] typeArray, String[] stringArray) throws IOException {
        if (typeArray.length != stringArray.length) {
            throw new Error("paramter type and name arrays different sizes");
        }
        for (int i = 0; i < typeArray.length; ++i) {
            this.writeMarshalArgument(indentingWriter, string, typeArray[i], stringArray[i]);
            if (i == typeArray.length - 1) continue;
            indentingWriter.pln();
        }
    }

    protected void checkParents(Type type) {
    }

    private class ClassNameTable {
        private TreeMap table = new TreeMap();
        private boolean readOnly = false;

        public void addClass(String string) {
            if (!this.readOnly) {
                this.table.put(string, string);
            } else {
                this.printError("Cannot add class '" + string + "' to ClassNameTable - table is read-only.");
            }
        }

        public void addClass(Identifier identifier) {
            this.addClass(identifier.toString());
        }

        public Iterator getClasses() {
            return this.table.keySet().iterator();
        }

        public boolean contains(String string) {
            return this.table.containsKey(string);
        }

        public void reset() {
            this.table.clear();
            this.readOnly = false;
        }

        public boolean isReadable() {
            return this.readOnly;
        }

        public boolean isWriteable() {
            return !this.readOnly;
        }

        public void makeReadOnly() {
            if (this.readOnly) {
                this.printError("ClassNameTable is already read-only.");
            }
            this.readOnly = true;
        }

        public void setNameToUse(String string, String string2) {
            if (!this.readOnly) {
                this.table.put(string, string2);
            } else {
                this.printError("Cannot update the name-to-use for '" + string + "': ClassNameTable is read-only.");
            }
        }

        public String getNameToUse(String string) {
            if (this.readOnly) {
                String string2 = (String)this.table.get(string);
                if (string2 != null) {
                    return string2;
                }
                return string;
            }
            this.printError("Name requested for '" + string + "': ClassNameTable is write-only.");
            return string;
        }

        protected String getProvisionalName(String string) {
            return (String)this.table.get(string);
        }

        public void listEntries(OutputStream outputStream, String string) throws IOException {
            int n;
            Iterator iterator = this.table.keySet().iterator();
            int n2 = 0;
            int n3 = 0;
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                n = string2.length();
                int n4 = ((String)this.table.get(string2)).length();
                n2 = n > n2 ? n : n2;
                n3 = n4 > n3 ? n4 : n3;
            }
            int n5 = n2 + n3 + 3;
            outputStream.write(("\nGenerated file: '" + string + "'\n").getBytes());
            outputStream.write((this.pad("Fully Qualified Name:", n2) + " | " + this.pad("Name To Use:", n3) + "\n").getBytes());
            for (n = 0; n < n5; ++n) {
                outputStream.write("-".getBytes());
            }
            iterator = this.table.keySet().iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                outputStream.write(("\n" + this.pad(string3, n2) + " | " + this.pad((String)this.table.get(string3), n3)).getBytes());
            }
            outputStream.write("\n".getBytes());
        }

        private String pad(String string, int n) {
            StringBuffer stringBuffer = new StringBuffer(string);
            while (stringBuffer.length() < n) {
                stringBuffer.append(" ");
            }
            return stringBuffer.substring(0, n);
        }

        private void printError(String string) {
            System.err.println("Error: " + string);
            new Throwable().printStackTrace();
        }
    }

    private static class ImportEntry {
        public static final int CORBA_2_3 = -1;
        public static final int OTHER = 0;
        public static final int LANG = 1;
        public static final int PACKAGE = 2;
        public static final int DEFAULT = 3;
        private final String qualifiedName;
        private final int importOrder;

        public ImportEntry(String string, int n) {
            this.qualifiedName = string;
            this.importOrder = n;
        }

        public static int getOrderFromPackageName(String string, String string2) {
            if (string == null || string.equals("")) {
                return 3;
            }
            if (string2 != null && string.equals(string2)) {
                return 2;
            }
            if (string.equals("java.lang")) {
                return 1;
            }
            if (string.startsWith("org.omg.CORBA_2_3")) {
                return -1;
            }
            return 0;
        }

        public String getQualifiedName() {
            return this.qualifiedName;
        }

        public int getImportOrder() {
            return this.importOrder;
        }

        public String getImportName() {
            return this.importOrder == 2 || this.importOrder == 3 ? null : this.qualifiedName;
        }
    }
}

