/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.idl;

import com.ibm.idl.ActualDcl;
import com.ibm.idl.Arguments;
import com.ibm.idl.AttributeEntry;
import com.ibm.idl.CORBALevel;
import com.ibm.idl.Comment;
import com.ibm.idl.ConstEntry;
import com.ibm.idl.DirectiveEntry;
import com.ibm.idl.EnumEntry;
import com.ibm.idl.EnumValueEntry;
import com.ibm.idl.ExceptionEntry;
import com.ibm.idl.FactoryMethodEntry;
import com.ibm.idl.ForwardDclEntry;
import com.ibm.idl.ForwardEntry;
import com.ibm.idl.ForwardStructEntry;
import com.ibm.idl.ForwardUnionEntry;
import com.ibm.idl.ForwardValueEntry;
import com.ibm.idl.IDLID;
import com.ibm.idl.IncludeEntry;
import com.ibm.idl.InterfaceEntry;
import com.ibm.idl.InterfaceState;
import com.ibm.idl.MethodEntry;
import com.ibm.idl.ModuleEntry;
import com.ibm.idl.ParameterEntry;
import com.ibm.idl.ParseException;
import com.ibm.idl.Preprocessor;
import com.ibm.idl.PrimitiveEntry;
import com.ibm.idl.Scanner;
import com.ibm.idl.SequenceEntry;
import com.ibm.idl.StringEntry;
import com.ibm.idl.StructEntry;
import com.ibm.idl.SymtabEntry;
import com.ibm.idl.SymtabFactory;
import com.ibm.idl.Token;
import com.ibm.idl.TokenBuffer;
import com.ibm.idl.TypedefEntry;
import com.ibm.idl.UnionBranch;
import com.ibm.idl.UnionEntry;
import com.ibm.idl.Util;
import com.ibm.idl.ValueBoxEntry;
import com.ibm.idl.ValueEntry;
import com.ibm.idl.constExpr.BinaryExpr;
import com.ibm.idl.constExpr.EvaluationException;
import com.ibm.idl.constExpr.ExprFactory;
import com.ibm.idl.constExpr.Expression;
import com.ibm.idl.constExpr.Negative;
import com.ibm.idl.constExpr.Not;
import com.ibm.idl.constExpr.Positive;
import com.ibm.idl.constExpr.Terminal;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

class Parser {
    private boolean _isModuleLegalType = false;
    private static final int MAX_SHORT = Short.MAX_VALUE;
    private static final int MIN_SHORT = Short.MIN_VALUE;
    private static final int MAX_USHORT = 65535;
    private static final int MIN_OCTET = 0;
    private static final int MAX_OCTET = 255;
    final double SPEC_MAX_FLOAT = 3.40282347E38;
    final double SPEC_MIN_FLOAT = 1.40239846E-45;
    final String SPEC_MAX_DOUBLE = "1.79769313486231570e308";
    final String SPEC_MIN_DOUBLE = "4.94065645841246544e-324";
    static long symbolTableCount = 0L;
    public static final String unknownNamePrefix = "uN__";
    static Hashtable symbolTable;
    Hashtable lcSymbolTable = new Hashtable();
    Hashtable introducedSymbolTable = new Hashtable();
    static Hashtable overrideNames;
    Vector emitList = new Vector();
    Vector emitList2 = new Vector();
    boolean emitAll;
    boolean cppModule;
    boolean noWarn;
    Scanner scanner;
    Hashtable symbols;
    Vector macros = new Vector();
    Vector paths;
    SymtabEntry currentModule = null;
    InterfaceEntry currentInterface = null;
    static Stack repIDStack;
    int sequence = 0;
    Vector includes;
    Vector includeEntries;
    boolean parsingConditionalExpr = false;
    Token token;
    Token token2 = null;
    ModuleEntry topLevelModule;
    private Preprocessor prep;
    private boolean useLatin1;
    private boolean verbose;
    SymtabFactory stFactory;
    ExprFactory exprFactory;
    private String[] keywords;
    private TokenBuffer tokenHistory = new TokenBuffer();
    private boolean allowInheritanceOfFwdInterface = false;
    private boolean allowMissingInterfaces = false;
    private boolean issueAnonTypeMessages = false;
    protected CORBALevel corbaLevel;

    Parser(Preprocessor preprocessor, Arguments arguments, Hashtable hashtable, Hashtable hashtable2, SymtabFactory symtabFactory, ExprFactory exprFactory, String[] stringArray) {
        this.noWarn = arguments.noWarn;
        this.corbaLevel = arguments.corbaLevel;
        this.paths = arguments.includePaths;
        this.symbols = arguments.definedSymbols;
        this.verbose = arguments.verbose;
        this.emitAll = arguments.emitAll;
        this.useLatin1 = arguments.useLatin1;
        this.cppModule = arguments.cppModule;
        this.allowMissingInterfaces = arguments.missingInterfaces;
        overrideNames = hashtable == null ? new Hashtable() : hashtable;
        symbolTable = hashtable2 == null ? new Hashtable() : hashtable2;
        this.keywords = stringArray == null ? new String[]{} : stringArray;
        this.stFactory = symtabFactory;
        this.exprFactory = exprFactory;
        this.topLevelModule = new ModuleEntry();
        this.currentModule = this.topLevelModule;
        this.prep = preprocessor;
        repIDStack.push(new IDLID());
        this.addPrimEntries();
    }

    void parse(String string) throws IOException {
        IncludeEntry includeEntry = this.stFactory.includeEntry();
        includeEntry.name('\"' + string + '\"');
        try {
            includeEntry.absFilename(Util.getAbsolutePath(string, this.paths));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.scanner = new Scanner(includeEntry, this.keywords, this.verbose, this.emitAll, this.corbaLevel, this.useLatin1);
        this.topLevelModule.sourceFile(includeEntry);
        this.token = new Token(0);
        this.tokenHistory.insert(this.token);
        try {
            this.match(0);
            if (this.token.equals(999)) {
                ParseException.nothing(string);
            } else {
                this.specification(this.topLevelModule);
            }
        }
        catch (ParseException parseException) {
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    private void addPrimEntries() {
        symbolTable.put("short", this.stFactory.primitiveEntry("short"));
        symbolTable.put("long", this.stFactory.primitiveEntry("long"));
        symbolTable.put("long long", this.stFactory.primitiveEntry("long long"));
        symbolTable.put("unsigned short", this.stFactory.primitiveEntry("unsigned short"));
        symbolTable.put("unsigned long", this.stFactory.primitiveEntry("unsigned long"));
        symbolTable.put("unsigned long long", this.stFactory.primitiveEntry("unsigned long long"));
        symbolTable.put("char", this.stFactory.primitiveEntry("char"));
        symbolTable.put("wchar", this.stFactory.primitiveEntry("wchar"));
        symbolTable.put("float", this.stFactory.primitiveEntry("float"));
        symbolTable.put("fixed", this.stFactory.primitiveEntry("fixed"));
        symbolTable.put("native", this.stFactory.primitiveEntry("native"));
        symbolTable.put("double", this.stFactory.primitiveEntry("double"));
        symbolTable.put("long double", this.stFactory.primitiveEntry("long double"));
        symbolTable.put("boolean", this.stFactory.primitiveEntry("boolean"));
        symbolTable.put("octet", this.stFactory.primitiveEntry("octet"));
        symbolTable.put("any", this.stFactory.primitiveEntry("any"));
        InterfaceEntry interfaceEntry = this.stFactory.interfaceEntry();
        interfaceEntry.name("Object");
        symbolTable.put("Object", interfaceEntry);
        ValueEntry valueEntry = this.stFactory.valueEntry();
        valueEntry.name("ValueBase");
        symbolTable.put("ValueBase", valueEntry);
        this.lcSymbolTable.put("short", this.stFactory.primitiveEntry("short"));
        this.lcSymbolTable.put("long", this.stFactory.primitiveEntry("long"));
        this.lcSymbolTable.put("long long", this.stFactory.primitiveEntry("long long"));
        this.lcSymbolTable.put("unsigned short", this.stFactory.primitiveEntry("unsigned short"));
        this.lcSymbolTable.put("unsigned long", this.stFactory.primitiveEntry("unsigned long"));
        this.lcSymbolTable.put("unsigned long long", this.stFactory.primitiveEntry("unsigned long long"));
        this.lcSymbolTable.put("char", this.stFactory.primitiveEntry("char"));
        this.lcSymbolTable.put("wchar", this.stFactory.primitiveEntry("wchar"));
        this.lcSymbolTable.put("float", this.stFactory.primitiveEntry("float"));
        this.lcSymbolTable.put("fixed", this.stFactory.primitiveEntry("fixed"));
        this.lcSymbolTable.put("native", this.stFactory.primitiveEntry("native"));
        this.lcSymbolTable.put("double", this.stFactory.primitiveEntry("double"));
        this.lcSymbolTable.put("long double", this.stFactory.primitiveEntry("long double"));
        this.lcSymbolTable.put("boolean", this.stFactory.primitiveEntry("boolean"));
        this.lcSymbolTable.put("octet", this.stFactory.primitiveEntry("octet"));
        this.lcSymbolTable.put("any", this.stFactory.primitiveEntry("any"));
        this.lcSymbolTable.put("object", interfaceEntry);
        this.lcSymbolTable.put("valuebase", valueEntry);
    }

    private void specification(ModuleEntry moduleEntry) throws IOException {
        while (!this.token.equals(999)) {
            this.definition(moduleEntry);
            this.addToEmitList(moduleEntry);
        }
        this.processEmitList2();
        this.checkValueTypeInheritance();
    }

    private void addToEmitList(ModuleEntry moduleEntry) {
        Enumeration enumeration = moduleEntry.contained().elements();
        while (enumeration.hasMoreElements()) {
            SymtabEntry symtabEntry = (SymtabEntry)enumeration.nextElement();
            if (symtabEntry instanceof DirectiveEntry) continue;
            if (symtabEntry.emit()) {
                this.emitList.addElement(symtabEntry);
                if (!(symtabEntry instanceof IncludeEntry)) continue;
                this.includes.addElement(symtabEntry.name());
                this.includeEntries.addElement(symtabEntry);
                continue;
            }
            if (!(symtabEntry instanceof ModuleEntry)) continue;
            this.checkContained((ModuleEntry)symtabEntry);
        }
        this.addToEmitList2(moduleEntry);
        moduleEntry.contained().removeAllElements();
    }

    private void addToEmitList2(ModuleEntry moduleEntry) {
        if (moduleEntry.contained().isEmpty()) {
            return;
        }
        Enumeration enumeration = moduleEntry.contained().elements();
        while (enumeration.hasMoreElements()) {
            SymtabEntry symtabEntry = (SymtabEntry)enumeration.nextElement();
            if (symtabEntry.emit()) {
                this.emitList2.addElement(symtabEntry);
                continue;
            }
            if (!(symtabEntry instanceof ModuleEntry)) continue;
            this.checkContained((ModuleEntry)symtabEntry);
        }
    }

    private void processEmitList2() {
        Object object;
        if (this.emitList2.size() == 0) {
            return;
        }
        Object object2 = (SymtabEntry)this.emitList2.firstElement();
        File file = null;
        String string = "";
        Vector<SymtabEntry> vector = new Vector<SymtabEntry>();
        Enumeration enumeration = this.emitList2.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (SymtabEntry)enumeration.nextElement();
            if (file == null && ((SymtabEntry)object2).sourceFile() != null) {
                file = new File(((SymtabEntry)object2).sourceFile().absFilename());
                try {
                    string = file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (((SymtabEntry)object2).sourceFile() == null) continue;
            File file2 = new File(((SymtabEntry)object2).sourceFile().absFilename());
            object = "";
            try {
                object = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (file == null || file2 == null || string == null || object == null || !string.equals(object)) continue;
            vector.add((SymtabEntry)object2);
        }
        this.emitList2 = new Vector();
        object2 = null;
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            object = (SymtabEntry)vector.elementAt(i);
            boolean bl = false;
            if (object2 == null || ((SymtabEntry)object2).lineNumber() >= ((SymtabEntry)object).lineNumber()) {
                n = 0;
            }
            if (((SymtabEntry)object).lineNumber() == 0 && i > 0) {
                ((SymtabEntry)object).lineNumber(((SymtabEntry)vector.elementAt(i - 1)).lineNumber());
            }
            for (int j = n; j < this.emitList2.size() && !bl; ++j) {
                object2 = (SymtabEntry)this.emitList2.elementAt(j);
                n = j;
                if (((SymtabEntry)object2).name().compareTo(((SymtabEntry)object).name()) == 0 && ((SymtabEntry)object2).lineNumber() == ((SymtabEntry)object).lineNumber() && ((SymtabEntry)object2).type() == ((SymtabEntry)object).type()) {
                    bl = true;
                }
                if (((SymtabEntry)object2).lineNumber() <= ((SymtabEntry)object).lineNumber()) continue;
                this.emitList2.insertElementAt(object, j);
                object2 = object;
                bl = true;
            }
            if (bl) continue;
            this.emitList2.insertElementAt(object, this.emitList2.size());
            n = this.emitList2.size() - 1;
            object2 = object;
        }
    }

    private void checkContained(ModuleEntry moduleEntry) {
        Enumeration enumeration = moduleEntry.contained().elements();
        while (enumeration.hasMoreElements()) {
            SymtabEntry symtabEntry = (SymtabEntry)enumeration.nextElement();
            if (symtabEntry instanceof ModuleEntry) {
                this.checkContained((ModuleEntry)symtabEntry);
            }
            if (!symtabEntry.emit()) continue;
            if (!this.emitList.contains(moduleEntry)) {
                this.emitList.addElement(moduleEntry);
                this.emitList2.addElement(moduleEntry);
            }
            moduleEntry.emit(true);
            break;
        }
    }

    private void checkValueTypeInheritance() {
        Enumeration enumeration = this.emitList.elements();
        while (enumeration.hasMoreElements()) {
            SymtabEntry symtabEntry = (SymtabEntry)enumeration.nextElement();
            if (symtabEntry instanceof ModuleEntry) {
                Enumeration enumeration2 = ((ModuleEntry)symtabEntry).contained().elements();
                while (enumeration2.hasMoreElements()) {
                    SymtabEntry symtabEntry2 = (SymtabEntry)enumeration2.nextElement();
                    if (!(symtabEntry2 instanceof ValueEntry)) continue;
                    ((ValueEntry)symtabEntry2).checkInheritanceConflicts(null, false);
                }
                continue;
            }
            if (!(symtabEntry instanceof ValueEntry)) continue;
            ((ValueEntry)symtabEntry).checkInheritanceConflicts(null, false);
        }
    }

    private void definition(ModuleEntry moduleEntry) throws IOException {
        try {
            switch (this.token.type) {
                case 9: 
                case 27: 
                case 30: 
                case 32: 
                case 46: {
                    this.typeDcl(moduleEntry);
                    break;
                }
                case 5: {
                    this.constDcl(moduleEntry);
                    break;
                }
                case 10: {
                    this.exceptDcl(moduleEntry);
                    break;
                }
                case 15: {
                    this.interfaceProd(moduleEntry, false, false);
                    break;
                }
                case 17: {
                    this.module(moduleEntry);
                    break;
                }
                case 36: {
                    this.match(36);
                    if (this.token.type == 15) {
                        this.interfaceProd(moduleEntry, true, false);
                        break;
                    }
                    if (this.token.type == 43) {
                        this.valueProd(moduleEntry, true);
                        break;
                    }
                    throw ParseException.syntaxError(this.scanner, new int[]{15, 43}, this.token.type);
                }
                case 48: {
                    this.match(48);
                    if (this.token.type == 15) {
                        this.interfaceProd(moduleEntry, false, true);
                        break;
                    }
                    throw ParseException.syntaxError(this.scanner, new int[]{15}, this.token.type);
                }
                case 37: 
                case 43: {
                    this.valueProd(moduleEntry, false);
                    break;
                }
                default: {
                    throw ParseException.syntaxError(this.scanner, new int[]{30, 27, 32, 9, 46, 5, 10, 15, 43, 17}, this.token.type);
                }
            }
            this.match(100);
        }
        catch (ParseException parseException) {
            this.skipToSemicolon();
        }
    }

    private void module(ModuleEntry moduleEntry) throws IOException, ParseException {
        this.match(17);
        repIDStack.push(((IDLID)repIDStack.peek()).clone());
        ModuleEntry moduleEntry2 = this.newModule(moduleEntry);
        ((IDLID)repIDStack.peek()).appendToName(moduleEntry2.name());
        moduleEntry2.comment(this.tokenHistory.lookBack((int)1).comment);
        this.currentModule = moduleEntry2;
        this.prep.setModulePragma(moduleEntry2);
        this.match(60);
        this.prep.openScope(moduleEntry2);
        this.match(101);
        this.definition(moduleEntry2);
        while (!this.token.equals(999) && !this.token.equals(102)) {
            this.definition(moduleEntry2);
        }
        this.prep.closeScope(moduleEntry2);
        this.match(102);
        this.currentModule = moduleEntry;
        repIDStack.pop();
    }

    private void interfaceProd(ModuleEntry moduleEntry, boolean bl, boolean bl2) throws IOException, ParseException {
        this.match(15);
        String string = this.token.name;
        this.match(60);
        this.interface2(moduleEntry, string, bl, bl2);
    }

    private void interface2(ModuleEntry moduleEntry, String string, boolean bl, boolean bl2) throws IOException, ParseException {
        if (this.token.type == 103 || this.token.type == 101) {
            repIDStack.push(((IDLID)repIDStack.peek()).clone());
            InterfaceEntry interfaceEntry = this.stFactory.interfaceEntry(moduleEntry, (IDLID)repIDStack.peek());
            interfaceEntry.sourceFile(this.scanner.fileEntry());
            interfaceEntry.lineNumber(this.scanner.currentLineNumber());
            interfaceEntry.name(string);
            interfaceEntry.setAbstract(bl);
            interfaceEntry.setLocal(bl2);
            if (bl2) {
                interfaceEntry.localOnly(true);
            }
            interfaceEntry.comment(this.tokenHistory.lookBack((int)(bl || bl2 ? 3 : 2)).comment);
            SymtabEntry symtabEntry = this.getSymtabEntry(interfaceEntry.fullName());
            if (symtabEntry != null & symtabEntry instanceof ForwardEntry) {
                if (!((ForwardEntry)symtabEntry).match(interfaceEntry)) {
                    ParseException.badAbstract(this.scanner, interfaceEntry.fullName());
                }
                ((ForwardEntry)symtabEntry).replaceForwardDcl(interfaceEntry, this.scanner);
            }
            this.pigeonhole(moduleEntry, interfaceEntry);
            ((IDLID)repIDStack.peek()).appendToName(string);
            this.currentModule = interfaceEntry;
            this.currentInterface = interfaceEntry;
            this.interfaceDcl(interfaceEntry);
            this.currentModule = moduleEntry;
            repIDStack.pop();
        } else {
            ForwardEntry forwardEntry = this.stFactory.forwardEntry(moduleEntry, (IDLID)repIDStack.peek());
            forwardEntry.sourceFile(this.scanner.fileEntry());
            forwardEntry.lineNumber(this.scanner.currentLineNumber());
            forwardEntry.name(string);
            forwardEntry.setAbstract(bl);
            forwardEntry.setLocal(bl2);
            forwardEntry.localOnly(bl2);
            forwardEntry.comment(this.tokenHistory.lookBack((int)(bl || bl2 ? 3 : 2)).comment);
            this.pigeonhole(moduleEntry, forwardEntry);
        }
    }

    private void interfaceDcl(InterfaceEntry interfaceEntry) throws IOException, ParseException {
        if (this.token.type != 101) {
            this.inheritanceSpec(interfaceEntry);
        } else if (!interfaceEntry.isAbstract()) {
            SymtabEntry symtabEntry = this.qualifiedEntry("Object");
            SymtabEntry symtabEntry2 = Parser.typeOf(symtabEntry);
            if (symtabEntry != null) {
                if (!this.isInterfaceOnly(symtabEntry2)) {
                    ParseException.wrongType(this.scanner, Parser.overrideName("Object"), "interface", symtabEntry.typeName());
                } else {
                    interfaceEntry.derivedFromAddElement(symtabEntry2, this.scanner);
                }
            }
        }
        this.prep.openScope(interfaceEntry);
        this.match(101);
        while (this.token.type != 102) {
            this.export(interfaceEntry);
        }
        this.prep.closeScope(interfaceEntry);
        this.match(102);
        this.currentInterface = null;
    }

    private void export(InterfaceEntry interfaceEntry) throws IOException {
        try {
            switch (this.token.type) {
                case 9: 
                case 27: 
                case 30: 
                case 32: 
                case 46: {
                    this.typeDcl(interfaceEntry);
                    break;
                }
                case 5: {
                    this.constDcl(interfaceEntry);
                    break;
                }
                case 10: {
                    this.exceptDcl(interfaceEntry);
                    break;
                }
                case 1: 
                case 23: {
                    this.attrDcl(interfaceEntry);
                    break;
                }
                case 0: 
                case 2: 
                case 4: 
                case 8: 
                case 12: 
                case 16: 
                case 18: 
                case 19: 
                case 20: 
                case 25: 
                case 26: 
                case 31: 
                case 33: 
                case 34: 
                case 35: 
                case 42: 
                case 45: 
                case 60: 
                case 124: {
                    this.opDcl(interfaceEntry);
                    break;
                }
                default: {
                    throw ParseException.syntaxError(this.scanner, new int[]{30, 27, 32, 9, 46, 5, 10, 23, 1, 20, 12, 8, 16, 25, 31, 4, 34, 2, 19, 0, 26, 35, 60, 124, 33, 42}, this.token.type);
                }
            }
            this.match(100);
        }
        catch (ParseException parseException) {
            this.skipToSemicolon();
        }
    }

    private void inheritanceSpec(InterfaceEntry interfaceEntry) throws IOException, ParseException {
        this.match(103);
        while (true) {
            SymtabEntry symtabEntry = this.scopedName(interfaceEntry.container(), this.stFactory.interfaceEntry());
            SymtabEntry symtabEntry2 = Parser.typeOf(symtabEntry);
            if (!this.allowInheritanceOfFwdInterface && symtabEntry2 instanceof ForwardEntry) {
                ParseException.inhForwardDeclare(this.scanner, symtabEntry2.name());
            } else if (this.isInterfaceOnly(symtabEntry2)) {
                boolean bl;
                boolean bl2 = symtabEntry2 instanceof InterfaceEntry && ((InterfaceEntry)symtabEntry2).isAbstract() || symtabEntry2 instanceof ForwardEntry && ((ForwardEntry)symtabEntry2).isAbstract();
                boolean bl3 = bl = symtabEntry2 instanceof InterfaceEntry && ((InterfaceEntry)symtabEntry2).isLocal() || symtabEntry2 instanceof ForwardEntry && ((ForwardEntry)symtabEntry2).isLocal();
                if (interfaceEntry.derivedFrom().contains(symtabEntry2)) {
                    ParseException.alreadyDerived(this.scanner, symtabEntry2.fullName(), interfaceEntry.fullName());
                } else if (interfaceEntry.isAbstract() && !bl2) {
                    ParseException.nonAbstractParent(this.scanner, interfaceEntry.fullName(), symtabEntry.fullName());
                } else if (!interfaceEntry.isLocal() && bl) {
                    ParseException.localInhProblem(this.scanner, interfaceEntry.fullName(), symtabEntry.fullName());
                } else {
                    interfaceEntry.derivedFromAddElement(symtabEntry2, this.scanner);
                }
            } else {
                ParseException.wrongType(this.scanner, symtabEntry.fullName(), "interface", this.entryName(symtabEntry));
            }
            if (symtabEntry instanceof InterfaceEntry && ((InterfaceEntry)symtabEntry).state() != null) {
                if (interfaceEntry.state() == null) {
                    interfaceEntry.initState();
                } else {
                    throw ParseException.badState(this.scanner, interfaceEntry.fullName());
                }
            }
            if (this.token.type != 104) break;
            this.match(104);
        }
    }

    public boolean isModuleLegalType() {
        return this._isModuleLegalType;
    }

    public void isModuleLegalType(boolean bl) {
        this._isModuleLegalType = bl;
    }

    SymtabEntry scopedName(SymtabEntry symtabEntry, SymtabEntry symtabEntry2) throws IOException, ParseException {
        Object object;
        SymtabEntry symtabEntry3;
        boolean bl = false;
        boolean bl2 = false;
        String string = null;
        String string2 = null;
        if (this.token.type == 124) {
            bl = true;
        } else if (this.token.type == 18) {
            string = "Object";
            string2 = this.token.name;
            this.match(18);
        } else if (this.token.type == 42) {
            string = "ValueBase";
            string2 = this.token.name;
            this.match(42);
        } else {
            string = this.token.name;
            string2 = this.token.name;
            this.match(60);
        }
        while (this.token.type == 124) {
            this.match(124);
            bl2 = true;
            if (string != null) {
                string = string + '/' + this.token.name;
            } else {
                string = this.token.name;
                string2 = this.token.name;
            }
            this.match(60);
        }
        SymtabEntry symtabEntry4 = null;
        symtabEntry4 = bl ? this.qualifiedEntry(string) : (bl2 ? this.partlyQualifiedEntry(string, symtabEntry) : this.unqualifiedEntry(string, symtabEntry));
        if (symtabEntry4 != null && !bl && string2 != null && symtabEntry != symtabEntry4 && symtabEntry != null && (symtabEntry3 = this.getSymtabEntry((String)(object = symtabEntry.fullName() + '/' + string2))) == null && (symtabEntry3 = string2.equals(string) ? symtabEntry4 : this.resolve(string2, symtabEntry, true, false, false, true)) != null) {
            String string3 = ((String)object).toLowerCase();
            this.introducedSymbolTable.put(string3, symtabEntry3);
        }
        if (symtabEntry4 == null) {
            symtabEntry4 = symtabEntry2;
            symtabEntry4.name(string);
        }
        if (symtabEntry4 != null && symtabEntry4 instanceof ValueBoxEntry && !((ValueBoxEntry)symtabEntry4).definitionComplete()) {
            ParseException.nestedValueBox(this.scanner);
        }
        if ((object = symtabEntry) != null && !(object instanceof ModuleEntry) && !(object instanceof InterfaceEntry)) {
            object = ((SymtabEntry)object).container();
        }
        if (object != null) {
            symtabEntry4.useRef((SymtabEntry)object);
        }
        return symtabEntry4;
    }

    private void valueProd(ModuleEntry moduleEntry, boolean bl) throws IOException, ParseException {
        boolean bl2;
        boolean bl3 = bl2 = this.token.type == 37;
        if (bl2) {
            this.match(37);
        }
        this.match(43);
        String string = this.token.name;
        this.match(60);
        switch (this.token.type) {
            case 40: 
            case 101: 
            case 103: {
                this.value2(moduleEntry, string, bl, bl2);
                return;
            }
            case 100: {
                if (bl2) break;
                this.valueForwardDcl(moduleEntry, string, bl);
                return;
            }
        }
        if (bl2) {
            throw ParseException.badCustom(this.scanner);
        }
        if (bl) {
            throw ParseException.abstractValueBox(this.scanner);
        }
        this.valueBox(moduleEntry, string);
    }

    private void value2(ModuleEntry moduleEntry, String string, boolean bl, boolean bl2) throws IOException, ParseException {
        repIDStack.push(((IDLID)repIDStack.peek()).clone());
        ValueEntry valueEntry = this.stFactory.valueEntry(moduleEntry, (IDLID)repIDStack.peek());
        valueEntry.sourceFile(this.scanner.fileEntry());
        valueEntry.lineNumber(this.scanner.currentLineNumber());
        valueEntry.name(string);
        valueEntry.setAbstract(bl);
        valueEntry.setCustom(bl2);
        valueEntry.comment(this.tokenHistory.lookBack((int)(bl || bl2 ? 3 : 2)).comment);
        SymtabEntry symtabEntry = this.getSymtabEntry(valueEntry.fullName());
        if (symtabEntry != null & symtabEntry instanceof ForwardValueEntry) {
            if (!((ForwardValueEntry)symtabEntry).match(valueEntry)) {
                ParseException.badAbstract(this.scanner, valueEntry.fullName());
            }
            ((ForwardValueEntry)symtabEntry).replaceForwardDcl(valueEntry, this.scanner);
        }
        this.pigeonhole(moduleEntry, valueEntry);
        ((IDLID)repIDStack.peek()).appendToName(string);
        this.currentModule = valueEntry;
        this.valueDcl(valueEntry);
        valueEntry.tagMethods();
        this.currentModule = moduleEntry;
        repIDStack.pop();
    }

    private void valueDcl(ValueEntry valueEntry) throws IOException, ParseException {
        if (this.token.type == 103) {
            this.valueInheritanceSpec(valueEntry);
        } else if (!valueEntry.isAbstract()) {
            SymtabEntry symtabEntry = this.qualifiedEntry("ValueBase");
            SymtabEntry symtabEntry2 = Parser.typeOf(symtabEntry);
            if (symtabEntry != null) {
                if (!this.isValue(symtabEntry2)) {
                    ParseException.wrongType(this.scanner, Parser.overrideName("ValueBase"), "value", symtabEntry.typeName());
                } else {
                    valueEntry.derivedFromAddElement(symtabEntry2, false, this.scanner);
                }
            }
        }
        if (this.token.type == 40) {
            this.valueSupportsSpec(valueEntry);
        }
        this.prep.openScope(valueEntry);
        this.match(101);
        while (this.token.type != 102) {
            this.valueElement(valueEntry);
        }
        this.prep.closeScope(valueEntry);
        this.match(102);
    }

    private void valueInheritanceSpec(ValueEntry valueEntry) throws IOException, ParseException {
        boolean bl;
        this.match(103);
        boolean bl2 = bl = this.token.type == 41;
        if (bl) {
            this.match(41);
        }
        if (valueEntry.isCustom() && bl) {
            ParseException.illegalTruncatable(this.scanner, "Custom", valueEntry.fullName());
        }
        if (valueEntry.isAbstract() && bl) {
            ParseException.illegalTruncatable(this.scanner, "Abstract", valueEntry.fullName());
        }
        while (true) {
            SymtabEntry symtabEntry;
            SymtabEntry symtabEntry2;
            if ((symtabEntry2 = Parser.typeOf(symtabEntry = this.scopedName(valueEntry.container(), this.stFactory.valueEntry()))) instanceof ForwardEntry) {
                ParseException.inhForwardDeclare(this.scanner, symtabEntry2.name());
            } else if (this.isValue(symtabEntry2) && !(symtabEntry2 instanceof ValueBoxEntry)) {
                valueEntry.derivedFromAddElement(symtabEntry2, bl, this.scanner);
            } else {
                ParseException.wrongType(this.scanner, symtabEntry.fullName(), "value", this.entryName(symtabEntry));
            }
            if (symtabEntry2 instanceof ValueEntry && !valueEntry.isCustom() && ((ValueEntry)symtabEntry2).isCustom()) {
                ParseException.inhCustomValueType(this.scanner, valueEntry.fullName(), symtabEntry2.fullName());
            }
            if (symtabEntry2 instanceof ValueEntry && !valueEntry.isAbstract() && bl && ((ValueEntry)symtabEntry2).isAbstract()) {
                ParseException.inhAbsTruncatable(this.scanner, valueEntry.fullName(), symtabEntry2.fullName());
            }
            if (this.token.type != 104) break;
            this.match(104);
            bl = false;
        }
    }

    private void valueSupportsSpec(ValueEntry valueEntry) throws IOException, ParseException {
        this.match(40);
        while (true) {
            SymtabEntry symtabEntry;
            SymtabEntry symtabEntry2;
            if (this.isInterfaceOnly(symtabEntry2 = Parser.typeOf(symtabEntry = this.scopedName(valueEntry.container(), this.stFactory.interfaceEntry())))) {
                valueEntry.derivedFromAddElement(symtabEntry2, this.scanner);
            } else {
                ParseException.wrongType(this.scanner, symtabEntry.fullName(), "interface", this.entryName(symtabEntry));
            }
            if (this.token.type != 104) break;
            this.match(104);
        }
    }

    private void valueElement(ValueEntry valueEntry) throws IOException, ParseException {
        if (valueEntry.isAbstract()) {
            this.export(valueEntry);
        } else {
            switch (this.token.type) {
                case 38: 
                case 39: {
                    this.valueStateMember(valueEntry);
                    break;
                }
                case 44: {
                    this.initDcl(valueEntry);
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 16: 
                case 18: 
                case 19: 
                case 20: 
                case 23: 
                case 25: 
                case 26: 
                case 27: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 42: 
                case 45: 
                case 46: 
                case 60: 
                case 124: {
                    this.export(valueEntry);
                    break;
                }
                default: {
                    throw ParseException.syntaxError(this.scanner, new int[]{38, 39, 42, 30, 27, 32, 9, 46, 5, 10, 23, 1, 20, 12, 8, 16, 25, 31, 4, 34, 2, 19, 0, 26, 35, 60, 124, 33}, this.token.type);
                }
            }
        }
    }

    private void valueStateMember(ValueEntry valueEntry) throws IOException, ParseException {
        boolean bl;
        TypedefEntry typedefEntry = this.stFactory.typedefEntry(valueEntry, (IDLID)repIDStack.peek());
        typedefEntry.sourceFile(this.scanner.fileEntry());
        typedefEntry.lineNumber(this.scanner.currentLineNumber());
        typedefEntry.comment(this.token.comment);
        boolean bl2 = bl = this.token.type == 39;
        if (bl) {
            this.match(39);
        } else {
            this.match(38);
        }
        boolean bl3 = this.token.type == 27 || this.token.type == 32 || this.token.type == 9;
        typedefEntry.name("");
        typedefEntry.type(this.typeSpec(valueEntry, false));
        this.addDeclarators(valueEntry, typedefEntry, bl);
        if (bl3) {
            valueEntry.addContained(typedefEntry);
        }
        this.match(100);
    }

    private void addDeclarators(ValueEntry valueEntry, TypedefEntry typedefEntry, boolean bl) throws IOException, ParseException {
        int n = bl ? 2 : 0;
        try {
            Vector vector = new Vector();
            InterfaceState interfaceState = new InterfaceState(n, typedefEntry);
            interfaceState.isTypeId(false);
            this.declarators(interfaceState, vector, valueEntry, false);
        }
        catch (ParseException parseException) {
            this.skipToSemicolon();
        }
    }

    private void initDcl(ValueEntry valueEntry) throws IOException, ParseException {
        FactoryMethodEntry factoryMethodEntry = new FactoryMethodEntry(this.stFactory.methodEntry(valueEntry, (IDLID)repIDStack.peek()));
        factoryMethodEntry.sourceFile(this.scanner.fileEntry());
        factoryMethodEntry.lineNumber(this.scanner.currentLineNumber());
        factoryMethodEntry.comment(this.token.comment);
        repIDStack.push(((IDLID)repIDStack.peek()).clone());
        ((IDLID)repIDStack.peek()).appendToName(this.token.name);
        this.match(44);
        factoryMethodEntry.name(this.token.name);
        if (this.token.type == 61) {
            this.match(61);
        } else {
            this.match(60);
            this.match(108);
        }
        if (this.token.type != 109) {
            while (true) {
                this.initParamDcl(factoryMethodEntry);
                if (this.token.type == 109) break;
                this.match(104);
            }
        }
        this.pigeonhole(valueEntry, factoryMethodEntry);
        this.match(109);
        this.match(100);
        repIDStack.pop();
    }

    private void initParamDcl(MethodEntry methodEntry) throws IOException, ParseException {
        ParameterEntry parameterEntry = this.stFactory.parameterEntry(methodEntry, (IDLID)repIDStack.peek());
        parameterEntry.sourceFile(this.scanner.fileEntry());
        parameterEntry.lineNumber(this.scanner.currentLineNumber());
        parameterEntry.comment(this.token.comment);
        this.match(13);
        parameterEntry.passType(0);
        parameterEntry.type(this.paramTypeSpec(methodEntry));
        parameterEntry.name(this.token.name);
        this.match(60);
        this.pigeonhole(methodEntry, parameterEntry);
    }

    private void valueBox(ModuleEntry moduleEntry, String string) throws IOException, ParseException {
        repIDStack.push(((IDLID)repIDStack.peek()).clone());
        ValueBoxEntry valueBoxEntry = this.stFactory.valueBoxEntry(moduleEntry, (IDLID)repIDStack.peek());
        valueBoxEntry.sourceFile(this.scanner.fileEntry());
        valueBoxEntry.lineNumber(this.scanner.currentLineNumber());
        valueBoxEntry.name(string);
        valueBoxEntry.comment(this.tokenHistory.lookBack((int)2).comment);
        SymtabEntry symtabEntry = this.getSymtabEntry(valueBoxEntry.fullName());
        if (symtabEntry != null && symtabEntry instanceof ForwardEntry) {
            ParseException.forwardedValueBox(this.scanner, valueBoxEntry.fullName());
        }
        this.pigeonhole(moduleEntry, valueBoxEntry);
        ((IDLID)repIDStack.peek()).appendToName(string);
        this.currentModule = valueBoxEntry;
        TypedefEntry typedefEntry = this.stFactory.typedefEntry(valueBoxEntry, (IDLID)repIDStack.peek());
        typedefEntry.sourceFile(this.scanner.fileEntry());
        typedefEntry.lineNumber(this.scanner.currentLineNumber());
        typedefEntry.comment(this.token.comment);
        boolean bl = this.token.type == 27 || this.token.type == 32 || this.token.type == 9;
        typedefEntry.name("");
        typedefEntry.type(this.typeSpec(typedefEntry, false));
        if (Parser.typeOf(typedefEntry.type()) instanceof ValueEntry) {
            ParseException.badValueBoxType(this.scanner);
        }
        if (typedefEntry.type() instanceof SequenceEntry) {
            this.createDuplicateSequenceEntry(typedefEntry, typedefEntry);
        }
        InterfaceState interfaceState = new InterfaceState(2, typedefEntry);
        valueBoxEntry.addStateElement(interfaceState, this.scanner);
        if (bl) {
            valueBoxEntry.addContained(typedefEntry);
        }
        valueBoxEntry.definitionComplete(true);
        this.currentModule = moduleEntry;
        repIDStack.pop();
    }

    private void valueForwardDcl(ModuleEntry moduleEntry, String string, boolean bl) throws IOException, ParseException {
        ForwardValueEntry forwardValueEntry = this.stFactory.forwardValueEntry(moduleEntry, (IDLID)repIDStack.peek());
        forwardValueEntry.sourceFile(this.scanner.fileEntry());
        forwardValueEntry.lineNumber(this.scanner.currentLineNumber());
        forwardValueEntry.name(string);
        forwardValueEntry.setAbstract(bl);
        forwardValueEntry.comment(this.tokenHistory.lookBack((int)(bl ? 3 : 2)).comment);
        this.pigeonhole(moduleEntry, forwardValueEntry);
    }

    private void constDcl(SymtabEntry symtabEntry) throws IOException, ParseException {
        this.match(5);
        ConstEntry constEntry = this.stFactory.constEntry(symtabEntry, (IDLID)repIDStack.peek());
        constEntry.sourceFile(this.scanner.fileEntry());
        constEntry.lineNumber(this.scanner.currentLineNumber());
        constEntry.comment(this.tokenHistory.lookBack((int)1).comment);
        this.constType(constEntry);
        constEntry.name(this.token.name);
        this.match(60);
        this.match(105);
        constEntry.value(this.constExp(constEntry));
        this.verifyConstType(constEntry.value(), Parser.typeOf(constEntry.type()));
        this.pigeonhole(symtabEntry, constEntry);
    }

    private void constType(SymtabEntry symtabEntry) throws IOException, ParseException {
        switch (this.token.type) {
            case 16: 
            case 25: 
            case 31: {
                symtabEntry.type(this.integerType(symtabEntry));
                break;
            }
            case 19: {
                symtabEntry.type(this.octetType());
                break;
            }
            case 4: 
            case 34: {
                symtabEntry.type(this.charType());
                break;
            }
            case 2: {
                symtabEntry.type(this.booleanType());
                break;
            }
            case 8: 
            case 12: 
            case 45: {
                symtabEntry.type(this.floatingPtType());
                break;
            }
            case 26: 
            case 35: {
                symtabEntry.type(this.stringType(symtabEntry, true));
                break;
            }
            case 47: {
                symtabEntry.type(this.fixedPtConstType(symtabEntry));
                break;
            }
            case 60: 
            case 124: {
                SymtabEntry symtabEntry2;
                PrimitiveEntry primitiveEntry = this.stFactory.primitiveEntry();
                SymtabEntry symtabEntry3 = this.scopedName(symtabEntry.container(), primitiveEntry);
                symtabEntry.type(symtabEntry3);
                if (this.hasArrayInfo(symtabEntry.type())) {
                    ParseException.illegalArray(this.scanner, "const");
                }
                if (primitiveEntry != symtabEntry3) {
                    this.checkTypeId(symtabEntry.type());
                }
                if (!((symtabEntry2 = Parser.typeOf(symtabEntry.type())) instanceof PrimitiveEntry || symtabEntry2 instanceof StringEntry || symtabEntry2 instanceof EnumEntry)) {
                    ParseException.wrongType(this.scanner, symtabEntry.fullName(), "primitive, string or enumeration", this.entryName(symtabEntry.type()));
                    symtabEntry.type(this.qualifiedEntry("long"));
                    break;
                }
                if (!(symtabEntry2 instanceof PrimitiveEntry)) break;
                String string = Parser.overrideName("any");
                if (!symtabEntry2.name().equals(string)) break;
                ParseException.wrongType(this.scanner, symtabEntry.fullName(), "primitive, string or enumeration (except " + string + ')', string);
                symtabEntry.type(this.qualifiedEntry("long"));
                break;
            }
            default: {
                throw ParseException.syntaxError(this.scanner, new int[]{16, 25, 31, 4, 34, 2, 12, 8, 19, 47, 26, 35, 60, 124}, this.token.type);
            }
        }
    }

    private boolean hasArrayInfo(SymtabEntry symtabEntry) {
        while (symtabEntry instanceof TypedefEntry) {
            if (((TypedefEntry)symtabEntry).arrayInfo().size() != 0) {
                return true;
            }
            symtabEntry = symtabEntry.type();
        }
        return false;
    }

    public static String overrideName(String string) {
        String string2 = (String)overrideNames.get(string);
        return string2 == null ? string : string2;
    }

    private void verifyConstType(Expression expression, SymtabEntry symtabEntry) {
        Object object = expression.value();
        if (object instanceof BigInteger) {
            this.verifyIntegral((Number)object, symtabEntry);
        } else if (object instanceof String) {
            this.verifyString((String)object, symtabEntry);
        } else if (object instanceof Boolean) {
            this.verifyBoolean(symtabEntry);
        } else if (object instanceof Character) {
            this.verifyCharacter(symtabEntry);
        } else if (object instanceof Float || object instanceof Double) {
            this.verifyFloat(expression, (Number)object, symtabEntry);
        } else if (object instanceof ConstEntry) {
            this.verifyConstType(((ConstEntry)object).value(), symtabEntry);
        } else if (object instanceof EnumValueEntry) {
            this.verifyEnumType((EnumValueEntry)object, symtabEntry);
        } else {
            ParseException.wrongType(this.scanner, Util.getMessage("ParseException.constExpr"), symtabEntry.fullName(), object == null ? "" : object.toString());
        }
    }

    private void verifyEnumType(EnumValueEntry enumValueEntry, SymtabEntry symtabEntry) {
        if (enumValueEntry.type() != symtabEntry) {
            ParseException.wrongType(this.scanner, Util.getMessage("ParseException.constExpr"), symtabEntry.fullName(), enumValueEntry.type().fullName());
        }
    }

    private void verifyIntegral(Number number, SymtabEntry symtabEntry) {
        boolean bl = false;
        if (symtabEntry == this.qualifiedEntry("long")) {
            if (number.longValue() > Integer.MAX_VALUE || number.longValue() < Integer.MIN_VALUE) {
                bl = true;
            }
        } else if (symtabEntry == this.qualifiedEntry("short")) {
            if (number.intValue() > Short.MAX_VALUE || number.intValue() < Short.MIN_VALUE) {
                bl = true;
            }
        } else if (symtabEntry == this.qualifiedEntry("octet")) {
            if (number.intValue() > 255 || number.intValue() < 0) {
                bl = true;
            }
        } else if (symtabEntry == this.qualifiedEntry("unsigned long")) {
            if (number.longValue() > 0xFFFFFFFFL || number.longValue() < 0L) {
                bl = true;
            }
        } else if (symtabEntry == this.qualifiedEntry("unsigned short")) {
            if (number.intValue() > 65535 || number.intValue() < 0) {
                bl = true;
            }
        } else if (symtabEntry == this.qualifiedEntry("long long")) {
            BigInteger bigInteger = BigInteger.valueOf(Long.MAX_VALUE);
            BigInteger bigInteger2 = BigInteger.valueOf(Long.MIN_VALUE);
            if (((BigInteger)number).compareTo(bigInteger) > 0 || ((BigInteger)number).compareTo(bigInteger2) < 0) {
                bl = true;
            }
        } else if (symtabEntry == this.qualifiedEntry("unsigned long long")) {
            BigInteger bigInteger = BigInteger.valueOf(Long.MAX_VALUE).multiply(BigInteger.valueOf(2L)).add(BigInteger.valueOf(1L));
            BigInteger bigInteger3 = BigInteger.valueOf(0L);
            if (((BigInteger)number).compareTo(bigInteger) > 0 || ((BigInteger)number).compareTo(bigInteger3) < 0) {
                bl = true;
            }
        } else {
            String string = null;
            string = "long";
            ParseException.wrongType(this.scanner, Util.getMessage("ParseException.constExpr"), symtabEntry.fullName(), string);
        }
        if (bl) {
            ParseException.outOfRange(this.scanner, number.toString(), symtabEntry.fullName());
        }
    }

    private void verifyString(String string, SymtabEntry symtabEntry) {
        if (!(symtabEntry instanceof StringEntry)) {
            ParseException.wrongType(this.scanner, Util.getMessage("ParseException.constExpr"), symtabEntry.fullName(), "string");
        } else {
            if (symtabEntry.name().equals(Parser.overrideName("wstring"))) {
                if (this.tokenHistory.lookBack((int)1).type != 207) {
                    ParseException.wrongType(this.scanner, Util.getMessage("ParseException.constExpr"), symtabEntry.fullName(), "string");
                }
            } else if (this.tokenHistory.lookBack((int)1).type != 204) {
                ParseException.wrongType(this.scanner, Util.getMessage("ParseException.constExpr"), symtabEntry.fullName(), "wstring");
            }
            if (((StringEntry)symtabEntry).maxSize() != null) {
                Expression expression = ((StringEntry)symtabEntry).maxSize();
                if (expression.value() instanceof ConstEntry) {
                    expression = ((ConstEntry)expression.value()).value();
                }
                try {
                    Number number = (Number)expression.value();
                    if (string.length() > number.intValue()) {
                        ParseException.stringTooLong(this.scanner, string, number.toString());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void verifyBoolean(SymtabEntry symtabEntry) {
        if (!symtabEntry.name().equals(Parser.overrideName("boolean"))) {
            ParseException.wrongType(this.scanner, Util.getMessage("ParseException.constExpr"), symtabEntry.name(), "boolean");
        }
    }

    private void verifyCharacter(SymtabEntry symtabEntry) {
        if (!symtabEntry.name().equals(Parser.overrideName("char")) && !symtabEntry.name().equals(Parser.overrideName("wchar"))) {
            ParseException.wrongType(this.scanner, Util.getMessage("ParseException.constExpr"), symtabEntry.fullName(), "char");
        } else if (symtabEntry.name().equals(Parser.overrideName("wchar"))) {
            if (this.tokenHistory.lookBack((int)1).type != 206) {
                ParseException.wrongType(this.scanner, Util.getMessage("ParseException.constExpr"), symtabEntry.fullName(), "char");
            }
        } else if (this.tokenHistory.lookBack((int)1).type != 201) {
            ParseException.wrongType(this.scanner, Util.getMessage("ParseException.constExpr"), symtabEntry.fullName(), "wchar");
        }
    }

    private BigDecimal eBigDecimal(String string) {
        String string2 = null;
        String string3 = string;
        int n = 0;
        if (!Character.isDigit(string.charAt(0))) {
            return new BigDecimal(0.0);
        }
        int n2 = string.toLowerCase().indexOf("e");
        if (n2 >= 0) {
            string3 = string.substring(0, n2);
            string2 = string.charAt(n2 + 1) == '+' ? string.substring(n2 + 2) : string.substring(n2 + 1);
            n = new Integer(string2);
        }
        BigDecimal bigDecimal = new BigDecimal(string3);
        return bigDecimal.movePointRight(n);
    }

    private void verifyFloat(Expression expression, Number number, SymtabEntry symtabEntry) {
        boolean bl = false;
        if (symtabEntry.name().equals(Parser.overrideName("float"))) {
            double d;
            double d2 = d = number.doubleValue() < 0.0 ? number.doubleValue() * -1.0 : number.doubleValue();
            if (d != 0.0 && (d > 3.40282347E38 || d < 1.40239846E-45)) {
                bl = true;
            } else if (Float.isNaN(number.floatValue())) {
                bl = true;
            }
        } else if (symtabEntry.name().equals(Parser.overrideName("double"))) {
            double d = number.doubleValue();
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                bl = true;
            } else {
                boolean bl2 = expression instanceof Terminal || expression instanceof Positive || expression instanceof Negative;
                BigDecimal bigDecimal = bl2 ? this.eBigDecimal(expression.rep()) : new BigDecimal(d);
                BigDecimal bigDecimal2 = bigDecimal.abs();
                BigDecimal bigDecimal3 = new BigDecimal("0.0");
                BigDecimal bigDecimal4 = this.eBigDecimal("1.79769313486231570e308");
                BigDecimal bigDecimal5 = this.eBigDecimal("4.94065645841246544e-324");
                if (bigDecimal2.compareTo(bigDecimal3) != 0 && (bigDecimal2.compareTo(bigDecimal4) > 0 || bigDecimal2.compareTo(bigDecimal5) < 0)) {
                    bl = true;
                }
            }
        } else {
            ParseException.wrongType(this.scanner, Util.getMessage("ParseException.constExpr"), symtabEntry.fullName(), number instanceof Float ? "float" : "double");
        }
        if (bl) {
            ParseException.outOfRange(this.scanner, number.toString(), symtabEntry.fullName());
        }
    }

    Expression constExp(SymtabEntry symtabEntry) throws IOException, ParseException {
        Expression expression = this.orExpr(null, symtabEntry);
        expression.type(symtabEntry.typeName());
        try {
            expression.evaluate();
            if (expression instanceof Terminal && expression.value() instanceof BigInteger && (Parser.overrideName(expression.type()).equals("float") || Parser.overrideName(expression.type()).indexOf("double") >= 0)) {
                expression.value(new Double(((BigInteger)expression.value()).doubleValue()));
            }
        }
        catch (EvaluationException evaluationException) {
            ParseException.evaluationError(this.scanner, evaluationException.toString());
        }
        catch (ArithmeticException arithmeticException) {
            ParseException.evaluationError(this.scanner, arithmeticException.toString());
        }
        return expression;
    }

    private Expression orExpr(Expression expression, SymtabEntry symtabEntry) throws IOException, ParseException {
        BinaryExpr binaryExpr;
        if (expression == null) {
            expression = this.xorExpr(null, symtabEntry);
        } else {
            binaryExpr = (BinaryExpr)expression;
            binaryExpr.right(this.xorExpr(null, symtabEntry));
            expression.rep(expression.rep() + binaryExpr.right().rep());
        }
        if (this.token.equals(117)) {
            this.match(this.token.type);
            binaryExpr = this.exprFactory.or(expression, null);
            binaryExpr.type(symtabEntry.typeName());
            binaryExpr.rep(expression.rep() + " | ");
            return this.orExpr(binaryExpr, symtabEntry);
        }
        return expression;
    }

    private Expression xorExpr(Expression expression, SymtabEntry symtabEntry) throws IOException, ParseException {
        BinaryExpr binaryExpr;
        if (expression == null) {
            expression = this.andExpr(null, symtabEntry);
        } else {
            binaryExpr = (BinaryExpr)expression;
            binaryExpr.right(this.andExpr(null, symtabEntry));
            expression.rep(expression.rep() + binaryExpr.right().rep());
        }
        if (this.token.equals(118)) {
            this.match(this.token.type);
            binaryExpr = this.exprFactory.xor(expression, null);
            binaryExpr.rep(expression.rep() + " ^ ");
            binaryExpr.type(symtabEntry.typeName());
            return this.xorExpr(binaryExpr, symtabEntry);
        }
        return expression;
    }

    private Expression andExpr(Expression expression, SymtabEntry symtabEntry) throws IOException, ParseException {
        BinaryExpr binaryExpr;
        if (expression == null) {
            expression = this.shiftExpr(null, symtabEntry);
        } else {
            binaryExpr = (BinaryExpr)expression;
            binaryExpr.right(this.shiftExpr(null, symtabEntry));
            expression.rep(expression.rep() + binaryExpr.right().rep());
        }
        if (this.token.equals(119)) {
            this.match(this.token.type);
            binaryExpr = this.exprFactory.and(expression, null);
            binaryExpr.rep(expression.rep() + " & ");
            binaryExpr.type(symtabEntry.typeName());
            return this.andExpr(binaryExpr, symtabEntry);
        }
        return expression;
    }

    private Expression shiftExpr(Expression expression, SymtabEntry symtabEntry) throws IOException, ParseException {
        BinaryExpr binaryExpr;
        if (expression == null) {
            expression = this.addExpr(null, symtabEntry);
        } else {
            binaryExpr = (BinaryExpr)expression;
            binaryExpr.right(this.addExpr(null, symtabEntry));
            expression.rep(expression.rep() + binaryExpr.right().rep());
        }
        if (this.token.equals(125)) {
            this.match(this.token.type);
            binaryExpr = this.exprFactory.shiftLeft(expression, null);
            binaryExpr.type(symtabEntry.typeName());
            binaryExpr.rep(expression.rep() + " << ");
            return this.shiftExpr(binaryExpr, symtabEntry);
        }
        if (this.token.equals(126)) {
            this.match(this.token.type);
            binaryExpr = this.exprFactory.shiftRight(expression, null);
            binaryExpr.type(symtabEntry.typeName());
            binaryExpr.rep(expression.rep() + " >> ");
            return this.shiftExpr(binaryExpr, symtabEntry);
        }
        return expression;
    }

    private Expression addExpr(Expression expression, SymtabEntry symtabEntry) throws IOException, ParseException {
        BinaryExpr binaryExpr;
        if (expression == null) {
            expression = this.multExpr(null, symtabEntry);
        } else {
            binaryExpr = (BinaryExpr)expression;
            binaryExpr.right(this.multExpr(null, symtabEntry));
            expression.rep(expression.rep() + binaryExpr.right().rep());
        }
        if (this.token.equals(106)) {
            this.match(this.token.type);
            binaryExpr = this.exprFactory.plus(expression, null);
            binaryExpr.type(symtabEntry.typeName());
            binaryExpr.rep(expression.rep() + " + ");
            return this.addExpr(binaryExpr, symtabEntry);
        }
        if (this.token.equals(107)) {
            this.match(this.token.type);
            binaryExpr = this.exprFactory.minus(expression, null);
            binaryExpr.type(symtabEntry.typeName());
            binaryExpr.rep(expression.rep() + " - ");
            return this.addExpr(binaryExpr, symtabEntry);
        }
        return expression;
    }

    private Expression multExpr(Expression expression, SymtabEntry symtabEntry) throws IOException, ParseException {
        BinaryExpr binaryExpr;
        if (expression == null) {
            expression = this.unaryExpr(symtabEntry);
        } else {
            binaryExpr = (BinaryExpr)expression;
            binaryExpr.right(this.unaryExpr(symtabEntry));
            expression.rep(expression.rep() + binaryExpr.right().rep());
        }
        if (this.token.equals(120)) {
            this.match(this.token.type);
            binaryExpr = this.exprFactory.times(expression, null);
            binaryExpr.type(symtabEntry.typeName());
            binaryExpr.rep(expression.rep() + " * ");
            return this.multExpr(binaryExpr, symtabEntry);
        }
        if (this.token.equals(121)) {
            this.match(this.token.type);
            binaryExpr = this.exprFactory.divide(expression, null);
            binaryExpr.type(symtabEntry.typeName());
            binaryExpr.rep(expression.rep() + " / ");
            return this.multExpr(binaryExpr, symtabEntry);
        }
        if (this.token.equals(122)) {
            this.match(this.token.type);
            binaryExpr = this.exprFactory.modulo(expression, null);
            binaryExpr.type(symtabEntry.typeName());
            binaryExpr.rep(expression.rep() + " % ");
            return this.multExpr(binaryExpr, symtabEntry);
        }
        return expression;
    }

    private Expression unaryExpr(SymtabEntry symtabEntry) throws IOException, ParseException {
        if (this.token.equals(106)) {
            this.match(this.token.type);
            Expression expression = this.primaryExpr(symtabEntry);
            Positive positive = this.exprFactory.positive(expression);
            positive.type(symtabEntry.typeName());
            positive.rep('+' + expression.rep());
            return positive;
        }
        if (this.token.equals(107)) {
            this.match(this.token.type);
            Expression expression = this.primaryExpr(symtabEntry);
            Negative negative = this.exprFactory.negative(expression);
            negative.type(symtabEntry.typeName());
            negative.rep('-' + expression.rep());
            return negative;
        }
        if (this.token.equals(123)) {
            this.match(this.token.type);
            Expression expression = this.primaryExpr(symtabEntry);
            Not not = this.exprFactory.not(expression);
            not.type(symtabEntry.typeName());
            not.rep('~' + expression.rep());
            return not;
        }
        return this.primaryExpr(symtabEntry);
    }

    private Expression primaryExpr(SymtabEntry symtabEntry) throws IOException, ParseException {
        Expression expression = null;
        if (this.parsingConditionalExpr) {
            this.prep.token = this.token;
            expression = this.prep.primaryExpr(symtabEntry);
            this.token = this.prep.token;
        } else {
            switch (this.token.type) {
                case 60: 
                case 124: {
                    ConstEntry constEntry = this.stFactory.constEntry();
                    constEntry.value(this.exprFactory.terminal("1", BigInteger.valueOf(1L)));
                    SymtabEntry symtabEntry2 = this.scopedName(symtabEntry.container(), constEntry);
                    if (symtabEntry2 instanceof ConstEntry) {
                        expression = this.exprFactory.terminal((ConstEntry)symtabEntry2);
                        break;
                    }
                    if (symtabEntry2 instanceof EnumValueEntry) {
                        expression = this.exprFactory.terminal((EnumValueEntry)symtabEntry2);
                        break;
                    }
                    ParseException.invalidConst(this.scanner, symtabEntry2.fullName());
                    expression = this.exprFactory.terminal("1", BigInteger.valueOf(1L));
                    break;
                }
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 206: 
                case 207: {
                    expression = this.literal(symtabEntry);
                    break;
                }
                case 108: {
                    this.match(108);
                    expression = this.constExp(symtabEntry);
                    this.match(109);
                    expression.rep('(' + expression.rep() + ')');
                    break;
                }
                default: {
                    throw ParseException.syntaxError(this.scanner, new int[]{60, 124, 205, 108}, this.token.type);
                }
            }
        }
        return expression;
    }

    Expression literal(SymtabEntry symtabEntry) throws IOException, ParseException {
        String string = this.token.name;
        Expression expression = null;
        switch (this.token.type) {
            case 202: {
                this.match(202);
                try {
                    expression = this.exprFactory.terminal(string, this.parseString(string));
                    expression.type(symtabEntry.typeName());
                }
                catch (NumberFormatException numberFormatException) {
                    ParseException.notANumber(this.scanner, string);
                    expression = this.exprFactory.terminal("0", BigInteger.valueOf(0L));
                }
                break;
            }
            case 201: {
                this.match(201);
                expression = this.exprFactory.terminal("'" + string.substring(1) + "'", new Character(string.charAt(0)));
                break;
            }
            case 206: {
                this.match(206);
                expression = this.exprFactory.terminal("'" + string.substring(1) + "'", new Character(string.charAt(0)));
                break;
            }
            case 203: {
                this.match(203);
                try {
                    expression = this.exprFactory.terminal(string, new Double(string));
                    expression.type(symtabEntry.typeName());
                }
                catch (NumberFormatException numberFormatException) {
                    ParseException.notANumber(this.scanner, string);
                }
                break;
            }
            case 200: {
                expression = this.booleanLiteral();
                break;
            }
            case 204: 
            case 207: {
                expression = this.stringLiteral();
                break;
            }
            default: {
                throw ParseException.syntaxError(this.scanner, 205, this.token.type);
            }
        }
        return expression;
    }

    private BigInteger parseString(String string) throws NumberFormatException {
        int n = 10;
        if (string.length() > 1 && string.charAt(0) == '0') {
            if (string.charAt(1) == 'x' || string.charAt(1) == 'X') {
                string = string.substring(2);
                n = 16;
            } else {
                n = 8;
            }
        }
        return new BigInteger(string, n);
    }

    private Terminal booleanLiteral() throws IOException, ParseException {
        Boolean bl = null;
        if (this.token.name.equals("TRUE")) {
            bl = new Boolean(true);
        } else if (this.token.name.equals("FALSE")) {
            bl = new Boolean(false);
        } else {
            ParseException.invalidConst(this.scanner, this.token.name);
            bl = new Boolean(false);
        }
        String string = this.token.name;
        this.match(200);
        return this.exprFactory.terminal(string, bl);
    }

    private Expression stringLiteral() throws IOException, ParseException {
        String string = "";
        do {
            string = string + this.token.name;
            if (this.token.equals(207)) {
                this.match(207);
                continue;
            }
            this.match(204);
        } while (this.token.equals(204) || this.token.equals(207));
        Terminal terminal = this.exprFactory.terminal(string);
        terminal.rep('\"' + string + '\"');
        return terminal;
    }

    private Expression positiveIntConst(SymtabEntry symtabEntry) throws IOException, ParseException {
        Expression expression = this.constExp(symtabEntry);
        Object object = expression.value();
        while (object instanceof ConstEntry) {
            object = ((ConstEntry)object).value().value();
        }
        if (!(object instanceof Number) || object instanceof Float || object instanceof Double) {
            ParseException.notPositiveInt(this.scanner, expression.rep());
            expression = this.exprFactory.terminal("1", BigInteger.valueOf(1L));
        } else if (((BigInteger)object).compareTo(BigInteger.valueOf(0L)) <= 0) {
            ParseException.notPositiveInt(this.scanner, object.toString());
            expression = this.exprFactory.terminal("1", BigInteger.valueOf(1L));
        }
        return expression;
    }

    private SymtabEntry typeDcl(SymtabEntry symtabEntry) throws IOException, ParseException {
        switch (this.token.type) {
            case 30: {
                this.match(30);
                return this.typeDeclarator(symtabEntry);
            }
            case 46: {
                this.match(46);
                return this.nativeDeclarator(symtabEntry);
            }
            case 27: {
                return this.structType(symtabEntry, true);
            }
            case 32: {
                return this.unionType(symtabEntry, true);
            }
            case 9: {
                return this.enumType(symtabEntry);
            }
        }
        throw ParseException.syntaxError(this.scanner, new int[]{30, 27, 32, 9, 46}, this.token.type);
    }

    private TypedefEntry typeDeclarator(SymtabEntry symtabEntry) throws IOException, ParseException {
        TypedefEntry typedefEntry = this.stFactory.typedefEntry(symtabEntry, (IDLID)repIDStack.peek());
        typedefEntry.sourceFile(this.scanner.fileEntry());
        typedefEntry.lineNumber(this.scanner.currentLineNumber());
        typedefEntry.comment(this.tokenHistory.lookBack((int)1).comment);
        typedefEntry.type(this.typeSpec(symtabEntry, true));
        Vector vector = new Vector();
        boolean bl = true;
        if (typedefEntry.type() instanceof SequenceEntry || typedefEntry.type() instanceof StringEntry && ((StringEntry)typedefEntry.type()).maxSize() != null) {
            bl = false;
        }
        this.declarators(typedefEntry, vector, symtabEntry, bl);
        return typedefEntry;
    }

    private TypedefEntry nativeDeclarator(SymtabEntry symtabEntry) throws IOException, ParseException {
        if (!symtabEntry.isLocalOnly() && symtabEntry instanceof InterfaceEntry) {
            ParseException.nonLocalNative(this.scanner, symtabEntry.fullName());
        }
        TypedefEntry typedefEntry = this.stFactory.typedefEntry(symtabEntry, (IDLID)repIDStack.peek());
        typedefEntry.emit(false);
        typedefEntry.sourceFile(this.scanner.fileEntry());
        typedefEntry.lineNumber(this.scanner.currentLineNumber());
        typedefEntry.comment(this.tokenHistory.lookBack((int)1).comment);
        typedefEntry.type(this.nativeType());
        this.declarator(typedefEntry, symtabEntry, false);
        return typedefEntry;
    }

    private SymtabEntry typeSpec(SymtabEntry symtabEntry, boolean bl) throws IOException, ParseException {
        return this.token.type == 27 || this.token.type == 32 || this.token.type == 9 ? this.constrTypeSpec(symtabEntry) : this.simpleTypeSpec(symtabEntry, bl);
    }

    private void checkTypeId(SymtabEntry symtabEntry) {
        this.checkTypeId(symtabEntry, false);
    }

    private void checkTypeId(SymtabEntry symtabEntry, boolean bl) {
        SymtabEntry symtabEntry2;
        if (symtabEntry == null || symtabEntry instanceof EnumValueEntry || symtabEntry instanceof TypedefEntry && !((TypedefEntry)symtabEntry).isTypeId() || !bl && (symtabEntry instanceof ForwardUnionEntry || symtabEntry instanceof ForwardStructEntry) || symtabEntry instanceof ConstEntry || symtabEntry instanceof MethodEntry || symtabEntry instanceof ExceptionEntry || symtabEntry instanceof ModuleEntry || symtabEntry instanceof ParameterEntry) {
            ParseException.notType(this.scanner, symtabEntry.fullName());
        }
        if (this.corbaLevel.gte(2.4f) && (symtabEntry2 = Parser.typeOf(symtabEntry)) instanceof SequenceEntry) {
            while (symtabEntry2 instanceof SequenceEntry) {
                symtabEntry2 = symtabEntry2.type();
            }
            if (symtabEntry2 instanceof ForwardStructEntry || symtabEntry2 instanceof ForwardUnionEntry) {
                ParseException.notType(this.scanner, symtabEntry.fullName());
            }
        }
    }

    private SymtabEntry simpleTypeSpec(SymtabEntry symtabEntry, boolean bl) throws IOException, ParseException {
        return this.simpleTypeSpec(symtabEntry, bl, false);
    }

    private SymtabEntry simpleTypeSpec(SymtabEntry symtabEntry, boolean bl, boolean bl2) throws IOException, ParseException {
        if (this.token.type == 60 || this.token.type == 124 || this.token.type == 18 || this.token.type == 42) {
            PrimitiveEntry primitiveEntry;
            SymtabEntry symtabEntry2 = symtabEntry instanceof InterfaceEntry || symtabEntry instanceof ModuleEntry || symtabEntry instanceof StructEntry || symtabEntry instanceof UnionEntry ? symtabEntry : symtabEntry.container();
            SymtabEntry symtabEntry3 = this.scopedName(symtabEntry2, primitiveEntry = this.stFactory.primitiveEntry());
            if (symtabEntry3 != primitiveEntry) {
                this.checkTypeId(symtabEntry3, bl2);
            }
            return symtabEntry3;
        }
        return this.token.type == 24 || this.token.type == 26 || this.token.type == 47 || this.token.type == 35 ? this.templateTypeSpec(symtabEntry, bl) : this.baseTypeSpec(symtabEntry);
    }

    private SymtabEntry baseTypeSpec(SymtabEntry symtabEntry) throws IOException, ParseException {
        switch (this.token.type) {
            case 8: 
            case 12: 
            case 45: {
                return this.floatingPtType();
            }
            case 16: 
            case 25: 
            case 31: {
                return this.integerType(symtabEntry);
            }
            case 4: 
            case 34: {
                return this.charType();
            }
            case 2: {
                return this.booleanType();
            }
            case 19: {
                return this.octetType();
            }
            case 0: {
                return this.anyType();
            }
        }
        throw ParseException.syntaxError(this.scanner, new int[]{12, 8, 16, 25, 31, 4, 34, 2, 19, 0}, this.token.type);
    }

    private SymtabEntry templateTypeSpec(SymtabEntry symtabEntry, boolean bl) throws IOException, ParseException {
        switch (this.token.type) {
            case 24: {
                return this.sequenceType(symtabEntry, bl);
            }
            case 47: {
                return this.fixedPtType(symtabEntry, bl);
            }
            case 26: 
            case 35: {
                return this.stringType(symtabEntry, bl);
            }
        }
        throw ParseException.syntaxError(this.scanner, new int[]{24, 26, 35, 47}, this.token.type);
    }

    private SymtabEntry constrTypeSpec(SymtabEntry symtabEntry) throws IOException, ParseException {
        switch (this.token.type) {
            case 27: {
                return this.structType(symtabEntry, false);
            }
            case 32: {
                return this.unionType(symtabEntry, false);
            }
            case 9: {
                return this.enumType(symtabEntry);
            }
        }
        throw ParseException.syntaxError(this.scanner, new int[]{27, 32, 9}, this.token.type);
    }

    private void declarators(TypedefEntry typedefEntry, Vector vector, SymtabEntry symtabEntry, boolean bl) throws IOException, ParseException {
        while (true) {
            TypedefEntry typedefEntry2 = (TypedefEntry)typedefEntry.clone();
            this.declarator(typedefEntry2, symtabEntry, bl);
            if (this.isntInList(vector, typedefEntry2.name())) {
                vector.addElement(typedefEntry2);
            }
            if (this.token.type != 104) break;
            this.match(104);
        }
    }

    private void declarator(TypedefEntry typedefEntry, SymtabEntry symtabEntry, boolean bl) throws IOException, ParseException {
        typedefEntry.name(this.token.name);
        this.createDuplicateSequenceEntry(typedefEntry, symtabEntry);
        this.pigeonhole(symtabEntry, typedefEntry);
        if (!this.token.comment.text().equals("")) {
            typedefEntry.comment(this.token.comment);
        }
        this.match(60);
        while (this.token.type == 112) {
            this.issueAnonTypeMessage("array", bl);
            bl = true;
            this.fixedArraySize(typedefEntry);
        }
    }

    private void createDuplicateSequenceEntry(TypedefEntry typedefEntry, SymtabEntry symtabEntry) {
        if (typedefEntry.type() instanceof SequenceEntry) {
            SymtabEntry symtabEntry2 = typedefEntry;
            while (symtabEntry2.type() instanceof SequenceEntry) {
                SequenceEntry sequenceEntry = null;
                sequenceEntry = symtabEntry2 == typedefEntry ? this.newSequenceEntry(symtabEntry) : this.newSequenceEntry(symtabEntry2);
                sequenceEntry.type(symtabEntry2.type().type());
                sequenceEntry.maxSize(((SequenceEntry)symtabEntry2.type()).maxSize());
                sequenceEntry.ref(symtabEntry2);
                symtabEntry2.type(sequenceEntry);
                symtabEntry2 = sequenceEntry;
            }
        }
    }

    private PrimitiveEntry floatingPtType() throws IOException, ParseException {
        Object object;
        String string = "double";
        if (this.token.type == 12) {
            this.match(12);
            string = "float";
        } else if (this.token.type == 45) {
            ParseException.noLongDouble(this.scanner);
            this.match(45);
        } else if (this.token.type == 8) {
            this.match(8);
        } else {
            object = new int[]{12, 8, 45};
            ParseException.syntaxError(this.scanner, new int[]{12, 8, 45}, this.token.type);
        }
        object = null;
        try {
            object = (PrimitiveEntry)this.qualifiedEntry(string);
        }
        catch (ClassCastException classCastException) {
            ParseException.undeclaredType(this.scanner, string);
        }
        return object;
    }

    private PrimitiveEntry integerType(SymtabEntry symtabEntry) throws IOException, ParseException {
        String string = "";
        if (this.token.type == 31) {
            this.match(31);
            string = "unsigned ";
        }
        string = string + this.signedInt();
        PrimitiveEntry primitiveEntry = null;
        try {
            primitiveEntry = (PrimitiveEntry)this.qualifiedEntry(string);
        }
        catch (ClassCastException classCastException) {
            ParseException.undeclaredType(this.scanner, string);
        }
        return primitiveEntry;
    }

    private String signedInt() throws IOException, ParseException {
        String string = "long";
        if (this.token.type == 16) {
            this.match(16);
            if (this.token.type == 16) {
                string = "long long";
                this.match(16);
            }
        } else if (this.token.type == 25) {
            string = "short";
            this.match(25);
        } else if (this.token.type == 19) {
            string = "octet";
            this.match(19);
        } else {
            ParseException.syntaxError(this.scanner, new int[]{16, 25}, this.token.type);
        }
        return string;
    }

    private PrimitiveEntry charType() throws IOException, ParseException {
        String string;
        if (this.token.type == 4) {
            this.match(4);
            string = "char";
        } else {
            this.match(34);
            string = "wchar";
        }
        PrimitiveEntry primitiveEntry = null;
        try {
            primitiveEntry = (PrimitiveEntry)this.qualifiedEntry(string);
        }
        catch (ClassCastException classCastException) {
            ParseException.undeclaredType(this.scanner, Parser.overrideName(string));
        }
        return primitiveEntry;
    }

    private PrimitiveEntry booleanType() throws IOException, ParseException {
        PrimitiveEntry primitiveEntry = null;
        this.match(2);
        try {
            primitiveEntry = (PrimitiveEntry)this.qualifiedEntry("boolean");
        }
        catch (ClassCastException classCastException) {
            ParseException.undeclaredType(this.scanner, Parser.overrideName("boolean"));
        }
        return primitiveEntry;
    }

    private PrimitiveEntry octetType() throws IOException, ParseException {
        PrimitiveEntry primitiveEntry = null;
        this.match(19);
        try {
            primitiveEntry = (PrimitiveEntry)this.qualifiedEntry("octet");
        }
        catch (ClassCastException classCastException) {
            ParseException.undeclaredType(this.scanner, Parser.overrideName("octet"));
        }
        return primitiveEntry;
    }

    private SymtabEntry anyType() throws IOException, ParseException {
        this.match(0);
        try {
            return this.qualifiedEntry("any");
        }
        catch (ClassCastException classCastException) {
            ParseException.undeclaredType(this.scanner, Parser.overrideName("any"));
            return null;
        }
    }

    private PrimitiveEntry nativeType() throws IOException, ParseException {
        PrimitiveEntry primitiveEntry = null;
        try {
            primitiveEntry = (PrimitiveEntry)this.qualifiedEntry("native");
        }
        catch (ClassCastException classCastException) {
            ParseException.undeclaredType(this.scanner, Parser.overrideName("native"));
        }
        return primitiveEntry;
    }

    private SymtabEntry structType(SymtabEntry symtabEntry, boolean bl) throws IOException, ParseException {
        this.match(27);
        String string = this.token.name;
        this.match(60);
        if (this.token.equals(101)) {
            StructEntry structEntry = this.stFactory.structEntry(symtabEntry, (IDLID)repIDStack.peek());
            repIDStack.push(((IDLID)repIDStack.peek()).clone());
            ((IDLID)repIDStack.peek()).appendToName(string);
            structEntry.sourceFile(this.scanner.fileEntry());
            structEntry.lineNumber(this.scanner.currentLineNumber());
            structEntry.comment(this.tokenHistory.lookBack((int)2).comment);
            structEntry.name(string);
            SymtabEntry symtabEntry2 = this.getSymtabEntry(structEntry.fullName());
            if (symtabEntry2 != null & symtabEntry2 instanceof ForwardStructEntry) {
                ((ForwardStructEntry)symtabEntry2).replaceForwardDcl(structEntry, this.scanner);
            }
            this.pigeonhole(symtabEntry, structEntry);
            this.prep.openScope(structEntry);
            this.match(101);
            this.member(structEntry);
            this.memberList2(structEntry);
            this.prep.closeScope(structEntry);
            this.match(102);
            if (symtabEntry2 != null & symtabEntry2 instanceof ForwardStructEntry) {
                Vector vector = ((ForwardDclEntry)symtabEntry2).getReferencingEntries();
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    SymtabEntry symtabEntry3;
                    SymtabEntry symtabEntry4 = (SymtabEntry)enumeration.nextElement();
                    symtabEntry4.localOnly(structEntry.isLocalOnly());
                    if (!(symtabEntry4 instanceof SequenceEntry) || (symtabEntry3 = ((SequenceEntry)symtabEntry4).ref()) == null) continue;
                    symtabEntry3.localOnly(structEntry.isLocalOnly());
                }
            }
            repIDStack.pop();
            return structEntry;
        }
        if (this.corbaLevel.gte(2.4f) && bl) {
            ForwardStructEntry forwardStructEntry = this.stFactory.forwardStructEntry(symtabEntry, (IDLID)repIDStack.peek());
            forwardStructEntry.sourceFile(this.scanner.fileEntry());
            forwardStructEntry.lineNumber(this.scanner.currentLineNumber());
            forwardStructEntry.name(string);
            forwardStructEntry.comment(this.tokenHistory.lookBack((int)2).comment);
            this.pigeonhole(symtabEntry, forwardStructEntry);
            return forwardStructEntry;
        }
        throw ParseException.syntaxError(this.scanner, 101, this.token.type);
    }

    private void memberList2(StructEntry structEntry) throws IOException {
        while (this.token.type != 102) {
            this.member(structEntry);
        }
    }

    private void member(StructEntry structEntry) throws IOException {
        TypedefEntry typedefEntry = this.stFactory.typedefEntry(structEntry, (IDLID)repIDStack.peek());
        typedefEntry.sourceFile(this.scanner.fileEntry());
        typedefEntry.lineNumber(this.scanner.currentLineNumber());
        typedefEntry.isTypeId(false);
        typedefEntry.comment(this.token.comment);
        try {
            typedefEntry.type(this.typeSpec(structEntry, false));
            if (typedefEntry.type() == structEntry) {
                throw ParseException.recursive(this.scanner, structEntry.fullName(), this.token.name == null ? "" : this.token.name);
            }
            if (Parser.typeOf(typedefEntry) instanceof ExceptionEntry) {
                throw ParseException.illegalException(this.scanner, this.entryName(structEntry));
            }
            this.declarators(typedefEntry, structEntry.members(), structEntry, false);
            this.match(100);
        }
        catch (ParseException parseException) {
            this.skipToSemicolon();
        }
    }

    private final boolean isConstTypeSpec(Token token) {
        return token.type == 27 || token.type == 32 || token.type == 9;
    }

    private SymtabEntry unionType(SymtabEntry symtabEntry, boolean bl) throws IOException, ParseException {
        this.match(32);
        String string = this.token.name;
        this.match(60);
        if (this.token.equals(28)) {
            UnionEntry unionEntry = this.stFactory.unionEntry(symtabEntry, (IDLID)repIDStack.peek());
            repIDStack.push(((IDLID)repIDStack.peek()).clone());
            ((IDLID)repIDStack.peek()).appendToName(string);
            unionEntry.sourceFile(this.scanner.fileEntry());
            unionEntry.lineNumber(this.scanner.currentLineNumber());
            unionEntry.comment(this.tokenHistory.lookBack((int)2).comment);
            unionEntry.name(string);
            SymtabEntry symtabEntry2 = this.getSymtabEntry(unionEntry.fullName());
            if (symtabEntry2 != null & symtabEntry2 instanceof ForwardUnionEntry) {
                ((ForwardUnionEntry)symtabEntry2).replaceForwardDcl(unionEntry, this.scanner);
            }
            this.pigeonhole(symtabEntry, unionEntry);
            this.match(28);
            this.match(108);
            unionEntry.type(this.switchTypeSpec(unionEntry));
            this.match(109);
            this.prep.openScope(unionEntry);
            this.match(101);
            this.switchBody(unionEntry);
            this.verifyUnion(unionEntry);
            this.prep.closeScope(unionEntry);
            this.match(102);
            if (symtabEntry2 != null & symtabEntry2 instanceof ForwardUnionEntry) {
                Vector vector = ((ForwardDclEntry)symtabEntry2).getReferencingEntries();
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    SymtabEntry symtabEntry3;
                    SymtabEntry symtabEntry4 = (SymtabEntry)enumeration.nextElement();
                    symtabEntry4.localOnly(unionEntry.isLocalOnly());
                    if (!(symtabEntry4 instanceof SequenceEntry) || (symtabEntry3 = ((SequenceEntry)symtabEntry4).ref()) == null) continue;
                    symtabEntry3.localOnly(unionEntry.isLocalOnly());
                }
            }
            repIDStack.pop();
            return unionEntry;
        }
        if (this.corbaLevel.gte(2.4f) && bl) {
            ForwardUnionEntry forwardUnionEntry = this.stFactory.forwardUnionEntry(symtabEntry, (IDLID)repIDStack.peek());
            forwardUnionEntry.sourceFile(this.scanner.fileEntry());
            forwardUnionEntry.lineNumber(this.scanner.currentLineNumber());
            forwardUnionEntry.name(string);
            forwardUnionEntry.comment(this.tokenHistory.lookBack((int)2).comment);
            this.pigeonhole(symtabEntry, forwardUnionEntry);
            return forwardUnionEntry;
        }
        return null;
    }

    private void verifyUnion(UnionEntry unionEntry) {
        SymtabEntry symtabEntry = Parser.typeOf(unionEntry);
        if (this.corbaLevel.gte(2.4f) && symtabEntry instanceof PrimitiveEntry && (symtabEntry.name().equals("char") || symtabEntry.name().equals("wchar"))) {
            ParseException.infoCharUnionSwitch(this.scanner, unionEntry.name());
        }
        unionEntry.complete();
        if (unionEntry.defaultSpecified() && unionEntry.defaultBranchValue() == null) {
            ParseException.noDefault(this.scanner);
        }
    }

    private SymtabEntry switchTypeSpec(UnionEntry unionEntry) throws IOException, ParseException {
        SymtabEntry symtabEntry = null;
        switch (this.token.type) {
            case 16: 
            case 25: 
            case 31: {
                return this.integerType(unionEntry);
            }
            case 4: 
            case 34: {
                return this.charType();
            }
            case 2: {
                return this.booleanType();
            }
            case 9: {
                return this.enumType(unionEntry);
            }
            case 60: 
            case 124: {
                SymtabEntry symtabEntry2;
                symtabEntry = this.scopedName(unionEntry, this.stFactory.primitiveEntry());
                if (this.hasArrayInfo(unionEntry.type())) {
                    ParseException.illegalArray(this.scanner, "switch");
                }
                if (!((symtabEntry2 = Parser.typeOf(symtabEntry)) instanceof EnumEntry) && !(symtabEntry2 instanceof PrimitiveEntry)) {
                    ParseException.wrongType(this.scanner, symtabEntry.fullName(), "long, unsigned long, short, unsigned short, char, boolean, enum", this.entryName(symtabEntry2));
                    break;
                }
                if (!(symtabEntry2 instanceof PrimitiveEntry)) break;
                SymtabEntry symtabEntry3 = this.qualifiedEntry("octet");
                SymtabEntry symtabEntry4 = this.qualifiedEntry("float");
                SymtabEntry symtabEntry5 = this.qualifiedEntry("double");
                if (symtabEntry2 != symtabEntry3 && symtabEntry2 != symtabEntry4 && symtabEntry2 != symtabEntry5) break;
                ParseException.wrongType(this.scanner, symtabEntry.fullName(), "long, unsigned long, short, unsigned short, char, boolean, enum", this.entryName(symtabEntry2));
                break;
            }
            default: {
                throw ParseException.syntaxError(this.scanner, new int[]{16, 25, 31, 4, 2, 9, 60, 124}, this.token.type);
            }
        }
        return symtabEntry;
    }

    private void switchBody(UnionEntry unionEntry) throws IOException, ParseException {
        this.caseProd(unionEntry);
        while (!this.token.equals(102)) {
            this.caseProd(unionEntry);
        }
    }

    private void caseProd(UnionEntry unionEntry) throws IOException, ParseException {
        UnionBranch unionBranch = new UnionBranch();
        unionEntry.addBranch(unionBranch);
        this.caseLabel(unionEntry, unionBranch);
        while (this.token.equals(3) || this.token.equals(7)) {
            this.caseLabel(unionEntry, unionBranch);
        }
        this.elementSpec(unionEntry, unionBranch);
        if (unionBranch.isDefault) {
            unionEntry.defaultBranch(unionBranch.typedef);
        }
        this.match(100);
    }

    private void caseLabel(UnionEntry unionEntry, UnionBranch unionBranch) throws IOException, ParseException {
        if (this.token.type == 3) {
            this.match(3);
            ConstEntry constEntry = this.stFactory.constEntry(unionEntry, (IDLID)repIDStack.peek());
            constEntry.sourceFile(this.scanner.fileEntry());
            constEntry.lineNumber(this.scanner.currentLineNumber());
            constEntry.type(unionEntry);
            SymtabEntry symtabEntry = Parser.typeOf(unionEntry.type());
            Expression expression = this.constExp(constEntry);
            this.verifyConstType(expression, symtabEntry);
            if (unionEntry.checkLabelValues(expression)) {
                ParseException.branchLabel(this.scanner, expression.rep());
            }
            unionBranch.labels.addElement(expression);
            this.match(103);
        } else if (this.token.type == 7) {
            this.match(7);
            this.match(103);
            if (unionBranch.isDefault || unionEntry.defaultBranch() != null) {
                ParseException.alreadyDefaulted(this.scanner);
            }
            unionBranch.isDefault = true;
        } else {
            throw ParseException.syntaxError(this.scanner, new int[]{3, 7}, this.token.type);
        }
    }

    private void elementSpec(UnionEntry unionEntry, UnionBranch unionBranch) throws IOException, ParseException {
        TypedefEntry typedefEntry = this.stFactory.typedefEntry(unionEntry, (IDLID)repIDStack.peek());
        typedefEntry.sourceFile(this.scanner.fileEntry());
        typedefEntry.lineNumber(this.scanner.currentLineNumber());
        typedefEntry.isTypeId(false);
        typedefEntry.comment(this.token.comment);
        typedefEntry.type(this.typeSpec(unionEntry, false));
        if (typedefEntry.type() == unionEntry) {
            throw ParseException.recursive(this.scanner, unionEntry.fullName(), this.token.name == null ? "" : this.token.name);
        }
        if (Parser.typeOf(typedefEntry) instanceof ExceptionEntry) {
            throw ParseException.illegalException(this.scanner, this.entryName(unionEntry));
        }
        this.declarator(typedefEntry, unionEntry, false);
        unionBranch.typedef = typedefEntry;
        if (unionEntry.has(typedefEntry)) {
            ParseException.branchName(this.scanner, typedefEntry.name());
        }
    }

    private EnumEntry enumType(SymtabEntry symtabEntry) throws IOException, ParseException {
        this.match(9);
        EnumEntry enumEntry = this.newEnumEntry(symtabEntry);
        enumEntry.comment(this.tokenHistory.lookBack((int)1).comment);
        enumEntry.name(this.token.name);
        this.match(60);
        this.prep.openScope(enumEntry);
        this.match(101);
        if (this.isntInStringList(enumEntry.elements(), this.token.name)) {
            enumEntry.addElement(this.token.name);
            EnumValueEntry enumValueEntry = new EnumValueEntry(symtabEntry, (IDLID)repIDStack.peek());
            enumValueEntry.type(enumEntry);
            enumValueEntry.sourceFile(this.scanner.fileEntry());
            enumValueEntry.lineNumber(this.scanner.currentLineNumber());
            if (enumValueEntry.module().equals("")) {
                enumValueEntry.module(enumValueEntry.name());
            } else if (!enumValueEntry.name().equals("")) {
                enumValueEntry.module(enumValueEntry.module() + "/" + enumValueEntry.name());
            }
            enumValueEntry.name(this.token.name);
            this.pigeonhole(enumEntry.container(), enumValueEntry);
        }
        this.match(60);
        this.enumType2(enumEntry);
        this.prep.closeScope(enumEntry);
        this.match(102);
        return enumEntry;
    }

    private void enumType2(EnumEntry enumEntry) throws IOException, ParseException {
        while (this.token.type == 104) {
            this.match(104);
            String string = this.token.name;
            this.match(60);
            if (!this.isntInStringList(enumEntry.elements(), string)) continue;
            enumEntry.addElement(string);
            EnumValueEntry enumValueEntry = new EnumValueEntry(enumEntry.container(), (IDLID)repIDStack.peek());
            enumValueEntry.type(enumEntry);
            enumValueEntry.sourceFile(this.scanner.fileEntry());
            enumValueEntry.lineNumber(this.scanner.currentLineNumber());
            if (enumValueEntry.module().equals("")) {
                enumValueEntry.module(enumValueEntry.name());
            } else if (!enumValueEntry.name().equals("")) {
                enumValueEntry.module(enumValueEntry.module() + "/" + enumValueEntry.name());
            }
            enumValueEntry.name(string);
            this.pigeonhole(enumEntry.container(), enumValueEntry);
        }
    }

    void issueAnonTypeMessage(String string, boolean bl) throws IOException, ParseException {
        if (!bl && this.issueAnonTypeMessages && this.corbaLevel.gte(2.4f)) {
            ParseException.infoAnonymousType(this.scanner, string);
        }
    }

    private SequenceEntry sequenceType(SymtabEntry symtabEntry, boolean bl) throws IOException, ParseException {
        this.issueAnonTypeMessage("sequence", bl);
        this.match(24);
        this.match(110);
        SequenceEntry sequenceEntry = this.newSequenceEntry(symtabEntry);
        sequenceEntry.type(this.simpleTypeSpec(sequenceEntry, false, bl));
        if (this.token.type == 104) {
            this.match(104);
            ConstEntry constEntry = this.stFactory.constEntry(sequenceEntry, (IDLID)repIDStack.peek());
            constEntry.sourceFile(this.scanner.fileEntry());
            constEntry.lineNumber(this.scanner.currentLineNumber());
            constEntry.type(this.qualifiedEntry("long"));
            sequenceEntry.maxSize(this.positiveIntConst(constEntry));
            this.verifyConstType(sequenceEntry.maxSize(), this.qualifiedEntry("long"));
        }
        this.match(111);
        return sequenceEntry;
    }

    private StringEntry fixedPtConstType(SymtabEntry symtabEntry) throws IOException, ParseException {
        StringEntry stringEntry = this.stFactory.stringEntry();
        stringEntry.name(Parser.overrideName("fixed"));
        this.match(47);
        ParseException.noFixedPtConstSupport(this.scanner);
        return stringEntry;
    }

    private StringEntry fixedPtType(SymtabEntry symtabEntry, boolean bl) throws IOException, ParseException {
        this.issueAnonTypeMessage("fixed", bl);
        StringEntry stringEntry = this.stFactory.stringEntry();
        stringEntry.name(Parser.overrideName("fixed"));
        this.match(47);
        this.match(110);
        ConstEntry constEntry = this.stFactory.constEntry(symtabEntry, (IDLID)repIDStack.peek());
        constEntry.sourceFile(this.scanner.fileEntry());
        constEntry.type(this.qualifiedEntry("long"));
        Expression expression = this.positiveIntConst(constEntry);
        this.verifyConstType(expression, this.qualifiedEntry("long"));
        this.match(104);
        constEntry = this.stFactory.constEntry(symtabEntry, (IDLID)repIDStack.peek());
        constEntry.sourceFile(this.scanner.fileEntry());
        constEntry.type(this.qualifiedEntry("long"));
        Expression expression2 = this.positiveIntConst(constEntry);
        this.verifyConstType(expression2, this.qualifiedEntry("long"));
        this.match(111);
        ParseException.noFixedPtSupport(this.scanner);
        return stringEntry;
    }

    private StringEntry stringType(SymtabEntry symtabEntry, boolean bl) throws IOException, ParseException {
        StringEntry stringEntry = this.stFactory.stringEntry();
        if (this.token.type == 26) {
            stringEntry.name(Parser.overrideName("string"));
            this.match(26);
            if (this.token.type == 110) {
                this.issueAnonTypeMessage("string", bl);
            }
        } else {
            stringEntry.name(Parser.overrideName("wstring"));
            this.match(35);
            if (this.token.type == 110) {
                this.issueAnonTypeMessage("wstring", bl);
            }
        }
        stringEntry.maxSize(this.stringType2(symtabEntry));
        return stringEntry;
    }

    private Expression stringType2(SymtabEntry symtabEntry) throws IOException, ParseException {
        if (this.token.type == 110) {
            this.match(110);
            ConstEntry constEntry = this.stFactory.constEntry(symtabEntry, (IDLID)repIDStack.peek());
            constEntry.sourceFile(this.scanner.fileEntry());
            constEntry.type(this.qualifiedEntry("long"));
            Expression expression = this.positiveIntConst(constEntry);
            this.verifyConstType(expression, this.qualifiedEntry("long"));
            this.match(111);
            return expression;
        }
        return null;
    }

    private void fixedArraySize(TypedefEntry typedefEntry) throws IOException, ParseException {
        this.match(112);
        ConstEntry constEntry = this.stFactory.constEntry(typedefEntry, (IDLID)repIDStack.peek());
        constEntry.sourceFile(this.scanner.fileEntry());
        constEntry.lineNumber(this.scanner.currentLineNumber());
        constEntry.type(this.qualifiedEntry("long"));
        Expression expression = this.positiveIntConst(constEntry);
        typedefEntry.addArrayInfo(expression);
        this.verifyConstType(expression, this.qualifiedEntry("long"));
        this.match(113);
    }

    private void attrDcl(InterfaceEntry interfaceEntry) throws IOException, ParseException {
        AttributeEntry attributeEntry = this.stFactory.attributeEntry(interfaceEntry, (IDLID)repIDStack.peek());
        attributeEntry.sourceFile(this.scanner.fileEntry());
        attributeEntry.lineNumber(this.scanner.currentLineNumber());
        attributeEntry.comment(this.token.comment);
        Comment comment = attributeEntry.comment();
        if (this.token.type == 23) {
            this.match(23);
            attributeEntry.readOnly(true);
        }
        this.match(1);
        attributeEntry.type(this.paramTypeSpec(attributeEntry));
        attributeEntry.name(this.token.name);
        if (!this.token.comment.text().equals("")) {
            attributeEntry.comment(this.token.comment);
        }
        boolean bl = interfaceEntry.methodsAddElement(attributeEntry, this.scanner);
        this.pigeonhole(interfaceEntry, attributeEntry, bl);
        if (!this.token.comment.text().equals("")) {
            AttributeEntry attributeEntry2 = (AttributeEntry)attributeEntry.clone();
            attributeEntry2.comment(comment);
            this.match(60);
            this.attrDcl2(interfaceEntry, attributeEntry2);
        } else {
            this.match(60);
            this.attrDcl2(interfaceEntry, attributeEntry);
        }
    }

    private void attrDcl2(InterfaceEntry interfaceEntry, AttributeEntry attributeEntry) throws IOException, ParseException {
        while (this.token.type == 104) {
            this.match(104);
            AttributeEntry attributeEntry2 = (AttributeEntry)attributeEntry.clone();
            attributeEntry2.name(this.token.name);
            if (!this.token.comment.text().equals("")) {
                attributeEntry2.comment(this.token.comment);
            }
            boolean bl = interfaceEntry.methodsAddElement(attributeEntry2, this.scanner);
            this.pigeonhole(interfaceEntry, attributeEntry2, bl);
            this.match(60);
        }
    }

    private void exceptDcl(SymtabEntry symtabEntry) throws IOException, ParseException {
        this.match(10);
        ExceptionEntry exceptionEntry = this.stFactory.exceptionEntry(symtabEntry, (IDLID)repIDStack.peek());
        repIDStack.push(((IDLID)repIDStack.peek()).clone());
        ((IDLID)repIDStack.peek()).appendToName(this.token.name);
        exceptionEntry.sourceFile(this.scanner.fileEntry());
        exceptionEntry.lineNumber(this.scanner.currentLineNumber());
        exceptionEntry.comment(this.tokenHistory.lookBack((int)1).comment);
        exceptionEntry.name(this.token.name);
        this.match(60);
        this.pigeonhole(symtabEntry, exceptionEntry);
        if (!this.token.equals(101)) {
            throw ParseException.syntaxError(this.scanner, 101, this.token.type);
        }
        this.prep.openScope(exceptionEntry);
        this.match(101);
        this.memberList2(exceptionEntry);
        this.prep.closeScope(exceptionEntry);
        this.match(102);
        repIDStack.pop();
    }

    private void opDcl(InterfaceEntry interfaceEntry) throws IOException, ParseException {
        MethodEntry methodEntry = this.stFactory.methodEntry(interfaceEntry, (IDLID)repIDStack.peek());
        methodEntry.sourceFile(this.scanner.fileEntry());
        methodEntry.lineNumber(this.scanner.currentLineNumber());
        methodEntry.comment(this.token.comment);
        if (this.token.type == 20) {
            this.match(20);
            methodEntry.oneway(true);
        }
        methodEntry.type(this.opTypeSpec(methodEntry, interfaceEntry));
        repIDStack.push(((IDLID)repIDStack.peek()).clone());
        ((IDLID)repIDStack.peek()).appendToName(this.token.name);
        methodEntry.name(this.token.name);
        boolean bl = interfaceEntry.methodsAddElement(methodEntry, this.scanner);
        this.pigeonhole(interfaceEntry, methodEntry, bl);
        this.opDcl2(methodEntry);
        if (methodEntry.oneway()) {
            this.checkIfOpLegalForOneway(methodEntry);
        }
        repIDStack.pop();
    }

    private void checkIfOpLegalForOneway(MethodEntry methodEntry) {
        boolean bl = false;
        if (methodEntry.type() != null || methodEntry.exceptions().size() != 0) {
            bl = true;
        } else {
            Enumeration enumeration = methodEntry.parameters().elements();
            while (enumeration.hasMoreElements()) {
                if (((ParameterEntry)enumeration.nextElement()).passType() == 0) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            ParseException.oneway(this.scanner, methodEntry.name());
        }
    }

    private void opDcl2(MethodEntry methodEntry) throws IOException, ParseException {
        if (this.token.equals(61)) {
            this.match(61);
            this.parameterDcls2(methodEntry);
        } else {
            this.match(60);
            this.parameterDcls(methodEntry);
        }
        this.opDcl3(methodEntry);
    }

    private void opDcl3(MethodEntry methodEntry) throws IOException, ParseException {
        if (this.token.type != 100) {
            if (!this.token.equals(22) && !this.token.equals(6)) {
                throw ParseException.syntaxError(this.scanner, new int[]{22, 6, 100}, this.token.type);
            }
            if (this.token.type == 22) {
                this.raisesExpr(methodEntry);
            }
            if (this.token.type == 6) {
                this.contextExpr(methodEntry);
            }
        }
    }

    private SymtabEntry opTypeSpec(SymtabEntry symtabEntry, InterfaceEntry interfaceEntry) throws IOException, ParseException {
        SymtabEntry symtabEntry2 = null;
        if (this.token.type == 33) {
            this.match(33);
        } else {
            symtabEntry2 = this.paramTypeSpec(symtabEntry);
        }
        return symtabEntry2;
    }

    private void parameterDcls(MethodEntry methodEntry) throws IOException, ParseException {
        this.match(108);
        this.parameterDcls2(methodEntry);
    }

    private void parameterDcls2(MethodEntry methodEntry) throws IOException, ParseException {
        if (this.token.type == 109) {
            this.match(109);
        } else {
            this.paramDcl(methodEntry);
            while (this.token.type == 104) {
                this.match(104);
                this.paramDcl(methodEntry);
            }
            this.match(109);
        }
    }

    private void paramDcl(MethodEntry methodEntry) throws IOException, ParseException {
        ParameterEntry parameterEntry = this.stFactory.parameterEntry(methodEntry, (IDLID)repIDStack.peek());
        parameterEntry.sourceFile(this.scanner.fileEntry());
        parameterEntry.lineNumber(this.scanner.currentLineNumber());
        parameterEntry.comment(this.token.comment);
        this.paramAttribute(parameterEntry);
        parameterEntry.type(this.paramTypeSpec(methodEntry));
        parameterEntry.name(this.token.name);
        this.match(60);
        this.pigeonhole(methodEntry, parameterEntry);
    }

    private void paramAttribute(ParameterEntry parameterEntry) throws IOException, ParseException {
        if (this.token.type == 13) {
            parameterEntry.passType(0);
            this.match(13);
        } else if (this.token.type == 21) {
            parameterEntry.passType(2);
            this.match(21);
        } else if (this.token.type == 14) {
            parameterEntry.passType(1);
            this.match(14);
        } else {
            throw ParseException.syntaxError(this.scanner, new int[]{13, 21, 14}, this.token.type);
        }
    }

    private void raisesExpr(MethodEntry methodEntry) throws IOException, ParseException {
        this.match(22);
        this.match(108);
        Comment comment = this.token.comment;
        SymtabEntry symtabEntry = this.scopedName(methodEntry.container(), this.stFactory.exceptionEntry());
        if (Parser.typeOf(symtabEntry) instanceof ExceptionEntry) {
            symtabEntry.comment(comment);
            if (this.isntInList(methodEntry.exceptions(), symtabEntry)) {
                methodEntry.exceptionsAddElement((ExceptionEntry)symtabEntry);
                if (symtabEntry.isLocalOnly() && this.isInterfaceOnly(methodEntry.container()) && !methodEntry.container().isLocalOnly()) {
                    ParseException.localException(this.scanner, symtabEntry.name(), methodEntry.name(), methodEntry.container().name());
                }
            }
        } else {
            ParseException.wrongType(this.scanner, symtabEntry.fullName(), "exception", this.entryName(symtabEntry.type()));
        }
        this.raisesExpr2(methodEntry);
        this.match(109);
    }

    private void raisesExpr2(MethodEntry methodEntry) throws IOException, ParseException {
        while (this.token.type == 104) {
            this.match(104);
            Comment comment = this.token.comment;
            SymtabEntry symtabEntry = this.scopedName(methodEntry.container(), this.stFactory.exceptionEntry());
            if (Parser.typeOf(symtabEntry) instanceof ExceptionEntry) {
                symtabEntry.comment(comment);
                if (!this.isntInList(methodEntry.exceptions(), symtabEntry)) continue;
                methodEntry.addException((ExceptionEntry)symtabEntry);
                continue;
            }
            ParseException.wrongType(this.scanner, symtabEntry.fullName(), "exception", this.entryName(symtabEntry.type()));
        }
    }

    private void contextExpr(MethodEntry methodEntry) throws IOException, ParseException {
        this.match(6);
        this.match(108);
        String string = (String)this.stringLiteral().value();
        if (this.isntInStringList(methodEntry.contexts(), string)) {
            methodEntry.addContext(string);
        }
        this.contextExpr2(methodEntry);
        this.match(109);
    }

    private void contextExpr2(MethodEntry methodEntry) throws IOException, ParseException {
        while (this.token.type == 104) {
            this.match(104);
            String string = (String)this.stringLiteral().value();
            if (!this.isntInStringList(methodEntry.contexts(), string)) continue;
            methodEntry.addContext(string);
        }
    }

    private SymtabEntry paramTypeSpec(SymtabEntry symtabEntry) throws IOException, ParseException {
        SymtabEntry symtabEntry2 = null;
        switch (this.token.type) {
            case 0: 
            case 2: 
            case 4: 
            case 8: 
            case 12: 
            case 16: 
            case 19: 
            case 25: 
            case 31: 
            case 34: 
            case 45: {
                return this.baseTypeSpec(symtabEntry);
            }
            case 26: 
            case 35: {
                return this.stringType(symtabEntry, true);
            }
            case 18: 
            case 42: 
            case 60: 
            case 124: {
                PrimitiveEntry primitiveEntry = this.stFactory.primitiveEntry();
                symtabEntry2 = this.scopedName(symtabEntry.container(), primitiveEntry);
                if (Parser.typeOf(symtabEntry2) instanceof AttributeEntry) {
                    ParseException.attributeNotType(this.scanner, symtabEntry2.name());
                } else if (Parser.typeOf(symtabEntry2) instanceof MethodEntry) {
                    ParseException.operationNotType(this.scanner, symtabEntry2.name());
                } else if (symtabEntry2 != primitiveEntry) {
                    this.checkTypeId(symtabEntry2);
                }
                if (symtabEntry2.type() == null || !symtabEntry2.type().name().equals("native") || this.currentInterface == null || this.currentInterface.isLocalOnly()) break;
                ParseException.nonLocalNative2(this.scanner, this.currentInterface.fullName(), symtabEntry2.fullName());
                break;
            }
            default: {
                throw ParseException.syntaxError(this.scanner, new int[]{12, 8, 16, 25, 31, 4, 34, 2, 19, 0, 26, 35, 60, 124, 42}, this.token.type);
            }
        }
        return symtabEntry2;
    }

    private void match(int n) throws IOException, ParseException {
        ParseException parseException = null;
        if (!this.token.equals(n)) {
            parseException = ParseException.syntaxError(this.scanner, n, this.token.type);
            if (n == 100) {
                return;
            }
        }
        if (this.token2 != null) {
            this.token = this.token2;
            this.token2 = null;
        } else {
            this.token = this.scanner.getToken();
        }
        if (this.token.equals(16)) {
            this.token2 = this.scanner.getToken();
            if (this.token2.equals(8)) {
                this.token = new Token(45);
                this.token2 = null;
            }
        }
        this.issueTokenWarnings();
        this.tokenHistory.insert(this.token);
        while (this.token.isDirective()) {
            this.token = this.prep.process(this.token);
        }
        if (this.token.type <= 61) {
            String string = (String)this.symbols.get(this.token.name);
            if (string != null && !string.equals("")) {
                if (this.macros.contains(this.token.name)) {
                    this.scanner.scanString(this.prep.expandMacro(string, this.token));
                    this.match(this.token.type);
                } else {
                    this.scanner.scanString(string);
                    this.match(this.token.type);
                }
            } else if (string != null && string.equals("")) {
                this.scanner.scanString(" ");
                this.match(this.token.type);
            }
        }
        if (parseException != null) {
            throw parseException;
        }
    }

    private void issueTokenWarnings() {
        if (this.noWarn) {
            return;
        }
        if ((this.token.equals(60) || this.token.equals(61)) && !this.token.isEscaped() && this.token.collidesWithKeyword()) {
            ParseException.warning(this.scanner, Util.getMessage("Migration.keywordCollision", this.token.name));
        }
        if (this.token.isKeyword() && this.token.isDeprecated()) {
            ParseException.warning(this.scanner, Util.getMessage("Deprecated.keyword", this.token.toString()));
        }
    }

    private ModuleEntry newModule(ModuleEntry moduleEntry) {
        ModuleEntry moduleEntry2 = this.stFactory.moduleEntry(moduleEntry, (IDLID)repIDStack.peek());
        moduleEntry2.sourceFile(this.scanner.fileEntry());
        moduleEntry2.lineNumber(this.scanner.currentLineNumber());
        moduleEntry2.name(this.token.name);
        SymtabEntry symtabEntry = this.getSymtabEntry(moduleEntry2.fullName());
        if (!this.cppModule && symtabEntry != null && symtabEntry instanceof ModuleEntry) {
            boolean bl = moduleEntry2.emit();
            moduleEntry2 = (ModuleEntry)symtabEntry;
            if (bl && !moduleEntry2.emit()) {
                moduleEntry2.emit(true);
            }
            if (moduleEntry == this.topLevelModule) {
                if (!moduleEntry2.emit()) {
                    this.addToContainer(moduleEntry, moduleEntry2);
                } else if (!moduleEntry.contained().contains(moduleEntry2)) {
                    this.addToContainer(moduleEntry, moduleEntry2);
                }
            }
        } else {
            this.pigeonhole(moduleEntry, moduleEntry2);
        }
        return moduleEntry2;
    }

    private EnumEntry newEnumEntry(SymtabEntry symtabEntry) {
        EnumEntry enumEntry = this.stFactory.enumEntry(symtabEntry, (IDLID)repIDStack.peek());
        enumEntry.sourceFile(this.scanner.fileEntry());
        enumEntry.lineNumber(this.scanner.currentLineNumber());
        enumEntry.name(this.token.name);
        this.pigeonhole(symtabEntry, enumEntry);
        return enumEntry;
    }

    private SequenceEntry newSequenceEntry(SymtabEntry symtabEntry) {
        SequenceEntry sequenceEntry = this.stFactory.sequenceEntry(symtabEntry, (IDLID)repIDStack.peek());
        sequenceEntry.sourceFile(this.scanner.fileEntry());
        sequenceEntry.lineNumber(this.scanner.currentLineNumber());
        sequenceEntry.name("");
        this.pigeonhole(symtabEntry, sequenceEntry);
        return sequenceEntry;
    }

    private void checkContainerDcl(SymtabEntry symtabEntry, SymtabEntry symtabEntry2) {
        if (symtabEntry instanceof InterfaceEntry || symtabEntry instanceof StructEntry || symtabEntry instanceof UnionEntry || symtabEntry instanceof ExceptionEntry || symtabEntry instanceof ModuleEntry) {
            if (symtabEntry.name().toLowerCase().equals(symtabEntry2.name().toLowerCase())) {
                ParseException.sameAsContainer(this.scanner, symtabEntry2.name());
            } else if (symtabEntry instanceof InterfaceEntry) {
                Object object;
                InterfaceEntry interfaceEntry = (InterfaceEntry)symtabEntry;
                Object object2 = interfaceEntry.derivedFrom().elements();
                while (object2.hasMoreElements()) {
                    object = (SymtabEntry)object2.nextElement();
                    if (!(object instanceof InterfaceEntry)) continue;
                    this.checkContainerDcl((SymtabEntry)object, symtabEntry2);
                }
                if (symtabEntry instanceof ValueEntry) {
                    object2 = (ValueEntry)symtabEntry;
                    object = ((ValueEntry)object2).supports().elements();
                    while (object.hasMoreElements()) {
                        SymtabEntry symtabEntry3 = (SymtabEntry)object.nextElement();
                        if (!(symtabEntry3 instanceof ValueEntry)) continue;
                        this.checkContainerDcl(symtabEntry3, symtabEntry2);
                    }
                }
            }
            return;
        }
    }

    private boolean isType(SymtabEntry symtabEntry) {
        return symtabEntry != null && !(symtabEntry instanceof EnumValueEntry) && (!(symtabEntry instanceof TypedefEntry) || ((TypedefEntry)symtabEntry).isTypeId()) && !(symtabEntry instanceof ConstEntry) && !(symtabEntry instanceof MethodEntry) && !(symtabEntry instanceof ExceptionEntry) && !(symtabEntry instanceof ModuleEntry) && !(symtabEntry instanceof ParameterEntry);
    }

    private void checkTypeDcl(SymtabEntry symtabEntry, SymtabEntry symtabEntry2) {
        SymtabEntry symtabEntry3;
        if (!this.isType(symtabEntry2)) {
            return;
        }
        SymtabEntry symtabEntry4 = symtabEntry;
        if (symtabEntry4 != null && !(symtabEntry4 instanceof InterfaceEntry) && !(symtabEntry4 instanceof ModuleEntry)) {
            symtabEntry4 = this.getMIVContainer(symtabEntry4);
        }
        if (symtabEntry4 != null && symtabEntry4 instanceof InterfaceEntry && (symtabEntry3 = this.unqualifiedEntry(symtabEntry2.name(), symtabEntry, false)) != null && symtabEntry3.useRef() != null) {
            SymtabEntry symtabEntry5 = symtabEntry3.useRef();
            SymtabEntry symtabEntry6 = null;
            SymtabEntry symtabEntry7 = null;
            SymtabEntry symtabEntry8 = null;
            symtabEntry8 = symtabEntry4;
            while (symtabEntry8 != null && symtabEntry6 == null) {
                if (!(symtabEntry8 instanceof ModuleEntry)) {
                    symtabEntry7 = symtabEntry5;
                    while (symtabEntry7 != null && symtabEntry6 == null) {
                        if (symtabEntry7.fullName().equals(symtabEntry8.fullName())) {
                            symtabEntry6 = symtabEntry7;
                        }
                        symtabEntry7 = this.getMIVContainer(symtabEntry7);
                    }
                }
                symtabEntry8 = this.getMIVContainer(symtabEntry8);
            }
            if (symtabEntry6 != null) {
                ParseException.redeclareAfterUse(this.scanner, symtabEntry2.fullName(), symtabEntry3.fullName(), symtabEntry6.fullName());
            }
        }
    }

    private SymtabEntry getMIVContainer(SymtabEntry symtabEntry) {
        SymtabEntry symtabEntry2 = null;
        if (symtabEntry != null) {
            symtabEntry2 = symtabEntry.container();
        }
        while (symtabEntry2 != null && !(symtabEntry2 instanceof ModuleEntry) && !(symtabEntry2 instanceof InterfaceEntry)) {
            symtabEntry2 = symtabEntry2.container();
        }
        return symtabEntry2;
    }

    private void pigeonhole(SymtabEntry symtabEntry, SymtabEntry symtabEntry2) {
        this.pigeonhole(symtabEntry, symtabEntry2, true);
    }

    private void pigeonhole(SymtabEntry symtabEntry, SymtabEntry symtabEntry2, boolean bl) {
        String string;
        if (symtabEntry2.name().equals("")) {
            symtabEntry2.name(unknownNamePrefix + ++this.sequence);
        }
        if (overrideNames.get(string = symtabEntry2.fullName()) == null) {
            this.checkTypeDcl(symtabEntry, symtabEntry2);
            this.checkContainerDcl(symtabEntry, symtabEntry2);
            this.checkLocalOnly(symtabEntry, symtabEntry2);
            this.addToContainer(symtabEntry, symtabEntry2);
            SymtabEntry symtabEntry3 = this.getSymtabEntry(string);
            if (symtabEntry3 == null) {
                String string2;
                String string3 = "";
                String string4 = symtabEntry2.name().toLowerCase();
                if (!symtabEntry2.module().equals("")) {
                    string3 = (symtabEntry2.module() + '/').toLowerCase();
                }
                if (string4.startsWith("_")) {
                    string4 = string4.substring(1);
                }
                if (this.lcSymbolTable.get(string2 = string3 + string4) != null && bl) {
                    ParseException.alreadyDeclared(this.scanner, string);
                }
                if (this.introducedSymbolTable.get(string2) != null && bl) {
                    ParseException.alreadyIntroduced(this.scanner, string);
                }
                symbolTable.put(string, symtabEntry2);
                this.lcSymbolTable.put(string2, symtabEntry2);
                if (string.startsWith("org/omg/CORBA")) {
                    overrideNames.put("CORBA" + string.substring(13), string);
                }
            } else if (symtabEntry3 instanceof ForwardDclEntry && symtabEntry2 instanceof ActualDcl) {
                String string5;
                String string6 = ((IDLID)symtabEntry2.repositoryID()).prefix();
                if (string6.equals(string5 = ((IDLID)symtabEntry3.repositoryID()).prefix())) {
                    String string7 = string.toLowerCase();
                    symbolTable.put(string, symtabEntry2);
                    this.lcSymbolTable.put(string7, symtabEntry2);
                } else {
                    ParseException.badRepIDPrefix(this.scanner, string, string5, string6);
                }
            } else if (symtabEntry2 instanceof ForwardDclEntry && (symtabEntry3 instanceof ActualDcl || symtabEntry3 instanceof ForwardDclEntry)) {
                String string8;
                String string9;
                symtabEntry2.type(symtabEntry3);
                if (symtabEntry3 instanceof ForwardDclEntry && symtabEntry2.repositoryID() instanceof IDLID && symtabEntry3.repositoryID() instanceof IDLID && !(string9 = ((IDLID)symtabEntry2.repositoryID()).prefix()).equals(string8 = ((IDLID)symtabEntry3.repositoryID()).prefix())) {
                    ParseException.badRepIDPrefix(this.scanner, string, string8, string9);
                }
            } else if (!(this.cppModule && symtabEntry2 instanceof ModuleEntry && symtabEntry3 instanceof ModuleEntry)) {
                if (string.startsWith("org/omg/CORBA") || string.startsWith("CORBA")) {
                    if (symtabEntry2 instanceof AttributeEntry || symtabEntry2 instanceof ConstEntry || symtabEntry2 instanceof EnumEntry || symtabEntry2 instanceof ExceptionEntry || symtabEntry2 instanceof MethodEntry || symtabEntry2 instanceof PrimitiveEntry || symtabEntry2 instanceof SequenceEntry || symtabEntry2 instanceof StructEntry || symtabEntry2 instanceof TypedefEntry || symtabEntry2 instanceof UnionEntry) {
                        ParseException.alreadyDeclared(this.scanner, string);
                    }
                } else if (bl) {
                    ParseException.alreadyDeclared(this.scanner, string);
                }
            }
        }
    }

    private void addToContainer(SymtabEntry symtabEntry, SymtabEntry symtabEntry2) {
        if (symtabEntry instanceof ModuleEntry) {
            ((ModuleEntry)symtabEntry).addContained(symtabEntry2);
        } else if (symtabEntry instanceof InterfaceEntry) {
            if (symtabEntry2 instanceof FactoryMethodEntry && symtabEntry instanceof ValueEntry) {
                ((ValueEntry)symtabEntry).initializersAddElement((FactoryMethodEntry)symtabEntry2, this.scanner);
            } else if (symtabEntry2 instanceof InterfaceState) {
                ((InterfaceEntry)symtabEntry).addStateElement((InterfaceState)symtabEntry2, this.scanner);
            } else {
                ((InterfaceEntry)symtabEntry).addContained(symtabEntry2);
            }
        } else if (symtabEntry instanceof StructEntry) {
            if (!(symtabEntry2 instanceof TypedefEntry) || ((TypedefEntry)symtabEntry2).isTypeId()) {
                ((StructEntry)symtabEntry).addContained(symtabEntry2);
            }
        } else if (symtabEntry instanceof UnionEntry) {
            if (!(symtabEntry2 instanceof TypedefEntry) || ((TypedefEntry)symtabEntry2).isTypeId()) {
                ((UnionEntry)symtabEntry).addContained(symtabEntry2);
            }
        } else if (symtabEntry instanceof SequenceEntry) {
            ((SequenceEntry)symtabEntry).addContained(symtabEntry2);
        } else if (symtabEntry instanceof MethodEntry) {
            ((MethodEntry)symtabEntry).addParameter((ParameterEntry)symtabEntry2);
        }
    }

    private void checkLocalOnly(SymtabEntry symtabEntry, SymtabEntry symtabEntry2) {
        if (symtabEntry2.type() != null && symtabEntry2.type().isLocalOnly()) {
            symtabEntry2.localOnly(true);
        }
        if (!symtabEntry2.isLocalOnly()) {
            return;
        }
        if (!(symtabEntry instanceof ModuleEntry)) {
            if (symtabEntry instanceof ValueEntry) {
                if (symtabEntry2 instanceof InterfaceState) {
                    ParseException.localStateMember(this.scanner, symtabEntry2.name(), symtabEntry.name());
                }
            } else if (symtabEntry instanceof InterfaceEntry) {
                if (!symtabEntry.isLocalOnly() && symtabEntry2 instanceof MethodEntry) {
                    if (symtabEntry2 instanceof AttributeEntry) {
                        ParseException.localAttribute(this.scanner, symtabEntry2.name(), symtabEntry.name());
                    } else {
                        ParseException.localReturn(this.scanner, symtabEntry2.name(), symtabEntry.name());
                    }
                }
            } else if (symtabEntry instanceof StructEntry || symtabEntry instanceof UnionEntry) {
                if (symtabEntry2 instanceof TypedefEntry && !((TypedefEntry)symtabEntry2).isTypeId() && symtabEntry2.isLocalOnly()) {
                    symtabEntry.localOnly(true);
                }
            } else if (symtabEntry instanceof SequenceEntry) {
                if (symtabEntry2.isLocalOnly()) {
                    symtabEntry.localOnly(true);
                }
            } else if (symtabEntry instanceof MethodEntry && this.isInterfaceOnly(symtabEntry.container()) && !symtabEntry.container().isLocalOnly()) {
                ParseException.localParameter(this.scanner, symtabEntry2.name(), symtabEntry.name(), symtabEntry.container().name());
            }
        }
    }

    SymtabEntry resolve(String string, SymtabEntry symtabEntry, boolean bl, boolean bl2, boolean bl3) {
        return this.resolve(string, symtabEntry, bl, bl2, bl3, this._isModuleLegalType);
    }

    SymtabEntry resolve(String string, SymtabEntry symtabEntry, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        String string2 = string;
        SymtabEntry symtabEntry2 = null;
        SymtabEntry symtabEntry3 = symtabEntry;
        if (symtabEntry3 == null && !bl) {
            symtabEntry2 = this.resolveRecursive(string, null, false, false, bl2);
        } else {
            int n = 0;
            String string3 = null;
            while (string2 != null) {
                n = string2.indexOf(47);
                if (n != -1) {
                    string3 = string2.substring(0, n);
                    string2 = string2.substring(n + 1);
                } else {
                    string3 = string2;
                    string2 = null;
                    bl = false;
                }
                if ((symtabEntry2 = symtabEntry2 == null ? this.resolveRecursive(string3, symtabEntry3, bl, true, bl2) : this.resolveRecursive(string3, symtabEntry2, bl, false, bl2)) != null) continue;
                string2 = null;
            }
        }
        if (symtabEntry2 == null) {
            if (bl2) {
                ParseException.undeclaredType(this.scanner, string);
            }
        } else if (symtabEntry2 instanceof ModuleEntry && !bl4) {
            if (bl3) {
                ParseException.moduleNotType(this.scanner, string);
            }
            symtabEntry2 = null;
        }
        return symtabEntry2;
    }

    SymtabEntry resolveRecursive(String string, SymtabEntry symtabEntry, boolean bl, boolean bl2, boolean bl3) {
        SymtabEntry symtabEntry2 = null;
        SymtabEntry symtabEntry3 = symtabEntry;
        if (symtabEntry3 == null || symtabEntry3.fullName() == null || symtabEntry3.fullName().equals("")) {
            symtabEntry3 = null;
        }
        if (symtabEntry3 == null) {
            symtabEntry2 = this.searchOverrideNames(string);
            if (symtabEntry2 == null) {
                symtabEntry2 = this.getSymtabEntry(string);
            }
        } else {
            boolean bl4 = true;
            while (symtabEntry2 == null && symtabEntry3 != null) {
                symtabEntry2 = this.getSymtabEntry(symtabEntry3.fullName() + '/' + string);
                if (symtabEntry2 == null && symtabEntry3 instanceof InterfaceEntry) {
                    symtabEntry2 = this.searchLocalInheritanceScope(string, symtabEntry3, bl3);
                }
                if (symtabEntry2 == null && bl4) {
                    symtabEntry2 = this.searchOverrideNames(string);
                }
                if (symtabEntry2 == null) {
                    if (!bl2) {
                        symtabEntry3 = null;
                    } else {
                        if ((symtabEntry3 = symtabEntry3.container()) == null || symtabEntry3.fullName() == null || symtabEntry3.fullName().equals("")) {
                            symtabEntry3 = null;
                        }
                        if (symtabEntry3 == null) {
                            symtabEntry2 = this.resolveRecursive(string, null, bl, false, bl3);
                        }
                    }
                }
                bl4 = false;
            }
        }
        if (symtabEntry2 != null && bl && symtabEntry2 instanceof TypedefEntry && ((TypedefEntry)symtabEntry2).isTypeId()) {
            symtabEntry2 = this.resolveRecursive(Parser.typeOf(symtabEntry2).fullName(), null, true, false, bl3);
        }
        return symtabEntry2;
    }

    SymtabEntry qualifiedEntry(String string) {
        SymtabEntry symtabEntry = this.resolve(string, null, false, false, true);
        if (symtabEntry == null) {
            symtabEntry = this.resolve(string, null, true, true, true);
        }
        return symtabEntry;
    }

    SymtabEntry partlyQualifiedEntry(String string, SymtabEntry symtabEntry) {
        return this.resolve(string, symtabEntry, true, true, true);
    }

    SymtabEntry unqualifiedEntry(String string, SymtabEntry symtabEntry) {
        return this.unqualifiedEntry(string, symtabEntry, true, true);
    }

    SymtabEntry unqualifiedEntry(String string, SymtabEntry symtabEntry, boolean bl) {
        return this.unqualifiedEntry(string, symtabEntry, bl, bl);
    }

    SymtabEntry unqualifiedEntry(String string, SymtabEntry symtabEntry, boolean bl, boolean bl2) {
        return this.resolve(string, symtabEntry, true, bl, bl2);
    }

    SymtabEntry searchLocalInheritanceScope(String string, SymtabEntry symtabEntry, boolean bl) {
        return symtabEntry instanceof InterfaceEntry ? this.searchDerivedFrom(string, (InterfaceEntry)symtabEntry, bl) : null;
    }

    SymtabEntry searchOverrideNames(String string) {
        String string2 = (String)overrideNames.get(string);
        return string2 != null ? (SymtabEntry)symbolTable.get(string2) : null;
    }

    SymtabEntry searchDerivedFrom(String string, InterfaceEntry interfaceEntry, boolean bl) {
        SymtabEntry symtabEntry = null;
        Enumeration enumeration = interfaceEntry.derivedFrom().elements();
        while (enumeration.hasMoreElements()) {
            SymtabEntry symtabEntry2 = (SymtabEntry)enumeration.nextElement();
            if (!(symtabEntry2 instanceof InterfaceEntry)) continue;
            InterfaceEntry interfaceEntry2 = (InterfaceEntry)symtabEntry2;
            String string2 = interfaceEntry2.fullName() + '/' + string;
            SymtabEntry symtabEntry3 = this.getSymtabEntry(string2);
            if (symtabEntry3 == null) {
                symtabEntry3 = this.searchDerivedFrom(string, interfaceEntry2, bl);
            }
            if (symtabEntry3 == null) continue;
            if (symtabEntry == null) {
                symtabEntry = symtabEntry3;
                continue;
            }
            if (symtabEntry3.fullName().equals(symtabEntry.fullName())) continue;
            if (bl) {
                ParseException.ambiguousRef(this.scanner, string, symtabEntry.fullName(), symtabEntry3.fullName());
            }
            return symtabEntry;
        }
        return symtabEntry;
    }

    String entryName(SymtabEntry symtabEntry) {
        if (symtabEntry instanceof AttributeEntry) {
            return "attribute";
        }
        if (symtabEntry instanceof ConstEntry) {
            return "constant";
        }
        if (symtabEntry instanceof EnumEntry) {
            return "enumeration";
        }
        if (symtabEntry instanceof ExceptionEntry) {
            return "exception";
        }
        if (symtabEntry instanceof ValueBoxEntry) {
            return "value box";
        }
        if (symtabEntry instanceof ForwardValueEntry || symtabEntry instanceof ValueEntry) {
            return "value";
        }
        if (symtabEntry instanceof ForwardEntry || symtabEntry instanceof InterfaceEntry) {
            return "interface";
        }
        if (symtabEntry instanceof MethodEntry) {
            return "method";
        }
        if (symtabEntry instanceof ModuleEntry) {
            return "module";
        }
        if (symtabEntry instanceof ParameterEntry) {
            return "parameter";
        }
        if (symtabEntry instanceof PrimitiveEntry) {
            return "primitive";
        }
        if (symtabEntry instanceof SequenceEntry) {
            return "sequence";
        }
        if (symtabEntry instanceof StringEntry) {
            return "string";
        }
        if (symtabEntry instanceof StructEntry) {
            return "struct";
        }
        if (symtabEntry instanceof TypedefEntry) {
            return "typedef";
        }
        if (symtabEntry instanceof UnionEntry) {
            return "union";
        }
        return "void";
    }

    private boolean isInterface(SymtabEntry symtabEntry) {
        return symtabEntry instanceof InterfaceEntry || symtabEntry instanceof ForwardEntry;
    }

    private boolean isValue(SymtabEntry symtabEntry) {
        return symtabEntry instanceof ValueEntry || symtabEntry instanceof ForwardValueEntry;
    }

    private boolean isInterfaceOnly(SymtabEntry symtabEntry) {
        return this.isInterface(symtabEntry) && !this.isValue(symtabEntry);
    }

    private boolean isntInStringList(Vector vector, String string) {
        boolean bl = true;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            if (!string.equals((String)enumeration.nextElement())) continue;
            ParseException.alreadyDeclared(this.scanner, string);
            bl = false;
            break;
        }
        return bl;
    }

    private boolean isntInList(Vector vector, String string) {
        boolean bl = true;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            if (!string.equals(((SymtabEntry)enumeration.nextElement()).name())) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private boolean isntInList(Vector vector, SymtabEntry symtabEntry) {
        boolean bl = true;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            SymtabEntry symtabEntry2 = (SymtabEntry)enumeration.nextElement();
            if (symtabEntry != symtabEntry2) continue;
            ParseException.alreadyDeclared(this.scanner, symtabEntry.fullName());
            bl = false;
            break;
        }
        return bl;
    }

    public static SymtabEntry typeOf(SymtabEntry symtabEntry) {
        while (symtabEntry instanceof TypedefEntry) {
            symtabEntry = symtabEntry.type();
        }
        return symtabEntry;
    }

    void forwardEntryCheck() {
        this.purgeIntroducedSymbols();
        Enumeration enumeration = symbolTable.elements();
        while (enumeration.hasMoreElements()) {
            SymtabEntry symtabEntry = (SymtabEntry)enumeration.nextElement();
            if (!(symtabEntry instanceof ForwardDclEntry)) continue;
            if (symtabEntry instanceof ForwardEntry && this.allowMissingInterfaces) {
                ForwardEntry forwardEntry = (ForwardEntry)symtabEntry;
                if (forwardEntry.inheritanceRef() || symtabEntry instanceof ForwardValueEntry) {
                    ParseException.forwardEntry(this.scanner, forwardEntry.fullName());
                    continue;
                }
                InterfaceEntry interfaceEntry = null;
                interfaceEntry = forwardEntry instanceof ForwardValueEntry ? this.stFactory.valueEntry((ModuleEntry)forwardEntry.container(), (IDLID)forwardEntry.repositoryID()) : this.stFactory.interfaceEntry((ModuleEntry)forwardEntry.container(), (IDLID)forwardEntry.repositoryID());
                interfaceEntry.sourceFile(forwardEntry.sourceFile());
                interfaceEntry.lineNumber(forwardEntry.lineNumber());
                interfaceEntry.name(forwardEntry.name());
                interfaceEntry.setAbstract(forwardEntry.isAbstract());
                interfaceEntry.setMissing(true);
                forwardEntry.setMissing(true);
                forwardEntry.replaceForwardDcl(interfaceEntry, this.scanner);
                this.pigeonhole(forwardEntry.container(), interfaceEntry);
                continue;
            }
            ParseException.forwardEntry(this.scanner, symtabEntry.fullName());
        }
    }

    void purgeIntroducedSymbols() {
        this.introducedSymbolTable.clear();
    }

    private void skipToSemicolon() throws IOException {
        while (!this.token.equals(999) && !this.token.equals(100)) {
            if (this.token.equals(101)) {
                this.skipToRightBrace();
            }
            try {
                this.match(this.token.type);
            }
            catch (ParseException parseException) {}
        }
        if (this.token.equals(999)) {
            throw new EOFException();
        }
        try {
            this.match(100);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void skipToRightBrace() throws IOException {
        boolean bl = true;
        while (!this.token.equals(999) && !this.token.equals(102)) {
            if (bl) {
                bl = false;
            } else if (this.token.equals(101)) {
                this.skipToRightBrace();
            }
            try {
                this.match(this.token.type);
            }
            catch (ParseException parseException) {}
        }
        if (this.token.equals(999)) {
            throw new EOFException();
        }
    }

    public static void enteringInclude() {
        repIDStack.push(new IDLID());
    }

    public static void exitingInclude() {
        repIDStack.pop();
    }

    public SymtabEntry getSymtabEntry(String string) {
        ++symbolTableCount;
        return (SymtabEntry)symbolTable.get(string);
    }

    static {
        repIDStack = new Stack();
    }
}

