/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.beaninfo;

import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import java.lang.reflect.Method;

public abstract class SwingBeanInfo
extends SimpleBeanInfo {
    public static final String BOUND = "bound";
    public static final String CONSTRAINED = "constrained";
    public static final String PROPERTYEDITORCLASS = "propertyEditorClass";
    public static final String READMETHOD = "readMethod";
    public static final String WRITEMETHOD = "writeMethod";
    public static final String DISPLAYNAME = "displayName";
    public static final String EXPERT = "expert";
    public static final String HIDDEN = "hidden";
    public static final String PREFERRED = "preferred";
    public static final String SHORTDESCRIPTION = "shortDescription";
    public static final String CUSTOMIZERCLASS = "customizerClass";

    protected void throwError(Exception exception, String string) {
        throw new Error(exception.toString() + " " + string);
    }

    private void initFeatureDescriptor(FeatureDescriptor featureDescriptor, String string, Object object) {
        if (DISPLAYNAME.equals(string)) {
            featureDescriptor.setDisplayName((String)object);
        }
        if (EXPERT.equals(string)) {
            featureDescriptor.setExpert((Boolean)object);
        }
        if (HIDDEN.equals(string)) {
            featureDescriptor.setHidden((Boolean)object);
        }
        if (PREFERRED.equals(string)) {
            if (PREFERRED.equals(string)) {
                featureDescriptor.setValue(string, object);
            }
        } else if (SHORTDESCRIPTION.equals(string)) {
            featureDescriptor.setShortDescription((String)object);
        } else {
            featureDescriptor.setValue(string, object);
        }
    }

    public PropertyDescriptor createPropertyDescriptor(Class clazz, String string, Object[] objectArray) {
        PropertyDescriptor propertyDescriptor = null;
        try {
            propertyDescriptor = new PropertyDescriptor(string, clazz);
        }
        catch (IntrospectionException introspectionException) {
            try {
                propertyDescriptor = this.createReadOnlyPropertyDescriptor(string, clazz);
            }
            catch (IntrospectionException introspectionException2) {
                this.throwError(introspectionException2, "Can't create PropertyDescriptor for " + string + " ");
            }
        }
        for (int i = 0; i < objectArray.length; i += 2) {
            Method method;
            String string2;
            String string3 = (String)objectArray[i];
            Object object = objectArray[i + 1];
            if (BOUND.equals(string3)) {
                propertyDescriptor.setBound((Boolean)object);
                continue;
            }
            if (CONSTRAINED.equals(string3)) {
                propertyDescriptor.setConstrained((Boolean)object);
                continue;
            }
            if (PROPERTYEDITORCLASS.equals(string3)) {
                propertyDescriptor.setPropertyEditorClass((Class)object);
                continue;
            }
            if (READMETHOD.equals(string3)) {
                string2 = (String)object;
                try {
                    method = clazz.getMethod(string2, new Class[0]);
                }
                catch (Exception exception) {
                    this.throwError(exception, clazz + " no such method as \"" + string2 + "\"");
                }
                continue;
            }
            if (WRITEMETHOD.equals(string3)) {
                string2 = (String)object;
                try {
                    Class<?> clazz2 = propertyDescriptor.getPropertyType();
                    method = clazz.getMethod(string2, clazz2);
                }
                catch (Exception exception) {
                    this.throwError(exception, clazz + " no such method as \"" + string2 + "\"");
                }
                continue;
            }
            this.initFeatureDescriptor(propertyDescriptor, string3, object);
        }
        return propertyDescriptor;
    }

    public BeanDescriptor createBeanDescriptor(Class clazz, Object[] objectArray) {
        Class clazz2 = null;
        for (int i = 0; i < objectArray.length; i += 2) {
            if (!CUSTOMIZERCLASS.equals((String)objectArray[i])) continue;
            clazz2 = (Class)objectArray[i + 1];
            break;
        }
        BeanDescriptor beanDescriptor = new BeanDescriptor(clazz, clazz2);
        for (int i = 0; i < objectArray.length; i += 2) {
            String string = (String)objectArray[i];
            Object object = objectArray[i + 1];
            this.initFeatureDescriptor(beanDescriptor, string, object);
        }
        return beanDescriptor;
    }

    public int getDefaultPropertyIndex() {
        return 0;
    }

    public Image getIcon(int n) {
        return null;
    }

    public BeanInfo[] getAdditionalBeanInfo() {
        Class<?> clazz = this.getBeanDescriptor().getBeanClass().getSuperclass();
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        if (beanInfo != null) {
            BeanInfo[] beanInfoArray = new BeanInfo[]{beanInfo};
            return beanInfoArray;
        }
        return null;
    }

    private PropertyDescriptor createReadOnlyPropertyDescriptor(String string, Class clazz) throws IntrospectionException {
        Method method = null;
        String string2 = SwingBeanInfo.capitalize(string);
        Class[] classArray = new Class[]{};
        try {
            method = clazz.getMethod("is" + string2, classArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (method == null) {
            try {
                method = clazz.getMethod("get" + string2, classArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (method != null) {
            return new PropertyDescriptor(string, method, null);
        }
        try {
            classArray = new Class[]{Integer.TYPE};
            method = clazz.getMethod("get" + string2, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IntrospectionException("cannot find accessor method for " + string + " property.");
        }
        return new IndexedPropertyDescriptor(string, null, null, method, null);
    }

    private static String capitalize(String string) {
        if (string.length() == 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toUpperCase(cArray[0]);
        return new String(cArray);
    }
}

