/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.runtime;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.EJBContainerException;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.csi.EJBClusterNameService;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.deploy.DeployedObjectEvent;
import com.ibm.ws.runtime.deploy.DeployedObjectListener;
import com.ibm.ws.runtime.service.ApplicationMgr;
import com.ibm.ws.runtime.service.EJBContainer;
import com.ibm.ws.runtime.service.Server;
import com.ibm.wsspi.cluster.ClusterMemberService;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.NoClusterDefinedException;
import com.ibm.wsspi.cluster.adapter.IdentityMapping;

public class ApplicationServerRuntimeImpl
extends ComponentImpl
implements EJBClusterNameService,
DeployedObjectListener {
    private static final TraceComponent tc = Tr.register((Class)ApplicationServerRuntimeImpl.class, (String)"WLM", (String)"com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final String cellName = AdminServiceFactory.getAdminService().getCellName();
    private static ClusterMemberService clusterMemberService = null;
    private Identity containingClusterIdentity = null;

    public static void setClusterMemberService(ClusterMemberService clusterMemberService) {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"setClusterMemberService", (Object)clusterMemberService);
        }
        ApplicationServerRuntimeImpl.clusterMemberService = clusterMemberService;
    }

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize", (Object)object);
        }
        super.initialize(object);
        Server server = (Server)this.getService(Server.class);
        String string = server.getClusterName();
        if (string != null) {
            EJBContainer eJBContainer;
            block5: {
                this.containingClusterIdentity = IdentityMapping.getApplicationServerCluster(cellName, string);
                eJBContainer = (EJBContainer)this.getService(EJBContainer.class);
                try {
                    eJBContainer.setClusterNameService((EJBClusterNameService)this);
                }
                catch (EJBContainerException eJBContainerException) {
                    FFDCFilter.processException((Throwable)eJBContainerException, (String)(ApplicationServerRuntimeImpl.class.getName() + ".start"), (String)"107", (Object)((Object)this));
                    if (!tc.isEventEnabled()) break block5;
                    Tr.event((TraceComponent)tc, (String)"unexpected", (Object)((Object)eJBContainerException));
                }
            }
            ApplicationMgr applicationMgr = (ApplicationMgr)this.getService(ApplicationMgr.class);
            applicationMgr.addDeployedObjectListener((DeployedObjectListener)this);
            this.releaseService(eJBContainer);
            this.releaseService(applicationMgr);
        }
        this.releaseService(server);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize", (Object)new Object[]{clusterMemberService, this.containingClusterIdentity});
        }
    }

    public void start() throws RuntimeWarning, RuntimeError {
        super.start();
        Server server = (Server)this.getService(Server.class);
        String string = server.getClusterName();
        if (string == null) {
            this.joinStandaloneCluster(cellName, server.getNodeName(), server.getName());
        }
        this.releaseService(server);
    }

    public Identity getClusterIdentity(J2EEName j2EEName) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getClusterIdentity", (Object)new Object[]{j2EEName, j2EEName.getModule()});
        }
        Identity identity = this.containingClusterIdentity;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getClusterIdentity", (Object)identity);
        }
        return identity;
    }

    public void stateChanged(DeployedObjectEvent deployedObjectEvent) throws RuntimeError, RuntimeWarning {
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"stateChanged", (Object)deployedObjectEvent);
            }
            if (deployedObjectEvent.getPropertyName().equals("state")) {
                if (deployedObjectEvent.getNewValue().equals("STARTED")) {
                    String string = deployedObjectEvent.getDeployedObject().getName();
                    Identity identity = IdentityMapping.getApplicationCluster(cellName, string);
                    try {
                        clusterMemberService.joinCluster(identity);
                        clusterMemberService.defineAttribute(string);
                    }
                    catch (NoClusterDefinedException noClusterDefinedException) {
                        FFDCFilter.processException((Throwable)noClusterDefinedException, (String)ApplicationServerRuntimeImpl.class.getName(), (String)"165", (Object)((Object)this));
                        if (tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)"unexpected exception", (Object)((Object)noClusterDefinedException));
                        }
                        break block10;
                    }
                }
                if (deployedObjectEvent.getOldValue() != null && deployedObjectEvent.getOldValue().equals("STARTED")) {
                    String string = deployedObjectEvent.getDeployedObject().getName();
                    Identity identity = IdentityMapping.getApplicationCluster(cellName, string);
                    try {
                        clusterMemberService.disjoinCluster(identity);
                        clusterMemberService.undefineAttribute(string);
                    }
                    catch (NoClusterDefinedException noClusterDefinedException) {
                        FFDCFilter.processException((Throwable)noClusterDefinedException, (String)ApplicationServerRuntimeImpl.class.getName(), (String)"176", (Object)((Object)this));
                        if (!tc.isEventEnabled()) break block10;
                        Tr.event((TraceComponent)tc, (String)"unexpected exception", (Object)((Object)noClusterDefinedException));
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stateChanged", (Object)new Object[]{deployedObjectEvent.getPropertyName(), deployedObjectEvent.getOldValue(), deployedObjectEvent.getNewValue(), deployedObjectEvent.getRuntimeState()});
        }
    }

    private void joinStandaloneCluster(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"joinStandaloneCluster", (Object)new Object[]{string, string2, string3});
        }
        try {
            Identity identity = IdentityMapping.getApplicationServerCluster(string, string2 + ":" + string3);
            clusterMemberService.joinCluster(identity);
        }
        catch (NoClusterDefinedException noClusterDefinedException) {
            FFDCFilter.processException((Throwable)noClusterDefinedException, (String)(ApplicationServerRuntimeImpl.class.getName() + ".joinSingletonCluster"), (String)"197", (Object)((Object)this), (Object[])new Object[]{string, string2, string3});
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"joinSingletonCluster", (Object)((Object)noClusterDefinedException));
            }
            Tr.error((TraceComponent)tc, (String)"NLSKEY_UNEXPECTED_EXCEPTION", (Object)new Object[]{"joinSingletonCluster", noClusterDefinedException});
        }
    }
}

