/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.OnePhaseXAResource;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.exceptions.TransactionException;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import com.ibm.ws.rsadapter.spi.WSStateManager;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class WSRdbOnePhaseXaResourceImpl
implements OnePhaseXAResource,
FFDCSelfIntrospectable {
    private final Connection ivSqlConn;
    private final WSRdbManagedConnectionImpl ivManagedConnection;
    private final WSStateManager ivStateManager;
    private final String ivDatabaseType;
    private final boolean detectMultithreadedAccess;
    private static final Class currClass = WSRdbOnePhaseXaResourceImpl.class;
    private static final TraceComponent tc = Tr.register((Class)currClass, (String)"RRA", (String)"IBMDataStoreAdapterNLS");

    public WSRdbOnePhaseXaResourceImpl(Connection connection, String string, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{AdapterUtil.toString(connection), string, wSRdbManagedConnectionImpl});
        }
        this.ivSqlConn = connection;
        this.ivManagedConnection = wSRdbManagedConnectionImpl;
        this.ivDatabaseType = string;
        this.ivStateManager = this.ivManagedConnection.stateMgr;
        this.detectMultithreadedAccess = this.ivManagedConnection.mcf.detectMultithreadedAccess;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        XAException xAException;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"commit", (Object)new Object[]{this, this.ivManagedConnection, AdapterUtil.toString(xid), bl ? "ONE PHASE" : "TWO PHASE"});
        }
        if (tc.isDebugEnabled()) {
            object = null;
            try {
                object = this.ivManagedConnection.mcf.getCorrelator(this.ivManagedConnection);
            }
            catch (SQLException sQLException) {
                Tr.debug((TraceComponent)tc, (String)"got an exception trying to get the correlator in commit, exception is: ", (Object)sQLException);
            }
            if (object != null) {
                StringBuffer stringBuffer = new StringBuffer(200);
                stringBuffer.append("Correlator: DB2, ID: ");
                stringBuffer.append((String)object);
                if (xid != null) {
                    stringBuffer.append("Transaction ID : ");
                    stringBuffer.append(xid);
                }
                stringBuffer.append(" COMMIT");
                Tr.debug((TraceComponent)tc, (String)stringBuffer.toString());
            }
        }
        if (this.detectMultithreadedAccess) {
            this.ivManagedConnection.detectMultithreadedAccess();
        }
        if (!bl) {
            object = new XAException(105);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"commit", (Object)object);
            }
            throw object;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        this.ivManagedConnection.wasLazilyEnlisted = false;
        try {
            this.ivSqlConn.commit();
            this.ivStateManager.setState(7);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.spi.WSRdbOnePhaseXaResourceImpl.commit", (String)"105", (Object)this);
            bl2 = true;
            Tr.error((TraceComponent)tc, (String)"DSA_INTERNAL_ERROR", (Object)new Object[]{"Exception caught during commit on the OnePhaseXAResource", sQLException});
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"issue a rollback due to commit failure");
                }
                this.ivSqlConn.rollback();
            }
            catch (SQLException sQLException2) {
                FFDCFilter.processException((Throwable)sQLException2, (String)"com.ibm.ws.rsadapter.spi.WSRdbOnePhaseXaResourceImpl.commit", (String)"197", (Object)this);
                bl3 = true;
                Tr.error((TraceComponent)tc, (String)"DSA_INTERNAL_ERROR", (Object)new Object[]{"Exception caught during rollback on the OnePhaseXAResource after a commit failed", sQLException2});
            }
            catch (RuntimeException runtimeException) {
                FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.rsadapter.spi.WSRdbOnePhaseXaResourceImpl.commit", (String)"204", (Object)this);
                bl3 = true;
                Tr.error((TraceComponent)tc, (String)"DSA_INTERNAL_ERROR", (Object)new Object[]{"Exception caught during rollback on the OnePhaseXAResource after a commit failed", runtimeException});
            }
        }
        catch (TransactionException transactionException) {
            FFDCFilter.processException((Throwable)((Object)transactionException), (String)"com.ibm.ws.rsadapter.spi.WSRdbOnePhaseXaResourceImpl.commit", (String)"123", (Object)this);
            Tr.error((TraceComponent)tc, (String)"INVALID_TX_STATE", (Object)new Object[]{"OnePhaseXAResource.commit()", this.ivManagedConnection.getTransactionStateAsString()});
            bl4 = false;
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.rsadapter.spi.WSRdbOnePhaseXaResourceImpl.commit", (String)"221", (Object)this);
            Tr.error((TraceComponent)tc, (String)"DSA_INTERNAL_ERROR", (Object)new Object[]{"Exception caught during commit on the OnePhaseXAResource", runtimeException});
            XAException xAException2 = new XAException(8);
            WSRdbOnePhaseXaResourceImpl.traceXAException(xAException2, currClass);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"commit", (Object)"Exception");
            }
            throw xAException2;
        }
        if (bl3) {
            xAException = new XAException(-3);
            WSRdbOnePhaseXaResourceImpl.traceXAException(xAException, currClass);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"commit", (Object)"Exception");
            }
            throw xAException;
        }
        if (bl2) {
            xAException = new XAException(8);
            WSRdbOnePhaseXaResourceImpl.traceXAException(xAException, currClass);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"commit", (Object)"Exception");
            }
            throw xAException;
        }
        if (bl4) {
            xAException = new XAException(-3);
            WSRdbOnePhaseXaResourceImpl.traceXAException(xAException, currClass);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"commit", (Object)"Exception");
            }
            throw xAException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"commit");
        }
    }

    public void end(Xid xid, int n) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"end", (Object)new Object[]{this, this.ivManagedConnection, AdapterUtil.toString(xid), AdapterUtil.getXAResourceEndFlagString(n)});
        }
        try {
            if (n == 0x20000000) {
                this.ivStateManager.setState(6);
            } else {
                this.ivStateManager.setState(5);
            }
        }
        catch (TransactionException transactionException) {
            FFDCFilter.processException((Throwable)((Object)transactionException), (String)"com.ibm.ws.rsadapter.spi.WSRdbOnePhaseXaResourceImpl.end", (String)"189", (Object)this);
            Tr.error((TraceComponent)tc, (String)"INVALID_TX_STATE", (Object)new Object[]{"OnePhaseXAResource.end()", this.ivManagedConnection.getTransactionStateAsString()});
            XAException xAException = new XAException(105);
            WSRdbOnePhaseXaResourceImpl.traceXAException(xAException, currClass);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"end", (Object)"Exception");
            }
            throw xAException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"end");
        }
    }

    public void forget(Xid xid) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"forget", (Object)AdapterUtil.toString(xid));
        }
        Tr.error((TraceComponent)tc, (String)"INVALID_TX_STATE", (Object)new Object[]{"OnePhaseXAResource.forget()", this.ivManagedConnection.getTransactionStateAsString()});
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"forget");
        }
        XAException xAException = new XAException(105);
        WSRdbOnePhaseXaResourceImpl.traceXAException(xAException, currClass);
        throw xAException;
    }

    public final String getResourceName() {
        return this.ivDatabaseType;
    }

    public int getTransactionTimeout() throws XAException {
        return -1;
    }

    public final String[] introspectSelf() {
        return this.ivManagedConnection.introspectSelf();
    }

    void introspectThisClassOnly(FFDCLogger fFDCLogger) {
        fFDCLogger.createFFDCHeader(this);
        fFDCLogger.append("Database Type:", this.ivDatabaseType);
        fFDCLogger.append("Connection:", AdapterUtil.toString(this.ivSqlConn));
        fFDCLogger.append("ManagedConnection:", this.ivManagedConnection);
        fFDCLogger.append("Detection of multithreaded access is:", this.detectMultithreadedAccess ? "ENABLED" : "DISABLED");
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        return false;
    }

    public int prepare(Xid xid) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"prepare", (Object)AdapterUtil.toString(xid));
        }
        Tr.error((TraceComponent)tc, (String)"INVALID_TX_STATE", (Object)new Object[]{"OnePhaseXAResource.prepare()", this.ivManagedConnection.getTransactionStateAsString()});
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"prepare");
        }
        XAException xAException = new XAException(105);
        WSRdbOnePhaseXaResourceImpl.traceXAException(xAException, currClass);
        throw xAException;
    }

    public Xid[] recover(int n) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recover", (Object)AdapterUtil.getXAResourceRecoverFlagString(n));
        }
        Xid[] xidArray = new Xid[]{};
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recover", (Object)xidArray);
        }
        return xidArray;
    }

    public void rollback(Xid xid) throws XAException {
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"rollback", (Object)new Object[]{this, this.ivManagedConnection, AdapterUtil.toString(xid)});
        }
        if (tc.isDebugEnabled()) {
            String string = null;
            try {
                string = this.ivManagedConnection.mcf.getCorrelator(this.ivManagedConnection);
            }
            catch (SQLException sQLException) {
                Tr.debug((TraceComponent)tc, (String)"got an exception trying to get the correlator in commit, exception is: ", (Object)sQLException);
            }
            if (string != null) {
                serializable = new StringBuffer(200);
                serializable.append("Correlator: DB2, ID: ");
                serializable.append(string);
                if (xid != null) {
                    serializable.append("Transaction ID : ");
                    serializable.append(xid);
                }
                serializable.append(" ROLLBACK");
                Tr.debug((TraceComponent)tc, (String)serializable.toString());
            }
        }
        this.ivManagedConnection.wasLazilyEnlisted = false;
        try {
            this.ivSqlConn.rollback();
            this.ivStateManager.setState(8);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.spi.WSRdbOnePhaseXaResourceImpl.rollback", (String)"342", (Object)this);
            Tr.error((TraceComponent)tc, (String)"DSA_INTERNAL_ERROR", (Object)new Object[]{"Exception caught during rollback on the OnePhaseXAResource", sQLException});
            serializable = new XAException(-3);
            WSRdbOnePhaseXaResourceImpl.traceXAException((XAException)serializable, currClass);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"rollback", (Object)"Exception");
            }
            throw serializable;
        }
        catch (TransactionException transactionException) {
            FFDCFilter.processException((Throwable)((Object)transactionException), (String)"com.ibm.ws.rsadapter.spi.WSRdbOnePhaseXaResourceImpl.rollback", (String)"351", (Object)this);
            Tr.error((TraceComponent)tc, (String)"INVALID_TX_STATE", (Object)new Object[]{"OnePhaseXAResource.rollback()", this.ivManagedConnection.getTransactionStateAsString()});
            serializable = new XAException(-3);
            WSRdbOnePhaseXaResourceImpl.traceXAException((XAException)serializable, currClass);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"rollback", (Object)"Exception");
            }
            throw serializable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"rollback");
        }
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        return false;
    }

    public void start(Xid xid, int n) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"start", (Object)new Object[]{this, this.ivManagedConnection, AdapterUtil.toString(xid), AdapterUtil.getXAResourceStartFlagString(n)});
        }
        if (this.detectMultithreadedAccess) {
            this.ivManagedConnection.detectMultithreadedAccess();
        }
        try {
            this.ivManagedConnection.setAutoCommit(false);
            this.ivStateManager.setState(4);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.spi.WSRdbOnePhaseXaResourceImpl.start", (String)"406", (Object)this);
            Tr.error((TraceComponent)tc, (String)"DSA_ERROR", (Object)new Object[]{sQLException, "com.ibm.ws.rsadapter.spi.WSRdbOnePhaseXaResourceImpl.start"});
            XAException xAException = new XAException(105);
            WSRdbOnePhaseXaResourceImpl.traceXAException(xAException, currClass);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"start", (Object)"Exception");
            }
            throw xAException;
        }
        catch (TransactionException transactionException) {
            FFDCFilter.processException((Throwable)((Object)transactionException), (String)"com.ibm.ws.rsadapter.spi.WSRdbOnePhaseXaResourceImpl.start", (String)"407", (Object)this);
            Tr.error((TraceComponent)tc, (String)"INVALID_TX_STATE", (Object)new Object[]{"OnePhaseXAResource.start()", this.ivManagedConnection.getTransactionStateAsString()});
            XAException xAException = new XAException(105);
            WSRdbOnePhaseXaResourceImpl.traceXAException(xAException, currClass);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"start", (Object)"Exception");
            }
            throw xAException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public static final XAException traceXAException(XAException xAException, Class clazz) {
        Tr.warning((TraceComponent)tc, (String)"THROW_XAEXCEPTION", (Object)new Object[]{AdapterUtil.getXAExceptionCodeString(xAException.errorCode), xAException.getMessage()});
        return xAException;
    }
}

