/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.rsadapter.CloudscapeDataStoreHelper;
import com.ibm.websphere.rsadapter.CloudscapeNetworkServerDataStoreHelper;
import com.ibm.websphere.rsadapter.ConnectJDBCDataStoreHelper;
import com.ibm.websphere.rsadapter.DB2390DataStoreHelper;
import com.ibm.websphere.rsadapter.DB2390LocalDataStoreHelper;
import com.ibm.websphere.rsadapter.DB2DataStoreHelper;
import com.ibm.websphere.rsadapter.DB2UniversalDataStoreHelper;
import com.ibm.websphere.rsadapter.DataDirectDataStoreHelper;
import com.ibm.websphere.rsadapter.DataStoreHelper;
import com.ibm.websphere.rsadapter.InformixDataStoreHelper;
import com.ibm.websphere.rsadapter.Oracle10gDataStoreHelper;
import com.ibm.websphere.rsadapter.OracleDataStoreHelper;
import com.ibm.websphere.rsadapter.SequeLinkDataStoreHelper;
import com.ibm.websphere.rsadapter.Sybase11DataStoreHelper;
import com.ibm.websphere.rsadapter.SybaseDataStoreHelper;
import com.ibm.websphere.rsadapter.WSConnectJDBCDataStoreHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.DSConfigurationHelper;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import com.ibm.ws.rsadapter.spi.DynamicDSConfigManager;
import com.ibm.ws.rsadapter.spi.InternalCloudscapeDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalCloudscapeNetworkServerDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalDB2DataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalDataDirectDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalGenericDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalInformixDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalOracle10gDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalOracleDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalSequeLinkDataStoreHelper;
import com.ibm.ws.rsadapter.spi.InternalSybaseDataStoreHelper;
import com.ibm.ws.rsadapter.spi.ParameterList;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import com.ibm.ws.security.util.AccessController;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import javax.sql.XADataSource;

public class WSRdbDataSource
implements Serializable,
FFDCSelfIntrospectable {
    private static final long serialVersionUID = -7106919037814463614L;
    private Properties dataSourceProperties = null;
    transient Object dataSource;
    WSManagedConnectionFactoryImpl mcf;
    private boolean jtaEnabled;
    private boolean wasUsedToGetAConnection;
    private String currentSQLID = null;
    transient DataStoreHelper dataStoreHelper = null;
    private final String dataSourceImplClass;
    private String dataSourceName = null;
    private String productName;
    private String driverType = null;
    transient DynamicDSConfigManager dcm;
    private transient int numConfigIDs;
    private static final Class currClass = WSRdbDataSource.class;
    private static final TraceComponent tc = Tr.register((Class)currClass, (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    private static final HashMap helperMap = new HashMap(47);

    public WSRdbDataSource(Properties properties, WSManagedConnectionFactoryImpl wSManagedConnectionFactoryImpl) throws ResourceException {
        String string;
        String string2;
        Object object;
        String string3;
        String string4;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>");
        }
        this.mcf = wSManagedConnectionFactoryImpl;
        this.dataSourceProperties = properties;
        Properties properties2 = (Properties)properties.clone();
        Properties properties3 = new Properties();
        this.dataSourceImplClass = (String)properties2.remove("dataSourceClass");
        if (this.dataSourceImplClass == null) {
            throw new DataStoreAdapterException("DSIMPLCLASS_NULL", "DataSource implementation class is null.  Could not create DataSource", currClass);
        }
        String string5 = (String)properties2.remove("informixLockModeWait");
        if (string5 != null) {
            properties3.setProperty("informixLockModeWait", string5);
        }
        if ((string4 = (String)properties2.remove("informixAllowNewLine")) != null) {
            properties3.setProperty("informixAllowNewLine", string4);
        }
        if ((string3 = (String)properties2.remove("databaseType")) != null) {
            properties3.setProperty("databaseType", string3);
            wSManagedConnectionFactoryImpl.setDatabaseType(string3);
        }
        boolean bl = wSManagedConnectionFactoryImpl.disableBackendIdchecking = (object = properties2.remove("disableBackendIdChecking")) != null && new Boolean((String)object) != false;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"disableBackendIdchecking is: ", (Object)new Boolean(wSManagedConnectionFactoryImpl.disableBackendIdchecking));
        }
        String string6 = (String)properties2.remove("dataStoreHelperClass");
        String string7 = (String)properties2.remove("statementCacheSize");
        Object object2 = properties2.remove("enableMultithreadedAccessDetection");
        wSManagedConnectionFactoryImpl.detectMultithreadedAccess = object2 != null && new Boolean((String)object2) != false;
        object2 = properties2.remove("enableSQLJ");
        String string8 = (String)properties2.remove("oracleLogFileSizeLimit");
        if (string8 != null) {
            properties3.setProperty("oracleLogFileSizeLimit", string8);
        }
        if ((string8 = (String)properties2.remove("oracleLogFileCount")) != null) {
            properties3.setProperty("oracleLogFileCount", string8);
        }
        if ((string8 = (String)properties2.remove("oracleLogFileName")) != null) {
            properties3.setProperty("oracleLogFileName", string8);
        }
        if ((string8 = (String)properties2.remove("oracleLogTraceLevel")) != null) {
            properties3.setProperty("oracleLogTraceLevel", string8);
        }
        if ((string8 = (String)properties2.remove("oracle9iLogTraceLevel")) != null) {
            properties3.setProperty("oracle9iLogTraceLevel", string8);
        }
        if ((string8 = (String)properties2.remove("oracleLogPackageName")) != null) {
            properties3.setProperty("oracleLogPackageName", string8);
        }
        if ((string8 = (String)properties2.remove("oracleLogFormat")) != null) {
            properties3.setProperty("oracleLogFormat", string8);
        }
        wSManagedConnectionFactoryImpl.disableWASConnectionPooling = (object2 = properties2.remove("disableWASConnectionPooling")) != null && new Boolean((String)object2) != false;
        string8 = (String)properties2.remove("webSphereDefaultIsolationLevel");
        if (string8 != null) {
            properties3.setProperty("webSphereDefaultIsolationLevel", string8);
        }
        if ((string8 = properties2.getProperty("traceLevel")) != null) {
            properties3.setProperty("traceLevel", string8);
        }
        boolean bl2 = wSManagedConnectionFactoryImpl.transactionBranchesLooselyCoupled = (object2 = properties2.remove("transactionBranchesLooselyCoupled")) != null && new Boolean((String)object2) != false;
        if (wSManagedConnectionFactoryImpl.transactionBranchesLooselyCoupled) {
            Tr.warning((TraceComponent)tc, (String)"ORACLE_PATCH_WARNING");
        }
        wSManagedConnectionFactoryImpl.resetConnectionByBackendDatabase = (object2 = properties2.remove("resetConnectionByBackendDatabase")) != null && new Boolean((String)object2) != false;
        String string9 = properties2.getProperty("traceFile");
        if (string9 != null) {
            properties3.setProperty("traceFile", string9);
        }
        wSManagedConnectionFactoryImpl.preTestSQLString = (String)properties2.remove("preTestSQLString");
        object2 = properties2.remove("validateAfterConnectionError");
        wSManagedConnectionFactoryImpl.validateAfterConnectionError = object2 == null || new Boolean((String)object2) != false;
        object2 = properties2.remove("jmsOnePhaseOptimization");
        if (object2 != null) {
            wSManagedConnectionFactoryImpl.jmsOnePhaseOptimization = new Boolean((String)object2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"The sharedDataSourceWithCMP DS custom property value is:", (Object)new Boolean(wSManagedConnectionFactoryImpl.jmsOnePhaseOptimization));
        }
        if ((string2 = (String)properties2.remove("reauthentication")) != null) {
            wSManagedConnectionFactoryImpl.reauthEnabled = new Boolean(string2);
            properties3.setProperty("reauthentication", string2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"The Reauthentication DS custom property value is:", (Object)new Boolean(wSManagedConnectionFactoryImpl.reauthEnabled));
        }
        if ((string8 = (String)properties2.remove("dbFailOverEnabled")) != null) {
            wSManagedConnectionFactoryImpl.dbFailOverEnabled = new Boolean(string8);
        }
        if ((string8 = (String)properties2.remove("connRetriesDuringDBFailover")) != null) {
            wSManagedConnectionFactoryImpl.connectionRetriesDuringDBFailover = new Integer(string8);
        }
        if ((string8 = (String)properties2.remove("connRetryIntervalDuringDBFailover")) != null) {
            wSManagedConnectionFactoryImpl.connRetryDurationDuringDBFailover = new Long(string8);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"DB_FAILOVER_ENABLED", (Object)new Boolean(wSManagedConnectionFactoryImpl.dbFailOverEnabled));
            Tr.debug((TraceComponent)tc, (String)"DB_FAILOVER_CONNECTION_RETRY_INTERVAL", (Object)new Long(wSManagedConnectionFactoryImpl.connRetryDurationDuringDBFailover));
            Tr.debug((TraceComponent)tc, (String)"DB_FAILOVER_CONNECTION_RETRY_COUNT", (Object)new Integer(wSManagedConnectionFactoryImpl.connectionRetriesDuringDBFailover));
        }
        if ((string = (String)properties2.remove("isolationLevelSwitchingSupport")) != null) {
            properties3.setProperty("isolationLevelSwitchingSupport", string);
        }
        String string10 = null;
        if (properties2.containsKey("currentSQLID")) {
            string10 = properties2.getProperty("currentSQLID");
        }
        if (string10 != null && string10.trim().length() > 0) {
            PropertyDescriptor[] propertyDescriptorArray = null;
            try {
                final Class<?> clazz = Class.forName(this.dataSourceImplClass);
                propertyDescriptorArray = (PropertyDescriptor[])AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return Introspector.getBeanInfo(clazz).getPropertyDescriptors();
                    }
                });
                boolean bl3 = false;
                for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                    if (!propertyDescriptorArray[i].getName().equals("currentSQLID")) continue;
                    bl3 = true;
                    break;
                }
                if (!bl3) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Setting currentSQLID on DataSource to: " + string10));
                    }
                    this.currentSQLID = string10;
                    properties2.remove("currentSQLID");
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"currentSQLID will be passed to physical DS");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, (String)this.getClass().getName(), (String)"420", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"<init> with exception: ", (Object)classNotFoundException);
                }
                throw AdapterUtil.createDataStoreAdapterException("DS_CLASS_NOT_FOUND", this.dataSourceImplClass, classNotFoundException, WSRdbDataSource.class);
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"<init> with exception:", (Object)exception);
                }
                throw (ResourceException)((Object)exception);
            }
        }
        if (this.currentSQLID != null) {
            properties3.setProperty("currentSQLID", this.currentSQLID);
        }
        this.driverType = properties2.getProperty("driverType");
        if (this.driverType != null) {
            properties3.setProperty("driverType", this.driverType);
        }
        if (string6 == null) {
            string6 = DSConfigurationHelper.getDataStoreHelperClassName(this.dataSourceImplClass, this.driverType);
        }
        if (string6 == null) {
            string6 = DSConfigurationHelper.getDataStoreHelperClassName(this.dataSourceImplClass);
        }
        properties3.setProperty("dataSourceClass", this.dataSourceImplClass);
        this.dataStoreHelper = DSConfigurationHelper.createDataStoreHelper(string6, properties3);
        int n = this.dataStoreHelper.getMetaData().getHelperType();
        if (string7 != null) {
            wSManagedConnectionFactoryImpl.setStatementCacheSize(Integer.parseInt(string7));
        }
        wSManagedConnectionFactoryImpl.internalHelper = this.createInternalDataStoreHelper(string6);
        wSManagedConnectionFactoryImpl.internalHelper.setExternalHelper(this.dataStoreHelper);
        wSManagedConnectionFactoryImpl.internalHelper.setProperties(properties3);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(AdapterUtil.EOLN + "Database type:                          " + string3 + AdapterUtil.EOLN + "DataSource class:                       " + this.dataSourceImplClass + AdapterUtil.EOLN + "DataStoreHelper class:                  " + string6 + AdapterUtil.EOLN + "InternalDataStoreHelper class:          " + wSManagedConnectionFactoryImpl.internalHelper + AdapterUtil.EOLN + "Multithreaded access detection enabled? " + wSManagedConnectionFactoryImpl.detectMultithreadedAccess));
        }
        properties2 = wSManagedConnectionFactoryImpl.internalHelper.validateConfiguration(properties2, this.dataSourceImplClass);
        this.dataSource = this.createNewDataSource(properties2);
        this.jtaEnabled = DSConfigurationHelper.is2PhaseEnabled(properties2, this.dataSource);
        if (this.jtaEnabled && wSManagedConnectionFactoryImpl.jmsOnePhaseOptimization) {
            throw new DataStoreAdapterException("INVALID_DS_CONFIGURATION", "INVALID_DS_CONFIGURATION", currClass);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    synchronized int configure(String string, Object[] objectArray, Class[] classArray, int n) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"configure", (Object)new Object[]{string, string.equals("setPassword") ? "******" : WSRdbDataSource.toString(objectArray), WSRdbDataSource.toString(classArray), new Integer(n)});
        }
        this.dcm = this.dcm == null ? new DynamicDSConfigManager(this.dataSource) : this.dcm;
        HashMap<String, ParameterList> hashMap = new HashMap<String, ParameterList>(this.dcm.getConfigMethods(n));
        hashMap.put(string, new ParameterList(classArray, objectArray));
        int n2 = this.dcm.getConfigID(hashMap);
        if (n2 < 0) {
            try {
                Object object = this.createNewDataSource((Properties)this.dataSourceProperties.clone());
                DynamicDSConfigManager.applyConfiguration(object, hashMap);
                n2 = ++this.numConfigIDs;
                this.dcm.add(n2, hashMap, object);
            }
            catch (ResourceException resourceException) {
                FFDCFilter.processException((Throwable)resourceException, (String)(this.getClass().getName() + ".configure"), (String)"462", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"configure", (Object)((Object)resourceException));
                }
                throw AdapterUtil.toSQLException(resourceException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"configure", (Object)new Integer(n2));
        }
        return n2;
    }

    private InternalDataStoreHelper createInternalDataStoreHelper(String string) throws ResourceException {
        Object object = helperMap.get(string);
        try {
            block27: {
                if (object == null) {
                    object = helperMap.get(this.dataSourceImplClass);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"searching on the dataSourceImplClass returned: ", object);
                    }
                    if (object == null) {
                        int n = this.dataStoreHelper.getMetaData().getHelperType();
                        switch (n) {
                            case 1: 
                            case 3: 
                            case 15: {
                                return new InternalDB2DataStoreHelper();
                            }
                            case 4: {
                                return new InternalDB2UniversalDataStoreHelper();
                            }
                            case 0: 
                            case 19: {
                                return new InternalCloudscapeDataStoreHelper();
                            }
                            case 11: 
                            case 12: {
                                return new InternalSybaseDataStoreHelper();
                            }
                            case 14: {
                                return new InternalInformixDataStoreHelper();
                            }
                            case 5: 
                            case 10: {
                                return new InternalGenericDataStoreHelper();
                            }
                            case 6: 
                            case 7: 
                            case 8: {
                                return new InternalDataDirectDataStoreHelper();
                            }
                            case 9: {
                                return new InternalSequeLinkDataStoreHelper();
                            }
                            case 13: {
                                return new InternalOracleDataStoreHelper();
                            }
                            case 17: {
                                return new InternalOracle10gDataStoreHelper();
                            }
                            case 16: 
                            case 18: {
                                return new InternalCloudscapeNetworkServerDataStoreHelper();
                            }
                            case -1: {
                                return this.getInternalHelperBasedOnInstance();
                            }
                            case 2: {
                                break;
                            }
                            default: {
                                return new InternalGenericDataStoreHelper();
                            }
                        }
                    }
                }
                if (object.equals("com.ibm.ws.rsadapter.spi.InternalDB2DataStoreHelper")) {
                    try {
                        Class<?> clazz = Class.forName("com.ibm.db2.jcc.SQLJContext");
                        object = "com.ibm.ws.rsadapter.spi.InternalDB2V8SQLJDataStoreHelper";
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"SQLJContext is implemented by DB2, change to InternalDB2V8SQLJDataStoreHelper  ", object);
                        }
                        clazz = null;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        try {
                            Class<?> clazz = Class.forName("com.ibm.db2.jcc.SQLJConnection");
                            object = "com.ibm.ws.rsadapter.spi.InternalDB2V8DataStoreHelper";
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"SQLJConnection is implemented by DB2, change to InternalDB2V8DataStoreHelper  ", object);
                            }
                            clazz = null;
                        }
                        catch (ClassNotFoundException classNotFoundException2) {
                            if (!tc.isDebugEnabled()) break block27;
                            Tr.debug((TraceComponent)tc, (String)"SQLJConnection or SQLJContext is not implemented by DB2");
                        }
                    }
                }
            }
            return (InternalDataStoreHelper)DSConfigurationHelper.loadClass((String)object).newInstance();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)(this.getClass().getName() + ".createInternalDataStoreHelper"), (String)"276", (Object)this);
            throw AdapterUtil.createDataStoreAdapterException("DSA_INTERNAL_ERROR", new Object[]{"Unable to locate Internal Data Store Helper for " + string, ".  Exception is: ", exception}, exception, this.getClass());
        }
    }

    private final InternalDataStoreHelper getInternalHelperBasedOnInstance() {
        if (this.dataStoreHelper instanceof DB2390LocalDataStoreHelper) {
            return new InternalDB2DataStoreHelper();
        }
        if (this.dataStoreHelper instanceof WSConnectJDBCDataStoreHelper) {
            return new InternalDataDirectDataStoreHelper();
        }
        if (this.dataStoreHelper instanceof DB2UniversalDataStoreHelper) {
            return new InternalDB2UniversalDataStoreHelper();
        }
        if (this.dataStoreHelper instanceof DB2390DataStoreHelper) {
            return new InternalDB2DataStoreHelper();
        }
        if (this.dataStoreHelper instanceof ConnectJDBCDataStoreHelper) {
            return new InternalDataDirectDataStoreHelper();
        }
        if (this.dataStoreHelper instanceof CloudscapeNetworkServerDataStoreHelper) {
            return new InternalCloudscapeNetworkServerDataStoreHelper();
        }
        if (this.dataStoreHelper instanceof SequeLinkDataStoreHelper) {
            return new InternalSequeLinkDataStoreHelper();
        }
        if (this.dataStoreHelper instanceof DB2DataStoreHelper) {
            return new InternalDB2DataStoreHelper();
        }
        if (this.dataStoreHelper instanceof Oracle10gDataStoreHelper) {
            return new InternalOracle10gDataStoreHelper();
        }
        if (this.dataStoreHelper instanceof OracleDataStoreHelper) {
            return new InternalOracleDataStoreHelper();
        }
        if (this.dataStoreHelper instanceof DataDirectDataStoreHelper) {
            return new InternalDataDirectDataStoreHelper();
        }
        if (this.dataStoreHelper instanceof CloudscapeDataStoreHelper) {
            return new InternalCloudscapeDataStoreHelper();
        }
        if (this.dataStoreHelper instanceof InformixDataStoreHelper) {
            return new InternalInformixDataStoreHelper();
        }
        if (this.dataStoreHelper instanceof Sybase11DataStoreHelper) {
            return new InternalSybaseDataStoreHelper();
        }
        if (this.dataStoreHelper instanceof SybaseDataStoreHelper) {
            return new InternalSybaseDataStoreHelper();
        }
        return new InternalGenericDataStoreHelper();
    }

    public final PooledConnection getPooledConnection(String string, String string2, int n) throws ResourceException {
        PooledConnection pooledConnection = null;
        try {
            pooledConnection = DSConfigurationHelper.getPooledConnection(n == 0 ? this.dataSource : this.dcm.getDataSource(n), string, string2, this.jtaEnabled);
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, (String)(this.getClass().getName() + ".getPooledConnection"), (String)"903", (Object)this);
            throw AdapterUtil.createDataStoreAdapterException("JAVAX_CONN_ERR", this.jtaEnabled ? "XAConnection" : "PooledConnection", resourceException.getCause() == null ? null : this.dataStoreHelper.mapException((SQLException)resourceException.getCause()), WSRdbDataSource.class);
        }
        return pooledConnection;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"equals", (Object)new Object[]{this, object});
        }
        try {
            WSRdbDataSource wSRdbDataSource = (WSRdbDataSource)object;
            bl = this.numConfigIDs + wSRdbDataSource.numConfigIDs == 0 || this.numConfigIDs == wSRdbDataSource.numConfigIDs && AdapterUtil.match(this.dcm, wSRdbDataSource.dcm);
        }
        catch (Throwable throwable) {
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"equals", (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
        }
        return bl;
    }

    boolean equals(WSRdbDataSource wSRdbDataSource, int n, int n2) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"equals", (Object)new Object[]{"Configuration #" + n + " of " + this, "Configuration #" + n2 + " of " + wSRdbDataSource});
        }
        boolean bl2 = bl = this.dcm == null && wSRdbDataSource.dcm == null || AdapterUtil.match(this.dcm.getConfigMethods(n), wSRdbDataSource.dcm.getConfigMethods(n2));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"equals", (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
        }
        return bl;
    }

    public Connection getConnection(PooledConnection pooledConnection) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getConnection", (Object)AdapterUtil.toString(pooledConnection));
        }
        try {
            Connection connection = pooledConnection.getConnection();
            this.dataStoreHelper.doConnectionSetup(connection);
            if (!this.wasUsedToGetAConnection) {
                this.wasUsedToGetAConnection = true;
                this.mcf.internalHelper.gatherAndDisplayMetaDataInfo(connection, this);
                if (this.driverType != null) {
                    Tr.info((TraceComponent)tc, (String)"JDBC_DRIVER_TYPE", (Object)this.driverType);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getConnection", (Object)AdapterUtil.toString(connection));
            }
            return connection;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.spi.WSRdbDataSource.getConnection", (String)"260", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getConnection - throwing exception");
            }
            throw this.translateSQLException(sQLException);
        }
    }

    public final PrintWriter getLogWriter() throws ResourceException {
        try {
            if (this.jtaEnabled) {
                return ((XADataSource)this.dataSource).getLogWriter();
            }
            return ((ConnectionPoolDataSource)this.dataSource).getLogWriter();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.spi.WSRdbDataSource.getLogWriter", (String)"293", (Object)this);
            throw this.translateSQLException(sQLException);
        }
    }

    public PrintWriter getLogWriter(int n) throws SQLException {
        Object object = n == 0 ? this.dataSource : this.dcm.getDataSource(n);
        try {
            return this.jtaEnabled ? ((XADataSource)object).getLogWriter() : ((ConnectionPoolDataSource)object).getLogWriter();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)(this.getClass().getName() + ".getLogWriter"), (String)"621", (Object)this);
            throw this.dataStoreHelper.mapException(sQLException);
        }
    }

    public int getLoginTimeout(int n) throws SQLException {
        Object object = n == 0 ? this.dataSource : this.dcm.getDataSource(n);
        try {
            return this.jtaEnabled ? ((XADataSource)object).getLoginTimeout() : ((ConnectionPoolDataSource)object).getLoginTimeout();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)(this.getClass().getName() + ".getLoginTimeout"), (String)"665", (Object)this);
            throw this.dataStoreHelper.mapException(sQLException);
        }
    }

    public final Properties getDataSourceProperties() {
        return this.dataSourceProperties;
    }

    public String[] introspectSelf() {
        FFDCLogger fFDCLogger = new FFDCLogger(900, this);
        fFDCLogger.append("DataSource Implementation Class Name:", this.dataSourceImplClass);
        fFDCLogger.append("DataSource Name:", this.dataSourceName);
        fFDCLogger.append("DataStoreHelper:", this.dataStoreHelper);
        fFDCLogger.append("DataSource properties:", AdapterUtil.hidePassword(this.dataSourceProperties));
        fFDCLogger.append(this.jtaEnabled ? "TWO PHASE ENABLED" : "ONE PHASE ENABLED");
        fFDCLogger.append("Underlying DataSource Object: " + AdapterUtil.toString(this.dataSource), this.dataSource);
        fFDCLogger.append("Counter of unique, modified DataSource configurations: " + this.numConfigIDs);
        fFDCLogger.introspect("DynamicDSConfigManager", this.dcm);
        return fFDCLogger.toStringArray();
    }

    public final void setLogWriter(PrintWriter printWriter) throws ResourceException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setting the logWriter to:", (Object)printWriter);
        }
        try {
            if (this.jtaEnabled) {
                ((XADataSource)this.dataSource).setLogWriter(printWriter);
            } else {
                ((ConnectionPoolDataSource)this.dataSource).setLogWriter(printWriter);
            }
            this.mcf.logWriter = printWriter;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.spi.WSRdbDataSource.setLogWriter", (String)"367", (Object)this);
            throw this.translateSQLException(sQLException);
        }
    }

    public final boolean isJTAEnabled() {
        return this.jtaEnabled;
    }

    public Object[] call(String string, Object[] objectArray, Class[] classArray, int n) throws SQLException {
        return this.call(string, objectArray, classArray, n, null);
    }

    public Object[] call(String string, Object[] objectArray, Class[] classArray, int n, String string2) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"call", (Object)new Object[]{string, string.equals("setPassword") ? "******" : WSRdbDataSource.toString(objectArray), WSRdbDataSource.toString(classArray), new Integer(n), string2});
        }
        Object[] objectArray2 = new Object[2];
        if (string.startsWith("set") && objectArray != null && objectArray.length == 1 && classArray != null && classArray.length == 1) {
            objectArray2[1] = new Integer(this.configure(string, objectArray, classArray, n));
        } else {
            Object object = n == 0 ? this.dataSource : this.dcm.getDataSource(n);
            objectArray2[0] = WSJdbcUtil.call(object, string, objectArray, classArray, this.dataStoreHelper, string2);
            objectArray2[1] = new Integer(n);
        }
        if (tc.isEntryEnabled()) {
            Object[] objectArray3;
            if (string.equals("getPassword")) {
                Object[] objectArray4 = new Object[2];
                objectArray4[0] = "******";
                objectArray3 = objectArray4;
                objectArray4[1] = objectArray2[1];
            } else {
                objectArray3 = objectArray2;
            }
            Tr.exit((TraceComponent)tc, (String)"call", (Object)objectArray3);
        }
        return objectArray2;
    }

    private final DataStoreAdapterException translateSQLException(SQLException sQLException) {
        DataStoreAdapterException dataStoreAdapterException = new DataStoreAdapterException("DSA_ERROR", sQLException, currClass);
        return this.mcf.getInternalDataStoreHelper().mapException(dataStoreAdapterException);
    }

    public final String getDataSourceName() {
        return this.dataSourceName;
    }

    private Object createNewDataSource(final Properties properties) throws ResourceException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createNewDataSource", (Object)new Object[]{this.dataSourceImplClass, AdapterUtil.hidePassword(properties)});
        }
        try {
            object = AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Object object = DSConfigurationHelper.createDataSource(WSRdbDataSource.this.dataSourceImplClass);
                    DSConfigurationHelper.setDataSourceProperties(object, properties);
                    return object;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.rsadapter.spi.WSRdbDataSource.WSRdbDataSource", (String)"532", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createNewDataSource", (Object)privilegedActionException.getException());
            }
            throw (ResourceException)((Object)privilegedActionException.getException());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createNewDataSource", (Object)object);
        }
        return object;
    }

    Object setUserName(String string) {
        String string2 = "setUser";
        Method method = null;
        try {
            method = this.dataSource.getClass().getMethod(string2, String.class);
            method.invoke(this.dataSource, string);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Tr.warning((TraceComponent)tc, (String)"PROP_NOT_FOUND", (Object)new Object[]{this.dataSource.getClass().getName(), "user"});
        }
        catch (IllegalAccessException illegalAccessException) {
            Tr.warning((TraceComponent)tc, (String)"PROP_SET_ERROR", (Object)new Object[]{this.dataSource.getClass().getName(), "user", illegalAccessException});
        }
        catch (InvocationTargetException invocationTargetException) {
            Tr.warning((TraceComponent)tc, (String)"PROP_SET_ERROR", (Object)new Object[]{this.dataSource.getClass().getName(), "user", invocationTargetException});
        }
        return this.dataSourceProperties.setProperty("user", string);
    }

    Object setPassword(String string) {
        String string2 = "setPassword";
        Method method = null;
        try {
            method = this.dataSource.getClass().getMethod(string2, String.class);
            method.invoke(this.dataSource, string);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Tr.warning((TraceComponent)tc, (String)"PROP_NOT_FOUND", (Object)new Object[]{this.dataSource.getClass().getName(), "password"});
        }
        catch (IllegalAccessException illegalAccessException) {
            Tr.warning((TraceComponent)tc, (String)"PROP_SET_ERROR", (Object)new Object[]{this.dataSource.getClass().getName(), "password", illegalAccessException});
        }
        catch (InvocationTargetException invocationTargetException) {
            Tr.warning((TraceComponent)tc, (String)"PROP_SET_ERROR", (Object)new Object[]{this.dataSource.getClass().getName(), "password", invocationTargetException});
        }
        return this.dataSourceProperties.setProperty("password", string);
    }

    private static String toString(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer("{ ");
        if (objectArray != null && objectArray.length > 0) {
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append(objectArray[i]).append(", ");
            }
            stringBuffer.deleteCharAt(stringBuffer.length() - 2);
        }
        return new String(stringBuffer.append("}"));
    }

    static {
        helperMap.put("com.ibm.websphere.rsadapter.DB2UniversalDataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalDB2UniversalDataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.DB2DataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalDB2DataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.DB2390DataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalDB2DataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.DB2390LocalDataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalDB2DataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.DataDirectDataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalDataDirectDataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.CloudscapeNetworkServerDataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalCloudscapeNetworkServerDataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.DerbyDataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalCloudscapeDataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.DerbyNetworkServerDataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalCloudscapeNetworkServerDataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.CloudscapeDataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalCloudscapeDataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.InformixDataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalInformixDataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.SybaseDataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalSybaseDataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.OracleDataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalOracleDataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.Oracle10gDataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalOracle10gDataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.ConnectJDBCDataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalDataDirectDataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.SequeLinkDataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalSequeLinkDataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.WSConnectJDBCDataStoreHelper", "com.ibm.ws.rsadapter.spi.InternalDataDirectDataStoreHelper");
        helperMap.put("com.ibm.db2.jdbc.app.DB2StdConnectionPoolDataSource", "com.ibm.ws.rsadapter.spi.InternalDB2AS400NativeDataStoreHelper");
        helperMap.put("com.ibm.db2.jdbc.app.DB2StdXADataSource", "com.ibm.ws.rsadapter.spi.InternalDB2AS400NativeDataStoreHelper");
        helperMap.put("com.ibm.db2.jdbc.app.UDBConnectionPoolDataSource", "com.ibm.ws.rsadapter.spi.InternalDB2AS400NativeDataStoreHelper");
        helperMap.put("com.ibm.db2.jdbc.app.UDBXADataSource", "com.ibm.ws.rsadapter.spi.InternalDB2AS400NativeDataStoreHelper");
        helperMap.put("com.ibm.as400.access.AS400JDBCConnectionPoolDataSource", "com.ibm.ws.rsadapter.spi.InternalDB2AS400ToolboxDataStoreHelper");
        helperMap.put("com.ibm.as400.access.AS400JDBCXADataSource", "com.ibm.ws.rsadapter.spi.InternalDB2AS400ToolboxDataStoreHelper");
        helperMap.put("com.ibm.websphere.rsadapter.ProxyDataSource", "com.ibm.ws.rsadapter.spi.InternalGenericDataStoreHelper");
    }
}

