/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.FFDCLogger;
import java.sql.Connection;
import java.util.Map;
import javax.resource.spi.ConnectionRequestInfo;

public class WSConnectionRequestInfoImpl
implements ConnectionRequestInfo,
Cloneable,
FFDCSelfIntrospectable {
    private static final TraceComponent tc = Tr.register((Class)WSConnectionRequestInfoImpl.class, (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    private static final int NUM_CRI_PROPERTIES = 8;
    String ivUserName;
    String ivPassword;
    int ivIsoLevel;
    String ivCatalog;
    Boolean ivReadOnly;
    Map ivTypeMap;
    int ivHoldability;
    int ivConfigID;
    boolean ivNoEnlist;
    boolean ivShareWithCMPOnly;
    private int hashcode;
    private boolean hasIsolationLevelOnly;
    boolean isJDBC;
    boolean supportIsolvlSwitching;

    WSConnectionRequestInfoImpl() {
        this.ivIsoLevel = 2;
        this.hashcode = 2;
    }

    public WSConnectionRequestInfoImpl(int n, boolean bl) {
        this.hashcode = this.ivIsoLevel = n;
        this.isJDBC = bl;
        this.hasIsolationLevelOnly = true;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ConnectionRequestInfo created", (Object)this);
        }
    }

    public WSConnectionRequestInfoImpl(int n, boolean bl, boolean bl2, boolean bl3) {
        this.ivIsoLevel = n;
        this.isJDBC = bl;
        this.supportIsolvlSwitching = bl2;
        this.ivShareWithCMPOnly = bl3;
        this.hashcode = (bl3 ? 71 : 0) + n;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ConnectionRequestInfo created", (Object)this);
        }
    }

    public WSConnectionRequestInfoImpl(String string, String string2, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        this.ivUserName = string;
        this.ivPassword = string2;
        this.ivIsoLevel = n;
        this.ivConfigID = n2;
        this.isJDBC = true;
        this.ivNoEnlist = bl;
        this.supportIsolvlSwitching = bl2;
        this.ivShareWithCMPOnly = bl3;
        this.hashcode = this.ivIsoLevel + this.ivConfigID + (bl ? 37 : 0) + (bl3 ? 71 : 0) + (this.ivUserName == null ? 0 : this.ivUserName.hashCode() / 8) + (this.ivPassword == null ? 0 : this.ivPassword.hashCode() / 8);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ConnectionRequestInfo created", (Object)this);
        }
    }

    public WSConnectionRequestInfoImpl(String string, String string2, int n, String string3, Boolean bl, Map map, int n2, int n3, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.ivUserName = string;
        this.ivPassword = string2;
        this.ivIsoLevel = n;
        this.ivCatalog = string3;
        this.ivReadOnly = bl;
        this.ivTypeMap = map;
        this.ivHoldability = n2;
        this.ivConfigID = n3;
        this.isJDBC = bl2;
        this.ivNoEnlist = bl4;
        this.ivShareWithCMPOnly = bl5;
        this.supportIsolvlSwitching = bl3;
        this.hashcode = this.ivIsoLevel + this.ivConfigID + (bl4 ? 37 : 0) + (bl5 ? 71 : 0) + (this.ivUserName == null ? 0 : this.ivUserName.hashCode() / 8) + (this.ivPassword == null ? 0 : this.ivPassword.hashCode() / 8) + (this.ivCatalog == null ? 0 : this.ivCatalog.hashCode() / 8) + (this.ivReadOnly == null ? 0 : this.ivReadOnly.hashCode() / 8) + (this.ivTypeMap == null ? 0 : ((Object)this.ivTypeMap).hashCode() / 8) + this.ivHoldability * 5;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ConnectionRequestInfo created", (Object)this);
        }
    }

    public final int getConfigID() {
        return this.ivConfigID;
    }

    public final String getUserName() {
        return this.ivUserName;
    }

    public final String getPassword() {
        return this.ivPassword;
    }

    public final int getIsolationLevel() {
        return this.ivIsoLevel;
    }

    public final String getCatalog() {
        return this.ivCatalog;
    }

    public final Map getTypeMap() {
        return this.ivTypeMap;
    }

    public final int getHoldability() {
        return this.ivHoldability;
    }

    public String[] introspectSelf() {
        FFDCLogger fFDCLogger = new FFDCLogger(this);
        fFDCLogger.append("User Name:", this.ivUserName);
        fFDCLogger.append("Password:", this.ivPassword == null ? null : "******");
        fFDCLogger.append("Isolation Level:", AdapterUtil.getIsolationLevelString(this.ivIsoLevel));
        fFDCLogger.append("Catalog:", this.ivCatalog);
        fFDCLogger.append("Is Read Only?", this.ivReadOnly);
        fFDCLogger.append("Type Map:", this.ivTypeMap);
        fFDCLogger.append("Cursor Holdability:", AdapterUtil.getCursorHoldabilityString(this.ivHoldability));
        fFDCLogger.append("Config ID: " + this.ivConfigID);
        fFDCLogger.append("Hash Code:", Integer.toHexString(this.hashcode));
        fFDCLogger.append("Support isolation switching on connection:", new Boolean(this.supportIsolvlSwitching));
        fFDCLogger.append(" NoEnlistment: ", new Boolean(this.ivNoEnlist));
        fFDCLogger.append(" ShareWithCMPOnly: ", new Boolean(this.ivShareWithCMPOnly));
        fFDCLogger.append("Handle type:", this.isJDBC ? Connection.class.getName() : javax.resource.cci.Connection.class.getName());
        return fFDCLogger.toStringArray();
    }

    public final boolean isJDBCHandle() {
        return this.isJDBC;
    }

    public final Boolean isReadOnly() {
        return this.ivReadOnly;
    }

    public final boolean isReconfigurable(WSConnectionRequestInfoImpl wSConnectionRequestInfoImpl, boolean bl) {
        if (bl) {
            return this.ivConfigID == wSConnectionRequestInfoImpl.ivConfigID && this.ivNoEnlist == wSConnectionRequestInfoImpl.ivNoEnlist && this.ivShareWithCMPOnly == wSConnectionRequestInfoImpl.ivShareWithCMPOnly;
        }
        return WSConnectionRequestInfoImpl.match(this.ivUserName, wSConnectionRequestInfoImpl.ivUserName) && WSConnectionRequestInfoImpl.match(this.ivPassword, wSConnectionRequestInfoImpl.ivPassword) && this.ivConfigID == wSConnectionRequestInfoImpl.ivConfigID && this.ivNoEnlist == wSConnectionRequestInfoImpl.ivNoEnlist && this.ivShareWithCMPOnly == wSConnectionRequestInfoImpl.ivShareWithCMPOnly;
    }

    public final boolean equals(Object object) {
        boolean bl;
        if (object == this) {
            bl = true;
        } else {
            try {
                WSConnectionRequestInfoImpl wSConnectionRequestInfoImpl = (WSConnectionRequestInfoImpl)object;
                bl = this.supportIsolvlSwitching ? (!this.isJDBC && !wSConnectionRequestInfoImpl.isJDBC ? this.hasIsolationLevelOnly && wSConnectionRequestInfoImpl.hasIsolationLevelOnly || WSConnectionRequestInfoImpl.match(this.ivUserName, wSConnectionRequestInfoImpl.ivUserName) && WSConnectionRequestInfoImpl.match(this.ivPassword, wSConnectionRequestInfoImpl.ivPassword) : this.hasIsolationLevelOnly && wSConnectionRequestInfoImpl.hasIsolationLevelOnly || this.ivNoEnlist == wSConnectionRequestInfoImpl.ivNoEnlist && this.ivShareWithCMPOnly == wSConnectionRequestInfoImpl.ivShareWithCMPOnly && WSConnectionRequestInfoImpl.match(this.ivUserName, wSConnectionRequestInfoImpl.ivUserName) && WSConnectionRequestInfoImpl.match(this.ivPassword, wSConnectionRequestInfoImpl.ivPassword) && this.ivHoldability == wSConnectionRequestInfoImpl.ivHoldability && WSConnectionRequestInfoImpl.match(this.ivCatalog, wSConnectionRequestInfoImpl.ivCatalog) && WSConnectionRequestInfoImpl.match(this.ivReadOnly, wSConnectionRequestInfoImpl.ivReadOnly) && WSConnectionRequestInfoImpl.match(this.ivTypeMap, wSConnectionRequestInfoImpl.ivTypeMap) && this.ivConfigID == wSConnectionRequestInfoImpl.ivConfigID) : this.ivIsoLevel == wSConnectionRequestInfoImpl.ivIsoLevel && (this.hasIsolationLevelOnly && wSConnectionRequestInfoImpl.hasIsolationLevelOnly || this.hashcode == wSConnectionRequestInfoImpl.hashcode && this.ivNoEnlist == wSConnectionRequestInfoImpl.ivNoEnlist && this.ivShareWithCMPOnly == wSConnectionRequestInfoImpl.ivShareWithCMPOnly && WSConnectionRequestInfoImpl.match(this.ivUserName, wSConnectionRequestInfoImpl.ivUserName) && WSConnectionRequestInfoImpl.match(this.ivPassword, wSConnectionRequestInfoImpl.ivPassword) && this.ivHoldability == wSConnectionRequestInfoImpl.ivHoldability && WSConnectionRequestInfoImpl.match(this.ivCatalog, wSConnectionRequestInfoImpl.ivCatalog) && WSConnectionRequestInfoImpl.match(this.ivReadOnly, wSConnectionRequestInfoImpl.ivReadOnly) && WSConnectionRequestInfoImpl.match(this.ivTypeMap, wSConnectionRequestInfoImpl.ivTypeMap) && this.ivConfigID == wSConnectionRequestInfoImpl.ivConfigID);
            }
            catch (RuntimeException runtimeException) {
                bl = false;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"equals?", (Object)new Object[]{AdapterUtil.toString(this), AdapterUtil.toString(object), bl ? Boolean.TRUE : Boolean.FALSE});
        }
        return bl;
    }

    private static final boolean match(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer(300).append(AdapterUtil.toString(this)).append(string + "  UserName       = ").append(this.ivUserName).append(string + "  Password       = ").append(this.ivPassword == null ? "null" : "******").append(string + "  Catalog        = ").append(this.ivCatalog).append(string + "  IsReadOnly     = ").append(this.ivReadOnly).append(string + "  TypeMap        = ").append(this.ivTypeMap).append(string + "  NoEnlist       = ").append(this.ivNoEnlist).append(string + "  ShareWithCMPOnly = ").append(this.ivShareWithCMPOnly).append(string + "  Holdability    = ").append(AdapterUtil.getCursorHoldabilityString(this.ivHoldability)).append(string + "  ConfigID       = ").append(this.ivConfigID).append(string + "  Isolation      = ").append(AdapterUtil.getIsolationLevelString(this.ivIsoLevel)).append(string + "  Support isolation switching  = ").append(this.supportIsolvlSwitching).append(string + "  Handle type    = ").append(this.isJDBC ? Connection.class.getName() : javax.resource.cci.Connection.class.getName());
        return new String(stringBuffer);
    }

    public final int hashCode() {
        return this.hashcode;
    }
}

