/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.ws.rsadapter.spi.InternalGenericDataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSRdbDataSource;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.resource.ResourceException;

public class InternalSybaseDataStoreHelper
extends InternalGenericDataStoreHelper {
    private static final TraceComponent tc = Tr.register((Class)InternalSybaseDataStoreHelper.class, (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    private transient TraceComponent sybaseTc = Tr.register((String)"com.ibm.ws.sybase.logwriter", (String)"WAS.database", null);
    private transient PrintWriter sybasePw = null;

    public PrintWriter getPrintWriter() throws ResourceException {
        if (this.sybasePw == null) {
            this.sybasePw = this.externalHelper.getPrintWriter();
            if (this.sybasePw != null) {
                Tr.debug((TraceComponent)this.sybaseTc, (String)"user supplied own printWriter in datastore helper, will use provided one", (Object)this.sybasePw);
            } else {
                this.sybasePw = new PrintWriter((Writer)new TraceWriter(this.sybaseTc), true);
            }
        }
        Tr.debug((TraceComponent)this.sybaseTc, (String)"returning", (Object)this.sybasePw);
        return this.sybasePw;
    }

    public void gatherAndDisplayMetaDataInfo(Connection connection, WSRdbDataSource wSRdbDataSource) throws SQLException {
        block9: {
            this.setDatabaseProductName("Sybase SQL Server");
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                String string = databaseMetaData.getDatabaseProductName();
                Tr.info((TraceComponent)tc, (String)"DB_PRODUCT_NAME", (Object)string);
                Tr.info((TraceComponent)tc, (String)"DB_PRODUCT_VERSION", (Object)databaseMetaData.getDatabaseProductVersion());
                Tr.info((TraceComponent)tc, (String)"JDBC_DRIVER_NAME", (Object)databaseMetaData.getDriverName());
                Tr.info((TraceComponent)tc, (String)"JDBC_DRIVER_VERSION", (Object)databaseMetaData.getDriverVersion());
                try {
                    if (databaseMetaData.supportsResultSetHoldability(1) && databaseMetaData.supportsResultSetHoldability(2)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Holdabiliy is supported");
                        }
                        this.holdabilitySupported = true;
                        break block9;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Holdability not supported");
                    }
                    this.holdabilitySupported = false;
                }
                catch (Throwable throwable) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"caught an exception when testing the holdability from metadata, will call the holdability itself to know if supported", (Object)throwable);
                    }
                }
            }
            catch (SQLException sQLException) {
                SQLException sQLException2 = this.externalHelper.mapException(sQLException);
                if (sQLException2 instanceof StaleConnectionException) {
                    throw sQLException2;
                }
                Tr.info((TraceComponent)tc, (String)"META_DATA_EXCEPTION", (Object)sQLException2.getMessage());
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug((TraceComponent)tc, (String)("meta data access caused a non SCE, continuing without displaying metadata: " + sQLException2));
            }
        }
    }
}

