/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.rsadapter.Oracle10gDataStoreHelper;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.spi.InternalGenericDataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSRdbDataSource;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import javax.resource.ResourceException;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;

public class InternalOracleDataStoreHelper
extends InternalGenericDataStoreHelper {
    private static TraceComponent tc = Tr.register((Class)InternalOracleDataStoreHelper.class, (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    protected static TraceComponent oraTc = Tr.register((String)"com.ibm.ws.oracle.logwriter", (String)"WAS.database", null);
    protected static TraceComponent clientInfoTc = Tr.register((String)"WAS.clientinfo", (String)"WAS.clientinfo", (String)"IBMDataStoreAdapterNLS");
    protected static TraceComponent clientInfoPlusTc = Tr.register((String)"WAS.clientinfopluslogging", (String)"WAS.clientinfopluslogging", (String)"IBMDataStoreAdapterNLS");
    private transient PrintWriter oraPw;
    int _logLevel = 2;
    private transient Class currClass = InternalOracleDataStoreHelper.class;
    private transient int majorDBRelease;

    public void setProperties(Properties properties) throws ResourceException {
        super.setProperties(properties);
        if (properties != null) {
            String string = properties.getProperty("oracle9iLogTraceLevel");
            if (string != null && !string.equals("")) {
                this._logLevel = Integer.parseInt(string);
            }
            if (oraTc.isDebugEnabled()) {
                Tr.debug((TraceComponent)oraTc, (String)"the oracle trace level specified is: ", (Object)new Integer(this._logLevel));
            }
            OracleLog.setLogVolume((int)this._logLevel);
        }
    }

    public boolean shouldTraceBeEnabled(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) {
        return oraTc.isDebugEnabled() && !wSRdbManagedConnectionImpl.mcf.loggingEnabled;
    }

    public boolean shouldTraceBeDisabled(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) {
        return !oraTc.isDebugEnabled() && wSRdbManagedConnectionImpl.mcf.loggingEnabled;
    }

    public void disableJdbcLogging(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws ResourceException {
        Tr.debug((TraceComponent)oraTc, (String)"Disabling logging on Oracle9i or prior", (Object)wSRdbManagedConnectionImpl.sqlConn);
        OracleLog.setLogWriter(null);
        wSRdbManagedConnectionImpl.mcf.loggingEnabled = false;
    }

    public void enableJdbcLogging(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws ResourceException {
        PrintWriter printWriter = this.getPrintWriter();
        Tr.debug((TraceComponent)oraTc, (String)"Enabling logging on Oralce9i or prior to ", (Object)printWriter);
        OracleLog.setLogWriter((PrintWriter)printWriter);
        wSRdbManagedConnectionImpl.mcf.loggingEnabled = true;
    }

    public PrintWriter getPrintWriter() throws ResourceException {
        if (this.oraPw == null) {
            this.oraPw = this.externalHelper.getPrintWriter();
            if (this.oraPw != null) {
                Tr.debug((TraceComponent)oraTc, (String)"user supplied own printWriter in the datastore helper, will use provided one", (Object)this.oraPw);
            } else {
                this.oraPw = new PrintWriter((Writer)new TraceWriter(oraTc), true);
            }
        }
        Tr.debug((TraceComponent)oraTc, (String)"returning", (Object)this.oraPw);
        return this.oraPw;
    }

    public void setReadOnly(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl, boolean bl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setReadOnly", (Object)new Object[]{this, wSRdbManagedConnectionImpl, new Boolean(bl)});
        }
        if (bl) {
            throw new SQLException(AdapterUtil.getNLSMessage("METHOD_UNSUPPORTED", new Object[]{"setReadOnly", Connection.class.getName()}));
        }
        Tr.info((TraceComponent)tc, (String)"ORA_READONLY");
    }

    public void psSetBytes(PreparedStatement preparedStatement, int n, byte[] byArray) throws SQLException {
        int n2;
        int n3 = n2 = byArray == null ? 0 : byArray.length;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("psSetBytes - byteArray length: " + n2));
        }
        if (byArray != null && n2 > 2000) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ORACLE setBytes byte array length > 2000 workaround.");
            }
            preparedStatement.setBinaryStream(n, (InputStream)new ByteArrayInputStream(byArray), n2);
        } else {
            preparedStatement.setBytes(n, byArray);
        }
    }

    public void psSetString(PreparedStatement preparedStatement, int n, String string) throws SQLException {
        int n2;
        int n3 = n2 = string == null ? 0 : string.getBytes().length;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("string length: " + n2));
        }
        if (n2 > 4000) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Oracle setString length > 4000 bytes workaround.");
            }
            preparedStatement.setCharacterStream(n, (Reader)new StringReader(string), string.length());
        } else {
            preparedStatement.setString(n, string);
        }
    }

    public int getHoldability(Connection connection) throws SQLException {
        int n = 0;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getHoldability", (Object)AdapterUtil.toString(connection));
        }
        try {
            if (this.holdabilitySupported) {
                n = connection.getHoldability();
                return n;
            }
            return 0;
        }
        catch (AbstractMethodError abstractMethodError) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getHoldability", (Object)"getHoldability is not supported in this JDBC driver. Encounter a java.lang.AbstractMethodError");
            }
            this.holdabilitySupported = false;
            return 0;
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == 17023) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getHoldability", (Object)("getHoldability is not supported in this JDBC driver. Encounter a java.sql.SQLException: " + sQLException.getMessage()));
                }
                this.holdabilitySupported = false;
                return 0;
            }
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClientInformation(Properties properties, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl, boolean bl) throws SQLException {
        StringBuffer stringBuffer = null;
        String string = null;
        OracleConnection oracleConnection = (OracleConnection)wSRdbManagedConnectionImpl.sqlConn;
        if (this.majorDBRelease == 0) {
            try {
                this.majorDBRelease = oracleConnection.getMetaData().getDatabaseMajorVersion();
            }
            catch (SQLException sQLException) {
                this.majorDBRelease = 1;
            }
            if (this.majorDBRelease < 9) {
                Tr.warning((TraceComponent)tc, (String)"ORACLE8I_CLIENTID_WARNING");
            }
        }
        if (tc.isDebugEnabled() || clientInfoPlusTc.isDebugEnabled()) {
            TraceComponent traceComponent = clientInfoPlusTc.isDebugEnabled() ? clientInfoPlusTc : tc;
            Tr.debug((TraceComponent)traceComponent, (String)"setClientInformation(Properties props,WSRdbManagedConnectionImpl mc, boolean explicitCall) with sqlConn", (Object)new Object[]{properties, wSRdbManagedConnectionImpl, new Boolean(bl), wSRdbManagedConnectionImpl.sqlConn});
            if (this.majorDBRelease == 8) {
                Tr.debug((TraceComponent)traceComponent, (String)"Oracle 8i DB server detected -- exiting method");
            }
            if (this.majorDBRelease == 1) {
                Tr.debug((TraceComponent)traceComponent, (String)"JDBC driver does not support getDatabaseMajorVersion method.  DB version unknown -- exiting method");
            }
        }
        if (this.majorDBRelease < 9) {
            return;
        }
        if (bl) {
            string = properties.getProperty("CLIENT_ID");
            wSRdbManagedConnectionImpl.clientInfoExplicitlySet = true;
        }
        if (clientInfoTc.isDebugEnabled() || clientInfoPlusTc.isDebugEnabled()) {
            stringBuffer = new StringBuffer(64);
            stringBuffer.append(RasHelper.getThreadId()).append('_').append(wSRdbManagedConnectionImpl.toString());
            if (string != null) {
                stringBuffer.append('_').append(string);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The clientInfo string is:", (Object)stringBuffer);
            }
            wSRdbManagedConnectionImpl.clientInfoImplicitlySet = true;
            string = stringBuffer.toString();
        }
        if (string != null) {
            wSRdbManagedConnectionImpl.holdCurrentClientInfo(string, null, null, null);
            if (wSRdbManagedConnectionImpl.pmi != null) {
                try {
                    wSRdbManagedConnectionImpl.pmi.jdbcOperationStarted();
                    oracleConnection.setClientIdentifier(string);
                }
                finally {
                    wSRdbManagedConnectionImpl.pmi.jdbcOperationCompleted();
                }
            } else {
                oracleConnection.setClientIdentifier(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClientInformationArray(String[] stringArray, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl, boolean bl) throws SQLException {
        OracleConnection oracleConnection = (OracleConnection)wSRdbManagedConnectionImpl.sqlConn;
        if (bl) {
            wSRdbManagedConnectionImpl.clientInfoExplicitlySet = true;
        } else {
            wSRdbManagedConnectionImpl.clientInfoImplicitlySet = true;
        }
        if (wSRdbManagedConnectionImpl.pmi != null) {
            try {
                wSRdbManagedConnectionImpl.pmi.jdbcOperationStarted();
                oracleConnection.setClientIdentifier(stringArray[0]);
            }
            finally {
                wSRdbManagedConnectionImpl.pmi.jdbcOperationCompleted();
            }
        } else {
            oracleConnection.setClientIdentifier(stringArray[0]);
        }
    }

    public void resetClientInformation(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if ((wSRdbManagedConnectionImpl.clientInfoExplicitlySet || wSRdbManagedConnectionImpl.clientInfoImplicitlySet) && !clientInfoTc.isDebugEnabled() && !clientInfoPlusTc.isDebugEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"resetClientInformation is called on: ", (Object)wSRdbManagedConnectionImpl);
            }
            OracleConnection oracleConnection = (OracleConnection)wSRdbManagedConnectionImpl.sqlConn;
            oracleConnection.setClientIdentifier(null);
            wSRdbManagedConnectionImpl.clientInfoExplicitlySet = false;
            wSRdbManagedConnectionImpl.clientInfoImplicitlySet = false;
        }
    }

    public void doConnectionCleanupOnWrapper(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (wSRdbManagedConnectionImpl.is2Phase()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"setting AC to false to workaround Oracle xa problem");
            }
            wSRdbManagedConnectionImpl.setAutoCommit(false);
        }
    }

    public void gatherAndDisplayMetaDataInfo(Connection connection, WSRdbDataSource wSRdbDataSource) throws SQLException {
        block7: {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String string = databaseMetaData.getDatabaseProductName();
            this.setDatabaseProductName(string);
            Tr.info((TraceComponent)tc, (String)"DB_PRODUCT_NAME", (Object)string);
            Tr.info((TraceComponent)tc, (String)"DB_PRODUCT_VERSION", (Object)databaseMetaData.getDatabaseProductVersion());
            Tr.info((TraceComponent)tc, (String)"JDBC_DRIVER_NAME", (Object)databaseMetaData.getDriverName());
            Tr.info((TraceComponent)tc, (String)"JDBC_DRIVER_VERSION", (Object)databaseMetaData.getDriverVersion());
            Tr.info((TraceComponent)tc, (String)"DATA_STORE_HELPER_NAME", (Object)wSRdbDataSource.dataStoreHelper);
            if (databaseMetaData.getDriverMajorVersion() >= 10 && !(wSRdbDataSource.dataStoreHelper instanceof Oracle10gDataStoreHelper)) {
                Tr.warning((TraceComponent)tc, (String)"ORACLE_10G_DATASTORE_HELPER_WARNING");
            }
            try {
                if (databaseMetaData.supportsResultSetHoldability(1) && databaseMetaData.supportsResultSetHoldability(2)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Holdabiliy is supported");
                    }
                    this.holdabilitySupported = true;
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Holdability not supported");
                    }
                    this.holdabilitySupported = false;
                }
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug((TraceComponent)tc, (String)"caught an exception when testing the holdability from metadata, will call the holdability itself to know if supported", (Object)throwable);
            }
        }
    }
}

