/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ce.cm.PortableSQLException;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.websphere.rsadapter.DataStoreHelper;
import com.ibm.websphere.rsadapter.Reassociateable;
import com.ibm.websphere.rsadapter.WSSystemMonitor;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException;
import com.ibm.ws.rsadapter.jdbc.WSJdbcConnection;
import com.ibm.ws.rsadapter.spi.InternalDataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSRdbDataSource;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.sql.PooledConnection;
import org.ietf.jgss.GSSCredential;

public class InternalGenericDataStoreHelper
implements InternalDataStoreHelper {
    private static final TraceComponent databaseTc = Tr.register((String)"com.ibm.ws.database.logwriter", (String)"WAS.database", null);
    private static final TraceComponent tc = Tr.register((Class)InternalGenericDataStoreHelper.class, (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    private static TraceComponent clientInfoTc = Tr.register((String)"WAS.clientinfo", (String)"WAS.clientinfo", (String)"IBMDataStoreAdapterNLS");
    private static TraceComponent clientInfoPlusTc = Tr.register((String)"WAS.clientinfopluslogging", (String)"WAS.clientinfopluslogging", (String)"IBMDataStoreAdapterNLS");
    private transient PrintWriter genPw = null;
    private transient Class currClass = InternalGenericDataStoreHelper.class;
    protected transient DataStoreHelper externalHelper = null;
    private String databaseProductName = null;
    protected boolean holdabilitySupported = true;

    public void closeDefaultContext(Object object) throws ResourceException {
    }

    public Reassociateable createJDBCConnectionWrapper(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws ResourceException {
        return new WSJdbcConnection(wSRdbManagedConnectionImpl, wSRdbManagedConnectionImpl.sqlConn, WSRdbManagedConnectionImpl.key, wSRdbManagedConnectionImpl.threadID);
    }

    public Boolean getRRSTransactional() {
        return Boolean.FALSE;
    }

    public String getThreadIdentitySupport() {
        return "NOTALLOWED";
    }

    public Boolean getThreadSecurity() {
        return Boolean.FALSE;
    }

    public String getCorrelator(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        return null;
    }

    public void setEwlmCorrelator(byte[] byArray, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws ResourceException {
    }

    public void setProperties(Properties properties) throws ResourceException {
    }

    public boolean shouldTraceBeEnabled(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) {
        return databaseTc.isDebugEnabled() && !wSRdbManagedConnectionImpl.mcf.loggingEnabled;
    }

    public boolean shouldTraceBeDisabled(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) {
        return !databaseTc.isDebugEnabled() && wSRdbManagedConnectionImpl.mcf.loggingEnabled;
    }

    public void disableJdbcLogging(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws ResourceException {
        wSRdbManagedConnectionImpl.mcf.reallySetLogWriter(null);
        wSRdbManagedConnectionImpl.mcf.loggingEnabled = false;
    }

    public void enableJdbcLogging(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws ResourceException {
        PrintWriter printWriter = this.getPrintWriter();
        Tr.debug((TraceComponent)databaseTc, (String)"enabling logging {mcf, pw}: ", (Object)new Object[]{wSRdbManagedConnectionImpl.mcf, printWriter});
        wSRdbManagedConnectionImpl.mcf.reallySetLogWriter(printWriter);
        wSRdbManagedConnectionImpl.mcf.loggingEnabled = true;
    }

    public PrintWriter getPrintWriter() throws ResourceException {
        if (this.genPw == null) {
            PrintWriter printWriter = this.externalHelper.getPrintWriter();
            if (printWriter != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"user supplied own printWriter in the DataStoreHelper, will use provided one", (Object)printWriter);
                }
                this.genPw = printWriter;
            } else {
                this.genPw = new PrintWriter((Writer)new TraceWriter(databaseTc), true);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"returning", (Object)this.genPw);
        }
        return this.genPw;
    }

    public String processSQL(String string, int n, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = null;
        if (bl) {
            stringBuffer = new StringBuffer(250);
            stringBuffer.append(string).append(" FOR UPDATE");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("modified sqlString is: " + stringBuffer));
            }
            return new String(stringBuffer);
        }
        return string;
    }

    public void setReadOnly(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl, boolean bl) throws SQLException {
        wSRdbManagedConnectionImpl.setReadOnly(bl);
    }

    public int getHoldability(Connection connection) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getHoldability", (Object)AdapterUtil.toString(connection));
        }
        int n = 0;
        try {
            if (this.holdabilitySupported) {
                n = connection.getHoldability();
                return n;
            }
            return 0;
        }
        catch (AbstractMethodError abstractMethodError) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getHoldability", (Object)"getHoldability is not supported in this JDBC driver. Encounter a java.lang.AbstractMethodError");
            }
            this.holdabilitySupported = false;
            return 0;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getHoldability", (Object)"getHoldability is not supported in this JDBC driver. Encounter a java.lang.UnsupportedOperationException");
            }
            this.holdabilitySupported = false;
            return 0;
        }
    }

    public Properties validateConfiguration(Properties properties, String string) {
        return properties;
    }

    public boolean isIsolationLevelSwitchingSupport() {
        return false;
    }

    public void psSetBytes(PreparedStatement preparedStatement, int n, byte[] byArray) throws SQLException {
        preparedStatement.setBytes(n, byArray);
    }

    public void psSetString(PreparedStatement preparedStatement, int n, String string) throws SQLException {
        preparedStatement.setString(n, string);
    }

    public DataStoreAdapterException mapException(DataStoreAdapterException dataStoreAdapterException) {
        SQLException sQLException = null;
        SQLException sQLException2 = null;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"mapException", (Object)((Object)dataStoreAdapterException));
        }
        if (!dataStoreAdapterException.beenMapped()) {
            if (dataStoreAdapterException.containsSqlException() && (sQLException = this.externalHelper.mapException(sQLException2 = (SQLException)dataStoreAdapterException.getLinkedException())) instanceof PortableSQLException) {
                if (sQLException2 instanceof BatchUpdateException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Exception is a batchUpdate ex, no exception mapping is done, just setting connection error flag because cause id a staleConnectionException");
                    }
                } else {
                    dataStoreAdapterException.setLinkedException(sQLException);
                }
                if (sQLException instanceof StaleConnectionException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"mapException: linkedException causes a  Stale Connection");
                    }
                    dataStoreAdapterException.setConnectionError(true);
                }
            }
            dataStoreAdapterException.setBeenMapped();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"mapException", (Object)((Object)dataStoreAdapterException));
        }
        return dataStoreAdapterException;
    }

    public void setExternalHelper(DataStoreHelper dataStoreHelper) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setExternalHelper", (Object)dataStoreHelper);
        }
        this.externalHelper = dataStoreHelper;
    }

    public void setDatabaseProductName(String string) {
        this.databaseProductName = string;
    }

    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    public void setClientInformation(Properties properties, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl, boolean bl) throws SQLException {
        if (properties == null) {
            return;
        }
        if (clientInfoPlusTc.isDebugEnabled()) {
            Tr.debug((TraceComponent)clientInfoPlusTc, (String)"setClientInformation(Properties props, WSRdbManagedConnectionImpl mc, boolean explicitCall)", (Object)new Object[]{properties, wSRdbManagedConnectionImpl, new Boolean(bl)});
        }
    }

    public void setClientInformationArray(String[] stringArray, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl, boolean bl) throws SQLException {
    }

    public void resetClientInformation(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
    }

    public boolean resetConnection(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        return false;
    }

    public PooledConnection getPooledConnection(GSSCredential gSSCredential, WSRdbDataSource wSRdbDataSource, int n) throws ResourceException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getPooledConnection() returning null");
        }
        return null;
    }

    public WSSystemMonitor getSystemMonitor(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getSystemMonitor() returning null");
        }
        return null;
    }

    public void enableSystemMonitor(Object object, boolean bl, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"no-op");
        }
    }

    public void startSystemMonitor(Object object, int n, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"no-op");
        }
    }

    public void stopSystemMonitor(Object object, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"no-op");
        }
    }

    public long getServerTimeMicros(Object object, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"no-op");
        }
        return -1L;
    }

    public long getNetworkIOTimeMicros(Object object, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"no-op");
        }
        return -1L;
    }

    public long getCoreDriverTimeMicros(Object object, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"no-op");
        }
        return -1L;
    }

    public long getApplicationTimeMillis(Object object, WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"no-op");
        }
        return -1L;
    }

    public Object getSQLJContext(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        return null;
    }

    public Object getDefaultContext(Connection connection) throws SQLException {
        return null;
    }

    public void setCurrentAutoCommit(Connection connection, boolean bl) {
    }

    public void setCurrentTransactionIsolation(Connection connection, int n) {
    }

    public void doConnectionCleanupOnWrapper(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
    }

    public void processLastHandleClosed(Connection connection, boolean bl, boolean bl2) throws SQLException {
    }

    public void gatherAndDisplayMetaDataInfo(Connection connection, WSRdbDataSource wSRdbDataSource) throws SQLException {
        block6: {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String string = databaseMetaData.getDatabaseProductName();
            this.setDatabaseProductName(string);
            Tr.info((TraceComponent)tc, (String)"DB_PRODUCT_NAME", (Object)string);
            Tr.info((TraceComponent)tc, (String)"DB_PRODUCT_VERSION", (Object)databaseMetaData.getDatabaseProductVersion());
            Tr.info((TraceComponent)tc, (String)"JDBC_DRIVER_NAME", (Object)databaseMetaData.getDriverName());
            Tr.info((TraceComponent)tc, (String)"JDBC_DRIVER_VERSION", (Object)databaseMetaData.getDriverVersion());
            try {
                if (databaseMetaData.supportsResultSetHoldability(1) && databaseMetaData.supportsResultSetHoldability(2)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Holdabiliy is supported");
                    }
                    this.holdabilitySupported = true;
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Holdability not supported");
                    }
                    this.holdabilitySupported = false;
                }
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)"caught an exception when testing the holdability from metadata, will call the holdability itself to know if supported", (Object)throwable);
            }
        }
    }
}

