/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.db2.jcc.DB2Wrapper;
import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.rsadapter.Reassociateable;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.jdbc.WSDB2WrapperConnection;
import com.ibm.ws.rsadapter.jdbc.WSJdbcConnection;
import com.ibm.ws.rsadapter.spi.InternalGenericDataStoreHelper;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import com.ibm.ws.util.PlatformHelperFactory;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import javax.resource.ResourceException;
import sqlj.runtime.ref.DefaultContext;

public class InternalDB2DataStoreHelper
extends InternalGenericDataStoreHelper {
    private static TraceComponent tc = Tr.register((Class)InternalDB2DataStoreHelper.class, (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    protected static final TraceComponent db2Tc = Tr.register((String)"com.ibm.ws.db2.logwriter", (String)"WAS.database", null);
    String osType;
    boolean isRRSTransaction = false;
    String threadIdentitySupport = "NOTALLOWED";
    boolean threadSecurity = false;
    boolean localZOS = false;
    protected static boolean private_disableResetUOW;
    protected static boolean supportsUOWDetection;
    private static Field mTransactionStateField;
    String productName = null;
    static int JDBC;
    static int SQLJ;
    int connType = 0;
    private transient PrintWriter db2Pw;

    public InternalDB2DataStoreHelper() {
        if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
            this.localZOS = true;
        }
        if (this.localZOS) {
            this.isRRSTransaction = true;
            this.threadIdentitySupport = "ALLOWED";
            this.threadSecurity = true;
        }
    }

    public Reassociateable createJDBCConnectionWrapper(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createJDBCConnectionWrapper", (Object)wSRdbManagedConnectionImpl);
        }
        WSJdbcConnection wSJdbcConnection = null;
        Object object = wSRdbManagedConnectionImpl.threadID;
        if (object == null && wSRdbManagedConnectionImpl.mcf.detectMultithreadedAccess) {
            object = Thread.currentThread();
        }
        wSJdbcConnection = this.localZOS ? new WSDB2WrapperConnection(wSRdbManagedConnectionImpl, wSRdbManagedConnectionImpl.sqlConn, WSRdbManagedConnectionImpl.key, object) : new WSJdbcConnection(wSRdbManagedConnectionImpl, wSRdbManagedConnectionImpl.sqlConn, WSRdbManagedConnectionImpl.key, object);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createJDBCConnectionWrapper", (Object)wSJdbcConnection);
        }
        return wSJdbcConnection;
    }

    public Boolean getRRSTransactional() {
        return new Boolean(this.isRRSTransaction);
    }

    public String getThreadIdentitySupport() {
        return this.threadIdentitySupport;
    }

    public Boolean getThreadSecurity() {
        return new Boolean(this.threadSecurity);
    }

    public PrintWriter getPrintWriter() throws ResourceException {
        if (this.db2Pw == null) {
            this.db2Pw = this.externalHelper.getPrintWriter();
            if (this.db2Pw != null) {
                Tr.debug((TraceComponent)db2Tc, (String)"user supplied own printWriter in the datastore helper, will use provided one", (Object)this.db2Pw);
            } else {
                this.db2Pw = new PrintWriter((Writer)new TraceWriter(db2Tc), true);
            }
        }
        Tr.debug((TraceComponent)tc, (String)"returning", (Object)this.db2Pw);
        return this.db2Pw;
    }

    public Object getDefaultContext(Connection connection) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getDefaultContext", (Object)this);
        }
        DefaultContext defaultContext = null;
        try {
            defaultContext = new DefaultContext(connection);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.spi.InternalDB2DataStoreHelper.getDefaultContext", (String)"549", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getDefaultContext - failed trying to create Default ConnectionContext, throwing exception");
            }
            throw sQLException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getDefaultContext", (Object)defaultContext);
        }
        return defaultContext;
    }

    public void processLastHandleClosed(Connection connection, boolean bl, boolean bl2) throws SQLException {
        if (this.localZOS && bl && !bl2) {
            this.resetUOWBoundary(connection);
        }
    }

    public void doConnectionCleanupOnWrapper(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl) throws SQLException {
        if (this.localZOS) {
            this.resetUOWBoundary(wSRdbManagedConnectionImpl.sqlConn);
        }
    }

    private void resetUOWBoundary(Connection connection) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resetUOWBoundary");
        }
        if (!private_disableResetUOW) {
            boolean bl = true;
            if (this.localZOS && supportsUOWDetection) {
                try {
                    int n;
                    DB2Wrapper dB2Wrapper = (DB2Wrapper)connection;
                    Object object = dB2Wrapper.getDB2Object();
                    if (mTransactionStateField == null) {
                        Class<?> clazz = object.getClass();
                        mTransactionStateField = clazz.getField("mTransactionState");
                    }
                    if ((n = mTransactionStateField.getInt(object)) == 0) {
                        bl = false;
                    }
                }
                catch (Exception exception) {
                    Tr.event((TraceComponent)tc, (String)"JDBC Driver does not support UOW detection because of: ", (Object)exception);
                    supportsUOWDetection = false;
                }
            }
            if (bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Issuing rollback to reset UOW boundary");
                }
                connection.rollback();
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Connection already on UOW boundary; skip rollback");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resetUOWBoundary");
        }
    }

    static {
        supportsUOWDetection = true;
        mTransactionStateField = null;
        JDBC = 1;
        SQLJ = 2;
        private_disableResetUOW = new Boolean(System.getProperty("private_disableResetUOW"));
        if (tc.isDebugEnabled() && private_disableResetUOW) {
            Tr.debug((TraceComponent)tc, (String)"resetUOW is disabled");
        }
    }
}

