/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.spi;

import com.ibm.ws.rsadapter.AdapterUtil;
import java.text.DecimalFormat;

public class CacheMap {
    private final int maxEntries;
    private int numEntries;
    private final int numBuckets;
    private static final int maxBucketSize = 5;
    private int numDiscards;
    private final Object[][] values;
    private final Object[][] keys;
    private final int[] bucketSizes;
    private final int[] previous;
    private final int[] next;
    private final int BEFORE_LRU;
    private final int AFTER_MRU;

    public CacheMap(int n) {
        this.maxEntries = n;
        this.BEFORE_LRU = this.numBuckets = (this.maxEntries * 4 + 1) / 3;
        this.AFTER_MRU = this.numBuckets + 1;
        int n2 = this.numBuckets + 2;
        this.previous = new int[n2];
        this.next = new int[n2];
        this.values = new Object[this.numBuckets][5];
        this.keys = new Object[this.numBuckets][5];
        this.bucketSizes = new int[this.numBuckets];
        for (int i = 0; i < this.numBuckets; ++i) {
            this.next[i] = this.previous[i] = this.BEFORE_LRU;
        }
        this.next[this.BEFORE_LRU] = this.AFTER_MRU;
        this.previous[this.AFTER_MRU] = this.BEFORE_LRU;
    }

    public final Object add(Object object, Object object2) {
        int n;
        int n2;
        int n3 = n2 = (object.hashCode() & Integer.MAX_VALUE) % this.numBuckets;
        int n4 = this.bucketSizes[n3];
        this.bucketSizes[n3] = n4 + 1;
        int n5 = n4;
        Object object3 = n5 == 5 ? this.discardFromBucket(n2, --n5) : null;
        this.values[n2][n5] = object2;
        this.keys[n2][n5] = object;
        int n6 = this.next[n2];
        if (n6 != this.BEFORE_LRU) {
            this.previous[n6] = n = this.previous[n2];
            this.next[n] = n6;
        }
        n = this.previous[this.AFTER_MRU];
        this.previous[this.AFTER_MRU] = this.next[n] = n2;
        this.next[n2] = this.AFTER_MRU;
        this.previous[n2] = n;
        return ++this.numEntries > this.maxEntries ? this.removeLRU() : object3;
    }

    private Object discardFromBucket(int n, int n2) {
        ++this.numDiscards;
        int n3 = n;
        this.bucketSizes[n3] = this.bucketSizes[n3] - 1;
        --this.numEntries;
        return this.values[n][n2];
    }

    public String display() {
        StringBuffer stringBuffer = new StringBuffer();
        DecimalFormat decimalFormat = new DecimalFormat("'  '000");
        stringBuffer.append(AdapterUtil.EOLN).append(this).append(AdapterUtil.EOLN).append("Number of entries:   ").append(this.numEntries).append(AdapterUtil.EOLN).append("Maximum entries:     ").append(this.maxEntries).append(AdapterUtil.EOLN).append("Number of buckets:   ").append(this.numBuckets).append(AdapterUtil.EOLN).append("Maximum bucket size: ").append(5).append(AdapterUtil.EOLN).append("Number of discards:  ").append(this.numDiscards);
        stringBuffer.append(AdapterUtil.EOLN).append(AdapterUtil.EOLN).append("BUCKET SIZE PREV NEXT").append(AdapterUtil.EOLN);
        for (int i = 0; i < this.numBuckets; ++i) {
            stringBuffer.append(decimalFormat.format(i));
            stringBuffer.append(decimalFormat.format(this.bucketSizes[i]));
            stringBuffer.append(decimalFormat.format(this.previous[i]));
            stringBuffer.append(decimalFormat.format(this.next[i]));
            stringBuffer.append(AdapterUtil.EOLN);
            for (int j = 0; j < this.bucketSizes[i]; ++j) {
                stringBuffer.append("                      ").append(Integer.toHexString(this.values[i][j].hashCode())).append(' ').append(this.keys[i][j]).append(AdapterUtil.EOLN);
            }
        }
        stringBuffer.append(decimalFormat.format(this.BEFORE_LRU)).append("  LRU     ").append(decimalFormat.format(this.next[this.BEFORE_LRU])).append(AdapterUtil.EOLN);
        stringBuffer.append(decimalFormat.format(this.AFTER_MRU)).append("  MRU").append(decimalFormat.format(this.previous[this.AFTER_MRU])).append(AdapterUtil.EOLN);
        return new String(stringBuffer);
    }

    public final Object remove(Object object) {
        int n = (object.hashCode() & Integer.MAX_VALUE) % this.numBuckets;
        Object[] objectArray = this.keys[n];
        int n2 = this.bucketSizes[n];
        for (int i = n2 - 1; i >= 0; --i) {
            if (!objectArray[i].equals(object)) continue;
            if ((this.bucketSizes[n] = --n2) == 0) {
                int n3 = this.next[n];
                int n4 = this.previous[n3] = this.previous[n];
                this.next[n4] = n3;
                this.next[n] = this.previous[n] = this.BEFORE_LRU;
            }
            --this.numEntries;
            objectArray[i] = objectArray[n2];
            objectArray[n2] = null;
            Object[] objectArray2 = this.values[n];
            Object object2 = objectArray2[i];
            objectArray2[i] = objectArray2[n2];
            objectArray2[n2] = null;
            return object2;
        }
        return null;
    }

    public final Object[] removeAll() {
        Object[] objectArray = new Object[this.numEntries];
        this.numEntries = 0;
        int n = this.numBuckets;
        int n2 = 0;
        while (n > 0) {
            int n3 = this.bucketSizes[--n];
            while (n3 > 0) {
                Object[] objectArray2 = this.values[n];
                Object[] objectArray3 = this.keys[n];
                objectArray3[--n3] = null;
                objectArray[n2++] = objectArray2[n3];
                objectArray2[n3] = null;
            }
            this.bucketSizes[n] = 0;
        }
        for (n = 0; n <= this.AFTER_MRU; ++n) {
            this.next[n] = this.previous[n] = this.BEFORE_LRU;
        }
        return objectArray;
    }

    private final Object removeLRU() {
        int n = this.next[this.BEFORE_LRU];
        Object[] objectArray = this.values[n];
        Object[] objectArray2 = this.keys[n];
        int n2 = n;
        int n3 = this.bucketSizes[n2] - 1;
        this.bucketSizes[n2] = n3;
        int n4 = n3;
        --this.numEntries;
        int n5 = (this.numDiscards++ & Integer.MAX_VALUE) % (n4 + 1);
        Object object = objectArray[n5];
        if (n4 == 0) {
            int n6 = this.next[n];
            int n7 = this.previous[n6] = this.previous[n];
            this.next[n7] = n6;
            this.next[n] = this.BEFORE_LRU;
            objectArray[0] = null;
            objectArray2[0] = null;
        } else {
            objectArray[n5] = objectArray[n4];
            objectArray[n4] = null;
            objectArray2[n5] = objectArray2[n4];
            objectArray2[n4] = null;
        }
        return object;
    }

    public final int size() {
        return this.numEntries;
    }
}

