/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.reqmetrics.PmiReqMetrics;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.jdbc.WSJdbcConnection;
import com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet;
import com.ibm.ws.rsadapter.jdbc.WSJdbcStatement;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import com.ibm.ws.rsadapter.spi.InternalDataStoreHelper;
import com.ibm.ws.rsadapter.spi.StatementCacheKey;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class WSJdbcPreparedStatement
extends WSJdbcStatement
implements PreparedStatement {
    private static final TraceComponent tc = Tr.register((Class)WSJdbcPreparedStatement.class, (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    PreparedStatement pstmtImpl;
    StatementCacheKey key;
    InternalDataStoreHelper internalHelper;

    WSJdbcPreparedStatement() {
    }

    WSJdbcPreparedStatement(PreparedStatement preparedStatement, WSJdbcConnection wSJdbcConnection, int n) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{AdapterUtil.toString(preparedStatement), wSJdbcConnection, AdapterUtil.getCursorHoldabilityString(n)});
        }
        this.pstmtImpl = preparedStatement;
        this.stmtImpl = this.pstmtImpl;
        this.parentWrapper = wSJdbcConnection;
        this.pmi = wSJdbcConnection.pmi;
        this.holdability = n;
        try {
            this.currentFetchSize = this.pstmtImpl.getFetchSize();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.<init>", (String)"94", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"<init>", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("current fetchSize is " + this.currentFetchSize));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    WSJdbcPreparedStatement(PreparedStatement preparedStatement, WSJdbcConnection wSJdbcConnection, int n, StatementCacheKey statementCacheKey) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{AdapterUtil.toString(preparedStatement), wSJdbcConnection, AdapterUtil.getCursorHoldabilityString(n), statementCacheKey});
        }
        this.pstmtImpl = preparedStatement;
        this.stmtImpl = this.pstmtImpl;
        this.parentWrapper = wSJdbcConnection;
        this.pmi = wSJdbcConnection.pmi;
        this.key = statementCacheKey;
        this.holdability = n;
        try {
            this.currentFetchSize = this.pstmtImpl.getFetchSize();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.<init>", (String)"184", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"<init>", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("current fetchSize is " + this.currentFetchSize));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    void setInternalHelper(InternalDataStoreHelper internalDataStoreHelper) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setInternalHelper");
        }
        this.internalHelper = internalDataStoreHelper;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setInternalHelper");
        }
    }

    public void addBatch() throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"addBatch");
        }
        try {
            this.pstmtImpl.addBatch();
            this.hasBatchParameters = true;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.addBatch", (String)"65", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void clearParameters() throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"clearParameters");
        }
        try {
            this.pstmtImpl.clearParameters();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.clearParameters", (String)"87", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    SQLException closeWrapper(boolean bl) {
        SQLException sQLException;
        block19: {
            sQLException = null;
            try {
                this.parentWrapper.childWrappers.remove(this);
            }
            catch (RuntimeException runtimeException) {
                if (this.parentWrapper.state == 2) break block19;
                throw runtimeException;
            }
        }
        if (this.key == null) {
            try {
                this.pstmtImpl.close();
            }
            catch (SQLException sQLException2) {
                FFDCFilter.processException((Throwable)sQLException2, (String)(this.getClass().getName() + ".closeWrapper"), (String)"264", (Object)this);
                Tr.warning((TraceComponent)tc, (String)"ERR_CLOSING_OBJECT", (Object)new Object[]{this.pstmtImpl, sQLException2});
                sQLException = sQLException2;
            }
        } else {
            WSJdbcConnection wSJdbcConnection = (WSJdbcConnection)this.parentWrapper;
            WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl = wSJdbcConnection.managedConn;
            if (wSRdbManagedConnectionImpl == null) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Not associated with a ManagedConnection. Statement cannot be cached.");
                    }
                    this.pstmtImpl.close();
                }
                catch (SQLException sQLException3) {
                    FFDCFilter.processException((Throwable)sQLException3, (String)(this.getClass().getName() + ".closeWrapper"), (String)"281", (Object)this);
                    Tr.warning((TraceComponent)tc, (String)"ERR_CLOSING_OBJECT", (Object)new Object[]{this.pstmtImpl, sQLException3});
                    sQLException = sQLException3;
                }
            } else {
                try {
                    if (this.haveStatementPropertiesChanged) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Cleaning up Statement");
                        }
                        wSJdbcConnection.helper.doStatementCleanup(this.pstmtImpl);
                        this.haveStatementPropertiesChanged = false;
                    }
                    if (this.hasBatchParameters) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Clearing batch parameters");
                        }
                        this.pstmtImpl.clearBatch();
                    }
                    wSRdbManagedConnectionImpl.cacheStatement(this.pstmtImpl, this.key);
                }
                catch (SQLException sQLException4) {
                    FFDCFilter.processException((Throwable)sQLException4, (String)(this.getClass().getName() + ".closeWrapper"), (String)"310", (Object)this);
                    sQLException = sQLException4;
                    try {
                        this.pstmtImpl.close();
                    }
                    catch (SQLException sQLException5) {
                        FFDCFilter.processException((Throwable)sQLException5, (String)(this.getClass().getName() + ".closeWrapper"), (String)"321", (Object)this);
                        Tr.warning((TraceComponent)tc, (String)"ERR_CLOSING_OBJECT", (Object)new Object[]{this.pstmtImpl, sQLException5});
                    }
                }
            }
        }
        this.stmtImpl = null;
        this.pstmtImpl = null;
        this.key = null;
        return sQLException == null ? null : WSJdbcUtil.mapException(this, sQLException);
    }

    final void enforceStatementProperties() throws SQLException {
        if (this.requestedFetchSize != this.currentFetchSize) {
            this.stmtImpl.setFetchSize(this.requestedFetchSize);
            this.currentFetchSize = this.requestedFetchSize;
        }
    }

    public boolean execute() throws SQLException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"execute", (Object)this);
        }
        try {
            if (this.childWrapper != null) {
                this.closeAndRemoveResultSet();
            }
            if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                this.closeAndRemoveResultSets();
            }
            this.parentWrapper.beginTransactionIfNecessary();
            this.enforceStatementProperties();
            bl = this.pmi == null && !PmiReqMetrics.isEnabled() ? this.pstmtImpl.execute() : this.pmiExecute();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.execute", (String)"286", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"execute", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"execute", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"execute", (Object)(bl ? "QUERY" : "UPDATE"));
        }
        return bl;
    }

    public ResultSet executeQuery() throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"executeQuery", (Object)this);
        }
        WSJdbcResultSet wSJdbcResultSet = null;
        try {
            if (this.childWrapper != null) {
                this.closeAndRemoveResultSet();
            }
            if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                this.closeAndRemoveResultSets();
            }
            this.parentWrapper.beginTransactionIfNecessary();
            this.enforceStatementProperties();
            wSJdbcResultSet = this.createResultSetWrapper(this.pmi == null && !PmiReqMetrics.isEnabled() ? this.pstmtImpl.executeQuery() : this.pmiExecuteQuery());
            this.childWrapper = wSJdbcResultSet;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.executeQuery", (String)"371", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"executeQuery", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"executeQuery", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"executeQuery", (Object)this.childWrapper);
        }
        return wSJdbcResultSet;
    }

    public int executeUpdate() throws SQLException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"executeUpdate", (Object)this);
        }
        try {
            if (this.childWrapper != null) {
                this.closeAndRemoveResultSet();
            }
            if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                this.closeAndRemoveResultSets();
            }
            this.parentWrapper.beginTransactionIfNecessary();
            this.enforceStatementProperties();
            n = this.pmi == null && !PmiReqMetrics.isEnabled() ? this.pstmtImpl.executeUpdate() : this.pmiExecuteUpdate();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.executeUpdate", (String)"449", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"executeUpdate", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"executeUpdate", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"executeUpdate", (Object)new Integer(n));
        }
        return n;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getMetaData", (Object)this);
        }
        ResultSetMetaData resultSetMetaData = null;
        try {
            resultSetMetaData = this.pstmtImpl.getMetaData();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.getMetaData", (String)"621", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getMetaData", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getMetaData", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getMetaData", (Object)resultSetMetaData);
        }
        return resultSetMetaData;
    }

    TraceComponent getTracer() {
        return tc;
    }

    void introspectWrapperSpecificInfo(FFDCLogger fFDCLogger) {
        super.introspectWrapperSpecificInfo(fFDCLogger);
        fFDCLogger.append("key:", this.key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pmiExecute() throws SQLException {
        boolean bl;
        Object object;
        block6: {
            object = null;
            try {
                if (PmiReqMetrics.isEnabled()) {
                    object = PmiReqMetrics.updateBegin((int)2, (String)"JDBC", (String)"execute");
                }
                if (this.pmi != null) {
                    this.pmi.jdbcOperationStarted();
                }
                bl = this.pstmtImpl.execute();
                Object var4_3 = null;
                if (this.pmi == null) break block6;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var4_4 = null;
                    if (this.pmi != null) {
                        this.pmi.jdbcOperationCompleted();
                    }
                    if (!PmiReqMetrics.isEnabled()) break block7;
                    PmiReqMetrics.updateEnd((Object)object, (int)2, (int)0);
                }
                throw throwable;
            }
            this.pmi.jdbcOperationCompleted();
        }
        if (PmiReqMetrics.isEnabled()) {
            PmiReqMetrics.updateEnd((Object)object, (int)2, (int)0);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet pmiExecuteQuery() throws SQLException {
        ResultSet resultSet;
        Object object;
        block6: {
            object = null;
            try {
                if (PmiReqMetrics.isEnabled()) {
                    object = PmiReqMetrics.updateBegin((int)2, (String)"JDBC", (String)"executeQuery");
                }
                if (this.pmi != null) {
                    this.pmi.jdbcOperationStarted();
                }
                resultSet = this.pstmtImpl.executeQuery();
                Object var4_3 = null;
                if (this.pmi == null) break block6;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var4_4 = null;
                    if (this.pmi != null) {
                        this.pmi.jdbcOperationCompleted();
                    }
                    if (!PmiReqMetrics.isEnabled()) break block7;
                    PmiReqMetrics.updateEnd((Object)object, (int)2, (int)0);
                }
                throw throwable;
            }
            this.pmi.jdbcOperationCompleted();
        }
        if (PmiReqMetrics.isEnabled()) {
            PmiReqMetrics.updateEnd((Object)object, (int)2, (int)0);
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int pmiExecuteUpdate() throws SQLException {
        int n;
        Object object;
        block6: {
            object = null;
            try {
                if (PmiReqMetrics.isEnabled()) {
                    object = PmiReqMetrics.updateBegin((int)2, (String)"JDBC", (String)"executeUpdate");
                }
                if (this.pmi != null) {
                    this.pmi.jdbcOperationStarted();
                }
                n = this.pstmtImpl.executeUpdate();
                Object var4_3 = null;
                if (this.pmi == null) break block6;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var4_4 = null;
                    if (this.pmi != null) {
                        this.pmi.jdbcOperationCompleted();
                    }
                    if (!PmiReqMetrics.isEnabled()) break block7;
                    PmiReqMetrics.updateEnd((Object)object, (int)2, (int)0);
                }
                throw throwable;
            }
            this.pmi.jdbcOperationCompleted();
        }
        if (PmiReqMetrics.isEnabled()) {
            PmiReqMetrics.updateEnd((Object)object, (int)2, (int)0);
        }
        return n;
    }

    public void setArray(int n, Array array) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setArray #" + n));
        }
        try {
            this.pstmtImpl.setArray(n, array);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setArray", (String)"500", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setAsciiStream #" + n), (Object)new Integer(n2));
        }
        try {
            this.pstmtImpl.setAsciiStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setAsciiStream", (String)"522", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setBigDecimal #" + n));
        }
        try {
            this.pstmtImpl.setBigDecimal(n, bigDecimal);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setBigDecimal", (String)"544", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setBinaryStream #" + n), (Object)new Integer(n2));
        }
        try {
            this.pstmtImpl.setBinaryStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setBinaryStream", (String)"566", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setBlob #" + n));
        }
        try {
            this.pstmtImpl.setBlob(n, blob);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setBlob", (String)"588", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setBoolean #" + n));
        }
        try {
            this.pstmtImpl.setBoolean(n, bl);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setBoolean", (String)"610", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setByte(int n, byte by) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setByte #" + n));
        }
        try {
            this.pstmtImpl.setByte(n, by);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setByte", (String)"632", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setBytes #" + n));
        }
        try {
            this.internalHelper.psSetBytes(this.pstmtImpl, n, byArray);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setBytes", (String)"654", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            FFDCFilter.processException((Throwable)nullPointerException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setBytes", (String)"949", (Object)this);
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setCharacterStream #" + n), (Object)new Integer(n2));
        }
        try {
            this.pstmtImpl.setCharacterStream(n, reader, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setCharacterStream", (String)"677", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setClob(int n, Clob clob) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setClob #" + n));
        }
        try {
            this.pstmtImpl.setClob(n, clob);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setClob", (String)"699", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setDate(int n, Date date) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setDate #" + n));
        }
        try {
            this.pstmtImpl.setDate(n, date);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setDate", (String)"721", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setDate with Calendar #" + n));
        }
        try {
            this.pstmtImpl.setDate(n, date, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setDate", (String)"743", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setDouble(int n, double d) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setDouble #" + n));
        }
        try {
            this.pstmtImpl.setDouble(n, d);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setDouble", (String)"765", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setFloat(int n, float f) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setFloat #" + n));
        }
        try {
            this.pstmtImpl.setFloat(n, f);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setFloat", (String)"787", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setInt(int n, int n2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setInt #" + n));
        }
        try {
            this.pstmtImpl.setInt(n, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setInt", (String)"809", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setLong(int n, long l) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setLong #" + n));
        }
        try {
            this.pstmtImpl.setLong(n, l);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setLong", (String)"831", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setNull(int n, int n2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setNull #" + n), (Object)AdapterUtil.getSQLTypeString(n2));
        }
        try {
            this.pstmtImpl.setNull(n, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setNull", (String)"854", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setNull #" + n), (Object)new Object[]{AdapterUtil.getSQLTypeString(n2), string});
        }
        try {
            this.pstmtImpl.setNull(n, n2, string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setNull", (String)"877", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setObject(int n, Object object) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setObject #" + n));
        }
        try {
            this.pstmtImpl.setObject(n, object);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setObject", (String)"899", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setObject #" + n), (Object)new Integer(n2));
        }
        try {
            this.pstmtImpl.setObject(n, object, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setObject", (String)"921", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setObject #" + n), (Object)new Object[]{new Integer(n2), new Integer(n3)});
        }
        try {
            this.pstmtImpl.setObject(n, object, n2, n3);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setObject", (String)"944", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setRef(int n, Ref ref) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setRef #" + n));
        }
        try {
            this.pstmtImpl.setRef(n, ref);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setRef", (String)"966", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setShort(int n, short s) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setShort #" + n));
        }
        try {
            this.pstmtImpl.setShort(n, s);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setShort", (String)"988", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setString(int n, String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setString #" + n));
        }
        try {
            this.internalHelper.psSetString(this.pstmtImpl, n, string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setString", (String)"1010", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            FFDCFilter.processException((Throwable)nullPointerException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setString", (String)"1307", (Object)this);
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setTime(int n, Time time) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setTime #" + n));
        }
        try {
            this.pstmtImpl.setTime(n, time);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setTime", (String)"1032", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setTime with Calendar #" + n));
        }
        try {
            this.pstmtImpl.setTime(n, time, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setTime", (String)"1054", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setTimestamp #" + n));
        }
        try {
            this.pstmtImpl.setTimestamp(n, timestamp);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setTimestamp", (String)"1076", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setTimestamp with Calendar #" + n));
        }
        try {
            this.pstmtImpl.setTimestamp(n, timestamp, calendar);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setTimestamp", (String)"1098", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setUnicodeStream #" + n), (Object)new Integer(n2));
        }
        try {
            this.pstmtImpl.setUnicodeStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setUnicodeStream", (String)"1120", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public void setURL(int n, URL uRL) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setURL", (Object)new Integer(n));
        }
        try {
            this.pstmtImpl.setURL(n, uRL);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.setURL", (String)"1140", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getParameterMetaData", (Object)this);
        }
        ParameterMetaData parameterMetaData = null;
        try {
            parameterMetaData = this.pstmtImpl.getParameterMetaData();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement.getParameterMetaData", (String)"1442", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getParameterMetaData", (Object)"Exception, details in FFDC");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getParameterMetaData", (Object)"Exception, details in FFDC");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getParameterMetaData", (Object)parameterMetaData);
        }
        return parameterMetaData;
    }
}

