/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc;

import com.ibm.ejs.j2c.CMConfigData;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ce.cm.ObjectClosedException;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.websphere.correlation.CorrelationService;
import com.ibm.websphere.pmi.reqmetrics.PmiReqMetrics;
import com.ibm.websphere.rsadapter.DataStoreHelper;
import com.ibm.websphere.rsadapter.Reassociateable;
import com.ibm.websphere.rsadapter.WSConnection;
import com.ibm.websphere.rsadapter.WSSystemMonitor;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException;
import com.ibm.ws.rsadapter.jdbc.DataStoreHelperKeeper;
import com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement;
import com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData;
import com.ibm.ws.rsadapter.jdbc.WSJdbcObject;
import com.ibm.ws.rsadapter.jdbc.WSJdbcPreparedStatement;
import com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet;
import com.ibm.ws.rsadapter.jdbc.WSJdbcStatement;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import com.ibm.ws.rsadapter.spi.CSCacheKey;
import com.ibm.ws.rsadapter.spi.PSCacheKey;
import com.ibm.ws.rsadapter.spi.StatementCacheKey;
import com.ibm.ws.rsadapter.spi.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.spi.WSRdbManagedConnectionImpl;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LazyAssociatableConnectionManager;
import javax.resource.spi.LazyEnlistableConnectionManager;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.SharingViolationException;
import javax.security.auth.Subject;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;

public class WSJdbcConnection
extends WSJdbcObject
implements Reassociateable,
DataStoreHelperKeeper,
WSConnection {
    private static final TraceComponent tc = Tr.register((Class)WSJdbcConnection.class, (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    private static final TraceComponent clientInfoTc = Tr.register((String)"WAS.clientinfopluslogging", (String)"WAS.clientinfopluslogging", (String)"IBMDataStoreAdapterNLS");
    private static TraceComponent tempTc;
    private String[] currentClientInfo;
    private boolean clientInfoSetExplicitly;
    private Properties clientProps;
    Connection connImpl;
    DataStoreHelper helper;
    WSRdbManagedConnectionImpl managedConn;
    WSManagedConnectionFactoryImpl mcf;
    ConnectionManager cm;
    private LazyEnlistableConnectionManager lazyEnlistableCM;
    private LazyAssociatableConnectionManager lazyAssociatableCM;
    boolean isReserved;
    Object managedConnKey;
    Subject subject;
    ConnectionRequestInfo connRequestInfo;
    boolean autoCommit;
    boolean rrsTransactional;
    boolean detectMultithreadedAccess;
    Object threadID;
    boolean isResultSetClosedAtCommit;
    int currentTransactionIsolation = 2;
    boolean supportIsolvlSwitching = false;

    WSJdbcConnection() {
    }

    public WSJdbcConnection(WSRdbManagedConnectionImpl wSRdbManagedConnectionImpl, Connection connection, Object object, Object object2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{wSRdbManagedConnectionImpl, AdapterUtil.toString(connection)});
        }
        this.managedConn = wSRdbManagedConnectionImpl;
        this.connImpl = connection;
        this.managedConnKey = object;
        this.threadID = object2;
        this.detectMultithreadedAccess = this.threadID != null;
        this.mcf = this.managedConn.getManagedConnectionFactory();
        this.helper = this.mcf.getDataStoreHelper();
        this.supportIsolvlSwitching = this.mcf.getInternalDataStoreHelper().isIsolationLevelSwitchingSupport();
        this.pmi = this.mcf.getPMI();
        this.rrsTransactional = this.mcf.getRRSTransactional();
        this.autoCommit = this.managedConn.getTransactionState() == 1 && !this.managedConn.inGlobalTransaction() ? false : this.managedConn.getDefaultAutoCommit();
        this.childWrappers = new ArrayList(8);
        this.currentTransactionIsolation = this.managedConn.getTransactionIsolation();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    final Connection initialize(ConnectionManager connectionManager) throws SQLException {
        this.cm = connectionManager;
        if (this.state != 1) {
            this.connImpl.clearWarnings();
        }
        return this;
    }

    public Connection initialize(ConnectionManager connectionManager, Object object) throws ResourceException, SQLException {
        if (this.managedConnKey == null) {
            throw AdapterUtil.createDataStoreAdapterException("OBJECT_CLOSED", "Connection", null, WSJdbcConnection.class);
        }
        if (object != this.managedConnKey) {
            throw AdapterUtil.createDataStoreAdapterException("NOT_A_JDBC_METHOD", null, null, WSJdbcConnection.class);
        }
        return this.initialize(connectionManager);
    }

    private void beginLocalTransactionIfNecessary() throws SQLException {
        if (this.managedConn.isMCStale()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"MC is stale", (Object)this.managedConn);
            }
            throw new StaleConnectionException(AdapterUtil.getNLSMessage("INVALID_CONNECTION"));
        }
        if (this.autoCommit) {
            return;
        }
        try {
            this.managedConn.processLocalTransactionStartedEvent(this);
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, (String)(WSJdbcConnection.class.getName() + ".beginLocalTransactionIfNecessary"), (String)"343", (Object)this);
            throw AdapterUtil.toSQLException(resourceException);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Local transaction started for " + this));
        }
    }

    void beginTransactionIfNecessary() throws SQLException {
        boolean bl = false;
        boolean bl2 = false;
        if (this.managedConn.isMCStale()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"MC is stale", (Object)this.managedConn);
            }
            throw new StaleConnectionException(AdapterUtil.getNLSMessage("INVALID_CONNECTION"));
        }
        if (this.detectMultithreadedAccess) {
            this.detectMultithreadedAccess();
        }
        if (this.supportIsolvlSwitching) {
            this.managedConn.setTransactionIsolation(this.currentTransactionIsolation);
        }
        if (this.managedConn.isEnlistmentDisabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"beginTransactionIfNecessary: no-op enlistment is disabled");
            }
            return;
        }
        switch (this.managedConn.getTransactionState()) {
            case 2: 
            case 7: {
                bl = true;
            }
            case 1: {
                if (!tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)"Transaction is active.");
                break;
            }
            case 0: {
                if (WSManagedConnectionFactoryImpl.locationRestrictedFunction.inGlobalTransaction()) {
                    try {
                        this.managedConn.lazyEnlist(this.lazyEnlistableCM == null ? (this.lazyEnlistableCM = (LazyEnlistableConnectionManager)this.cm) : this.lazyEnlistableCM);
                        bl = this.managedConn.getTransactionState() == 2;
                        break;
                    }
                    catch (ClassCastException classCastException) {
                        bl2 = true;
                        this.beginLocalTransactionIfNecessary();
                        break;
                    }
                    catch (ResourceException resourceException) {
                        SystemException systemException;
                        FFDCFilter.processException((Throwable)resourceException, (String)(WSJdbcConnection.class.getName() + ".beginTransactionIfNecessary"), (String)"324", (Object)this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Error during lazy enlistment.", (Object)((Object)resourceException));
                        }
                        if (resourceException.getCause() instanceof SystemException && (systemException = (SystemException)resourceException.getCause()).getCause() != null && systemException.getCause() instanceof XAException) {
                            XAException xAException = (XAException)systemException.getCause();
                            if (xAException.errorCode == -7) {
                                this.fireConnectionErrorEvent(xAException);
                                StaleConnectionException staleConnectionException = new StaleConnectionException(resourceException.getMessage());
                                staleConnectionException.initCause((Throwable)xAException);
                                throw staleConnectionException;
                            }
                        }
                        throw AdapterUtil.toSQLException(resourceException);
                    }
                }
                bl2 = true;
                this.beginLocalTransactionIfNecessary();
                break;
            }
            default: {
                throw new SQLException(AdapterUtil.getNLSMessage("INVALID_TRAN_STATE", this.managedConn.getTransactionStateAsString()));
            }
        }
        if (bl2) {
            this.managedConn.enforceAutoCommit(this.autoCommit);
        }
    }

    public final void clearWarnings() throws SQLException {
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            this.connImpl.clearWarnings();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.clearWarnings", (String)"395", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    SQLException closeWrapper(boolean bl) {
        SQLException sQLException;
        block5: {
            sQLException = null;
            if (this.managedConn != null) {
                try {
                    this.managedConn.processConnectionClosedEvent(this);
                }
                catch (ResourceException resourceException) {
                    FFDCFilter.processException((Throwable)resourceException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.close", (String)"495", (Object)this);
                    if (sQLException == null) {
                        sQLException = AdapterUtil.toSQLException(resourceException);
                        break block5;
                    }
                    Tr.warning((TraceComponent)tc, (String)"DSA_INTERNAL_ERR_WARNING", (Object)new Object[]{"An unexpected error occurred sending a connectionClosed event" + System.getProperty("line.separator"), resourceException});
                }
            } else {
                WSManagedConnectionFactoryImpl.locationRestrictedFunction.inactiveConnectionClosed(this, this.cm);
            }
        }
        this.connImpl = null;
        this.childWrappers = null;
        this.managedConn = null;
        this.managedConnKey = null;
        this.connRequestInfo = null;
        this.subject = null;
        this.mcf = null;
        this.cm = null;
        this.pmi = null;
        this.helper = null;
        this.threadID = null;
        this.clientProps = null;
        return sQLException;
    }

    public void commit() throws SQLException {
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry((TraceComponent)tempTc, (String)"commit", (Object)this);
        }
        if (this.managedConn != null && this.managedConn.isMCStale()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"MC is stale", (Object)this.managedConn);
            }
            throw new StaleConnectionException(AdapterUtil.getNLSMessage("INVALID_CONNECTION"));
        }
        if (this.detectMultithreadedAccess) {
            this.detectMultithreadedAccess();
        }
        if (this.state == 1) {
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit((TraceComponent)tempTc, (String)"commit", (Object)"no-op; state is INACTIVE");
            }
            return;
        }
        try {
            if (this.managedConn.isEnlistmentDisabled()) {
                this.connImpl.commit();
                if (this.isResultSetClosedAtCommit) {
                    for (int i = this.childWrappers.size() - 1; i > -1; --i) {
                        ((WSJdbcStatement)this.childWrappers.get(i)).closeResultSetsIfNecessary();
                    }
                }
                if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                    tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                    Tr.exit((TraceComponent)tempTc, (String)"commit", (Object)"Enlistment is disabled");
                }
                return;
            }
            if (this.managedConn.inGlobalTransaction()) {
                SQLException sQLException = new SQLException(AdapterUtil.getNLSMessage("OP_NOT_VALID_IN_GT", "Connection.commit"));
                if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                    tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                    Tr.exit((TraceComponent)tempTc, (String)"commit", (Object)sQLException);
                }
                throw sQLException;
            }
            if (this.managedConn.getTransactionState() == 1) {
                this.managedConn.processLocalTransactionCommittedEvent(this);
                if (this.isResultSetClosedAtCommit) {
                    for (int i = this.childWrappers.size() - 1; i > -1; --i) {
                        ((WSJdbcStatement)this.childWrappers.get(i)).closeResultSetsIfNecessary();
                    }
                }
            } else {
                this.connImpl.commit();
            }
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.commit", (String)"776", (Object)this);
            SQLException sQLException = AdapterUtil.toSQLException(resourceException);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit((TraceComponent)tempTc, (String)"commit", (Object)"Exception");
            }
            throw sQLException;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)(this.getClass().getName() + ".commit"), (String)"587", (Object)this);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit((TraceComponent)tempTc, (String)"commit", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit((TraceComponent)tempTc, (String)"commit", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit((TraceComponent)tempTc, (String)"commit");
        }
    }

    CallableStatement createCallableStatementWrapper(CallableStatement callableStatement, int n) throws SQLException {
        this.isResultSetClosedAtCommit = this.isResultSetClosedAtCommit || n == 2;
        WSJdbcCallableStatement wSJdbcCallableStatement = new WSJdbcCallableStatement(callableStatement, this, n);
        wSJdbcCallableStatement.setInternalHelper(this.mcf.getInternalDataStoreHelper());
        return wSJdbcCallableStatement;
    }

    CallableStatement createCallableStatementWrapper(CallableStatement callableStatement, int n, StatementCacheKey statementCacheKey) throws SQLException {
        this.isResultSetClosedAtCommit = this.isResultSetClosedAtCommit || n == 2;
        WSJdbcCallableStatement wSJdbcCallableStatement = new WSJdbcCallableStatement(callableStatement, this, n, statementCacheKey);
        wSJdbcCallableStatement.setInternalHelper(this.mcf.getInternalDataStoreHelper());
        return wSJdbcCallableStatement;
    }

    PreparedStatement createPreparedStatementWrapper(PreparedStatement preparedStatement, int n) throws SQLException {
        this.isResultSetClosedAtCommit = this.isResultSetClosedAtCommit || n == 2;
        WSJdbcPreparedStatement wSJdbcPreparedStatement = new WSJdbcPreparedStatement(preparedStatement, this, n);
        wSJdbcPreparedStatement.setInternalHelper(this.mcf.getInternalDataStoreHelper());
        return wSJdbcPreparedStatement;
    }

    PreparedStatement createPreparedStatementWrapper(PreparedStatement preparedStatement, int n, StatementCacheKey statementCacheKey) throws SQLException {
        this.isResultSetClosedAtCommit = this.isResultSetClosedAtCommit || n == 2;
        WSJdbcPreparedStatement wSJdbcPreparedStatement = new WSJdbcPreparedStatement(preparedStatement, this, n, statementCacheKey);
        wSJdbcPreparedStatement.setInternalHelper(this.mcf.getInternalDataStoreHelper());
        return wSJdbcPreparedStatement;
    }

    WSJdbcResultSet createResultSetWrapper(ResultSet resultSet, WSJdbcObject wSJdbcObject) {
        return new WSJdbcResultSet(resultSet, wSJdbcObject);
    }

    SQLException createSharingException(String string) {
        String string2 = AdapterUtil.getNLSMessage("OP_NOT_SHAREABLE", string);
        SQLException sQLException = new SQLException(string2);
        sQLException.initCause((Throwable)new SharingViolationException(string2));
        return sQLException;
    }

    public final Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    public final Statement createStatement(int n, int n2) throws SQLException {
        Statement statement;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createStatement", (Object)new Object[]{this, AdapterUtil.getResultSetTypeString(n), AdapterUtil.getConcurrencyModeString(n2)});
        }
        try {
            if (this.state == 1) {
                this.reactivate();
            }
            this.beginTransactionIfNecessary();
            statement = this.connImpl.createStatement(n, n2);
            statement = this.createStatementWrapper(statement, this.managedConn.getCurrentHoldability());
            this.childWrappers.add(statement);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.createStatement", (String)"865", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createStatement", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createStatement", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createStatement", (Object)statement);
        }
        return statement;
    }

    Statement createStatementWrapper(Statement statement, int n) throws SQLException {
        this.isResultSetClosedAtCommit = this.isResultSetClosedAtCommit || n == 2;
        return new WSJdbcStatement(statement, this, n);
    }

    final void detectMultithreadedAccess() {
        Thread thread = Thread.currentThread();
        if (thread != this.threadID) {
            this.mcf.detectedMultithreadedAccess = true;
            StringWriter stringWriter = new StringWriter();
            new Error().printStackTrace(new PrintWriter(stringWriter));
            Tr.warning((TraceComponent)tc, (String)"MULTITHREADED_ACCESS_DETECTED", (Object)new Object[]{this, Integer.toHexString(this.threadID.hashCode()) + ' ' + this.threadID, Integer.toHexString(thread.hashCode()) + ' ' + thread, stringWriter.getBuffer().delete(0, "java.lang.Error".length())});
        }
    }

    public void dissociate() throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"dissociate", (Object)this);
        }
        switch (this.state) {
            case 0: {
                break;
            }
            case 1: {
                if (this.isReserved) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Unreserving handle for dissociation", (Object)this);
                    }
                    this.isReserved = false;
                    break;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"dissociate", (Object)"Already dissociated.");
                }
                return;
            }
            case 2: {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"dissociate", (Object)"Exception");
                }
                throw AdapterUtil.createDataStoreAdapterException("OBJECT_CLOSED", "Connection", null, WSJdbcConnection.class);
            }
        }
        this.closeChildWrappers();
        this.connRequestInfo = this.managedConn.createConnectionRequestInfo();
        this.subject = this.managedConn.getSubject();
        if (this.managedConn.clientInfoExplicitlySet || this.managedConn.clientInfoImplicitlySet) {
            this.currentClientInfo = this.managedConn.getCurrentClientInfo();
            this.clientInfoSetExplicitly = this.managedConn.clientInfoExplicitlySet;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"clientProps saved from mc is:", (Object)this.currentClientInfo);
            }
        }
        this.managedConn.dissociateHandle(this);
        this.connImpl = null;
        this.managedConn = null;
        this.state = 1;
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"state --> INACTIVE");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"dissociate");
        }
    }

    public void fireConnectionErrorEvent(Exception exception) {
        switch (this.state) {
            case 0: {
                try {
                    this.managedConn.processConnectionErrorOccurredEvent(this, exception);
                }
                catch (NullPointerException nullPointerException) {
                    if (!tc.isEventEnabled()) break;
                    Tr.event((TraceComponent)tc, (String)"Handle CLOSED or INACTIVE. Not sending CONNECTION_ERROR_OCCURRED.", (Object)this);
                }
                break;
            }
            case 1: {
                try {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Handle is INACTIVE. Not sending CONNECTION_ERROR_OCCURRED.", (Object)this);
                    }
                    this.close();
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.FireConnectionErrorEvent", (String)"965", (Object)this);
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)"Error closing connection:", (Object)sQLException);
                }
                break;
            }
            case 2: {
                if (!tc.isEventEnabled()) break;
                Tr.event((TraceComponent)tc, (String)"Connection already closed. Not sending CONNECTION_ERROR_OCCURRED.", (Object)this);
            }
        }
    }

    public final boolean getAutoCommit() throws SQLException {
        if (this.state == 1) {
            this.reactivate();
        }
        if (this.rrsTransactional) {
            UOWCoordinator uOWCoordinator;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"MCF is rrsTransactional - check for Global");
            }
            if ((uOWCoordinator = TransactionManagerFactory.getUOWCurrent().getUOWCoord()) != null && uOWCoordinator.isGlobal()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"RRSGlobalTran active - return autoCommit=false");
                }
                return false;
            }
        }
        return this.autoCommit;
    }

    public ManagedConnection getManagedConnection(Object object) throws ResourceException {
        if (this.managedConnKey == null) {
            throw AdapterUtil.createDataStoreAdapterException("OBJECT_CLOSED", "Connection", null, WSJdbcConnection.class);
        }
        if (object != this.managedConnKey) {
            throw AdapterUtil.createDataStoreAdapterException("NOT_A_JDBC_METHOD", null, null, WSJdbcConnection.class);
        }
        return this.managedConn;
    }

    public final String getCatalog() throws SQLException {
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            return this.managedConn.getCatalog();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.getCatalog", (String)"917", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    final WSJdbcObject getConnectionWrapper() {
        return this;
    }

    public final DataStoreHelper getHelper() {
        return this.helper;
    }

    final Object getJDBCImplObject() {
        return this.connImpl;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getMetaData", (Object)this);
        }
        try {
            if (this.state == 1) {
                this.reactivate();
            }
            this.beginTransactionIfNecessary();
            this.childWrapper = this.childWrapper == null ? new WSJdbcDatabaseMetaData(this.connImpl.getMetaData(), this) : this.childWrapper;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.getMetaData", (String)"922", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getMetaData", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getMetaData", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getMetaData", (Object)this.childWrapper);
        }
        return (WSJdbcDatabaseMetaData)this.childWrapper;
    }

    TraceComponent getTracer() {
        return tc;
    }

    public final int getTransactionIsolation() throws SQLException {
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            return this.managedConn.getTransactionIsolation();
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final Map getTypeMap() throws SQLException {
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            return this.managedConn.getTypeMap();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.getTypeMap", (String)"927", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final SQLWarning getWarnings() throws SQLException {
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            return this.connImpl.getWarnings();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.getWarnings", (String)"991", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public String[] introspectSelf() {
        FFDCLogger fFDCLogger = new FFDCLogger(500, this);
        this.introspectAll(fFDCLogger);
        fFDCLogger.eoln();
        fFDCLogger.introspect("ConnectionRequestInfo:", this.connRequestInfo);
        fFDCLogger.introspect("ManagedConnectionFactory:", this.mcf);
        fFDCLogger.introspect("ManagedConnection:", this.managedConn);
        return fFDCLogger.toStringArray();
    }

    void introspectWrapperSpecificInfo(FFDCLogger fFDCLogger) {
        fFDCLogger.append("Transaction Manager global transaction status is", AdapterUtil.getGlobalTranStatusAsString());
        fFDCLogger.append("Underlying Connection: " + AdapterUtil.toString(this.connImpl), this.connImpl);
        fFDCLogger.append("Key Object:", this.managedConnKey);
        fFDCLogger.append("DataStoreHelper:", this.helper);
        fFDCLogger.introspect("Connection Manager:", this.cm);
        fFDCLogger.append("ConnectionManager supports lazy association?", this.cm instanceof LazyAssociatableConnectionManager ? Boolean.TRUE : Boolean.FALSE);
        fFDCLogger.append("ConnectionManager supports lazy enlistment?", this.cm instanceof LazyEnlistableConnectionManager ? Boolean.TRUE : Boolean.FALSE);
        fFDCLogger.append("Handle is reserved? " + this.isReserved);
        fFDCLogger.append("AutoCommit value tracked by handle: " + this.autoCommit);
        fFDCLogger.append("Detection of multithreaded access is:", this.detectMultithreadedAccess ? "ENABLED" : "DISABLED");
        fFDCLogger.append("Thread id:", this.threadID);
    }

    public final boolean isClosed() {
        return this.state == 2;
    }

    public final boolean isReadOnly() throws SQLException {
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            return this.managedConn.isReadOnly();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.isReadOnly", (String)"996", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final boolean isReserved() {
        return this.isReserved;
    }

    public boolean isShareable() throws SQLException {
        try {
            CMConfigData cMConfigData = WSManagedConnectionFactoryImpl.locationRestrictedFunction.getCMConfigData(this.cm);
            return cMConfigData != null && cMConfigData.isShareable();
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final String nativeSQL(String string) throws SQLException {
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            return this.connImpl.nativeSQL(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.nativeSQL", (String)"1079", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CallableStatement pmiPrepareCall(String string, int n, int n2) throws SQLException {
        try {
            this.pmi.jdbcOperationStarted();
            CallableStatement callableStatement = this.connImpl.prepareCall(string, n, n2);
            return callableStatement;
        }
        finally {
            this.pmi.jdbcOperationCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement pmiPrepareStatement(String string, int n, int n2) throws SQLException {
        try {
            this.pmi.jdbcOperationStarted();
            PreparedStatement preparedStatement = this.connImpl.prepareStatement(string, n, n2);
            return preparedStatement;
        }
        finally {
            this.pmi.jdbcOperationCompleted();
        }
    }

    public final CallableStatement prepareCall(String string) throws SQLException {
        return this.prepareCall(string, 1003, 1007);
    }

    public final CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        CallableStatement callableStatement;
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry((TraceComponent)tempTc, (String)"prepareCall", (Object)new Object[]{this, string, AdapterUtil.getResultSetTypeString(n), AdapterUtil.getConcurrencyModeString(n2)});
        }
        try {
            if (this.state == 1) {
                this.reactivate();
            }
            if (this.managedConn.isStatementCachingEnabled()) {
                CSCacheKey cSCacheKey = new CSCacheKey(string, n, n2, this.managedConn.getCurrentHoldability(), this.helper.getMetaData().doesStatementCacheIsoLevel() ? this.currentTransactionIsolation : 0);
                this.beginTransactionIfNecessary();
                Object object = this.managedConn.getStatement(cSCacheKey);
                callableStatement = object == null ? (callableStatement = this.pmi == null ? this.connImpl.prepareCall(string, n, n2) : this.pmiPrepareCall(string, n, n2)) : (CallableStatement)object;
                callableStatement = this.createCallableStatementWrapper(callableStatement, this.managedConn.getCurrentHoldability(), cSCacheKey);
            } else {
                this.beginTransactionIfNecessary();
                callableStatement = this.pmi == null ? this.connImpl.prepareCall(string, n, n2) : this.pmiPrepareCall(string, n, n2);
                callableStatement = this.createCallableStatementWrapper(callableStatement, this.managedConn.getCurrentHoldability());
            }
            this.childWrappers.add(callableStatement);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.prepareCall", (String)"1523", (Object)this);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit((TraceComponent)tempTc, (String)"prepareCall", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit((TraceComponent)tempTc, (String)"prepareCall", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit((TraceComponent)tempTc, (String)"prepareCall", (Object)callableStatement);
        }
        return callableStatement;
    }

    public final PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1003, 1007);
    }

    public final PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        PreparedStatement preparedStatement;
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry((TraceComponent)tempTc, (String)"prepareStatement", (Object)new Object[]{this, string, AdapterUtil.getResultSetTypeString(n), AdapterUtil.getConcurrencyModeString(n2)});
        }
        try {
            if (this.state == 1) {
                this.reactivate();
            }
            if (this.managedConn.isStatementCachingEnabled()) {
                PSCacheKey pSCacheKey = new PSCacheKey(string, n, n2, this.managedConn.getCurrentHoldability(), 0, this.mcf.getDataStoreHelper().getMetaData().doesStatementCacheIsoLevel() ? this.currentTransactionIsolation : 0);
                this.beginTransactionIfNecessary();
                Object object = this.managedConn.getStatement(pSCacheKey);
                preparedStatement = object == null ? (this.pmi == null ? this.connImpl.prepareStatement(string, n, n2) : this.pmiPrepareStatement(string, n, n2)) : this.resetStatement((PreparedStatement)object);
                preparedStatement = this.createPreparedStatementWrapper(preparedStatement, this.managedConn.getCurrentHoldability(), pSCacheKey);
            } else {
                this.beginTransactionIfNecessary();
                preparedStatement = this.pmi == null ? this.connImpl.prepareStatement(string, n, n2) : this.pmiPrepareStatement(string, n, n2);
                preparedStatement = this.createPreparedStatementWrapper(preparedStatement, this.managedConn.getCurrentHoldability());
            }
            this.childWrappers.add(preparedStatement);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.prepareStatement", (String)"1584", (Object)this);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit((TraceComponent)tempTc, (String)"prepareStatement", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit((TraceComponent)tempTc, (String)"prepareStatement", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit((TraceComponent)tempTc, (String)"prepareStatement", (Object)preparedStatement);
        }
        return preparedStatement;
    }

    final void reactivate() throws SQLException {
        if (this.state != 1) {
            return;
        }
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Requesting implicit reactivation.");
        }
        try {
            this.lazyAssociatableCM = this.lazyAssociatableCM == null ? (LazyAssociatableConnectionManager)this.cm : this.lazyAssociatableCM;
            this.lazyAssociatableCM.associateConnection((Object)this, (ManagedConnectionFactory)this.mcf, this.connRequestInfo);
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.reactivate", (String)"1625", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"REASSOCIATION_ERR", (Object)((Object)resourceException));
            throw AdapterUtil.toSQLException(resourceException);
        }
    }

    public void reassociate(ManagedConnection managedConnection, Connection connection, Object object) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reassociate", (Object)new Object[]{this, managedConnection, AdapterUtil.toString(connection)});
        }
        if (this.managedConnKey == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"reassociate", (Object)"Exception");
            }
            throw AdapterUtil.createDataStoreAdapterException("OBJECT_CLOSED", "Connection", null, WSJdbcConnection.class);
        }
        if (object != this.managedConnKey) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"reassociate", (Object)"Exception");
            }
            throw AdapterUtil.createDataStoreAdapterException("NOT_A_JDBC_METHOD", null, null, WSJdbcConnection.class);
        }
        if (this.isReserved) {
            if (managedConnection != this.managedConn) {
                String string = "Connection handle is reserved for reassociation with a specific ManagedConnection, which does not match the ManagedConnection provided.";
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)string, (Object)new Object[]{this, this.managedConn, managedConnection});
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"reassociate", (Object)"Exception");
                }
                throw AdapterUtil.createDataStoreAdapterException("WS_INTERNAL_ERROR", new Object[]{string, " See trace for more details."}, null, WSJdbcConnection.class);
            }
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Handle is reserved, reassociating back to original ManagedConnection.");
            }
            this.isReserved = false;
            this.state = 0;
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"state --> ACTIVE");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"reassociate");
            }
            return;
        }
        if (this.state != 1) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"reassociate", (Object)"Exception");
            }
            throw AdapterUtil.createDataStoreAdapterException("CANNOT_REASSOCIATE", this.getStateString(), null, WSJdbcConnection.class);
        }
        if (this.childWrapper != null || this.childWrappers != null && this.childWrappers.size() > 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"reassociate", (Object)"Exception");
            }
            throw AdapterUtil.createDataStoreAdapterException("CHILDREN_STILL_OPEN", null, null, WSJdbcConnection.class);
        }
        this.managedConn = (WSRdbManagedConnectionImpl)managedConnection;
        this.connImpl = connection;
        this.connRequestInfo = null;
        this.subject = null;
        if (this.currentClientInfo != null) {
            try {
                this.mcf.getInternalDataStoreHelper().setClientInformationArray(this.currentClientInfo, this.managedConn, this.clientInfoSetExplicitly);
                this.currentClientInfo = null;
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)(WSJdbcConnection.class.getName() + ".reassociate()"), (String)"1781", (Object)this);
                throw new DataStoreAdapterException("DSA_ERROR", sQLException, WSJdbcConnection.class);
            }
        }
        if (PmiReqMetrics.isPassCorrelatorToDB() && this.managedConn.getStateManager().getState() == 0) {
            this.mcf.getInternalDataStoreHelper().setEwlmCorrelator(CorrelationService.getEwlmCorrelator(), this.managedConn);
        }
        this.state = 0;
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"state --> ACTIVE");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"reassociate");
        }
    }

    public void reserve(Object object) throws ResourceException {
        if (this.managedConnKey == null) {
            throw AdapterUtil.createDataStoreAdapterException("OBJECT_CLOSED", "Connection", null, WSJdbcConnection.class);
        }
        if (object != this.managedConnKey) {
            throw AdapterUtil.createDataStoreAdapterException("NOT_A_JDBC_METHOD", null, null, WSJdbcConnection.class);
        }
        this.isReserved = true;
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Reserving handle", (Object)this);
        }
        this.state = 1;
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"state --> INACTIVE");
        }
    }

    final CallableStatement resetStatement(CallableStatement callableStatement) throws SQLException {
        callableStatement.clearParameters();
        return callableStatement;
    }

    final PreparedStatement resetStatement(PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.clearParameters();
        return preparedStatement;
    }

    public void rollback() throws SQLException {
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry((TraceComponent)tempTc, (String)"rollback", (Object)this);
        }
        try {
            if (this.managedConn != null && this.managedConn.isMCStale()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"MC is stale", (Object)this.managedConn);
                }
                throw new StaleConnectionException(AdapterUtil.getNLSMessage("INVALID_CONNECTION"));
            }
            if (this.detectMultithreadedAccess) {
                this.detectMultithreadedAccess();
            }
            if (this.state == 1) {
                if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                    tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                    Tr.exit((TraceComponent)tempTc, (String)"rollback", (Object)"no-op; state is INACTIVE");
                }
                return;
            }
            if (this.managedConn.isEnlistmentDisabled()) {
                this.connImpl.rollback();
                for (int i = this.childWrappers.size() - 1; i > -1; --i) {
                    ((WSJdbcStatement)this.childWrappers.get(i)).closeChildWrappers();
                }
                if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                    tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                    Tr.exit((TraceComponent)tempTc, (String)"rollback", (Object)"Enlistment is disabled");
                }
                return;
            }
            if (this.managedConn.inGlobalTransaction()) {
                SQLException sQLException = new SQLException(AdapterUtil.getNLSMessage("OP_NOT_VALID_IN_GT", "Connection.rollback"));
                if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                    tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                    Tr.exit((TraceComponent)tempTc, (String)"rollback", (Object)sQLException);
                }
                throw sQLException;
            }
            if (this.managedConn.getTransactionState() == 1) {
                this.managedConn.processLocalTransactionRolledbackEvent(this);
                for (int i = this.childWrappers.size() - 1; i > -1; --i) {
                    ((WSJdbcStatement)this.childWrappers.get(i)).closeChildWrappers();
                }
            } else {
                this.connImpl.rollback();
            }
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.rollback", (String)"2001", (Object)this);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit((TraceComponent)tempTc, (String)"rollback", (Object)"Exception");
            }
            throw AdapterUtil.toSQLException(resourceException);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)(this.getClass().getName() + ".rollback"), (String)"1860", (Object)this);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit((TraceComponent)tempTc, (String)"rollback", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit((TraceComponent)tempTc, (String)"rollback", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit((TraceComponent)tempTc, (String)"rollback");
        }
    }

    final RuntimeException runtimeXIfNotClosed(RuntimeException runtimeException) throws SQLException {
        switch (this.state) {
            case 1: {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Connection dissociated on another thread while performing an operation. Closing the Connection handle.");
                }
                this.close();
            }
            case 2: {
                throw new ObjectClosedException(AdapterUtil.getNLSMessage("OBJECT_CLOSED", "Connection"));
            }
        }
        return runtimeException;
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setAutoCommit requested by application.");
        }
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            if (this.managedConn.getHandleCount() > 1 && bl != this.managedConn.getAutoCommit()) {
                throw this.createSharingException("setAutoCommit");
            }
            if (this.managedConn.getTransactionState() == 0) {
                this.managedConn.setAutoCommit(bl);
                this.autoCommit = bl;
            } else if (this.managedConn.inGlobalTransaction()) {
                if (bl) {
                    throw new SQLException(AdapterUtil.getNLSMessage("OP_NOT_VALID_IN_GT", "setAutoCommit"));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"setAutoCommit(false) requested during a global transaction.");
                }
                this.managedConn.setAutoCommit(bl);
                this.autoCommit = bl;
            } else {
                if (bl) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"setAutoCommit(true) requested during local transaction; implicitly committing the transaction.");
                    }
                    this.commit();
                }
                this.managedConn.setAutoCommit(bl);
                this.autoCommit = bl;
            }
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.setAutoCommit", (String)"2006", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void setCatalog(String string) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setCatalog", (Object)new Object[]{this, string});
        }
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            if (this.managedConn.getHandleCount() > 1 && !AdapterUtil.match(string, this.managedConn.getCatalog())) {
                throw this.createSharingException("setCatalog");
            }
            this.managedConn.setCatalog(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.setCatalog", (String)"2011", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void setReadOnly(boolean bl) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setReadOnly", (Object)new Object[]{this, bl ? Boolean.TRUE : Boolean.FALSE});
        }
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            if (this.managedConn.getHandleCount() > 1 && bl != this.managedConn.isReadOnly()) {
                throw this.createSharingException("setReadOnly");
            }
            this.mcf.getInternalDataStoreHelper().setReadOnly(this.managedConn, bl);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.setReadOnly", (String)"2016", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void setTransactionIsolation(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setTransactionIsolation requested by application.");
        }
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            if (this.managedConn.getHandleCount() > 1 && n != this.managedConn.getTransactionIsolation()) {
                throw this.createSharingException("setTransactionIsolation");
            }
            this.managedConn.setTransactionIsolation(n);
            this.currentTransactionIsolation = n;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.setTransactionIsolation", (String)"2021", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final void setTypeMap(Map map) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setTypeMap", (Object)new Object[]{this, map});
        }
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            if (this.managedConn.getHandleCount() > 1) {
                throw this.createSharingException("setTypeMap");
            }
            this.managedConn.setTypeMap(map);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.setTypeMap", (String)"2026", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public boolean supportsImplicitReactivation() {
        return true;
    }

    public ConnectionRequestInfo getCRI() {
        return this.connRequestInfo;
    }

    public void setHoldability(int n) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setHoldability requested by application.");
        }
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            if (this.managedConn.getHandleCount() > 1 && n != this.managedConn.getHoldability()) {
                throw this.createSharingException("setHoldability");
            }
            this.managedConn.setHoldability(n);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.setHoldability", (String)"2031", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public int getHoldability() throws SQLException {
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            return this.managedConn.getHoldability();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.getHoldability", (String)"2055", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setSavepoint", (Object)this);
        }
        if (this.state == 1) {
            this.reactivate();
        }
        Savepoint savepoint = null;
        try {
            if (this.managedConn.inGlobalTransaction()) {
                Tr.error((TraceComponent)tc, (String)"OP_NOT_VALID_IN_GT", (Object)"setSavepoint");
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"setSavepoint", (Object)"Exception");
                }
                throw new SQLException(AdapterUtil.getNLSMessage("OP_NOT_VALID_IN_GT", "setSavepoint"));
            }
            savepoint = this.connImpl.setSavepoint();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.setSavepoint", (String)"2082", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setSavepoint", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setSavepoint", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setSavepoint", (Object)savepoint);
        }
        return savepoint;
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setSavepoint", (Object)new Object[]{this, string});
        }
        if (this.state == 1) {
            this.reactivate();
        }
        Savepoint savepoint = null;
        try {
            if (this.managedConn.inGlobalTransaction()) {
                Tr.error((TraceComponent)tc, (String)"OP_NOT_VALID_IN_GT", (Object)"setSavepoint");
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"setSavepoint", (Object)"Exception");
                }
                throw new SQLException(AdapterUtil.getNLSMessage("OP_NOT_VALID_IN_GT", "setSavepoint"));
            }
            savepoint = this.connImpl.setSavepoint(string);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.setSavepoint(String)", (String)"2116", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setSavepoint", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setSavepoint", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setSavepoint", (Object)savepoint);
        }
        return savepoint;
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry((TraceComponent)tempTc, (String)"rollback", (Object)new Object[]{this, savepoint});
        }
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            if (this.managedConn.inGlobalTransaction()) {
                Tr.error((TraceComponent)tc, (String)"OP_NOT_VALID_IN_GT", (Object)"rollback");
                if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                    tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                    Tr.exit((TraceComponent)tempTc, (String)"rollback", (Object)"Exception");
                }
                throw new SQLException(AdapterUtil.getNLSMessage("OP_NOT_VALID_IN_GT", "rollback"));
            }
            this.connImpl.rollback(savepoint);
            for (int i = this.childWrappers.size() - 1; i > -1; --i) {
                ((WSJdbcStatement)this.childWrappers.get(i)).closeChildWrappers();
            }
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.rollback(Savepoint)", (String)"2141", (Object)this);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit((TraceComponent)tempTc, (String)"rollback", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit((TraceComponent)tempTc, (String)"rollback", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit((TraceComponent)tempTc, (String)"rollback");
        }
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"releaseSavepoint", (Object)new Object[]{this, savepoint});
        }
        if (this.state == 1) {
            this.reactivate();
        }
        try {
            if (this.managedConn.inGlobalTransaction()) {
                Tr.error((TraceComponent)tc, (String)"OP_NOT_VALID_IN_GT", (Object)"releaseSavepoint");
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"releaseSavepoint", (Object)"Exception");
                }
                throw new SQLException(AdapterUtil.getNLSMessage("OP_NOT_VALID_IN_GT", "releaseSavepoint"));
            }
            this.connImpl.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.releaseSavepoint", (String)"2169", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"releaseSavepoint", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"releaseSavepoint", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"releaseSavepoint");
        }
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        Statement statement;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createStatement", (Object)new Object[]{this, AdapterUtil.getResultSetTypeString(n), AdapterUtil.getConcurrencyModeString(n2), AdapterUtil.getCursorHoldabilityString(n3)});
        }
        try {
            if (this.state == 1) {
                this.reactivate();
            }
            this.beginTransactionIfNecessary();
            statement = this.connImpl.createStatement(n, n2, n3);
            statement = this.createStatementWrapper(statement, n3);
            this.childWrappers.add(statement);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.createStatement(int, int, int)", (String)"2268", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createStatement", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createStatement", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createStatement", (Object)statement);
        }
        return statement;
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        PreparedStatement preparedStatement;
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry((TraceComponent)tempTc, (String)"prepareStatement", (Object)new Object[]{this, string, AdapterUtil.getResultSetTypeString(n), AdapterUtil.getConcurrencyModeString(n2), AdapterUtil.getCursorHoldabilityString(n3)});
        }
        try {
            if (this.state == 1) {
                this.reactivate();
            }
            if (this.managedConn.isStatementCachingEnabled()) {
                PSCacheKey pSCacheKey = new PSCacheKey(string, n, n2, n3, 0, this.mcf.getDataStoreHelper().getMetaData().doesStatementCacheIsoLevel() ? this.currentTransactionIsolation : 0);
                this.beginTransactionIfNecessary();
                Object object = this.managedConn.getStatement(pSCacheKey);
                preparedStatement = object == null ? (this.pmi == null ? this.connImpl.prepareStatement(string, n, n2, n3) : this.pmiPrepareStatement(string, n, n2, n3)) : this.resetStatement((PreparedStatement)object);
                preparedStatement = this.createPreparedStatementWrapper(preparedStatement, n3, pSCacheKey);
            } else {
                this.beginTransactionIfNecessary();
                preparedStatement = this.pmi == null ? this.connImpl.prepareStatement(string, n, n2, n3) : this.pmiPrepareStatement(string, n, n2, n3);
                preparedStatement = this.createPreparedStatementWrapper(preparedStatement, n3);
            }
            this.childWrappers.add(preparedStatement);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.prepareStatement(String, int, int, int)", (String)"2380", (Object)this);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit((TraceComponent)tempTc, (String)"prepareStatement", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit((TraceComponent)tempTc, (String)"prepareStatement", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit((TraceComponent)tempTc, (String)"prepareStatement", (Object)preparedStatement);
        }
        return preparedStatement;
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        CallableStatement callableStatement;
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry((TraceComponent)tempTc, (String)"prepareCall", (Object)new Object[]{this, string, AdapterUtil.getResultSetTypeString(n), AdapterUtil.getConcurrencyModeString(n2), AdapterUtil.getCursorHoldabilityString(n3)});
        }
        try {
            if (this.state == 1) {
                this.reactivate();
            }
            if (this.managedConn.isStatementCachingEnabled()) {
                CSCacheKey cSCacheKey = new CSCacheKey(string, n, n2, n3, this.helper.getMetaData().doesStatementCacheIsoLevel() ? this.currentTransactionIsolation : 0);
                this.beginTransactionIfNecessary();
                Object object = this.managedConn.getStatement(cSCacheKey);
                callableStatement = object == null ? (this.pmi == null ? this.connImpl.prepareCall(string, n, n2, n3) : this.pmiPrepareCall(string, n, n2, n3)) : this.resetStatement((CallableStatement)object);
                callableStatement = this.createCallableStatementWrapper(callableStatement, n3, cSCacheKey);
            } else {
                this.beginTransactionIfNecessary();
                callableStatement = this.pmi == null ? this.connImpl.prepareCall(string, n, n2, n3) : this.pmiPrepareCall(string, n, n2, n3);
                callableStatement = this.createCallableStatementWrapper(callableStatement, n3);
            }
            this.childWrappers.add(callableStatement);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.prepareCall(String, int, int, int)", (String)"2492", (Object)this);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit((TraceComponent)tempTc, (String)"prepareCall", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit((TraceComponent)tempTc, (String)"prepareCall", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit((TraceComponent)tempTc, (String)"prepareCall", (Object)callableStatement);
        }
        return callableStatement;
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        PreparedStatement preparedStatement;
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry((TraceComponent)tempTc, (String)"prepareStatement", (Object)new Object[]{this, string, AdapterUtil.getAutoGeneratedKeyString(n)});
        }
        try {
            if (this.state == 1) {
                this.reactivate();
            }
            if (this.managedConn.isStatementCachingEnabled()) {
                PSCacheKey pSCacheKey = new PSCacheKey(string, 1003, 1007, this.managedConn.getCurrentHoldability(), n, this.mcf.getDataStoreHelper().getMetaData().doesStatementCacheIsoLevel() ? this.currentTransactionIsolation : 0);
                this.beginTransactionIfNecessary();
                Object object = this.managedConn.getStatement(pSCacheKey);
                preparedStatement = object == null ? (this.pmi == null ? this.connImpl.prepareStatement(string, n) : this.pmiPrepareStatement(string, n)) : this.resetStatement((PreparedStatement)object);
                preparedStatement = this.createPreparedStatementWrapper(preparedStatement, this.managedConn.getCurrentHoldability(), pSCacheKey);
            } else {
                this.beginTransactionIfNecessary();
                preparedStatement = this.pmi == null ? this.connImpl.prepareStatement(string, n) : this.pmiPrepareStatement(string, n);
                preparedStatement = this.createPreparedStatementWrapper(preparedStatement, this.managedConn.getCurrentHoldability());
            }
            this.childWrappers.add(preparedStatement);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.prepareStatement(String, int)", (String)"2604", (Object)this);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit((TraceComponent)tempTc, (String)"prepareStatement", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit((TraceComponent)tempTc, (String)"prepareStatement", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit((TraceComponent)tempTc, (String)"prepareStatement", (Object)preparedStatement);
        }
        return preparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        PreparedStatement preparedStatement;
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry((TraceComponent)tempTc, (String)"prepareStatement", (Object)AdapterUtil.populateArrayForTrace(new Object[]{this, string, nArray}));
        }
        try {
            if (this.state == 1) {
                this.reactivate();
            }
            this.beginTransactionIfNecessary();
            preparedStatement = this.pmi == null ? this.connImpl.prepareStatement(string, nArray) : this.pmiPrepareStatement(string, nArray);
            preparedStatement = this.createPreparedStatementWrapper(preparedStatement, this.managedConn.getCurrentHoldability());
            this.childWrappers.add(preparedStatement);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.prepareStatement(String, int[])", (String)"2717", (Object)this);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit((TraceComponent)tempTc, (String)"prepareStatement", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit((TraceComponent)tempTc, (String)"prepareStatement", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit((TraceComponent)tempTc, (String)"prepareStatement", (Object)preparedStatement);
        }
        return preparedStatement;
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        PreparedStatement preparedStatement;
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.entry((TraceComponent)tempTc, (String)"prepareStatement", (Object)AdapterUtil.populateArrayForTrace(new Object[]{this, string, stringArray}));
        }
        try {
            if (this.state == 1) {
                this.reactivate();
            }
            this.beginTransactionIfNecessary();
            preparedStatement = this.pmi == null ? this.connImpl.prepareStatement(string, stringArray) : this.pmiPrepareStatement(string, stringArray);
            preparedStatement = this.createPreparedStatementWrapper(preparedStatement, this.managedConn.getCurrentHoldability());
            this.childWrappers.add(preparedStatement);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcConnection.prepareStatement(String, String[])", (String)"2827", (Object)this);
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit((TraceComponent)tempTc, (String)"prepareStatement", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
                tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
                Tr.exit((TraceComponent)tempTc, (String)"prepareStatement", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled() || clientInfoTc.isEntryEnabled()) {
            tempTc = clientInfoTc.isEntryEnabled() ? clientInfoTc : tc;
            Tr.exit((TraceComponent)tempTc, (String)"prepareStatement", (Object)preparedStatement);
        }
        return preparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CallableStatement pmiPrepareCall(String string, int n, int n2, int n3) throws SQLException {
        try {
            this.pmi.jdbcOperationStarted();
            CallableStatement callableStatement = this.connImpl.prepareCall(string, n, n2, n3);
            return callableStatement;
        }
        finally {
            this.pmi.jdbcOperationCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement pmiPrepareStatement(String string, int n, int n2, int n3) throws SQLException {
        try {
            this.pmi.jdbcOperationStarted();
            PreparedStatement preparedStatement = this.connImpl.prepareStatement(string, n, n2, n3);
            return preparedStatement;
        }
        finally {
            this.pmi.jdbcOperationCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement pmiPrepareStatement(String string, int n) throws SQLException {
        try {
            this.pmi.jdbcOperationStarted();
            PreparedStatement preparedStatement = this.connImpl.prepareStatement(string, n);
            return preparedStatement;
        }
        finally {
            this.pmi.jdbcOperationCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement pmiPrepareStatement(String string, int[] nArray) throws SQLException {
        try {
            this.pmi.jdbcOperationStarted();
            PreparedStatement preparedStatement = this.connImpl.prepareStatement(string, nArray);
            return preparedStatement;
        }
        finally {
            this.pmi.jdbcOperationCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement pmiPrepareStatement(String string, String[] stringArray) throws SQLException {
        try {
            this.pmi.jdbcOperationStarted();
            PreparedStatement preparedStatement = this.connImpl.prepareStatement(string, stringArray);
            return preparedStatement;
        }
        finally {
            this.pmi.jdbcOperationCompleted();
        }
    }

    public void setClientInformation(Properties properties) throws SQLException {
        this.clientProps = (Properties)properties.clone();
        if (this.state == 1) {
            this.reactivate();
        }
        if (properties != null) {
            this.mcf.getInternalDataStoreHelper().setClientInformation(properties, this.managedConn, true);
        } else {
            this.mcf.getInternalDataStoreHelper().resetClientInformation(this.managedConn);
        }
    }

    public Properties getClientInformation() {
        return this.clientProps;
    }

    public WSSystemMonitor getSystemMonitor() throws SQLException {
        if (this.state == 1) {
            this.reactivate();
        }
        return this.mcf.getInternalDataStoreHelper().getSystemMonitor(this.managedConn);
    }
}

