/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc;

import com.ibm.db2.jcc.SQLJCallableStatement;
import com.ibm.db2.jcc.SQLJColumnMetaData;
import com.ibm.db2.jcc.SQLJPreparedStatement;
import com.ibm.db2.jcc.SQLJResultSet;
import com.ibm.db2.jcc.SQLJSection;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.reqmetrics.PmiReqMetrics;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.jdbc.WSJccConnection;
import com.ibm.ws.rsadapter.jdbc.WSJccResultSet;
import com.ibm.ws.rsadapter.jdbc.WSJdbcCallableStatement;
import com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import com.ibm.ws.rsadapter.spi.StatementCacheKey;
import java.sql.BatchUpdateException;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class WSJccCallableStatement
extends WSJdbcCallableStatement
implements SQLJCallableStatement {
    private static final TraceComponent tc = Tr.register((Class)WSJccCallableStatement.class, (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    private SQLJCallableStatement sqljCstmtImpl;

    WSJccCallableStatement(CallableStatement callableStatement, WSJccConnection wSJccConnection, int n) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{AdapterUtil.toString(callableStatement), wSJccConnection, AdapterUtil.getCursorHoldabilityString(n)});
        }
        this.cstmtImpl = callableStatement;
        this.pstmtImpl = this.cstmtImpl;
        this.stmtImpl = this.cstmtImpl;
        this.parentWrapper = wSJccConnection;
        this.pmi = wSJccConnection.pmi;
        this.holdability = n;
        try {
            this.currentFetchSize = this.pstmtImpl.getFetchSize();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJccCallableStatement.<init>", (String)"57", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"<init>", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("current fetchSize is " + this.currentFetchSize));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    WSJccCallableStatement(CallableStatement callableStatement, WSJccConnection wSJccConnection, int n, StatementCacheKey statementCacheKey) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{AdapterUtil.toString(callableStatement), wSJccConnection, AdapterUtil.getCursorHoldabilityString(n), statementCacheKey});
        }
        this.cstmtImpl = callableStatement;
        this.pstmtImpl = this.cstmtImpl;
        this.stmtImpl = this.cstmtImpl;
        this.parentWrapper = wSJccConnection;
        this.pmi = wSJccConnection.pmi;
        this.key = statementCacheKey;
        this.holdability = n;
        try {
            this.currentFetchSize = this.pstmtImpl.getFetchSize();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.jdbc.WSJccCallableStatement.<init>", (String)"109", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"<init>", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("current fetchSize is " + this.currentFetchSize));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public final void addBatch(SQLJPreparedStatement sQLJPreparedStatement) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"addBatch", (Object)new Object[]{this, AdapterUtil.toString(sQLJPreparedStatement)});
        }
        try {
            this.getSQLJCallableStatement().addBatch(sQLJPreparedStatement);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)(this.getClass().getName() + ".addBatch"), (String)"159", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    final RuntimeException checkIfClosed(RuntimeException runtimeException) {
        return this.state == 2 ? new RuntimeException(AdapterUtil.getNLSMessage("OBJECT_CLOSED", "Statement")) : runtimeException;
    }

    final SQLException closeWrapper(boolean bl) {
        this.sqljCstmtImpl = null;
        return super.closeWrapper(bl);
    }

    final WSJdbcResultSet createResultSetWrapper(ResultSet resultSet) {
        return new WSJccResultSet(resultSet, this);
    }

    public int[] executeBatch(boolean bl) throws SQLException {
        int[] nArray;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"executeBatch", (Object)new Object[]{this, bl ? Boolean.TRUE : Boolean.FALSE});
        }
        try {
            if (this.childWrapper != null) {
                this.closeAndRemoveResultSet();
            }
            if (this.childWrappers != null && !this.childWrappers.isEmpty()) {
                this.closeAndRemoveResultSets();
            }
            this.parentWrapper.beginTransactionIfNecessary();
            this.enforceStatementProperties();
            nArray = this.pmi == null && !PmiReqMetrics.isEnabled() ? this.getSQLJCallableStatement().executeBatch(bl) : this.pmiExecuteBatch(bl);
        }
        catch (BatchUpdateException batchUpdateException) {
            FFDCFilter.processException((Throwable)batchUpdateException, (String)(this.getClass().getName() + ".executeBatch"), (String)"327", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Check for Connection Error", (Object)new Object[]{AdapterUtil.getStackTraceWithState(batchUpdateException)});
            }
            try {
                WSJccConnection wSJccConnection = (WSJccConnection)this.parentWrapper;
                if (wSJccConnection.helper.isConnectionError((SQLException)batchUpdateException)) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Encountered a Stale Connection: ", (Object)wSJccConnection);
                    }
                    wSJccConnection.fireConnectionErrorEvent(batchUpdateException);
                }
            }
            catch (NullPointerException nullPointerException) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"executeBatch", (Object)"Exception");
                }
                throw this.runtimeXIfNotClosed(nullPointerException);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"executeBatch", (Object)"Exception");
            }
            throw batchUpdateException;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)(this.getClass().getName() + ".executeBatch"), (String)"260", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"executeBatch", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"executeBatch", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < nArray.length; ++i) {
                stringBuffer.append(i).append(' ');
            }
            Tr.exit((TraceComponent)tc, (String)"executeBatch", (Object)new String(stringBuffer));
        }
        return nArray;
    }

    public final int executeSetCurrentPackageset() throws SQLException {
        try {
            return this.getSQLJCallableStatement().executeSetCurrentPackageset();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)(this.getClass().getName() + "executeSetCurrentPackageset"), (String)"300", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final Object[] getInputs() {
        try {
            return this.getSQLJCallableStatement().getInputs();
        }
        catch (NullPointerException nullPointerException) {
            throw this.checkIfClosed(nullPointerException);
        }
    }

    public final SQLJColumnMetaData getParameterColumnMetaData() throws SQLException {
        try {
            return this.getSQLJCallableStatement().getParameterColumnMetaData();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)(this.getClass().getName() + ".getParameterColumnMetaData"), (String)"383", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final SQLJColumnMetaData getResultSetColumnMetaData() throws SQLException {
        try {
            return this.getSQLJCallableStatement().getResultSetColumnMetaData();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)(this.getClass().getName() + ".getResultSetColumnMetaData"), (String)"403", (Object)this);
            throw WSJdbcUtil.mapException(this, sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw this.runtimeXIfNotClosed(nullPointerException);
        }
    }

    public final SQLJSection getSection() {
        try {
            return this.getSQLJCallableStatement().getSection();
        }
        catch (NullPointerException nullPointerException) {
            throw this.checkIfClosed(nullPointerException);
        }
    }

    public SQLJResultSet getSingletonResultSet() {
        WSJccResultSet wSJccResultSet;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSingletonResultSet", (Object)this);
        }
        try {
            SQLJResultSet sQLJResultSet = this.getSQLJCallableStatement().getSingletonResultSet();
            if (sQLJResultSet == null) {
                wSJccResultSet = null;
            } else if (this.childWrapper == null && (this.childWrappers == null || this.childWrappers.isEmpty())) {
                wSJccResultSet = new WSJccResultSet((ResultSet)sQLJResultSet, this);
                this.childWrapper = wSJccResultSet;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Set the result set to child wrapper");
                }
            } else {
                if (this.childWrappers == null) {
                    this.childWrappers = new ArrayList(5);
                }
                wSJccResultSet = new WSJccResultSet((ResultSet)sQLJResultSet, this);
                this.childWrappers.add(wSJccResultSet);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Add the result set to child wrappers list.");
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getSingletonResultSet", (Object)"Exception");
            }
            throw this.checkIfClosed(nullPointerException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSingletonResultSet", wSJccResultSet);
        }
        return wSJccResultSet;
    }

    private final SQLJCallableStatement getSQLJCallableStatement() {
        return this.sqljCstmtImpl == null ? (this.sqljCstmtImpl = (SQLJCallableStatement)this.cstmtImpl) : this.sqljCstmtImpl;
    }

    public final boolean getSQLJSingletonQuery() {
        try {
            return this.getSQLJCallableStatement().getSQLJSingletonQuery();
        }
        catch (NullPointerException nullPointerException) {
            throw this.checkIfClosed(nullPointerException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] pmiExecuteBatch(boolean bl) throws SQLException {
        int[] nArray;
        Object object;
        block6: {
            object = null;
            try {
                if (PmiReqMetrics.isEnabled()) {
                    object = PmiReqMetrics.updateBegin((int)2, (String)"JDBC", (String)"executeBatch");
                }
                if (this.pmi != null) {
                    this.pmi.jdbcOperationStarted();
                }
                nArray = this.getSQLJCallableStatement().executeBatch(bl);
                Object var5_4 = null;
                if (this.pmi == null) break block6;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var5_5 = null;
                    if (this.pmi != null) {
                        this.pmi.jdbcOperationCompleted();
                    }
                    if (!PmiReqMetrics.isEnabled()) break block7;
                    PmiReqMetrics.updateEnd((Object)object, (int)2, (int)0);
                }
                throw throwable;
            }
            this.pmi.jdbcOperationCompleted();
        }
        if (PmiReqMetrics.isEnabled()) {
            PmiReqMetrics.updateEnd((Object)object, (int)2, (int)0);
        }
        return nArray;
    }

    public final void setInputs(Object[] objectArray) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setInputs (# of inputs = " + objectArray.length + ")"));
        }
        try {
            this.getSQLJCallableStatement().setInputs(objectArray);
        }
        catch (NullPointerException nullPointerException) {
            throw this.checkIfClosed(nullPointerException);
        }
    }

    public final void setSection(SQLJSection sQLJSection) {
        try {
            this.getSQLJCallableStatement().setSection(sQLJSection);
        }
        catch (NullPointerException nullPointerException) {
            throw this.checkIfClosed(nullPointerException);
        }
    }

    public final void setSQLJSingletonQuery(boolean bl) {
        try {
            this.getSQLJCallableStatement().setSQLJSingletonQuery(bl);
        }
        catch (NullPointerException nullPointerException) {
            throw this.checkIfClosed(nullPointerException);
        }
    }

    public void setQueryInstanceIdentifier(long l) {
        try {
            this.getSQLJCallableStatement().setQueryInstanceIdentifier(l);
        }
        catch (NullPointerException nullPointerException) {
            throw this.checkIfClosed(nullPointerException);
        }
    }
}

