/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.rsadapter.DSPropertyEntry;
import com.ibm.websphere.rsadapter.DataStoreHelper;
import com.ibm.websphere.rsadapter.GenericDataStoreHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException;
import com.ibm.ws.security.policy.DynamicPolicy;
import com.ibm.ws.security.policy.DynamicPolicyFactory;
import com.ibm.ws.security.util.AccessController;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.management.ObjectName;
import javax.resource.ResourceException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import javax.sql.XADataSource;

public class DSConfigurationHelper {
    private static final TraceComponent tc = Tr.register((Class)DSConfigurationHelper.class, (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    public static final String CLOUDSCAPE = "Cloudscape";
    public static final String DERBY = "Derby";
    public static final String DB2 = "DB2";
    public static final String DB2_400 = "DB2/400";
    public static final String INFORMIX = "Informix";
    public static final String MS_SQL_SERVER = "Microsoft SQL Server";
    public static final String ORACLE = "Oracle";
    public static final String SYBASE = "Sybase";
    public static final String UNSUPPORTED = "Unsupported";
    public static final String DATABASE_NAME = "databaseName";
    public static final String DATA_SOURCE_NAME = "dataSourceName";
    public static final String LOGIN_TIMEOUT = "loginTimeout";
    public static final String LOG_WRITER = "logWriter";
    public static final String PASSWORD = "password";
    public static final String PORT_NUMBER = "portNumber";
    public static final String SERVER_NAME = "serverName";
    public static final String USER = "user";
    public static final String CONNECTION_MANAGER_CLASS = "connectionManagerClass";
    public static final String DATA_SOURCE_CLASS = "dataSourceClass";
    public static final String DATA_STORE_HELPER_CLASS = "dataStoreHelperClass";
    public static final String DATABASE_TYPE = "databaseType";
    public static final String ENABLE_2_PHASE = "enable2Phase";
    public static final String DISABLE_2_PHASE = "disable2Phase";
    public static final String ENABLE_MULTITHREADED_ACCESS_DETECTION = "enableMultithreadedAccessDetection";
    public static final String ENABLE_SQLJ = "enableSQLJ";
    public static final String INFORMIX_LOCK_MODE_WAIT = "informixLockModeWait";
    public static final String INFORMIX_ALLOW_NEWLINE = "informixAllowNewLine";
    public static final String STATEMENT_CACHE_SIZE = "statementCacheSize";
    public static final String ISOLATION_SWITCHING_SUPPORT = "isolationLevelSwitchingSupport";
    public static final String ORACLELOG_FILE_SIZE_LIMIT = "oracleLogFileSizeLimit";
    public static final String ORACLELOG_FILE_COUNT = "oracleLogFileCount";
    public static final String ORACLELOG_FILENAME = "oracleLogFileName";
    public static final String ORACLELOG_TRACELEVEL = "oracleLogTraceLevel";
    public static final String ORACLE9iLOG_TRACELEVEL = "oracle9iLogTraceLevel";
    public static final String ORACLELOG_FORMAT = "oracleLogFormat";
    public static final String ORACLELOG_PACKAGENAME = "oracleLogPackageName";
    public static final String DB2_TRACE_LEVEL = "traceLevel";
    public static final String DB2_TRACE_FILE = "traceFile";
    public static final String TRANSACTION_BRANCHES_LOOSELY_COUPLED = "transactionBranchesLooselyCoupled";
    public static final String DISABLE_BACKEND_ID_CHECKING = "disableBackendIdChecking";
    public static final String VALIDATE_AFTER_CONNECTION_ERROR = "validateAfterConnectionError";
    public static final String ZOS_CURRENT_SQLID = "currentSQLID";
    public static final String DB2_DRIVER_TYPE = "driverType";
    public static final String PRE_TEST_SQL_STRING = "preTestSQLString";
    public static final String JMS_ONE_PHASE_OPTIMIZATION = "jmsOnePhaseOptimization";
    public static final String REAUTHENTICATION = "reauthentication";
    public static final String RESET_CONNECTION_BY_BACKEND_DATABASE = "resetConnectionByBackendDatabase";
    public static final String DISABLE_WAS_CONNECTION_POOLING = "disableWASConnectionPooling";
    public static final String DB_FAILOVER_ENABLED = "dbFailOverEnabled";
    public static final String DB_FAILOVER_CONNECTION_RETRY_COUNT = "connRetriesDuringDBFailover";
    public static final String DB_FAILOVER_CONNECTION_RETRY_INTERVAL = "connRetryIntervalDuringDBFailover";
    public static final String WAS_DEFAULT_ISOLATION_LEVEL = "webSphereDefaultIsolationLevel";
    public static final String CONN_FACTORY_TYPE = "ConnectionFactoryType";
    public static final String DESCRIPTION = "description";
    public static final String AGED_TIMEOUT = "agedTimeout";
    public static final String CONNECTION_TIMEOUT = "connectionTimeout";
    public static final String MAX_CONNECTIONS = "maxConnections";
    public static final String MIN_CONNECTIONS = "minConnections";
    public static final String PURGE_POLICY = "purgePolicy";
    public static final String REAP_TIME = "reapTime";
    public static final String UNUSED_TIMEOUT = "unusedTimeout";
    public static final String ONE_PHASE = " (single phase)";
    public static final String TWO_PHASE = " (XA)";
    public static final String DB2_VENDOR = "(DB2UDBNT)(DB2EXPRESS)";
    public static final String DB2_ZOS_VENDOR = "(DB2UDBOS390)";
    public static final String DB2_400_VENDOR = "(DB2UDBAS400)";
    public static final String CLOUDSCAPE_VENDOR = "(CLOUDSCAPE)";
    public static final String DERBY_VENDOR = "(DERBY)";
    public static final String INFORMIX_VENDOR = "(INFORMIX)";
    public static final String MS_SQL_SERVER_VENDOR = "(MSSQLSERVER)";
    public static final String ORACLE_VENDOR = "(ORACLE)";
    public static final String SYBASE_VENDOR = "(SYBASE)";
    public static final String CLOUDSCAPE_HELPER_NAME = "com.ibm.websphere.rsadapter.CloudscapeDataStoreHelper";
    public static final String CLOUDSCAPE_NS_U_HELPER_NAME = "com.ibm.websphere.rsadapter.CloudscapeNetworkServerDataStoreHelper";
    public static final String DERBY_HELPER_NAME = "com.ibm.websphere.rsadapter.DerbyDataStoreHelper";
    public static final String DERBY_NS_U_HELPER_NAME = "com.ibm.websphere.rsadapter.DerbyNetworkServerDataStoreHelper";
    public static final String CONNECTJDBC_HELPER_NAME = "com.ibm.websphere.rsadapter.ConnectJDBCDataStoreHelper";
    public static final String DB2AS400_HELPER_NAME = "com.ibm.websphere.rsadapter.DB2AS400DataStoreHelper";
    public static final String DB2_HELPER_NAME = "com.ibm.websphere.rsadapter.DB2DataStoreHelper";
    public static final String DB2UNIVERSAL_HELPER_NAME = "com.ibm.websphere.rsadapter.DB2UniversalDataStoreHelper";
    public static final String INFORMIX_HELPER_NAME = "com.ibm.websphere.rsadapter.InformixDataStoreHelper";
    public static final String ORACLE_HELPER_NAME = "com.ibm.websphere.rsadapter.OracleDataStoreHelper";
    public static final String SYBASE_HELPER_NAME = "com.ibm.websphere.rsadapter.SybaseDataStoreHelper";
    public static final String WSCONNECTJDBC_HELPER_NAME = "com.ibm.websphere.rsadapter.WSConnectJDBCDataStoreHelper";
    public static final String SEQUELINK_HELPER_NAME = "com.ibm.websphere.rsadapter.SequeLinkDataStoreHelper";
    public static final String GENERIC_HELPER_NAME = "com.ibm.websphere.rsadapter.GenericDataStoreHelper";
    private static String[] strictlyMatchedDatabase = new String[]{"(DB2UDBOS390)", "(ORACLE)"};
    private static final HashMap databaseProductNameToBackendMap = new HashMap(10);
    public static final String[] ADAPTER_PROPS;
    public static final String[] supportedDatabases;
    private static final HashMap supportedDataSourceClassMap;
    private static final HashMap commonPropListMap;
    private static final Class[] PARAM_LIST_STRING;
    private static final Class[] PARAM_LIST_PROPS;
    static Hashtable classLoaderMap;

    public static String getDataStoreHelperClassName(String string, Object object) {
        List list = (List)commonPropListMap.get(string);
        String string2 = null;
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                DSPropertyEntry dSPropertyEntry = (DSPropertyEntry)iterator.next();
                if (!dSPropertyEntry.getPropertyName().equals(DATA_STORE_HELPER_CLASS)) continue;
                string2 = (String)dSPropertyEntry.getDefaultValue();
                if (string2.equals(DB2UNIVERSAL_HELPER_NAME) && string.equals("com.ibm.db2.jcc.DB2ConnectionPoolDataSource") && object == null) {
                    string2 = DB2_HELPER_NAME;
                }
                return string2;
            }
        }
        return GENERIC_HELPER_NAME;
    }

    public static final String getBackendIDFromDatabaseProductName(String string) {
        string = string.trim();
        return (String)databaseProductNameToBackendMap.get(string);
    }

    public static final boolean backendRequiresStrictMatch(String string) {
        for (int i = 0; i < strictlyMatchedDatabase.length; ++i) {
            if (!strictlyMatchedDatabase[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static String getDataStoreHelperClassName(String string) {
        List list = (List)commonPropListMap.get(string);
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                DSPropertyEntry dSPropertyEntry = (DSPropertyEntry)iterator.next();
                if (!dSPropertyEntry.getPropertyName().equals(DATA_STORE_HELPER_CLASS)) continue;
                return (String)dSPropertyEntry.getDefaultValue();
            }
        }
        return GENERIC_HELPER_NAME;
    }

    public static Object createDataSource(Object object) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createDataSource", (Object)object);
        }
        try {
            Class clazz = object instanceof Class ? (Class)object : DSConfigurationHelper.loadClass((String)object);
            Object t = clazz.newInstance();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createDataSource", t);
            }
            return t;
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.rsadapter.DSConfigurationHelper.createDataSource", (String)"410");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createDataSource", (Object)"Exception");
            }
            throw AdapterUtil.createDataStoreAdapterException("DS_CLASS_NOT_FOUND", object, classNotFoundException, DSConfigurationHelper.class);
        }
        catch (InstantiationException instantiationException) {
            FFDCFilter.processException((Throwable)instantiationException, (String)"com.ibm.ws.rsadapter.DSConfigurationHelper.createDataSource", (String)"416");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createDataSource", (Object)"Exception");
            }
            throw AdapterUtil.createDataStoreAdapterException("DS_CREATE_ERROR", new Object[]{object, instantiationException}, instantiationException, DSConfigurationHelper.class);
        }
        catch (IllegalAccessException illegalAccessException) {
            FFDCFilter.processException((Throwable)illegalAccessException, (String)"com.ibm.ws.rsadapter.DSConfigurationHelper.createDataSource", (String)"426");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createDataSource", (Object)"Exception");
            }
            throw AdapterUtil.createDataStoreAdapterException("DS_CREATE_ERROR", new Object[]{object, illegalAccessException}, illegalAccessException, DSConfigurationHelper.class);
        }
    }

    public static DataStoreHelper createDataStoreHelper(String string, Properties properties) throws ResourceException {
        DataStoreHelper dataStoreHelper;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createDataStoreHelper", (Object)new Object[]{string, properties});
        }
        try {
            Class clazz = DSConfigurationHelper.loadClass(string);
            if (clazz.equals(GenericDataStoreHelper.class)) {
                Tr.warning((TraceComponent)tc, (String)"DSH_GEN_USED");
            }
            dataStoreHelper = (DataStoreHelper)clazz.getConstructor(PARAM_LIST_PROPS).newInstance(properties);
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.rsadapter.DSConfigurationHelper.createDataStoreHelper", (String)"469");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createDataStoreHelper", (Object)"Exception");
            }
            throw AdapterUtil.createDataStoreAdapterException("HELPER_NOT_FOUND", string, classNotFoundException, DSConfigurationHelper.class);
        }
        catch (InstantiationException instantiationException) {
            FFDCFilter.processException((Throwable)instantiationException, (String)"com.ibm.ws.rsadapter.DSConfigurationHelper.createDataStoreHelper", (String)"475");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createDataStoreHelper", (Object)"Exception");
            }
            throw AdapterUtil.createDataStoreAdapterException("HELPER_IMPL_ERR", string, instantiationException, DSConfigurationHelper.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            FFDCFilter.processException((Throwable)noSuchMethodException, (String)"com.ibm.ws.rsadapter.DSConfigurationHelper.createDataStoreHelper", (String)"481");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createDataStoreHelper", (Object)"Exception");
            }
            throw AdapterUtil.createDataStoreAdapterException("HELPER_NEW_UP_ERR", string, noSuchMethodException, DSConfigurationHelper.class);
        }
        catch (IllegalAccessException illegalAccessException) {
            FFDCFilter.processException((Throwable)illegalAccessException, (String)"com.ibm.ws.rsadapter.DSConfigurationHelper.createDataStoreHelper", (String)"487");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createDataStoreHelper", (Object)"Exception");
            }
            throw AdapterUtil.createDataStoreAdapterException("HELPER_ACCESS_ERR", string, illegalAccessException, DSConfigurationHelper.class);
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.rsadapter.DSConfigurationHelper.createDataStoreHelper", (String)"493");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createDataStoreHelper", (Object)"Exception");
            }
            throw AdapterUtil.createDataStoreAdapterException("HELPER_CAST_ERR", string, classCastException, DSConfigurationHelper.class);
        }
        catch (InvocationTargetException invocationTargetException) {
            FFDCFilter.processException((Throwable)invocationTargetException, (String)"com.ibm.ws.rsadapter.DSConfigurationHelper.createDataStoreHelper", (String)"499");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createDataStoreHelper", (Object)"Exception");
            }
            throw AdapterUtil.createDataStoreAdapterException("HELPER_CTOR_ERR", new Object[]{string, invocationTargetException.getTargetException()}, invocationTargetException.getTargetException(), DSConfigurationHelper.class);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createDataStoreHelper", (Object)AdapterUtil.toString(dataStoreHelper));
        }
        return dataStoreHelper;
    }

    public static PooledConnection getPooledConnection(final Object object, String string, String string2, final boolean bl) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getPooledConnection", (Object)new Object[]{AdapterUtil.toString(object), string, "******", bl ? "two-phase" : "one-phase"});
        }
        final String string3 = string == null ? null : string.trim();
        final String string4 = string2 == null ? null : string2.trim();
        try {
            PooledConnection pooledConnection = (PooledConnection)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return bl ? (string3 == null ? ((XADataSource)object).getXAConnection() : ((XADataSource)object).getXAConnection(string3, string4)) : (string3 == null ? ((ConnectionPoolDataSource)object).getPooledConnection() : ((ConnectionPoolDataSource)object).getPooledConnection(string3, string4));
                }
            });
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getPooledConnection", (Object)AdapterUtil.toString(pooledConnection));
            }
            return pooledConnection;
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.rsadapter.DSConfigurationHelper.getPooledConnection", (String)"568");
            DataStoreAdapterException dataStoreAdapterException = AdapterUtil.createDataStoreAdapterException("JAVAX_CONN_ERR", bl ? "XAConnection" : "PooledConnection", privilegedActionException.getException(), DSConfigurationHelper.class);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getPooledConnection", (Object)"Exception");
            }
            throw dataStoreAdapterException;
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.rsadapter.DSConfigurationHelper.getPooledConnection", (String)"583");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Caught ClassCastException", (Object)classCastException);
            }
            DataStoreAdapterException dataStoreAdapterException = AdapterUtil.createDataStoreAdapterException(bl ? "NOT_A_2_PHASE_DS" : "NOT_A_1_PHASE_DS", classCastException.getMessage(), null, DSConfigurationHelper.class);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getPooledConnection", (Object)"Exception");
            }
            throw dataStoreAdapterException;
        }
    }

    public static List getPropertiesForDataSource(String string, final String string2) throws ClassNotFoundException {
        int n = string.indexOf(32);
        final String string3 = n > 0 ? string.substring(0, n) : string;
        ArrayList<DSPropertyEntry> arrayList = new ArrayList<DSPropertyEntry>();
        List list = (List)commonPropListMap.get(string);
        if (list == null) {
            list = (List)commonPropListMap.get(UNSUPPORTED);
        }
        arrayList.addAll(list);
        List list2 = DSConfigurationHelper.getPropertyNames(list);
        try {
            PropertyDescriptor[] propertyDescriptorArray = (PropertyDescriptor[])AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return Introspector.getBeanInfo(DSConfigurationHelper.loadDataSourceClass(string3, string2)).getPropertyDescriptors();
                }
            });
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                if (list2.contains(propertyDescriptor.getName()) || propertyDescriptor.getWriteMethod() == null || !DSConfigurationHelper.isRepresentableAsString(propertyDescriptor.getPropertyType())) continue;
                arrayList.add(new DSPropertyEntry(propertyDescriptor.getName(), propertyDescriptor.getPropertyType(), false));
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)exception;
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.rsadapter.DSConfigurationHelper.getPropertiesForDataSource", (String)"692");
            Tr.warning((TraceComponent)tc, (String)"CANT_READ_SETTERS", (Object)exception);
        }
        return arrayList;
    }

    private static List getPropertyNames(List list) {
        int n = list == null ? 0 : list.size();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(i, ((DSPropertyEntry)list.get(i)).getPropertyName());
        }
        return arrayList;
    }

    public static final String[] getSupportedDatabases() {
        return supportedDatabases;
    }

    public static final String[] getSupportedDataSourceClasses(String string) {
        String[] stringArray = (String[])supportedDataSourceClassMap.get(string);
        return stringArray == null ? new String[]{} : stringArray;
    }

    public static final boolean is2PhaseEnabled(Properties properties, Object object) {
        return properties.getProperty(ENABLE_2_PHASE) == null ? (properties.getProperty(DISABLE_2_PHASE) == null ? object instanceof XADataSource : !new Boolean(properties.getProperty(DISABLE_2_PHASE)).booleanValue()) : new Boolean(properties.getProperty(ENABLE_2_PHASE));
    }

    public static final boolean isRepresentableAsString(Class clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        try {
            if (clazz.getConstructor(PARAM_LIST_STRING) != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clazz.equals(Properties.class) || clazz.equals(Character.class);
    }

    public static Class loadClass(final String string) throws ClassNotFoundException {
        try {
            return (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    if (classLoader == null) {
                        classLoader = ClassLoader.getSystemClassLoader();
                    }
                    return classLoader.loadClass(string);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (ClassNotFoundException)privilegedActionException.getException();
        }
    }

    public static Class loadDataSourceClass(String string, String string2) throws ClassNotFoundException {
        if (string2 == null || string2.trim().length() == 0) {
            return Class.forName(string, true, Thread.currentThread().getContextClassLoader());
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        String string3 = string2.indexOf(92) >= 0 || string2.indexOf(59) >= 0 ? ";" : File.pathSeparator;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
        while (stringTokenizer.hasMoreTokens()) {
            File file = new File(stringTokenizer.nextToken());
            if (file.isFile()) {
                arrayList.add(file);
                continue;
            }
            File[] fileArray = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.toString().endsWith(".jar") || file.toString().endsWith(".zip");
                }
            });
            if (fileArray == null) continue;
            arrayList.addAll(Arrays.asList(fileArray));
        }
        int n = arrayList.size();
        if (n < 1) {
            throw new ClassNotFoundException(AdapterUtil.getNLSMessage("JAR_ZIP_NOT_FOUND", string2));
        }
        URL[] uRLArray = new URL[n];
        try {
            for (int i = 0; i < n; ++i) {
                uRLArray[i] = ((File)arrayList.get(i)).toURL();
            }
        }
        catch (MalformedURLException malformedURLException) {
            FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.rsadapter.DSConfigurationHelper.loadDataSourceClass", (String)"901");
            throw new ClassNotFoundException(AdapterUtil.getNLSMessage("CANT_READ_JAR_ZIP", malformedURLException));
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        File file = new File(uRLArray[0].getFile());
        URLClassLoader uRLClassLoader = (URLClassLoader)classLoaderMap.get(file);
        if (uRLClassLoader == null) {
            uRLClassLoader = new URLClassLoader(uRLArray, classLoader);
            classLoaderMap.put(file, uRLClassLoader);
        }
        return Class.forName(string, true, uRLClassLoader);
    }

    public static final ArrayList setDataSourceProperties(Object object, Properties properties) throws ResourceException {
        return DSConfigurationHelper.setDataSourceProperties(object, properties, null);
    }

    private static ArrayList setDataSourceProperties(Object object, Properties properties, Locale locale) throws ResourceException {
        String string;
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>(16);
        final Class<?> clazz = object.getClass();
        PropertyDescriptor[] propertyDescriptorArray = null;
        try {
            propertyDescriptorArray = (PropertyDescriptor[])AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return Introspector.getBeanInfo(clazz).getPropertyDescriptors();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.rsadapter.DSConfigurationHelper.setDataSourceProperties", (String)"969");
            throw AdapterUtil.createDataStoreAdapterException("CANT_READ_SETTERS", exception, exception, DSConfigurationHelper.class);
        }
        String string3 = properties.getProperty(USER);
        boolean bl = string3 != null && string3.trim().length() > 0;
        boolean bl2 = false;
        String string4 = System.getProperty("os.name");
        if (string4.equalsIgnoreCase("OS/390") || string4.equalsIgnoreCase("Z/OS")) {
            bl2 = true;
        }
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            string2 = propertyDescriptorArray[i].getName();
            string3 = (String)properties.remove(string2);
            if (string3 == null) continue;
            try {
                string3 = string3.trim();
                boolean bl3 = string2.equals(PASSWORD);
                if (string3.length() <= 0 && (!bl3 || !bl)) continue;
                DSConfigurationHelper.setProperty(object, propertyDescriptorArray[i], string3, !bl3);
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                FFDCFilter.processException((Throwable)noSuchMethodException, (String)"com.ibm.ws.rsadapter.DSConfigurationHelper.setDataSourceProperties", (String)"989");
                if (bl2 && string3.equals(DB2_DRIVER_TYPE)) {
                    throw AdapterUtil.createDataStoreAdapterException("DB2ZOS_CONFIG_ERROR", noSuchMethodException, noSuchMethodException, DSConfigurationHelper.class);
                }
                string = AdapterUtil.getNLSMessage("PROP_NOT_FOUND", locale, new Object[]{clazz.getName(), string2});
                arrayList.add(string);
                Tr.warning((TraceComponent)tc, (String)"CONFIG_WARN", (Object)string);
                continue;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.rsadapter.DSConfigurationHelper.setDataSourceProperties", (String)"1001");
                if (throwable instanceof InvocationTargetException) {
                    throwable2 = ((InvocationTargetException)throwable).getTargetException();
                }
                String string5 = throwable2.getClass().getName();
                string = AdapterUtil.getNLSMessage("PROP_SET_ERROR", locale, new Object[]{string2, throwable2.toString().indexOf(string5) < 0 ? ": " + string5 : "", throwable2});
                arrayList.add(string);
                Tr.warning((TraceComponent)tc, (String)"CONFIG_WARN", (Object)string);
            }
        }
        if (!properties.isEmpty()) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                if (Arrays.binarySearch(ADAPTER_PROPS, string2) >= 0) continue;
                string = AdapterUtil.getNLSMessage("PROP_NOT_FOUND", locale, new Object[]{clazz.getName(), string2});
                arrayList.add(string);
                Tr.warning((TraceComponent)tc, (String)"CONFIG_WARN", (Object)string);
            }
        }
        return arrayList;
    }

    public static void setProperty(Object object, PropertyDescriptor propertyDescriptor, String string, boolean bl) throws Exception {
        Method method;
        Object object2 = null;
        String string2 = propertyDescriptor.getName();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("set " + string2 + " = " + (bl ? string : "******")));
        }
        if ((method = propertyDescriptor.getWriteMethod()) == null) {
            throw new NoSuchMethodException(AdapterUtil.getNLSMessage("NO_SETTER_METHOD", string2));
        }
        Class<?> clazz = method.getParameterTypes()[0];
        if (!clazz.isPrimitive()) {
            object2 = clazz.equals(String.class) ? string : (clazz.equals(Properties.class) ? AdapterUtil.toProperties(string) : (clazz.equals(Character.class) ? new Character(string.charAt(0)) : clazz.getConstructor(String.class).newInstance(string)));
        } else if (clazz.equals(Integer.TYPE)) {
            object2 = new Integer(string);
        } else if (clazz.equals(Long.TYPE)) {
            object2 = new Long(string);
        } else if (clazz.equals(Boolean.TYPE)) {
            object2 = new Boolean(string);
        } else if (clazz.equals(Double.TYPE)) {
            object2 = new Double(string);
        } else if (clazz.equals(Float.TYPE)) {
            object2 = new Float(string);
        } else if (clazz.equals(Short.TYPE)) {
            object2 = new Short(string);
        } else if (clazz.equals(Byte.TYPE)) {
            object2 = new Byte(string);
        } else if (clazz.equals(Character.TYPE)) {
            object2 = new Character(string.charAt(0));
        }
        method.invoke(object, object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String testConnectionToDataSource(String string, String string2, String string3, Properties properties, final String string4, String string5, String string6) throws ClassNotFoundException {
        StringBuffer stringBuffer;
        block57: {
            Throwable throwable3222;
            Object object;
            PooledConnection pooledConnection;
            Connection connection;
            Locale locale;
            block55: {
                String string7;
                int n = string.indexOf(32);
                final String string8 = n > 0 ? string.substring(0, n) : string;
                locale = new Locale(string5, string6);
                connection = null;
                pooledConnection = null;
                DataStoreHelper dataStoreHelper = null;
                int n2 = 0;
                stringBuffer = new StringBuffer();
                Properties properties2 = (Properties)properties.clone();
                Properties properties3 = new Properties();
                String string9 = (String)properties2.remove(DATABASE_TYPE);
                if (string9 != null) {
                    properties3.put(DATABASE_TYPE, string9);
                }
                if ((string9 = (String)properties2.remove(INFORMIX_LOCK_MODE_WAIT)) != null) {
                    properties3.put(INFORMIX_LOCK_MODE_WAIT, string9);
                }
                if ((string9 = (String)properties2.remove(INFORMIX_ALLOW_NEWLINE)) != null) {
                    properties3.put(INFORMIX_ALLOW_NEWLINE, string9);
                }
                if ((string9 = (String)properties2.remove(ORACLELOG_FILE_SIZE_LIMIT)) != null) {
                    properties3.put(ORACLELOG_FILE_SIZE_LIMIT, string9);
                }
                if ((string9 = (String)properties2.remove(ORACLELOG_FILE_COUNT)) != null) {
                    properties3.put(ORACLELOG_FILE_COUNT, string9);
                }
                if ((string9 = (String)properties2.remove(ORACLELOG_FILENAME)) != null) {
                    properties3.put(ORACLELOG_FILENAME, string9);
                }
                if ((string9 = (String)properties2.remove(ORACLELOG_TRACELEVEL)) != null) {
                    properties3.put(ORACLELOG_TRACELEVEL, string9);
                }
                if ((string9 = (String)properties2.remove(ORACLE9iLOG_TRACELEVEL)) != null) {
                    properties3.put(ORACLE9iLOG_TRACELEVEL, string9);
                }
                if ((string9 = (String)properties2.remove(ORACLELOG_PACKAGENAME)) != null) {
                    properties3.put(ORACLELOG_PACKAGENAME, string9);
                }
                if ((string9 = (String)properties2.remove(ORACLELOG_FORMAT)) != null) {
                    properties3.put(ORACLELOG_FORMAT, string9);
                }
                if ((string9 = (String)properties2.remove(WAS_DEFAULT_ISOLATION_LEVEL)) != null) {
                    properties3.put(WAS_DEFAULT_ISOLATION_LEVEL, string9);
                }
                if ((string9 = (String)properties2.remove(ZOS_CURRENT_SQLID)) != null) {
                    properties3.put(ZOS_CURRENT_SQLID, string9);
                }
                if ((string9 = (String)properties2.remove(ISOLATION_SWITCHING_SUPPORT)) != null) {
                    properties3.put(ISOLATION_SWITCHING_SUPPORT, string9);
                }
                if ((string7 = (String)properties2.remove(DATA_STORE_HELPER_CLASS)) != null) {
                    if (string7.equals(GenericDataStoreHelper.class)) {
                        ++n2;
                        stringBuffer.append(AdapterUtil.getNLSMessage("DSH_GEN_USED", locale)).append(FFDCLogger.EOLN);
                    }
                    try {
                        ++n2;
                        dataStoreHelper = DSConfigurationHelper.createDataStoreHelper(string7, properties3);
                        --n2;
                    }
                    catch (ResourceException resourceException) {
                        FFDCFilter.processException((Throwable)resourceException, (String)"com.ibm.ws.rsadapter.DSConfigurationHelper.testConnectionToDataSource", (String)"1209");
                        object = resourceException instanceof DataStoreAdapterException ? ((DataStoreAdapterException)resourceException).translate(locale) : resourceException.getMessage();
                        stringBuffer.append((String)object).append(FFDCLogger.EOLN);
                    }
                }
                Class clazz = null;
                try {
                    clazz = (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return DSConfigurationHelper.loadDataSourceClass(string8, string4);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (ClassNotFoundException)privilegedActionException.getException();
                }
                object = DSConfigurationHelper.createDataSource(clazz);
                ArrayList arrayList = DSConfigurationHelper.setDataSourceProperties(object, properties2, locale);
                int n3 = arrayList.size();
                n2 += n3;
                int n4 = 0;
                while (n4 < n3) {
                    stringBuffer.append(arrayList.get(n4++)).append(FFDCLogger.EOLN);
                }
                pooledConnection = DSConfigurationHelper.getPooledConnection(object, string2, string3, DSConfigurationHelper.is2PhaseEnabled(properties, object));
                connection = pooledConnection.getConnection();
                if (dataStoreHelper != null) {
                    try {
                        ++n2;
                        dataStoreHelper.doConnectionSetup(connection);
                        --n2;
                    }
                    catch (Throwable throwable2) {
                        FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.rsadapter.DSConfigurationHelper.testConnectionToDataSource", (String)"1285");
                        String string10 = AdapterUtil.getNLSMessage("HELPER_EXEC_ERR", locale, new Object[]{"doConnectionSetup", throwable2.getMessage()});
                        Tr.warning((TraceComponent)tc, (String)"CONFIG_WARN", (Object)string10);
                        stringBuffer.append(string10).append(FFDCLogger.EOLN);
                        throw throwable2;
                    }
                }
                connection.getAutoCommit();
                if (connection != null) {
                    connection.close();
                }
                connection = null;
                if (pooledConnection != null) {
                    pooledConnection.close();
                }
                pooledConnection = null;
                stringBuffer.append(n2 == 0 ? AdapterUtil.getNLSMessage("TEST_DS_SUCCESSFUL", locale) : AdapterUtil.getNLSMessage("TEST_DS_WARNINGS", locale, new Integer(n2)));
                Object var26_35 = null;
                if (connection == null) break block55;
                try {
                    connection.close();
                }
                catch (Throwable throwable3222) {
                    // empty catch block
                }
            }
            if (pooledConnection != null) {
                try {
                    pooledConnection.close();
                }
                catch (Throwable throwable3222) {}
            }
            break block57;
            {
                catch (ClassNotFoundException classNotFoundException) {
                    throw classNotFoundException;
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    throw new ClassNotFoundException(AdapterUtil.stackTraceToString(noClassDefFoundError));
                }
                catch (ResourceException resourceException) {
                    Throwable throwable42222;
                    FFDCFilter.processException((Throwable)resourceException, (String)"com.ibm.ws.rsadapter.DSConfigurationHelper.testConnectionToDataSource", (String)"1336");
                    object = resourceException.getLinkedException();
                    if (object == null) {
                        object = resourceException;
                    }
                    String string11 = object instanceof DataStoreAdapterException ? ((DataStoreAdapterException)((Object)object)).translate(locale) : ((Throwable)object).getMessage();
                    String string12 = AdapterUtil.getNLSMessage("TEST_DS_FAIL", locale, new Object[]{object.getClass().getName(), string11});
                    stringBuffer.append(string12);
                    Tr.warning((TraceComponent)tc, (String)"CONFIG_WARN_WITH_X", (Object)new Object[]{string12, object});
                    Object var26_36 = null;
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable42222) {
                            // empty catch block
                        }
                    }
                    if (pooledConnection != null) {
                        try {
                            pooledConnection.close();
                        }
                        catch (Throwable throwable42222) {}
                    }
                    break block57;
                }
                catch (SQLException sQLException) {
                    Throwable throwable52222;
                    FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.DSConfigurationHelper.testConnectionToDataSource", (String)"1356");
                    object = AdapterUtil.getNLSMessage("TEST_DS_FAIL_SQLX", locale, new Object[]{sQLException.getSQLState(), new Integer(sQLException.getErrorCode()), sQLException.getMessage()});
                    stringBuffer.append((String)object);
                    Tr.warning((TraceComponent)tc, (String)"CONFIG_WARN_WITH_X", (Object)new Object[]{object, sQLException});
                    Object var26_37 = null;
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable52222) {
                            // empty catch block
                        }
                    }
                    if (pooledConnection != null) {
                        try {
                            pooledConnection.close();
                        }
                        catch (Throwable throwable52222) {}
                    }
                    break block57;
                }
                catch (Throwable throwable6) {
                    Throwable throwable72222;
                    FFDCFilter.processException((Throwable)throwable6, (String)"com.ibm.ws.rsadapter.DSConfigurationHelper.testConnectionToDataSource", (String)"1376");
                    object = AdapterUtil.getNLSMessage("TEST_DS_FAIL", locale, new Object[]{throwable6.getClass().getName(), AdapterUtil.toErrorMessage(throwable6)});
                    stringBuffer.append((String)object);
                    Tr.warning((TraceComponent)tc, (String)"CONFIG_WARN_WITH_X", (Object)new Object[]{object, throwable6});
                    Object var26_38 = null;
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable72222) {
                            // empty catch block
                        }
                    }
                    if (pooledConnection != null) {
                        try {
                            pooledConnection.close();
                        }
                        catch (Throwable throwable72222) {}
                    }
                }
            }
            catch (Throwable throwable8) {
                Throwable throwable92222;
                Object var26_39 = null;
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable92222) {
                        // empty catch block
                    }
                }
                if (pooledConnection != null) {
                    try {
                        pooledConnection.close();
                    }
                    catch (Throwable throwable92222) {
                        // empty catch block
                    }
                }
                throw throwable8;
            }
        }
        return new String(stringBuffer);
    }

    /*
     * Loose catch block
     */
    public static int testConnectionForGUI(String string, String string2, String string3, Properties properties, final String string4) throws Exception {
        int n;
        block48: {
            Throwable throwable2222;
            StringBuffer stringBuffer;
            PooledConnection pooledConnection;
            Connection connection;
            HashMap hashMap;
            block46: {
                Object object;
                SQLWarning sQLWarning;
                String string5;
                hashMap = null;
                int n2 = string.indexOf(32);
                final String string6 = n2 > 0 ? string.substring(0, n2) : string;
                connection = null;
                pooledConnection = null;
                DataStoreHelper dataStoreHelper = null;
                n = 0;
                stringBuffer = new StringBuffer();
                Properties properties2 = (Properties)properties.clone();
                Properties properties3 = new Properties();
                String string7 = (String)properties2.remove(DATABASE_TYPE);
                if (string7 != null) {
                    properties3.put(DATABASE_TYPE, string7);
                }
                if ((string7 = (String)properties2.remove(INFORMIX_LOCK_MODE_WAIT)) != null) {
                    properties3.put(INFORMIX_LOCK_MODE_WAIT, string7);
                }
                if ((string7 = (String)properties2.remove(INFORMIX_ALLOW_NEWLINE)) != null) {
                    properties3.put(INFORMIX_ALLOW_NEWLINE, string7);
                }
                if ((string7 = (String)properties2.remove(ORACLELOG_FILE_SIZE_LIMIT)) != null) {
                    properties3.put(ORACLELOG_FILE_SIZE_LIMIT, string7);
                }
                if ((string7 = (String)properties2.remove(ORACLELOG_FILE_COUNT)) != null) {
                    properties3.put(ORACLELOG_FILE_COUNT, string7);
                }
                if ((string7 = (String)properties2.remove(ORACLELOG_FILENAME)) != null) {
                    properties3.put(ORACLELOG_FILENAME, string7);
                }
                if ((string7 = (String)properties2.remove(ORACLELOG_TRACELEVEL)) != null) {
                    properties3.put(ORACLELOG_TRACELEVEL, string7);
                }
                if ((string7 = (String)properties2.remove(ORACLE9iLOG_TRACELEVEL)) != null) {
                    properties3.put(ORACLE9iLOG_TRACELEVEL, string7);
                }
                if ((string7 = (String)properties2.remove(ORACLELOG_PACKAGENAME)) != null) {
                    properties3.put(ORACLELOG_PACKAGENAME, string7);
                }
                if ((string7 = (String)properties2.remove(ORACLELOG_FORMAT)) != null) {
                    properties3.put(ORACLELOG_FORMAT, string7);
                }
                if ((string7 = (String)properties2.remove(WAS_DEFAULT_ISOLATION_LEVEL)) != null) {
                    properties3.put(WAS_DEFAULT_ISOLATION_LEVEL, string7);
                }
                if ((string7 = (String)properties2.remove(ZOS_CURRENT_SQLID)) != null) {
                    properties3.put(ZOS_CURRENT_SQLID, string7);
                }
                if ((string7 = (String)properties2.remove(ISOLATION_SWITCHING_SUPPORT)) != null) {
                    properties3.put(ISOLATION_SWITCHING_SUPPORT, string7);
                }
                if ((string5 = (String)properties2.remove(DATA_STORE_HELPER_CLASS)) != null) {
                    if (string5.equals(GenericDataStoreHelper.class)) {
                        ++n;
                        stringBuffer.append(AdapterUtil.getNLSMessage("DSH_GEN_USED")).append(FFDCLogger.EOLN);
                    }
                    dataStoreHelper = DSConfigurationHelper.createDataStoreHelper(string5, properties3);
                }
                hashMap = DSConfigurationHelper.setupMap(string4);
                Class clazz = null;
                try {
                    clazz = (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return DSConfigurationHelper.loadDataSourceClass(string6, string4);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (ClassNotFoundException)privilegedActionException.getException();
                }
                Object object2 = DSConfigurationHelper.createDataSource(clazz);
                ArrayList arrayList = DSConfigurationHelper.setDataSourceProperties(object2, properties2);
                int n3 = arrayList.size();
                n += n3;
                int n4 = 0;
                while (n4 < n3) {
                    stringBuffer.append(arrayList.get(n4++)).append(FFDCLogger.EOLN);
                }
                pooledConnection = DSConfigurationHelper.getPooledConnection(object2, string2, string3, DSConfigurationHelper.is2PhaseEnabled(properties, object2));
                connection = pooledConnection.getConnection();
                if (connection != null && string.startsWith("com.sybase") && (sQLWarning = connection.getWarnings()) != null) {
                    object = null;
                    String string8 = sQLWarning.getSQLState();
                    if (string8.equals("010UF")) {
                        Object object3 = object = new SQLException(sQLWarning.getMessage(), string8);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)(string8 + sQLWarning.getMessage()));
                        }
                        for (sQLWarning = sQLWarning.getNextWarning(); sQLWarning != null; sQLWarning = sQLWarning.getNextWarning()) {
                            object3 = new SQLException(sQLWarning.getMessage(), sQLWarning.getSQLState());
                            ((SQLException)object).setNextException((SQLException)object3);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)(sQLWarning.getSQLState() + sQLWarning.getMessage()));
                        }
                        throw object;
                    }
                }
                if (dataStoreHelper != null) {
                    try {
                        ++n;
                        dataStoreHelper.doConnectionSetup(connection);
                        --n;
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.rsadapter.DSConfigurationHelper.testConnectionToDataSource", (String)"1285");
                        object = AdapterUtil.getNLSMessage("HELPER_EXEC_ERR", new Object[]{"doConnectionSetup", exception.getMessage()});
                        Tr.warning((TraceComponent)tc, (String)"CONFIG_WARN", (Object)object);
                        stringBuffer.append((String)object).append(FFDCLogger.EOLN);
                        throw exception;
                    }
                }
                connection.getAutoCommit();
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                Tr.info((TraceComponent)tc, (String)"DB_PRODUCT_NAME", (Object)databaseMetaData.getDatabaseProductName());
                Tr.info((TraceComponent)tc, (String)"DB_PRODUCT_VERSION", (Object)databaseMetaData.getDatabaseProductVersion());
                Tr.info((TraceComponent)tc, (String)"JDBC_DRIVER_NAME", (Object)databaseMetaData.getDriverName());
                Tr.info((TraceComponent)tc, (String)"JDBC_DRIVER_VERSION", (Object)databaseMetaData.getDriverVersion());
                if (connection != null) {
                    connection.close();
                }
                connection = null;
                if (pooledConnection != null) {
                    pooledConnection.close();
                }
                pooledConnection = null;
                stringBuffer.append(n == 0 ? AdapterUtil.getNLSMessage("TEST_DS_SUCCESSFUL") : AdapterUtil.getNLSMessage("TEST_DS_WARNINGS", new Integer(n)));
                Object var26_37 = null;
                if (connection == null) break block46;
                try {
                    connection.close();
                }
                catch (Throwable throwable2222) {
                    // empty catch block
                }
            }
            if (pooledConnection != null) {
                try {
                    pooledConnection.close();
                }
                catch (Throwable throwable2222) {
                    // empty catch block
                }
            }
            if (hashMap != null && (throwable2222 = DynamicPolicyFactory.getInstance()) != null) {
                throwable2222.removePolicy(hashMap);
            }
            break block48;
            {
                catch (DataStoreAdapterException dataStoreAdapterException) {
                    Exception exception = dataStoreAdapterException.getLinkedException();
                    exception = exception == null ? new Exception(dataStoreAdapterException.getMessage()) : new Exception(exception.toString());
                    throw exception;
                }
                catch (ResourceException resourceException) {
                    FFDCFilter.processException((Throwable)resourceException, (String)"com.ibm.ws.rsadapter.DSConfigurationHelper.testConnectionToDataSource", (String)"1486");
                    Throwable throwable3 = resourceException.getLinkedException();
                    if (throwable3 == null) {
                        throwable3 = resourceException;
                    }
                    String string9 = throwable3.getMessage();
                    String string10 = AdapterUtil.getNLSMessage("TEST_DS_FAIL", new Object[]{throwable3.getClass().getName(), string9});
                    stringBuffer.append(string10);
                    Tr.warning((TraceComponent)tc, (String)"CONFIG_WARN_WITH_X", (Object)new Object[]{string10, throwable3});
                    throw resourceException;
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.rsadapter.DSConfigurationHelper.testConnectionToDataSource", (String)"1504");
                    String string11 = AdapterUtil.getNLSMessage("TEST_DS_FAIL_SQLX", new Object[]{sQLException.getSQLState(), new Integer(sQLException.getErrorCode()), sQLException.getMessage()});
                    stringBuffer.append(string11);
                    Tr.warning((TraceComponent)tc, (String)"CONFIG_WARN_WITH_X", (Object)new Object[]{string11, sQLException});
                    throw sQLException;
                }
            }
            catch (Throwable throwable4) {
                Throwable throwable52222;
                Object var26_38 = null;
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable52222) {
                        // empty catch block
                    }
                }
                if (pooledConnection != null) {
                    try {
                        pooledConnection.close();
                    }
                    catch (Throwable throwable52222) {
                        // empty catch block
                    }
                }
                if (hashMap != null && (throwable52222 = DynamicPolicyFactory.getInstance()) != null) {
                    throwable52222.removePolicy(hashMap);
                }
                throw throwable4;
            }
        }
        if (n == 0) {
            Tr.info((TraceComponent)tc, (String)"TEST_DS_SUCCESSFUL");
            return 0;
        }
        Tr.info((TraceComponent)tc, (String)"TEST_DS_WARNINGS", (Object)new Integer(n));
        return n;
    }

    private static HashMap setupMap(String string) {
        String string2 = string.indexOf(92) >= 0 || string.indexOf(59) >= 0 ? ";" : File.pathSeparator;
        HashMap<String, Object> hashMap = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        int n = arrayList.size();
        ObjectName objectName = AdminServiceFactory.getAdminService().getLocalServer();
        String string3 = objectName.getKeyProperty("processType");
        if (string3.equals("DeploymentManager") || string3.equals("NodeAgent")) {
            hashMap = new HashMap<String, Object>(2);
            hashMap.put("type", "spi");
            hashMap.put("classpath", arrayList.toArray(new String[n]));
            DynamicPolicy dynamicPolicy = DynamicPolicyFactory.getInstance();
            if (dynamicPolicy != null) {
                dynamicPolicy.setupPolicy(hashMap);
            }
        }
        return hashMap;
    }

    public static ArrayList getHelperListForDataSource(String string, String string2) {
        ArrayList arrayList = new ArrayList();
        if (string2 == null) {
            string2 = "";
        }
        if (string.equals("com.ibm.db2.jcc.DB2ConnectionPoolDataSource") || string.equals("com.ibm.db2.jcc.DB2XADataSource")) {
            if (string2.equals("DB2 Universal JDBC Driver Provider") || string2.equals("DB2 Universal JDBC Driver Provider (XA)")) {
                ArrayList<String> arrayList2 = new ArrayList<String>();
                arrayList2.add(0, DB2UNIVERSAL_HELPER_NAME);
                arrayList2.add(1, "DB2_Universal_DataStoreHelper");
                arrayList.add(0, arrayList2);
                arrayList2 = new ArrayList();
                arrayList2.add(0, DB2AS400_HELPER_NAME);
                arrayList2.add(1, "DB2_for_iSeries_DataStoreHelper");
                arrayList.add(1, arrayList2);
            } else if (string2.equals("DB2 for zOS Local JDBC Provider (RRS)")) {
                ArrayList<String> arrayList3 = new ArrayList<String>();
                arrayList3.add(0, DB2_HELPER_NAME);
                arrayList3.add(1, "DB2_DataStoreHelper");
                arrayList.add(0, arrayList3);
            } else if (string2.equals("Cloudscape Network Server Using Universal JDBC Driver")) {
                ArrayList<String> arrayList4 = new ArrayList<String>();
                arrayList4.add(0, CLOUDSCAPE_NS_U_HELPER_NAME);
                arrayList4.add(1, "Cloudscape_Network_Server_DataStoreHelper");
                arrayList.add(0, arrayList4);
            } else if (string2.equals("Derby Network Server Using Universal JDBC Driver")) {
                ArrayList<String> arrayList5 = new ArrayList<String>();
                arrayList5.add(0, DERBY_NS_U_HELPER_NAME);
                arrayList5.add(1, "Derby_Network_Server_DataStoreHelper");
                arrayList.add(0, arrayList5);
            } else {
                ArrayList<String> arrayList6 = new ArrayList<String>();
                arrayList6.add(0, DB2UNIVERSAL_HELPER_NAME);
                arrayList6.add(1, "DB2_Universal_DataStoreHelper");
                arrayList.add(0, arrayList6);
                arrayList6 = new ArrayList();
                arrayList6.add(0, DB2AS400_HELPER_NAME);
                arrayList6.add(1, "DB2_for_iSeries_DataStoreHelper");
                arrayList.add(1, arrayList6);
                arrayList6 = new ArrayList();
                arrayList6.add(0, CLOUDSCAPE_NS_U_HELPER_NAME);
                arrayList6.add(1, "Cloudscape_Network_Server_DataStoreHelper");
                arrayList.add(2, arrayList6);
            }
        } else if (string.equals("COM.ibm.db2.jdbc.DB2ConnectionPoolDataSource") || string.equals("COM.ibm.db2.jdbc.DB2XADataSource")) {
            ArrayList<String> arrayList7 = new ArrayList<String>();
            arrayList7.add(0, DB2_HELPER_NAME);
            arrayList7.add(1, "DB2_DataStoreHelper");
            arrayList.add(0, arrayList7);
        } else if (string.equals("com.ibm.db2.jdbc.app.UDBConnectionPoolDataSource") || string.equals("com.ibm.db2.jdbc.app.UDBXADataSource") || string.equals("com.ibm.as400.access.AS400JDBCConnectionPoolDataSource") || string.equals("com.ibm.as400.access.AS400JDBCXADataSource")) {
            ArrayList<String> arrayList8 = new ArrayList<String>();
            arrayList8.add(0, DB2AS400_HELPER_NAME);
            arrayList8.add(1, "DB2_for_iSeries_DataStoreHelper");
            arrayList.add(0, arrayList8);
        } else if (string.equals("com.ibm.db2j.jdbc.DB2jConnectionPoolDataSource") || string.equals("com.ibm.db2j.jdbc.DB2jXADataSource")) {
            ArrayList<String> arrayList9 = new ArrayList<String>();
            arrayList9.add(0, CLOUDSCAPE_HELPER_NAME);
            arrayList9.add(1, "Cloudscape_DataStoreHelper");
            arrayList.add(0, arrayList9);
        } else if (string.equals("org.apache.derby.jdbc.EmbeddedConnectionPoolDataSource") || string.equals("org.apache.derby.jdbc.EmbeddedXADataSource")) {
            ArrayList<String> arrayList10 = new ArrayList<String>();
            arrayList10.add(0, DERBY_HELPER_NAME);
            arrayList10.add(1, "Derby_DataStoreHelper");
            arrayList.add(0, arrayList10);
        } else if (string.equals("com.informix.jdbcx.IfxConnectionPoolDataSource") || string.equals("com.informix.jdbcx.IfxXADataSource")) {
            ArrayList<String> arrayList11 = new ArrayList<String>();
            arrayList11.add(0, INFORMIX_HELPER_NAME);
            arrayList11.add(1, "Informix_DataStoreHelper");
            arrayList.add(0, arrayList11);
        } else if (string.equals("com.sybase.jdbc2.jdbc.SybConnectionPoolDataSource") || string.equals("com.sybase.jdbc2.jdbc.SybXADataSource")) {
            ArrayList<String> arrayList12 = new ArrayList<String>();
            arrayList12.add(0, SYBASE_HELPER_NAME);
            arrayList12.add(1, "Sybase_DataStoreHelper");
            arrayList.add(0, arrayList12);
        } else if (string.equals("oracle.jdbc.pool.OracleConnectionPoolDataSource") || string.equals("oracle.jdbc.xa.client.OracleXADataSource")) {
            ArrayList<String> arrayList13 = new ArrayList<String>();
            arrayList13.add(0, ORACLE_HELPER_NAME);
            arrayList13.add(1, "Oracle9i_and_prior_DataStoreHelper");
            arrayList.add(0, arrayList13);
            arrayList13 = new ArrayList();
            arrayList13.add(0, "com.ibm.websphere.rsadapter.Oracle10gDataStoreHelper");
            arrayList13.add(1, "Oracle10g_DataStoreHelper");
            arrayList.add(1, arrayList13);
        } else if (string.equals("com.ddtek.jdbcx.sqlserver.SQLServerDataSource")) {
            ArrayList<String> arrayList14 = new ArrayList<String>();
            arrayList14.add(0, CONNECTJDBC_HELPER_NAME);
            arrayList14.add(1, "DataDirect_ConnectJDBC_DataStoreHelper");
            arrayList.add(0, arrayList14);
        } else if (string.equals("com.ibm.websphere.jdbcx.sqlserver.SQLServerDataSource")) {
            ArrayList<String> arrayList15 = new ArrayList<String>();
            arrayList15.add(0, WSCONNECTJDBC_HELPER_NAME);
            arrayList15.add(1, "WebSphere_Branded_ConnectJDBC_DataStoreHelper");
            arrayList.add(0, arrayList15);
        } else {
            ArrayList<String> arrayList16 = new ArrayList<String>();
            arrayList16.add(0, GENERIC_HELPER_NAME);
            arrayList16.add(1, "Generic_DataStoreHelper");
            arrayList.add(0, arrayList16);
        }
        return arrayList;
    }

    static {
        databaseProductNameToBackendMap.put("DB2/", DB2_VENDOR);
        databaseProductNameToBackendMap.put(DB2, DB2_ZOS_VENDOR);
        databaseProductNameToBackendMap.put("DSN", DB2_ZOS_VENDOR);
        databaseProductNameToBackendMap.put("DB2 UDB for AS/400", DB2_400_VENDOR);
        databaseProductNameToBackendMap.put(ORACLE, ORACLE_VENDOR);
        databaseProductNameToBackendMap.put("DBMS:db2j", CLOUDSCAPE_VENDOR);
        databaseProductNameToBackendMap.put(CLOUDSCAPE, CLOUDSCAPE_VENDOR);
        databaseProductNameToBackendMap.put("Apache Derby", DERBY_VENDOR);
        databaseProductNameToBackendMap.put("Informix Dynamic Server", INFORMIX_VENDOR);
        databaseProductNameToBackendMap.put("Sybase SQL Server", SYBASE_VENDOR);
        databaseProductNameToBackendMap.put("Adaptive Server Enterprise", SYBASE_VENDOR);
        databaseProductNameToBackendMap.put(MS_SQL_SERVER, MS_SQL_SERVER_VENDOR);
        ADAPTER_PROPS = new String[]{CONN_FACTORY_TYPE, CONNECTION_MANAGER_CLASS, "name", DATA_SOURCE_CLASS, DATA_STORE_HELPER_CLASS, DATABASE_TYPE, DESCRIPTION, MAX_CONNECTIONS, MIN_CONNECTIONS, STATEMENT_CACHE_SIZE, AGED_TIMEOUT, CONNECTION_TIMEOUT, PURGE_POLICY, REAP_TIME, UNUSED_TIMEOUT, ENABLE_2_PHASE, DISABLE_2_PHASE, ENABLE_MULTITHREADED_ACCESS_DETECTION, ENABLE_SQLJ, INFORMIX_LOCK_MODE_WAIT, INFORMIX_ALLOW_NEWLINE, ISOLATION_SWITCHING_SUPPORT, ORACLELOG_FILE_SIZE_LIMIT, ORACLELOG_FILE_COUNT, ORACLELOG_FILENAME, ORACLELOG_TRACELEVEL, ORACLE9iLOG_TRACELEVEL, ORACLELOG_FORMAT, ORACLELOG_PACKAGENAME, TRANSACTION_BRANCHES_LOOSELY_COUPLED, DISABLE_BACKEND_ID_CHECKING, DB2_DRIVER_TYPE, PRE_TEST_SQL_STRING, ZOS_CURRENT_SQLID, JMS_ONE_PHASE_OPTIMIZATION, REAUTHENTICATION, RESET_CONNECTION_BY_BACKEND_DATABASE, DISABLE_WAS_CONNECTION_POOLING, DB_FAILOVER_ENABLED, DB_FAILOVER_CONNECTION_RETRY_COUNT, DB_FAILOVER_CONNECTION_RETRY_INTERVAL, WAS_DEFAULT_ISOLATION_LEVEL};
        supportedDatabases = new String[]{CLOUDSCAPE, DB2, DB2_400, INFORMIX, MS_SQL_SERVER, ORACLE, SYBASE, DERBY};
        PARAM_LIST_STRING = new Class[]{String.class};
        PARAM_LIST_PROPS = new Class[]{Properties.class};
        classLoaderMap = new Hashtable();
        Arrays.sort(ADAPTER_PROPS);
        supportedDataSourceClassMap = new HashMap(2 * supportedDatabases.length + 1);
        supportedDataSourceClassMap.put(CLOUDSCAPE, new String[]{"com.ibm.db2j.jdbc.DB2jConnectionPoolDataSource", "com.ibm.db2j.jdbc.DB2jXADataSource", "com.ibm.db2.jcc.DB2ConnectionPoolDataSource"});
        supportedDataSourceClassMap.put(DERBY, new String[]{"org.apache.derby.jdbc.EmbeddedConnectionPoolDataSource", "org.apache.derby.jdbc.EmbeddedXADataSource", "com.ibm.db2.jcc.DB2ConnectionPoolDataSource"});
        supportedDataSourceClassMap.put(DB2, new String[]{"COM.ibm.db2.jdbc.DB2ConnectionPoolDataSource", "COM.ibm.db2.jdbc.DB2XADataSource", "com.ibm.db2.jcc.DB2ConnectionPoolDataSource", "com.ibm.db2.jcc.DB2XADataSource"});
        supportedDataSourceClassMap.put(DB2_400, new String[]{"com.ibm.as400.access.AS400JDBCConnectionPoolDataSource", "com.ibm.as400.access.AS400JDBCXADataSource", "com.ibm.db2.jdbc.app.DB2StdConnectionPoolDataSource", "com.ibm.db2.jdbc.app.DB2StdXADataSource", "com.ibm.db2.jdbc.app.UDBConnectionPoolDataSource", "com.ibm.db2.jdbc.app.UDBXADataSource", "com.ibm.db2.jcc.DB2ConnectionPoolDataSource"});
        supportedDataSourceClassMap.put(INFORMIX, new String[]{"com.informix.jdbcx.IfxConnectionPoolDataSource", "com.informix.jdbcx.IfxXADataSource"});
        supportedDataSourceClassMap.put(MS_SQL_SERVER, new String[]{"com.ibm.websphere.jdbcx.sqlserver.SQLServerDataSource (single phase)", "com.ibm.websphere.jdbcx.sqlserver.SQLServerDataSource (XA)", "com.ddtek.jdbcx.sqlserver.SQLServerDataSource (single phase)", "com.ddtek.jdbcx.sqlserver.SQLServerDataSource (XA)", "com.ddtek.jdbcx.sequelink.SequeLinkDataSource (single phase)", "com.ddtek.jdbcx.sequelink.SequeLinkDataSource (XA)", "com.microsoft.jdbcx.sqlserver.SQLServerDataSource (single phase)", "com.microsoft.jdbcx.sqlserver.SQLServerDataSource (XA)"});
        supportedDataSourceClassMap.put(ORACLE, new String[]{"oracle.jdbc.pool.OracleConnectionPoolDataSource", "oracle.jdbc.xa.client.OracleXADataSource"});
        supportedDataSourceClassMap.put(SYBASE, new String[]{"com.sybase.jdbc2.jdbc.SybConnectionPoolDataSource", "com.sybase.jdbc2.jdbc.SybXADataSource"});
        commonPropListMap = new HashMap(61);
        ArrayList<DSPropertyEntry> arrayList = new ArrayList<DSPropertyEntry>(1);
        arrayList.add(new DSPropertyEntry(DATA_STORE_HELPER_CLASS, String.class, true, (Object)GENERIC_HELPER_NAME));
        commonPropListMap.put(UNSUPPORTED, arrayList);
        arrayList = new ArrayList(2);
        arrayList.add(new DSPropertyEntry(DATA_STORE_HELPER_CLASS, String.class, true, (Object)CLOUDSCAPE_HELPER_NAME));
        arrayList.add(new DSPropertyEntry(DATABASE_NAME, String.class, true, (Object)"C:/db2j/databases/sample"));
        commonPropListMap.put("com.ibm.db2j.jdbc.DB2jConnectionPoolDataSource", arrayList);
        commonPropListMap.put("com.ibm.db2j.jdbc.DB2jXADataSource", arrayList);
        arrayList = new ArrayList(6);
        arrayList.add(new DSPropertyEntry(DATA_STORE_HELPER_CLASS, String.class, true, (Object)DB2UNIVERSAL_HELPER_NAME));
        arrayList.add(new DSPropertyEntry(DATABASE_NAME, String.class, true, (Object)"sample"));
        arrayList.add(new DSPropertyEntry(SERVER_NAME, String.class, true, (Object)"localhost"));
        arrayList.add(new DSPropertyEntry(PORT_NUMBER, Integer.TYPE, true, (Object)new Integer(6789)));
        arrayList.add(new DSPropertyEntry(USER, String.class, false, null));
        arrayList.add(new DSPropertyEntry(PASSWORD, String.class, false, null));
        commonPropListMap.put("com.ibm.db2.jcc.DB2ConnectionPoolDataSource", arrayList);
        commonPropListMap.put("com.ibm.db2.jcc.DB2XADataSource", arrayList);
        arrayList = new ArrayList(5);
        arrayList.add(new DSPropertyEntry(DATA_STORE_HELPER_CLASS, String.class, true, (Object)DB2_HELPER_NAME));
        arrayList.add(new DSPropertyEntry(DATABASE_NAME, String.class, true, (Object)"sample"));
        arrayList.add(new DSPropertyEntry(USER, String.class, false, null));
        arrayList.add(new DSPropertyEntry(PASSWORD, String.class, false, null));
        arrayList.add(new DSPropertyEntry("connectionAttribute", String.class, false, (Object)"cursorhold=0"));
        commonPropListMap.put("COM.ibm.db2.jdbc.DB2ConnectionPoolDataSource", arrayList);
        commonPropListMap.put("COM.ibm.db2.jdbc.DB2XADataSource", arrayList);
        arrayList = new ArrayList(5);
        arrayList.add(new DSPropertyEntry(DATA_STORE_HELPER_CLASS, String.class, true, (Object)DB2AS400_HELPER_NAME));
        arrayList.add(new DSPropertyEntry(SERVER_NAME, String.class, true, null));
        arrayList.add(new DSPropertyEntry(USER, String.class, false, null));
        arrayList.add(new DSPropertyEntry(PASSWORD, String.class, false, null));
        arrayList.add(new DSPropertyEntry("connectionAttribute", String.class, false, (Object)"cursorhold=0"));
        commonPropListMap.put("com.ibm.as400.access.AS400JDBCConnectionPoolDataSource", arrayList);
        commonPropListMap.put("com.ibm.as400.access.AS400JDBCXADataSource", arrayList);
        arrayList = new ArrayList(5);
        arrayList.add(new DSPropertyEntry(DATA_STORE_HELPER_CLASS, String.class, true, (Object)DB2AS400_HELPER_NAME));
        arrayList.add(new DSPropertyEntry(DATABASE_NAME, String.class, false, (Object)"localhost"));
        arrayList.add(new DSPropertyEntry(USER, String.class, false, null));
        arrayList.add(new DSPropertyEntry(PASSWORD, String.class, false, null));
        arrayList.add(new DSPropertyEntry("connectionAttribute", String.class, false, (Object)"cursorhold=0"));
        commonPropListMap.put("com.ibm.db2.jdbc.app.DB2StdConnectionPoolDataSource", arrayList);
        commonPropListMap.put("com.ibm.db2.jdbc.app.DB2StdXADataSource", arrayList);
        commonPropListMap.put("com.ibm.db2.jdbc.app.UDBConnectionPoolDataSource", arrayList);
        commonPropListMap.put("com.ibm.db2.jdbc.app.UDBXADataSource", arrayList);
        arrayList = new ArrayList(8);
        arrayList.add(new DSPropertyEntry(DATA_STORE_HELPER_CLASS, String.class, true, (Object)INFORMIX_HELPER_NAME));
        arrayList.add(new DSPropertyEntry(DATABASE_NAME, String.class, true, (Object)"sample"));
        arrayList.add(new DSPropertyEntry(SERVER_NAME, String.class, true, (Object)"informix_server"));
        arrayList.add(new DSPropertyEntry(PORT_NUMBER, Integer.TYPE, true, (Object)new Integer(1526)));
        arrayList.add(new DSPropertyEntry("ifxIFXHOST", String.class, true, (Object)"localhost"));
        arrayList.add(new DSPropertyEntry(INFORMIX_LOCK_MODE_WAIT, Integer.TYPE, true, (Object)new Integer(2)));
        arrayList.add(new DSPropertyEntry(USER, String.class, false, null));
        arrayList.add(new DSPropertyEntry(PASSWORD, String.class, false, null));
        commonPropListMap.put("com.informix.jdbcx.IfxConnectionPoolDataSource", arrayList);
        commonPropListMap.put("com.informix.jdbcx.IfxXADataSource", arrayList);
        arrayList = new ArrayList(2);
        arrayList.add(new DSPropertyEntry(DATA_STORE_HELPER_CLASS, String.class, true, (Object)GENERIC_HELPER_NAME));
        arrayList.add(new DSPropertyEntry("url", String.class, true, (Object)"jdbc:idb:sample.prp"));
        commonPropListMap.put("com.ibm.ejs.cm.portability.IDBConnectionPoolDataSource", arrayList);
        arrayList = new ArrayList(6);
        arrayList.add(new DSPropertyEntry(DATA_STORE_HELPER_CLASS, String.class, true, (Object)WSCONNECTJDBC_HELPER_NAME));
        arrayList.add(new DSPropertyEntry(DATABASE_NAME, String.class, true, (Object)"sample"));
        arrayList.add(new DSPropertyEntry(SERVER_NAME, String.class, true, (Object)"localhost"));
        arrayList.add(new DSPropertyEntry(PORT_NUMBER, Integer.TYPE, true, (Object)new Integer(1433)));
        arrayList.add(new DSPropertyEntry(USER, String.class, false, null));
        arrayList.add(new DSPropertyEntry(PASSWORD, String.class, false, null));
        commonPropListMap.put("com.ibm.websphere.jdbcx.sqlserver.SQLServerDataSource", arrayList);
        commonPropListMap.put("com.ibm.websphere.jdbcx.sqlserver.SQLServerDataSource (single phase)", arrayList);
        commonPropListMap.put("com.ibm.websphere.jdbcx.sqlserver.SQLServerDataSource (XA)", arrayList);
        arrayList = new ArrayList(6);
        arrayList.add(new DSPropertyEntry(DATA_STORE_HELPER_CLASS, String.class, true, (Object)CONNECTJDBC_HELPER_NAME));
        arrayList.add(new DSPropertyEntry(DATABASE_NAME, String.class, true, (Object)"sample"));
        arrayList.add(new DSPropertyEntry(SERVER_NAME, String.class, true, (Object)"localhost"));
        arrayList.add(new DSPropertyEntry(PORT_NUMBER, Integer.TYPE, true, (Object)new Integer(1433)));
        arrayList.add(new DSPropertyEntry(USER, String.class, false, null));
        arrayList.add(new DSPropertyEntry(PASSWORD, String.class, false, null));
        commonPropListMap.put("com.ddtek.jdbcx.sqlserver.SQLServerDataSource", arrayList);
        commonPropListMap.put("com.ddtek.jdbcx.sqlserver.SQLServerDataSource (single phase)", arrayList);
        commonPropListMap.put("com.ddtek.jdbcx.sqlserver.SQLServerDataSource (XA)", arrayList);
        arrayList = new ArrayList(7);
        arrayList.add(new DSPropertyEntry(DATA_STORE_HELPER_CLASS, String.class, true, (Object)CONNECTJDBC_HELPER_NAME));
        arrayList.add(new DSPropertyEntry(DATABASE_NAME, String.class, true, (Object)"sample"));
        arrayList.add(new DSPropertyEntry(SERVER_NAME, String.class, true, (Object)"localhost"));
        arrayList.add(new DSPropertyEntry(PORT_NUMBER, Integer.TYPE, true, (Object)new Integer(1433)));
        arrayList.add(new DSPropertyEntry(USER, String.class, false, null));
        arrayList.add(new DSPropertyEntry(PASSWORD, String.class, false, null));
        arrayList.add(new DSPropertyEntry("selectMethod", String.class, false, (Object)"cursor"));
        commonPropListMap.put("com.microsoft.jdbcx.sqlserver.SQLServerDataSource", arrayList);
        commonPropListMap.put("com.microsoft.jdbcx.sqlserver.SQLServerDataSource (single phase)", arrayList);
        commonPropListMap.put("com.microsoft.jdbcx.sqlserver.SQLServerDataSource (XA)", arrayList);
        arrayList = new ArrayList(6);
        arrayList.add(new DSPropertyEntry(DATA_STORE_HELPER_CLASS, String.class, true, (Object)SEQUELINK_HELPER_NAME));
        arrayList.add(new DSPropertyEntry(DATABASE_NAME, String.class, true, (Object)"sample"));
        arrayList.add(new DSPropertyEntry(SERVER_NAME, String.class, true, (Object)"localhost"));
        arrayList.add(new DSPropertyEntry(PORT_NUMBER, Integer.TYPE, true, (Object)new Integer(19996)));
        arrayList.add(new DSPropertyEntry(USER, String.class, false, null));
        arrayList.add(new DSPropertyEntry(PASSWORD, String.class, false, null));
        commonPropListMap.put("com.ddtek.jdbcx.sequelink.SequeLinkDataSource", arrayList);
        commonPropListMap.put("com.ddtek.jdbcx.sequelink.SequeLinkDataSource (single phase)", arrayList);
        commonPropListMap.put("com.ddtek.jdbcx.sequelink.SequeLinkDataSource (XA)", arrayList);
        arrayList = new ArrayList(4);
        arrayList.add(new DSPropertyEntry(DATA_STORE_HELPER_CLASS, String.class, true, (Object)ORACLE_HELPER_NAME));
        arrayList.add(new DSPropertyEntry("URL", String.class, true, (Object)"jdbc:oracle:thin:dbuser1/dbpwd1@localhost:1521:sample"));
        arrayList.add(new DSPropertyEntry(USER, String.class, false, null));
        arrayList.add(new DSPropertyEntry(PASSWORD, String.class, false, null));
        commonPropListMap.put("oracle.jdbc.pool.OracleConnectionPoolDataSource", arrayList);
        commonPropListMap.put("oracle.jdbc.xa.client.OracleXADataSource", arrayList);
        arrayList = new ArrayList(6);
        arrayList.add(new DSPropertyEntry(DATA_STORE_HELPER_CLASS, String.class, true, (Object)SYBASE_HELPER_NAME));
        arrayList.add(new DSPropertyEntry(DATABASE_NAME, String.class, true, (Object)"sample"));
        arrayList.add(new DSPropertyEntry(SERVER_NAME, String.class, true, (Object)"localhost"));
        arrayList.add(new DSPropertyEntry(PORT_NUMBER, Integer.TYPE, true, (Object)new Integer(4100)));
        arrayList.add(new DSPropertyEntry(USER, String.class, false, null));
        arrayList.add(new DSPropertyEntry(PASSWORD, String.class, false, null));
        commonPropListMap.put("com.sybase.jdbc2.jdbc.SybConnectionPoolDataSource", arrayList);
        commonPropListMap.put("com.sybase.jdbc2.jdbc.SybXADataSource", arrayList);
        arrayList = new ArrayList(4);
        arrayList.add(new DSPropertyEntry(DATA_STORE_HELPER_CLASS, String.class, true, (Object)DERBY_HELPER_NAME));
        arrayList.add(new DSPropertyEntry(DATABASE_NAME, String.class, true, (Object)"e:/sample"));
        commonPropListMap.put("org.apache.derby.jdbc.EmbeddedConnectionPoolDataSource", arrayList);
        commonPropListMap.put("org.apache.derby.jdbc.EmbeddedXADataSource", arrayList);
        arrayList = new ArrayList(4);
        arrayList.add(new DSPropertyEntry(DATA_STORE_HELPER_CLASS, String.class, true, (Object)CLOUDSCAPE_HELPER_NAME));
        arrayList.add(new DSPropertyEntry(DATABASE_NAME, String.class, true, (Object)"e:/sample"));
        commonPropListMap.put("com.ibm.db2j.jdbc.DB2jConnectionPoolDataSource", arrayList);
        commonPropListMap.put("com.ibm.db2j.jdbc.DB2jXADataSource", arrayList);
    }
}

