/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteServer;
import java.rmi.server.RemoteStub;
import java.rmi.server.ServerCloneException;
import java.rmi.server.ServerRef;
import sun.rmi.transport.ObjectTable;

public class UnicastRemoteObject
extends RemoteServer {
    private int port = 0;
    private RMIClientSocketFactory csf = null;
    private RMIServerSocketFactory ssf = null;
    private static final long serialVersionUID = 4974527148936298033L;
    private static Class[] portParamTypes = new Class[]{Integer.TYPE};
    private static Class[] portFactoryParamTypes = new Class[]{Integer.TYPE, RMIClientSocketFactory.class, RMIServerSocketFactory.class};

    protected UnicastRemoteObject() throws RemoteException {
        this(0);
    }

    protected UnicastRemoteObject(int n) throws RemoteException {
        this.port = n;
        UnicastRemoteObject.exportObject(this, n);
    }

    protected UnicastRemoteObject(int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) throws RemoteException {
        this.port = n;
        this.csf = rMIClientSocketFactory;
        this.ssf = rMIServerSocketFactory;
        UnicastRemoteObject.exportObject((Remote)this, n, rMIClientSocketFactory, rMIServerSocketFactory);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.reexport();
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            UnicastRemoteObject unicastRemoteObject = (UnicastRemoteObject)super.clone();
            unicastRemoteObject.reexport();
            return unicastRemoteObject;
        }
        catch (RemoteException remoteException) {
            throw new ServerCloneException("Clone failed", remoteException);
        }
    }

    private void reexport() throws RemoteException {
        if (this.csf == null && this.ssf == null) {
            UnicastRemoteObject.exportObject(this, this.port);
        } else {
            UnicastRemoteObject.exportObject((Remote)this, this.port, this.csf, this.ssf);
        }
    }

    public static RemoteStub exportObject(Remote remote) throws RemoteException {
        return (RemoteStub)UnicastRemoteObject.exportObject(remote, 0);
    }

    public static Remote exportObject(Remote remote, int n) throws RemoteException {
        Object[] objectArray = new Object[]{new Integer(n)};
        return UnicastRemoteObject.exportObject(remote, "UnicastServerRef", portParamTypes, objectArray);
    }

    public static Remote exportObject(Remote remote, int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) throws RemoteException {
        Object[] objectArray = new Object[]{new Integer(n), rMIClientSocketFactory, rMIServerSocketFactory};
        return UnicastRemoteObject.exportObject(remote, "UnicastServerRef2", portFactoryParamTypes, objectArray);
    }

    public static boolean unexportObject(Remote remote, boolean bl) throws NoSuchObjectException {
        return ObjectTable.unexportObject(remote, bl);
    }

    private static Remote exportObject(Remote remote, String string, Class[] classArray, Object[] objectArray) throws RemoteException {
        ServerRef serverRef;
        Class<?> clazz;
        String string2 = "sun.rmi.server." + string;
        try {
            clazz = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ExportException("No class found for server ref type: " + string);
        }
        if (!ServerRef.class.isAssignableFrom(clazz)) {
            throw new ExportException("Server ref class not instance of " + ServerRef.class.getName() + ": " + clazz.getName());
        }
        try {
            Constructor<?> constructor = clazz.getConstructor(classArray);
            serverRef = (ServerRef)constructor.newInstance(objectArray);
            if (remote instanceof UnicastRemoteObject) {
                ((UnicastRemoteObject)remote).ref = serverRef;
            }
        }
        catch (Exception exception) {
            throw new ExportException("Exception creating instance of server ref class: " + clazz.getName(), exception);
        }
        return serverRef.exportObject(remote, null);
    }
}

