/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vap.converters.streams;

import com.ibm.vap.converters.streams.ContextObjectInputStream;
import com.ibm.vap.converters.streams.VapBinaryStreamToObjectConverter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.sql.Blob;
import javax.ejb.EJBObject;
import javax.ejb.Handle;

public class BinaryStreamToEJBObjectConverter
extends VapBinaryStreamToObjectConverter {
    static BinaryStreamToEJBObjectConverter singleton = null;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 2001";

    public Object dataFrom(Object obj) {
        if (obj == null) {
            return null;
        }
        byte[] object = null;
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            ObjectOutputStream objectStream = new ObjectOutputStream(byteStream);
            Handle handle = ((EJBObject)obj).getHandle();
            objectStream.writeObject(handle);
            objectStream.flush();
            object = byteStream.toByteArray();
        }
        catch (Exception exception) {
            RuntimeException runtimeexception = new RuntimeException(exception.getMessage());
            runtimeexception.fillInStackTrace();
            throw runtimeexception;
        }
        return object;
    }

    public static String getTargetClassName() {
        return "javax.ejb.EJBObject";
    }

    public Object objectFrom(Object obj) {
        if (obj == null) {
            return null;
        }
        EJBObject result = null;
        try {
            InputStream objStream = null;
            objStream = obj instanceof InputStream ? (InputStream)obj : (obj instanceof Blob ? ((Blob)obj).getBinaryStream() : new ByteArrayInputStream((byte[])obj));
            ContextObjectInputStream inputStream = new ContextObjectInputStream(objStream);
            result = ((Handle)inputStream.readObject()).getEJBObject();
        }
        catch (Exception exception) {
            RuntimeException runtimeexception = new RuntimeException(exception.getMessage());
            runtimeexception.fillInStackTrace();
            throw runtimeexception;
        }
        return result;
    }

    public static void reset() {
        singleton = null;
    }

    public static BinaryStreamToEJBObjectConverter singleton() {
        if (singleton == null) {
            singleton = new BinaryStreamToEJBObjectConverter();
        }
        return singleton;
    }
}

