/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vap.composers;

import java.io.Serializable;

public class VapUSPhoneNumber
implements Serializable {
    private String areaCode;
    private String zonePrefix;
    private String fourDigitNumber;

    public VapUSPhoneNumber(String aString) {
        this.fromString(aString);
    }

    public VapUSPhoneNumber(String anAreaCode, String aZonePrefix, String aNumber) {
        this.setAreaCode(anAreaCode);
        this.setZonePrefix(aZonePrefix);
        this.setFourDigitNumber(aNumber);
    }

    public String getAreaCode() {
        if (this.areaCode == null) {
            this.areaCode = this.defaultAreaCode();
        }
        return this.areaCode;
    }

    public void setAreaCode(String aNumber) {
        this.areaCode = aNumber;
    }

    public String defaultAreaCode() {
        return "xxx";
    }

    public String defaultPhoneNumber() {
        return "xxxxxxx";
    }

    public String getFourDigitNumber() {
        return this.fourDigitNumber;
    }

    public void fromString(String aString) {
        StringBuffer aBuffer = new StringBuffer();
        int i = 0;
        while (i < aString.length()) {
            char aChar = aString.charAt(i);
            if (Character.isDigit(aChar)) {
                aBuffer.append(aChar);
            }
            ++i;
        }
        String digitString = aBuffer.toString();
        if (digitString.length() == 10) {
            this.setAreaCode(digitString.substring(0, 3));
            this.setZonePrefix(digitString.substring(3, 7));
            this.setFourDigitNumber(digitString.substring(7));
        }
        if (digitString.length() == 7) {
            this.setZonePrefix(digitString.substring(0, 3));
            this.setFourDigitNumber(digitString.substring(3));
        }
    }

    public boolean isValid() {
        return !this.getAreaCode().equals(this.defaultAreaCode()) && !this.phoneNumber().equals(this.defaultPhoneNumber());
    }

    public String phoneNumber() {
        if (this.zonePrefix == null || this.fourDigitNumber == null) {
            return this.defaultPhoneNumber();
        }
        return String.valueOf(this.zonePrefix) + this.fourDigitNumber;
    }

    public String getZonePrefix() {
        return this.zonePrefix;
    }

    public String toHyphenDelimitedString() {
        StringBuffer aBuffer = new StringBuffer();
        aBuffer.append(this.getAreaCode());
        aBuffer.append("-");
        aBuffer.append(this.getZonePrefix());
        aBuffer.append("-");
        aBuffer.append(this.getFourDigitNumber());
        return aBuffer.toString();
    }

    public String toString() {
        StringBuffer aBuffer = new StringBuffer();
        aBuffer.append("(");
        aBuffer.append(this.getAreaCode());
        aBuffer.append(")");
        aBuffer.append(this.getZonePrefix());
        aBuffer.append("-");
        aBuffer.append(this.getFourDigitNumber());
        return aBuffer.toString();
    }

    public void setFourDigitNumber(String fourDigitNumber) {
        this.fourDigitNumber = fourDigitNumber;
    }

    public void setZonePrefix(String zonePrefix) {
        this.zonePrefix = zonePrefix;
    }
}

