/*
 * Decompiled with CFR 0.152.
 */
package javax.security.cert;

import java.security.PublicKey;
import javax.security.cert.CertPathValidatorResult;
import javax.security.cert.PolicyNode;
import javax.security.cert.TrustAnchor;

public class PKIXCertPathValidatorResult
implements CertPathValidatorResult {
    private TrustAnchor trustAnchor;
    private PolicyNode policyTree;
    private PublicKey subjectPubKey;

    public PKIXCertPathValidatorResult(TrustAnchor trustAnchor, PolicyNode policyNode, PublicKey publicKey) {
        if (publicKey == null) {
            throw new NullPointerException("subject public key must not be null");
        }
        if (trustAnchor == null) {
            throw new NullPointerException("trustAnchor must not be null");
        }
        this.trustAnchor = trustAnchor;
        this.policyTree = policyNode;
        this.subjectPubKey = publicKey;
    }

    public TrustAnchor getTrustAnchor() {
        return this.trustAnchor;
    }

    public PolicyNode getPolicyTree() {
        return this.policyTree;
    }

    public PublicKey getPublicKey() {
        return this.subjectPubKey;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public String toString() {
        return "PKIXCertPathValidatorResult:\nTrust Anchor\t" + this.trustAnchor + "\n" + "Policy Tree\t" + this.policyTree + "\n" + "Subject Public Key\t" + this.subjectPubKey;
    }
}

