/*
 * Decompiled with CFR 0.152.
 */
package javax.security.cert;

import java.io.IOException;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertSelector;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.cert.CertPath$I;
import javax.security.cert.CertPathBuilderException;
import javax.security.cert.CertPathBuilderResult;
import javax.security.cert.CertPathParameters;
import javax.security.cert.CertStore;
import javax.security.cert.CertStoreParameters;
import javax.security.cert.CollectionCertStoreParameters;
import javax.security.cert.LDAPCertStoreParameters;
import javax.security.cert.PKIXBuilderParameters;
import javax.security.cert.PKIXCertPathBuilderResult;
import javax.security.cert.PKIXCertPathChecker;
import javax.security.cert.PKIXCertPathChecker$I;
import javax.security.cert.PolicyNode$I;
import javax.security.cert.TrustAnchor;
import javax.security.cert.X509CertSelector;

public class CertPathBuilder {
    private java.security.cert.CertPathBuilder builder;

    private CertPathBuilder() {
    }

    public static CertPathBuilder getInstance(String string) throws NoSuchAlgorithmException {
        try {
            CertPathBuilder certPathBuilder = new CertPathBuilder();
            certPathBuilder.builder = java.security.cert.CertPathBuilder.getInstance(string);
            return certPathBuilder;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new NoSuchAlgorithmException(string + " not found");
        }
    }

    public static CertPathBuilder getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        try {
            CertPathBuilder certPathBuilder = new CertPathBuilder();
            certPathBuilder.builder = java.security.cert.CertPathBuilder.getInstance(string, string2);
            return certPathBuilder;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new NoSuchAlgorithmException(string + " not found");
        }
    }

    public static CertPathBuilder getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        try {
            CertPathBuilder certPathBuilder = new CertPathBuilder();
            certPathBuilder.builder = java.security.cert.CertPathBuilder.getInstance(string, provider);
            return certPathBuilder;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new NoSuchAlgorithmException(string + " not found");
        }
    }

    public final Provider getProvider() {
        return this.builder.getProvider();
    }

    public final String getAlgorithm() {
        return this.builder.getAlgorithm();
    }

    public final CertPathBuilderResult build(CertPathParameters certPathParameters) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        try {
            Object object;
            Cloneable cloneable;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            PKIXBuilderParameters pKIXBuilderParameters = null;
            try {
                pKIXBuilderParameters = (PKIXBuilderParameters)certPathParameters;
            }
            catch (ClassCastException classCastException) {
                throw new InvalidAlgorithmParameterException("Parameters are not an instance of PKIXBuilderParameters");
            }
            Set set = pKIXBuilderParameters.getTrustAnchors();
            Iterator iterator = set.iterator();
            HashSet<java.security.cert.TrustAnchor> hashSet = new HashSet<java.security.cert.TrustAnchor>();
            java.security.cert.TrustAnchor trustAnchor = null;
            while (iterator.hasNext()) {
                object5 = (TrustAnchor)iterator.next();
                object4 = ((TrustAnchor)object5).getTrustedCert();
                trustAnchor = null;
                try {
                    trustAnchor = object4 != null ? new java.security.cert.TrustAnchor((X509Certificate)object4, ((TrustAnchor)object5).getNameConstraints()) : new java.security.cert.TrustAnchor(((TrustAnchor)object5).getCAName(), ((TrustAnchor)object5).getCAPublicKey(), ((TrustAnchor)object5).getNameConstraints());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (trustAnchor == null) continue;
                hashSet.add(trustAnchor);
            }
            object5 = null;
            try {
                object5 = (X509CertSelector)pKIXBuilderParameters.getTargetCertConstraints();
            }
            catch (ClassCastException classCastException) {
                throw new CertPathBuilderException("Target constraints not X509CertSelector type");
            }
            object4 = null;
            if (object5 != null) {
                object4 = new java.security.cert.X509CertSelector();
                try {
                    ((java.security.cert.X509CertSelector)object4).setAuthorityKeyIdentifier(((X509CertSelector)object5).getAuthorityKeyIdentifier());
                    ((java.security.cert.X509CertSelector)object4).setBasicConstraints(((X509CertSelector)object5).getBasicConstraints());
                    ((java.security.cert.X509CertSelector)object4).setCertificate(((X509CertSelector)object5).getCertificate());
                    ((java.security.cert.X509CertSelector)object4).setCertificateValid(((X509CertSelector)object5).getCertificateValid());
                    ((java.security.cert.X509CertSelector)object4).setExtendedKeyUsage(((X509CertSelector)object5).getExtendedKeyUsage());
                    ((java.security.cert.X509CertSelector)object4).setIssuer(((X509CertSelector)object5).getIssuerAsBytes());
                    ((java.security.cert.X509CertSelector)object4).setIssuer(((X509CertSelector)object5).getIssuerAsString());
                    ((java.security.cert.X509CertSelector)object4).setKeyUsage(((X509CertSelector)object5).getKeyUsage());
                    ((java.security.cert.X509CertSelector)object4).setMatchAllSubjectAltNames(((X509CertSelector)object5).getMatchAllSubjectAltNames());
                    ((java.security.cert.X509CertSelector)object4).setNameConstraints(((X509CertSelector)object5).getNameConstraints());
                    ((java.security.cert.X509CertSelector)object4).setPathToNames(((X509CertSelector)object5).getPathToNames());
                    ((java.security.cert.X509CertSelector)object4).setPolicy(((X509CertSelector)object5).getPolicy());
                    ((java.security.cert.X509CertSelector)object4).setPrivateKeyValid(((X509CertSelector)object5).getPrivateKeyValid());
                    ((java.security.cert.X509CertSelector)object4).setSerialNumber(((X509CertSelector)object5).getSerialNumber());
                    ((java.security.cert.X509CertSelector)object4).setSubject(((X509CertSelector)object5).getSubjectAsString());
                    ((java.security.cert.X509CertSelector)object4).setSubjectAlternativeNames(((X509CertSelector)object5).getSubjectAlternativeNames());
                    ((java.security.cert.X509CertSelector)object4).setSubjectKeyIdentifier(((X509CertSelector)object5).getSubjectKeyIdentifier());
                    ((java.security.cert.X509CertSelector)object4).setSubjectPublicKey(((X509CertSelector)object5).getSubjectPublicKey());
                    ((java.security.cert.X509CertSelector)object4).setSubjectPublicKeyAlgID(((X509CertSelector)object5).getSubjectPublicKeyAlgID());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            List list = pKIXBuilderParameters.getCertPathCheckers();
            ArrayList<java.security.cert.PKIXCertPathChecker> arrayList = new ArrayList<java.security.cert.PKIXCertPathChecker>();
            if (list != null) {
                object3 = list.iterator();
                while (object3.hasNext()) {
                    object2 = (PKIXCertPathChecker)iterator.next();
                    cloneable = new PKIXCertPathChecker$I((PKIXCertPathChecker)object2);
                    arrayList.add((java.security.cert.PKIXCertPathChecker)cloneable);
                }
            }
            object3 = pKIXBuilderParameters.getCertStores();
            object2 = null;
            cloneable = null;
            CertStoreParameters certStoreParameters = null;
            ArrayList<java.security.cert.CertStore> arrayList2 = null;
            if (object3 != null) {
                arrayList2 = new ArrayList<java.security.cert.CertStore>();
                iterator = object3.iterator();
                while (iterator.hasNext()) {
                    object = (CertStore)iterator.next();
                    certStoreParameters = ((CertStore)object).getCertStoreParameters();
                    if (certStoreParameters instanceof LDAPCertStoreParameters) {
                        cloneable = new java.security.cert.LDAPCertStoreParameters(((LDAPCertStoreParameters)certStoreParameters).getServerName(), ((LDAPCertStoreParameters)certStoreParameters).getPort());
                    } else if (certStoreParameters instanceof CollectionCertStoreParameters) {
                        cloneable = new java.security.cert.CollectionCertStoreParameters(((CollectionCertStoreParameters)certStoreParameters).getCollection());
                    } else {
                        throw new InvalidAlgorithmParameterException("Invalid algorithm parameters");
                    }
                    try {
                        object2 = java.security.cert.CertStore.getInstance(((CertStore)object).getType(), (java.security.cert.CertStoreParameters)cloneable);
                        arrayList2.add((java.security.cert.CertStore)object2);
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
                }
            }
            object = new java.security.cert.PKIXBuilderParameters(hashSet, (CertSelector)object4);
            ((PKIXParameters)object).setAnyPolicyInhibited(pKIXBuilderParameters.isAnyPolicyInhibited());
            ((PKIXParameters)object).setCertPathCheckers(arrayList);
            ((PKIXParameters)object).setCertStores(arrayList2);
            ((PKIXParameters)object).setDate(pKIXBuilderParameters.getDate());
            ((PKIXParameters)object).setExplicitPolicyRequired(pKIXBuilderParameters.isExplicitPolicyRequired());
            ((PKIXParameters)object).setInitialPolicies(pKIXBuilderParameters.getInitialPolicies());
            ((java.security.cert.PKIXBuilderParameters)object).setMaxPathLength(pKIXBuilderParameters.getMaxPathLength());
            ((PKIXParameters)object).setPolicyMappingInhibited(pKIXBuilderParameters.isPolicyMappingInhibited());
            ((PKIXParameters)object).setPolicyQualifiersRejected(pKIXBuilderParameters.getPolicyQualifiersRejected());
            ((PKIXParameters)object).setRevocationEnabled(pKIXBuilderParameters.isRevocationEnabled());
            ((PKIXParameters)object).setSigProvider(pKIXBuilderParameters.getSigProvider());
            ((PKIXParameters)object).setTargetCertConstraints((CertSelector)object4);
            ((PKIXParameters)object).setTrustAnchors(hashSet);
            java.security.cert.PKIXCertPathBuilderResult pKIXCertPathBuilderResult = (java.security.cert.PKIXCertPathBuilderResult)this.builder.build((java.security.cert.CertPathParameters)object);
            PolicyNode$I policyNode$I = new PolicyNode$I(pKIXCertPathBuilderResult.getPolicyTree());
            TrustAnchor trustAnchor2 = new TrustAnchor(pKIXCertPathBuilderResult.getTrustAnchor());
            CertPath$I certPath$I = new CertPath$I(pKIXCertPathBuilderResult.getCertPath());
            return new PKIXCertPathBuilderResult(certPath$I, trustAnchor2, policyNode$I, pKIXCertPathBuilderResult.getPublicKey());
        }
        catch (java.security.cert.CertPathBuilderException certPathBuilderException) {
            throw new CertPathBuilderException(certPathBuilderException.getMessage());
        }
    }

    public static final String getDefaultType() {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Security.getProperty("certpathbuilder.type");
            }
        });
        if (string == null) {
            string = "PKIX";
        }
        return string;
    }
}

