/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.soap;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

public abstract class SOAPFactory {
    private static final String SF_PROPERTY = "javax.xml.soap.SOAPFactory";
    private static final String DEFAULT_SF = "com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory";

    public abstract SOAPElement createElement(Name var1) throws SOAPException;

    public abstract SOAPElement createElement(String var1) throws SOAPException;

    public abstract SOAPElement createElement(String var1, String var2, String var3) throws SOAPException;

    public abstract Detail createDetail() throws SOAPException;

    public abstract Name createName(String var1, String var2, String var3) throws SOAPException;

    public abstract Name createName(String var1) throws SOAPException;

    public static SOAPFactory newInstance() throws SOAPException {
        try {
            String factoryPropertyName = SF_PROPERTY;
            String defaultFactoryClassName = DEFAULT_SF;
            ClassLoader classloader = Thread.currentThread().getContextClassLoader();
            String factoryClassName = System.getProperty(factoryPropertyName);
            if (factoryClassName == null) {
                String factoryResource = "META-INF/services/" + factoryPropertyName;
                InputStream inputstream = null;
                inputstream = classloader == null ? ClassLoader.getSystemResourceAsStream(factoryResource) : classloader.getResourceAsStream(factoryResource);
                if (inputstream != null) {
                    BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(inputstream, "UTF-8"));
                    factoryClassName = bufferedreader.readLine();
                    bufferedreader.close();
                }
            }
            if (factoryClassName == null) {
                factoryClassName = defaultFactoryClassName;
            }
            if (factoryClassName == null) {
                throw new SOAPException("Provider for " + factoryPropertyName + " cannot be found", null);
            }
            Class<?> factoryClass = classloader == null ? Class.forName(factoryClassName) : classloader.loadClass(factoryClassName);
            Object factory = factoryClass.newInstance();
            return (SOAPFactory)factory;
        }
        catch (Exception exception) {
            throw new SOAPException("Unable to create SOAP Factory: " + exception.getMessage());
        }
    }
}

