/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.soap;

import com.ibm.ws.ffdc.FFDCFilter;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPException;

public abstract class SOAPConnectionFactory {
    private static final String DEFAULT_SOAP_CONNECTION_FACTORY = "com.ibm.ws.webservices.engine.soap.SOAPConnectionFactoryImpl";
    private static final String SF_PROPERTY = "javax.xml.soap.SOAPConnectionFactory";

    public static SOAPConnectionFactory newInstance() throws SOAPException, UnsupportedOperationException {
        try {
            String factoryPropertyName = SF_PROPERTY;
            String defaultFactoryClassName = DEFAULT_SOAP_CONNECTION_FACTORY;
            ClassLoader classloader = Thread.currentThread().getContextClassLoader();
            String factoryClassName = System.getProperty(factoryPropertyName);
            if (factoryClassName == null) {
                String factoryResource = "META-INF/services/" + factoryPropertyName;
                InputStream inputstream = null;
                inputstream = classloader == null ? ClassLoader.getSystemResourceAsStream(factoryResource) : classloader.getResourceAsStream(factoryResource);
                if (inputstream != null) {
                    BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(inputstream, "UTF-8"));
                    factoryClassName = bufferedreader.readLine();
                    bufferedreader.close();
                }
            }
            if (factoryClassName == null) {
                factoryClassName = defaultFactoryClassName;
            }
            if (factoryClassName == null) {
                throw new SOAPException("Provider for " + factoryPropertyName + " cannot be found", null);
            }
            Class<?> factoryClass = classloader == null ? Class.forName(factoryClassName) : classloader.loadClass(factoryClassName);
            Object factory = factoryClass.newInstance();
            return (SOAPConnectionFactory)factory;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"javax.xml.soap.SOAPConnectionFactory.newInstance", (String)"79");
            throw new SOAPException("Unable to create SOAP connection factory: " + exception.getMessage());
        }
    }

    public abstract SOAPConnection createConnection() throws SOAPException;
}

