/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11.provider;

import com.ibm.crypto.pkcs11.provider.PKCS11RSAKeyPairParameterSpec;
import com.ibm.crypto.pkcs11.provider.RSAPKCS11PrivateKey;
import com.ibm.crypto.pkcs11.provider.RSAPKCS11PublicKey;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public final class RSAPKCS11KeyPairGenerator
extends KeyPairGeneratorSpi {
    private int modlen = 1024;
    private PKCS11Session[] openSessions = null;
    private String label = null;
    SecureRandom random = null;
    private boolean extractAttr = true;
    private boolean sensitive = false;

    private boolean checkIfExtractable() {
        byte[] byArray = "testid".getBytes();
        int[] nArray = new int[]{1, 258, 260, 266, 289, 290};
        Object[] objectArray = new Object[]{Boolean.FALSE, byArray, Boolean.TRUE, Boolean.TRUE, new Integer(this.modlen), new BigInteger("65537")};
        int[] nArray2 = new int[]{1, 2, 258, 259, 261, 264, 354};
        Object[] objectArray2 = new Object[]{Boolean.FALSE, Boolean.TRUE, byArray, Boolean.FALSE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE};
        boolean bl = false;
        int n = 0;
        String string = "";
        PKCS11Object[] pKCS11ObjectArray = null;
        Object var10_10 = null;
        boolean bl2 = false;
        while (!bl) {
            if (n >= this.openSessions.length) {
                return false;
            }
            try {
                pKCS11ObjectArray = this.openSessions[n].generateKeyPair(0, null, nArray, objectArray, nArray2, objectArray2);
                bl = true;
            }
            catch (Exception exception) {
                string = String.valueOf(string) + n + "." + exception.getMessage() + " ";
                ++n;
            }
        }
        return true;
    }

    private boolean checkIfSensitive() {
        byte[] byArray = "testid".getBytes();
        int[] nArray = new int[]{1, 258, 260, 266, 289, 290};
        Object[] objectArray = new Object[]{Boolean.FALSE, byArray, Boolean.TRUE, Boolean.TRUE, new Integer(this.modlen), new BigInteger("65537")};
        int[] nArray2 = new int[]{1, 2, 258, 259, 261, 264};
        Object[] objectArray2 = new Object[]{Boolean.FALSE, Boolean.TRUE, byArray, Boolean.FALSE, Boolean.TRUE, Boolean.TRUE};
        boolean bl = false;
        int n = 0;
        String string = "";
        PKCS11Object[] pKCS11ObjectArray = null;
        Object var10_10 = null;
        boolean bl2 = false;
        while (!bl) {
            if (n >= this.openSessions.length) {
                return true;
            }
            try {
                pKCS11ObjectArray = this.openSessions[n].generateKeyPair(0, null, nArray, objectArray, nArray2, objectArray2);
                bl = true;
            }
            catch (Exception exception) {
                string = String.valueOf(string) + n + "." + exception.getMessage() + " ";
                ++n;
            }
        }
        return false;
    }

    private boolean checkKeyPairGeneration() throws InvalidAlgorithmParameterException {
        byte[] byArray = "testid".getBytes();
        int[] nArray = new int[]{1, 258, 260, 266, 289, 290};
        Object[] objectArray = new Object[]{Boolean.FALSE, byArray, Boolean.TRUE, Boolean.TRUE, new Integer(this.modlen), new BigInteger("65537")};
        int[] nArray2 = new int[]{1, 2, 258, 261, 264};
        Object[] objectArray2 = new Object[]{Boolean.FALSE, Boolean.TRUE, byArray, Boolean.TRUE, Boolean.TRUE};
        boolean bl = false;
        int n = 0;
        String string = "";
        PKCS11Object[] pKCS11ObjectArray = null;
        Object var10_10 = null;
        boolean bl2 = false;
        while (!bl) {
            if (n >= this.openSessions.length) {
                throw new InvalidAlgorithmParameterException("Cannot generate key pair: " + string);
            }
            try {
                pKCS11ObjectArray = this.openSessions[n].generateKeyPair(0, null, nArray, objectArray, nArray2, objectArray2);
                bl2 = false;
                PKCS11Object[] pKCS11ObjectArray2 = this.orderObjects(pKCS11ObjectArray);
                PKCS11Object pKCS11Object = pKCS11ObjectArray2[0];
                PKCS11Object pKCS11Object2 = pKCS11ObjectArray2[1];
                int[] nArray3 = new int[]{1};
                Object[] objectArray3 = new Object[]{Boolean.TRUE};
                try {
                    PKCS11Object pKCS11Object3 = pKCS11Object2.copy(nArray3, objectArray3);
                    pKCS11Object3.destroy();
                    pKCS11Object2.destroy();
                    pKCS11Object.destroy();
                    bl = true;
                }
                catch (Exception exception) {
                    pKCS11Object2.destroy();
                    pKCS11Object.destroy();
                    return false;
                }
            }
            catch (Exception exception) {
                string = String.valueOf(string) + n + "." + exception.getMessage() + " ";
                ++n;
            }
        }
        return true;
    }

    public KeyPair generateKeyPair() {
        byte[] byArray = new byte[20];
        this.random.nextBytes(byArray);
        int[] nArray = new int[]{1, 258, 260, 266, 289, 290};
        Object[] objectArray = new Object[]{Boolean.FALSE, byArray, Boolean.TRUE, Boolean.TRUE, new Integer(this.modlen), new BigInteger("65537")};
        int[] nArray2 = new int[]{1, 2, 258, 259, 261, 264, 354};
        Object[] objectArray2 = new Object[]{Boolean.FALSE, Boolean.TRUE, byArray, Boolean.FALSE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE};
        int[] nArray3 = new int[]{1, 2, 258, 259, 261, 264};
        Object[] objectArray3 = new Object[]{Boolean.FALSE, Boolean.TRUE, byArray, Boolean.FALSE, Boolean.TRUE, Boolean.TRUE};
        int[] nArray4 = new int[]{1, 2, 258, 259, 261, 264};
        Object[] objectArray4 = new Object[]{Boolean.FALSE, Boolean.TRUE, byArray, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE};
        boolean bl = false;
        int n = 0;
        String string = "";
        PKCS11Object[] pKCS11ObjectArray = null;
        KeyPair keyPair = null;
        boolean bl2 = false;
        while (!bl) {
            if (n >= this.openSessions.length) {
                throw new ProviderException("Cannot generate key pair: " + string);
            }
            try {
                Object[] objectArray5;
                Object object;
                pKCS11ObjectArray = this.sensitive ? this.openSessions[n].generateKeyPair(0, null, nArray, objectArray, nArray4, objectArray4) : (this.extractAttr ? this.openSessions[n].generateKeyPair(0, null, nArray, objectArray, nArray2, objectArray2) : this.openSessions[n].generateKeyPair(0, null, nArray, objectArray, nArray3, objectArray3));
                bl2 = false;
                PKCS11Object[] pKCS11ObjectArray2 = this.orderObjects(pKCS11ObjectArray);
                PKCS11Object pKCS11Object = pKCS11ObjectArray2[0];
                PKCS11Object pKCS11Object2 = pKCS11ObjectArray2[1];
                int[] nArray5 = new int[]{1};
                Object[] objectArray6 = new Object[]{Boolean.TRUE};
                try {
                    object = pKCS11Object2.copy(nArray5, objectArray6);
                    object.destroy();
                }
                catch (Exception exception) {
                    object = new int[]{1, 2, 258, 259, 261, 264, 3, 354};
                    objectArray5 = new Object[]{Boolean.TRUE, Boolean.TRUE, byArray, Boolean.FALSE, Boolean.TRUE, Boolean.TRUE, this.label, Boolean.TRUE};
                    int[] nArray6 = new int[]{1, 2, 258, 259, 261, 264, 3};
                    Object[] objectArray7 = new Object[]{Boolean.TRUE, Boolean.TRUE, byArray, Boolean.FALSE, Boolean.TRUE, Boolean.TRUE, this.label};
                    int[] nArray7 = new int[]{1, 2, 258, 259, 261, 264, 3};
                    Object[] objectArray8 = new Object[]{Boolean.TRUE, Boolean.TRUE, byArray, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, this.label};
                    bl2 = true;
                    pKCS11ObjectArray = this.sensitive ? this.openSessions[n].generateKeyPair(0, null, nArray, objectArray, nArray7, objectArray8) : (this.extractAttr ? this.openSessions[n].generateKeyPair(0, null, nArray, objectArray, (int[])object, objectArray5) : this.openSessions[n].generateKeyPair(0, null, nArray, objectArray, nArray6, objectArray7));
                    pKCS11ObjectArray2 = this.orderObjects(pKCS11ObjectArray);
                    pKCS11Object = pKCS11ObjectArray2[0];
                    pKCS11Object2 = pKCS11ObjectArray2[1];
                }
                object = new RSAPKCS11PublicKey(n, pKCS11Object, this.openSessions[n], this.openSessions, null, byArray, null, Boolean.TRUE, Boolean.TRUE, (BigInteger)this.getValue(pKCS11Object, 288), (Integer)this.getValue(pKCS11Object, 289), (BigInteger)this.getValue(pKCS11Object, 290));
                objectArray5 = null;
                if (bl2) {
                    objectArray5 = new RSAPKCS11PrivateKey(n, pKCS11Object2, this.openSessions[n], this.openSessions, null, byArray, null, Boolean.TRUE, Boolean.TRUE);
                } else {
                    try {
                        objectArray5 = new RSAPKCS11PrivateKey(n, pKCS11Object2, this.openSessions[n], this.openSessions, null, byArray, null, Boolean.TRUE, Boolean.TRUE, (BigInteger)this.getValue(pKCS11Object2, 288), (BigInteger)this.getValue(pKCS11Object2, 290), (BigInteger)this.getValue(pKCS11Object2, 291), (BigInteger)this.getValue(pKCS11Object2, 292), (BigInteger)this.getValue(pKCS11Object2, 293), (BigInteger)this.getValue(pKCS11Object2, 294), (BigInteger)this.getValue(pKCS11Object2, 295), (BigInteger)this.getValue(pKCS11Object2, 296));
                    }
                    catch (Exception exception) {
                        objectArray5 = new RSAPKCS11PrivateKey(n, pKCS11Object2, this.openSessions[n], this.openSessions, null, byArray, null, Boolean.TRUE, Boolean.TRUE);
                    }
                }
                keyPair = new KeyPair((PublicKey)object, (PrivateKey)objectArray5);
                bl = true;
            }
            catch (Exception exception) {
                string = String.valueOf(string) + n + "." + exception.getMessage() + " ";
                ++n;
            }
        }
        return keyPair;
    }

    private Object getValue(PKCS11Object pKCS11Object, int n) {
        return pKCS11Object.getAttributeValue(n);
    }

    public void initialize(int n) {
        throw new UnsupportedOperationException("Parameters must be specified");
    }

    public void initialize(int n, SecureRandom secureRandom) {
        throw new UnsupportedOperationException("Parameters must be specified");
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec == null) {
            throw new InvalidAlgorithmParameterException("Parameters must be specified");
        }
        this.random = secureRandom;
        if (algorithmParameterSpec instanceof PKCS11RSAKeyPairParameterSpec) {
            PKCS11RSAKeyPairParameterSpec pKCS11RSAKeyPairParameterSpec = (PKCS11RSAKeyPairParameterSpec)algorithmParameterSpec;
            KeyStore keyStore = pKCS11RSAKeyPairParameterSpec.getKeyStore();
            this.label = pKCS11RSAKeyPairParameterSpec.getLabel();
            try {
                Key key = keyStore.getKey(null, null);
                if (key == null || !(key instanceof RSAPKCS11PublicKey)) {
                    throw new InvalidAlgorithmParameterException("Invalid KeyStore type");
                }
                this.openSessions = ((RSAPKCS11PublicKey)key).getOpenSessions();
            }
            catch (Exception exception) {
                throw new InvalidAlgorithmParameterException("Invalid KeyStore type");
            }
            if (this.openSessions == null) {
                throw new InvalidAlgorithmParameterException("All parameters must be specified");
            }
            this.modlen = pKCS11RSAKeyPairParameterSpec.getStrength();
            this.label = pKCS11RSAKeyPairParameterSpec.getLabel();
            this.sensitive = this.checkIfSensitive();
            this.extractAttr = this.checkIfExtractable();
            if (!this.checkKeyPairGeneration() && this.label == null) {
                throw new InvalidAlgorithmParameterException("Key label must be specified");
            }
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be specified");
        }
    }

    private PKCS11Object[] orderObjects(PKCS11Object[] pKCS11ObjectArray) {
        Integer n = (Integer)this.getValue(pKCS11ObjectArray[0], 0);
        Integer n2 = (Integer)this.getValue(pKCS11ObjectArray[1], 0);
        PKCS11Object pKCS11Object = null;
        PKCS11Object pKCS11Object2 = null;
        if (n.equals(PKCS11Object.PUBLIC_KEY) && n2.equals(PKCS11Object.PRIVATE_KEY)) {
            pKCS11Object2 = pKCS11ObjectArray[0];
            pKCS11Object = pKCS11ObjectArray[1];
        } else if (n.equals(PKCS11Object.PRIVATE_KEY) && n2.equals(PKCS11Object.PUBLIC_KEY)) {
            pKCS11Object2 = pKCS11ObjectArray[1];
            pKCS11Object = pKCS11ObjectArray[0];
        } else {
            throw new RuntimeException("Token returns invalid objects");
        }
        pKCS11ObjectArray[0] = pKCS11Object2;
        pKCS11ObjectArray[1] = pKCS11Object;
        return pKCS11ObjectArray;
    }
}

