/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.MemoryRange;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class Windump
extends Dump {
    private static MinidumpHeader minidumpHeader;
    private static MinidumpDirectoryElement[] minidumpDirectoryElements;
    private static boolean verbose;
    private static int numberOfThreads;
    private static int numberOfModules;
    private static long numberOfMemoryRanges;
    private static MinidumpThread[] minidumpThreads;
    private static MinidumpModule[] minidumpModules;
    private static MemoryRange[] memoryRanges;
    private static long baseRva;
    private static boolean isMiniDump;
    private static boolean isWindowsDump;
    private static final long PEBADDRESS = 2147348480L;
    private static final int INFOBLOCKADDRESSOFFSET = 16;
    private static final int COMMANDLINEADDRESSOFFSET = 68;
    private static final int COMMANDLINELENGTHADDRESSOFFSET = 64;
    private static final int EVIRONMENTADDRESSOFFSET = 72;
    private static final long PEB64ADDRESS = 0L;
    private static final long EVIRONMENTADDRESS64 = 65536L;

    public static boolean isSupportedDump(RandomAccessFile randomAccessFile) {
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[4];
        boolean bl = false;
        try {
            randomAccessFile.seek(0L);
            randomAccessFile.read(byArray);
            String string = new String(byArray);
            if (string.toUpperCase().equals("MDMP")) {
                bl = true;
            } else if (string.toUpperCase().equals("USER")) {
                randomAccessFile.read(byArray2);
                string = new String(byArray2);
                if (string.toUpperCase().equals("DUMP")) {
                    bl = true;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("\nUsage: java WinDump filename\n");
            System.exit(1);
        }
        verbose = true;
        try {
            new Windump(stringArray[0]);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("\n File \"" + stringArray[0] + "\" not found.");
            System.exit(1);
        }
    }

    public Windump(String string) throws FileNotFoundException {
        super(string);
        bIsLittleEndian = true;
        this.setSystemType(1);
        minidumpHeader = new MinidumpHeader();
        if (isMiniDump) {
            this.processMdStreams(minidumpHeader);
        } else {
            this.processUdStreams();
        }
        cmdLine = this.findCommandLine();
        envVars = this.findEnvVars();
    }

    public static String getStringFromBytes(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (null == byArray) {
            return "bad string";
        }
        for (int i = 0; i < byArray.length && byArray[i] != 0 && byArray[0] != 0; ++i) {
            stringBuffer.append((char)byArray[i]);
        }
        return stringBuffer.toString();
    }

    private String getModuleName(int n) {
        String string = "????";
        long l = 0L;
        try {
            l = this.getFilePointer();
            this.seek(n);
            int n2 = Windump.convertEndian(this.readInt());
            if (n2 >= 512 || n2 <= 0) {
                n2 = 512;
            }
            byte[] byArray = new byte[n2];
            this.read(byArray);
            byte[] byArray2 = new byte[n2 / 2];
            for (int i = 0; i < n2 / 2; ++i) {
                byArray2[i] = byArray[2 * i];
            }
            string = new String(byArray2);
            this.seek(l);
        }
        catch (IOException iOException) {
            System.err.println("IOError in getModuleName");
        }
        return string;
    }

    protected static final short convertEndian(short s) {
        int n = s << 8;
        int n2 = s >>> 8;
        short s2 = (short)(n + n2);
        return s2;
    }

    protected static final int convertEndian(int n) {
        return n >>> 24 | n << 24 | n << 8 & 0xFF0000 | n >> 8 & 0xFF00;
    }

    public static long longFromBytes(byte[] byArray, boolean bl) {
        long l = 0L;
        if (byArray.length != 8) {
            System.err.println("Invalid use of longFromBytes - 0 returned");
            return l;
        }
        byte[] byArray2 = new byte[]{byArray[0], byArray[1], byArray[2], byArray[3], byArray[4], byArray[5], byArray[6], byArray[7]};
        if (bl) {
            byArray2[0] = byArray[7];
            byArray2[1] = byArray[6];
            byArray2[2] = byArray[5];
            byArray2[3] = byArray[4];
            byArray2[4] = byArray[3];
            byArray2[5] = byArray[2];
            byArray2[6] = byArray[1];
            byArray2[7] = byArray[0];
        }
        for (int i = 0; i < 8; ++i) {
            l <<= 8;
            if (byArray2[i] < 0) {
                l = l + (long)byArray2[i] + 256L;
                continue;
            }
            l += (long)byArray2[i];
        }
        return l;
    }

    private void processUdStreams() {
        UserdumpHeader userdumpHeader = new UserdumpHeader();
        this.processUdMemory(userdumpHeader);
    }

    private void processMdStreams(MinidumpHeader minidumpHeader) {
        int n;
        try {
            this.seek(minidumpHeader.streamDirectoryRva);
            minidumpDirectoryElements = new MinidumpDirectoryElement[minidumpHeader.numberOfStreams];
            for (n = 0; n < minidumpHeader.numberOfStreams; ++n) {
                Windump.minidumpDirectoryElements[n] = new MinidumpDirectoryElement();
                Windump.minidumpDirectoryElements[n].streamType = Windump.convertEndian(this.readInt());
                Windump.minidumpDirectoryElements[n].dataSize = Windump.convertEndian(this.readInt());
                Windump.minidumpDirectoryElements[n].location = Windump.convertEndian(this.readInt());
                if (!verbose) continue;
                System.err.println("Stream Type:" + Windump.minidumpDirectoryElements[n].streamType + "\tdataSize: " + Windump.minidumpDirectoryElements[n].dataSize + "\tlocation: " + Windump.minidumpDirectoryElements[n].location + "\tdescription: " + MinidumpStreamTypes.getDescription(Windump.minidumpDirectoryElements[n].streamType));
            }
        }
        catch (IOException iOException) {
            System.err.println(" IOException whilst locating minidump streams");
            System.exit(1);
        }
        block9: for (n = 0; n < minidumpHeader.numberOfStreams; ++n) {
            switch (Windump.minidumpDirectoryElements[n].streamType) {
                case 3: {
                    this.processThreads(n);
                    continue block9;
                }
                case 4: {
                    this.processModules(n);
                    continue block9;
                }
                case 9: {
                    this.processMemory64(n);
                    continue block9;
                }
                case 7: {
                    this.processSystemInfo(n);
                    continue block9;
                }
            }
        }
    }

    private void processThreads(int n) {
        try {
            this.seek(Windump.minidumpDirectoryElements[n].location);
            numberOfThreads = Windump.convertEndian(this.readInt());
            minidumpThreads = new MinidumpThread[numberOfThreads];
            if (verbose) {
                System.err.println("Number of threads = " + numberOfThreads);
            }
            for (int i = 0; i < numberOfThreads; ++i) {
                Windump.minidumpThreads[i] = new MinidumpThread();
                Windump.minidumpThreads[i].threadId = Windump.convertEndian(this.readInt());
                Windump.minidumpThreads[i].suspendCount = Windump.convertEndian(this.readInt());
                Windump.minidumpThreads[i].priorityClass = Windump.convertEndian(this.readInt());
                Windump.minidumpThreads[i].priority = Windump.convertEndian(this.readInt());
                byte[] byArray = new byte[8];
                this.read(byArray);
                Windump.minidumpThreads[i].teb = Windump.longFromBytes(byArray, true);
                this.read(byArray);
                Windump.minidumpThreads[i].stackStartOfMemoryRange = Windump.longFromBytes(byArray, true);
                Windump.minidumpThreads[i].stackDataSize = Windump.convertEndian(this.readInt());
                Windump.minidumpThreads[i].stackRva = Windump.convertEndian(this.readInt());
                Windump.minidumpThreads[i].contextDataSize = Windump.convertEndian(this.readInt());
                Windump.minidumpThreads[i].contextRva = Windump.convertEndian(this.readInt());
                if (!verbose) continue;
                System.err.println("Thread id: 0x" + Integer.toHexString(Windump.minidumpThreads[i].threadId));
            }
        }
        catch (IOException iOException) {
            System.err.println(" IOERROR in processThreads");
            System.exit(1);
        }
    }

    private void processSystemInfo(int n) {
        try {
            this.seek(Windump.minidumpDirectoryElements[n].location);
            short s = Windump.convertEndian(this.readShort());
            bIs32Bit = 9 != s && 6 != s;
        }
        catch (IOException iOException) {
            System.err.println(" IOERROR in processSystemInfo");
            System.exit(1);
        }
    }

    private void processModules(int n) {
        try {
            this.seek(Windump.minidumpDirectoryElements[n].location);
            numberOfModules = Windump.convertEndian(this.readInt());
            minidumpModules = new MinidumpModule[numberOfModules];
            for (int i = 0; i < numberOfModules; ++i) {
                Windump.minidumpModules[i] = new MinidumpModule();
                byte[] byArray = new byte[8];
                this.read(byArray);
                Windump.minidumpModules[i].baseOfImage = Windump.longFromBytes(byArray, true);
                Windump.minidumpModules[i].sizeOfImage = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].checkSum = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].timeDateStamp = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].moduleNameRva = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].moduleName = this.getModuleName(Windump.minidumpModules[i].moduleNameRva);
                Windump.minidumpModules[i].versionInfoDwSignature = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].versionInfoDwStrucVersion = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].versionInfoDwFileVersionMS = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].versionInfoDwFileVersionLS = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].versionInfoDwProductVersionMS = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].versionInfoDwProductVersionLS = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].versionInfoDwFileFlagsMask = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].versionInfoDwFileFlags = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].versionInfoDwFileOS = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].versionInfoDwFileType = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].versionInfoDwFileSubtype = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].versionInfoDwFileDateMS = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].versionInfoDwFileDateLS = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].cvRecordDataSize = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].cvRecordDataRva = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].miscRecordDataSize = Windump.convertEndian(this.readInt());
                Windump.minidumpModules[i].miscRecordDataRva = Windump.convertEndian(this.readInt());
                this.read(byArray);
                this.read(byArray);
            }
        }
        catch (IOException iOException) {
            System.err.println(" IOERROR in processModules");
            System.exit(1);
        }
    }

    private void processUdMemory(UserdumpHeader userdumpHeader) {
        long l = 0L;
        long l2 = 0L;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        try {
            int n6;
            this.seek(userdumpHeader.regionOffset);
            memoryRanges = new MemoryRange[userdumpHeader.regionCount];
            boolean bl = true;
            int n7 = 0;
            for (n6 = 0; n6 < userdumpHeader.regionCount; ++n6) {
                l = Windump.convertEndian(this.readInt());
                l2 = Windump.convertEndian(this.readInt());
                n = Windump.convertEndian(this.readInt());
                n2 = Windump.convertEndian(this.readInt());
                n3 = Windump.convertEndian(this.readInt());
                n4 = Windump.convertEndian(this.readInt());
                n5 = Windump.convertEndian(this.readInt());
                if (bl) {
                    Windump.memoryRanges[n7] = new MemoryRange();
                }
                bl = false;
                if (0 == n7) {
                    memoryRanges[n7].setVaddr(l);
                    memoryRanges[n7].setFileoffset(userdumpHeader.dataOffset);
                    memoryRanges[n7].setSize(n2);
                    ++n7;
                    bl = true;
                    continue;
                }
                if (memoryRanges[n7 - 1].getVaddr() + memoryRanges[n7 - 1].getSize() == l) {
                    memoryRanges[n7 - 1].setSize(memoryRanges[n7 - 1].getSize() + (long)n2);
                    continue;
                }
                memoryRanges[n7].setFileoffset(memoryRanges[n7 - 1].getFileoffset() + memoryRanges[n7 - 1].getSize());
                memoryRanges[n7].setVaddr(l);
                memoryRanges[n7].setSize(n2);
                ++n7;
                bl = true;
            }
            numberOfMemoryRanges = n7;
            memoryRanges = this.reformMemoryRanges(memoryRanges, (int)numberOfMemoryRanges);
            if (verbose) {
                System.err.println("True number of memory sections = " + numberOfMemoryRanges);
                n6 = 0;
                while ((long)n6 < numberOfMemoryRanges) {
                    System.err.println("Memory: 0x" + Long.toHexString(memoryRanges[n6].getVaddr()) + "  \tlength: " + memoryRanges[n6].getSize() + " bytes    \toffsetInFile: 0x" + Long.toHexString(memoryRanges[n6].getFileoffset()));
                    ++n6;
                }
            }
        }
        catch (IOException iOException) {
            System.err.println(" IOERROR in processUdMemory");
            System.exit(1);
        }
    }

    private void processMemory64(int n) {
        try {
            this.seek(Windump.minidumpDirectoryElements[n].location);
            byte[] byArray = new byte[8];
            this.read(byArray);
            numberOfMemoryRanges = Windump.longFromBytes(byArray, true);
            this.read(byArray);
            baseRva = Windump.longFromBytes(byArray, true);
            memoryRanges = new MemoryRange[(int)numberOfMemoryRanges];
            long l = 0L;
            long l2 = 0L;
            int n2 = 0;
            boolean bl = true;
            int n3 = 0;
            while ((long)n3 < numberOfMemoryRanges) {
                if (bl) {
                    Windump.memoryRanges[n2] = new MemoryRange();
                }
                bl = false;
                this.read(byArray);
                l2 = Windump.longFromBytes(byArray, true);
                this.read(byArray);
                l = Windump.longFromBytes(byArray, true);
                if (0 == n2) {
                    memoryRanges[n2].setVaddr(l2);
                    memoryRanges[n2].setFileoffset(baseRva);
                    memoryRanges[n2].setSize(l);
                    ++n2;
                    bl = true;
                } else if (memoryRanges[n2 - 1].getVaddr() + memoryRanges[n2 - 1].getSize() == l2) {
                    memoryRanges[n2 - 1].setSize(memoryRanges[n2 - 1].getSize() + l);
                } else {
                    memoryRanges[n2].setFileoffset(memoryRanges[n2 - 1].getFileoffset() + memoryRanges[n2 - 1].getSize());
                    memoryRanges[n2].setVaddr(l2);
                    memoryRanges[n2].setSize(l);
                    ++n2;
                    bl = true;
                }
                ++n3;
            }
            numberOfMemoryRanges = n2;
            memoryRanges = this.reformMemoryRanges(memoryRanges, (int)numberOfMemoryRanges);
            if (verbose) {
                System.err.println("True number of memory sections = " + numberOfMemoryRanges);
                n3 = 0;
                while ((long)n3 < numberOfMemoryRanges) {
                    System.err.println("Memory: 0x" + Long.toHexString(memoryRanges[n3].getVaddr()) + "  \tlength: " + memoryRanges[n3].getSize() + " bytes    \toffsetInFile: 0x" + Long.toHexString(memoryRanges[n3].getFileoffset()));
                    ++n3;
                }
            }
        }
        catch (IOException iOException) {
            System.err.println(" IOERROR in processMemory64");
            System.exit(1);
        }
    }

    private MemoryRange[] reformMemoryRanges(MemoryRange[] memoryRangeArray, int n) {
        MemoryRange[] memoryRangeArray2 = new MemoryRange[n];
        for (int i = 0; i < n; ++i) {
            memoryRangeArray2[i] = memoryRangeArray[i];
        }
        return memoryRangeArray2;
    }

    public MemoryRange[] getMemoryRanges() {
        return memoryRanges;
    }

    protected byte[] getMemoryBytes(long l, int n, boolean bl) {
        return this.getMemoryBytes(l, n);
    }

    public byte[] getMemoryBytes(long l, int n) {
        byte[] byArray = null;
        int n2 = this.findWhichMemoryRange(l);
        if (-1 == n2) {
            return null;
        }
        try {
            long l2 = l - memoryRanges[n2].getVaddr();
            long l3 = memoryRanges[n2].getFileoffset();
            long l4 = memoryRanges[n2].getSize();
            long l5 = l3 + l2;
            if (l5 > this.filesize) {
                return null;
            }
            this.seek(l5);
            long l6 = l4 - l2;
            if (this.filesize - l5 < l6) {
                l6 = this.filesize - l5;
            }
            int n3 = n;
            if (l6 < (long)n) {
                n3 = (int)l6;
            }
            byArray = new byte[n3];
            this.read(byArray);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byArray;
    }

    public long seekToMemoryAddress(long l) {
        long l2 = 0L;
        int n = this.findWhichMemoryRange(l);
        if (-1 != n) {
            long l3 = l - memoryRanges[n].getVaddr();
            try {
                this.seek(memoryRanges[n].getFileoffset() + l3);
                l2 = memoryRanges[n].getSize() - l3;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return l2;
    }

    public Dump.Loaded[] getLoadedInfo() {
        Dump.Loaded[] loadedArray = new Dump.Loaded[numberOfModules];
        for (int i = 0; i < numberOfModules; ++i) {
            loadedArray[i] = new Dump.Loaded(Windump.minidumpModules[i].moduleName, Windump.minidumpModules[i].baseOfImage, Windump.minidumpModules[i].sizeOfImage);
        }
        return loadedArray;
    }

    private String findCommandLine() {
        String string = "!!! Cannot establish Command Line !!!";
        try {
            long l = this.readPtr(2147348496L);
            if (-1L != l && 0L != this.seekToMemoryAddress(l + 64L)) {
                long l2;
                int n = Windump.convertEndian(this.readShort());
                short s = Windump.convertEndian(this.readShort());
                if (n > 1024) {
                    n = 1024;
                }
                if (n > 0 && -1L != (l2 = this.readPtr(l + 68L)) && 0L != this.seekToMemoryAddress(l2)) {
                    char[] cArray = new char[n / 2];
                    for (int i = 0; i < n / 2; ++i) {
                        cArray[i] = (char)Windump.convertEndian(this.readShort());
                    }
                    string = new String(cArray);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    private String findEnvVars() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            long l = 0L;
            if (this.is32bit()) {
                l = this.readPtr(2147348496L);
            }
            if (-1L != l) {
                long l2 = 65536L;
                if (this.is32bit()) {
                    l2 = this.readPtr(l + 72L);
                }
                if (-1L != l2 && 0L != this.seekToMemoryAddress(l2)) {
                    char c = '\u0000';
                    char c2 = '\u0000';
                    boolean bl = false;
                    do {
                        c2 = c;
                        c = (char)Windump.convertEndian(this.readShort());
                        if (c == '\u0000' && c2 == '\u0000') {
                            bl = true;
                            continue;
                        }
                        if (c == '\u0000') {
                            stringBuffer.append("\n");
                            continue;
                        }
                        stringBuffer.append(c);
                    } while (!bl);
                }
            }
        }
        catch (IOException iOException) {
            stringBuffer.append(" !!! Failure finding environment data !!!");
        }
        return stringBuffer.toString();
    }

    static {
        verbose = false;
        Dump.registerDumpSupport(Windump.class);
    }

    static final class MinidumpStreamTypes {
        static final int UNUSED = 0;
        static final int RESERVED0 = 1;
        static final int RESERVED1 = 2;
        static final int THREADLIST = 3;
        static final int MODULELIST = 4;
        static final int MEMORYLIST = 5;
        static final int EXCEPTIONLIST = 6;
        static final int SYSTEMINFO = 7;
        static final int THREADEXLIST = 8;
        static final int MEMORY64LIST = 9;
        static final int COMMENTSTREAMA = 10;
        static final int COMMENTSTREAMW = 11;
        static final int HANDLEDATA = 12;
        static final int FUNCTIONTABLE = 13;
        static final String[] descriptions = new String[]{"UNUSED", "RESERVED0", "RESERVED1", "THREADLIST", "MODULELIST", "MEMORYLIST", "EXCEPTIONLIST", "SYSTEMINFO", "THREADEXLIST", "MEMORY64LIST", "COMMENTSTREAMA", "COMMENTSTREAMW", "HANDLEDATA", "FUNCTIONTABLE"};

        MinidumpStreamTypes() {
        }

        static final String getDescription(int n) {
            if (n < 0 | n >= descriptions.length) {
                return " !!! Unrecognised Stream !!!";
            }
            return descriptions[n];
        }
    }

    static final class MinidumpConstants {
        static final int PROCESSOR_ARCHITECTURE_IA64 = 6;
        static final int PROCESSOR_ARCHITECTURE_AMD64 = 9;

        MinidumpConstants() {
        }
    }

    class UserdumpHeader {
        byte[] signature = new byte[8];
        int unknown1;
        int unknown2;
        int unknown3;
        int threadCount;
        int moduleCount;
        int regionCount;
        long contextOffset;
        long moduleOffset;
        long dataOffset;
        long regionOffset;
        long debugOffset;
        long threadOffset;
        long versionInfoOffset;

        UserdumpHeader() {
            try {
                Windump.this.seek(0L);
                Windump.this.read(this.signature);
                this.unknown1 = Windump.convertEndian(Windump.this.readInt());
                this.unknown2 = Windump.convertEndian(Windump.this.readInt());
                this.unknown3 = Windump.convertEndian(Windump.this.readInt());
                this.threadCount = Windump.convertEndian(Windump.this.readInt());
                this.moduleCount = Windump.convertEndian(Windump.this.readInt());
                this.regionCount = Windump.convertEndian(Windump.this.readInt());
                this.contextOffset = Windump.convertEndian(Windump.this.readInt());
                this.moduleOffset = Windump.convertEndian(Windump.this.readInt());
                this.dataOffset = Windump.convertEndian(Windump.this.readInt());
                this.regionOffset = Windump.convertEndian(Windump.this.readInt());
                this.debugOffset = Windump.convertEndian(Windump.this.readInt());
                this.threadOffset = Windump.convertEndian(Windump.this.readInt());
                this.versionInfoOffset = Windump.convertEndian(Windump.this.readInt());
                if (verbose) {
                    String string = new String(this.signature);
                    System.err.println("Sig: " + string + "  threads: " + this.threadCount + " threadOffset: 0x" + Long.toHexString(this.threadOffset) + "\nregions: " + this.regionCount + " regionOffset: 0x" + Long.toHexString(this.regionOffset) + " dataOffset: 0x" + Long.toHexString(this.dataOffset));
                }
            }
            catch (IOException iOException) {
                System.err.println("IOException");
            }
        }
    }

    class MinidumpHeader {
        byte[] signature = new byte[4];
        int version;
        int numberOfStreams;
        long streamDirectoryRva;
        int checkSum;
        int timeDateStamp;

        MinidumpHeader() {
            try {
                Windump.this.read(this.signature);
                String string = new String(this.signature);
                if (string.toUpperCase().equals("MDMP")) {
                    isMiniDump = true;
                    isWindowsDump = true;
                    this.version = Windump.convertEndian(Windump.this.readInt());
                    this.numberOfStreams = Windump.convertEndian(Windump.this.readInt());
                    this.streamDirectoryRva = Windump.convertEndian(Windump.this.readInt());
                    this.checkSum = Windump.convertEndian(Windump.this.readInt());
                    this.timeDateStamp = Windump.convertEndian(Windump.this.readInt());
                } else {
                    Windump.this.seek(0L);
                    this.signature = new byte[8];
                    Windump.this.read(this.signature);
                    string = new String(this.signature);
                    if (string.toUpperCase().equals("USERDUMP")) {
                        isMiniDump = false;
                        isWindowsDump = true;
                    } else {
                        isWindowsDump = false;
                    }
                }
            }
            catch (IOException iOException) {
                System.err.println("IOException");
            }
        }
    }

    class MinidumpDirectoryElement {
        int streamType;
        int dataSize;
        int location;

        MinidumpDirectoryElement() {
        }
    }

    class MinidumpThread {
        int threadId;
        int suspendCount;
        int priorityClass;
        int priority;
        long teb;
        long stackStartOfMemoryRange;
        int stackDataSize;
        int stackRva;
        int contextDataSize;
        int contextRva;

        MinidumpThread() {
        }
    }

    class MinidumpModule {
        long baseOfImage;
        int sizeOfImage;
        int checkSum;
        int timeDateStamp;
        int moduleNameRva;
        String moduleName;
        int versionInfoDwSignature;
        int versionInfoDwStrucVersion;
        int versionInfoDwFileVersionMS;
        int versionInfoDwFileVersionLS;
        int versionInfoDwProductVersionMS;
        int versionInfoDwProductVersionLS;
        int versionInfoDwFileFlagsMask;
        int versionInfoDwFileFlags;
        int versionInfoDwFileOS;
        int versionInfoDwFileType;
        int versionInfoDwFileSubtype;
        int versionInfoDwFileDateMS;
        int versionInfoDwFileDateLS;
        int cvRecordDataSize;
        int cvRecordDataRva;
        int miscRecordDataSize;
        int miscRecordDataRva;
        long reserved0;
        long reserved1;

        MinidumpModule() {
        }
    }
}

