/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.commandconsole.DumpUtils;

public class MemoryRange {
    private long vaddr;
    private long fileoffset;
    private long size;
    private int asid;

    public MemoryRange(long l, long l2, long l3) {
        this.vaddr = l;
        this.fileoffset = l2;
        this.size = l3;
        this.asid = 0;
    }

    public MemoryRange(long l, long l2, long l3, int n) {
        this.vaddr = l;
        this.fileoffset = l2;
        this.size = l3;
        this.asid = n;
    }

    public MemoryRange() {
    }

    public long getFileoffset() {
        return this.fileoffset;
    }

    public long getSize() {
        return this.size;
    }

    public long getVaddr() {
        return this.vaddr;
    }

    public void setFileoffset(long l) {
        this.fileoffset = l;
    }

    public void setSize(long l) {
        this.size = l;
    }

    public void setVaddr(long l) {
        this.vaddr = l;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Long.toHexString(this.vaddr);
        string = DumpUtils.padToPtrSize(string);
        stringBuffer.append("Addr: 0x" + string);
        String string2 = Long.toString(this.size);
        string2 = DumpUtils.padWithSpaces(string2, 10);
        stringBuffer.append("   Size: " + string2);
        stringBuffer.append("   File Offset: 0x" + Long.toHexString(this.fileoffset));
        stringBuffer.append(" (" + this.fileoffset + ")");
        if (this.asid != 0) {
            stringBuffer.append("   asid: 0x" + Integer.toHexString(this.asid));
        }
        return stringBuffer.toString();
    }

    public int getAsid() {
        return this.asid;
    }
}

