/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.command.CommandPlugin;
import com.ibm.jvm.j9.dump.commandconsole.DumpConsole;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMConsole;
import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.J9Class;
import com.ibm.jvm.j9.dump.systemdump.J9Heap;
import com.ibm.jvm.j9.dump.systemdump.J9Object;
import java.util.Iterator;

public class J9ObjectIterator
implements Iterator {
    private static boolean CREATEOAFILE = false;
    private J9Heap[] theHeaps;
    private int currentHeap;
    private int numHeaps;
    private long currentInstance;
    private long prevInstance;
    private long currentHeapEnd;
    private Dump theDump;
    private int currentHeapCount;
    private int recorderedHeapCount;
    private CommandPlugin callingPlugin;
    private int ptrSize;
    private int classCount;
    private Iterator classesIterator = null;

    protected J9ObjectIterator() {
    }

    private J9ObjectIterator(CommandPlugin commandPlugin) {
        this.callingPlugin = commandPlugin;
        if (!CREATEOAFILE) {
            this.theDump = DumpConsole.getTheDump();
            this.theHeaps = J9Heap.getTheHeaps();
            this.numHeaps = this.theHeaps.length;
            this.currentHeap = 0;
            this.currentInstance = this.theHeaps[0].getStart();
            this.currentHeapEnd = this.theHeaps[0].getEnd();
            this.currentHeapCount = this.theHeaps[0].getInCount();
        }
    }

    public static J9ObjectIterator getObjectIterator(CommandPlugin commandPlugin) {
        J9ObjectIterator j9ObjectIterator = new J9ObjectIterator(commandPlugin);
        return j9ObjectIterator;
    }

    public Object next() {
        if (0 == this.ptrSize) {
            this.ptrSize = true == DumpConsole.getTheDump().is32bit() ? 4 : 8;
        }
        if (null == this.classesIterator) {
            this.classesIterator = J9JVMConsole.getKnownClassesByName().keySet().iterator();
        }
        J9Object j9Object = null;
        if (this.classesIterator.hasNext()) {
            if (this.classCount == 0 && this.callingPlugin != null) {
                this.callingPlugin.notifyObservers("\tRecording class instances ....");
            }
            ++this.classCount;
            String string = (String)this.classesIterator.next();
            J9Class j9Class = J9JVMConsole.getClass(string);
            long l = j9Class.getClassAddress();
            j9Object = new J9Object(l, -1);
        } else {
            if (this.classCount != -1) {
                if (this.callingPlugin != null) {
                    this.callingPlugin.notifyObservers("\t  ... " + this.classCount + " class instances recorded");
                    this.callingPlugin.notifyObservers("\tStarting scan of heap segment " + this.currentHeap + "  start=0x" + Long.toHexString(this.currentInstance) + "   end=0x" + Long.toHexString(this.currentHeapEnd) + "   object count= " + this.currentHeapCount);
                }
                this.classCount = -1;
            }
            long l = this.currentInstance;
            j9Object = new J9Object(l, this.currentHeap);
            this.prevInstance = this.currentInstance;
            this.currentInstance += (long)j9Object.getInstanceSize();
            if (0L != this.currentInstance % (long)this.ptrSize) {
                this.currentInstance = this.currentInstance + (long)this.ptrSize - this.currentInstance % (long)this.ptrSize;
            }
            ++this.recorderedHeapCount;
            if (this.currentInstance >= this.currentHeapEnd) {
                ++this.currentHeap;
                if (this.recorderedHeapCount != this.currentHeapCount) {
                    this.callingPlugin.notifyObservers("\t !!!WARNING: Discrepency in object count, xml says" + this.currentHeapCount + " scan found " + this.recorderedHeapCount);
                }
                this.recorderedHeapCount = 0;
                if (this.currentHeap < this.theHeaps.length) {
                    this.currentInstance = this.theHeaps[this.currentHeap].getStart();
                    this.currentHeapEnd = this.theHeaps[this.currentHeap].getEnd();
                    this.currentHeapCount = this.theHeaps[this.currentHeap].getInCount();
                    if (null != this.callingPlugin) {
                        this.callingPlugin.notifyObservers("\tStarting scan of heap segment " + this.currentHeap + "  start=0x" + Long.toHexString(this.currentInstance) + "   end=0x" + Long.toHexString(this.currentHeapEnd) + "   object count= " + this.currentHeapCount);
                    }
                }
            }
        }
        return j9Object;
    }

    public void remove() {
    }

    public boolean hasNext() {
        return this.currentHeap < this.numHeaps;
    }
}

