/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.commandconsole.DumpConsole;
import com.ibm.jvm.j9.dump.commandconsole.DumpUtils;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMConsole;
import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.J9Class;
import com.ibm.jvm.j9.dump.systemdump.J9Object;
import java.util.Vector;

public class J9Heap {
    private long start;
    private long end;
    private HeapAllocBits hab;
    private static Dump theDump;
    private static boolean is32bit;
    private int inCount;
    private static byte[] objectAddressBuffer;
    private int count;
    private long size;
    private static J9Heap[] theHeaps;

    public J9Heap(String string, String string2, int n) {
        String string3 = DumpUtils.stripOff0x(string);
        String string4 = DumpUtils.stripOff0x(string2);
        this.start = DumpUtils.parseLongHex(string3);
        this.end = DumpUtils.parseLongHex(string4);
        this.size = this.end - this.start;
        this.inCount = n;
        if (null == theDump) {
            theDump = DumpConsole.getTheDump();
        }
        is32bit = theDump.is32bit();
        J9JVMConsole.addHeap(this);
    }

    public void recordObjectPosition(long l) {
        if (null == this.hab) {
            this.hab = new HeapAllocBits(this.size);
        }
        this.hab.recordObjectPosition(l);
    }

    public long getEnd() {
        return this.end;
    }

    public long getStart() {
        return this.start;
    }

    public static J9Object checkForObjectBeforeAddress(long l) {
        J9Object j9Object = null;
        int n = J9Heap.whatHeap(l);
        if (-1 != n) {
            j9Object = true == theHeaps[n].checkAllocBit(l) ? new J9Object(l, n) : theHeaps[n].findPreviousObject(l, n);
        }
        return j9Object;
    }

    public static J9Object checkForObject(long l) {
        J9Object j9Object = null;
        int n = J9Heap.whatHeap(l);
        if (-1 != n) {
            if (theHeaps[n].checkAllocBit(l)) {
                j9Object = new J9Object(l, n);
            }
        } else {
            J9Class j9Class = J9JVMConsole.getClass(l);
            if (j9Class != null) {
                j9Object = new J9Object(l, -1);
            }
        }
        return j9Object;
    }

    private J9Object findPreviousObject(long l, int n) {
        J9Object j9Object = null;
        long l2 = this.hab.findAllocBitPreceding(l);
        if (l2 != 0L) {
            j9Object = new J9Object(l2, n);
        }
        return j9Object;
    }

    public static int whatHeap(long l) {
        Vector vector;
        int n;
        int n2 = -1;
        if (null == theHeaps && (n = (vector = J9JVMConsole.getKnownHeaps()).size()) != 0) {
            theHeaps = new J9Heap[n];
            for (int i = 0; i < n; ++i) {
                J9Heap j9Heap = (J9Heap)vector.get(i);
                if (i > 0) {
                    if (j9Heap.start > J9Heap.theHeaps[i - 1].start) {
                        J9Heap.theHeaps[i] = j9Heap;
                        continue;
                    }
                    int n3 = 0;
                    J9Heap j9Heap2 = null;
                    for (int j = i - 1; j >= 0; --j) {
                        if (J9Heap.theHeaps[j].start >= j9Heap.start) continue;
                        n3 = j + 1;
                        j = -1;
                    }
                    j9Heap2 = theHeaps[n3];
                    J9Heap.theHeaps[n3] = j9Heap;
                    J9Heap j9Heap3 = null;
                    for (int j = n3 + 1; j == i; ++j) {
                        j9Heap3 = theHeaps[j];
                        J9Heap.theHeaps[j] = j9Heap2;
                        j9Heap2 = j9Heap3;
                    }
                    continue;
                }
                J9Heap.theHeaps[i] = j9Heap;
            }
        }
        if (theHeaps != null) {
            for (int i = 0; i < theHeaps.length; ++i) {
                if (l < theHeaps[i].getStart() || l > theHeaps[i].getEnd()) continue;
                return i;
            }
        }
        return n2;
    }

    private boolean checkAllocBit(long l) {
        if (null == this.hab) {
            return false;
        }
        return this.hab.checkAllocBit(l);
    }

    public static J9Heap[] getTheHeaps() {
        return theHeaps;
    }

    public static J9Heap getAHeap(int n) {
        return theHeaps[n];
    }

    public int getCount() {
        return this.count;
    }

    public int getInCount() {
        return this.inCount;
    }

    public static void sortHeaps() {
        J9Heap.whatHeap(-1L);
    }

    class HeapAllocBits {
        private int[] bitArray;
        private final int[] bitFlip = new int[]{Integer.MIN_VALUE, 0x40000000, 0x20000000, 0x10000000, 0x8000000, 0x4000000, 0x2000000, 0x1000000, 0x800000, 0x400000, 0x200000, 0x100000, 524288, 262144, 131072, 65536, 32768, 16384, 8192, 4096, 2048, 1024, 512, 256, 128, 64, 32, 16, 8, 4, 2, 1};
        private int divider = 256;

        HeapAllocBits(long l) {
            if (is32bit) {
                this.divider = 128;
            }
            int n = (int)l / this.divider;
            if (l % (long)this.divider != 0L) {
                ++n;
            }
            this.bitArray = new int[n];
        }

        void recordObjectPosition(long l) {
            long l2 = l - J9Heap.this.start;
            int n = (int)(l2 / (long)this.divider);
            int n2 = this.divider / 32;
            int n3 = (int)(l2 % (long)this.divider) / n2;
            this.bitArray[n] = this.bitArray[n] | this.bitFlip[n3];
        }

        boolean checkAllocBit(long l) {
            int n;
            int n2;
            boolean bl = false;
            long l2 = l - J9Heap.this.start;
            int n3 = (int)(l2 / (long)this.divider);
            if (0 != (this.bitArray[n3] & this.bitFlip[n2 = (int)(l2 % (long)this.divider) / (n = this.divider / 32)])) {
                bl = true;
            }
            return bl;
        }

        long findAllocBitPreceding(long l) {
            long l2 = 0L;
            int n = this.divider / 32;
            if (0L != l % (long)n) {
                l = (long)n * (l / (long)n) + (long)n;
            }
            long l3 = l - J9Heap.this.start;
            int n2 = (int)(l3 / (long)this.divider);
            int n3 = (int)(l3 % (long)this.divider) / n;
            boolean bl = false;
            while (!bl) {
                if (0 == this.bitArray[n2]) {
                    n3 = 32;
                    if (--n2 >= 0) continue;
                    bl = true;
                    continue;
                }
                if (0 != (this.bitArray[n2] & this.bitFlip[n3])) {
                    l2 = J9Heap.this.start + (long)((n2 * 32 + n3) * n);
                    bl = true;
                    continue;
                }
                if (--n3 >= 0) continue;
                n3 = 32;
                if (--n2 >= 0) continue;
                bl = true;
            }
            return l2;
        }
    }
}

