/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.MemoryRange;
import com.ibm.jvm.j9.dump.systemdump.ProgramHeaderElement;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;

public class Elfdump
extends Dump {
    private static boolean verbose = false;
    private int wordLength;
    private int machine;
    private long version;
    private long entry;
    private long programHeaderOffset;
    private long sectionHeaderOffset;
    private long flags;
    private long elfHeaderSize;
    private long programHeaderEntrySize;
    private long numProgramHeaders;
    private long sectionHeaderEntrySize;
    private long numSectionHeaders;
    private long stringTable;
    private Map pHMap;
    static final int EI_NIDENT = 16;
    static final int ELFCLASS32 = 1;
    static final int ELFCLASS64 = 2;
    static final int ELFDATA2LSB = 1;
    static final int ELFDATA2MSB = 2;
    static final int ARCH_SPARC = 2;
    static final int ARCH_IA32 = 3;
    static final int ARCH_IA64 = 50;
    static final int ARCH_PPC32 = 20;
    static final int ARCH_PPC64 = 21;
    static final int ARCH_S390 = 22;
    static final int ARCH_AMD64 = 62;
    private static String[] archStrings;

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("\nUsage: java ElfDump filename\n");
            System.exit(1);
        }
        verbose = true;
        try {
            int n;
            byte[] byArray;
            Elfdump elfdump = new Elfdump(stringArray[0]);
            MemoryRange[] memoryRangeArray = elfdump.getMemoryRanges();
            System.out.println("Memory ranges size =" + memoryRangeArray.length);
            System.out.print("Seek to memory address 0xa6537000: ");
            if (elfdump.seekToMemoryAddress(2790518784L) > 0L) {
                System.out.println(true);
                System.out.println("Getting 200 bytes from 0xa653f000L:");
                byArray = elfdump.getMemoryBytes(2790518784L, 200);
                System.out.println("Returned memory size = " + byArray.length);
                for (n = 0; n < byArray.length; ++n) {
                    System.out.print(byArray[n] + " ");
                    if (n % 20 != 0) continue;
                    System.out.println();
                }
            } else {
                System.out.println(false);
            }
            System.out.println("Seek to memory address 0x123456: " + elfdump.seekToMemoryAddress(1193046L));
            System.out.println("Seek to memory address 0x1: " + elfdump.seekToMemoryAddress(1L));
            System.out.println("Getting 200 bytes from 0x0: ");
            byArray = elfdump.getMemoryBytes(0L, 200);
            System.out.println("Returned memory size = " + byArray.length);
            for (n = 0; n < byArray.length; ++n) {
                System.out.print(byArray[n] + " ");
                if (n % 20 != 0) continue;
                System.out.println();
            }
            System.out.println("Getting 200 bytes from 0x804e000: ");
            byArray = elfdump.getMemoryBytes(134537216L, 4096);
            if (byArray != null) {
                System.out.println("Returned memory size = " + byArray.length);
                for (n = 0; n < byArray.length; ++n) {
                    System.out.print(byArray[n] + " ");
                    if (n % 20 != 0) continue;
                    System.out.println();
                }
            }
            System.out.println("Seek to memory address 0xc1000000: " + elfdump.seekToMemoryAddress(0xC1000000L));
            System.out.println("Seek to memory address 0x7fbf7f8000: " + elfdump.seekToMemoryAddress(548673650688L));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("\n File \"" + stringArray[0] + "\" not found.");
            System.exit(1);
        }
    }

    public Elfdump(String string) throws FileNotFoundException {
        super(string, "r");
        this.setSystemType(2);
        byte[] byArray = new byte[16];
        try {
            this.read(byArray);
            String string2 = new String(byArray);
            string2 = string2.toUpperCase();
            if (-1 != string2.indexOf("ELF") && verbose) {
                System.err.println("Whoopee looks like its an elf core file");
            }
            byte[] byArray2 = new byte[]{byArray[4], byArray[5]};
            this.setArchitecture(byArray2);
            int n = this.readHalf();
            if (verbose) {
                System.out.println("Object Type = " + n);
            }
            this.machine = this.readHalf();
            switch (this.machine) {
                case 20: 
                case 21: 
                case 50: {
                    int n2 = 4;
                    break;
                }
                case 22: {
                    int n2 = this.wordLength / 2;
                    break;
                }
                default: {
                    int n2 = 2;
                }
            }
            if (this.is32bit()) {
                this.read32bitHeader();
            } else {
                this.read64bitHeader();
            }
            this.pHMap = new HashMap((int)this.numProgramHeaders);
            int n3 = 0;
            while ((long)n3 < this.numProgramHeaders) {
                this.seek(this.programHeaderOffset + (long)n3 * this.programHeaderEntrySize);
                ProgramHeaderElement programHeaderElement = ProgramHeaderElement.readProgramHeaderElement(this, this.is32bit());
                if (programHeaderElement.type == 2L) {
                    boolean bl = true;
                }
                if (programHeaderElement.memsize != 0L) {
                    this.pHMap.put(new Long(programHeaderElement.virtaddr), programHeaderElement);
                }
                if (verbose) {
                    System.err.println(programHeaderElement.toString());
                }
                ++n3;
            }
            this.pHMap = new TreeMap(this.pHMap);
            if (verbose) {
                ProgramHeaderElement[] programHeaderElementArray = this.pHMap.values().toArray(new ProgramHeaderElement[0]);
                long l = 0L;
                int n4 = 0;
                while ((long)n4 < this.numProgramHeaders) {
                    l += programHeaderElementArray[n4].memsize;
                    switch ((int)programHeaderElementArray[n4].type) {
                        case 1: {
                            if (programHeaderElementArray[n4].filesize == 0L || !verbose) break;
                            System.err.println("Its a LOAD entry thats dumped memory 0x" + Long.toHexString(programHeaderElementArray[n4].virtaddr) + "for " + Long.toHexString(programHeaderElementArray[n4].memsize) + " bytes. Offset in dump file is 0x" + Long.toHexString(programHeaderElementArray[n4].offset));
                            break;
                        }
                        case 4: {
                            if (!verbose) break;
                            System.err.println("Its a NOTE entry");
                            break;
                        }
                        case 2: {
                            if (!verbose) break;
                            System.err.println("Its a DYNAMIC entry");
                            break;
                        }
                    }
                    ++n4;
                }
                if (verbose) {
                    System.out.println("Total Memory Size =" + l);
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Exception reading dump file");
        }
    }

    private void read32bitHeader() throws IOException {
        this.version = this.readUnsignInt();
        this.entry = this.readUnsignInt();
        this.programHeaderOffset = this.readUnsignInt();
        this.sectionHeaderOffset = this.readUnsignInt();
        this.flags = this.readUnsignInt();
        this.elfHeaderSize = this.readHalf();
        this.programHeaderEntrySize = this.readHalf();
        this.numProgramHeaders = this.readHalf();
        this.sectionHeaderEntrySize = this.readHalf();
        this.numSectionHeaders = this.readHalf();
        this.stringTable = this.readHalf();
        if (verbose) {
            System.out.println("32bit");
            System.out.println("version =" + this.version);
            System.out.println("entry =" + this.entry);
            System.out.println("programHeaderOffset =" + this.programHeaderOffset);
            System.out.println("sectionHeaderOffset =" + this.sectionHeaderOffset);
        }
    }

    private void read64bitHeader() throws IOException {
        this.version = this.readUnsignInt();
        this.entry = this.readUnsignLong();
        this.programHeaderOffset = this.readUnsignLong();
        this.sectionHeaderOffset = this.readUnsignLong();
        this.flags = this.readUnsignInt();
        this.elfHeaderSize = this.readHalf();
        this.programHeaderEntrySize = this.readHalf();
        this.numProgramHeaders = this.readHalf();
        this.sectionHeaderEntrySize = this.readHalf();
        this.numSectionHeaders = this.readHalf();
        this.stringTable = this.readHalf();
        if (verbose) {
            System.out.println("64bit");
            System.out.println("version =" + this.version);
            System.out.println("entry =" + this.entry);
            System.out.println("programHeaderOffset =" + this.programHeaderOffset);
            System.out.println("sectionHeaderOffset =" + this.sectionHeaderOffset);
        }
    }

    public static boolean isSupportedDump(RandomAccessFile randomAccessFile) {
        byte[] byArray = new byte[16];
        try {
            randomAccessFile.seek(0L);
            randomAccessFile.read(byArray);
            String string = new String(byArray);
            string = string.toUpperCase();
            if (-1 != string.indexOf("ELF")) {
                if (verbose) {
                    System.err.println("isSupportedDump: Whoopee looks like its an elf core file");
                }
                return true;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return false;
    }

    private void setArchitecture(byte[] byArray) throws IOException {
        switch (byArray[0]) {
            case 1: {
                Elfdump.set32Bit(true);
                break;
            }
            case 2: {
                Elfdump.set32Bit(false);
                break;
            }
            default: {
                throw new IOException("Unexpected bitness flag detected in core file.");
            }
        }
        switch (byArray[1]) {
            case 1: {
                Elfdump.setLittleEndian(true);
                break;
            }
            case 2: {
                Elfdump.setLittleEndian(false);
                break;
            }
            default: {
                throw new IOException("Unexpected endianess flag detected in core file.");
            }
        }
        if (verbose) {
            if (this.is32bit()) {
                System.err.println("Its a 32-bit dump");
            } else {
                System.err.println("Its a 64-bit dump");
            }
            if (bIsLittleEndian) {
                System.err.println("Its a little endian dump");
            } else {
                System.err.println("Its a big endian dump");
            }
        }
    }

    public MemoryRange[] getMemoryRanges() {
        MemoryRange[] memoryRangeArray = new MemoryRange[this.pHMap.size()];
        int n = 0;
        Iterator iterator = this.pHMap.values().iterator();
        while (iterator.hasNext()) {
            ProgramHeaderElement programHeaderElement = (ProgramHeaderElement)iterator.next();
            memoryRangeArray[n] = programHeaderElement.getRange();
            ++n;
        }
        return memoryRangeArray;
    }

    protected byte[] getMemoryBytes(long l, int n, boolean bl) {
        return this.getMemoryBytes(l, n);
    }

    public byte[] getMemoryBytes(long l, int n) {
        byte[] byArray = null;
        long l2 = this.seekToMemoryAddress(l);
        if (0L != l2) {
            byArray = l2 > (long)n ? new byte[n] : new byte[(int)l2];
            try {
                this.read(byArray);
            }
            catch (IOException iOException) {
                byArray = null;
            }
        }
        return byArray;
    }

    public long seekToMemoryAddress(long l) {
        long l2;
        if (verbose) {
            System.out.println("Looking for vaddr =" + Long.toHexString(l));
        }
        SortedMap sortedMap = (SortedMap)this.pHMap;
        ProgramHeaderElement programHeaderElement = (ProgramHeaderElement)this.pHMap.get(new Long(l));
        if (verbose) {
            if (null == programHeaderElement) {
                System.out.println("phe was null");
            } else {
                System.out.println("phe was not null");
            }
        }
        if (programHeaderElement == null) {
            SortedMap sortedMap2 = sortedMap.headMap(new Long(l));
            SortedMap sortedMap3 = sortedMap.tailMap(new Long(l));
            if (verbose) {
                System.out.println("header.size =" + sortedMap2.size());
                System.out.println("tail.size =" + sortedMap3.size());
            }
            try {
                Long l3 = sortedMap2.lastKey();
                programHeaderElement = (ProgramHeaderElement)this.pHMap.get(l3);
            }
            catch (NoSuchElementException noSuchElementException) {
                return 0L;
            }
        }
        if (verbose) {
            System.out.println("seekToMemoryAddress phe = " + programHeaderElement);
        }
        if (programHeaderElement.memsize <= (l2 = l - programHeaderElement.virtaddr)) {
            return 0L;
        }
        long l4 = programHeaderElement.offset + l2;
        if (l4 > this.filesize) {
            return 0L;
        }
        try {
            this.seek(l4);
        }
        catch (IOException iOException) {
            return 0L;
        }
        return programHeaderElement.memsize - l2;
    }

    public long readUnsignInt() throws IOException {
        long[] lArray = new long[4];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = this.readUnsignedByte();
        }
        if (this.isLittleEndian()) {
            return lArray[0] + (lArray[1] << 8) + (lArray[2] << 16) + (lArray[3] << 24);
        }
        return lArray[3] + (lArray[2] << 8) + (lArray[1] << 16) + (lArray[0] << 24);
    }

    public int readHalf() throws IOException {
        int[] nArray = new int[2];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.readUnsignedByte();
        }
        if (this.isLittleEndian()) {
            return nArray[0] + (nArray[1] << 8);
        }
        return nArray[1] + (nArray[0] << 8);
    }

    public long readUnsignLong() throws IOException {
        long[] lArray = new long[8];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = this.readUnsignedByte();
        }
        if (this.isLittleEndian()) {
            return lArray[0] + (lArray[1] << 8) + (lArray[2] << 16) + (lArray[3] << 24) + (lArray[4] << 32) + (lArray[5] << 40) + (lArray[6] << 48) + (lArray[7] << 56);
        }
        return lArray[7] + (lArray[6] << 8) + (lArray[5] << 16) + (lArray[4] << 24) + (lArray[3] << 32) + (lArray[2] << 40) + (lArray[1] << 48) + (lArray[0] << 56);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("\n\tSystem subtype : ");
        stringBuffer.append(archStrings[this.machine]);
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    public Dump.Loaded[] getLoadedInfo() {
        return null;
    }

    static {
        Dump.registerDumpSupport(Elfdump.class);
        archStrings = new String[100];
        Elfdump.archStrings[2] = "Sun Sparc";
        Elfdump.archStrings[3] = "IA/32";
        Elfdump.archStrings[50] = "IA/64";
        Elfdump.archStrings[20] = "PPC/32";
        Elfdump.archStrings[21] = "PPC/64";
        Elfdump.archStrings[22] = "s390";
        Elfdump.archStrings[62] = "AMD64";
    }
}

