/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.commandconsole.DumpUtils;
import com.ibm.jvm.j9.dump.systemdump.MemoryRange;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

public abstract class Dump
extends RandomAccessFile {
    protected static boolean bIs32Bit = true;
    protected static int systemType;
    protected static boolean bIsLittleEndian;
    private String dumpName;
    private String stamp;
    private String version;
    private String uuid;
    protected int NUMCACHES = 4;
    protected int CACHESIZE = 262144;
    protected int MAXCACHEMISS = 10;
    protected boolean cachedData;
    public long cacheHits;
    public long cacheMisses;
    public int cacheLoads;
    protected byte[][] caches;
    protected long[] cacheStart;
    protected int[] cacheSize;
    protected int[] cacheMissCount;
    protected int prevMemRange = -1;
    protected long pmrStartAddr = 0L;
    protected long pmrSize = 0L;
    protected static String cmdLine;
    protected static String envVars;
    int lastUsedCache = 0;
    protected long filesize;
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_WINDOWS = 1;
    public static final int TYPE_LINUX = 2;
    public static final int TYPE_ZOS = 3;
    private static final String[] types;
    private static ArrayList DumpType;
    private static final String[][] subTypes;
    static /* synthetic */ Class class$java$io$RandomAccessFile;

    protected Dump(File file, String string) throws FileNotFoundException {
        super(file, string);
        this.dumpName = file.getName();
        try {
            this.filesize = this.length();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected Dump(String string, String string2) throws FileNotFoundException {
        super(string, string2);
        this.dumpName = string;
        try {
            this.filesize = this.length();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Dump(String string) throws FileNotFoundException {
        super(string, "r");
        this.dumpName = string;
        try {
            this.filesize = this.length();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final String getSystemTypeAsString(int n) {
        return types[n];
    }

    public abstract MemoryRange[] getMemoryRanges();

    public abstract byte[] getMemoryBytes(long var1, int var3);

    protected abstract byte[] getMemoryBytes(long var1, int var3, boolean var4);

    public abstract Loaded[] getLoadedInfo();

    public abstract long seekToMemoryAddress(long var1);

    public int findMemoryRange(long l) {
        int n = -1;
        MemoryRange[] memoryRangeArray = this.getMemoryRanges();
        return n;
    }

    public int findWhichMemoryRange(long l) {
        int n = -1;
        MemoryRange[] memoryRangeArray = this.getMemoryRanges();
        if (null != memoryRangeArray) {
            if (this.prevMemRange != -1 && l >= this.pmrStartAddr && l < this.pmrStartAddr + this.pmrSize) {
                return this.prevMemRange;
            }
            int n2 = memoryRangeArray.length;
            int n3 = 0;
            int n4 = n2 / 2;
            boolean bl = false;
            while (!bl) {
                long l2 = memoryRangeArray[n4].getVaddr();
                if (l >= l2) {
                    if (l < l2 + memoryRangeArray[n4].getSize()) {
                        n = n4;
                        bl = true;
                    }
                    if (n3 >= n2) {
                        bl = true;
                    }
                    n3 = n4 + 1;
                } else {
                    if (n4 >= n2 || n4 <= n3) {
                        bl = true;
                    }
                    n2 = n4 - 1;
                }
                if ((n4 = n3 + (n2 - n3) / 2) >= 0 && n4 != memoryRangeArray.length) continue;
                bl = true;
            }
            if (n > 0) {
                for (int i = n - 1; i >= 0; --i) {
                    long l3 = memoryRangeArray[i].getVaddr();
                    if (l >= l3) {
                        if (l < l3 + memoryRangeArray[i].getSize()) {
                            n = i;
                            continue;
                        }
                        i = -1;
                        continue;
                    }
                    i = -1;
                }
            }
        }
        this.prevMemRange = n;
        if (-1 != n) {
            this.prevMemRange = n;
            this.pmrStartAddr = memoryRangeArray[n].getVaddr();
            this.pmrSize = memoryRangeArray[n].getSize();
        }
        return n;
    }

    public int findWhichMemoryRange(long l, int n) {
        int n2 = -1;
        MemoryRange[] memoryRangeArray = this.getMemoryRanges();
        if (null != memoryRangeArray) {
            for (int i = 0; i < memoryRangeArray.length; ++i) {
                if (memoryRangeArray[i].getAsid() != n) continue;
                long l2 = memoryRangeArray[i].getVaddr();
                if (l >= l2) {
                    if (l >= l2 + memoryRangeArray[i].getSize()) continue;
                    n2 = i;
                    i = memoryRangeArray.length;
                    continue;
                }
                return -1;
            }
        }
        return n2;
    }

    public static boolean isSupportedDump(RandomAccessFile randomAccessFile) {
        return false;
    }

    public static void registerDumpSupport(Class clazz) {
        if (DumpType == null) {
            DumpType = new ArrayList();
        }
        if (Dump.class.isAssignableFrom(clazz)) {
            DumpType.add(clazz);
        }
    }

    public static void deregisterDumpSupport(Dump dump) {
        if (DumpType == null) {
            return;
        }
        DumpType.remove(dump);
    }

    public long findBytes(byte[] byArray, int n) {
        long l = -1L;
        l = this.findPattern(byArray, n, 0L);
        return l;
    }

    public long findPattern(byte[] byArray, int n, long l) {
        long l2 = -1L;
        Vector vector = DumpUtils.findInMemory(this, byArray, l, -1L, n, 1, false);
        if (0 != vector.size()) {
            l2 = (Long)vector.get(0);
        }
        return l2;
    }

    public static Dump getDumptype(String string) throws FileNotFoundException {
        if (DumpType == null) {
            return null;
        }
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(string, "r");
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        Iterator iterator = DumpType.iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            try {
                Method method = clazz.getMethod("isSupportedDump", class$java$io$RandomAccessFile == null ? Dump.class$("java.io.RandomAccessFile") : class$java$io$RandomAccessFile);
                Boolean bl = (Boolean)method.invoke(null, randomAccessFile);
                if (!bl.booleanValue()) continue;
                Constructor constructor = clazz.getConstructor(String.class);
                return (Dump)constructor.newInstance(string);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
                return null;
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public boolean is32bit() {
        return bIs32Bit;
    }

    public boolean isLittleEndian() {
        return bIsLittleEndian;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long readPtr(long l) throws IOException {
        long l2 = -1L;
        if (this.seekToMemoryAddress(l) <= 0L) throw new IOException("jformat: seek to memory address failed");
        if (bIs32Bit) {
            l2 = this.readIntEx();
            if (true != bIsLittleEndian) return l2;
            return DumpUtils.convertEndian((int)l2);
        }
        l2 = this.readLongEx();
        if (true != bIsLittleEndian) return l2;
        return DumpUtils.convertEndian(l2);
    }

    public int getSystemType() {
        return systemType;
    }

    public void setSystemType(int n) {
        systemType = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (bIs32Bit) {
            stringBuffer.append("\t32bit");
        } else {
            stringBuffer.append("\t64bit");
        }
        if (bIsLittleEndian) {
            stringBuffer.append("\n\tLittle Endian (i.e. 0x12345678 in memory could be 0x78563412 if it was a pointer)");
        } else {
            stringBuffer.append("\n\tBig Endian");
        }
        stringBuffer.append("\n\tSystem         : " + this.getSystemTypeAsString(systemType));
        stringBuffer.append("\n\tVersion        : " + this.version);
        stringBuffer.append("\n\tBuildLevel     : " + this.stamp);
        stringBuffer.append("\n\tUuid           : " + this.uuid);
        return stringBuffer.toString();
    }

    public void setStamp(String string) {
        this.stamp = string;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public void setUuid(String string) {
        this.uuid = string;
    }

    public String getStamp() {
        return this.stamp;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getVersion() {
        return this.version;
    }

    public static void set32Bit(boolean bl) {
        bIs32Bit = bl;
    }

    public static void setLittleEndian(boolean bl) {
        bIsLittleEndian = bl;
    }

    public String getDumpName() {
        return this.dumpName;
    }

    public void setDumpName(String string) {
        this.dumpName = string;
    }

    public String getCmdLine() {
        return cmdLine;
    }

    public String getEnvVars() {
        return envVars;
    }

    public long readLongEx() throws IOException {
        return this.readLong();
    }

    public int readIntEx() throws IOException {
        return this.readInt();
    }

    public void readFullyEx(byte[] byArray) throws IOException {
        this.readFully(byArray);
    }

    public int readEx(byte[] byArray) throws IOException {
        return this.read(byArray);
    }

    public int readEx(byte[] byArray, int n, int n2) throws IOException {
        return this.read(byArray, n, n2);
    }

    protected void initCaching() {
        this.cachedData = true;
        this.caches = new byte[this.NUMCACHES][];
        this.cacheStart = new long[this.NUMCACHES];
        for (int i = 0; i < this.NUMCACHES; ++i) {
            this.cacheStart[i] = -1L;
        }
        this.cacheSize = new int[this.NUMCACHES];
        this.cacheMissCount = new int[this.NUMCACHES];
    }

    protected byte[] checkCaches(long l, int n) {
        byte[] byArray = null;
        for (int i = 0; i < this.NUMCACHES; ++i) {
            int n2 = i + this.lastUsedCache;
            if (n2 >= this.NUMCACHES) {
                n2 -= this.NUMCACHES;
            }
            if (!this.cachedData || this.cacheStart[n2] == -1L) continue;
            if (l >= this.cacheStart[n2] && l <= this.cacheStart[n2] + (long)this.cacheSize[n2]) {
                int n3 = (int)(l - this.cacheStart[n2]);
                if (this.cacheSize[n2] - n3 < n) continue;
                byArray = new byte[n];
                System.arraycopy(this.caches[n2], n3, byArray, 0, n);
                this.cacheMissCount[n2] = 0;
                this.lastUsedCache = n2;
                return byArray;
            }
            int n4 = n2;
            this.cacheMissCount[n4] = this.cacheMissCount[n4] + 1;
        }
        return byArray;
    }

    protected void cacheFill(byte[] byArray, long l, MemoryRange memoryRange) {
        int n = -1;
        for (int i = 0; i < this.NUMCACHES; ++i) {
            if (this.cacheStart[i] != -1L && this.cacheMissCount[i] < this.MAXCACHEMISS) continue;
            n = i;
            break;
        }
        if (-1 != n) {
            ++this.cacheLoads;
            this.cacheMissCount[n] = 0;
            long l2 = memoryRange.getSize();
            if (memoryRange.getSize() <= (long)this.CACHESIZE) {
                this.cacheStart[n] = memoryRange.getVaddr();
                this.caches[n] = this.getMemoryBytes(this.cacheStart[n], (int)l2, true);
            } else {
                int n2 = (int)(l - memoryRange.getVaddr());
                int n3 = (int)(l2 - (long)n2);
                if (n3 >= this.CACHESIZE) {
                    this.caches[n] = this.getMemoryBytes(l, this.CACHESIZE, true);
                    this.cacheStart[n] = l;
                } else {
                    this.cacheStart[n] = memoryRange.getVaddr() + l2 - (long)this.CACHESIZE;
                    this.caches[n] = this.getMemoryBytes(this.cacheStart[n], this.CACHESIZE, true);
                }
            }
            if (this.caches[n] != null) {
                this.cacheSize[n] = this.caches[n].length;
            } else {
                this.cacheStart[n] = -1L;
            }
        }
    }

    static {
        types = new String[]{"unknown", "windows", "linux", "zOS"};
        DumpType = null;
        subTypes = new String[][]{{"unknown"}, {"Windows unknown", "Windows XP", "Windows 2000", "Windows ME", "Windows NT", "Windows 95", "Windows 98"}, {"Linux ia32", "ZOS64", "ZOS32"}};
        try {
            Class.forName("com.ibm.jvm.j9.dump.systemdump.Windump");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            Class.forName("com.ibm.jvm.j9.dump.systemdump.Elfdump");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            Class.forName("com.ibm.jvm.j9.dump.systemdump.ZOSdump");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public class Loaded {
        String name;
        long startAddress;
        long size;

        Loaded(String string, long l, long l2) {
            this.name = string;
            this.startAddress = l;
            this.size = l2;
        }

        public String getName() {
            return this.name;
        }

        public long getSize() {
            return this.size;
        }

        public long getStartAddress() {
            return this.startAddress;
        }
    }
}

