/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.commandconsole;

import com.ibm.jvm.j9.dump.command.Command;
import com.ibm.jvm.j9.dump.command.J9JVMBaseCmds;
import com.ibm.jvm.j9.dump.commandconsole.DumpConsole;
import com.ibm.jvm.j9.dump.commandconsole.DumpUtils;
import com.ibm.jvm.j9.dump.commandconsole.DvNamesIndexFile;
import com.ibm.jvm.j9.dump.systemdump.GenericThread;
import com.ibm.jvm.j9.dump.systemdump.J9Class;
import com.ibm.jvm.j9.dump.systemdump.J9Heap;
import com.ibm.jvm.j9.dump.systemdump.J9Method;
import com.ibm.jvm.j9.dump.systemdump.J9Monitor;
import com.ibm.jvm.j9.dump.systemdump.J9Object;
import com.ibm.jvm.j9.dump.systemdump.J9Thread;
import com.ibm.jvm.j9.dump.systemdump.J9TraceBuffer;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Vector;

public class J9JVMConsole
extends DumpConsole {
    private static J9JVMConsole mySelf;
    protected static Vector threads;
    protected static HashMap knownClassesByName;
    protected static HashMap knownClassesById;
    protected static HashMap codeIds;
    protected static Vector knownHeaps;
    protected static DvNamesIndexFile namesFile;
    protected static Vector knownMonitors;
    protected static HashMap knownMonitorsByName;
    protected static HashMap knownMonitorsById;
    protected static HashMap LockedObjectsByAddress;
    protected static HashMap knownThreadsById;
    private static Vector traceBuffers;
    private static long traceFileHeaderAddress;
    private static int traceFileHeaderLength;
    private static String wParm;
    private static String iParm;
    private static String oParm;
    private static String dParm;
    private static String mParm;
    private static String jitVersion;
    private static PropertyResourceBundle helpData;

    public J9JVMConsole(String string, boolean bl) {
        super(string, false);
        mySelf = this;
        J9JVMBaseCmds j9JVMBaseCmds = new J9JVMBaseCmds();
        Command[] commandArray = j9JVMBaseCmds.getCommandSet();
        J9JVMConsole.registerCommandSet(commandArray);
        j9JVMBaseCmds.addObserver(mySelf);
        try {
            helpData = (PropertyResourceBundle)ResourceBundle.getBundle("com.ibm.jvm.j9.dump.command.J9JVMBaseCmdsHelp");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (null != helpData) {
            J9JVMConsole.addHelp(helpData);
        }
        j9JVMBaseCmds.addObserver(mySelf);
        Method method = null;
        try {
            method = this.getClass().getMethod("processArgs", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.setArgsProcessorMethod(method);
        if (bl) {
            J9JVMConsole.mainLoop();
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        if (stringArray.length > 0) {
            if (stringArray.length == 1 && !stringArray[0].startsWith("-") && !((File)(object = new File(stringArray[0]))).exists()) {
                J9JVMConsole.doOutput("\n\"" + object + "\" is not an existant file - invalid invocation\n");
                J9JVMConsole.doOutput(J9JVMConsole.usageInfo());
                System.exit(0);
            }
            if (null != (object = J9JVMConsole.analyseArgs(stringArray))) {
                J9JVMConsole.doOutput("\n" + (String)object + "\n");
                J9JVMConsole.doOutput(J9JVMConsole.usageInfo());
                System.exit(0);
            }
        }
        object = new J9JVMConsole("J9 Dump Analysis", true);
    }

    public static void processArgs() {
        int n;
        Object var2_2;
        String string;
        J9JVMConsole.doOutput("\nPlease wait while I process inbound arguments\n");
        String string2 = null;
        if (null != wParm) {
            string = "SET WORKDIR " + wParm;
            var2_2 = null;
            J9JVMConsole.doOutput("\n\t" + string);
            n = J9JVMConsole.findVerbNounCombo(string.toUpperCase());
            if (n != -1 && null != (string2 = J9JVMConsole.doCommand(n, string, null))) {
                J9JVMConsole.doOutput("\n\t\t" + string2);
            }
        }
        if (null != oParm) {
            string = "SET OUTPUT " + oParm;
            var2_2 = null;
            J9JVMConsole.doOutput("\n\t" + string);
            n = J9JVMConsole.findVerbNounCombo(string.toUpperCase());
            if (n != -1 && null != (string2 = J9JVMConsole.doCommand(n, string, null))) {
                J9JVMConsole.doOutput("\n\t\t" + string2);
            }
        }
        if (null != dParm) {
            string = "SET DUMP " + dParm;
            var2_2 = null;
            J9JVMConsole.doOutput("\n\t" + string);
            n = J9JVMConsole.findVerbNounCombo(string.toUpperCase());
            if (n != -1 && null != (string2 = J9JVMConsole.doCommand(n, string, null))) {
                J9JVMConsole.doOutput("\n\t\t" + string2);
            }
        }
        if (null != mParm) {
            string = "SET METADATA " + mParm;
            var2_2 = null;
            J9JVMConsole.doOutput("\n\t" + string);
            n = J9JVMConsole.findVerbNounCombo(string.toUpperCase());
            if (n != -1 && null != (string2 = J9JVMConsole.doCommand(n, string, null))) {
                J9JVMConsole.doOutput("\n\t\t" + string2);
            }
        }
        if (null != iParm) {
            string = "EX " + iParm;
            var2_2 = null;
            J9JVMConsole.doOutput("\n\t" + string);
            n = J9JVMConsole.findVerbNounCombo(string.toUpperCase());
            if (n != -1 && null != (string2 = J9JVMConsole.doCommand(n, string, null))) {
                J9JVMConsole.doOutput("\n\t\t" + string2);
            }
        }
    }

    private static String analyseArgs(String[] stringArray) {
        String string = null;
        String string2 = "dwioDWIO";
        if (stringArray.length != 0) {
            if (stringArray.length == 1 && !stringArray[0].startsWith("-")) {
                if (stringArray[0].equals("?")) {
                    string = J9JVMConsole.usageInfo();
                } else {
                    dParm = stringArray[0];
                }
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].startsWith("-")) {
                        String string3 = stringArray[i].substring(1);
                        String string4 = string3.substring(0, 1);
                        if (-1 == string2.indexOf(string4)) {
                            return "Invalid invocation -" + string4 + " parameter invalid ";
                        }
                        if (string4 != null) {
                            if ((string4 = string4.toUpperCase()).equals("D")) {
                                dParm = string3.substring(1);
                                continue;
                            }
                            if (string4.equals("I")) {
                                iParm = string3.substring(1);
                                continue;
                            }
                            if (string4.equals("O")) {
                                oParm = string3.substring(1);
                                continue;
                            }
                            if (!string4.equals("W")) continue;
                            wParm = string3.substring(1);
                            continue;
                        }
                        return "Invalid invocation -" + string4 + "invalid ";
                    }
                    if (i == stringArray.length - 1) {
                        dParm = stringArray[i];
                        continue;
                    }
                    return "Invalid invocation (embedded argument not starting with -)";
                }
            }
        }
        return string;
    }

    private static String usageInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Usage info:");
        stringBuffer.append("\n\n   jdmpview [-ddumpfilename] [-wworkdir] [-ooutput][-iinput]");
        stringBuffer.append("\n\n   where...");
        stringBuffer.append("\n     dumpfilename identifies a dumpfile");
        stringBuffer.append("\n     workdir identifies a writeable directory");
        stringBuffer.append("\n     output identifies an output file (format file:x:\\myfile)");
        stringBuffer.append("\n     input identifies an input command file (format x:\\myfile)");
        stringBuffer.append("\n\n   Notes: \"jdmpview dumpfilename\" is also valid");
        stringBuffer.append("\n          No spaces between the parameter identifier and their value.");
        return stringBuffer.toString();
    }

    public static int addCodeId(J9Method j9Method) {
        Long l = new Long(j9Method.getId());
        codeIds.put(l, j9Method);
        return threads.size() - 1;
    }

    public static String findMethod(String string) {
        String string2 = null;
        long l = DumpUtils.parseLongHex(string);
        Long l2 = new Long(l);
        J9Method j9Method = (J9Method)codeIds.get(l2);
        if (j9Method != null) {
            J9Class j9Class = j9Method.getMyClass();
            string2 = j9Class != null ? j9Class.getName() + "::" + j9Method.getMethodName() + j9Method.getSignature() : "?????????::" + j9Method.getMethodName() + j9Method.getSignature();
        }
        return string2;
    }

    public static int addJitCodeId(J9Method j9Method) {
        Long l = new Long(j9Method.getJitId());
        codeIds.put(l, j9Method);
        return threads.size() - 1;
    }

    public static int addThread(J9Thread j9Thread) {
        threads.add(j9Thread);
        String string = j9Thread.getThreadId();
        knownThreadsById.put(string, j9Thread);
        return threads.size() - 1;
    }

    public static void addClass(J9Class j9Class) {
        knownClassesByName.put(j9Class.getName(), j9Class);
        knownClassesById.put(j9Class.getId(), j9Class);
    }

    public static void addHeap(J9Heap j9Heap) {
        knownHeaps.add(j9Heap);
    }

    public static J9Class getClass(String string) {
        return (J9Class)knownClassesByName.get(string);
    }

    public static J9Class getClass(long l) {
        String string = Long.toHexString(l);
        return (J9Class)knownClassesById.get("0x" + string);
    }

    public static Vector getKnownHeaps() {
        return knownHeaps;
    }

    public static DvNamesIndexFile getNamesFile() {
        return namesFile;
    }

    public static void setNamesFile(DvNamesIndexFile dvNamesIndexFile) {
        namesFile = dvNamesIndexFile;
    }

    public static J9Monitor getMonitor(String string) {
        return (J9Monitor)knownMonitorsByName.get(string);
    }

    public static J9Monitor getMonitor(long l) {
        String string = Long.toHexString(l);
        return (J9Monitor)knownMonitorsById.get("0x" + string);
    }

    public static Vector getKnownMonitors() {
        return knownMonitors;
    }

    public static void addMonitor(J9Monitor j9Monitor) {
        knownMonitors.add(j9Monitor);
        knownMonitorsByName.put(j9Monitor.getName(), j9Monitor);
        knownMonitorsById.put(j9Monitor.getIdAsString(), j9Monitor);
    }

    public static Object isThisAMonitor(long l) {
        Object var2_1 = null;
        J9Monitor j9Monitor = (J9Monitor)knownMonitorsById.get("0x" + Long.toHexString(l));
        if (null == j9Monitor) {
            Iterator iterator = knownMonitorsById.values().iterator();
            while (iterator.hasNext()) {
                J9Monitor j9Monitor2 = (J9Monitor)iterator.next();
                long l2 = j9Monitor2.getId();
                if (l - l2 > 32L || l - l2 <= 0L) continue;
                return "This is close to a monitor (" + j9Monitor2.getName() + " @" + j9Monitor2.getIdAsString();
            }
        }
        return j9Monitor;
    }

    public static Vector getThreads() {
        return threads;
    }

    public static HashMap getKnownClassesByName() {
        return knownClassesByName;
    }

    public static void addLockedObject(J9Object j9Object) {
        LockedObjectsByAddress.put(new Long(j9Object.getObjectAddress()), j9Object);
    }

    public static HashMap getLockedObjectsByAddress() {
        return LockedObjectsByAddress;
    }

    public static Vector getLockedObjectsByThread(GenericThread genericThread) {
        Vector<J9Object> vector = new Vector<J9Object>();
        Iterator iterator = LockedObjectsByAddress.values().iterator();
        while (iterator.hasNext()) {
            J9Object j9Object = (J9Object)iterator.next();
            if (j9Object.getLockInfo() >>> 4 << 4 != DumpUtils.parseLongHex(genericThread.getThreadId())) continue;
            vector.add(j9Object);
        }
        return vector;
    }

    public static GenericThread getKnownThread(long l) {
        String string = "0x" + Long.toHexString(l);
        return (GenericThread)knownThreadsById.get(string);
    }

    public static Vector getTraceBuffers() {
        return traceBuffers;
    }

    public static void addTraceBuffer(String string, String string2, String string3, String string4, String string5) {
        long l = DumpUtils.parseLongHex(DumpUtils.stripOff0x(string5));
        long l2 = DumpUtils.parseLongHex(DumpUtils.stripOff0x(string));
        int n = Integer.parseInt(string2);
        int n2 = Integer.parseInt(string3);
        int n3 = Integer.parseInt(string4);
        long l3 = 0L;
        boolean bl = false;
        if (0L == l2) {
            bl = true;
        }
        while (!bl) {
            l3 = l2 + (long)n3;
            J9TraceBuffer j9TraceBuffer = new J9TraceBuffer(l3, n);
            traceBuffers.add(j9TraceBuffer);
            try {
                if ((l2 = theDump.readPtr(l2 + (long)n2)) != 0L) continue;
                bl = true;
            }
            catch (IOException iOException) {
                J9JVMConsole.reportError("Error encountered analysing trace buffers chain", iOException);
                bl = true;
            }
        }
    }

    public static long getTraceFileHeaderAddress() {
        return traceFileHeaderAddress;
    }

    public static void setTraceFileHeaderAddress(long l) {
        traceFileHeaderAddress = l;
    }

    public static int getTraceFileHeaderLength() {
        return traceFileHeaderLength;
    }

    public static void setTraceFileHeaderLength(int n) {
        traceFileHeaderLength = n;
    }

    public static String getJitVersion() {
        return jitVersion;
    }

    public static void setJitVersion(String string) {
        jitVersion = string;
    }

    static {
        threads = new Vector();
        knownClassesByName = new HashMap();
        knownClassesById = new HashMap();
        codeIds = new HashMap();
        knownHeaps = new Vector();
        knownMonitors = new Vector();
        knownMonitorsByName = new HashMap();
        knownMonitorsById = new HashMap();
        LockedObjectsByAddress = new HashMap();
        knownThreadsById = new HashMap();
        traceBuffers = new Vector();
    }
}

