/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.commandconsole;

import com.ibm.jvm.j9.dump.commandconsole.DumpConsole;
import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.MemoryRange;
import java.io.IOException;
import java.util.Vector;

public class DumpUtils {
    public static final int ADDRESSES_EQUAL = 0;
    public static final int ADDRESS_GT = 1;
    public static final int ADDRESS_LT = -1;
    private static int ptrSize = 0;
    private static final String s16Zeros = "0000000000000000";
    private static final String s16blanks = "                ";
    private static final String s32blanks = "                                ";
    public static String byteToHex = "000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F202122232425262728292A2B2C2D2E2F303132333435363738393A3B3C3D3E3F404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F606162636465666768696A6B6C6D6E6F707172737475767778797A7B7C7D7E7F808182838485868788898A8B8C8D8E8F909192939495969798999A9B9C9D9E9FA0A1A2A3A4A5A6A7A8A9AAABACADAEAFB0B1B2B3B4B5B6B7B8B9BABBBCBDBEBFC0C1C2C3C4C5C6C7C8C9CACBCCCDCECFD0D1D2D3D4D5D6D7D8D9DADBDCDDDEDFE0E1E2E3E4E5E6E7E8E9EAEBECEDEEEFF0F1F2F3F4F5F6F7F8F9FAFBFCFDFEFF";
    public static String byteToAscii = "................................ !\"#$%&'()*+'-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~.................................................................................................................................";
    public static String byteToEbcdic = "..........................................................................\u00a3.<(+|&.........!$*);\u00ac-/.........,%_>?..........:#@'=\".abcdefghi.......jklmnopqr........stuvwxyz...............`.......ABCDEFGHI.......JKLMNOPQR........STUVWXYZ......0123456789......";

    public static Vector formatMemory(byte[] byArray, long l, int n, boolean bl) {
        Object object;
        long l2 = l;
        if (0 == ptrSize) {
            DumpUtils.initPtrSize();
        }
        String string = "| ";
        Vector<String> vector = new Vector<String>();
        if (DumpConsole.getTheDump().getSystemType() == 3) {
            object = DumpConsole.getTheDump();
            int n2 = ((Dump)object).findWhichMemoryRange(l);
            if (n2 == -1) {
                vector.add("\n  Asid: ???");
            } else {
                MemoryRange[] memoryRangeArray = ((Dump)object).getMemoryRanges();
                vector.add("\n  Asid: 0x" + Integer.toHexString(memoryRangeArray[n2].getAsid()));
            }
        }
        if (((String)(object = Long.toHexString(l2))).length() < ptrSize) {
            object = s16Zeros.substring(0, ptrSize - ((String)object).length()) + (String)object;
        }
        StringBuffer stringBuffer = new StringBuffer("\n" + (String)object + ": ");
        boolean bl2 = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 1;
        while (n5 < byArray.length) {
            bl2 = true;
            n3 = byArray[n5];
            if (n3 < 0) {
                n3 += 256;
            }
            stringBuffer.append(byteToHex.substring(2 * n3, 2 * n3 + 2));
            string = bl ? string + byteToAscii.substring(n3, n3 + 1) : string + byteToEbcdic.substring(n3, n3 + 1);
            if (0 == n6 % 4) {
                stringBuffer.append(" ");
            }
            if (n == n6) {
                bl2 = false;
                stringBuffer.append(string);
                string = "| ";
                n6 = 0;
                vector.add(stringBuffer.toString() + " |");
                ++n4;
                object = Long.toHexString(l2 += (long)n);
                if (((String)object).length() < ptrSize) {
                    object = s16Zeros.substring(0, ptrSize - ((String)object).length()) + (String)object;
                }
                stringBuffer.setLength(0);
                stringBuffer.append((String)object + ": ");
            }
            ++n5;
            ++n6;
        }
        if (bl2) {
            stringBuffer.append(s32blanks.substring((string.length() - 2) * 2 - 1) + string);
            vector.add(stringBuffer.toString());
        }
        return vector;
    }

    public static final short convertEndian(short s) {
        int n = s << 8;
        int n2 = s >>> 8;
        short s2 = (short)(n + n2);
        return s2;
    }

    public static final int convertEndian(int n) {
        return n >>> 24 | n << 24 | n << 8 & 0xFF0000 | n >> 8 & 0xFF00;
    }

    public static final long convertEndian(long l) {
        long l2 = l & 0xFFFFFFFF00000000L;
        long l3 = l & 0xFFFFFFFFL;
        int n = (int)(l2 >>> 32);
        int n2 = (int)l3;
        l3 = DumpUtils.convertEndian(n);
        l2 = (long)DumpUtils.convertEndian(n2) << 32;
        return (l2 &= 0xFFFFFFFF00000000L) + (l3 &= 0xFFFFFFFFL);
    }

    public static final long parseLongHex(String string) throws NumberFormatException {
        long l = 0L;
        if (null == string) {
            return 0L;
        }
        string = DumpUtils.stripOff0x(string);
        try {
            l = Long.parseLong(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            if (string.length() < 16) {
                throw numberFormatException;
            }
            if (string.length() > 16) {
                throw numberFormatException;
            }
            String string2 = string.substring(0, 1);
            String string3 = null;
            int n = Integer.parseInt(string2, 16);
            if (n > 7) {
                string3 = Integer.toString(n - 8, 16);
                string2 = string3 + string.substring(1);
                l = Long.parseLong(string2, 16);
                l |= Long.MIN_VALUE;
            }
            throw numberFormatException;
        }
        return l;
    }

    public static Vector findInMemory(Dump dump, byte[] byArray, long l, long l2, int n, int n2, boolean bl) {
        long l3 = 0L;
        Vector<Long> vector = new Vector<Long>();
        long l4 = l;
        long l5 = l2;
        if (0L != l4 % (long)n) {
            l4 += (long)n - l4 % (long)n;
            l4 -= l4 % (long)n;
        }
        if (0L != l5 % (long)n) {
            l5 += (long)n - l5 % (long)n;
            if ((l5 -= l5 % (long)n) <= (long)n) {
                l5 = -l5;
            }
        }
        if (DumpUtils.addressCompare(l4, l5) == -1) {
            MemoryRange[] memoryRangeArray = dump.getMemoryRanges();
            for (int i = 0; i < memoryRangeArray.length && vector.size() < n2; ++i) {
                long l6 = memoryRangeArray[i].getVaddr();
                long l7 = l6 + memoryRangeArray[i].getSize();
                if (0L != l6 % (long)n) {
                    l6 += (long)n - l6 % (long)n;
                }
                if (0L != l7 % (long)n) {
                    l7 += (long)n - l7 % (long)n;
                }
                if (DumpUtils.addressCompare(l2, l) != 1 || DumpUtils.addressCompare(l, l7) != -1 || DumpUtils.addressCompare(l6, l2) != -1 || memoryRangeArray[i].getSize() == 0L) continue;
                long l8 = l6;
                if (DumpUtils.addressCompare(l8, l) == -1) {
                    l8 = l;
                }
                boolean bl2 = false;
                while (!bl2) {
                    long l9 = l8;
                    int n3 = 16000;
                    byte[] byArray2 = null;
                    byArray2 = dump.getMemoryBytes(l8, 16384);
                    int n4 = 0;
                    if (null != byArray2) {
                        l3 += (long)byArray2.length;
                        n4 = byArray2.length;
                        if (16384 == byArray2.length) {
                            if (DumpUtils.addressCompare(l7, l8 += 16000L) == -1 || DumpUtils.addressCompare(l2, l8) == -1) {
                                bl2 = true;
                            }
                        } else {
                            bl2 = true;
                            n3 = n4;
                        }
                    } else {
                        bl2 = true;
                    }
                    boolean bl3 = false;
                    if (n4 <= 0 || n4 < byArray.length) continue;
                    for (int j = 0; j < n3; j += n) {
                        int n5 = 0;
                        bl3 = true;
                        for (int k = 0; k < byArray.length && bl3 && k + j < n4; ++k) {
                            if (byArray[k] != byArray2[k + j]) {
                                bl3 = false;
                                continue;
                            }
                            ++n5;
                        }
                        if (bl3 && n5 != byArray.length) {
                            bl3 = false;
                        }
                        if (!bl3) continue;
                        long l10 = l9 + (long)j;
                        int n6 = DumpUtils.addressCompare(l10, l2);
                        if (n6 != 1) {
                            vector.add(new Long(l9 + (long)j));
                            if (n2 != vector.size()) continue;
                            j = n3;
                            bl2 = true;
                            continue;
                        }
                        bl2 = true;
                    }
                }
            }
        }
        return vector;
    }

    public static int addressCompare(long l, long l2) {
        int n = 0;
        if (l == l2) {
            return n;
        }
        if (l >= 0L && l2 >= 0L || l < 0L && l2 < 0L) {
            n = l > l2 ? 1 : -1;
        } else if (l2 >= 0L && l < 0L) {
            n = 1;
        } else if (l >= 0L && l2 < 0L) {
            n = -1;
        }
        return n;
    }

    public static String chainViaPtr(String string, boolean bl) {
        String string2 = null;
        String string3 = string.substring(1);
        long l = DumpUtils.parseLongHex(string3 = DumpUtils.stripOff0x(string3));
        if (0L != l) {
            Dump dump = DumpConsole.getTheDump();
            long l2 = 0L;
            try {
                l2 = dump.readPtr(l);
                string2 = Long.toHexString(l2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string2;
    }

    public static String stripOff0x(String string) {
        String string2 = string.toUpperCase();
        if (string2.startsWith("0X")) {
            string2 = string2.substring(2);
        }
        return string2;
    }

    public static String padToPtrSize(String string) {
        String string2 = string;
        if (0 == ptrSize) {
            DumpUtils.initPtrSize();
        }
        if (string.length() < ptrSize) {
            string2 = s16Zeros.substring(0, ptrSize - string.length()) + string;
        }
        return string2;
    }

    public static String padWithSpaces(String string, int n) {
        int n2;
        String string2 = string;
        if (n > 16) {
            n = 16;
        }
        if ((n2 = string.length()) < n) {
            string2 = s16blanks.substring(0, n - n2) + string;
        }
        return string2;
    }

    private static void initPtrSize() {
        Dump dump = DumpConsole.getTheDump();
        ptrSize = dump.is32bit() ? 8 : 16;
    }
}

