/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel;

import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.ClassRecord;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.LongObjectRecord;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.LongPrimitveArrayRecord;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.MediumObjectRecord;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.ObjectArrayRecord;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDump;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDumpClassCache;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDumpHandler;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PrimitiveArrayRecord;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.ShortObjectRecord;
import com.ibm.jvm.j9.dump.systemdump.J9Object;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class PortableHeapDumpRecord {
    public static final byte ONE_BYTE_REF = 0;
    public static final byte TWO_BYTE_REF = 1;
    public static final byte FOUR_BYTE_REF = 2;
    public static final byte EIGHT_BYTE_REF = 3;
    public static final String[] REF_SIZE_TO_STRING;
    public static final byte WORD_SIZE_32BIT = 4;
    public static final byte WORD_SIZE_64BIT = 8;
    public static final int ADDRESS_SHIFT_SIZE = 2;
    protected byte tag;
    protected long length;
    protected long[] References;
    protected byte referenceSize;
    protected short hashCode;
    static final /* synthetic */ boolean $assertionsDisabled;

    public boolean getTagBit(int n) {
        return (this.tag & 1 << n) > 0;
    }

    public int getTagValue(int n, int n2) {
        if (n < 0 || n2 > 8) {
            throw new IllegalArgumentException();
        }
        int n3 = this.tag;
        n3 &= 255 >>> 7 - n;
        n3 &= 255 << n2;
        return n3 >>>= n2;
    }

    public long getLength() {
        return this.length;
    }

    protected static byte sizeofReference(long l) {
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            return 3;
        }
        if (l > 32767L || l < -32768L) {
            return 2;
        }
        if (l > 127L || l < -128L) {
            return 1;
        }
        return 0;
    }

    protected void setReferences(J9Object j9Object) {
        long[] lArray = j9Object.getObjectRefs();
        if (lArray == null) {
            this.References = new long[0];
            return;
        }
        this.References = new long[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            this.References[i] = PortableHeapDumpRecord.getAddressDifference(lArray[i], j9Object.getObjectAddress());
            byte by = PortableHeapDumpRecord.sizeofReference(this.References[i]);
            if (by <= this.referenceSize) continue;
            this.referenceSize = by;
        }
    }

    protected void writeReference(DataOutput dataOutput, byte by, long l) throws IOException {
        switch (by) {
            case 0: {
                dataOutput.writeByte((byte)l);
                break;
            }
            case 1: {
                dataOutput.writeShort((short)l);
                break;
            }
            case 2: {
                dataOutput.writeInt((int)l);
                break;
            }
            case 3: {
                dataOutput.writeLong(l);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong size argument!");
            }
        }
    }

    protected static long readReference(DataInput dataInput, byte by, long l) throws IOException {
        long l2 = 0L;
        switch (by) {
            case 0: {
                l2 = dataInput.readByte() << 2;
                l2 += l;
                break;
            }
            case 1: {
                l2 = dataInput.readShort() << 2;
                l2 += l;
                break;
            }
            case 2: {
                l2 = dataInput.readInt() << 2;
                l2 += l;
                break;
            }
            case 3: {
                l2 = dataInput.readLong() << 2;
                l2 = l;
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong size argument!");
            }
        }
        return l2;
    }

    protected static long[] readReferences(DataInput dataInput, long l, byte by, int n) throws IOException {
        if (n == 0) {
            return null;
        }
        long[] lArray = new long[n];
        switch (by) {
            case 0: {
                int n2 = 0;
                while (n2 < lArray.length) {
                    lArray[n2] = dataInput.readByte() << 2;
                    int n3 = n2++;
                    lArray[n3] = lArray[n3] + l;
                }
                break;
            }
            case 1: {
                int n4 = 0;
                while (n4 < lArray.length) {
                    lArray[n4] = dataInput.readShort() << 2;
                    int n5 = n4++;
                    lArray[n5] = lArray[n5] + l;
                }
                break;
            }
            case 2: {
                int n6 = 0;
                while (n6 < lArray.length) {
                    lArray[n6] = dataInput.readInt() << 2;
                    int n7 = n6++;
                    lArray[n7] = lArray[n7] + l;
                }
                break;
            }
            case 3: {
                int n8 = 0;
                while (n8 < lArray.length) {
                    lArray[n8] = dataInput.readLong() << 2;
                    int n9 = n8++;
                    lArray[n9] = lArray[n9] + l;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Error size byte invalid");
            }
        }
        return lArray;
    }

    protected void writeReferences(DataOutput dataOutput) throws IOException {
        if (this.References.length == 0) {
            return;
        }
        switch (this.referenceSize) {
            case 0: {
                for (int i = 0; i < this.References.length; ++i) {
                    dataOutput.writeByte((byte)this.References[i]);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < this.References.length; ++i) {
                    dataOutput.writeShort((short)this.References[i]);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.References.length; ++i) {
                    dataOutput.writeInt((int)this.References[i]);
                }
                break;
            }
            case 3: {
                for (int i = 0; i < this.References.length; ++i) {
                    dataOutput.writeLong(this.References[i]);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Error size byte invalid");
            }
        }
    }

    protected static long getAddressDifference(long l, long l2) {
        return l - l2 >> 2;
    }

    protected static long getAddressDifference(J9Object j9Object, J9Object j9Object2) {
        if (j9Object2 == null) {
            return j9Object.getObjectAddress() >> 2;
        }
        return PortableHeapDumpRecord.getAddressDifference(j9Object.getObjectAddress(), j9Object2.getObjectAddress());
    }

    protected static void writeArrayRecord(DataOutput dataOutput, J9Object j9Object, J9Object j9Object2) throws IOException {
        boolean bl = j9Object.isPrimitiveArray();
        boolean bl2 = false;
        boolean bl3 = false;
        if (bl) {
            if (bl2 || bl3) {
                if (PortableHeapDump.DEBUG) {
                    PortableHeapDump.DEBUG_STREAM.print("Long Primitive Array Object");
                }
                new LongPrimitveArrayRecord(j9Object, j9Object2).writeHeapDump(dataOutput);
            } else {
                if (PortableHeapDump.DEBUG) {
                    PortableHeapDump.DEBUG_STREAM.print("Primitive Array Object");
                }
                new PrimitiveArrayRecord(j9Object, j9Object2).writeHeapDump(dataOutput);
            }
        } else {
            if (PortableHeapDump.DEBUG) {
                PortableHeapDump.DEBUG_STREAM.print("Object Array");
            }
            new ObjectArrayRecord(j9Object, j9Object2).writeHeapDump(dataOutput);
        }
        if (PortableHeapDump.DEBUG) {
            PortableHeapDump.DEBUG_STREAM.print(" class = " + j9Object.getClassForObject().getName());
            PortableHeapDump.DEBUG_STREAM.print(" address difference=" + PortableHeapDumpRecord.getAddressDifference(j9Object, j9Object2) + " double words");
            PortableHeapDump.DEBUG_STREAM.println();
        }
    }

    protected static void writeClassRecord(DataOutput dataOutput, J9Object j9Object, J9Object j9Object2) throws IOException {
        if (PortableHeapDump.DEBUG) {
            PortableHeapDump.DEBUG_STREAM.println("Class Record: Current = 0x" + Long.toHexString(j9Object.getObjectAddress()) + (j9Object2 == null ? " previous is null " : " previous = 0x" + Long.toHexString(j9Object2.getObjectAddress())));
        }
        new ClassRecord(j9Object, j9Object2).writeHeapDump(dataOutput);
    }

    protected static boolean isShortObjectEligible(J9Object j9Object, J9Object j9Object2) {
        long l = PortableHeapDumpRecord.getAddressDifference(j9Object, j9Object2);
        return l < 32767L && l > -32768L;
    }

    protected static void writeObjectRecord(DataOutput dataOutput, J9Object j9Object, J9Object j9Object2, byte by) throws IOException {
        PortableHeapDumpRecord portableHeapDumpRecord;
        if (by == -1 || j9Object2 == null) {
            if (PortableHeapDump.DEBUG) {
                PortableHeapDump.DEBUG_STREAM.print("Long Object, new class insert in cache");
            }
            portableHeapDumpRecord = new LongObjectRecord(j9Object, j9Object2);
        } else if (PortableHeapDumpRecord.isShortObjectEligible(j9Object, j9Object2)) {
            int n = 0;
            long[] lArray = j9Object.getObjectRefs();
            if (lArray != null) {
                n = lArray.length;
            }
            if (n <= 3) {
                if (PortableHeapDump.DEBUG) {
                    PortableHeapDump.DEBUG_STREAM.print("Short Object, no of ref =" + n);
                }
                portableHeapDumpRecord = new ShortObjectRecord(j9Object, j9Object2, by);
            } else if (n < 8) {
                if (PortableHeapDump.DEBUG) {
                    PortableHeapDump.DEBUG_STREAM.print("Medium Object, no of ref =" + n);
                }
                portableHeapDumpRecord = new MediumObjectRecord(j9Object, j9Object2);
            } else {
                if (PortableHeapDump.DEBUG) {
                    PortableHeapDump.DEBUG_STREAM.print("Long Object, no of ref=" + n);
                }
                portableHeapDumpRecord = new LongObjectRecord(j9Object, j9Object2);
            }
        } else {
            if (PortableHeapDump.DEBUG) {
                PortableHeapDump.DEBUG_STREAM.println("Long Object");
            }
            portableHeapDumpRecord = new LongObjectRecord(j9Object, j9Object2);
        }
        if (!$assertionsDisabled && portableHeapDumpRecord == null) {
            throw new AssertionError();
        }
        if (PortableHeapDump.DEBUG) {
            PortableHeapDump.DEBUG_STREAM.print(" class = " + j9Object.getClassForObject().getName());
            PortableHeapDump.DEBUG_STREAM.print(" address difference=" + PortableHeapDumpRecord.getAddressDifference(j9Object, j9Object2) + " double words");
            PortableHeapDump.DEBUG_STREAM.println();
        }
        ((PortableHeapDumpRecord)portableHeapDumpRecord).writeHeapDump(dataOutput);
    }

    protected static void readObjectRecords(DataInput dataInput, PortableHeapDumpHandler portableHeapDumpHandler) {
        PortableHeapDumpClassCache portableHeapDumpClassCache = new PortableHeapDumpClassCache();
        try {
            long l = 0L;
            byte by = dataInput.readByte();
            block8: while (by != 3) {
                switch (by) {
                    case 4: {
                        LongObjectRecord.readHeapDump(dataInput, by, portableHeapDumpHandler, l, portableHeapDumpClassCache);
                        continue block8;
                    }
                    case 5: {
                        ObjectArrayRecord.readHeapDump(dataInput, by, portableHeapDumpHandler, l, null);
                        continue block8;
                    }
                    case 6: {
                        ClassRecord.readHeapDump(dataInput, by, portableHeapDumpHandler);
                        continue block8;
                    }
                    case 7: {
                        LongPrimitveArrayRecord.readHeapDump(dataInput, by, portableHeapDumpHandler);
                        continue block8;
                    }
                }
                byte by2 = by;
                if ((by2 & 0xFFFFFF80) != 0) {
                    ShortObjectRecord.readHeapDump(dataInput, by, portableHeapDumpHandler, portableHeapDumpClassCache);
                    continue;
                }
                if ((by2 & 0x40) != 0) {
                    MediumObjectRecord.readHeapDump(dataInput, by, portableHeapDumpHandler, portableHeapDumpClassCache);
                    continue;
                }
                if ((by2 & 0x20) != 0) {
                    PrimitiveArrayRecord.readHeapDump(dataInput, by, portableHeapDumpHandler);
                    continue;
                }
                portableHeapDumpHandler.exceptionDetected(new Exception("Unknown Record type, flag byte =" + by));
            }
            portableHeapDumpHandler.endOfDump();
        }
        catch (Exception exception) {
            portableHeapDumpHandler.exceptionDetected(exception);
        }
    }

    public short getHashcode() {
        return this.hashCode;
    }

    public void setHashcode(short s) {
        this.hashCode = s;
    }

    protected abstract void writeHeapDump(DataOutput var1) throws IOException;

    static {
        $assertionsDisabled = !PortableHeapDumpRecord.class.desiredAssertionStatus();
        REF_SIZE_TO_STRING = new String[]{"one byte (byte)", "two byte (short)", "four byte (int)", "eight byte (long)"};
    }
}

