/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel;

import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDump;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDumpClassCache;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDumpHandler;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDumpRecord;
import com.ibm.jvm.j9.dump.systemdump.J9Object;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LongObjectRecord
extends PortableHeapDumpRecord {
    public static final byte MAGIC_NUMBER = 4;
    protected byte gapSize;
    protected byte sizeOfReference;
    protected boolean pinned;
    protected boolean dosed;
    protected boolean hashedandmoved;
    protected boolean hashed;
    protected long addressofClass;
    protected long gapPreceding;

    public LongObjectRecord(J9Object j9Object, J9Object j9Object2) {
        this.tag = (byte)4;
        this.setReferences(j9Object);
        this.addressofClass = j9Object.getClassForObject().getClassAddress();
        this.gapPreceding = LongObjectRecord.getAddressDifference(j9Object, j9Object2);
        this.gapSize = LongObjectRecord.sizeofReference(this.gapPreceding);
    }

    public void writeHeapDump(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(this.tag);
        int n = 0;
        n = (byte)(n | this.gapSize << 6);
        if (PortableHeapDump.DEBUG) {
            PortableHeapDump.DEBUG_STREAM.print("gapSize = " + this.gapSize);
        }
        n = (byte)(n | this.referenceSize << 4);
        if (this.pinned) {
            n = (byte)(n | 8);
        }
        if (this.dosed) {
            n = (byte)(n | 4);
        }
        if (this.hashedandmoved) {
            n = (byte)(n | 2);
        }
        if (this.hashed) {
            n = (byte)(n | 1);
        }
        dataOutput.writeByte(n);
        this.writeReference(dataOutput, this.gapSize, this.gapPreceding);
        if (PortableHeapDump.is32bit()) {
            dataOutput.writeInt((int)this.addressofClass);
        } else {
            dataOutput.writeLong(this.addressofClass);
        }
        if (PortableHeapDump.DEBUG) {
            PortableHeapDump.DEBUG_STREAM.print(" addressOfClass = " + this.addressofClass);
        }
        if (PortableHeapDump.isJ9()) {
            dataOutput.writeShort(this.hashCode);
        } else if (this.hashedandmoved || this.hashed) {
            dataOutput.writeInt(this.hashCode);
        }
        dataOutput.writeInt(this.References.length);
        if (PortableHeapDump.DEBUG) {
            PortableHeapDump.DEBUG_STREAM.println("num of ref = " + this.References.length);
        }
        this.writeReferences(dataOutput);
    }

    public static long readHeapDump(DataInput dataInput, byte by, PortableHeapDumpHandler portableHeapDumpHandler, long l, PortableHeapDumpClassCache portableHeapDumpClassCache) {
        long l2 = 0L;
        try {
            byte by2 = dataInput.readByte();
            byte by3 = (byte)((by2 & 0xC0) >>> 6);
            byte by4 = (byte)((by2 & 0x30) >>> 4);
            l2 = PortableHeapDumpRecord.readReference(dataInput, by3, l);
            long l3 = 0L;
            l3 = PortableHeapDump.is32bit() ? (long)dataInput.readInt() : dataInput.readLong();
            portableHeapDumpClassCache.setClassCacheIndex(l3);
            dataInput.readShort();
            int n = dataInput.readInt();
            long[] lArray = PortableHeapDumpRecord.readReferences(dataInput, l2, by4, n);
            portableHeapDumpHandler.object(l2, l3, lArray);
        }
        catch (Exception exception) {
            portableHeapDumpHandler.exceptionDetected(exception);
        }
        return l2;
    }
}

