/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel;

import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDump;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDumpHandler;
import com.ibm.jvm.j9.dump.command.heapdump.PortableHeapDumpModel.PortableHeapDumpRecord;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMConsole;
import com.ibm.jvm.j9.dump.systemdump.J9Class;
import com.ibm.jvm.j9.dump.systemdump.J9Object;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ClassRecord
extends PortableHeapDumpRecord {
    public static final byte MAGIC_NUMBER = 6;
    private byte gapSize;
    private long gapPreceding;
    private boolean hashedandmoved;
    private int instanceSize;
    private long superclass;
    private String className;

    public ClassRecord(J9Object j9Object, J9Object j9Object2) {
        this.tag = (byte)6;
        J9Class j9Class = J9JVMConsole.getClass(j9Object.getObjectAddress());
        this.className = j9Class.getName();
        this.setReferences(j9Object);
        this.gapPreceding = ClassRecord.getAddressDifference(j9Object, j9Object2);
        this.gapSize = ClassRecord.sizeofReference(this.gapPreceding);
        this.instanceSize = j9Class.getInstanceSize();
        this.superclass = Long.decode(j9Object.getClassForObject().getSuperId());
        if (PortableHeapDump.isJ9()) {
            this.hashedandmoved = false;
        }
    }

    public void writeHeapDump(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(this.tag);
        int n = 0;
        n = (byte)(n | this.gapSize << 6);
        n = (byte)(n | this.referenceSize << 4);
        if (this.hashedandmoved) {
            n = (byte)(n | 8);
        }
        dataOutput.writeByte(n);
        this.writeReference(dataOutput, this.gapSize, this.gapPreceding);
        dataOutput.writeInt(this.instanceSize);
        dataOutput.writeShort(this.hashCode());
        if (PortableHeapDump.is32bit()) {
            dataOutput.writeInt((int)this.superclass);
        } else {
            dataOutput.writeLong(this.superclass);
        }
        dataOutput.writeUTF(this.className);
        dataOutput.writeInt(this.References.length);
        this.writeReferences(dataOutput);
    }

    public static void readHeapDump(DataInput dataInput, byte by, PortableHeapDumpHandler portableHeapDumpHandler) {
    }
}

