/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soap.transport;

import com.ibm.trl.util.Logger;
import com.ibm.ws.security.util.AccessController;
import com.ibm.xml.soap.transport.EditorComponent;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.security.PrivilegedAction;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.soap.SOAPException;
import org.apache.soap.transport.EnvelopeEditorAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class PluggableEnvelopeEditor
extends EnvelopeEditorAdapter {
    public static final String ENVELOPE_EDITOR_HOME = "EnvelopeEditorHome";
    static final String INCOMING = "incoming";
    static final String OUTGOING = "outgoing";
    static final String EDITOR_CLASS = "class";
    static final String PARAM_NAME = "param-name";
    static final String PARAM_VALUE = "param-value";
    private final EditorComponent incomingEditor;
    private final EditorComponent outgoingEditor;
    private static final PrivilegedAction getCtxClassLoader = new PrivilegedAction(){

        public Object run() {
            return Thread.currentThread().getContextClassLoader();
        }
    };

    public PluggableEnvelopeEditor(InputSource inputSource, String string) throws ParserConfigurationException, IOException, SAXException, SOAPException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputSource);
        this.incomingEditor = this.createEditor(document, INCOMING, string);
        this.outgoingEditor = this.createEditor(document, OUTGOING, string);
    }

    public EditorComponent createEditor(Document document, String string, String string2) throws SOAPException {
        try {
            Object object;
            Properties properties = new Properties();
            Element element = (Element)document.getElementsByTagName(string).item(0);
            if (element == null) {
                System.out.println("key(" + string + ") not found");
                return null;
            }
            String string3 = element.getAttribute(EDITOR_CLASS);
            Logger.normal("EditorComponent class name: " + string3);
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                if (nodeList.item(i).getNodeType() != 1) continue;
                object = (Element)nodeList.item(i);
                NodeList nodeList2 = object.getChildNodes();
                int n2 = nodeList2.getLength();
                String string4 = null;
                String string5 = null;
                for (int j = 0; j < n2; ++j) {
                    if (nodeList2.item(j).getNodeType() != 1) continue;
                    Element element2 = (Element)nodeList2.item(j);
                    if (element2.getTagName().equals(PARAM_NAME)) {
                        string4 = element2.getFirstChild().getNodeValue();
                        continue;
                    }
                    if (element2.getTagName().equals(PARAM_VALUE)) {
                        string5 = element2.getFirstChild().getNodeValue();
                        continue;
                    }
                    throw new Exception("Wrong tag name in editor conf file: " + element2.getTagName());
                }
                properties.setProperty(string4, string5);
            }
            properties.setProperty(ENVELOPE_EDITOR_HOME, string2);
            EditorComponent editorComponent = null;
            if (string3 != null) {
                object = (ClassLoader)AccessController.doPrivileged((PrivilegedAction)getCtxClassLoader);
                editorComponent = object != null ? (EditorComponent)((ClassLoader)object).loadClass(string3).newInstance() : (EditorComponent)Class.forName(string3).newInstance();
                Logger.normal(properties.toString());
                Logger.normal(properties.getProperty("filename"));
                editorComponent.init(properties);
            }
            return editorComponent;
        }
        catch (Exception exception) {
            throw new SOAPException("ServerEroor", "Editor Conf Problem", (Throwable)exception);
        }
    }

    public void editIncoming(Reader reader, Writer writer) throws SOAPException {
        if (this.incomingEditor == null) {
            this.passThrough(reader, writer);
            return;
        }
        this.incomingEditor.edit(reader, writer);
    }

    public void editOutgoing(Reader reader, Writer writer) throws SOAPException {
        if (this.outgoingEditor == null) {
            this.passThrough(reader, writer);
            return;
        }
        this.outgoingEditor.edit(reader, writer);
    }

    public static void main(String[] stringArray) throws Exception {
        PluggableEnvelopeEditor pluggableEnvelopeEditor = new PluggableEnvelopeEditor(new InputSource(stringArray[0]), ".");
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(System.out);
        pluggableEnvelopeEditor.editOutgoing(new FileReader(stringArray[1]), outputStreamWriter);
        ((Writer)outputStreamWriter).flush();
        System.out.flush();
    }
}

