/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soap.security;

import com.ibm.trl.util.Logger;
import com.ibm.xml.soap.security.util.PasswordAgent;
import com.ibm.xml.soap.transport.AbstractSOAPHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import org.apache.soap.Constants;
import org.apache.soap.SOAPException;
import org.w3c.dom.Element;

public abstract class SOAPSecurityHandler
extends AbstractSOAPHandler {
    private static final String[] SECURITY_PROVIDERS;
    static final String RES_INPUT_KEYSTOREPASS = "Please input keystore password";

    private static synchronized void addSecurityProvider(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            try {
                Security.addProvider((Provider)clazz.newInstance());
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    protected KeyStore getKeyStore(Element element) throws SOAPException {
        String string = element.getAttribute("type");
        String string2 = element.getAttribute("path");
        char[] cArray = element.getAttribute("storepass").toCharArray();
        if (cArray.length == 0) {
            cArray = PasswordAgent.show("Please input keystore password for \"" + string2 + "\"");
        }
        if (cArray == null) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Can't get the keystore password: " + string2);
        }
        Logger.normal("KeyStore type: " + string, 3);
        Logger.normal("KeyStore path: " + string2, 3);
        Logger.normal("KeyStore password: " + new String(cArray), 3);
        return this.createKeyStore(string, string2, cArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private KeyStore createKeyStore(String string, String string2, char[] cArray) throws SOAPException {
        try {
            KeyStore keyStore = KeyStore.getInstance(string);
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(new File(this.home, string2));
                keyStore.load(fileInputStream, cArray);
                Object var7_11 = null;
                if (fileInputStream == null) return keyStore;
            }
            catch (Throwable throwable) {
                Object var7_12 = null;
                if (fileInputStream == null) throw throwable;
                try {
                    ((InputStream)fileInputStream).close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                ((InputStream)fileInputStream).close();
                return keyStore;
            }
            catch (IOException iOException) {}
            return keyStore;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "File not found: " + string2, (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "IO error occured while reading " + string2, (Throwable)iOException);
        }
        catch (CertificateException certificateException) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Certificate error occured while loading a key store '" + string2 + "'", (Throwable)certificateException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Encountered unknown algorithm while loading a keystore '" + string2 + "'", (Throwable)noSuchAlgorithmException);
        }
        catch (KeyStoreException keyStoreException) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Unknown key store type: " + string, (Throwable)keyStoreException);
        }
    }

    static {
        int n;
        SECURITY_PROVIDERS = new String[]{"sun.security.provider.Sun", "com.ibm.crypto.provider.IBMJCE", "com.ibm.security.cert.IBMCertPath"};
        Logger.normal("Removing all security providers", 3);
        Provider[] providerArray = Security.getProviders();
        for (n = 0; n < providerArray.length; ++n) {
            Security.removeProvider(providerArray[n].getName());
        }
        for (n = 0; n < SECURITY_PROVIDERS.length; ++n) {
            SOAPSecurityHandler.addSecurityProvider(SECURITY_PROVIDERS[n]);
        }
        providerArray = Security.getProviders();
        Logger.normal("Registered security providers:", 3);
        for (n = 0; n < providerArray.length; ++n) {
            Logger.normal("provider[" + n + "]=" + providerArray[n].getName(), 3);
        }
    }
}

