/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trl.soapimpl;

import com.ibm.trl.util.xml.DOMConverter;
import com.ibm.trl.util.xml.DOMHandler;
import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.NoSuchElementException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class ObjectStore {
    public static final String ELEM_JOBJ = "JavaObject";
    public static final String NS_PREFIX_JOBJ = "jobj";
    public static final String NS_URI_JOBJ = "urn:trl-soap:JavaObject";
    public static final String ENC_STYLE_JOBJ = "urn:trl-soap:SerializedJavaObject";
    private Object lock = new Object();
    private Element objectStore = null;
    private Object cache = null;

    public ObjectStore(Document document, Object object) throws IOException {
        this.storeObject(document, object);
    }

    public ObjectStore(Element element) throws NoSuchElementException {
        this.objectStore = element;
        this.checkObjectStore(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeObject(Document document, Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        Element element = document.createElementNS(NS_URI_JOBJ, "jobj:JavaObject");
        element.setAttribute("xmlns:jobj", NS_URI_JOBJ);
        element.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "SOAP-ENV:encodingStyle", ENC_STYLE_JOBJ);
        element.appendChild(document.createTextNode(Base64.encode((byte[])byteArrayOutputStream.toByteArray())));
        Object object2 = this.lock;
        synchronized (object2) {
            this.objectStore = element;
            this.cache = object;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object loadObject() throws ClassNotFoundException {
        if (this.cache != null) {
            return this.cache;
        }
        Object object = this.lock;
        synchronized (object) {
            ObjectInputStream objectInputStream = null;
            try {
                try {
                    objectInputStream = new ObjectInputStream(new ByteArrayInputStream(Base64.decode((String)DOMHandler.getNodeValue(this.objectStore))));
                    Object object2 = objectInputStream.readObject();
                    if (object2 instanceof Throwable) {
                        ((Throwable)object2).fillInStackTrace();
                    }
                    Object object3 = this.cache = object2;
                    Object var6_6 = null;
                    if (objectInputStream == null) return object3;
                    try {
                        objectInputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return object3;
                }
                catch (IOException iOException) {
                    throw new UnknownError(iOException.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (objectInputStream == null) throw throwable;
                try {}
                catch (IOException iOException) {
                    throw throwable;
                }
                objectInputStream.close();
                throw throwable;
            }
        }
    }

    private void checkObjectStore(Element element) throws NoSuchElementException {
        if (element == null) {
            throw new NoSuchElementException("ObjectStore is null");
        }
        if (!NS_URI_JOBJ.equals(element.getNamespaceURI()) || !ELEM_JOBJ.equals(element.getLocalName())) {
            throw new NoSuchElementException("Unexpected element: " + DOMConverter.toString(element));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getElement() {
        Element element = this.objectStore;
        synchronized (element) {
            return this.objectStore;
        }
    }
}

