/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trl.soapimpl;

import com.ibm.trl.soap.SOAPException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Stack;

public final class EnvelopeWriter
extends PrintWriter {
    private static final int E_ENVELOPE = 0;
    private static final int E_HEADER = 1;
    private static final int E_BODY = 2;
    private static final Integer[] INTEGERS = new Integer[]{new Integer(0), new Integer(1), new Integer(2)};
    private static final String[] QNAMES = new String[]{"SOAP-ENV:Envelope", "SOAP-ENV:Header", "SOAP-ENV:Body"};
    private static final String[] NAMESPACES = new String[]{" xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/1999/XMLSchema/\" xmlns:xsi=\"http://www.w3.org/1999/XMLSchema/instance/\"", "", ""};
    private boolean dirty = false;
    private Stack stack = new Stack();

    public EnvelopeWriter(Writer writer) {
        super(writer);
    }

    public EnvelopeWriter(Writer writer, boolean bl) {
        super(writer, bl);
    }

    public EnvelopeWriter(OutputStream outputStream) {
        super(outputStream);
    }

    public EnvelopeWriter(OutputStream outputStream, boolean bl) {
        super(outputStream, bl);
    }

    public void startEnvelope() {
        if (this.dirty) {
            throw new UnknownError("startEnvelope() should be called first");
        }
        this.stack.push(new Integer(0));
    }

    public void startHeader() {
        if (this.dirty) {
            this.dirty = false;
        } else {
            this.delayedStartTag();
        }
        this.stack.push(new Integer(1));
    }

    public void startBody() {
        if (this.dirty) {
            this.dirty = false;
        } else {
            this.delayedStartTag();
        }
        this.stack.push(new Integer(2));
    }

    public void endTag() throws SOAPException {
        if (this.stack.size() == 0) {
            throw new SOAPException("No more unclosed tag");
        }
        int n = -1;
        n = (Integer)this.stack.pop();
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                super.print(this.dirty ? "</" + QNAMES[n] + '>' : '<' + QNAMES[n] + NAMESPACES[n] + "/>");
                break;
            }
            default: {
                throw new SOAPException("Unexpected type: " + n);
            }
        }
    }

    private void delayedStartTag() {
        int n = -1;
        n = (Integer)this.stack.peek();
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                String string = "<" + QNAMES[n] + NAMESPACES[n] + '>';
                super.write(string, 0, string.length());
                break;
            }
            default: {
                throw new UnknownError("Unexpected type: " + n);
            }
        }
    }

    public void write(int n) {
        if (!this.dirty) {
            this.delayedStartTag();
            this.dirty = true;
        }
        super.write(n);
    }

    public void write(char[] cArray, int n, int n2) {
        if (!this.dirty) {
            this.delayedStartTag();
            this.dirty = true;
        }
        super.write(cArray, n, n2);
    }

    public void write(String string, int n, int n2) {
        if (!this.dirty) {
            this.delayedStartTag();
            this.dirty = true;
        }
        super.write(string, n, n2);
    }
}

