/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.RARFile;
import com.ibm.websphere.management.application.AppDeploymentUtil;
import com.ibm.websphere.management.application.EarUtils;
import com.ibm.websphere.management.application.EditScheduler;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.client.BindJndiForEJBMessageBindingHelper;
import com.ibm.ws.management.configarchive.EnhancedEarConfigurator;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.ecore.resource.Resource;

public class ValidateAppTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register((Class)ValidateAppTask.class, null, (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    private static int[][] versionTable = new int[][]{{12, 5}, {13, 5}, {14, 6}};

    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"performTask");
        }
        try {
            EARFile eARFile = this.scheduler instanceof InstallScheduler ? ((InstallScheduler)this.scheduler).getEarFile(false, true) : ((EditScheduler)this.scheduler).getEarFile();
            int n = EarUtils.getAppVersionForDeployment(eARFile);
            List list = ValidateAppTask.getSelectedOptions(eARFile, this.scheduler.getProperties(), this.scheduler.getWorkSpace());
            int n2 = ValidateAppTask.getAppVersion(eARFile, list);
            int n3 = ValidateAppTask.getHighestRarVersion(eARFile);
            Hashtable hashtable = (Hashtable)this.scheduler.getProperties().get("moduleToServer");
            Hashtable hashtable2 = AppDeploymentUtil.getNodeVersionForAppTargets(hashtable, this.scheduler.getCellContext(), this.scheduler.getWorkSpace());
            Vector vector = AppDeploymentUtil.appValidation(n3, n, n2, list, hashtable2);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Messages from AppValidationTask: " + vector));
            }
            AppUtils.dbg(tc, "App validation: " + vector.size());
            AppDeploymentInfo appDeploymentInfo = AppInstallHelper.getAppDeploymentInfo(eARFile);
            BindJndiForEJBMessageBindingHelper bindJndiForEJBMessageBindingHelper = new BindJndiForEJBMessageBindingHelper();
            AppDeploymentTask appDeploymentTask = bindJndiForEJBMessageBindingHelper.createTask(null, "BindJndiForEJBMessageBinding");
            bindJndiForEJBMessageBindingHelper.prepareTask(appDeploymentInfo, appDeploymentTask);
            Vector vector2 = AppDeploymentUtil.MDBValidation(hashtable2, hashtable, appDeploymentTask);
            Tr.debug((TraceComponent)tc, (String)("Messages from MDBValidation: " + vector2));
            vector.addAll(vector2);
            if (vector.size() != 0) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < vector.size(); ++i) {
                    stringBuffer.append("\n" + (String)vector.elementAt(i));
                }
                throw new AdminException(AppUtils.getMessage(this.getResourceBundle(), "ADMA5055E", new String[]{this.scheduler.getAppName(), stringBuffer.toString()}));
            }
            this.scheduler.propagateTaskEvent(this.createNotification("Completed", "ADMA5058I", new Object[0]));
            return true;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.task.ValidateAppTask.performTask", (String)"82", (Object)this);
            if (throwable instanceof AdminException) {
                this.scheduler.propagateTaskEvent(this.createTranslatedNotification("Failed", throwable.getMessage(), null));
                throw (AdminException)((Object)throwable);
            }
            String string = AppUtils.getMessage(this.getResourceBundle(), "ADMA5057E", new String[]{throwable.toString()});
            this.scheduler.propagateTaskEvent(this.createTranslatedNotification("Failed", string, null));
            throw new AdminException(throwable, string);
        }
    }

    private static List getSelectedOptions(EARFile eARFile, Hashtable hashtable, WorkSpace workSpace) throws Exception {
        Resource resource;
        List list;
        EnhancedEarConfigurator enhancedEarConfigurator;
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSelectedOptions");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl2 = hashtable.get("deployejb") != null && hashtable.get("deployejb").equals(Boolean.TRUE);
        boolean bl3 = hashtable.get("preCompileJSPs") != null && hashtable.get("preCompileJSPs").equals(Boolean.TRUE);
        boolean bl4 = hashtable.get("enhancedEarDisableValidation") != null;
        Tr.debug((TraceComponent)tc, (String)("enhancedEarDisable " + bl4));
        boolean bl5 = hashtable.get("deployws") != null && hashtable.get("deployws").equals(Boolean.TRUE);
        boolean bl6 = bl = hashtable.get("useMetaDataFromBinary") != null && hashtable.get("useMetaDataFromBinary").equals(Boolean.TRUE);
        if (bl2) {
            arrayList.add("deployejb");
        }
        if (bl3) {
            arrayList.add("preCompileJSPs");
        }
        if (!bl4 && (enhancedEarConfigurator = new EnhancedEarConfigurator(workSpace, eARFile, true, "default", "appName", "appName.ear_")).isEnhancedEar() && (list = enhancedEarConfigurator.getDeploymentResources()).size() == 1 && !(resource = (Resource)list.get(0)).getURI().toString().endsWith("deployment.xml")) {
            arrayList.add("enhancedEar");
        }
        if (bl5) {
            arrayList.add("deployws");
        }
        if (bl) {
            arrayList.add("useMetaDataFromBinary");
        }
        Tr.debug((TraceComponent)tc, (String)("selected Options: " + arrayList));
        return arrayList;
    }

    private static int getAppVersion(EARFile eARFile, List list) throws Exception {
        int n;
        if (list.size() > 0) {
            for (n = 0; n < list.size(); ++n) {
                String string = (String)list.get(n);
                Tr.debug((TraceComponent)tc, (String)("deplOption: " + string));
                if (!string.equals("deployejb") && !string.equals("preCompileJSPs") && !string.equals("enhancedEar") && !string.equals("deployws") && !string.equals("useMetaDataFromBinary")) continue;
                return versionTable[versionTable.length - 1][0];
            }
        }
        n = EarUtils.getAppVersionForDeployment(eARFile);
        Tr.debug((TraceComponent)tc, (String)("AppVersion: " + n));
        return n;
    }

    private static int getHighestRarVersion(EARFile eARFile) throws Exception {
        int n = 99;
        int n2 = 15;
        List list = eARFile.getRARFiles();
        if (list.size() > 0) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                RARFile rARFile = (RARFile)iterator.next();
                n = rARFile.getDeploymentDescriptor().getVersionID();
                if (n < n2) continue;
                n = n2;
            }
        }
        Tr.debug((TraceComponent)tc, (String)("the highest rar version " + n));
        return n;
    }
}

