/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.DistributionStatusSchedulerImpl;
import com.ibm.ws.management.application.J2CAppUtils;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ObjectName;

public class DistributionStatusTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register((Class)DistributionStatusTask.class, (String)"Admin", (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String OPNAME = "_getAppDistributionStatus";

    public DistributionStatusTask() {
        this.appTaskName = "AppDistribution";
    }

    public boolean performTask() throws AdminException {
        Hashtable hashtable = J2CAppUtils.getAppDocuments(this.scheduler.getAppName());
        if (hashtable == null || hashtable.size() == 0) {
            throw new AdminException("Error getting application documents from master repository.  The application may not be in the repository.");
        }
        List list = ((DistributionStatusSchedulerImpl)this.scheduler).get_nodes();
        for (int i = 0; i < list.size(); ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Inside the performTask for node : " + list.get(i)));
            }
            String string = this.handleNode((String)list.get(i), hashtable);
            String string2 = ((DistributionStatusSchedulerImpl)this.scheduler).addCompStatus(string);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Status : " + string + " cs = " + string2));
            }
            Properties properties = new Properties();
            properties.put("AppDistributionNode", string);
            properties.put("AppDistributionAll", string2);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(" nprops : " + properties + " CS = " + string2));
            }
            AppNotification appNotification = this.createTranslatedNotification("InProgress", string, null);
            appNotification.setProperties(properties);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(" PROPOGATING TASK .." + appNotification.toString()));
            }
            this.scheduler.propagateTaskEvent(appNotification);
        }
        return true;
    }

    private String handleNode(String string, Hashtable hashtable) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("handleNode: " + string + ", app = " + this.scheduler.getAppName()));
        }
        String string2 = null;
        try {
            string2 = this.scheduler.getCellContext().getName();
            ObjectName objectName = new ObjectName("WebSphere:type=AdminOperations,node=" + string + ",process=" + (AdminServiceFactory.getAdminService().getNodeName().equals(string) ? AdminServiceFactory.getAdminService().getProcessName() : "nodeagent") + ",*");
            Set set = AdminServiceFactory.getAdminService().queryNames(objectName, null);
            if (set == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"handleNode: set is null");
                }
                return this.getStr(string2, string, "unknown");
            }
            Iterator iterator = set.iterator();
            if (!iterator.hasNext()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"No MBean on the node");
                }
                return this.getStr(string2, string, "unknown");
            }
            objectName = (ObjectName)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("on = " + objectName));
            }
            if (!this.checkForOp(objectName)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("Back level MBean on " + string));
                }
                return this.getStr(string2, string, "unknown");
            }
            Hashtable hashtable2 = (Hashtable)AdminServiceFactory.getAdminService().invoke(objectName, OPNAME, new Object[]{this.scheduler.getAppName(), new Hashtable()}, new String[]{String.class.getName(), Hashtable.class.getName()});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("tbl = " + hashtable2));
            }
            if (hashtable2 == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("Table returned from node is null " + string));
                }
                return this.getStr(string2, string, "unknown");
            }
            if (Boolean.TRUE.equals(hashtable2.get(this.scheduler.getAppName()))) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("Marker still exists " + string));
                }
                return this.getStr(string2, string, "false");
            }
            Hashtable hashtable3 = (Hashtable)hashtable2.get("uri");
            if (hashtable3 == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("URI Table returned from node is null " + string));
                }
                return this.getStr(string2, string, "unknown");
            }
            if (hashtable.size() != hashtable3.size()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("URI Tables of different size for " + string + ", " + hashtable.size() + ", " + hashtable3.size()));
                }
                return this.getStr(string2, string, "false");
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                DocumentDigest documentDigest;
                String string3 = (String)enumeration.nextElement();
                if (!hashtable3.containsKey(string3)) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)("URI " + string3 + "does not exist on " + string));
                    }
                    return this.getStr(string2, string, "false");
                }
                DocumentDigest documentDigest2 = (DocumentDigest)hashtable.get(string3);
                if (((Object)documentDigest2).equals(documentDigest = (DocumentDigest)hashtable3.get(string3))) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("Digest diff for " + string3));
                }
                return this.getStr(string2, string, "false");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("All fine for " + string));
            }
            return this.getStr(string2, string, "true");
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.DistributionStatusScheduler.handleNode", (String)"178", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("Exception thrown in handleNode: " + throwable));
            }
            return this.getStr(string2, string, "unknown");
        }
    }

    private String getStr(String string, String string2, String string3) {
        return "WebSphere:cell=" + string + ",node=" + string2 + ",distribution=" + string3;
    }

    private boolean checkForOp(ObjectName objectName) throws Exception {
        MBeanInfo mBeanInfo = AdminServiceFactory.getAdminService().getMBeanInfo(objectName);
        MBeanOperationInfo[] mBeanOperationInfoArray = mBeanInfo.getOperations();
        for (int i = 0; i < mBeanOperationInfoArray.length; ++i) {
            if (!OPNAME.equals(mBeanOperationInfoArray[i].getName())) continue;
            return true;
        }
        return false;
    }
}

