/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.EditScheduler;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.UpdateScheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.DeltaFile;
import com.ibm.ws.management.application.UpdateSchedulerImpl;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DeltaDataTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register((Class)DeltaDataTask.class, null, (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    private DeltaFile _deltaFile;
    private RepositoryContext _appC;
    public static final String DelFiles = "DeltaDataTask.DelFiles";
    public static final String AddFiles = "DeltaDataTask.AddFiles";
    public static final String UpdateFiles = "DeltaDataTask.UpdateFiles";

    public boolean performTask() throws AdminException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"performTask");
        }
        try {
            Object object;
            this._appC = AppUtils.findAppContextFromConfig(this.scheduler.getAppName(), this.scheduler.getWorkSpace(), this.scheduler.getProperties());
            String string = EditionHelper.getCompositeName(this.scheduler.getAppName(), this.scheduler.getProperties());
            String string2 = "deltas/" + string;
            this._deltaFile = new DeltaFile(this._appC.getParent().getPath() + "/" + string2);
            Element element = this._deltaFile.createElement("change_input");
            this._deltaFile.appendChild(element);
            if (this.scheduler instanceof InstallScheduler) {
                element.setAttribute("contenttype", "app");
                object = this._appC.getParent().getName();
                if (EditionHelper.isEditionSupportEnabled()) {
                    object = EditionHelper.getAppEarName(this.scheduler.getAppName(), this.scheduler.getProperties());
                }
                element.setAttribute("contenturi", this._appC.getParent().getName());
                element.setAttribute("changetype", "install");
            } else if (this.scheduler instanceof EditScheduler) {
                element.setAttribute("contenttype", "app");
                object = this._appC.getParent().getName();
                if (EditionHelper.isEditionSupportEnabled()) {
                    object = EditionHelper.getAppEarName(this.scheduler.getAppName(), this.scheduler.getProperties());
                }
                element.setAttribute("contenturi", this._appC.getParent().getName());
                element.setAttribute("changetype", "edit");
                String string3 = ((EditScheduler)this.scheduler).getEarFile().getURI();
                if (string3.replace('\\', '/').endsWith("deployments/" + this.scheduler.getAppName())) {
                    element.setAttribute("useMetaDataFromBinary", "false");
                } else {
                    element.setAttribute("useMetaDataFromBinary", "true");
                }
            } else if (this.scheduler instanceof UpdateScheduler) {
                this.handleFGUpdate(element);
            }
            this._deltaFile.writeToDisk();
            this._appC.getParent().notifyChanged(0, string2 + "/" + this._deltaFile.getFileName());
            object = this.createNotification("Completed", "ADMA5005I", new String[]{this.scheduler.getAppName()});
            this.scheduler.propagateTaskEvent((AppNotification)object);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"performTask");
            }
            bl = true;
            Object var7_8 = null;
            this.scheduler.getProperties().remove(DelFiles);
        }
        catch (Throwable throwable) {
            try {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.task.DeltaDataTask.performTask", (String)"124", (Object)this);
                this.scheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5006E", new String[]{this.scheduler.getAppName(), throwable.toString()}));
                if (throwable instanceof AdminException) {
                    throw (AdminException)((Object)throwable);
                }
                throw new AdminException(throwable, AppUtils.getMessage(this.getResourceBundle(), "ADMA0066E"));
            }
            catch (Throwable throwable2) {
                Object var7_9 = null;
                this.scheduler.getProperties().remove(DelFiles);
                this.scheduler.getProperties().remove(AddFiles);
                throw throwable2;
            }
        }
        this.scheduler.getProperties().remove(AddFiles);
        return bl;
    }

    private void handleFGUpdate(Element element) throws Exception {
        Object object;
        int n;
        Object object2;
        String string;
        UpdateScheduler updateScheduler = (UpdateScheduler)this.scheduler;
        String string2 = null;
        element.setAttribute("changetype", "fg-update");
        element.setAttribute("contenttype", updateScheduler.getContentType());
        if (!AppUtils.isEmpty(updateScheduler.getOperation())) {
            element.setAttribute("operation", updateScheduler.getOperation());
        }
        if (!AppUtils.isEmpty(updateScheduler.getContentURI())) {
            element.setAttribute("contenturi", updateScheduler.getContentURI());
        }
        if ("modulefile".equals(updateScheduler.getContentType()) && "delete".equals(updateScheduler.getOperation())) {
            element.setAttribute("moduletype", (String)this.scheduler.getProperties().get("moduletype"));
        }
        if ((string = (String)this.scheduler.getProperties().get("update.recycle")) != null) {
            if (string.equals("update.recycle.modules") && this.scheduler.getProperties().get("update.recycle.modules") == null) {
                object2 = this.createNotification("InProgress", "ADMA5063W", new String[]{"update.recycle.modules"});
                this.scheduler.propagateTaskEvent((AppNotification)object2);
            } else {
                element.setAttribute("update.recycle", string);
                if (this.scheduler.getProperties().get("update.recycle.modules") != null) {
                    element.setAttribute("update.recycle.modules", (String)this.scheduler.getProperties().get("update.recycle.modules"));
                }
            }
        }
        object2 = this._deltaFile.createElement("files");
        this._deltaFile.appendChild((Element)object2);
        List list = (List)this.scheduler.getProperties().get(DelFiles);
        List list2 = (List)this.scheduler.getProperties().get(AddFiles);
        List list3 = (List)this.scheduler.getProperties().get(UpdateFiles);
        List list4 = ((UpdateSchedulerImpl)updateScheduler).getDeltaContents();
        for (n = 0; n < list4.size(); n += 2) {
            string2 = (String)list4.get(n);
            object = (String)list4.get(n + 1);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("delta contents: " + string2 + ", " + (String)object));
            }
            if ("add".equals(object)) {
                list2.add(string2);
                continue;
            }
            if ("delete".equals(object)) {
                list.add(string2);
                continue;
            }
            if ("update".equals(object)) {
                list3.add(string2);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("Unexpected behavior: " + string2 + ", " + (String)object));
        }
        for (n = 0; n < list.size(); ++n) {
            string2 = (String)list.get(n);
            object = this._deltaFile.createElement("file");
            object.setAttribute("uri", string2);
            object.setAttribute("operation", "delete");
            object2.appendChild((Node)object);
        }
        for (n = 0; n < list2.size(); ++n) {
            string2 = (String)list2.get(n);
            object = this._deltaFile.createElement("file");
            object.setAttribute("uri", string2);
            object.setAttribute("operation", "add");
            object2.appendChild((Node)object);
        }
        for (n = 0; n < list3.size(); ++n) {
            string2 = (String)list3.get(n);
            object = this._deltaFile.createElement("file");
            object.setAttribute("uri", string2);
            object.setAttribute("operation", "update");
            object2.appendChild((Node)object);
        }
    }
}

