/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.ModuleFile;
import com.ibm.etools.j2ee.commonarchivecore.ModuleRef;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appcfg.ModuleConfig;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.ClusteredTarget;
import com.ibm.websphere.models.config.appdeployment.ConnectorModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.appdeployment.DeploymentTarget;
import com.ibm.websphere.models.config.appdeployment.DeploymentTargetMapping;
import com.ibm.websphere.models.config.appdeployment.EJBModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.ServerTarget;
import com.ibm.websphere.models.config.appdeployment.WebModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.impl.AppdeploymentPackageImpl;
import com.ibm.websphere.models.config.init.ConfigInit;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class ConfigRepoHelper {
    private static TraceComponent tc = Tr.register((Class)ConfigRepoHelper.class, (String)"Admin", (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    private static Object workSpaceIdLock = new Object();
    private static int workSpaceIdCounter = 0;

    public static boolean containsEList(EList eList, Object object) {
        if (object == null) {
            return false;
        }
        for (int i = 0; i < eList.size(); ++i) {
            if (!eList.get(i).equals(object)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorkSpace getWorkSpace(String string) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Init config and create workspace");
        }
        ConfigInit.init();
        RepositoryMetaDataFactory.initialize();
        AppdeploymentPackageImpl.init();
        String string2 = string;
        if (string2 == null) {
            Object object = workSpaceIdLock;
            synchronized (object) {
                workSpaceIdCounter = (workSpaceIdCounter + 1) % 100;
                string2 = "" + System.currentTimeMillis() + workSpaceIdCounter;
            }
        }
        return WorkSpaceManagerFactory.getManager().getWorkSpace(string2);
    }

    public static void removeWorkSpace(boolean bl, WorkSpace workSpace) throws WorkSpaceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeWorkSpace");
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"sync workspace");
            }
            workSpace.synch(new HashMap());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"remove workspace");
        }
        String string = workSpace.getUserName();
        WorkSpaceManagerFactory.getManager().removeWorkSpace(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeWorkSpace");
        }
    }

    public static boolean checkIfZeroBinCopy(RepositoryContext repositoryContext) {
        return !repositoryContext.getParent().isAvailable(EditionHelper.getAppEarName(repositoryContext.getName(), (String)null));
    }

    public static EARFile getEarFileFromDeployment(WorkSpace workSpace, RepositoryContext repositoryContext) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getEarFileFromWorkSpace");
        }
        if (ConfigRepoHelper.checkIfZeroBinCopy(repositoryContext)) {
            throw new AdminException("The application " + repositoryContext.getName() + " was installed using Zero Binary Copy option. Applications are installed" + " using this option in WSAD unit test environment or using AppManagement MBean API. " + " When an application is installed using this option it is not possible" + " to perform any operation on this application using wsadmin or admin console" + " that involves accessing the application metadata or EAR file.  Such operations" + " include view/edit application information, export, export DDL etc.  The only" + " possible operations using wsadmin or admin console are start, stop and uninstall. " + " If this application is installed using WSAD unit test environment then use WSAD to" + " view/edit application information.");
        }
        repositoryContext.extract(false);
        EARFile eARFile = AppInstallHelper.getEarFile(repositoryContext.getPath(), false, AppUtils.getBundle(null));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getEarFileFromWorkSpace: " + eARFile));
        }
        if (eARFile == null) {
            throw new AdminException("Can not instantiate earfile for: " + repositoryContext.getName());
        }
        return eARFile;
    }

    public static EARFile getEarFileFromBinaries(RepositoryContext repositoryContext, WorkSpace workSpace, ResourceBundle resourceBundle, String string) throws Exception {
        return ConfigRepoHelper.getEarFileFromBinaries(repositoryContext, workSpace, resourceBundle, string, false);
    }

    public static EARFile getEarFileFromBinaries(RepositoryContext repositoryContext, WorkSpace workSpace, ResourceBundle resourceBundle, String string, boolean bl) throws Exception {
        EARFile eARFile;
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("getEarFileFromBinaries: " + repositoryContext));
            }
            if (ConfigRepoHelper.checkIfZeroBinCopy(repositoryContext)) {
                throw new AdminException("The application " + repositoryContext.getName() + "was installed using zero binary copy option. Therefore it is not possible " + "to perform any operation on this application that involves accessing the " + "application metadata or EAR file.  The only possible operation is uninstall.");
            }
            eARFile = null;
            RepositoryContext repositoryContext2 = repositoryContext.getParent();
            try {
                if (EditionHelper.isEditionSupportEnabled()) {
                    repositoryContext.getParent().extract(repositoryContext.getName() + ".ear", false);
                    eARFile = AppInstallHelper.getEarFile(repositoryContext2.getPath() + File.separator + repositoryContext.getName() + ".ear", false, resourceBundle);
                } else {
                    repositoryContext.getParent().extract(repositoryContext2.getName(), false);
                    eARFile = AppInstallHelper.getEarFile(repositoryContext2.getPath() + File.separator + repositoryContext2.getName(), false, resourceBundle);
                }
            }
            catch (Throwable throwable) {
                AppUtils.dbg(tc, repositoryContext2.getName() + " file not found: " + throwable);
                if (string != null) break block7;
                throw new AdminException(throwable, "Can not instantiate earfile for: " + repositoryContext2.getName());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getEarFileFromBinaries: " + eARFile));
        }
        return eARFile;
    }

    public static Resource getAppDeploymentResource(RepositoryContext repositoryContext) throws Exception {
        URI uRI = URI.createURI((String)"deployment.xml");
        Resource resource = repositoryContext.getResourceSet().createResource(uRI);
        HashMap hashMap = new HashMap();
        resource.load(hashMap);
        return resource;
    }

    public static ApplicationDeployment getAppDeploymentForApp(RepositoryContext repositoryContext) throws Exception {
        return ConfigRepoHelper.getAppDeploymentForApp(ConfigRepoHelper.getAppDeploymentResource(repositoryContext));
    }

    public static ApplicationDeployment getAppDeploymentForApp(Resource resource) throws Exception {
        AppdeploymentPackageImpl.init();
        Deployment deployment = (Deployment)resource.getContents().get(0);
        return (ApplicationDeployment)deployment.getDeployedObject();
    }

    public static Vector getServersForAppDeployment(ApplicationDeployment applicationDeployment, Vector vector, RepositoryContext repositoryContext, WorkSpace workSpace, boolean bl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServersForAppDeployment");
        }
        Vector vector2 = new Vector();
        for (int i = 0; i < applicationDeployment.getModules().size(); ++i) {
            ModuleDeployment moduleDeployment = (ModuleDeployment)applicationDeployment.getModules().get(i);
            Vector vector3 = ConfigRepoHelper.getServersForModuleDeployment(moduleDeployment, vector, repositoryContext, workSpace, bl);
            vector2.addAll(vector3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Server for appDepl: " + vector2));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getServersForAppDeployment");
        }
        return vector2;
    }

    public static Vector getServersForModuleDeployment(ModuleDeployment moduleDeployment, Vector vector, RepositoryContext repositoryContext, WorkSpace workSpace, boolean bl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServersForModuleDeployment");
        }
        Vector<String> vector2 = new Vector<String>();
        EList eList = moduleDeployment.getTargetMappings();
        for (int i = 0; i < eList.size(); ++i) {
            String string;
            DeploymentTarget deploymentTarget = ((DeploymentTargetMapping)eList.get(i)).getTarget();
            if (deploymentTarget == null) continue;
            if (deploymentTarget instanceof ClusteredTarget) {
                string = AppUtils.findContext("clusters", deploymentTarget.getName(), null, repositoryContext, workSpace, true);
                if (string == null) {
                    if (vector != null) {
                        if (vector.contains(deploymentTarget.getName())) continue;
                        vector.addElement(deploymentTarget.getName());
                        continue;
                    }
                    throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5027E", new Object[]{deploymentTarget.getName()}));
                }
                if (!vector2.contains(string)) {
                    vector2.addElement(string);
                }
            }
            if (!(deploymentTarget instanceof ServerTarget)) continue;
            string = ((ServerTarget)deploymentTarget).getNodeName();
            RepositoryContext repositoryContext2 = AppUtils.findContext("servers", deploymentTarget.getName(), string, repositoryContext, workSpace, false);
            if (repositoryContext2 == null) {
                if (vector != null) {
                    if (vector.contains(deploymentTarget.getName())) continue;
                    vector.addElement(deploymentTarget.getName());
                    continue;
                }
                throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5028E", new Object[]{deploymentTarget.getName(), string}));
            }
            if (!bl && AppUtils.getClusterFromMember(AppUtils.findContext("servers", deploymentTarget.getName(), string, repositoryContext, workSpace, false), workSpace) != null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Ignoring  cluster member: " + deploymentTarget.getName()));
                continue;
            }
            if (vector2.contains(repositoryContext2)) continue;
            vector2.addElement((String)repositoryContext2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Server for depl: " + vector2));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getServersForModuleDeployment");
        }
        return vector2;
    }

    public static Hashtable getNodeServerRelation(WorkSpace workSpace, Vector vector) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getNodeServerRelation");
        }
        Hashtable hashtable = new Hashtable();
        Vector vector2 = ConfigRepoHelper.getAllServers(workSpace, vector);
        for (int i = 0; i < vector2.size(); ++i) {
            RepositoryContext repositoryContext = (RepositoryContext)vector2.elementAt(i);
            Vector<RepositoryContext> vector3 = (Vector<RepositoryContext>)hashtable.get(repositoryContext.getParent());
            if (vector3 == null) {
                vector3 = new Vector<RepositoryContext>();
                hashtable.put(repositoryContext.getParent(), vector3);
            }
            if (vector3.contains(repositoryContext)) continue;
            vector3.addElement(repositoryContext);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Node-server relation: " + hashtable));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getNodeServerRelation");
        }
        return hashtable;
    }

    public static Vector getAllServers(WorkSpace workSpace, Vector vector) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("orig svrs: " + vector));
        }
        if (vector.size() == 0) {
            return vector;
        }
        Vector<RepositoryContext> vector2 = new Vector<RepositoryContext>();
        for (int i = 0; i < vector.size(); ++i) {
            RepositoryContext repositoryContext = (RepositoryContext)vector.elementAt(i);
            if (AppUtils.isServer(repositoryContext) && !vector2.contains(repositoryContext)) {
                vector2.addElement(repositoryContext);
            }
            if (!AppUtils.isCluster(repositoryContext)) continue;
            URI uRI = URI.createURI((String)"cluster.xml");
            Resource resource = repositoryContext.getResourceSet().createResource(uRI);
            HashMap hashMap = new HashMap();
            resource.load(hashMap);
            ServerCluster serverCluster = (ServerCluster)resource.getContents().get(0);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Cluster obj: " + serverCluster));
            }
            EList eList = serverCluster.getMembers();
            for (int j = 0; j < eList.size(); ++j) {
                ClusterMember clusterMember = (ClusterMember)eList.get(j);
                RepositoryContext repositoryContext2 = AppUtils.findContext("servers", clusterMember.getMemberName(), clusterMember.getNodeName(), repositoryContext.getParent(), workSpace, false);
                if (repositoryContext2 == null) {
                    throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5029E", new Object[]{clusterMember.getMemberName(), repositoryContext.getName()}));
                }
                if (vector2.contains(repositoryContext2)) continue;
                vector2.addElement(repositoryContext2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("ret svrs: " + vector2));
        }
        return vector2;
    }

    public static String getSIEntryText(RepositoryContext repositoryContext) {
        return repositoryContext.getParent().getName() + "/" + "deployments" + "/" + repositoryContext.getName();
    }

    public static RepositoryContext getAppContextFromSIEntry(String string, RepositoryContext repositoryContext, WorkSpace workSpace) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getAppContextFromSIEntry:" + string));
        }
        int n = string.indexOf("/");
        int n2 = string.lastIndexOf("/");
        if (n == -1 || n2 == -1 || n == n2) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getAppContextFromSIEntry: Malformed si entry");
            }
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n2 + 1, string.length());
        RepositoryContext repositoryContext2 = AppUtils.findContext("deployments", string3, string2, repositoryContext, workSpace, false);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getAppContextFromSIEntry:" + repositoryContext2));
        }
        return repositoryContext2;
    }

    public static Hashtable updateServerIndexDocs(RepositoryContext repositoryContext, WorkSpace workSpace, Vector vector, boolean bl, ResourceBundle resourceBundle) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("updateServerIndexDocs: " + vector));
        }
        Hashtable hashtable = ConfigRepoHelper.getNodeServerRelation(workSpace, vector);
        AppUtils.dbg(tc, AppUtils.getMessage(resourceBundle, "ADMA6018I", new Object[]{hashtable}));
        Hashtable hashtable2 = ConfigRepoHelper.getServerIndexDocs(workSpace, hashtable.keys());
        if (hashtable2 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Server index docs not found!!");
            }
            return new Hashtable();
        }
        Enumeration enumeration = hashtable.keys();
        Hashtable hashtable3 = new Hashtable();
        String string = ConfigRepoHelper.getSIEntryText(repositoryContext);
        String string2 = "";
        try {
            while (enumeration.hasMoreElements()) {
                RepositoryContext repositoryContext2 = (RepositoryContext)enumeration.nextElement();
                Vector vector2 = (Vector)hashtable.get(repositoryContext2);
                Vector<String> vector3 = new Vector<String>();
                for (int i = 0; i < vector2.size(); ++i) {
                    vector3.addElement(((RepositoryContext)vector2.elementAt(i)).getName());
                }
                Resource resource = (Resource)hashtable2.get(repositoryContext2);
                if (resource.getContents().size() == 0) {
                    throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5070E", new Object[]{repositoryContext2.getName()}));
                }
                ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
                ArrayList<String> arrayList = new ArrayList<String>();
                hashtable3.put(repositoryContext2.getName(), arrayList);
                string2 = repositoryContext2.getName();
                EList eList = serverIndex.getServerEntries();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("servers for " + repositoryContext2.getName() + " are " + vector3));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("serversEntries for " + repositoryContext2.getName() + " are " + eList));
                }
                for (int i = 0; i < eList.size(); ++i) {
                    ServerEntry serverEntry = (ServerEntry)eList.get(i);
                    if (!vector3.contains(serverEntry.getServerName())) continue;
                    if (bl) {
                        EList eList2 = serverEntry.getDeployedApplications();
                        if (!eList2.contains((Object)string)) {
                            eList2.add((Object)string);
                            AppUtils.dbg(tc, AppUtils.getMessage(resourceBundle, "ADMA6020I", new Object[]{repositoryContext, serverEntry.getServerName(), repositoryContext2.getName()}));
                        }
                    } else {
                        boolean bl2 = serverEntry.getDeployedApplications().remove((Object)string);
                        AppUtils.dbg(tc, AppUtils.getMessage(resourceBundle, "ADMA6021I", new Object[]{string, serverEntry.getServerName(), repositoryContext2.getName(), "" + bl2}));
                    }
                    arrayList.add(serverEntry.getServerName());
                }
                HashMap hashMap = new HashMap();
                resource.save(hashMap);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("updateServerIndexDocs: " + hashtable3));
            }
            return hashtable3;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.task.ConfigRepoHelper.updateServerIndexDocs", (String)"124");
            if (throwable instanceof AdminException) {
                throw (AdminException)((Object)throwable);
            }
            throw new AdminException(throwable, "Server Index update failed at  the last node of " + string2);
        }
    }

    public static String getNodeStrFromNodeSvrTable(Hashtable hashtable, String string) {
        if (hashtable == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = bl ? "" : "+";
            stringBuffer.append(string2 + "WebSphere:cell=" + string + ",node=" + enumeration.nextElement());
            bl = false;
        }
        return stringBuffer.toString();
    }

    public static Hashtable getServerIndexDocs(WorkSpace workSpace, Enumeration enumeration) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServerIndexDocs");
        }
        Hashtable<RepositoryContext, Resource> hashtable = new Hashtable<RepositoryContext, Resource>();
        while (enumeration.hasMoreElements()) {
            RepositoryContext repositoryContext = (RepositoryContext)enumeration.nextElement();
            URI uRI = URI.createURI((String)"serverindex.xml");
            Resource resource = repositoryContext.getResourceSet().createResource(uRI);
            HashMap hashMap = new HashMap();
            resource.load(hashMap);
            if (resource == null) {
                throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5031E", new Object[]{"serverindex.xml", repositoryContext}));
            }
            hashtable.put(repositoryContext, resource);
        }
        Tr.debug((TraceComponent)tc, (String)("retVal: " + hashtable));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getServerIndexDocs");
        }
        return hashtable;
    }

    public static String getDDUri(ModuleRef moduleRef) throws Exception {
        if (moduleRef.getAltDeploymentDescriptor() != null) {
            return moduleRef.getDeploymentDescriptor().eResource().getURI().toString();
        }
        if (moduleRef.isEJB()) {
            return "META-INF/ejb-jar.xml";
        }
        if (moduleRef.isWeb()) {
            return "WEB-INF/web.xml";
        }
        if (moduleRef.isConnector()) {
            return "META-INF/ra.xml";
        }
        return moduleRef.getDeploymentDescriptor().eResource().getURI().toString();
    }

    public static String getDDUri(ModuleDeployment moduleDeployment) throws Exception {
        if (moduleDeployment.getAltDD() != null) {
            return moduleDeployment.getAltDD();
        }
        if (moduleDeployment instanceof EJBModuleDeployment) {
            return "META-INF/ejb-jar.xml";
        }
        if (moduleDeployment instanceof WebModuleDeployment) {
            return "WEB-INF/web.xml";
        }
        if (moduleDeployment instanceof ConnectorModuleDeployment) {
            return "META-INF/ra.xml";
        }
        return null;
    }

    public static Hashtable getCNP(String string, ApplicationDeployment applicationDeployment, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCNP");
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        boolean bl = false;
        EList eList = applicationDeployment.getModules();
        for (int i = 0; i < eList.size(); ++i) {
            ModuleDeployment moduleDeployment = (ModuleDeployment)eList.get(i);
            String string3 = ConfigRepoHelper.getDDUri(moduleDeployment);
            if (string3 == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Unknown module deployment: " + moduleDeployment));
                continue;
            }
            String string4 = util.createUniqueModuleName(string3, moduleDeployment.getUri());
            if (!AppUtils.isEmpty(string)) {
                if (!string.equals(string4)) continue;
                hashtable.put(string4, ConfigRepoHelper.getCNP(moduleDeployment, string2));
                return hashtable;
            }
            hashtable.put(string4, ConfigRepoHelper.getCNP(moduleDeployment, string2));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getCNP: " + hashtable));
        }
        return hashtable;
    }

    public static String getCNP(ModuleDeployment moduleDeployment, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getCNP: " + moduleDeployment));
        }
        String string2 = "";
        EList eList = moduleDeployment.getTargetMappings();
        for (int i = 0; i < eList.size(); ++i) {
            DeploymentTargetMapping deploymentTargetMapping = (DeploymentTargetMapping)eList.get(i);
            DeploymentTarget deploymentTarget = deploymentTargetMapping.getTarget();
            String string3 = "";
            if (deploymentTarget instanceof ClusteredTarget) {
                string3 = "WebSphere:cell=" + string + ",cluster=" + deploymentTarget.getName();
            } else {
                if (!(deploymentTargetMapping.getTarget() instanceof ServerTarget)) continue;
                string3 = "WebSphere:cell=" + string + ",node=" + ((ServerTarget)deploymentTarget).getNodeName() + ",server=" + deploymentTarget.getName();
            }
            if (deploymentTargetMapping.getConfig() != null) {
                string3 = string3 + ",config=" + ((ModuleConfig)deploymentTargetMapping.getConfig()).getName();
            }
            string2 = AppUtils.isEmpty(string2) ? string3 : string2 + "+" + string3;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getCNP: " + string2));
        }
        return string2;
    }

    public static String getTargetString(RepositoryContext repositoryContext, String string) {
        String string2 = null;
        string2 = AppUtils.isCluster(repositoryContext) ? "WebSphere:cell=" + repositoryContext.getParent().getName() + ",cluster=" + repositoryContext.getName() : "WebSphere:cell=" + repositoryContext.getParent().getParent().getName() + ",node=" + repositoryContext.getParent().getName() + ",server=" + repositoryContext.getName();
        if (AppUtils.isEmpty(string)) {
            return string2;
        }
        return string + "+" + string2;
    }

    public static String getTargetString(ObjectName objectName, String string) {
        String string2 = "WebSphere:cell=" + objectName.getKeyProperty("cell") + ",node=" + objectName.getKeyProperty("node") + ",server=" + objectName.getKeyProperty("process");
        if (AppUtils.isEmpty(string)) {
            return string2;
        }
        return string + "+" + string2;
    }

    public static Vector getServerNames(String string, String string2, RepositoryContext repositoryContext, WorkSpace workSpace) throws Exception {
        return ConfigRepoHelper.getServerNames(string, string2, true, repositoryContext, workSpace);
    }

    public static Vector getServerNames(String string, String string2, boolean bl, RepositoryContext repositoryContext, WorkSpace workSpace) throws Exception {
        RepositoryContext repositoryContext2;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServerNames");
        }
        Vector<Object> vector = new Vector<Object>();
        if (string == null) {
            if (tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getServerNames: null");
            }
            return vector;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "+");
        Object[] objectArray = AppUtils.getContextArray("servers", repositoryContext, workSpace);
        while (stringTokenizer.hasMoreTokens()) {
            String string3;
            String string4 = stringTokenizer.nextToken().trim();
            if (AppUtils.isEmpty(string4)) continue;
            object = null;
            try {
                object = new ObjectName(string4);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Bad token: " + string4));
                }
                throw new AdminException(malformedObjectNameException, AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5025E", new Object[]{string4}));
            }
            repositoryContext2 = null;
            String string5 = ((ObjectName)object).getKeyProperty("cluster");
            if (!AppUtils.isEmpty(string5)) {
                repositoryContext2 = AppUtils.findContext("clusters", string5 = string5.trim(), null, repositoryContext, workSpace, true);
                if (repositoryContext2 == null) {
                    throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5022E", new Object[]{string5, string2}));
                }
            } else {
                string3 = ((ObjectName)object).getKeyProperty("server");
                if (AppUtils.isEmpty(string3)) {
                    string3 = ((ObjectName)object).getKeyProperty("process");
                }
                String string6 = ((ObjectName)object).getKeyProperty("node");
                if (AppUtils.isEmpty(string3)) {
                    throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5026E", new Object[]{string4, string2}));
                }
                string3 = string3.trim();
                repositoryContext2 = AppUtils.getContextFromArray(objectArray, string3, string6, false);
            }
            if (repositoryContext2 == null) {
                throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5026E", new Object[]{string4, string2}));
            }
            string3 = ((ObjectName)object).getKeyProperty("config");
            if (string3 == null) {
                string3 = "";
            }
            if (!vector.contains(repositoryContext2)) {
                vector.addElement(repositoryContext2);
                if (!bl) continue;
                vector.addElement(string3);
                continue;
            }
            Tr.warning((TraceComponent)tc, (String)AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5032W", new Object[]{repositoryContext2.getName(), string, string4}));
        }
        for (int i = 0; i < vector.size(); i += 2) {
            object = (RepositoryContext)vector.elementAt(i);
            if (AppUtils.isCluster((RepositoryContext)object) || (repositoryContext2 = AppUtils.getClusterFromMember((RepositoryContext)object, workSpace)) == null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Target has member: " + object + " which belongs to " + repositoryContext2));
            }
            if (vector.contains(repositoryContext2)) continue;
            throw new AdminException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA5033E", new Object[]{object.getName(), repositoryContext2.getName(), string2}));
        }
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getServerNames: " + vector));
        }
        return vector;
    }

    public static String getModuleType(Object object) {
        if (object instanceof ModuleRef) {
            ModuleRef moduleRef = (ModuleRef)object;
            if (moduleRef.isEJB()) {
                return "moduletype.ejb";
            }
            if (moduleRef.isWeb()) {
                return "moduletype.web";
            }
            if (moduleRef.isConnector()) {
                return "moduletype.connector";
            }
        } else if (object instanceof ModuleFile) {
            ModuleFile moduleFile = (ModuleFile)object;
            if (moduleFile.isEJBJarFile()) {
                return "moduletype.ejb";
            }
            if (moduleFile.isWARFile()) {
                return "moduletype.web";
            }
            if (moduleFile.isRARFile()) {
                return "moduletype.connector";
            }
        }
        return "moduletype.unknown";
    }

    public static boolean isDeployable(Object object) {
        if (object instanceof ModuleRef) {
            ModuleRef moduleRef = (ModuleRef)object;
            return moduleRef.isEJB() || moduleRef.isWeb() || moduleRef.isConnector();
        }
        if (object instanceof ModuleFile) {
            ModuleFile moduleFile = (ModuleFile)object;
            return moduleFile.isEJBJarFile() || moduleFile.isWARFile() || moduleFile.isRARFile();
        }
        return false;
    }

    public static String find_index(String string, Hashtable hashtable) {
        String string2 = (String)hashtable.get(string);
        String string3 = string;
        while (string2 != null) {
            int n = string3.lastIndexOf("-");
            if (n == -1) {
                string3 = string + "-" + Integer.toString(1);
            } else {
                String string4 = string3.substring(n + 1);
                try {
                    int n2 = Integer.valueOf(string4);
                    string3 = string.substring(0, n) + "-" + Integer.toString(++n2);
                }
                catch (NumberFormatException numberFormatException) {
                    string3 = string + "-" + Integer.toString(999);
                }
            }
            string2 = (String)hashtable.get(string3);
        }
        return string3;
    }

    public static ObjectName getObjectName(RepositoryContext repositoryContext) throws MalformedObjectNameException {
        if (AppUtils.isServer(repositoryContext)) {
            return new ObjectName("WebSphere:cell=" + repositoryContext.getParent().getParent().getName() + ",node=" + repositoryContext.getParent().getName() + ",server=" + repositoryContext.getName());
        }
        return new ObjectName("WebSphere:cell=" + repositoryContext.getParent().getName() + ",cluster=" + repositoryContext.getName());
    }
}

