/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.task;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.etools.j2ee.commonarchivecore.Archive;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.UpdateScheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.AppInstallHelper;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;

public class CompileJspTask
extends AbstractTask {
    private static TraceComponent tc = Tr.register((Class)CompileJspTask.class, (String)"Admin", (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String DEST_DIR = "WEB-INF" + File.separator + "classes";

    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"performTask");
        }
        String string = "";
        try {
            Object object;
            String[] stringArray = null;
            if (this.scheduler instanceof InstallScheduler) {
                object = (InstallScheduler)this.scheduler;
                List list = object.getEarFile(false, true).getWARFiles();
                stringArray = new String[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    stringArray[i] = object.getEarPath() + File.separator + ((WARFile)list.get(i)).getName();
                }
                object.setEarPath(object.getEarPath());
            } else if (this.scheduler instanceof UpdateScheduler && AppUtils.isPreCompileJSPs(this.scheduler)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"update scheduler .. jsp precompile");
                }
                if ((object = (UpdateScheduler)this.scheduler).getContentType().equals("modulefile")) {
                    stringArray = new String[]{object.getContentPath()};
                } else if (object.getContentType().equals("partialapp")) {
                    stringArray = new String[]{object.getContentPath() + File.separator + object.getContentURI()};
                }
            }
            object = "";
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    AppUtils.dbg(tc, "Compiling jsps in " + stringArray[i]);
                    this.compileWar(stringArray[i], stringArray[i] + File.separator + DEST_DIR);
                    string = new File(stringArray[i]).getName();
                    object = (String)object + (i == 0 ? "" : ", ") + string;
                }
                if (this.scheduler instanceof UpdateScheduler && ((UpdateScheduler)this.scheduler).getOrigContentType().equals("modulefile")) {
                    Archive archive = AppInstallHelper.getArchive(stringArray[0], false, true, this.getResourceBundle(), false);
                    AppUtils.dbg(tc, "Collapsing: " + archive.getURI());
                    archive.saveNoReopen();
                    archive.close();
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"source jsp war list is null.");
            }
            this.scheduler.propagateTaskEvent(this.createNotification("Completed", "ADMA5003I", new String[]{object}));
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"performTask");
            }
            return true;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.task.CompileJspTask.performTask", (String)"94", (Object)this);
            this.scheduler.propagateTaskEvent(this.createNotification("Failed", "ADMA5004E", new String[]{string, throwable.toString()}));
            AppUtils.dbg(tc, "Exception in jsp compile: " + throwable);
            if (throwable instanceof AdminException) {
                throw (AdminException)((Object)throwable);
            }
            throw new AdminException(throwable, AppUtils.getMessage(this.getResourceBundle(), "ADMA0021E", new Object[]{string}));
        }
    }

    private void compileWar(String string, String string2) throws AdminException {
        try {
            AppUtils.dbg(tc, "Invoking compilation ..");
            Class<?> clazz = Class.forName("com.ibm.ws.webcontainer.jsp.compiler.ibmtools.JspModC");
            Class[] classArray = new Class[]{String.class, String.class};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{string, string2};
            Object obj = constructor.newInstance(objectArray);
            Method method = clazz.getMethod("compileApp", new Class[0]);
            Integer n = (Integer)method.invoke(obj, new Object[0]);
            int n2 = n;
            if (n2 != 0) {
                AppUtils.dbg(tc, "Errors compiling jsps in " + string);
                AppUtils.dbg(tc, "Return code from jsp-compilation is: " + n2);
                throw new AdminException(AppUtils.getMessage(this.getResourceBundle(), "ADMA0021E", new Object[]{new File(string).getName() + " (rc=" + n2 + ")"}));
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof AdminException) {
                throw (AdminException)((Object)throwable);
            }
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.task.CompileJspTask.compileWar", (String)"138", (Object)this);
            AppUtils.dbg(tc, "Exception compiling jsps in " + string + ", " + throwable);
            throw new AdminException(throwable);
        }
    }
}

