/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.sync.AppData;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.classloader.ClassLoaderPolicy;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.J2CAppUtils;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.sync.AppSyncUtils;
import com.ibm.ws.management.application.sync.ChangeProcessor;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.runtime.service.VariableMap;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.emf.ecore.resource.Resource;

public class AppDataMgr {
    private static TraceComponent tc = Tr.register((Class)AppDataMgr.class, (String)"Admin", (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    static String CELLNAME_Str_KEY = "CELLNAME_KEY";
    public static String APPNAME_Str_KEY = "APPNAME_KEY";
    static String EAR_EARFile_KEY = "EAR_KEY";
    static String EARURI_Str_KEY = "EARURI_KEY";
    public static final String EAR_EARMODIFIEDTYPE_Str_KEY = "EARMODIFIEDTYPE_KEY";
    public static String DEPL_DEPLURL_Str_KEY = "DEPLURL_KEY";
    static String DEPL_DEPLMODIFIEDTYPE_Str_KEY = "DEPLMODIFIEDTYPE_KEY";
    static String DELTA_DELTList_KEY = "DELTLIST_KEY";
    static String FILE_FILEList_KEY = "FILELIST_KEY";
    static String DEPL_DEPLOYOBJ_ApplicationDeployment_KEY = "OLDDEPLOY_KEY";
    public static String DEPL_CTXIDFORSECURITY_Str_KEY = "CTXIDFORSECURITY_KEY";
    static String DEPL_WARCLPOLICY_Str_KEY = "WARPOLCY_KEY";
    static String DEPL_ZEROBINCPY_boo_KEY = "ZEROBINCPY_KEY";
    public static String DEPL_DISTENABLED_boo_KEY = "DIST_KEY";
    public static String BINURL_Str_KEY = "BINURL_KEY";
    private AppDataImpl _cachedAD;
    private AppDataImpl _newAD;
    private ConfigRepository _repo;
    private String _appName;
    private String _cellName;
    EARFile _earFile;
    private Hashtable _files;
    private Hashtable _deltas;
    String _earURI = null;
    String _deplURI = null;
    String _earChangeType;
    String _deplChangeType;
    Hashtable _props;
    String markerName = null;

    public AppDataMgr(String string, String string2, ConfigRepository configRepository, VariableMap variableMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("AppDataMgr: appname= " + string + " cellname= " + string2 + " repo= " + configRepository + " varMap = " + variableMap));
        }
        this._repo = configRepository;
        this._appName = string;
        this._cellName = string2;
        this._earChangeType = "DOCSNOCHANGE_KEY";
        this._deplChangeType = "DOCSNOCHANGE_KEY";
        this._earURI = AppSyncUtils.getBinName(string, string2);
        this._deplURI = AppSyncUtils.getDeplURI(string, string2);
        this._files = new Hashtable();
        this._files.put("DOCSADDED_KEY", new ArrayList());
        this._files.put("DOCSREMOVED_KEY", new ArrayList());
        this._files.put("DOCSMODIFIED_KEY", new ArrayList());
        this._deltas = new Hashtable();
        this._deltas.put("DOCSADDED_KEY", new ArrayList());
        this._deltas.put("DOCSREMOVED_KEY", new ArrayList());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"AppDataMgr");
        }
        this._props = new Hashtable();
    }

    protected void finalize() {
        this.cleanup();
    }

    public Hashtable getProps() {
        return this._props;
    }

    public void cleanup() {
        ApplicationDeployment applicationDeployment;
        ApplicationDeployment applicationDeployment2;
        block9: {
            String string = (String)this._props.get("expansionFailue");
            this._props.remove("expansionFailue");
            if (this.markerName != null) {
                if (string == null) {
                    boolean bl = new File(this.markerName).delete();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Deletedmarker " + this.markerName + " ret=" + bl));
                    }
                } else {
                    try {
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
                        AppUtils.copyFile(byteArrayInputStream, this.markerName);
                    }
                    catch (Throwable throwable) {
                        if (!tc.isDebugEnabled()) break block9;
                        Tr.debug((TraceComponent)tc, (String)("Could not put error code into marker file " + this.markerName));
                    }
                }
            }
        }
        if (this._earFile != null) {
            this._earFile.close();
        }
        if (this._newAD != null && (applicationDeployment2 = (ApplicationDeployment)this._newAD.getProperties().remove(DEPL_DEPLOYOBJ_ApplicationDeployment_KEY)) != null) {
            applicationDeployment2.eResource().unload();
        }
        if (this._cachedAD != null && (applicationDeployment = (ApplicationDeployment)this._cachedAD.getProperties().get(DEPL_DEPLOYOBJ_ApplicationDeployment_KEY)) != null) {
            applicationDeployment.eResource().unload();
        }
    }

    public void addAppDocument(String string, String string2, VariableMap variableMap) {
        if (AppSyncUtils.isPathToDeploymentxml(string, this._cellName)) {
            if (!"DOCSADDED_KEY".equals(string2)) {
                this.updateDeplData(variableMap);
            }
            this._deplChangeType = string2;
            if (AdminServiceFactory.getAdminService() != null && AdminServiceFactory.getAdminService().getProcessType().equals("NodeAgent")) {
                this.markerName = J2CAppUtils.getAppSyncMarkerLocation(System.getProperty("user.install.root"), this._appName);
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("marker name = " + this.markerName));
                    }
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("0".getBytes());
                    AppUtils.copyFile(byteArrayInputStream, this.markerName);
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("EEE could not create marker file at " + this.markerName));
                    }
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.application.sync.AppDataMgr.addAppDocument", (String)"175", (Object)this);
                }
            }
        } else if (AppSyncUtils.isPathToEar(string, this._cellName)) {
            this._earChangeType = string2;
        } else if (AppSyncUtils.isPathToDeltaxml(string)) {
            ((List)this._deltas.get(string2)).add(string);
        } else {
            ((List)this._files.get(string2)).add(string);
        }
    }

    public AppData getCachedAD() {
        return this._cachedAD;
    }

    public AppData getNewAD() {
        return this._newAD;
    }

    public void postProcess(VariableMap variableMap, boolean bl, ResourceBundle resourceBundle) {
        Object object;
        this.updateDeplData(variableMap);
        String string = (String)this._repo.getConfig().get("was.repository.root");
        try {
            object = string + '/' + this._earURI;
            if (new File((String)object).exists()) {
                this._earFile = AppInstallHelper.getEarFile((String)object, false, true, resourceBundle);
                this._cachedAD.getProperties().put(EAR_EARFile_KEY, this._earFile);
                this._newAD.getProperties().put(EAR_EARFile_KEY, this._earFile);
            }
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("failed to get ear:" + throwable));
            }
            if (bl) {
                throwable.printStackTrace(System.out);
            }
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.sync.AppDataMgr.update", (String)"375", (Object)this);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"creating chg processor");
        }
        object = new ChangeProcessor(this._earFile, bl, string);
        ((ChangeProcessor)object).init(this._earURI, this._earChangeType, this._deplURI, this._deplChangeType, this._deltas, this._files);
        ApplicationDeployment applicationDeployment = (ApplicationDeployment)this._cachedAD.getProperties().get(DEPL_DEPLOYOBJ_ApplicationDeployment_KEY);
        ApplicationDeployment applicationDeployment2 = (ApplicationDeployment)this._newAD.getProperties().get(DEPL_DEPLOYOBJ_ApplicationDeployment_KEY);
        ((ChangeProcessor)object).processDelta(applicationDeployment, applicationDeployment2, this._cachedAD.getBinURL(), this._newAD.getBinURL());
        this._props.put("filestbl", ((ChangeProcessor)object).getPatialStruct());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("" + object));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ear = " + this._earFile));
        }
        this._cachedAD.setChangeProcessor((ChangeProcessor)object);
        this._newAD.setChangeProcessor((ChangeProcessor)object);
    }

    public void processVarChanged(String string, String string2) {
        this._cachedAD.getChangeProcessor().setRecycle(1);
        this._cachedAD.getChangeProcessor().setOp(65536);
        this._cachedAD.getProperties().put(BINURL_Str_KEY, string);
        this._newAD.getProperties().put(BINURL_Str_KEY, string2);
    }

    private void updateDeplData(VariableMap variableMap) {
        Tr.debug((TraceComponent)tc, (String)("updateDeplData:" + variableMap));
        if (!"DOCSREMOVED_KEY".equals(this._deplChangeType)) {
            try {
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                Resource resource = null;
                resource = AppSyncUtils.getResource(this._repo, this._deplURI, "deployment.xml");
                ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(resource);
                hashtable.put(DEPL_DEPLOYOBJ_ApplicationDeployment_KEY, applicationDeployment);
                boolean bl = applicationDeployment.isEnableDistribution();
                boolean bl2 = applicationDeployment.isZeroBinaryCopy();
                String string = ClassLoaderPolicy.SINGLE_LITERAL.equals(applicationDeployment.getWarClassLoaderPolicy()) ? "1" : "0";
                String string2 = applicationDeployment.getAppContextIDForSecurity();
                String string3 = applicationDeployment.getBinariesURL();
                string3 = AppSyncUtils.normalizeBinaryPath(variableMap, string3);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("binaryURL: " + string3 + ", isDistrib: " + bl + ", isZeroBinCpy:" + bl2 + ", clPolicy:" + string + ", appContextIDForSecurity:" + string2));
                }
                if (string2 != null) {
                    hashtable.put(DEPL_CTXIDFORSECURITY_Str_KEY, string2);
                }
                hashtable.put(BINURL_Str_KEY, string3);
                hashtable.put(DEPL_WARCLPOLICY_Str_KEY, string);
                hashtable.put(DEPL_DISTENABLED_boo_KEY, new Boolean(bl));
                hashtable.put(DEPL_ZEROBINCPY_boo_KEY, new Boolean(bl2));
                this._newAD = new AppDataImpl(hashtable, this._appName);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("updateDeplData failed: " + exception));
                }
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.application.sync.AppDataMgr.updateDeplData", (String)"331", (Object)this);
            }
        }
        if (this._cachedAD == null) {
            this._cachedAD = this._newAD;
        } else if (this._newAD == null) {
            this._newAD = this._cachedAD;
        }
        this._newAD.setSibling(this._cachedAD);
        this._cachedAD.setSibling(this._newAD);
    }

    public String toString() {
        return ">>AppDataMgr: \ncachedAD = " + this._cachedAD + "\n" + "newAD = " + this._newAD + "\n" + "earfile: " + this._earFile + "\n" + "files: " + this._files + "\n" + "deltas: " + this._deltas + "\n" + "earURI: " + this._earURI + "\n" + "earChangeType: " + this._earChangeType + "\n" + "deplURI: " + this._deplURI + "\n" + "deplChange: " + this._deplChangeType + "\n" + "<<AppDataMgr \n";
    }

    private class AppDataImpl
    implements AppData {
        private Hashtable _dataTbl;
        private String _appName;
        private ChangeProcessor _cp;
        private AppDataImpl _myOnlySibling;
        private EARFile _earFile;

        AppDataImpl(Hashtable hashtable, String string) {
            this._dataTbl = hashtable;
            this._appName = string;
        }

        void setSibling(AppDataImpl appDataImpl) {
            this._myOnlySibling = appDataImpl;
        }

        void setEARFile(EARFile eARFile) {
            this._earFile = eARFile;
        }

        void setChangeProcessor(ChangeProcessor changeProcessor) {
            this._cp = changeProcessor;
        }

        ChangeProcessor getChangeProcessor() {
            return this._cp;
        }

        public Hashtable getProperties() {
            return this._dataTbl;
        }

        public String getAppContextIDForSecurity() {
            return (String)this.fetchData(DEPL_CTXIDFORSECURITY_Str_KEY, true);
        }

        public String getAppName() {
            return this._appName;
        }

        public String getBinURL() {
            return (String)this.fetchData(BINURL_Str_KEY, true);
        }

        public String getDeplURI() {
            return this._cp.getDeploymentURI();
        }

        public EARFile getEAR() {
            return (EARFile)this.fetchData(EAR_EARFile_KEY, true);
        }

        public String getEarURI() {
            return this._cp.getEarURI();
        }

        public String getWarClPolicy() {
            return (String)this.fetchData(DEPL_WARCLPOLICY_Str_KEY, true);
        }

        public boolean isDistEnabled() {
            Boolean bl = (Boolean)this.fetchData(DEPL_DISTENABLED_boo_KEY, true);
            if (bl == null) {
                return true;
            }
            return bl;
        }

        public boolean isZeroBinCpy() {
            Boolean bl = (Boolean)this.fetchData(DEPL_ZEROBINCPY_boo_KEY, true);
            if (bl == null) {
                return false;
            }
            return bl;
        }

        public String getDeploymentURI() {
            return this._cp.getDeploymentURI();
        }

        public String getDeploymentURIChangeType() {
            return this._cp.getDeploymentURIChangeType();
        }

        public String getEarURIChangeType() {
            return this._cp.getEarURIChangeType();
        }

        public List getModulesToRecycle() {
            return this._cp.getModulesToRecycle();
        }

        public List getModulesToStart() {
            return this._cp.getModulesToStart();
        }

        public List getModulesToStop() {
            return this._cp.getModulesToStop();
        }

        public int getOperations() {
            return this._cp.getOperations();
        }

        public Hashtable getPartialUpdateDetails() {
            return this._cp.getPartialUpdateDetails();
        }

        public int getRecycleMode() {
            return this._cp.getRecycleMode();
        }

        Object fetchData(String string, boolean bl) {
            Object v = this._dataTbl.get(string);
            if (v != null) {
                return v;
            }
            if (bl && this._myOnlySibling != null) {
                return this._myOnlySibling.fetchData(string, false);
            }
            return v;
        }

        public String toString() {
            return ">>> - AppData: " + this._appName + ", props=" + this._dataTbl;
        }

        public Hashtable getFileChangesInRepository() {
            return this._cp.getFileChangesInRepository();
        }

        public Hashtable getPartialUpdateModuleDetails() {
            return this._cp.getPartialUpdateModuleDetails();
        }
    }
}

