/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application.sync;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.sync.AbstractAppSyncTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.repository.ConfigRepositoryListener;
import com.ibm.websphere.management.repository.ResourceNameFilter;
import com.ibm.websphere.models.config.topology.cell.Cell;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.ExtensionHelper;
import com.ibm.ws.management.application.J2CAppUtils;
import com.ibm.ws.management.application.sync.AppDataMgr;
import com.ibm.ws.management.application.sync.AppSyncEventsTask;
import com.ibm.ws.management.application.sync.AppSyncUtils;
import com.ibm.ws.management.application.sync.DefaultAppSyncTaskProvider;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.sync.NodeSync;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.security.auth.Subject;
import org.eclipse.emf.ecore.resource.Resource;

public class AppBinaryProcessor
implements ConfigRepositoryListener,
NotificationListener {
    private static TraceComponent tc = Tr.register((Class)AppBinaryProcessor.class, (String)"Admin", (String)"com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CELLS_CONTEXT = "cells/";
    private static final String NODES_CONTEXT = "nodes/";
    private static final String DMGR = "dmgr";
    private static final long SYNC_ID = -1L;
    private ConfigRepository _repository;
    private boolean _isLocal;
    private String _cellName = null;
    private String _nodeName = null;
    private String _cRoot = null;
    private boolean _isInNodeSync = false;
    private Hashtable _changeTables = null;
    private Object notify = null;
    private Class cls = null;
    private static ResourceBundle _bundle;
    private static AppBinaryProcessor processor;
    private static AppBinThread binThread;
    private boolean notificationSignaled = false;
    static Vector appAddedTasks;
    static Vector appRemovedTasks;
    static Vector appModifiedTasks;

    public static ResourceBundle getBundle() {
        if (_bundle == null) {
            _bundle = AppUtils.getBundle(null);
        }
        return _bundle;
    }

    public static AppBinaryProcessor getAppBinInstance() {
        return processor;
    }

    public void waitForThreadCompletion() {
        if (binThread == null) {
            return;
        }
        AppBinaryProcessor.binThread.waitForThreadCompletion();
    }

    public void notifyWaiter() {
        AppBinaryProcessor.binThread.notifyWaiter();
    }

    public AppBinaryProcessor(Boolean bl, ConfigRepository configRepository) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("AppBinaryProcessor: " + bl));
        }
        this._isLocal = bl;
        this._repository = configRepository;
        this._cRoot = (String)this._repository.getConfig().get("was.repository.root");
        this._changeTables = new Hashtable();
        NodeSync.addLocalSyncEventListener((NotificationListener)this);
        if (processor != null && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Other instance exist!");
        }
        processor = this;
        try {
            this.cls = Class.forName("com.ibm.ws.security.authorize.AppInstallNotify");
            String string = "getInstance";
            Class<?>[] classArray = null;
            Object[] objectArray = null;
            Method method = this.cls.getMethod(string, classArray);
            this.notify = method.invoke(null, objectArray);
        }
        catch (Exception exception) {
            Tr.warning((TraceComponent)tc, (String)"ADMA7012E", (Object)new Object[]{exception});
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.application.sync.AppBinaryProcessor.AppBinaryProcessor", (String)"178", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"AppBinaryProcessor");
        }
    }

    public void onRepositoryLock() {
    }

    public void onRepositoryUnlock() {
    }

    public void onChangeStart(final ConfigRepositoryEvent configRepositoryEvent) {
        block3: {
            try {
                AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() {
                        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("setting CCL = " + this.getClass().getClassLoader()));
                        }
                        AppBinaryProcessor.this._onChangeStart(configRepositoryEvent);
                        Thread.currentThread().setContextClassLoader(classLoader);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception in doPriv() " + privilegedActionException + " cause  = " + privilegedActionException.getCause()));
                }
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.management.application.sync.AppBinaryProcessor.AppBinaryProcessor", (String)"216", (Object)this);
                System.out.println("Exception from doPriv = " + privilegedActionException + " == " + privilegedActionException.getCause());
                if (privilegedActionException.getCause() == null) break block3;
                privilegedActionException.getCause().printStackTrace();
            }
        }
    }

    private void _onChangeStart(ConfigRepositoryEvent configRepositoryEvent) {
        Tr.entry((TraceComponent)tc, (String)"onChangeStart");
        ChangeTable changeTable = null;
        long l = this._isInNodeSync ? -1L : configRepositoryEvent.getId();
        ConfigChangeNotifier[] configChangeNotifierArray = configRepositoryEvent.getChanges();
        for (int i = 0; i < configChangeNotifierArray.length; ++i) {
            try {
                int n;
                if (this._cellName == null || this._nodeName == null) {
                    this.createNodeInfo(configChangeNotifierArray[i].getUri());
                }
                if ((n = AppSyncUtils.shouldProcess(configChangeNotifierArray[i].getUri(), this._cellName, this._nodeName, this._isInNodeSync, this._isLocal)) == 0) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("process: " + configChangeNotifierArray[i].getUri() + " id=" + l));
                }
                if (changeTable == null && (changeTable = (ChangeTable)this._changeTables.get(new Long(l))) == null) {
                    changeTable = new ChangeTable(this._cellName, this._nodeName, this._repository, this._isLocal);
                    this._changeTables.put(new Long(l), changeTable);
                }
                String string = AppSyncUtils.getSyncEventFromRepoEvent(configChangeNotifierArray[i].getChangeType());
                switch (n) {
                    case 1: {
                        changeTable.handleAppDocument(configChangeNotifierArray[i].getUri(), string);
                        break;
                    }
                    case 3: {
                        changeTable.handleSIDocument(configChangeNotifierArray[i].getUri(), string, this._nodeName);
                        break;
                    }
                    case 2: {
                        changeTable.handleVarDocument(configChangeNotifierArray[i].getUri(), string);
                    }
                }
                continue;
            }
            catch (Throwable throwable) {
                Tr.warning((TraceComponent)tc, (String)"ADMA7000W", (Object)new Object[]{throwable});
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.sync.AppBinaryProcessor.onChangeStart", (String)"266", (Object)this);
            }
        }
        if (!this._isInNodeSync) {
            this.printTable("pre", l, (ChangeTable)this._changeTables.get(new Long(l)));
        }
        Tr.exit((TraceComponent)tc, (String)"onChangeStart");
    }

    public void onChangeCompletion(final ConfigRepositoryEvent configRepositoryEvent) {
        block3: {
            try {
                AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() {
                        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("setting CCL onChangecompletion = " + this.getClass().getClassLoader()));
                        }
                        AppBinaryProcessor.this._onChangeCompletion(configRepositoryEvent);
                        Thread.currentThread().setContextClassLoader(classLoader);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception in doPriv() " + privilegedActionException + " cause  = " + privilegedActionException.getCause()));
                }
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.management.application.sync.AppBinaryProcessor.AppBinaryProcessor", (String)"216", (Object)this);
                System.out.println("Exception from doPriv = " + privilegedActionException + " == " + privilegedActionException.getCause());
                if (privilegedActionException.getCause() == null) break block3;
                privilegedActionException.getCause().printStackTrace();
            }
        }
    }

    public void _onChangeCompletion(ConfigRepositoryEvent configRepositoryEvent) {
        boolean bl;
        Tr.entry((TraceComponent)tc, (String)"onChangeCompletion");
        boolean bl2 = bl = this._isLocal ? true : "UnManagedProcess".equals(AdminServiceFactory.getAdminService().getProcessType());
        if (!this._isInNodeSync) {
            this.postProcess(this._isInNodeSync ? -1L : configRepositoryEvent.getId(), bl);
        }
        Tr.exit((TraceComponent)tc, (String)"onChangeCompletion");
    }

    public void onRepositoryEpochRefresh() {
    }

    public void handleNotification(Notification notification, Object object) {
        Tr.entry((TraceComponent)tc, (String)"handleNotification");
        if (notification.getType().equals("websphere.nodesync.initiated")) {
            this._isInNodeSync = true;
        } else if (notification.getType().equals("websphere.nodesync.complete")) {
            boolean bl;
            this._isInNodeSync = false;
            this.printTable("pre", -1L, (ChangeTable)this._changeTables.get(new Long(-1L)));
            if (notification.getUserData() != null && Boolean.TRUE.equals(notification.getUserData())) {
                this.postProcess(-1L, this._isLocal);
            }
            if (bl = this.checkForFailedEars()) {
                this.postProcess(-1L, this._isLocal);
            }
        }
        Tr.exit((TraceComponent)tc, (String)"handleNotification");
    }

    public boolean checkForFailedEars() {
        boolean bl;
        block14: {
            int n;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"checkForFailedEars");
            }
            bl = false;
            String string = J2CAppUtils.getAppSyncMarkerLocation(System.getProperty("user.install.root"), "");
            String string2 = string.substring(0, n = string.lastIndexOf(46));
            File file = new File(string2);
            String[] stringArray = file.list();
            if (stringArray != null) {
                try {
                    Hashtable hashtable = AppSyncUtils.buildSIMap(this._cellName, this._nodeName, this._repository);
                    if (hashtable == null) {
                        return bl;
                    }
                    Enumeration enumeration = hashtable.keys();
                    enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        boolean bl2 = false;
                        String string3 = null;
                        String string4 = (String)enumeration.nextElement();
                        String string5 = AppSyncUtils.getBinName(string4, this._cellName);
                        try {
                            string3 = J2CAppUtils.getAppSyncMarkerLocation(System.getProperty("user.install.root"), string4);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Marker file to check is = " + string3));
                            }
                            FileInputStream fileInputStream = new FileInputStream(string3);
                            int n2 = fileInputStream.available();
                            fileInputStream.close();
                            if (n2 > 4) {
                                bl = true;
                                ChangeTable changeTable = null;
                                changeTable = (ChangeTable)this._changeTables.get(new Long(-1L));
                                if (changeTable == null) {
                                    changeTable = new ChangeTable(this._cellName, this._nodeName, this._repository, this._isLocal);
                                    this._changeTables.put(new Long(-1L), changeTable);
                                }
                                try {
                                    changeTable.handleAppDocument(AppSyncUtils.getDeplURI(string4, this._cellName), "DOCSADDED_KEY");
                                }
                                catch (Throwable throwable) {
                                    throwable.printStackTrace();
                                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.sync.AppBinaryProcessor.AppBinaryProcessor.ChangeTable", (String)"885", (Object)this);
                                }
                                Tr.error((TraceComponent)tc, (String)"ADMA7008E", (Object)(string4 + " application FAILED to expand - will retry ear expansion"));
                                continue;
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("Still in process of expanding application = " + string4));
                        }
                        catch (Exception exception) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("Marker file doesn't exist for application " + string5));
                        }
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block14;
                    Tr.debug((TraceComponent)tc, (String)("Failed to create SI map ex=" + exception));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("checkForFailedEars returns " + bl));
        }
        return bl;
    }

    public void postProcess(long l, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("postProcess: " + l + ", synchronous=: " + bl));
        }
        try {
            AppBinThread appBinThread;
            ChangeTable changeTable = (ChangeTable)this._changeTables.remove(new Long(l));
            if (changeTable == null) {
                if (tc.isEntryEnabled() && changeTable == null) {
                    Tr.exit((TraceComponent)tc, (String)("postProcess  table is null or BAD !!!! " + l));
                }
                return;
            }
            changeTable.postProcess(this._nodeName);
            this.printTable("post", l, changeTable);
            binThread = appBinThread = new AppBinThread(this._cellName, this._nodeName, changeTable, this._repository);
            appBinThread.setSecurity(this.notify, this.cls);
            appBinThread.setLocal(this._isLocal);
            if (!bl) {
                Thread thread = new Thread(appBinThread);
                thread.setContextClassLoader(this.getClass().getClassLoader());
                thread.start();
            } else {
                appBinThread.run();
            }
        }
        catch (Throwable throwable) {
            Tr.error((TraceComponent)tc, (String)"ADMA7007E", (Object)new Object[]{throwable, new Long(l)});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("postProcess: " + l));
        }
    }

    private void createNodeInfo(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createNodeInfo");
        }
        if (!this._isLocal) {
            this._cellName = AdminServiceFactory.getAdminService().getCellName();
            this._nodeName = AdminServiceFactory.getAdminService().getNodeName();
        } else if (this._isInNodeSync) {
            this._cellName = NodeSync.getNodeSync().getCellName();
            this._nodeName = NodeSync.getNodeSync().getNodeName();
        } else {
            if (string.indexOf(CELLS_CONTEXT) == -1) {
                return;
            }
            this._cellName = string.substring(string.indexOf(CELLS_CONTEXT) + CELLS_CONTEXT.length());
            if (this._cellName.indexOf(47) <= 0) {
                this._cellName = null;
                return;
            }
            this._cellName = this._cellName.substring(0, this._cellName.indexOf(47));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("cell: " + this._cellName));
            }
            Resource resource = AppSyncUtils.getResource(this._repository, CELLS_CONTEXT + this._cellName + "/" + "cell.xml", "cell.xml");
            Cell cell = (Cell)resource.getContents().get(0);
            WorkSpace workSpace = ConfigRepoHelper.getWorkSpace(null);
            RepositoryContext repositoryContext = AppUtils.findContext("cells", this._cellName, null, null, workSpace, true);
            if (cell.getCellType().getValue() == 1) {
                this._nodeName = AppSyncUtils.getDmgrNodeName(this._repository, this._cellName);
                if (this._nodeName == null) {
                    RepositoryContext repositoryContext2 = AppUtils.findContext("servers", DMGR, null, repositoryContext, workSpace, true);
                    if (repositoryContext2 == null) {
                        Object[] objectArray = AppUtils.getContextArray("servers", repositoryContext, workSpace);
                        repositoryContext2 = (RepositoryContext)objectArray[0];
                    }
                    this._nodeName = repositoryContext2.getParent().getName();
                }
            } else {
                this._nodeName = AppSyncUtils.getNodeNameFromBaseServer(this._repository, this._cellName);
                if (this._nodeName == null) {
                    Object[] objectArray = AppUtils.getContextArray("nodes", repositoryContext, workSpace);
                    this._nodeName = ((RepositoryContext)objectArray[0]).getName();
                }
            }
            ConfigRepoHelper.removeWorkSpace(false, workSpace);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("cell: " + this._cellName + ", node: " + this._nodeName));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createNodeInfo");
        }
    }

    private void printTable(String string, long l, ChangeTable changeTable) {
        if (tc.isDebugEnabled()) {
            if (changeTable == null) {
                Tr.debug((TraceComponent)tc, (String)("xxxxxxxxxxx " + string + ": " + l + " xxxxxxxxxx: NULL"));
                return;
            }
            Tr.debug((TraceComponent)tc, (String)("xxxxxxxxxxx " + string + ": " + l + " xxxxxxxxxx"));
            String string2 = null;
            AppDataMgr appDataMgr = null;
            Enumeration enumeration = changeTable.keys();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                appDataMgr = changeTable.getTableEntry(string2);
                Tr.debug((TraceComponent)tc, (String)("\n=================================\n" + appDataMgr.toString() + "\n" + "=================================\n"));
            }
            Tr.debug((TraceComponent)tc, (String)("xxxxENDxxxx id: " + l + " xxxxENDxxxx"));
        }
    }

    static /* synthetic */ AppBinThread access$402(AppBinThread appBinThread) {
        binThread = appBinThread;
        return binThread;
    }

    static {
        processor = null;
        binThread = null;
    }

    private class ChangeTable {
        private Hashtable _table = new Hashtable();
        private String cellName;
        private boolean variablexml;
        private VariableMap vMap = null;
        private Hashtable cachedsiMap = null;
        private Hashtable newsiMap = null;
        ConfigRepository repository;
        boolean _isLocal;
        boolean varChanged = false;
        Hashtable varTable = null;
        String cRoot = null;

        ChangeTable(String string, String string2, ConfigRepository configRepository, boolean bl) {
            this.cellName = string;
            this.repository = configRepository;
            this._isLocal = bl;
            try {
                this.cRoot = (String)configRepository.getConfig().get("was.repository.root");
                this.vMap = AppUtils.createVarMap(this.cRoot, string, string2, null);
            }
            catch (Exception exception) {
                Tr.warning((TraceComponent)tc, (String)"ADMA7016W", (Object)new Object[]{exception, "ChangeTable"});
            }
        }

        public void handleAppDocument(String string, String string2) {
            String string3 = AppSyncUtils.getAppNameFromAppDoc(string, this.cellName);
            AppDataMgr appDataMgr = (AppDataMgr)this._table.get(string3);
            if (appDataMgr == null) {
                appDataMgr = new AppDataMgr(string3, this.cellName, this.repository, this.vMap);
                this._table.put(string3, appDataMgr);
            }
            appDataMgr.addAppDocument(string, string2, this.vMap);
        }

        public void handleSIDocument(String string, String string2, String string3) {
            try {
                this.cachedsiMap = AppSyncUtils.buildSIMap(this.cellName, string3, this.repository);
            }
            catch (Throwable throwable) {
                if (this._isLocal) {
                    throwable.printStackTrace();
                }
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.sync.AppBinaryProcessor.AppBinaryProcessor.ChangeTable", (String)"1108", (Object)this);
            }
        }

        public void handleVarDocument(String string, String string2) {
            this.varChanged = true;
            this.varTable = this.getBinURLTable();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("oldVarTable: " + this.varTable));
            }
        }

        public Hashtable getCachedSIMap() {
            return this.cachedsiMap;
        }

        public Hashtable getNewSIMap() {
            return this.newsiMap;
        }

        public void postProcess(String string) {
            try {
                this.newsiMap = AppSyncUtils.buildSIMap(this.cellName, string, this.repository);
                if (this.cachedsiMap == null) {
                    this.cachedsiMap = this.newsiMap;
                }
            }
            catch (Throwable throwable) {
                if (this._isLocal) {
                    throwable.printStackTrace();
                }
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.sync.AppBinaryProcessor.AppBinaryProcessor.ChangeTable", (String)"869", (Object)this);
            }
            if (this.varChanged && this.varTable != null) {
                try {
                    this.vMap = AppUtils.createVarMap(this.cRoot, AppBinaryProcessor.this._cellName, AppBinaryProcessor.this._nodeName, null);
                    Hashtable hashtable = this.getBinURLTable();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("newVarTable: " + hashtable));
                    }
                    Hashtable<String, String[]> hashtable2 = new Hashtable<String, String[]>();
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        String string2;
                        String string3 = (String)enumeration.nextElement();
                        String string4 = (String)this.varTable.get(string3);
                        if (string4 == null || (string2 = (String)hashtable.get(string3)).equals(string4)) continue;
                        hashtable2.put(string3, new String[]{string4, string2});
                        if (this._table.get(string3) != null) continue;
                        try {
                            this.handleAppDocument(AppSyncUtils.getDeplURI(string3, AppBinaryProcessor.this._cellName), "DOCSMODIFIED_KEY");
                        }
                        catch (Throwable throwable) {
                            if (this._isLocal) {
                                throwable.printStackTrace();
                            }
                            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.sync.AppBinaryProcessor.AppBinaryProcessor.ChangeTable", (String)"885", (Object)this);
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("diffTable: " + hashtable2));
                    }
                    this.varTable = hashtable2;
                }
                catch (Exception exception) {
                    if (this._isLocal) {
                        exception.printStackTrace();
                    }
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.application.sync.AppBinaryProcessor.AppBinaryProcessor.ChangeTable", (String)"861", (Object)this);
                }
            }
        }

        public void postProcessVarChanged(AppDataMgr appDataMgr, String string) {
            if (!this.varChanged || this.varTable == null || this.varTable.get(string) == null) {
                return;
            }
            String[] stringArray = (String[])this.varTable.get(string);
            appDataMgr.processVarChanged(stringArray[0], stringArray[1]);
        }

        public VariableMap getVarMap() {
            return this.vMap;
        }

        public Enumeration keys() {
            return this._table.keys();
        }

        public AppDataMgr getTableEntry(String string) {
            return (AppDataMgr)this._table.get(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Hashtable getBinURLTable() {
            if (tc.isDebugEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getBinURLTable");
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            try {
                String[] stringArray = this.repository.listResourceNames(AppBinaryProcessor.CELLS_CONTEXT + AppBinaryProcessor.this._cellName + "/applications", 1, Integer.MAX_VALUE, new ResourceNameFilter(this){
                    private final /* synthetic */ ChangeTable this$1;
                    {
                        this.this$1 = changeTable;
                    }

                    public boolean accept(String string, String string2) {
                        return string.indexOf("/deployments/") != -1 && string2.equals("deployment.xml");
                    }
                });
                for (int i = 0; i < stringArray.length; ++i) {
                    Resource resource = null;
                    try {
                        String string = AppSyncUtils.getAppNameFromDepURI(stringArray[i]);
                        resource = AppSyncUtils.getResource(this.repository, stringArray[i], "deployment.xml");
                        String string2 = ConfigRepoHelper.getAppDeploymentForApp(resource).getBinariesURL();
                        string2 = this.vMap.expand(string2);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("appname:" + string + ", path: " + string2));
                        }
                        hashtable.put(string, string2);
                        continue;
                    }
                    catch (Throwable throwable) {
                        if (this._isLocal) {
                            throwable.printStackTrace();
                        }
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.sync.AppBinaryProcessor.AppBinaryProcessor.ChangeTable", (String)"891", (Object)this);
                        continue;
                    }
                    finally {
                        if (resource != null) {
                            resource.unload();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                if (this._isLocal) {
                    throwable.printStackTrace();
                }
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.management.application.sync.AppBinaryProcessor.AppBinaryProcessor.ChangeTable", (String)"877", (Object)this);
            }
            if (tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getBinURLTable");
            }
            return hashtable;
        }
    }

    private class AppBinThread
    implements Runnable {
        ConfigRepository _repository;
        String _cellName;
        String _nodeName;
        ResourceBundle _resBundle;
        Subject _subject = null;
        boolean _isLocal;
        ChangeTable _changeTbl;
        Object _notify;
        Class _cls;
        AbstractAppSyncTask _task;
        protected int nextTaskNum = 0;
        boolean bSuccess = true;

        public AppBinThread(String string, String string2, ChangeTable changeTable, ConfigRepository configRepository) {
            this._cellName = string;
            this._nodeName = string2;
            this._changeTbl = changeTable;
            this._repository = configRepository;
            this._resBundle = AppBinaryProcessor.getBundle();
        }

        public void setSecurity(Object object, Class clazz) {
            this._notify = object;
            this._cls = clazz;
        }

        public void setLocal(boolean bl) {
            this._isLocal = bl;
            if (!bl) {
                this._subject = SecurityHelper.getOwnedSubject();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block38: {
                if (AppBinaryProcessor.access$200().isEntryEnabled()) {
                    Tr.entry((TraceComponent)AppBinaryProcessor.access$200(), (String)"run");
                }
                if (this._subject != null) {
                    if (AppBinaryProcessor.access$200().isDebugEnabled()) {
                        Tr.debug((TraceComponent)AppBinaryProcessor.access$200(), (String)("Push creds: " + this._subject));
                    }
                    this._subject = SecurityHelper.pushInvocationSubject((Subject)this._subject);
                    if (AppBinaryProcessor.access$200().isDebugEnabled()) {
                        Tr.debug((TraceComponent)AppBinaryProcessor.access$200(), (String)("After push: " + this._subject));
                    }
                }
                var1_1 = this._changeTbl.keys();
                var3_2 = null;
                var4_3 = null;
                var5_4 = null;
                try {
                    this.setupTasks();
                    if (AppBinaryProcessor.access$200().isDebugEnabled()) {
                        Tr.debug((TraceComponent)AppBinaryProcessor.access$200(), (String)("Cached SI = " + this._changeTbl.getCachedSIMap()));
                    }
                    if (AppBinaryProcessor.access$200().isDebugEnabled()) {
                        Tr.debug((TraceComponent)AppBinaryProcessor.access$200(), (String)("New SI = " + this._changeTbl.getNewSIMap()));
                    }
                    while (var1_1.hasMoreElements()) {
                        block42: {
                            block36: {
                                block41: {
                                    block35: {
                                        block40: {
                                            block34: {
                                                this.nextTaskNum = 0;
                                                var2_5 = (String)var1_1.nextElement();
                                                var4_3 = this._changeTbl.getTableEntry(var2_5);
                                                try {
                                                    try {
                                                        var4_3.postProcess(this._changeTbl.getVarMap(), this._isLocal, this._resBundle);
                                                        this._changeTbl.postProcessVarChanged(var4_3, var2_5);
                                                        if (AppBinaryProcessor.access$200().isDebugEnabled()) {
                                                            Tr.debug((TraceComponent)AppBinaryProcessor.access$200(), (String)("" + var4_3));
                                                        }
                                                        if (var4_3.getNewAD() == null && var4_3.getCachedAD() == null) {
                                                            var8_8 = null;
                                                            break block34;
                                                        }
                                                        if (var4_3.getNewAD().isZeroBinCpy()) {
                                                            if (AppBinaryProcessor.access$200().isDebugEnabled()) {
                                                                Tr.debug((TraceComponent)AppBinaryProcessor.access$200(), (String)("App " + var2_5 + "isZeroBinCopy, skip."));
                                                            }
                                                            var4_3.getProps().put("syncstatus", new Boolean(this.bSuccess));
                                                            break block35;
                                                        }
                                                        var5_4 = this.getTaskList(var4_3.getNewAD().getOperations());
                                                        this._task = this.getNextTask(var5_4);
                                                        while (this._task != null && this.bSuccess) {
                                                            this._task.setData(this._repository, this._cellName, this._nodeName, this._isLocal, this._changeTbl.getCachedSIMap(), this._changeTbl.getNewSIMap());
                                                            this._task.setSecurity(this._subject, this._notify, this._cls);
                                                            Tr.debug((TraceComponent)AppBinaryProcessor.access$200(), (String)("Executing: " + this._task));
                                                            this.bSuccess = this._task.performTask(var4_3.getCachedAD(), var4_3.getNewAD(), var4_3.getProps());
                                                            if (!this.bSuccess) break;
                                                            this._task = this.getNextTask(var5_4);
                                                        }
                                                        var4_3.getProps().put("syncstatus", new Boolean(this.bSuccess));
                                                        break block36;
                                                    }
                                                    catch (Throwable var6_6) {
                                                        if (this._isLocal) {
                                                            var6_6.printStackTrace();
                                                        }
                                                        FFDCFilter.processException((Throwable)var6_6, (String)"com.ibm.ws.management.application.sync.AppBinaryProcessor.run", (String)"1347", (Object)this);
                                                        Tr.error((TraceComponent)AppBinaryProcessor.access$200(), (String)("Exception from run: " + var6_6));
                                                        var4_3.getProps().put("syncstatus", new Boolean(false));
                                                        var8_8 = null;
                                                        try {
                                                            var9_9 = new AppSyncEventsTask();
                                                            Tr.debug((TraceComponent)AppBinaryProcessor.access$200(), (String)("Executing: " + var9_9));
                                                            var9_9.setData(this._repository, this._cellName, this._nodeName, this._isLocal, this._changeTbl.getCachedSIMap(), this._changeTbl.getNewSIMap());
                                                            var9_9.performTask(var4_3.getCachedAD(), var4_3.getNewAD(), var4_3.getProps());
                                                        }
                                                        catch (Throwable var9_9) {
                                                            if (this._isLocal) {
                                                                var9_9.printStackTrace();
                                                            }
                                                            FFDCFilter.processException((Throwable)var9_9, (String)"com.ibm.ws.management.application.sync.AppBinThread.run", (String)"1425", (Object)this);
                                                        }
                                                        var4_3.cleanup();
                                                        continue;
                                                    }
                                                }
                                                catch (Throwable var7_10) {
                                                    block39: {
                                                        var8_8 = null;
                                                        ** try [egrp 3[TRYBLOCK] [8 : 693->787)] { 
lbl80:
                                                        // 1 sources

                                                        var9_9 = new AppSyncEventsTask();
                                                        Tr.debug((TraceComponent)AppBinaryProcessor.access$200(), (String)("Executing: " + var9_9));
                                                        var9_9.setData(this._repository, this._cellName, this._nodeName, this._isLocal, this._changeTbl.getCachedSIMap(), this._changeTbl.getNewSIMap());
                                                        var9_9.performTask(var4_3.getCachedAD(), var4_3.getNewAD(), var4_3.getProps());
                                                        break block39;
lbl86:
                                                        // 1 sources

                                                        catch (Throwable var9_9) {
                                                            if (this._isLocal) {
                                                                var9_9.printStackTrace();
                                                            }
                                                            FFDCFilter.processException((Throwable)var9_9, (String)"com.ibm.ws.management.application.sync.AppBinThread.run", (String)"1425", (Object)this);
                                                        }
                                                    }
                                                    var4_3.cleanup();
                                                    throw var7_10;
                                                }
                                            }
                                            ** try [egrp 3[TRYBLOCK] [8 : 693->787)] { 
lbl95:
                                            // 1 sources

                                            var9_9 = new AppSyncEventsTask();
                                            Tr.debug((TraceComponent)AppBinaryProcessor.access$200(), (String)("Executing: " + var9_9));
                                            var9_9.setData(this._repository, this._cellName, this._nodeName, this._isLocal, this._changeTbl.getCachedSIMap(), this._changeTbl.getNewSIMap());
                                            var9_9.performTask(var4_3.getCachedAD(), var4_3.getNewAD(), var4_3.getProps());
                                            break block40;
lbl101:
                                            // 1 sources

                                            catch (Throwable var9_9) {
                                                if (this._isLocal) {
                                                    var9_9.printStackTrace();
                                                }
                                                FFDCFilter.processException((Throwable)var9_9, (String)"com.ibm.ws.management.application.sync.AppBinThread.run", (String)"1425", (Object)this);
                                            }
                                        }
                                        var4_3.cleanup();
                                        continue;
                                    }
                                    var8_8 = null;
                                    ** try [egrp 3[TRYBLOCK] [8 : 693->787)] { 
lbl111:
                                    // 1 sources

                                    var9_9 = new AppSyncEventsTask();
                                    Tr.debug((TraceComponent)AppBinaryProcessor.access$200(), (String)("Executing: " + var9_9));
                                    var9_9.setData(this._repository, this._cellName, this._nodeName, this._isLocal, this._changeTbl.getCachedSIMap(), this._changeTbl.getNewSIMap());
                                    var9_9.performTask(var4_3.getCachedAD(), var4_3.getNewAD(), var4_3.getProps());
                                    break block41;
lbl117:
                                    // 1 sources

                                    catch (Throwable var9_9) {
                                        if (this._isLocal) {
                                            var9_9.printStackTrace();
                                        }
                                        FFDCFilter.processException((Throwable)var9_9, (String)"com.ibm.ws.management.application.sync.AppBinThread.run", (String)"1425", (Object)this);
                                    }
                                }
                                var4_3.cleanup();
                                continue;
                            }
                            var8_8 = null;
                            ** try [egrp 3[TRYBLOCK] [8 : 693->787)] { 
lbl127:
                            // 1 sources

                            var9_9 = new AppSyncEventsTask();
                            Tr.debug((TraceComponent)AppBinaryProcessor.access$200(), (String)("Executing: " + var9_9));
                            var9_9.setData(this._repository, this._cellName, this._nodeName, this._isLocal, this._changeTbl.getCachedSIMap(), this._changeTbl.getNewSIMap());
                            var9_9.performTask(var4_3.getCachedAD(), var4_3.getNewAD(), var4_3.getProps());
                            break block42;
lbl133:
                            // 1 sources

                            catch (Throwable var9_9) {
                                if (this._isLocal) {
                                    var9_9.printStackTrace();
                                }
                                FFDCFilter.processException((Throwable)var9_9, (String)"com.ibm.ws.management.application.sync.AppBinThread.run", (String)"1425", (Object)this);
                            }
                        }
                        var4_3.cleanup();
                    }
                    if (this._subject != null) {
                        if (AppBinaryProcessor.access$200().isDebugEnabled()) {
                            Tr.debug((TraceComponent)AppBinaryProcessor.access$200(), (String)("Pop creds: " + this._subject));
                        }
                        SecurityHelper.popInvocationSubject((Subject)this._subject);
                        if (AppBinaryProcessor.access$200().isDebugEnabled()) {
                            Tr.debug((TraceComponent)AppBinaryProcessor.access$200(), (String)"After pop");
                        }
                        this._subject = null;
                    }
                }
                catch (Throwable var6_7) {
                    FFDCFilter.processException((Throwable)var6_7, (String)"com.ibm.ws.management.application.sync.AppBinThread.run", (String)"1395", (Object)this);
                    if (!this._isLocal) break block38;
                    var6_7.printStackTrace();
                }
            }
            this.notifyWaiter();
            AppBinaryProcessor.access$402(null);
            if (AppBinaryProcessor.access$200().isEntryEnabled()) {
                Tr.exit((TraceComponent)AppBinaryProcessor.access$200(), (String)"run");
            }
        }

        private synchronized void waitForThreadCompletion() {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"waitForThreadCompletion");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Entering waitForThreadCompletion notificationSignaled = " + AppBinaryProcessor.this.notificationSignaled));
            }
            if (!AppBinaryProcessor.this.notificationSignaled) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            AppBinaryProcessor.this.notificationSignaled = false;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exiting waitForThreadCompletion");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"waitForThreadCompletion");
            }
        }

        private synchronized void notifyWaiter() {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"notifyWaiter");
            }
            AppBinaryProcessor.this.notificationSignaled = true;
            this.notify();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"notifyWaiter");
            }
        }

        private Vector getTaskList(int n) {
            Vector vector = null;
            vector = (n & 1) != 0 ? appAddedTasks : ((n & 0x10) != 0 ? appRemovedTasks : appModifiedTasks);
            return vector;
        }

        private void setupTasks() throws Exception {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"setupTasks");
            }
            DefaultAppSyncTaskProvider defaultAppSyncTaskProvider = new DefaultAppSyncTaskProvider();
            Vector vector = null;
            if (appAddedTasks == null) {
                appAddedTasks = new Vector();
                vector = new Vector();
                defaultAppSyncTaskProvider.provideAppAddedSyncTasks(vector);
                ExtensionHelper.processAppAddedSyncExtensions(vector);
                this.fillTasks(appAddedTasks, vector);
            }
            if (appRemovedTasks == null) {
                appRemovedTasks = new Vector();
                vector = new Vector();
                defaultAppSyncTaskProvider.provideAppRemovedSyncTasks(vector);
                ExtensionHelper.processAppRemovedSyncExtensions(vector);
                this.fillTasks(appRemovedTasks, vector);
            }
            if (appModifiedTasks == null) {
                appModifiedTasks = new Vector();
                vector = new Vector();
                defaultAppSyncTaskProvider.provideAppModifiedSyncTasks(vector);
                ExtensionHelper.processAppModifiedSyncExtensions(vector);
                this.fillTasks(appModifiedTasks, vector);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setupTasks");
            }
        }

        private void fillTasks(Vector vector, Vector vector2) throws AdminException {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"fillTasks");
            }
            if (vector2.size() == 0) {
                return;
            }
            String string = "";
            for (int i = 0; i < vector2.size(); ++i) {
                string = (String)vector2.elementAt(i);
                try {
                    Class<?> clazz = Class.forName(string);
                    if (tc.isEntryEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("class is: " + clazz));
                    }
                    vector.addElement(clazz.newInstance());
                    continue;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.management.application.sync.AppBinaryProcessor.fillTasks", (String)"863", (Object)this);
                    if (this._resBundle != null) {
                        throw new AdminException(exception, AppUtils.getMessage(this._resBundle, "ADMA0055E", new Object[]{string}));
                    }
                    throw new AdminException(exception);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"fillTasks");
            }
        }

        private AbstractAppSyncTask getNextTask(Vector vector) throws AdminException {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getNextTask");
            }
            if (this.nextTaskNum >= vector.size()) {
                return null;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getNextTask");
            }
            return (AbstractAppSyncTask)vector.elementAt(this.nextTaskNum++);
        }
    }
}

